<?php
use CodeIgniter\Router\RouteCollection;
/*
 * @var RouteCollection $routes
 */
 
$routes->setAutoRoute(true);
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);

//$routes->set404Override('App\Controllers\Home::not_found');

/* 
Api routes
*/
$routes->get('/api/generate-token', 'Api::Token_generate');
 $routes->post('/api/register', 'Api::Register');
$routes->get('api/customers', 'Api::Customerlist');
$routes->get('api/customer', 'Api::Customerdetails');


$routes->post('/SetLanguage', 'Home::SetLanguage');

$routes->get('/imageRender/(:any)', 'RenderImage::index/$1');

$routes->get('/', 'Home::index');

$routes->post('/GetHomeSliders', 'Home::GetHomeSliders');
$routes->post('/GetCustomerReviews', 'Home::GetCustomerReviews');


$routes->post('/GetHomeCategories', 'Home::GetHomeCategories');
$routes->post('/GetHomeSection/(:any)', 'Home::GetHomeSection/$1');

$routes->post('/GetHomeLooseDiamonds', 'Home::GetHomeLooseDiamonds');
$routes->post('/GetHomeLooseGemstones', 'Home::GetHomeLooseGemstones');
$routes->post('/GetHomeNewArrivals', 'Home::GetHomeNewArrivals');
$routes->post('/GetHomeBanners', 'Home::GetHomeBanners');
$routes->post('/GetHomePartnerSlider', 'Home::GetHomePartnerSlider');

//my account
$routes->get('/my-account', 'Home::my_account');
$routes->get('/my-account/detail', 'Home::account_detail');
$routes->post('/my-account/detail', 'Home::account_detail_submit');


$routes->get('/admin/order/invoice/(:any)', 'Admin\Order::GenerateInvoice/$1');
$routes->get('/invoice/(:any)', 'Home::GenerateInvoice/$1');

// my account Loyalty Points
$routes->get('/my-account/loyalty-points', 'Home::loyalty_points');


$routes->get('/logout-receive', 'Home::logout_receive');
$routes->post('/logout-receive', 'Home::logout_receive');

$routes->get('/logout-send', 'Home::logout_send');
$routes->post('/logout-send', 'Home::logout_send');


// my account address
$routes->get('/my-account/address', 'Home::address');
$routes->get('/my-account/address/add', 'Home::add_address');
$routes->post('/my-account/address/add', 'Home::add_address_submit');

$routes->get('/my-account/address/edit/(:any)', 'Home::edit_address/$1');
$routes->post('/my-account/address/edit/(:any)', 'Home::edit_address_submit/$1');

$routes->post('/my-account/address/removeAddress', 'Home::address_remove');

$routes->get('/my-account/update-password', 'Home::update_password');
$routes->post('/my-account/update-password', 'Home::update_password_submit');

$routes->get('/book-an-appointment', 'Home::book_an_appointment');



$routes->get('/my-account/orders', 'Home::orders');
$routes->post('/Getorders', 'Home::Getorders');
$routes->post('/Getfailedorders', 'Home::Getfailedorders');

$routes->get('/payments', 'Home::payments');
$routes->post('/Getpayments', 'Home::Getpayments');
$routes->get('/ShowOrderDetail', 'Home::ShowOrderDetail');
$routes->post('/ShowOrderDetail', 'Home::ShowOrderDetail');
$routes->post('/GetMainorders', 'Home::GetMainorders');
$routes->post('/MoreOrderItems', 'Home::MoreOrderItems');
$routes->post('/ShowOrderItemReview', 'Home::ShowOrderItemReview');
$routes->post('/productReviewsubmit', 'Home::productReviewsubmit');

$routes->post('/ShowOrderReview', 'Home::ShowOrderReview');
$routes->post('/orderReviewsubmit', 'Home::orderReviewsubmit');
$routes->post('/return-product', 'Home::returnProduct');

$routes->get('/order-invoice', 'Home::orderInvoicePDF');

$routes->get('/profile', 'Home::profile');
$routes->get('/edit-profile', 'Home::edit_profile');
$routes->post('/edit-profile', 'Home::edit_profile');

$routes->get('/password', 'Home::password');
$routes->post('/password', 'Home::password');

$routes->get('/address', 'Home::address');
$routes->post('/address', 'Home::address');

$routes->post('/defualtAddress', 'Home::defualtAddress');
$routes->post('/deleteAddress', 'Home::deleteAddress');

$routes->get('/editAddress/(:any)', 'Home::editAddress/$1');
$routes->post('/editAddress/(:any)', 'Home::editAddress/$1');

$routes->get('/coupon', 'Home::coupon');

$routes->post('/GetRegion', 'Home::GetRegion');

$routes->post('/GetRelatedProducts', 'Home::GetRelatedProducts');
$routes->post('/GetLastProducts', 'Home::GetLastProducts');
$routes->post('/GetProductReviews', 'Home::GetProductReviews');

$routes->post('/SetNewsletterEmail', 'Home::SetNewsletterEmail');

$routes->post('/GetCartProducts', 'Home::GetCartProducts');

$routes->post('/GetShippingMethod', 'Home::GetShippingMethod');
$routes->post('/GetamountMaping', 'Home::GetamountMaping');

$routes->post('/Shippingcheckout', 'Home::Shippingcheckout');
$routes->post('/SetBillingAddress', 'Home::SetBillingAddress');


$routes->post('/viewshippingAddress', 'Home::viewshippingAddress');
$routes->post('/viewshippingmethod', 'Home::viewshippingmethod');
$routes->get('/success', 'Home::success');
$routes->get('/failed', 'Home::failed');
$routes->post('/success', 'Home::success');
$routes->post('/failed', 'Home::failed');

$routes->post('/paymentProcess', 'Home::paymentProcess');

$routes->post('/cardpayment', 'Stripe::payment');
$routes->post('/payment-verify', 'Stripe::payment_verify');
$routes->get('/payment-verify', 'Stripe::payment_verify');

$routes->get('/pay', 'Paypal::payment');


$routes->get('upload/(:any)', 'RenderImage::index/$1');          // Add this line.
$routes->post('upload/upload', 'RenderImage::upload'); // Add this line.

// design your jewelry
$routes->get('/design-your-own-jewelry/(:any)/(:any)', 'Home::design_jewelry/$1/$2');
$routes->get('/design-your-own-jewelry/(:any)/(:any)/(:any)', 'Home::design_jewelry/$1/$2/$2');
$routes->get('/design-your-own-jewelry/final-design', 'Home::final_design');

// design your jewelry
$routes->post('/getDesignProductDetails', 'Home::getDesignProductDetails');
$routes->post('/SetDesignSetting', 'Home::SetDesignSetting');
$routes->post('/SetDesignStone', 'Home::SetDesignSetting');
$routes->post('/CustomeDesignAddtoCart', 'Home::CustomeDesign_AddtoCart');





// login 

$routes->get('/google-auth', 'Home::google_auth');
$routes->post('/google-auth', 'Home::google_auth');

$routes->get('/login', 'Home::login');
$routes->post('/login', 'Home::login');
$routes->get('/forgot-password', 'Home::forgot_password');
$routes->post('/forgot-password', 'Home::forgot_password');
$routes->get('/reset-password/(:any)', 'Home::reset_password/$1');
$routes->post('/reset-password/(:any)', 'Home::reset_password/$1');


$routes->get('/logout', 'Home::logout');
$routes->get('/our-story', 'Home::our_story');


//register
$routes->get('/register', 'Home::register');

$routes->get('/register-verify/(:any)', 'Home::register_verify/$1');


$routes->post('/register_submit', 'Home::register_submit');



// Shop By Category 
$routes->post('/GetCategories', 'Home::GetCategories');
$routes->post('/GetShopProducts', 'Home::GetShopProducts');
$routes->post('/CategoryProductsAjax', 'Home::CategoryProductsAjax');

// category Products 
// $routes->get('/jewelry', 'Home::shop_products');
// $routes->get('/jewelry/(:any)', 'Home::shop_products/$1');
// $routes->get('/jewelry/(:any)/(:any)', 'Home::shop_products/$1/$2');

$routes->get('/search', 'Home::search');
$routes->post('/getSearchProducts', 'Home::getSearchProducts');





$routes->post('/ShopProductsAjax/(:any)', 'Home::ShopProductsAjax/$1');
$routes->post('/ShopProductsAjax/(:any)/(:any)', 'Home::ShopProductsAjax/$1/$2');
$routes->post('/ShopProductsAjax/(:any)/(:any)/(:any)', 'Home::ShopProductsAjax/$1/$2/$2');

$routes->post('/GetfeaturedProduct/(:any)', 'Home::GetfeaturedProduct/$1');



// book Appointment
$routes->post('/bookAppointment', 'Home::bookAppointment');
$routes->post('/bookAppointmentProduct', 'Home::bookAppointmentProduct');


$routes->post('/emailAssistance', 'Home::emailAssistance');


$routes->post('/AddWishlist', 'Home::AddWishlist');
$routes->post('/RemoveWishlist', 'Home::RemoveWishlist');
$routes->post('/WishlistCommetSave', 'Home::WishlistCommetSave');
$routes->post('/AddtoCart', 'Home::AddtoCart');
$routes->post('/removetoCart', 'Home::removetoCart');
$routes->post('/cartdetails', 'Home::cartdetails');
$routes->post('/productQty', 'Home::productQty');
$routes->post('/cartupdate', 'Home::cartupdate');
$routes->post('/wishlistdetails', 'Home::wishlistdetails');

$routes->post('/totalcart', 'Home::totalcart');
$routes->post('/totalwishlist', 'Home::totalwishlist');

// Contact 
$routes->get('/contact-us', 'Home::contact');

// Auction 
$routes->get('/auction', 'Home::auction');

// Auction details
$routes->get('/auction-details', 'Home::auction_detail');

// cart 
$routes->get('/cart', 'Home::cart');

// wishlist 
$routes->get('/wishlist', 'Home::wishlist');


// checkout
$routes->post('/checkLogin', 'Home::checkLogin');

// checkout
$routes->get('/checkout', 'Home::checkout');

//Admin Routes
$routes->get('/admin', 'Admin\Dashboard::index');
$routes->get('/admin/login', 'Admin\Dashboard::login');
$routes->post('/admin/login', 'Admin\Dashboard::login');

$routes->get('/admin/forgot-password', 'Admin\Dashboard::forgot_password');
$routes->post('/admin/forgot-password', 'Admin\Dashboard::forgot_password');

$routes->get('/admin/reset-password/(:any)', 'Admin\Dashboard::reset_password/$1');
$routes->post('/admin/reset-password/(:any)', 'Admin\Dashboard::reset_password/$1');

$routes->get('/admin/change-password', 'Admin\Dashboard::change_password');
$routes->get('/admin/profile', 'Admin\Dashboard::profile');


$routes->post('admin/order/getrecentorder', 'Admin\Order::Getrecentorders');
$routes->post('admin/reports/totalsalechart', 'Admin\Reports::totalSalechart');
$routes->post('admin/reports/totalorderchart', 'Admin\Reports::totalOrderchart');
$routes->post('admin/reports/allorderchart', 'Admin\Reports::allOrderchart');
$routes->post('admin/reports/totalproductchart', 'Admin\Reports::totalProductchart');
$routes->post('admin/reports/totalcustomerchart', 'Admin\Reports::totalCustomerchart');
$routes->post('admin/reports/totalreviewschart', 'Admin\Reports::totalReviewschart');
$routes->post('admin/reports/cardreports', 'Admin\Reports::cardreports');
// settings
$routes->get('/admin/web-settings', 'Admin\Content::organisation');
$routes->get('/admin/more-settings', 'Admin\Content::more_settings');




//customers
$routes->get('/admin/customers', 'Admin\User::customers');
$routes->get('/admin/customers/edit/(:any)', 'Admin\User::customers_edit/$1');
$routes->post('/admin/customers/update/(:any)', 'Admin\User::customers_update/$1');

//Users
$routes->get('/admin/user/role', 'Admin\User::role');

$routes->post('/admin/rolecreate', 'Admin\User::rolecreate');
$routes->post('/admin/getrole', 'Admin\User::getrole');

$routes->get('/admin/user/employee', 'Admin\User::employee');
$routes->post('admin/user/getemployee', 'Admin\User::getemployee');
$routes->post('admin/user/getstates', 'Admin\User::fetch_states');
$routes->get('/admin/user/addemployee', 'Admin\User::addemployee');
$routes->post('admin/user/createemployee', 'Admin\User::employeecreate');

$routes->get('/admin/user/editemployee/(:any)', 'Admin\User::editemployee/$1');
$routes->post('/admin/user/editemployee/(:any)', 'Admin\User::editemployee/$1');

$routes->get('/admin/user/permission/(:any)', 'Admin\User::permission/$1');
$routes->post('/admin/user/permission/(:any)', 'Admin\User::permission/$1');


// menus
$routes->get('/admin/menus', 'Admin\Content::menus');
$routes->get('/admin/add-menu', 'Admin\Content::add_menu');
$routes->get('/admin/edit-menu/(:any)', 'Admin\Content::edit_menu/$1');
$routes->post('/admin/SubmitMenu', 'Admin\Content::SubmitMenu');
$routes->post('/admin/UpdateMenu/(:any)', 'Admin\Content::UpdateMenu/$1');

$routes->post('/admin/GetTypeCategorySlug', 'Admin\Master::GetTypeCategorySlug');

// email parameters
$routes->get('/admin/email-parameters', 'Admin\More::email_parameters');
$routes->get('/admin/add-email-parameter', 'Admin\More::add_email_parameter');
$routes->get('/admin/edit-email-parameter/(:any)', 'Admin\More::edit_email_parameter/$1');

// email template
$routes->get('/admin/email-templates', 'Admin\More::email_templates');
$routes->get('/admin/add-email-template', 'Admin\More::add_email_template');
$routes->get('/admin/edit-email-template/(:any)', 'Admin\More::edit_email_template/$1');

// faq 
$routes->get('/admin/faq', 'Admin\Content::faq');
$routes->get('/admin/addfaq', 'Admin\Content::addfaq');
$routes->get('/admin/editfaq/(:any)', 'Admin\Content::editfaq/$1');


$routes->get('/faq', 'Home::faq');


// page 
$routes->get('/admin/page', 'Admin\Content::page');
$routes->get('/admin/addpage', 'Admin\Content::addpage');
$routes->get('/admin/editpage/(:any)', 'Admin\Content::editpage/$1');

// category banner 
$routes->get('/admin/category-banner', 'Admin\Content::categorybanner');
$routes->get('/admin/add-category-banner', 'Admin\Content::addcategorybanner');
$routes->get('/admin/edit-category-banner/(:any)', 'Admin\Content::editcategorybanner/$1');

// home banner 
$routes->get('/admin/home-slider', 'Admin\Content::homeslider');
$routes->get('/admin/add-home-slider', 'Admin\Content::addhomeslider');
$routes->get('/admin/edit-home-slider/(:any)', 'Admin\Content::edithomeslider/$1');

// home banner 
$routes->get('/admin/home-banner', 'Admin\Content::homebanner');
$routes->get('/admin/add-home-banner', 'Admin\Content::addhomebanner');
$routes->get('/admin/edit-home-banner/(:any)', 'Admin\Content::edithomebanner/$1');

// our story
$routes->get('/admin/our-story', 'Admin\Content::ourstory');
$routes->get('/admin/add-our-story', 'Admin\Content::addourstory');
$routes->get('/admin/edit-our-story/(:any)', 'Admin\Content::editourstory/$1');

// our team
$routes->get('/admin/our-team', 'Admin\Content::ourteam');
$routes->get('/admin/add-our-team', 'Admin\Content::addourteam');
$routes->get('/admin/edit-our-team/(:any)', 'Admin\Content::editourteam/$1');

// register banner
$routes->get('/admin/register-banner', 'Admin\Content::registerbanner');
$routes->get('/admin/add-register-banner', 'Admin\Content::addregisterbanner');
$routes->get('/admin/edit-register-banner/(:any)', 'Admin\Content::editregisterbanner/$1');


// online benefit
$routes->get('/admin/online-benefit', 'Admin\Content::onlinebenefit');
$routes->get('/admin/add-online-benefit', 'Admin\Content::addonlinebenefit');
$routes->get('/admin/edit-online-benefit/(:any)', 'Admin\Content::editonlinebenefit/$1');

//testimonial
$routes->get('/admin/testimonial', 'Admin\Content::testimonial');
$routes->get('/admin/add-testimonial', 'Admin\Content::addtestimonial');
$routes->get('/admin/edit-testimonial/(:any)', 'Admin\Content::edittestimonial/$1');

// our service
$routes->get('/admin/our-service', 'Admin\Content::ourservice');
$routes->get('/admin/add-our-service', 'Admin\Content::addourservice');
$routes->get('/admin/edit-our-service/(:any)', 'Admin\Content::editourservice/$1');

// footer Section
$routes->get('/admin/footer-section', 'Admin\Content::footersection');
$routes->post('/admin/addfootersection', 'Admin\Content::addfootersection');
$routes->post('/admin/removefootersection', 'Admin\Content::removefootersection');

// customlink
$routes->get('/admin/customlink', 'Admin\Content::customlink');
$routes->get('/admin/addcustomlink', 'Admin\Content::addcustomlink');
$routes->get('/admin/editcustomlink/(:any)', 'Admin\Content::editcustomlink/$1');

// coupon
$routes->get('/admin/coupon', 'Admin\Content::coupon');
$routes->get('/admin/addcoupon', 'Admin\Content::addcoupon');
$routes->get('/admin/editcoupon/(:any)', 'Admin\Content::editcoupon/$1');

$routes->get('/admin/book-an-appointment', 'Admin\Content::book_an_appointment');


// address
$routes->get('/admin/address', 'Admin\Content::address');
$routes->get('/admin/addaddress', 'Admin\Content::addaddress');
$routes->get('/admin/editaddress/(:any)', 'Admin\Content::editaddress/$1');

// warehouse
$routes->get('/admin/warehouse', 'Admin\Content::warehouse');
$routes->get('/admin/addwarehouse', 'Admin\Content::addwarehouse');
$routes->get('/admin/editwarehouse/(:any)', 'Admin\Content::editwarehouse/$1');

// shipper
$routes->get('/admin/shipper', 'Admin\Content::shipper');
$routes->get('/admin/addshipper', 'Admin\Content::addshipper');
$routes->get('/admin/editshipper/(:any)', 'Admin\Content::editshipper/$1');

// tax
$routes->get('/admin/tax', 'Admin\More::tax');
$routes->get('/admin/addtax', 'Admin\More::addtax');
$routes->get('/admin/edittax/(:any)', 'Admin\More::edittax/$1');

// clear cache

$routes->get('/admin/dashboard/clear-cache', 'Admin\Dashboard::clear_cache');


// newsletter setting
$routes->get('/admin/newsletter-setting', 'Admin\More::newslettersetting');

// shipping
$routes->get('/admin/shipping', 'Admin\More::shipping');
$routes->get('/admin/addshipping', 'Admin\More::addshipping');
$routes->get('/admin/editshipping/(:any)', 'Admin\More::editshipping/$1');


$routes->get('/admin/LoyaltyPoints', 'Admin\User::LoyaltyPoints');

// language
$routes->get('/admin/language', 'Admin\Content::language');
$routes->get('/admin/addlanguage', 'Admin\Content::addlanguage');
$routes->get('/admin/editlanguage/(:any)', 'Admin\Content::editlanguage/$1');

// order status
$routes->get('/admin/orderstatus', 'Admin\Content::orderstatus');
$routes->get('/admin/addorderstatus', 'Admin\Content::addorderstatus');
$routes->get('/admin/editorderstatus/(:any)', 'Admin\Content::editorderstatus/$1');


// shipping Company

$routes->get('/admin/shippingcompany', 'Admin\Content::shippingcompany');
$routes->get('/admin/addshippingcompany', 'Admin\Content::addshippingcompany');
$routes->get('/admin/editshippingcompany/(:any)', 'Admin\Content::editshippingcompany/$1');

// products admin
$routes->get('/admin/products', 'Admin\Master::products');
$routes->get('/admin/addproduct', 'Admin\Master::addproduct');
$routes->get('/admin/editproduct/(:any)', 'Admin\Master::editproduct/$1');



$routes->get('/admin/importjewelry', 'Admin\Import::importjewelry');
$routes->post('/admin/importjewelry', 'Admin\Import::importjewelry');
$routes->get('/admin/importtracking', 'Admin\Import::importtracking');
$routes->post('/admin/importtracking', 'Admin\Import::importtracking');




$routes->get('/admin/adddiamond', 'Admin\Master::adddiamond');
$routes->get('/admin/editdiamond/(:any)', 'Admin\Master::editdiamond/$1');

$routes->get('/admin/addgemstone', 'Admin\Master::addgemstone');
$routes->get('/admin/editgemstone/(:any)', 'Admin\Master::editgemstone/$1');

$routes->post('/admin/ProductMasterSubmit/(:any)', 'Admin\Master::ProductMasterSubmit/$1');
$routes->post('/admin/ProductfileUpload', 'Admin\Master::ProductfileUpload');
$routes->post('/admin/ProductthumbfileUpload', 'Admin\Master::ProductthumbfileUpload');

$routes->post('/admin/DeleteProductImage', 'Admin\Master::DeleteProductImage');
$routes->post('/admin/ProductStoneSubmit', 'Admin\Master::ProductStoneSubmit');
$routes->post('/admin/ProductVariationSubmit', 'Admin\Master::ProductVariationSubmit');
$routes->post('/admin/ProductFinalSubmit', 'Admin\Master::ProductFinalSubmit');
$routes->post('/admin/SoftDeleteProductImage', 'Admin\Master::SoftDeleteProductImage');
$routes->post('/admin/RestoreProductImage', 'Admin\Master::RestoreProductImage');
$routes->post('/admin/fullDeleteProductImage', 'Admin\Master::fullDeleteProductImage');
$routes->post('/admin/SoftDeleteProductStone', 'Admin\Master::SoftDeleteProductStone');
$routes->post('/admin/RestoreProductStone', 'Admin\Master::RestoreProductStone');
$routes->post('/admin/ProductStoneUpdate', 'Admin\Master::ProductStoneUpdate');

$routes->post('/admin/SoftDeleteProductVariation', 'Admin\Master::SoftDeleteProductVariation');
$routes->post('/admin/RestoreProductVariation', 'Admin\Master::RestoreProductVariation');
$routes->post('/admin/ProductVariationUpdate', 'Admin\Master::ProductVariationUpdate');
$routes->post('/admin/ProductFinalUpdate', 'Admin\Master::ProductFinalUpdate');

$routes->post('/admin/GetTypeCategory', 'Admin\Master::GetTypeCategory');

$routes->get('/admin/product-images', 'Admin\Master::bulkproductimages');
$routes->post('/admin/bulkproductimagesUpload', 'Admin\Master::bulkproductimagesUpload');
$routes->post('/adminreturn-product', 'Order::returnProduct');

// category
$routes->get('/admin/category', 'Admin\Master::category');
$routes->get('/admin/addcategory', 'Admin\Master::addcategory');
$routes->get('/admin/editcategory/(:any)', 'Admin\Master::editcategory/$1');

// occasion
$routes->get('/admin/occasion', 'Admin\Master::occasion');
$routes->get('/admin/addoccasion', 'Admin\Master::addoccasion');
$routes->get('/admin/editoccasion/(:any)', 'Admin\Master::editoccasion/$1');

// collection
$routes->get('/admin/collection', 'Admin\Master::collection');
$routes->get('/admin/addcollection', 'Admin\Master::addcollection');
$routes->get('/admin/editcollection/(:any)', 'Admin\Master::editcollection/$1');

// style
$routes->get('/admin/style', 'Admin\Master::style');
$routes->get('/admin/addstyle', 'Admin\Master::addstyle');
$routes->get('/admin/editstyle/(:any)', 'Admin\Master::editstyle/$1');

// stone
$routes->get('/admin/stone', 'Admin\Master::stone');
$routes->get('/admin/addstone', 'Admin\Master::addstone');
$routes->get('/admin/editstone/(:any)', 'Admin\Master::editstone/$1');

// color
$routes->get('/admin/color', 'Admin\Master::color');
$routes->get('/admin/addcolor', 'Admin\Master::addcolor');
$routes->get('/admin/editcolor/(:any)', 'Admin\Master::editcolor/$1');

// design
$routes->get('/admin/design', 'Admin\Master::design');
$routes->get('/admin/adddesign', 'Admin\Master::adddesign');
$routes->get('/admin/editdesign/(:any)', 'Admin\Master::editdesign/$1');

// metal
$routes->get('/admin/metal', 'Admin\Master::metal');
$routes->get('/admin/addmetal', 'Admin\Master::addmetal');
$routes->get('/admin/editmetal/(:any)', 'Admin\Master::editmetal/$1');

// lab
$routes->get('/admin/lab', 'Admin\Master::lab');
$routes->get('/admin/addlab', 'Admin\Master::addlab');
$routes->get('/admin/editlab/(:any)', 'Admin\Master::editlab/$1');

// shape
$routes->get('/admin/shape', 'Admin\Master::shape');
$routes->get('/admin/addshape', 'Admin\Master::addshape');
$routes->get('/admin/editshape/(:any)', 'Admin\Master::editshape/$1');

// stonetype
$routes->get('/admin/stonetype', 'Admin\Master::stonetype');
$routes->get('/admin/addstonetype', 'Admin\Master::addstonetype');
$routes->get('/admin/editstonetype/(:any)', 'Admin\Master::editstonetype/$1');

// type
$routes->get('/admin/type', 'Admin\Master::type');
$routes->get('/admin/addtype', 'Admin\Master::addtype');
$routes->get('/admin/edittype/(:any)', 'Admin\Master::edittype/$1');

// intensity
$routes->get('/admin/intensity', 'Admin\Master::intensity');
$routes->get('/admin/addintensity', 'Admin\Master::addintensity');
$routes->get('/admin/editintensity/(:any)', 'Admin\Master::editintensity/$1');


// overtone
$routes->get('/admin/overtone', 'Admin\Master::overtone');
$routes->get('/admin/addovertone', 'Admin\Master::addovertone');
$routes->get('/admin/editovertone/(:any)', 'Admin\Master::editovertone/$1');


// clarity
$routes->get('/admin/clarity', 'Admin\Master::clarity');
$routes->get('/admin/addclarity', 'Admin\Master::addclarity');
$routes->get('/admin/editclarity/(:any)', 'Admin\Master::editclarity/$1');

// gemtype
$routes->get('/admin/gemtype', 'Admin\Master::gemtype');
$routes->get('/admin/addgemtype', 'Admin\Master::addgemtype');
$routes->get('/admin/editgemtype/(:any)', 'Admin\Master::editgemtype/$1');

// origin
$routes->get('/admin/origin', 'Admin\Master::origin');
$routes->get('/admin/addorigin', 'Admin\Master::addorigin');
$routes->get('/admin/editorigin/(:any)', 'Admin\Master::editorigin/$1');

// treatment
$routes->get('/admin/treatment', 'Admin\Master::treatment');
$routes->get('/admin/addtreatment', 'Admin\Master::addtreatment');
$routes->get('/admin/edittreatment/(:any)', 'Admin\Master::edittreatment/$1');


// size
$routes->get('/admin/size', 'Admin\Master::size');
$routes->get('/admin/addsize', 'Admin\Master::addsize');
$routes->get('/admin/editsize/(:any)', 'Admin\Master::editsize/$1');

// stone-cut
$routes->get('/admin/stone-cut', 'Admin\Master::stonecut');
$routes->get('/admin/addstonecut', 'Admin\Master::addstonecut');
$routes->get('/admin/editstonecut/(:any)', 'Admin\Master::editstonecut/$1');

// stone-size
$routes->get('/admin/stone-size', 'Admin\Master::stonesize');
$routes->get('/admin/addstonesize', 'Admin\Master::addstonesize');
$routes->get('/admin/editstonesize/(:any)', 'Admin\Master::editstonesize/$1');

// Gender
$routes->get('/admin/gender', 'Admin\Master::gender');
$routes->get('/admin/addgender', 'Admin\Master::addgender');
$routes->get('/admin/editgender/(:any)', 'Admin\Master::editgender/$1');

// Store
$routes->get('/admin/store', 'Admin\Master::store');
$routes->get('/admin/addstore', 'Admin\Master::addstore');
$routes->get('/admin/editstore/(:any)', 'Admin\Master::editstore/$1');

// Age
$routes->get('/admin/age', 'Admin\Master::age');
$routes->get('/admin/addage', 'Admin\Master::addage');
$routes->get('/admin/editage/(:any)', 'Admin\Master::editage/$1');

// subscribers
$routes->get('/admin/subscribers', 'Admin\More::subscribers');

// appointments
$routes->get('/admin/appointments', 'Admin\More::appointments');

// web partners
$routes->get('/admin/webpartner', 'Admin\More::webpartner');
$routes->get('/admin/addwebpartner', 'Admin\More::addwebpartner');
$routes->get('/admin/editwebpartner/(:any)', 'Admin\More::editwebpartner/$1');

// follow us
$routes->get('/admin/followus', 'Admin\More::followus');
$routes->get('/admin/addfollowus', 'Admin\More::addfollowus');
$routes->get('/admin/editfollowus/(:any)', 'Admin\More::editfollowus/$1');

$routes->get('/admin/order', 'Admin\Order::index');
$routes->get('/admin/order/edit/(:any)', 'Admin\Order::edit/$1');

$routes->get('/admin/payments', 'Admin\Order::payments');
$routes->get('/admin/payment-view/(:any)', 'Admin\Order::payments_view/$1');
 
$routes->get('/admin/pending-order', 'Admin\Order::pending_order');
$routes->get('/admin/completed-order', 'Admin\Order::completed_order');
$routes->get('/admin/abadonded-order', 'Admin\Order::abadonded_order');
$routes->get('/admin/return-order', 'Admin\Order::return_order');
$routes->get('/admin/orders-reviews', 'Admin\Order::ordersreviews');
$routes->get('/admin/products-reviews', 'Admin\Order::productsreviews');

$routes->post('/admin/approvereturn', 'Admin\Order::returnProductapprove');

$routes->get('/admin/shipment', 'Admin\UpsController::index');
$routes->post('/admin/shipments', 'Admin\UpsController::GetShipments');
$routes->post('/admin/cancelUpsShipment', 'Admin\UpsController::cancelUpsShipment');
$routes->post('/admin/cancelUpsPickup', 'Admin\UpsController::cancelUpsPickup');



$routes->get('/admin/create-shipment', 'Admin\UpsController::createShipment');
$routes->get('/admin/create-shipment/(:any)', 'Admin\UpsController::createShipment/$1');
$routes->post('/admin/checkOrderExists', 'Admin\UpsController::checkOrderExists');
$routes->post('/admin/submit-shipment', 'Admin\UpsController::SubmitCreateShipment');
$routes->get('/admin/getShippers/(:any)', 'Admin\UpsController::getShippers/$1');

$routes->get('/admin/create-pickup/(:any)', 'Admin\UpsController::createPickup/$1');
$routes->post('/admin/submit-pickup', 'Admin\UpsController::createUpsPickup');


// Our Services
$routes->get('/admin/services', 'Admin\More::services');
$routes->get('/admin/addservices', 'Admin\More::addservices');
$routes->get('/admin/editservice/(:any)', 'Admin\More::editservice/$1');


// Product 
$routes->get('/product/(:any)/(:any)', 'Home::product/$1/$2');


$routes->get('/admin/reports/orderReports', 'Admin\Reports::orderReports');

$routes->get('/admin/reports/customerReports', 'Admin\Reports::customerReports');

$routes->get('/admin/reports/paymentReports', 'Admin\Reports::paymentReports');




// $CI = \Config\Database::connect();
//     $uri = service('uri');
//     $sLast = $uri->getSegment(1);
//  if($sLast)
//  {
//      $uri=$sLast;
//      $result =  $CI->table('pages_management')
//                   ->select('page_slug')
//                   ->where('page_slug', $uri)
//             	   ->get()->getRowArray();
     
//      if($result)
//      {
//      $routes->get("/".$result['page_slug'], 'Home::page');     
//      }
//  }
 


$routes->get('/admin/logout', 'Admin\Dashboard::logout');

$routes->get('/not-found', 'Home::not_found');

$routes->get('(:any)', 'Home::shop/$1');

$routes->post('/GetShopProducts', 'Home::GetShopProducts');
$routes->post('/GetProductData', 'Home::GetProductData');
$routes->post('/shopProductSettings', 'Home::shopProductSettings');
$routes->post('/shopProductFilters', 'Home::shopProductFilters');

$routes->post('/GetProductSizeVariation', 'Home::GetProductSizeVariation');
$routes->post('/GetProductvariationdetail', 'Home::GetProductvariationdetail');





