<?php
namespace App\Controllers\Admin;
use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
use App\Models\ApiModel;
use App\Controllers\BaseController;
class Api extends ResourceController
{
    use ResponseTrait;

    public function __construct(){
      
        $this->ApiModel = new ApiModel();  
        $this->apiURL = 'https://jeweal.tiarasoftwares.com/';
    }


public function Token_generate(){
    // Instance
         $apilink = $this->apiURL.'Login?username=naren&mailid=naren%40tiarasoftwares.com&appid=tiara_bkk_12072019_1_0_TCA&password="123456"';
        $client = \Config\Services::curlrequest();
    
        /* $postData = array(
            'username' => "naren",
            'appid' => "tiara_bkk_12072019_1_0_TCA",
            'mailid' => "naren@tiarasoftwares.com",
        );
        */
         // Send request
        $response = $client->get($apilink,['debug' => true]);
         
       // Read response
        $code = $response->getStatusCode();
        $reason = $response->getReason();
        if($code == 200){ // Success

            // Read data 
            $body = json_decode($response->getBody());
            return $body->data->token;
        }else{
            echo "failed";
            die;
        }
    
}
public function GetCountry()
{
    // Instance
         $apilink = $this->apiURL.'GetCountry';
        $client = \Config\Services::curlrequest();
    
         // Send request
        $response = $client->get($apilink,['debug' => true]);
         
       // Read response
        $code = $response->getStatusCode();
        $reason = $response->getReason();
        if($code == 200){ // Success

            // Read data 
            $body = json_decode($response->getBody());
            return $body->data->token;
        }else{
            echo "failed";
            die;
        }
}
public function Productdetails($stockId){
    // Instance
        $token=$this->Token_generate();
        $apilink = $this->apiURL.'Productdetails?stockid='.$stockId;
        $client = \Config\Services::curlrequest();
            
            // Header data
            $headerData = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'Authorization' => 'Bearer '.$token
            );

            $response = $client->post($apilink,[
                'debug' => true,
                'headers'=> $headerData,
            ]);
        
       // Read response
        $code = $response->getStatusCode();
        $reason = $response->getReason();
        if($code == 200){ // Success

            // Read data 
            $body = $response->getBody();
            $datas=json_decode($body);
            if($datas->message=='Success')
            {
                 return $datas->data;
                 die;
            }
            else
            {
                return "failed";
                    die;
            }
        }else{
           return "failed";
            die;
        }
        
    
}


    public function Productcategory()
    {
        
        $token=$this->Token_generate();
       
        $apilink = $this->apiURL.'Productcategory';
        $client = \Config\Services::curlrequest();
    
        $postData = array(
                "page" => 0,
                "count" => 0,
                "item" => [],
                "family" => [],
                "style" => [],
                "metal" => [],
                "size" => [],
                "collection" => [],
                "stone" => [],
                "orderby" => 0,
                "pricefrom" => "",
                "priceto" => "",
            );
        
         // Header data
    $headerData = array(
        'Content-Type' => 'application/json',
        'Accept' => 'application/json',
        'Authorization' => 'Bearer '.$token
    );
       
          $response = $client->post($apilink,[
        'debug' => true,
        'headers'=>$headerData,
        'json' => $postData
    ]);
    
    
         // Read response
    $code = $response->getStatusCode();
    $reason = $response->getReason();
           
         if($code == 200){ // Success

            // Read data 
            $body = json_decode($response->getBody());
            print_r($body);
           
        }else{
            echo "failed";
            die;
        }
    }
    
    public function getCategoryProducts()
    {
            $categoryid=$this->request->getVar('categoryid');
            $category= $this->ApiModel->getcategoryID($categoryid);
            if(isset($category))
            {
                $categoryName=unserialize($category['name']);
                $limit=$this->request->getVar('limit');
                $data=array(
                    'categoryid'=>$categoryid,
                    'categoryname'=>$categoryName,
                    'limit'=>$limit,
                    'status'=>201
                    );
               // echo json_encode($data);
                
                 return $this->respond($data,200);
            }
            else
            {
                 $data=array(
                    'status'=>'error'
                    );
                //echo json_encode($data);
                
                 return $this->failNotFound($data);
            }
    }

    public function getCategory()
    {
            $category= $this->ApiModel->getcategory();
            if(isset($category))
            {
                $categorydata=array();
                foreach($category as $row)
                {
                    $categoryName=unserialize($row['name']);
                    $data=array(
                        'categoryid'=>$row['categoryid'],
                        'categoryname'=>$categoryName,
                        'categoryslug'=>$row['slug']
                        );
                    $categorydata[]= $data;
                }
               
               // echo json_encode($data);
                
                 return $this->respond($categorydata,200);
            }
            else
            {
                 $data=array(
                    'status'=>'error'
                    );
                //echo json_encode($data);
                
                 return $this->failNotFound($data);
            }
    }

}