<?php
namespace App\Controllers\Admin;
use App\Models\ContentModel;
use App\Models\MasterModel;
use App\Controllers\BaseController;
use App\Controllers\Api;
class Content extends BaseController
{
    public function __construct(){
        $this->Api = new Api();
        $this->ContentModel = new ContentModel(); 
        $this->MasterModel = new MasterModel();
        $this->session = \Config\Services::session();
    }
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    public function lang_slug($unserializeName)
    {
       
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
            
        }
    }
    public function organisation()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['web_setting'] = $this->ContentModel->web_setting();
        $data['page']='organisation';
        return view('Admin/admin_index',$data);
    }
    
    public function organisation_update()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('logo')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads', $newName);

                         // File path to display preview
                         $filepath = "/public/uploads/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
        else
        {
            $filepath='';
        }
        
        if($file = $this->request->getFile('icon')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads', $newName);

                         // File path to display preview
                         $fileicon = "/public/uploads/".$newName;
                    }
                    else
                    {
                        $fileicon='';
                    }
         }  
        else
        {
            $fileicon='';
        }
        
        if($file = $this->request->getFile('login_banner')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads', $newName);

                         // File path to display preview
                         $filepath_login_banner = "/public/uploads/".$newName;
                    }
                    else
                    {
                        $filepath_login_banner='';
                    }
         }  
        else
        {
            $filepath_login_banner='';
        }

        $company_title = $this->request->getVar('company_title');
        $company_tagline = $this->request->getVar('company_tagline');
        $email = $this->request->getVar('email');
        $phone = $this->request->getVar('phone');
        $telephone = $this->request->getVar('company_telephone');
        $fax = $this->request->getVar('company_fax');
        $url = $this->request->getVar('url');
        $address1 = $this->request->getVar('address1');
        $address2 = $this->request->getVar('address2');
        $zipcode = $this->request->getVar('zipcode');
        $country_id = $this->request->getVar('country');
        $state_id = $this->request->getVar('state');
        $country = countryname($country_id);
        $region = regionname($state_id);
        
        $city = $this->request->getVar('city');
        
        $logo_view = $this->request->getVar('logo_view');
        $about_tax = $this->request->getVar('about_tax');
        $meta_title = $this->request->getVar('meta_title');
        $meta_keyword = $this->request->getVar('meta_keyword');
        $meta_description = $this->request->getVar('meta_description');

        $data=array(
            'company_title'=>$company_title,
            'tagline'=>$company_tagline,
            'comapny_email'=>$email,
            'c_no'=>$phone,
            'telephone'=>$telephone,
            'fax'=>$fax,
            'url'=>$url,
            'address1'=>$address1,
            'address2'=>$address2,
            'zipcode'=>$zipcode,
            'country'=>$country,
            'provision_state'=>$region,
            'country_id'=>$country_id,
            'provision_state_id'=>$state_id,
            'city'=>$city,
            'logo_view'=>$logo_view,
            'about_tax'=>$about_tax,
            'meta_title'=>$meta_title,
            'meta_keyword'=>$meta_keyword,
            'meta_description'=>$meta_description,
            );
        if($filepath!='')
        {
            $data['logo']=$filepath;
        }
        if($fileicon!='')
        {
            $data['icon']=$fileicon;
        }
        
        if($filepath_login_banner!='')
        {
            $data['login_banner']=$filepath_login_banner;
        }
        
        
        
        $this->ContentModel->organisation_update($data); 
        return redirect()->to('/admin/web-settings'); 
    }
    
    public function more_settings()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['more_setting'] = $this->ContentModel->more_settings();
        $data['page']='more_settings';
        return view('Admin/admin_index',$data);
    }
    
    public function more_setting_update()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $setting_key   = $this->request->getVar('setting_key');
        $setting_value = $this->request->getVar('setting_value');
        foreach($setting_key as $index=>$key)
        {
            $value=$setting_value[$index];
            if($key!='' && $value!='')
            {
                $this->ContentModel->update_more_settings($key,$value);
            }
        }
        return redirect()->to('/admin/more-settings'); 
    }
	
    // language
    public function language()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='language';
        return view('Admin/admin_index',$data);
    }
    
    public function addlanguage()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addlanguage';
        return view('Admin/admin_index',$data);
    }
    
    public function insert_language()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $filepath='';
        if($file = $this->request->getFile('country_flag')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/country_flag/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/country_flag/".$newName;
                    }
                    
         }  
         
        $language = $this->request->getVar('language');
        $code = $this->request->getVar('code');
        $sort_order = $this->request->getVar('sort_order');

        $data=array(
            'language'=>$language,
            'country_flag'=>$filepath,
            'code'=>$code,
            'sequence'=>$sort_order,
            );
        
        $this->ContentModel->insert_language($data); 
        return redirect()->to('/admin/language'); 
    }
    
    public function editlanguage($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $language= $this->ContentModel->getlanguageID($i);

        if(isset($language))
        {
            $data['language']  = $language;
            $data['page'] ='editlanguage';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/language');  
        }
        
    }
    
    public function update_language($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language = $this->request->getVar('language');
        $code = $this->request->getVar('code');
        $sort_order = $this->request->getVar('sort_order');
        
        $filepath='';
        if($file = $this->request->getFile('country_flag')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/country_flag/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/country_flag/".$newName;
                    }
                    
         } 

        $data=array(
            'language'=>$language,
            'code'=>$code,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['country_flag']=$filepath;
        }
        $this->ContentModel->update_language($data,$id); 
        return redirect()->to('/admin/language');
    }
    
    
    
    public function getlanguage()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();

       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('language')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('language')
                                ->select('id')
                                ->orLike('language', $searchValue)
                                ->orLike('code', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('language')
            ->select('*')
            ->orLike('language', $searchValue)
            ->orLike('code', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
               $status.='<div class="square-switch">';
               $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
               $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
               $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editlanguage/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               $language='<img src="'.base_url().$record['country_flag'].'" style="width: 24px;    height: 24px;"> '.$record['language'];
          $data[] = array( 
             "id"=>$i,
             "language"=>$language,
             "code"=>$record['code'],
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    
    public function languagestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_language_status($status,$id); 
    }
    
    public function languagedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->language_delete($id);  
    }
    // faq details
    public function faq()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['faq'] = $this->ContentModel->getfaq();
        $data['page']='faq';
        return view('Admin/admin_index',$data);
    }
    
    public function addfaq()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['faq'] = $this->ContentModel->getfaq();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addfaq';
        return view('Admin/admin_index',$data);
    }
    
    public function insert_faq()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $faq_title = $this->request->getVar('faq_title');
        $faq_details = $this->request->getVar('faq_details');
        $sort_order = $this->request->getVar('sort_order');
        $lang = $this->request->getVar('lang');
        
        $data=array(
            'Faq_title'=>$faq_title,
            'Faq_Detail'=>$faq_details,
            'sequence'=>$sort_order,
            'language'=>$lang,
            );
        
        $this->ContentModel->insert_faq($data); 
        return redirect()->to('/admin/faq'); 
    }
    
    public function editfaq($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $faq= $this->ContentModel->getfaqID($i);

        if(isset($faq))
        {
            $data['faq']  = $faq;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['page'] ='editfaq';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/faq');  
        }
        
    }
    
    public function update_faq($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $faq_title = $this->request->getVar('faq_title');
        $faq_details = $this->request->getVar('faq_details');
        $sort_order = $this->request->getVar('sort_order');
        $lang = $this->request->getVar('lang');
        
        $data=array(
            'Faq_title'=>$faq_title,
            'Faq_Detail'=>$faq_details,
            'sequence'=>$sort_order,
            'language'=>$lang,
            );
        
        $this->ContentModel->update_faq($data,$id); 
        return redirect()->to('/admin/faq');
    }
    
    public function getfaq()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('faq')
                     ->select('Id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('faq')
                                ->select('Id')
                                ->orLike('Faq_title', $searchValue)
                                ->orLike('Faq_Detail', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('faq')
            ->select('*')
            ->orLike('Faq_title', $searchValue)
            ->orLike('Faq_Detail', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['Id'].'" id="square-switch'.$record['Id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['Id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editfaq/'.$record['Id'].'" data-id="'.$record['Id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['Id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "Id"=>$i,
             "Faq_title"=>$record['Faq_title'],
             "Faq_Detail"=>$record['Faq_Detail'],
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "language"=>$record['language'],
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    
    public function faqstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_faq_status($status,$id); 
             
    }
    
    public function faqdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->faq_delete($id);  
    }
    
    public function fetch_states() 
    {
        $countryID = $this->request->getVar('id');
        $states = $this->ContentModel->fetch_states($countryID);
        //echo $this->db->getLastQuery();
        $options='';
        if($states)
        {
	        foreach($states as $row)
	        {
	           $options.='<option value="'.$row->name.'">'.$row->name.'</option>';
	        }
	           $data=array('status'=>'1','rows'=>$options,'msg'=>'States Found');
	   }
	   else
	   {
	           $data=array('status'=>'0','rows'=>$options,'msg'=>'States Not Found');
	   }
	    echo  json_encode($data);
    }
    
    // page details
    public function page()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getpage();
        $data['page']='page';
        return view('Admin/admin_index',$data);
    }
    public function addpage()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getpage();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addpage';
        return view('Admin/admin_index',$data);
    }
    
    public function insert_page()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $page_name = $this->request->getVar('page_name');
        $page_slug = $this->request->getVar('page_slug');
        $page_heading = $this->request->getVar('page_heading');
        $page_description = $this->request->getVar('page_description');
        $meta_title = $this->request->getVar('meta_title');
        $meta_keyword = $this->request->getVar('meta_keyword');
        $meta_description = $this->request->getVar('meta_description');
        $sort_order = $this->request->getVar('sort_order');
        $lang = $this->request->getVar('lang');
        
        if($file = $this->request->getFile('page_banner')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/page_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/page_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $data=array(
            'page_name'=>$page_name,
            'page_slug'=>slugify($page_slug),
            'page_heading'=>$page_heading,
            'page_banner'=>$filepath,
            'page_description'=>$page_description,
            'meta_title'=>$meta_title,
            'meta_keyword'=>$meta_keyword,
            'meta_description'=>$meta_description,
            'page_sort'=>$sort_order,
            'language'=>$lang,
            );
            
        if($this->request->getVar('set_at_footer_bootom'))
        {
            $data['set_at_footer_bootom']=$this->request->getVar('set_at_footer_bootom');
        }
        else
        {
            $data['set_at_footer_bootom']='no';
        }    
        
        $this->ContentModel->insert_page($data); 
        return redirect()->to('/admin/page'); 
    }
    
    public function editpage($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $page= $this->ContentModel->getpageID($i);

        if(isset($page))
        {
            $data['pagedata']  = $page;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['page'] ='editpage';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/page');  
        }
        
    }
    
    public function update_page($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $page_name = $this->request->getVar('page_name');
        $page_slug = $this->request->getVar('page_slug');
        $page_heading = $this->request->getVar('page_heading');
        $page_description = $this->request->getVar('page_description');
        $meta_title = $this->request->getVar('meta_title');
        $meta_keyword = $this->request->getVar('meta_keyword');
        $meta_description = $this->request->getVar('meta_description');
        $sort_order = $this->request->getVar('sort_order');
        $lang = $this->request->getVar('lang');
        
        if($file = $this->request->getFile('page_banner')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/page_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/page_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $data=array(
            'page_name'=>$page_name,
            'page_slug'=>slugify($page_slug),
            'page_heading'=>$page_heading,
            'page_description'=>$page_description,
            'meta_title'=>$meta_title,
            'meta_keyword'=>$meta_keyword,
            'meta_description'=>$meta_description,
            'page_sort'=>$sort_order,
            'language'=>$lang,
            );
        if($filepath!='')
        {
            $data['page_banner']=$filepath;
        }
        if($this->request->getVar('set_at_footer_bootom'))
        {
            $data['set_at_footer_bootom']=$this->request->getVar('set_at_footer_bootom');
        }
        else
        {
            $data['set_at_footer_bootom']='no';
        }
        
        $this->ContentModel->update_page($data,$id); 
        return redirect()->to('/admin/page');
    }
    
    
    public function getpage()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('pages_management')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('pages_management')
                                ->select('id')
                                ->orLike('page_name', $searchValue)
                                ->orLike('page_heading', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('pages_management')
            ->select('*')
            ->orLike('page_name', $searchValue)
            ->orLike('page_heading', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           $status='';
           if($record['page_status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editpage/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['page_created_on']));
               
          $data[] = array( 
             "id"=>$i,
             "page_title"=>$record['page_name'],
             "page_hedding"=>$record['page_heading'],
             "footer_show"=>$record['set_at_footer_bootom'],
             "sequence"=>$record['page_sort'],
             "Status"=>$status,
             "date"=>$date,
             "language"=>$record['language'],
             "action"=>$action,

          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    
    public function pagestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_page_status($status,$id); 
    }
    public function pagedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->ContentModel->page_delete($id);  
    }
    
    public function categorybanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getcategorybanner();
        $data['page']='categorybanner';
        return view('Admin/admin_index',$data);
    }
    public function addcategorybanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getcategorybanner();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addcategorybanner';
        return view('Admin/admin_index',$data);
    }
    public function insert_categorybanner()
    {
       
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/home_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/home_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $link_textlanguage_arr = $this->request->getVar('link_text_language');
        $link_text_arr = $this->request->getVar('link_text');
        $serialized_link_text=$this->lang_serialize($link_textlanguage_arr,$link_text_arr);
        
        $banner_type = $this->request->getVar('banner_type');
        $view_banner_category = $this->request->getVar('view_banner_category');
        $target_banner_category = $this->request->getVar('target_banner_category');
        $banner_page = $this->request->getVar('banner_page');
        $custom_link = $this->request->getVar('custom_link');
        $data=array(
            'banner_type'=>$banner_type,
            'banner_title'=>$serialized_banner_title,
            'button_text'=>$serialized_link_text,
            'banner_image'=>$filepath,
            'view_category'=>$view_banner_category,
            'target_category'=>$target_banner_category,
            'view_page'=>$banner_page,
            'custom_link'=>$custom_link
            );
        if($banner_page=='category')
        {
            $categorybanner=$this->ContentModel->Addcheck_categorypagebanner($banner_type,$view_banner_category,$banner_page); 
        }
        else
        {
            $categorybanner=$this->ContentModel->Addcheck_categorybanner($banner_type,$banner_page); 
        }
        if(!$categorybanner)
        {
            $this->ContentModel->insert_categorybanner($data); 
            return redirect()->to('/admin/category-banner'); 
        }
        else
        {
            $this->session->set('admin_error','This Category Banner already exists.');
            return redirect()->to('admin/add-category-banner');
        }
        
        
     
    }
    
    public function editcategorybanner($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $categorybanner= $this->ContentModel->getcategorybannerID($i);

        if(isset($categorybanner))
        {
            $data['categorybanner']  = $categorybanner;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editcategorybanner';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/category-banner');  
        }
        
    }
    
    public function update_categorybanner($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/category_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/category_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $link_textlanguage_arr = $this->request->getVar('link_text_language');
        $link_text_arr = $this->request->getVar('link_text');
        $serialized_link_text=$this->lang_serialize($link_textlanguage_arr,$link_text_arr);
        
        $banner_type = $this->request->getVar('banner_type');
        $view_banner_category = $this->request->getVar('view_banner_category');
        $target_banner_category = $this->request->getVar('target_banner_category');
        $banner_page = $this->request->getVar('banner_page');
        $custom_link = $this->request->getVar('custom_link');
        
        $data=array(
            'banner_type'=>$banner_type,
            'banner_title'=>$serialized_banner_title,
            'button_text'=>$serialized_link_text,
            'view_category'=>$view_banner_category,
            'target_category'=>$target_banner_category,
            'view_page'=>$banner_page,
            'custom_link'=>$custom_link
            );
            
        if($filepath!='')
        {
           $data['banner_image'] = $filepath;
        }
        if($banner_page=='category')
        {
            $categorybanner=$this->ContentModel->check_categorypagebanner($banner_type,$view_banner_category,$banner_page,$id); 
        }
        else
        {
            $categorybanner=$this->ContentModel->check_categorybanner($banner_type,$banner_page,$id); 
        }
        if(!$categorybanner)
        {
            $this->ContentModel->update_categorybanner($data,$id); 
            return redirect()->to('/admin/category-banner');
        }
        else
        {
            $this->session->set('admin_error','This Category Banner already exists.');
            return redirect()->to('admin/edit-category-banner/'.$id);
        }
        
    }
    
    public function getcategorybanner()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('categorybanner')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('categorybanner')
                                ->select('id')
                                ->orLike('banner_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('categorybanner')
            ->select('*')
            ->orLike('banner_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           $image='<img src="'.base_url().$record['banner_image'].'" class="table-img">';
           $BannerTitle=unserialize($record['banner_title'])['en'];
           $BannerText=unserialize($record['button_text'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-category-banner/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               $Category=$this->ContentModel->GetCategoriesSlug($record['view_category']);
               if(isset($Category))
               {
               $ViewCategory_Name=unserialize($Category['name'])['en'];
               }
               else
               {
                  $ViewCategory_Name='None'; 
               }
               $Category=$this->ContentModel->GetCategoriesSlug($record['target_category']);
               if(isset($Category))
               {
               $TargetCategory_Name=unserialize($Category['name'])['en'];
               }
               else
               {
                   $TargetCategory_Name='None';
               }
               
          $data[] = array( 
             "id"=>$i,
             "BannerImage"=>$image,
             "BannerTitle"=>$BannerText,
             "BannerType"=>$record['banner_type'],
             "ViewCategory"=>$ViewCategory_Name,
             "ViewPage"=>$record['view_page'],
             "TargetCategory"=>$TargetCategory_Name,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function categorybannerstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_categorybanner_status($status,$id); 
    }
    public function categorybannerdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->categorybanner_delete($id);  
    }
    
    public function ourstory()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getourstory();
        $data['page']='ourstory';
        return view('Admin/admin_index',$data);
    }
    public function addourstory()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getourstory();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addourstory';
        return view('Admin/admin_index',$data);
    }
    public function insert_ourstory()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/ourstory_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/ourstory_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $banner_desclanguage_arr = $this->request->getVar('banner_desc_language');
        $banner_desc_arr = $this->request->getVar('banner_desc');
        $serialized_banner_desc=$this->lang_serialize($banner_desclanguage_arr,$banner_desc_arr);
        
        $banner_section = $this->request->getVar('banner_section');

        $data=array(
            'banner_section'=>$banner_section,
            'banner_title'=>$serialized_banner_title,
            'banner_desc'=>$serialized_banner_desc,
            'banner_image'=>$filepath
            );
        
        $this->ContentModel->insert_ourstory($data); 
        return redirect()->to('/admin/our-story'); 
     
    }
    
    public function editourstory($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $ourstory= $this->ContentModel->getourstoryID($i);

        if(isset($ourstory))
        {
            $data['ourstory']  = $ourstory;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editourstory';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/our-story');  
        }
        
    }
    
    public function update_ourstory($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/ourstory_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/ourstory_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $banner_desclanguage_arr = $this->request->getVar('banner_desc_language');
        $banner_desc_arr = $this->request->getVar('banner_desc');
        $serialized_banner_desc=$this->lang_serialize($banner_desclanguage_arr,$banner_desc_arr);
        
        $banner_section = $this->request->getVar('banner_section');
    
        $data=array(
            'banner_section'=>$banner_section,
            'banner_title'=>$serialized_banner_title,
            'banner_desc'=>$serialized_banner_desc,
            );
        if($filepath!='')
        {
           $data['banner_image'] = $filepath;
        }
        $this->ContentModel->update_ourstory($data,$id); 
        return redirect()->to('/admin/our-story');
    }
    
    public function getourstory()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('ourstory')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('ourstory')
                                ->select('id')
                                ->orLike('banner_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('ourstory')
            ->select('*')
            ->orLike('banner_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           if($record['banner_image']!='')
           {
                $image='<img src="'.base_url().$record['banner_image'].'" class="table-img">';
           }
           else
           {
                $image='';  
           }
           $BannerTitle=unserialize($record['banner_title'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-our-story/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               
               
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Title"=>$BannerTitle,
             "Section"=>'Section '.$record['banner_section'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function ourstorystatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_ourstory_status($status,$id); 
    }
    public function ourstorydelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->ourstory_delete($id);  
    }
    
    public function footersection()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $data=[];
        $data['pages'] = $this->ContentModel->getpages();
        $data['customlinks'] = $this->ContentModel->getcustomlinks();
        $data['footersection'] = $this->ContentModel->getfootersection();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='footersection';
        return view('Admin/admin_index',$data);
    }
    public function addfootersection()
    {
        $section=$this->request->getVar('section');
        $type=$this->request->getVar('type');
        $id=$this->request->getVar('id');
         $data=array(
            'type'=>$type,
            'section'=>$section,
            'pageid'=>$id,
            );
        
        $this->ContentModel->addfootersectiontemp($data); 
        return true;
    }
    
  
    
    public function removefootersection()
    {
        $section=$this->request->getVar('section');
        $type=$this->request->getVar('type');
        $id=$this->request->getVar('id');
         $data=array(
            'type'=>$type,
            'section'=>$section,
            'pageid'=>$id,
            );
        
        $this->ContentModel->removefootersectiontemp($data); 
        return true;
    }
    
    
    public function update_footerSection()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $this->ContentModel->emptyfootersection(); 
        $footersection=$this->ContentModel->getfootersectiontemp();

        if(isset($footersection))
        {
            foreach($footersection as $row)
            {
                $data=array(
                    'type'=>$row['type'],
                    'section'=>$row['section'],
                    'pageid'=>$row['pageid'],
                    );
                
                $this->ContentModel->addfootersection($data);
            }
        }
        return redirect()->to('/admin/footer-section');
        
    }
    
    public function addcustomlink()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Category";
        $data['customlinks'] = $this->ContentModel->getcustomlink();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addcustomlink';
        return view('Admin/admin_index',$data);
    }
    public function insert_customlink()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('link_text_language');
        $link_text_arr = $this->request->getVar('link_text');
        $link = $this->request->getVar('link');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$link_text_arr);
        
        $data=array(
            'name'=>$serialized_name,
            'link'=>$link,
            'sequence'=>$sort_order,
            );
        
        $this->ContentModel->insert_customlink($data); 
        return redirect()->to('/admin/customlink');
    }
    
    public function editcustomlink($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $customlink= $this->ContentModel->getcustomlinkID($i);

        if(isset($customlink))
        {
            $data['title']="Add Custom link";
            $data['language'] = $this->ContentModel->getlanguage();
            $data['customlinks'] = $this->ContentModel->getcustomlink();
            $data['customlink']  = $customlink;
            $data['page'] ='editcustomlink';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/customlink');  
        }
    }
    
    public function update_customlink($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('link_text_language');
        $link_text_arr = $this->request->getVar('link_text');
        $link = $this->request->getVar('link');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$link_text_arr);
        
        $data=array(
            'name'=>$serialized_name,
            'link'=>$link,
            'sequence'=>$sort_order,
            );
        
        $this->ContentModel->update_customlink($data,$id); 
        return redirect()->to('/admin/customlink');
    }
    
    public function customlink()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['customlink'] = $this->ContentModel->getcustomlink();
        $data['page']='customlink';
        return view('Admin/admin_index',$data);
    }
    public function getcustomlink()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('customlink')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('customlink')
                                ->select('id')
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('customlink')
            ->select('*')
            ->Like('name', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $linktext_name=unserialize($record['name']);
           $linktext=$linktext_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editcustomlink/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "LinkText"=>$linktext,
             "Link"=>$record['link'],
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function customlinkstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_customlink_status($status,$id); 
             
    }
    
    public function customlinkdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->customlink_delete($id);  
    }
    
    
    
    

     public function ourservice()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getourservice();
        $data['page']='ourservice';
        return view('Admin/admin_index',$data);
    }
    public function addourservice()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getourservice();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addourservice';
        return view('Admin/admin_index',$data);
    }
    public function insert_ourservice()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('service_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/ourservice/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/ourservice/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $service_titlelanguage_arr = $this->request->getVar('service_title_language');
        $service_title_arr = $this->request->getVar('service_title');
        $serialized_service_title=$this->lang_serialize($service_titlelanguage_arr,$service_title_arr);
        
        $service_desclanguage_arr = $this->request->getVar('service_desc_language');
        $service_desc_arr = $this->request->getVar('service_desc');
        $serialized_service_desc=$this->lang_serialize($service_desclanguage_arr,$service_desc_arr);
        

        $data=array(
            'service_title'=>$serialized_service_title,
            'service_desc'=>$serialized_service_desc,
            'service_image'=>$filepath
            );
        
        $this->ContentModel->insert_ourservice($data); 
        return redirect()->to('/admin/our-service'); 
     
    }
    
    public function editourservice($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $ourservice= $this->ContentModel->getourserviceID($i);

        if(isset($ourservice))
        {
            $data['ourservice']  = $ourservice;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editourservice';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/our-service');  
        }
        
    }
    
    public function update_ourservice($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('service_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/ourservice/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/ourservice/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $service_titlelanguage_arr = $this->request->getVar('service_title_language');
        $service_title_arr = $this->request->getVar('service_title');
        $serialized_service_title=$this->lang_serialize($service_titlelanguage_arr,$service_title_arr);
        
        $service_desclanguage_arr = $this->request->getVar('service_desc_language');
        $service_desc_arr = $this->request->getVar('service_desc');
        $serialized_service_desc=$this->lang_serialize($service_desclanguage_arr,$service_desc_arr);
        

        $data=array(
            'service_title'=>$serialized_service_title,
            'service_desc'=>$serialized_service_desc,
            );
        if($filepath!='')
        {
           $data['service_image'] = $filepath;
        }
        $this->ContentModel->update_ourservice($data,$id); 
        return redirect()->to('/admin/our-service');
    }
    
    public function getourservice()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('ourservice')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('ourservice')
                                ->select('id')
                                ->orLike('service_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('ourservice')
            ->select('*')
            ->orLike('service_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           if($record['service_image']!='')
           {
                $image='<img src="'.base_url().$record['service_image'].'" class="table-img">';
           }
           else
           {
                $image='';  
           }
           $BannerTitle=unserialize($record['service_title'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-our-service/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               
               
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Title"=>$BannerTitle,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function ourservicestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_ourservice_status($status,$id); 
    }
    public function ourservicedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->ourservice_delete($id);  
    }
    
    
    public function ourteam()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getourteam();
        $data['page']='ourteam';
        return view('Admin/admin_index',$data);
    }
    public function addourteam()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getourteam();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addourteam';
        return view('Admin/admin_index',$data);
    }
    public function insert_ourteam()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('team_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/ourteam_team/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/ourteam_team/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $team_titlelanguage_arr = $this->request->getVar('team_title_language');
        $team_title_arr = $this->request->getVar('team_title');
        $serialized_team_title=$this->lang_serialize($team_titlelanguage_arr,$team_title_arr);
        
        $team_desclanguage_arr = $this->request->getVar('team_desc_language');
        $team_desc_arr = $this->request->getVar('team_desc');
        $serialized_team_desc=$this->lang_serialize($team_desclanguage_arr,$team_desc_arr);
        

        $data=array(
            'team_title'=>$serialized_team_title,
            'team_desc'=>$serialized_team_desc,
            'team_image'=>$filepath
            );
        
        $this->ContentModel->insert_ourteam($data); 
        return redirect()->to('/admin/our-team'); 
     
    }
    
    public function editourteam($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $ourteam= $this->ContentModel->getourteamID($i);

        if(isset($ourteam))
        {
            $data['ourteam']  = $ourteam;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editourteam';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/our-team');  
        }
        
    }
    
    public function update_ourteam($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('team_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/ourteam_team/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/ourteam_team/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $team_titlelanguage_arr = $this->request->getVar('team_title_language');
        $team_title_arr = $this->request->getVar('team_title');
        $serialized_team_title=$this->lang_serialize($team_titlelanguage_arr,$team_title_arr);
        
        $team_desclanguage_arr = $this->request->getVar('team_desc_language');
        $team_desc_arr = $this->request->getVar('team_desc');
        $serialized_team_desc=$this->lang_serialize($team_desclanguage_arr,$team_desc_arr);
        

        $data=array(
            'team_title'=>$serialized_team_title,
            'team_desc'=>$serialized_team_desc,
            );
        if($filepath!='')
        {
           $data['team_image'] = $filepath;
        }
        $this->ContentModel->update_ourteam($data,$id); 
        return redirect()->to('/admin/our-team');
    }
    
    public function getourteam()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('ourteam')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('ourteam')
                                ->select('id')
                                ->orLike('team_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('ourteam')
            ->select('*')
            ->orLike('team_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           if($record['team_image']!='')
           {
                $image='<img src="'.base_url().$record['team_image'].'" class="table-img">';
           }
           else
           {
                $image='';  
           }
           $BannerTitle=unserialize($record['team_title'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-our-team/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               
               
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Title"=>$BannerTitle,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function ourteamstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_ourteam_status($status,$id); 
    }
    public function ourteamdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->ourteam_delete($id);  
    }
    
    
    //testimonials
    
    
    public function testimonial()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->gettestimonial();
        $data['page']='testimonial';
        return view('Admin/admin_index',$data);
    }
    public function addtestimonial()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->gettestimonial();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addtestimonial';
        return view('Admin/admin_index',$data);
    }
    public function insert_testimonial()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/testimonial/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/testimonial/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $namelanguage_arr = $this->request->getVar('name_language');
        $name_arr = $this->request->getVar('name');
        $serialized_name=$this->lang_serialize($namelanguage_arr,$name_arr);
        
        $desclanguage_arr = $this->request->getVar('desc_language');
        $desc_arr = $this->request->getVar('desc');
        $serialized_desc=$this->lang_serialize($desclanguage_arr,$desc_arr);
        

        $data=array(
            'name'=>$serialized_name,
            'desc'=>$serialized_desc,
            'image'=>$filepath
            );
        
        $this->ContentModel->insert_testimonial($data); 
        return redirect()->to('/admin/testimonial'); 
     
    }
    
    public function edittestimonial($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $testimonial= $this->ContentModel->gettestimonialID($i);

        if(isset($testimonial))
        {
            $data['testimonial']  = $testimonial;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='edittestimonial';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/testimonial');  
        }
        
    }
    
    public function update_testimonial($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/testimonial/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/testimonial/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $namelanguage_arr = $this->request->getVar('name_language');
        $name_arr = $this->request->getVar('name');
        $serialized_name=$this->lang_serialize($namelanguage_arr,$name_arr);
        
        $desclanguage_arr = $this->request->getVar('desc_language');
        $desc_arr = $this->request->getVar('desc');
        $serialized_desc=$this->lang_serialize($desclanguage_arr,$desc_arr);
        

        $data=array(
            'name'=>$serialized_name,
            'desc'=>$serialized_desc,
            );
        if($filepath!='')
        {
           $data['image'] = $filepath;
        }
        $this->ContentModel->update_testimonial($data,$id); 
        return redirect()->to('/admin/testimonial');
    }
    
    public function gettestimonial()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('testimonial')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('testimonial')
                                ->select('id')
                                ->orLike('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('testimonial')
            ->select('*')
            ->orLike('name', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           if($record['image']!='')
           {
                $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           }
           else
           {
                $image='';  
           }
           $name=unserialize($record['name'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-testimonial/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               
               
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Name"=>$name,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function testimonialstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_testimonial_status($status,$id); 
    }
    public function testimonialdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->testimonial_delete($id);  
    }
    
    //coupon
    
    
    public function coupon()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getcoupon();
        $data['page']='coupon';
        return view('Admin/admin_index',$data);
    }
    public function addcoupon()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['customerlist'] =$this->ContentModel->customersDetail();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addcoupon';
        return view('Admin/admin_index',$data);
    }
    public function insert_coupon()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $coupon = $this->request->getVar('coupon');
        $coupon_details = $this->request->getVar('coupon_details');
        $datefilter = $this->request->getVar('datefilter');
        $coupon_type = $this->request->getVar('coupon_type');
        $discount = $this->request->getVar('discount');
        $totalUseCoupon = $this->request->getVar('totalUseCoupon');
        $coustomerUseCoupon = $this->request->getVar('coustomerUseCoupon');
        $coustomers = implode(",",$this->request->getVar('customers'));

        $data=array(
            'coupon'=>$coupon,
            'coupon_deatils'=>$coupon_details,
            'coupon_date'=>$datefilter,
            'coupon_type'=>$coupon_type,
            'discount'=>$discount,
            'uses_per_coupon'=>$totalUseCoupon,
            'uses_per_customer'=>$coustomerUseCoupon,
            'customers'=>$coustomers,
            );
        
        $this->ContentModel->insert_coupon($data); 
        return redirect()->to('/admin/coupon'); 
     
    }
    
    public function editcoupon($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $coupon= $this->ContentModel->getcouponID($i);

        if(isset($coupon))
        {
            $data['coupon']  = $coupon;
            $data['customerlist'] =$this->ContentModel->customersDetail();
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editcoupon';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/coupon');  
        }
        
    }
    
    public function update_coupon($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $coupon = $this->request->getVar('coupon');
        $datefilter = $this->request->getVar('datefilter');
        $coupon_type = $this->request->getVar('coupon_type');
        $discount = $this->request->getVar('discount');
        $totalUseCoupon = $this->request->getVar('totalUseCoupon');
        $coustomerUseCoupon = $this->request->getVar('coustomerUseCoupon');
        $coustomers = implode(",",$this->request->getVar('customers'));
        $coupon_details = $this->request->getVar('coupon_details');

        $data=array(
            'coupon'=>$coupon,
            'coupon_deatils'=>$coupon_details,
            'coupon_date'=>$datefilter,
            'coupon_type'=>$coupon_type,
            'discount'=>$discount,
            'uses_per_coupon'=>$totalUseCoupon,
            'uses_per_customer'=>$coustomerUseCoupon,
            'customers'=>$coustomers,
            );
        
        $this->ContentModel->update_coupon($data,$id); 
        return redirect()->to('/admin/coupon');
    }
    
    public function getcoupon()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('coupon')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('coupon')
                                ->select('id')
                                ->orLike('coupon', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('coupon')
            ->select('*')
            ->orLike('coupon', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editcoupon/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['created_date']));
               
             $couponDateArr=explode("-",$record['coupon_date']);  
               $couponStartDate=date("d-m-Y",strtotime($couponDateArr[0]));
               $couponEndDate=date("d-m-Y",strtotime($couponDateArr[1]));
               
          $data[] = array( 
             "id"=>$i,
             "coupon"=>$record['coupon'],
             "coupon_date"=>$couponStartDate." - ".$couponEndDate,
             "coupon_type"=>$record['coupon_type'],
             "discount"=>$record['discount'],
             "uses_per_coupon"=>$record['uses_per_coupon'],
             "uses_per_customer"=>$record['uses_per_customer'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function couponstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_coupon_status($status,$id); 
    }
    
    public function coupondelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->ContentModel->coupon_delete($id);  
    }
    
    // online benefit
    
    public function onlinebenefit()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getonlinebenefit();
        $data['page']='onlinebenefit';
        return view('Admin/admin_index',$data);
    }
    public function addonlinebenefit()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getonlinebenefit();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addonlinebenefit';
        return view('Admin/admin_index',$data);
    }
    public function insert_onlinebenefit()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('onlinebenefit_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/onlinebenefit/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/onlinebenefit/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $onlinebenefit_titlelanguage_arr = $this->request->getVar('onlinebenefit_title_language');
        $onlinebenefit_title_arr = $this->request->getVar('onlinebenefit_title');
        $serialized_onlinebenefit_title=$this->lang_serialize($onlinebenefit_titlelanguage_arr,$onlinebenefit_title_arr);
        

        $data=array(
            'onlinebenefit_title'=>$serialized_onlinebenefit_title,
            'onlinebenefit_image'=>$filepath
            );
        
        $this->ContentModel->insert_onlinebenefit($data); 
        return redirect()->to('/admin/online-benefit'); 
     
    }
    
    public function editonlinebenefit($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $onlinebenefit= $this->ContentModel->getonlinebenefitID($i);

        if(isset($onlinebenefit))
        {
            $data['onlinebenefit']  = $onlinebenefit;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editonlinebenefit';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/online-benefit');  
        }
        
    }
    
    public function update_onlinebenefit($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('onlinebenefit_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/onlinebenefit/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/onlinebenefit/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $onlinebenefit_titlelanguage_arr = $this->request->getVar('onlinebenefit_title_language');
        $onlinebenefit_title_arr = $this->request->getVar('onlinebenefit_title');
        $serialized_onlinebenefit_title=$this->lang_serialize($onlinebenefit_titlelanguage_arr,$onlinebenefit_title_arr);

        $data=array(
            'onlinebenefit_title'=>$serialized_onlinebenefit_title,
            );
        if($filepath!='')
        {
           $data['onlinebenefit_image'] = $filepath;
        }
        $this->ContentModel->update_onlinebenefit($data,$id); 
        return redirect()->to('/admin/online-benefit');
    }
    
    public function getonlinebenefit()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('onlinebenefit')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('onlinebenefit')
                                ->select('id')
                                ->orLike('onlinebenefit_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('onlinebenefit')
            ->select('*')
            ->orLike('onlinebenefit_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           if($record['onlinebenefit_image']!='')
           {
                $image='<img src="'.base_url().$record['onlinebenefit_image'].'" class="table-img">';
           }
           else
           {
                $image='';  
           }
           $BannerTitle=unserialize($record['onlinebenefit_title'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-online-benefit/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               
               
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Title"=>$BannerTitle,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function onlinebenefitstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_onlinebenefit_status($status,$id); 
    }
    public function onlinebenefitdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->onlinebenefit_delete($id);  
    }
    
    
    //address
    
    
    public function address()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getaddress();
        $data['page']='address';
        return view('Admin/admin_index',$data);
    }
    public function addaddress()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addaddress';
        return view('Admin/admin_index',$data);
    }
    public function insert_address()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
         $title = $this->request->getVar('title');
        $phone = $this->request->getVar('phone');
        $phonecode = $this->request->getVar('phonecode');
        $phone2 = $this->request->getVar('phone2');
        $phonecode2 = $this->request->getVar('phonecode2');
        $email = $this->request->getVar('email');
        $fax = $this->request->getVar('fax');
        $add1 = $this->request->getVar('add1');
        $add2 = $this->request->getVar('add2');
        $countryId = $this->request->getVar('country');
        $country = countryname($countryId);
        $regionId = $this->request->getVar('region');
        $region = regionname($regionId);
        $city = $this->request->getVar('city');
        $zipcode = $this->request->getVar('zipcode');
        $map = $this->request->getVar('map');
        
        $data=array(
            'title'=>$title,
            'phone'=>$phone,
            'phonecode'=>$phonecode,
            'phone2'=>$phone2,
            'phonecode2'=>$phonecode2,
            'email'=>$email,
            'fax'=>$fax,
            'add1'=>$add1,
            'add2'=>$add2,
            'countryId'=>$countryId,
            'country'=>$country,
            'regionId'=>$regionId,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zipcode,
            'map'=>$map,
            );
        
        $this->ContentModel->insert_address($data); 
        return redirect()->to('/admin/address'); 
     
    }
    
    public function editaddress($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $address= $this->ContentModel->getaddressID($i);

        if(isset($address))
        {
            $data['address']  = $address;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['page'] ='editaddress';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/address');  
        }
        
    }
    
    public function update_address($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $title = $this->request->getVar('title');
        $phone = $this->request->getVar('phone');
        $phonecode = $this->request->getVar('phonecode');
        $phone2 = $this->request->getVar('phone2');
        $phonecode2 = $this->request->getVar('phonecode2');
        $email = $this->request->getVar('email');
        $fax = $this->request->getVar('fax');
        $add1 = $this->request->getVar('add1');
        $add2 = $this->request->getVar('add2');
        $countryId = $this->request->getVar('country');
        $country = countryname($countryId);
        $regionId = $this->request->getVar('region');
        $region = regionname($regionId);
        $city = $this->request->getVar('city');
        $zipcode = $this->request->getVar('zipcode');
        $map = $this->request->getVar('map');
        
        $data=array(
            'title'=>$title,
            'phone'=>$phone,
            'phonecode'=>$phonecode,
            'phone2'=>$phone2,
            'phonecode2'=>$phonecode2,
            'email'=>$email,
            'fax'=>$fax,
            'add1'=>$add1,
            'add2'=>$add2,
            'countryId'=>$countryId,
            'country'=>$country,
            'regionId'=>$regionId,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zipcode,
            'map'=>$map,
            );
        
        $this->ContentModel->update_address($data,$id); 
        return redirect()->to('/admin/address');
    }
    
    public function getaddress()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('officeaddress')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('officeaddress')
                                ->select('id')
                                ->orLike('add1', $searchValue)
                                ->orLike('add2', $searchValue)
                                ->orLike('city', $searchValue)
                                ->orLike('region', $searchValue)
                                ->orLike('country', $searchValue)
                                ->orLike('email', $searchValue)
                                ->orLike('phone', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('officeaddress')
            ->select('*')
            ->orLike('add1', $searchValue)
            ->orLike('add2', $searchValue)
            ->orLike('city', $searchValue)
            ->orLike('region', $searchValue)
            ->orLike('country', $searchValue)
            ->orLike('email', $searchValue)
            ->orLike('phone', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
         $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editaddress/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['createDate']));

               
          $data[] = array( 
             "id"=>$i,
             "address"=>$record['add1']."<br>".$record['add2'],
             "Region"=>$record['region'],
             "Country"=>$record['country'],
             "Zipcode"=>$record['zipcode'],
            //  "Email"=>$record['email'],
            //  "Phone"=>"+".$record['phonecode'].$record['phone'],
             "date"=>$date,
             "status"=>$status,
             "action"=>$action,
          ); 
         
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function addressstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_address_status($status,$id); 
    }
    
    public function addressdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->ContentModel->address_delete($id);  
    }
    

    
    
    public function add_menu()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getAllPages();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['color'] = $this->MasterModel->getcolor();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['occasion'] = $this->MasterModel->getoccasion();
         $data['style'] = $this->MasterModel->getstyle();
        $data['menus'] = $this->ContentModel->getmenus();
        $data['topmenus'] = $this->ContentModel->gettopmenus();

        $data['page']='addmenu';
        return view('Admin/admin_index',$data);
    }
    public function edit_menu($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $data=[];
        $data['pages'] = $this->ContentModel->getAllPages();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['color'] = $this->MasterModel->getcolor();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['occasion'] = $this->MasterModel->getoccasion();
         $data['style'] = $this->MasterModel->getstyle();
        $data['menus'] = $this->ContentModel->getmenus();
        $data['menu'] = $this->ContentModel->getmenu($id);
        $data['topmenus'] = $this->ContentModel->gettopmenus();
        $data['page']='editmenu';
        return view('Admin/admin_index',$data);
    }
    
    public function SubmitMenu()
    {
        if(!isset($this->session->admin))
        {
           $response=array('status'=>true,'message'=>'Something Wrong.');
            echo json_encode($response);
            return ; 
        }
        $serialized_menu_title='';
        $menu_titleanguage_arr = $this->request->getVar('menu_title_language');
        $menu_title_arr = $this->request->getVar('menu_title');
        $serialized_menu_title=$this->lang_serialize($menu_titleanguage_arr,$menu_title_arr);
        $parent_menu=$this->request->getVar('parent_menu');
        $description=$this->request->getVar('description');
        $megamenu=$this->request->getVar('megamenu');
        $menu_head=$this->request->getVar('menu_head');
        $menu_sort=$this->request->getVar('menu_sort');
        $menu_highlight=$this->request->getVar('menu_highlight');
        
        
        if($this->request->getVar('menu_slug'))
        {
            if($this->request->getVar('menu_slug')!='javascript:void(0)')
            {
                $menu_slug=slugify($this->request->getVar('menu_slug'));
            }
            else
            {
                $menu_slug=$this->request->getVar('menu_slug');
            }
        }
        else
        {
            $menu_slug="javascript:void(0)";
        }
        
        if($this->request->getVar('menu-type'))
        {
            $menutype=$this->request->getVar('menu-type');
        }
        else
        {
            $menutype="";
        }
        
        if($this->request->getVar('all-product'))
        {
            $allproduct=$this->request->getVar('all-product');
        }
        else
        {
            $allproduct="";
        }
        
        if($this->request->getVar('category'))
        {
            $category=$this->request->getVar('category');
        }
        else
        {
            $category="";
        }
        if($this->request->getVar('category_type'))
        {
            $categorytype=$this->request->getVar('category_type');
        }
        else
        {
            $categorytype="";
        }
        if($this->request->getVar('color'))
        {
            $color=$this->request->getVar('color');
        }
        else
        {
            $color="";
        }
        if($this->request->getVar('gemtype'))
        {
            $gemtype=$this->request->getVar('gemtype');
        }
        else
        {
            $gemtype="";
        }
        if($this->request->getVar('stone'))
        {
            $stone=$this->request->getVar('stone');
        }
        else
        {
            $stone="";
        }
        
        if($this->request->getVar('stonetype'))
        {
            $stonetype=$this->request->getVar('stonetype');
        }
        else
        {
            $stonetype="";
        }
        if($this->request->getVar('collection'))
        {
            $collection=$this->request->getVar('collection');
        }
        else
        {
            $collection="";
        }
        if($this->request->getVar('occasion'))
        {
            $occasion=$this->request->getVar('occasion');
        }
        else
        {
            $occasion="";
        }
          if($this->request->getVar('style'))
        {
            $style=$this->request->getVar('style');
        }
        else
        {
            $style="";
        }
        if($this->request->getVar('page'))
        {
            $page=$this->request->getVar('page');
        }
        else
        {
            $page="";
        }
       
        
        $data=array(
            'menu_title'=>$serialized_menu_title,
            'parent_menu'=>$parent_menu,
            'megamenu'=>$megamenu,
            'menu_slug'=>$menu_slug,
            'menu-type'=>$menutype,
            'all-product'=>$allproduct,
            'category'=>$category,
            'category-type'=>$categorytype,
            'color'=>$color,
            'gemtype'=>$gemtype,
            'stone'=>$stone,
            'stonetype'=>$stonetype,
            'collection'=>$collection,
            'occasion'=>$occasion,
            'style'=>$style,
            'page'=>$page,
            'menu_head'=>$menu_head,
            'menu_highlight'=>$menu_highlight,
            'menu_sort'=>$menu_sort,
            'description'=>$description
            );
            
        if($file = $this->request->getFile('menu_image')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/menu/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/menu/".$newName;
                         $data['image']=$filepath;
                    }
         } 
        if($file = $this->request->getFile('title_image')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/menu/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/menu/".$newName;
                         $data['title_image']=$filepath;
                    }
         }
         
         
        if($menu_slug!="javascript:void(0)")
        {
            $checkMenuSlug=$this->ContentModel->checkMenuSlug($menu_slug,$parent_menu);
            if(isset($checkMenuSlug))
            {
                $response=array('status'=>false,'message'=>'Menu slug Already Exist.');
                echo json_encode($response);
                return ; 
            }
        }
    
       
        $menus=$this->ContentModel->insert_menu($data); 
        if($menus)
        {
            $response=array('status'=>true,'message'=>'Menu Successfully Add.');
            echo json_encode($response);
            return ; 
        }
        else
        {
            $response=array('status'=>true,'message'=>'Something Wrong.');
            echo json_encode($response);
            return ; 
        }
    }
    
    public function UpdateMenu($id)
    {
        if(!isset($this->session->admin))
        {
           $response=array('status'=>true,'message'=>'Something Wrong.');
            echo json_encode($response);
            return ; 
        }
        $serialized_menu_title='';
        $menu_titleanguage_arr = $this->request->getVar('menu_title_language');
        $menu_title_arr = $this->request->getVar('menu_title');
        $serialized_menu_title=$this->lang_serialize($menu_titleanguage_arr,$menu_title_arr);
        $parent_menu=$this->request->getVar('parent_menu');
        $megamenu=$this->request->getVar('megamenu');
        $menu_head=$this->request->getVar('menu_head');
        $menu_sort=$this->request->getVar('menu_sort');
        $menu_highlight=$this->request->getVar('menu_highlight');
        $description=$this->request->getVar('description');
        
        if($this->request->getVar('menu_slug'))
        {
            if($this->request->getVar('menu_slug')!='javascript:void(0)')
            {
                $menu_slug=slugify($this->request->getVar('menu_slug'));
            }
            else
            {
                $menu_slug=$this->request->getVar('menu_slug');
            }
        }
        else
        {
            $menu_slug="javascript:void(0)";
        }
        if($this->request->getVar('menu-type'))
        {
            $menutype=$this->request->getVar('menu-type');
        }
        else
        {
            $menutype="";
        }
        if($this->request->getVar('all-product'))
        {
            $allproduct=$this->request->getVar('all-product');
        }
        else
        {
            $allproduct="";
        }
        
        
        if($this->request->getVar('category'))
        {
            $category=$this->request->getVar('category');
        }
        else
        {
            $category="";
        }
        if($this->request->getVar('category_type'))
        {
            $categorytype=$this->request->getVar('category_type');
        }
        else
        {
            $categorytype="";
        }
        if($this->request->getVar('color'))
        {
            $color=$this->request->getVar('color');
        }
        else
        {
            $color="";
        }
        if($this->request->getVar('gemtype'))
        {
            $gemtype=$this->request->getVar('gemtype');
        }
        else
        {
            $gemtype="";
        }
        if($this->request->getVar('stone'))
        {
            $stone=$this->request->getVar('stone');
        }
        else
        {
            $stone="";
        }
        
        if($this->request->getVar('stonetype'))
        {
            $stonetype=$this->request->getVar('stonetype');
        }
        else
        {
            $stonetype="";
        }
        if($this->request->getVar('collection'))
        {
            $collection=$this->request->getVar('collection');
        }
        else
        {
            $collection="";
        }
        if($this->request->getVar('occasion'))
        {
            $occasion=$this->request->getVar('occasion');
        }
        else
        {
            $occasion="";
        }
        
         if($this->request->getVar('style'))
        {
            $style=$this->request->getVar('style');
        }
        else
        {
            $style="";
        }
        if($this->request->getVar('page'))
        {
            $page=$this->request->getVar('page');
        }
        else
        {
            $page="";
        }
        
        $data=array(
            'menu_title'=>$serialized_menu_title,
            'parent_menu'=>$parent_menu,
            'megamenu'=>$megamenu,
            'menu_slug'=>$menu_slug,
            'menu-type'=>$menutype,
            'all-product'=>$allproduct,
            'category'=>$category,
            'category-type'=>$categorytype,
            'color'=>$color,
            'gemtype'=>$gemtype,
            'stone'=>$stone,
            'stonetype'=>$stonetype,
            'collection'=>$collection,
            'occasion'=>$occasion,
            'style'=>$style,
            'page'=>$page,
            'menu_head'=>$menu_head,
            'menu_highlight'=>$menu_highlight,
            'menu_sort'=>$menu_sort,
            'description'=>trim($description)
            );
        if($file = $this->request->getFile('menu_image')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/menu/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/menu/".$newName;
                         $data['image']=$filepath;
                    }
         }
         
         if($file = $this->request->getFile('title_image')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/menu/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/menu/".$newName;
                         $data['title_image']=$filepath;
                    }
         }
             
            
        if($menu_slug!="javascript:void(0)")
        {
            $checkMenuSlug=$this->ContentModel->checkMenuSlugId($menu_slug,$id,$parent_menu);
            if(isset($checkMenuSlug))
            {
                $response=array('status'=>false,'message'=>'Menu slug Already Exist.');
                echo json_encode($response);
                return ; 
            }
        }

        $menus=$this->ContentModel->update_menu($data,$id); 
        if($menus)
        {
            $response=array('status'=>true,'message'=>'Menu Successfully update.');
            echo json_encode($response);
            return ; 
        }
        else
        {
            $response=array('status'=>true,'message'=>'Something Wrong.');
            echo json_encode($response);
            return ; 
        }
        
     
    }
    
    public function menus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='menus';
        return view('Admin/admin_index',$data);
    }
    
    public function getmenu()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('menus')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('menus')
                                ->select('id')
                                ->Like('menu_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('menus')
            ->select('*')
            ->Like('menu_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           $menutitle=unserialize($record['menu_title']);
           $menutitle=$menutitle['en'];
         $status='';
           if($record['status']=='1')
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-menu/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['createdate']));
            
            if($record['menu_slug']=='javascript:void(0)')
            {
                $menu_slug='-';
            }
            else
            {
                 $menu_slug=$record['menu_slug'];
            }
            if(!empty($record['menu-type']))
            {
                $menutype=$record['menu-type'];
            }
            else
            {
                $menutype='-';
            }
            
            if($record['parent_menu']=='0')
            {
                $parentmenuTitle='None';
            }
            else
            {   $parentMenuArr=array();
                $parentmenuId=$record['parent_menu'];
                for ($x = 0; $x < 5; $x++) 
                {
                  $parentmenu=$this->ContentModel->getmenu($parentmenuId); 
                  if($parentmenu)
                  {
                      $parentmenuId=$parentmenu['parent_menu'];
                      $parentMenutitle=unserialize($parentmenu['menu_title']);
                      $parentMenuArr[]=$parentMenutitle['en'];
                      if($parentmenuId=='0')
                      {
                          break;
                      }
                  }
                  else
                  {
                      break;
                  }
                  
                }
                $parentMenuArr=array_reverse($parentMenuArr);
                $parentmenuTitle=implode(" > ",$parentMenuArr);
                
            }
            
               
          $data[] = array( 
             "id"=>$i,
             "menu_title"=>ucwords(strtolower($menutitle)),
             "parent_menu"=>ucwords(strtolower($parentmenuTitle)),
             "menu_slug"=>$menu_slug,
             "menu-type"=>ucwords(strtolower($menutype)),
             "menu_sort"=>$record['menu_sort'],
             "status"=>$status,
             "action"=>$action,
          ); 
          
          
         
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    
    public function menustatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_menu_status($status,$id); 
             
    }
    
    public function menudelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->ContentModel->menu_delete($id);  
    }
    
    //slider
    
    public function homeslider()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->gethomeslider();
        $data['page']='homeslider';
        return view('Admin/admin_index',$data);
    }
    public function addhomeslider()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->gethomeslider();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addhomeslider';
        return view('Admin/admin_index',$data);
    }
    public function insert_homeslider()
    {
       
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('slider_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/home_slider/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/home_slider/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $slider_titlelanguage_arr = $this->request->getVar('slider_title_language');
        $slider_title_arr = $this->request->getVar('slider_title');
        $serialized_slider_title=$this->lang_serialize($slider_titlelanguage_arr,$slider_title_arr);
        
        $button1_textlanguage_arr = $this->request->getVar('button1_text_language');
        $button1_text_arr = $this->request->getVar('button1_text');
        $serialized_button1_text=$this->lang_serialize($button1_textlanguage_arr,$button1_text_arr);
        
        $button2_textlanguage_arr = $this->request->getVar('button2_text_language');
        $button2_text_arr = $this->request->getVar('button2_text');
        $serialized_button2_text=$this->lang_serialize($button2_textlanguage_arr,$button2_text_arr);
        
        $slider_desclanguage_arr = $this->request->getVar('slider_desc_language');
        $slider_desc_arr = $this->request->getVar('slider_desc');
        $serialized_slider_desc=$this->lang_serialize($slider_desclanguage_arr,$slider_desc_arr);
        
        $button1_link = $this->request->getVar('button1_link');
        $button2_link = $this->request->getVar('button2_link');

        $data=array(
            'slider_title'=>$serialized_slider_title,
            'button1_text'=>$serialized_button1_text,
            'button2_text'=>$serialized_button2_text,
            'slider_desc'=>$serialized_slider_desc,
            'button1_link'=>$button1_link,
            'button2_link'=>$button2_link,
            );
        if($filepath!='')
        {
           $data['slider_image'] = $filepath;
        }
        $this->ContentModel->insert_homeslider($data); 
        return redirect()->to('/admin/home-slider'); 
     
    }
    
    public function edithomeslider($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $homeslider= $this->ContentModel->gethomesliderID($i);

        if(isset($homeslider))
        {
            $data['homeslider']  = $homeslider;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='edithomeslider';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/home-slider');  
        }
        
    }
    
    public function update_homeslider($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('slider_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/home_slider/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/home_slider/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $slider_titlelanguage_arr = $this->request->getVar('slider_title_language');
        $slider_title_arr = $this->request->getVar('slider_title');
        $serialized_slider_title=$this->lang_serialize($slider_titlelanguage_arr,$slider_title_arr);
        
        $button1_textlanguage_arr = $this->request->getVar('button1_text_language');
        $button1_text_arr = $this->request->getVar('button1_text');
        $serialized_button1_text=$this->lang_serialize($button1_textlanguage_arr,$button1_text_arr);
        
        $button2_textlanguage_arr = $this->request->getVar('button2_text_language');
        $button2_text_arr = $this->request->getVar('button2_text');
        $serialized_button2_text=$this->lang_serialize($button2_textlanguage_arr,$button2_text_arr);
        
        $slider_desclanguage_arr = $this->request->getVar('slider_desc_language');
        $slider_desc_arr = $this->request->getVar('slider_desc');
        $serialized_slider_desc=$this->lang_serialize($slider_desclanguage_arr,$slider_desc_arr);
        
        $button1_link = $this->request->getVar('button1_link');
        $button2_link = $this->request->getVar('button2_link');

        $data=array(
            'slider_title'=>$serialized_slider_title,
            'button1_text'=>$serialized_button1_text,
            'button2_text'=>$serialized_button2_text,
            'slider_desc'=>$serialized_slider_desc,
            'button1_link'=>$button1_link,
            'button2_link'=>$button2_link,
            );
        if($filepath!='')
        {
           $data['slider_image'] = $filepath;
        }
        $this->ContentModel->update_homeslider($data,$id); 
        return redirect()->to('/admin/home-slider');
    }
    
    public function gethomeslider()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('homeslider')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('homeslider')
                                ->select('id')
                                ->orLike('slider_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('homeslider')
            ->select('*')
            ->orLike('slider_title', $searchValue)
            ->orderBy('id','ASC')
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           $image='<img src="'.base_url().$record['slider_image'].'" class="table-img">';
           $SliderTitle=unserialize($record['slider_title'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-home-slider/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               if($record['button1_link']!='')
               {
               $url1=$record['button1_link'];
               }
               else
               {
                $url1='None';   
               }
               if($record['button2_link']!='')
               {
               $url2=$record['button2_link'];
               }
               else
               {
                $url2='None';   
               }
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Title"=>$SliderTitle,
            //  "url1"=>$url1,
            //  "url2"=>$url2,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function homesliderstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_homeslider_status($status,$id); 
    }
    public function homesliderdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->homeslider_delete($id);  
    }
    
    // home banner
    
    public function homebanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->gethomebanner();
        $data['page']='homebanner';
        return view('Admin/admin_index',$data);
    }
    public function addhomebanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->gethomebanner();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addhomebanner';
        return view('Admin/admin_index',$data);
    }
    public function insert_homebanner()
    {
       
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/home_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/home_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
         
         if($file_mobile = $this->request->getFile('banner_image_mobile')) 
        {
                    if ($file_mobile->isValid() && ! $file_mobile->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file_mobile->getName();
                         $ext = $file_mobile->getClientExtension();

                         // Get random file name
                         $newName = $file_mobile->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file_mobile->move('./public/uploads/home_banner/', $newName);

                         // File path to display preview
                         $filepath_mobile = "public/uploads/home_banner/".$newName;
                    }
                    else
                    {
                        $filepath_mobile='';
                    }
         }  
         else
         {
            $filepath_mobile='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $button_textlanguage_arr = $this->request->getVar('button_text_language');
        $button_text_arr = $this->request->getVar('button_text');
        $serialized_button_text=$this->lang_serialize($button_textlanguage_arr,$button_text_arr);
        
        $banner_desclanguage_arr = $this->request->getVar('banner_desc_language');
        $banner_desc_arr = $this->request->getVar('banner_desc');
        $serialized_banner_desc=$this->lang_serialize($banner_desclanguage_arr,$banner_desc_arr);
        
        $banner_section = $this->request->getVar('banner_section');
        $button_link = $this->request->getVar('button_link');
        // $target_banner_category = $this->request->getVar('target_banner_category');

        $data=array(
            'banner_section'=>$banner_section,
            'banner_title'=>$serialized_banner_title,
            'button_text'=>$serialized_button_text,
            'banner_desc'=>$serialized_banner_desc,
            'button_link'=>$button_link,
            // 'target_category'=>$target_banner_category,
            'banner_image'=>$filepath,
            'banner_image_mobile'=>$filepath_mobile
            );
        
        $this->ContentModel->insert_homebanner($data); 
        return redirect()->to('/admin/home-banner'); 
     
    }
    
    public function edithomebanner($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $homebanner= $this->ContentModel->gethomebannerID($i);

        if(isset($homebanner))
        {
            $data['homebanner']  = $homebanner;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='edithomebanner';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/home-banner');  
        }
        
    }
    
    public function update_homebanner($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/home_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/home_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
         
         if($file_mobile = $this->request->getFile('banner_image_mobile')) 
        {
                    if ($file_mobile->isValid() && ! $file_mobile->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file_mobile->getName();
                         $ext = $file_mobile->getClientExtension();

                         // Get random file name
                         $newName = $file_mobile->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file_mobile->move('./public/uploads/home_banner/', $newName);

                         // File path to display preview
                         $filepath_mobile = "public/uploads/home_banner/".$newName;
                    }
                    else
                    {
                        $filepath_mobile='';
                    }
         }  
         else
         {
            $filepath_mobile='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $button_textlanguage_arr = $this->request->getVar('button_text_language');
        $button_text_arr = $this->request->getVar('button_text');
        $serialized_button_text=$this->lang_serialize($button_textlanguage_arr,$button_text_arr);
        
        $banner_desclanguage_arr = $this->request->getVar('banner_desc_language');
        $banner_desc_arr = $this->request->getVar('banner_desc');
        $serialized_banner_desc=$this->lang_serialize($banner_desclanguage_arr,$banner_desc_arr);
        
        $banner_section = $this->request->getVar('banner_section');
        $button_link = $this->request->getVar('button_link');
        // $target_banner_category = $this->request->getVar('target_banner_category');

        $data=array(
            'banner_section'=>$banner_section,
            'banner_title'=>$serialized_banner_title,
            'button_text'=>$serialized_button_text,
            'banner_desc'=>$serialized_banner_desc,
            'button_link'=>$button_link,
            // 'target_category'=>$target_banner_category,
            );
        if($filepath!='')
        {
           $data['banner_image'] = $filepath;
        }
        if($filepath_mobile!='')
        {
           $data['banner_image_mobile'] = $filepath_mobile;
        }
        $this->ContentModel->update_homebanner($data,$id); 
        return redirect()->to('/admin/home-banner');
    }
    
    public function gethomebanner()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('homebanner')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('homebanner')
                                ->select('id')
                                ->orLike('banner_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('homebanner')
            ->select('*')
            ->orLike('banner_title', $searchValue)
            ->orderBy('banner_section','ASC')
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           $image='<img src="'.base_url().$record['banner_image'].'" class="table-img">';
           $mobileimage='<img src="'.base_url().$record['banner_image_mobile'].'" class="table-img">';
           $BannerTitle=unserialize($record['banner_title'])['en'];
           $BannerText=unserialize($record['button_text'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-home-banner/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
            //   $Category=$this->ContentModel->GetCategoriesSlug($record['target_category']);
            //   if(isset($Category))
            //   {
            //       $TargetCategory_Name=unserialize($Category['name'])['en'];
            //   }
            //   else
            //   {
            //       $TargetCategory_Name='None';
            //   }
            
               if($record['button_link']!='')
               {
               $url=$record['button_link'];
               }
               else
               {
                $url='None';   
               }
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             'MobileImage'=>$mobileimage,
             "Title"=>$BannerTitle,
             "Section"=>'Section '.$record['banner_section'],
             "Url"=>$url,
            //  "TargetCategory"=>$TargetCategory_Name,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function homebannerstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_homebanner_status($status,$id); 
    }
    public function homebannerdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->homebanner_delete($id);  
    }
	
	
	// orderstatus
    public function orderstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['orderstatus'] = $this->ContentModel->getorderstatus();
        $data['page']='orderstatus';
        return view('Admin/admin_index',$data);
    }
    
    public function addorderstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['orderstatus'] = $this->ContentModel->getorderstatus();
        $data['page']='addorderstatus';
        return view('Admin/admin_index',$data);
    }
    
    public function insert_orderstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $status_title = $this->request->getVar('status_title');
        $invoice = $this->request->getVar('invoice');
        $sort_order = $this->request->getVar('sort_order');

        $data=array(
            'status_title'=>$status_title,
			'slug'=>slugify($status_title),
            'invoice'=>$invoice,
            'sequence'=>$sort_order,
            );
        
        $this->ContentModel->insert_orderstatus($data); 
        return redirect()->to('/admin/orderstatus'); 
    }
    
    public function editorderstatus($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $orderstatus= $this->ContentModel->getorderstatusID($i);

        if(isset($orderstatus))
        {
            $data['orderstatus']  = $orderstatus;
            $data['page'] ='editorderstatus';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/orderstatus');  
        }
        
    }
    
    public function update_orderstatus($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $status_title = $this->request->getVar('status_title');
        $invoice = $this->request->getVar('invoice');
        $sort_order = $this->request->getVar('sort_order');

        $data=array(
            'status_title'=>$status_title,
            'invoice'=>$invoice,
            'sequence'=>$sort_order,
            );
        
        $this->ContentModel->update_orderstatus($data,$id); 
        return redirect()->to('/admin/orderstatus');
    }
    
    
    
    public function getorderstatus()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();

       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('orderstatus')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('orderstatus')
                                ->select('id')
                                ->orLike('status_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('orderstatus')
            ->select('*')
            ->orLike('status_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
               $status.='<div class="square-switch">';
               $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
               $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
               $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editorderstatus/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['create_date']));
               if($record['invoice']==0)
			   {
				   $invoice='No';
			   }
			   else
			   {
				   $invoice='Yes';
			   }
          $data[] = array( 
             "id"=>$i,
             "status_title"=>$record['status_title'],
             "invoice"=>$invoice,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    
    public function orderstatusstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $status = $this->request->getVar('status');
            $id = $this->request->getVar('id');
            $this->ContentModel->update_orderstatus_status($status,$id); 
    }
    
    public function orderstatusdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->orderstatus_delete($id);  
    }
	
	
	
	// shippingcompany
    public function shippingcompany()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['shippingcompany'] = $this->ContentModel->getshippingcompany();
        $data['page']='shippingcompany';
        return view('Admin/admin_index',$data);
    }
    
    public function addshippingcompany()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['shippingcompany'] = $this->ContentModel->getshippingcompany();
        $data['page']='addshippingcompany';
        return view('Admin/admin_index',$data);
    }
    
    public function insert_shippingcompany()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $company_title = $this->request->getVar('company_title');
        $company_logo = $this->request->getVar('company_logo');
		$tracking_link = $this->request->getVar('tracking_link');
        $sort_order = $this->request->getVar('sort_order');
        if($file = $this->request->getFile('company_logo')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/shippingcompany/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/shippingcompany/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
        }  
        else
        {
            $filepath='';
        }
		 
        $data=array(
            'company_title'=>$company_title,
			'slug'=>slugify($company_title),
            'tracking_link'=>$tracking_link,
			'company_logo'=>$filepath,
            'sequence'=>$sort_order,
            );
        
        $this->ContentModel->insert_shippingcompany($data); 
        return redirect()->to('/admin/shippingcompany'); 
    }
    
    public function editshippingcompany($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $shippingcompany= $this->ContentModel->getshippingcompanyID($i);

        if(isset($shippingcompany))
        {
            $data['shippingcompany']  = $shippingcompany;
            $data['page'] ='editshippingcompany';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/shippingcompany');  
        }
        
    }
    
    public function update_shippingcompany($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
         $company_title = $this->request->getVar('company_title');
        $company_logo = $this->request->getVar('company_logo');
		$tracking_link = $this->request->getVar('tracking_link');
        $sort_order = $this->request->getVar('sort_order');
        if($file = $this->request->getFile('company_logo')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/shippingcompany/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/shippingcompany/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
        }  
        else
        {
            $filepath='';
        }
		 
        $data=array(
            'company_title'=>$company_title,
			'slug'=>slugify($company_title),
            'tracking_link'=>$tracking_link,
            'sequence'=>$sort_order,
            );
		if($filepath!='')
		{
			$data['company_logo']=$filepath;
		}			
        $this->ContentModel->update_shippingcompany($data,$id); 
        return redirect()->to('/admin/shippingcompany');
    }
    
    
    
    public function getshippingcompany()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();

       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('shippingcompany')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('shippingcompany')
                                ->select('id')
                                ->orLike('company_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('shippingcompany')
            ->select('*')
            ->orLike('company_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
               $status.='<div class="square-switch">';
               $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
               $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
               $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editshippingcompany/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['create_date']));
               
          $data[] = array( 
             "id"=>$i,
             "company_title"=>$record['company_title'],
             "tracking_link"=>$record['tracking_link'],
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    
    public function shippingcompanystatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $status = $this->request->getVar('status');
            $id = $this->request->getVar('id');
            $this->ContentModel->update_shippingcompany_status($status,$id); 
    }
    
    public function shippingcompanydelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->shippingcompany_delete($id);  
    }
    
    
    
    public function registerbanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getregisterbanner();
        $data['page']='registerbanner';
        return view('Admin/admin_index',$data);
    }
    public function addregisterbanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pages'] = $this->ContentModel->getregisterbanner();
        $data['language'] = $this->ContentModel->getlanguage();
        $data['Categories'] = $this->ContentModel->GetCategories();
        $data['page']='addregisterbanner';
        return view('Admin/admin_index',$data);
    }
    public function insert_registerbanner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/registerbanner_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/registerbanner_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $banner_desclanguage_arr = $this->request->getVar('banner_desc_language');
        $banner_desc_arr = $this->request->getVar('banner_desc');
        $serialized_banner_desc=$this->lang_serialize($banner_desclanguage_arr,$banner_desc_arr);
        

        $data=array(
            'banner_title'=>$serialized_banner_title,
            'banner_desc'=>$serialized_banner_desc,
            'banner_image'=>$filepath
            );
        
        $this->ContentModel->insert_registerbanner($data); 
        return redirect()->to('/admin/register-banner'); 
     
    }
    
    public function editregisterbanner($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $registerbanner= $this->ContentModel->getregisterbannerID($i);

        if(isset($registerbanner))
        {
            $data['registerbanner']  = $registerbanner;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['Categories'] = $this->ContentModel->GetCategories();
            $data['page'] ='editregisterbanner';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/register-banner');  
        }
        
    }
    
    public function update_registerbanner($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('banner_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/registerbanner_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/registerbanner_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $banner_titlelanguage_arr = $this->request->getVar('banner_title_language');
        $banner_title_arr = $this->request->getVar('banner_title');
        $serialized_banner_title=$this->lang_serialize($banner_titlelanguage_arr,$banner_title_arr);
        
        $banner_desclanguage_arr = $this->request->getVar('banner_desc_language');
        $banner_desc_arr = $this->request->getVar('banner_desc');
        $serialized_banner_desc=$this->lang_serialize($banner_desclanguage_arr,$banner_desc_arr);
        

        $data=array(
            'banner_title'=>$serialized_banner_title,
            'banner_desc'=>$serialized_banner_desc,
            );
        if($filepath!='')
        {
           $data['banner_image'] = $filepath;
        }
        $this->ContentModel->update_registerbanner($data,$id); 
        return redirect()->to('/admin/register-banner');
    }
    
    public function getregisterbanner()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('registerbanner')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('registerbanner')
                                ->select('id')
                                ->orLike('banner_title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('registerbanner')
            ->select('*')
            ->orLike('banner_title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
           
           if($record['banner_image']!='')
           {
                $image='<img src="'.base_url().$record['banner_image'].'" class="table-img">';
           }
           else
           {
                $image='';  
           }
           $BannerTitle=unserialize($record['banner_title'])['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-register-banner/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
               
               
               
          $data[] = array( 
             "id"=>$i,
             "Image"=>$image,
             "Title"=>$BannerTitle,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function registerbannerstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_registerbanner_status($status,$id); 
    }
    public function registerbannerdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->ContentModel->registerbanner_delete($id);  
    }
    
    
   
    
    public function book_an_appointment()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $page= $this->ContentModel->getbook_an_appointmen();

        if(isset($page))
        {
            $data['pagedata']  = $page;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['page'] ='edit_book_an_appointment';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/edit-book-an-appointment/'.$i);  
        }
        
    }
    
    public function update_book_an_appointment($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $page_heading = $this->request->getVar('page_heading');
        $page_description = $this->request->getVar('page_description');
        $meta_title = $this->request->getVar('meta_title');
        $meta_keyword = $this->request->getVar('meta_keyword');
        $meta_description = $this->request->getVar('meta_description');
        $lang = $this->request->getVar('lang');
        
        if($file = $this->request->getFile('page_banner')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/page_banner/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/page_banner/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $data=array(
            'page_heading'=>$page_heading,
            'page_description'=>$page_description,
            'meta_title'=>$meta_title,
            'meta_keyword'=>$meta_keyword,
            'meta_description'=>$meta_description,
            'language'=>$lang,
            );
        if($filepath!='')
        {
            $data['page_banner']=$filepath;
        }
        
        $this->ContentModel->update_book_an_appointmentID($data,$id); 
        return redirect()->to('/admin/edit-book-an-appointment/'.$id);
    }
    

    	
	public function warehouse()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getwarehouse();
        $data['page']='warehouse';
        return view('Admin/admin_index',$data);
    }
    public function addwarehouse()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addwarehouse';
        return view('Admin/admin_index',$data);
    }
    public function insert_warehouse()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
         $title = $this->request->getVar('title');
        $phone = $this->request->getVar('phone');
        $phonecode = $this->request->getVar('phonecode');
        $phone2 = $this->request->getVar('phone2');
        $phonecode2 = $this->request->getVar('phonecode2');
        $email = $this->request->getVar('email');
        $fax = $this->request->getVar('fax');
        $add1 = $this->request->getVar('add1');
        $add2 = $this->request->getVar('add2');
        $countryId = $this->request->getVar('country');
        $country = countryname($countryId);
        $regionId = $this->request->getVar('region');
        $region = regionname($regionId);
        $city = $this->request->getVar('city');
        $zipcode = $this->request->getVar('zipcode');
        
        $data=array(
            'title'=>$title,
            'phone'=>$phone,
            'phonecode'=>$phonecode,
            'phone2'=>$phone2,
            'phonecode2'=>$phonecode2,
            'email'=>$email,
            'fax'=>$fax,
            'add1'=>$add1,
            'add2'=>$add2,
            'countryId'=>$countryId,
            'country'=>$country,
            'regionId'=>$regionId,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zipcode,
            );
        
        $this->ContentModel->insert_warehouse($data); 
        return redirect()->to('/admin/warehouse'); 
     
    }
    
    public function editwarehouse($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $warehouse= $this->ContentModel->getwarehouseID($i);

        if(isset($warehouse))
        {
            $data['warehouse']  = $warehouse;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['page'] ='editwarehouse';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/warehouse');  
        }
        
    }
    
    public function update_warehouse($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $title = $this->request->getVar('title');
        $phone = $this->request->getVar('phone');
        $phonecode = $this->request->getVar('phonecode');
        $phone2 = $this->request->getVar('phone2');
        $phonecode2 = $this->request->getVar('phonecode2');
        $email = $this->request->getVar('email');
        $fax = $this->request->getVar('fax');
        $add1 = $this->request->getVar('add1');
        $add2 = $this->request->getVar('add2');
        $countryId = $this->request->getVar('country');
        $country = countryname($countryId);
        $regionId = $this->request->getVar('region');
        $region = regionname($regionId);
        $city = $this->request->getVar('city');
        $zipcode = $this->request->getVar('zipcode');
        
        $data=array(
            'title'=>$title,
            'phone'=>$phone,
            'phonecode'=>$phonecode,
            'phone2'=>$phone2,
            'phonecode2'=>$phonecode2,
            'email'=>$email,
            'fax'=>$fax,
            'add1'=>$add1,
            'add2'=>$add2,
            'countryId'=>$countryId,
            'country'=>$country,
            'regionId'=>$regionId,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zipcode,
            );
        
        $this->ContentModel->update_warehouse($data,$id); 
        return redirect()->to('/admin/warehouse');
    }
    
    public function getwarehouse()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('warehouse')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('warehouse')
                                ->select('id')
                                ->orLike('add1', $searchValue)
                                ->orLike('add2', $searchValue)
                                ->orLike('city', $searchValue)
                                ->orLike('region', $searchValue)
                                ->orLike('country', $searchValue)
                                ->orLike('email', $searchValue)
                                ->orLike('phone', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('warehouse')
            ->select('*')
            ->orLike('add1', $searchValue)
            ->orLike('add2', $searchValue)
            ->orLike('city', $searchValue)
            ->orLike('region', $searchValue)
            ->orLike('country', $searchValue)
            ->orLike('email', $searchValue)
            ->orLike('phone', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
         $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editwarehouse/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['createDate']));

               
          $data[] = array( 
             "id"=>$i,
			 "title"=>$record['title'],
             "warehouse"=>$record['add1']."<br>".$record['add2'],
             "Region"=>$record['region'],
             "Country"=>$record['country'],
             "Zipcode"=>$record['zipcode'],
            //  "Email"=>$record['email'],
            //  "Phone"=>"+".$record['phonecode'].$record['phone'],
             "date"=>$date,
             "status"=>$status,
             "action"=>$action,
          ); 
         
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function warehousestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_warehouse_status($status,$id); 
    }
    
    public function warehousedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->ContentModel->warehouse_delete($id);  
    }
	
	public function shipper()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['pagedata'] = $this->ContentModel->getshipper();
        $data['page']='shipper';
        return view('Admin/admin_index',$data);
    }
    public function addshipper()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->ContentModel->getlanguage();
        $data['page']='addshipper';
        return view('Admin/admin_index',$data);
    }
    public function insert_shipper()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
         $title = $this->request->getVar('title');
		 $account_number = $this->request->getVar('account_number');
        $phone = $this->request->getVar('phone');
        $phonecode = $this->request->getVar('phonecode');
        $phone2 = $this->request->getVar('phone2');
        $phonecode2 = $this->request->getVar('phonecode2');
        $email = $this->request->getVar('email');
        $fax = $this->request->getVar('fax');
        $add1 = $this->request->getVar('add1');
        $add2 = $this->request->getVar('add2');
        $countryId = $this->request->getVar('country');
        $country = countryname($countryId);
        $regionId = $this->request->getVar('region');
        $region = regionname($regionId);
        $city = $this->request->getVar('city');
        $zipcode = $this->request->getVar('zipcode');
        
        $data=array(
            'title'=>$title,
			'account_number'=>$account_number,
            'phone'=>$phone,
            'phonecode'=>$phonecode,
            'phone2'=>$phone2,
            'phonecode2'=>$phonecode2,
            'email'=>$email,
            'fax'=>$fax,
            'add1'=>$add1,
            'add2'=>$add2,
            'countryId'=>$countryId,
            'country'=>$country,
            'regionId'=>$regionId,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zipcode,
            );
        
        $this->ContentModel->insert_shipper($data); 
        return redirect()->to('/admin/shipper'); 
     
    }
    
    public function editshipper($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $shipper= $this->ContentModel->getshipperID($i);

        if(isset($shipper))
        {
            $data['shipper']  = $shipper;
            $data['language'] = $this->ContentModel->getlanguage();
            $data['page'] ='editshipper';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/shipper');  
        }
        
    }
    
    public function update_shipper($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $title = $this->request->getVar('title');
		$account_number = $this->request->getVar('account_number');
        $phone = $this->request->getVar('phone');
        $phonecode = $this->request->getVar('phonecode');
        $phone2 = $this->request->getVar('phone2');
        $phonecode2 = $this->request->getVar('phonecode2');
        $email = $this->request->getVar('email');
        $fax = $this->request->getVar('fax');
        $add1 = $this->request->getVar('add1');
        $add2 = $this->request->getVar('add2');
        $countryId = $this->request->getVar('country');
        $country = countryname($countryId);
        $regionId = $this->request->getVar('region');
        $region = regionname($regionId);
        $city = $this->request->getVar('city');
        $zipcode = $this->request->getVar('zipcode');
        
        $data=array(
            'title'=>$title,
			'account_number'=>$account_number,
            'phone'=>$phone,
            'phonecode'=>$phonecode,
            'phone2'=>$phone2,
            'phonecode2'=>$phonecode2,
            'email'=>$email,
            'fax'=>$fax,
            'add1'=>$add1,
            'add2'=>$add2,
            'countryId'=>$countryId,
            'country'=>$country,
            'regionId'=>$regionId,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zipcode,
            );
        
        $this->ContentModel->update_shipper($data,$id); 
        return redirect()->to('/admin/shipper');
    }
    
    public function getshipper()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('shippers')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('shippers')
                                ->select('id')
								->orLike('title', $searchValue)
								->orLike('account_number', $searchValue)
								->orLike('account_number', $searchValue)
                                ->orLike('add1', $searchValue)
                                ->orLike('add2', $searchValue)
                                ->orLike('city', $searchValue)
                                ->orLike('region', $searchValue)
                                ->orLike('country', $searchValue)
                                ->orLike('email', $searchValue)
                                ->orLike('phone', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('shippers')
            ->select('*')
			->orLike('title', $searchValue)
			->orLike('account_number', $searchValue)
            ->orLike('add1', $searchValue)
            ->orLike('add2', $searchValue)
            ->orLike('city', $searchValue)
            ->orLike('region', $searchValue)
            ->orLike('country', $searchValue)
            ->orLike('email', $searchValue)
            ->orLike('phone', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record ){
         $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editshipper/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['createDate']));

               
          $data[] = array( 
             "id"=>$i,
			 "title"=>$record['title'],
			 "account_number"=>$record['account_number'],
             "address"=>$record['add1']."<br>".$record['add2'],
             "Region"=>$record['region'],
             "Country"=>$record['country'],
             "Zipcode"=>$record['zipcode'],
            //  "Email"=>$record['email'],
            //  "Phone"=>"+".$record['phonecode'].$record['phone'],
             "date"=>$date,
             "status"=>$status,
             "action"=>$action,
          ); 
         
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function shipperstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->ContentModel->update_shipper_status($status,$id); 
    }
    
    public function shipperdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->ContentModel->shipper_delete($id);  
    }
    
}
