<?php
namespace App\Controllers\Admin;
use App\Models\DashboardModel;
use App\Controllers\BaseController;
class Dashboard extends BaseController
{
    public function __construct(){
      $this->session = \Config\Services::session(); 
        $this->dashboardModel = new DashboardModel();  
        
    }
    public function index()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='dashboard';
        return view('Admin/admin_index',$data);
    }
    
    public function login()
    {
        if(isset($this->session->admin))
        {
           return redirect()->to('/admin'); 
        }
        if (! $this->request->is('post')) {
            $data=[];
            $data['title']='login';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/login', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }   
        
        $rules = [
                    'username' => 'required|max_length[30]|valid_email',
                    'password' => 'required|max_length[255]|min_length[6]',
                ];

        if (!$this->validate($rules)) {
            $data=[];
            $data['validation'] = $this->validator;
            $data['title']='login';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/login', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }
        $username = $this->request->getVar('username');
        $password = $this->request->getVar('password');
        $data = $this->dashboardModel->login($username);
        if(isset($data)){
            $pass = $data['password'];
            $authenticatePassword = password_verify($password, $pass);
            if($authenticatePassword){
                $ses_data = [
                    'id' => $data['id'],
                    'data' => $data,
                    'isLoggedIn' => TRUE
                ];
                $this->session->set('admin',$ses_data);
                return redirect()->to('/admin');
            
            }else{
                //$session->setFlashdata('msg', 'Password is incorrect.');
                return redirect()->to('/admin/login');
            }
        }else{
            //$session->setFlashdata('msg', 'Username does not exist.');
            return redirect()->to('/admin/login');
        }
    }
    
    public function forgot_password()
    {
        if(isset($this->session->admin))
        {
           return redirect()->to('/admin'); 
        }
        if (! $this->request->is('post')) {
            $data=[];
            $data['title']='Forgot Password';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/forgot_password', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }   
        
        $rules = [
                    'email' => 'required|max_length[30]|valid_email',
                ];

        if (!$this->validate($rules)) {
            $data=[];
            $data['validation'] = $this->validator;
            $data['title']='Forgot Password';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/forgot_password', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }
        $email = $this->request->getVar('email');
        $data = $this->dashboardModel->login($email);
        if(isset($data))
        {
                $currentTime = strtotime(date('Y-m-d H:i:s', strtotime('1 hour')));
                $code=RandomString($length=32);
                $data=array(
                    'reset-password-code'=>$code,
                    'reset-password-time'=>$currentTime,
                    );
                $this->dashboardModel->updateresetpassword($data,$email);   
                $link=base_url()."admin/reset-password/".$code;
                 $emailtemplate=emailtemplates('forgot-password-admin');
                 if($emailtemplate)
                 {
                     $websettings=websettings();
                     $token = array('SITE_URL' => base_url(''),
                                    'SITE_TITLE' => $websettings['company_title'],
                                    'EMAIL' => $email,
                                    'LINK' => $link,
                                );
                                
                     $to=$email; 
                     $this->send_email($emailtemplate,$token,$to);
                 }
            $data=[];
            $data['title']='Forgot Password';
            $data['success_msg']='Instructions will be sent to your Registered Email '.$email;
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/forgot_password', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
            
            
        }else{
            //$session->setFlashdata('msg', 'Username does not exist.');
            $data=[];
            $data['title']='Forgot Password';
            $data['error_msg']='Email Not Registered!';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/forgot_password', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }
    }
    
    
    public function reset_password($code)
    {
        if(isset($this->session->admin))
        {
           return redirect()->to('/admin'); 
        }
        if (! $this->request->is('post')) {
            
            $data=[];
            $resetpasswordcheck=$this->dashboardModel->resetpasswordcheck($code); 
            if(isset($resetpasswordcheck))
            {
                $currentTime = strtotime(date('Y-m-d H:i:s', strtotime('1 hour')));
                $resetpasswordtime=$resetpasswordcheck['reset-password-time'];
                if($resetpasswordtime<$currentTime)
                {
                    $data['title']='Reset Password';
                    return  view('Admin/Include/top_meta')
                          . view('Admin/Include/include_top')
                          . view('Admin/Include/body_start')
                          . view('Admin/reset_password', $data)
                          . view('Admin/Include/include_bottom')
                          . view('Admin/Include/body_end');
                }
                else
                {
                    $data['title']='Reset Password';
                    $data['error_msg']='Reset Password link expired.';
                    return  view('Admin/Include/top_meta')
                          . view('Admin/Include/include_top')
                          . view('Admin/Include/body_start')
                          . view('Admin/reset_password', $data)
                          . view('Admin/Include/include_bottom')
                          . view('Admin/Include/body_end');
                }
            }
            else
            {
                $data['title']='Reset Password';
                $data['error_msg']='Reset Password link not Vaild.';
                return  view('Admin/Include/top_meta')
                      . view('Admin/Include/include_top')
                      . view('Admin/Include/body_start')
                      . view('Admin/reset_password', $data)
                      . view('Admin/Include/include_bottom')
                      . view('Admin/Include/body_end');
            }
        }   
        
        $rules = [
                     "password" => [
                    "label" => "Password", 
                    "rules" => "required|max_length[20]|min_length[6]"
                    ],
                    "confirm_password" => [
                    "label" => "Confirm Password", 
                    "rules" => "required|max_length[20]|min_length[6]|matches[password]"
                    ]
                ];

        if (!$this->validate($rules)) {
            $data=[];
            $data['validation'] = $this->validator;
            $data['title']='Reset Password';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/reset_password', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }
        $dataresetpassword = $this->dashboardModel->resetpasswordcheck($code);
        if(isset($dataresetpassword))
        {
            $new_password = password_hash($this->request->getVar('password'), PASSWORD_BCRYPT);
                $data=array(
                    'reset-password-code'=>"",
                    'reset-password-time'=>"",
                    'password'=>$new_password,
                    );
                $this->dashboardModel->changeresetpassword($data,$code);   
                
           return redirect()->to('/admin/login'); 
            
            
        }else{
            //$session->setFlashdata('msg', 'Username does not exist.');
            $data=[];
            $data['title']='Reset Password';
            $data['error_msg']='Reset Password link Not Valid.';
            return  view('Admin/Include/top_meta')
                  . view('Admin/Include/include_top')
                  . view('Admin/Include/body_start')
                  . view('Admin/reset_password', $data)
                  . view('Admin/Include/include_bottom')
                  . view('Admin/Include/body_end');
        }
    }
    
    public function organisation()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        
        $data=[];
        $data['page']='organisation';
        return view('Admin/admin_index',$data);
    }
    
    public function profile()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $data=[];
        $adminId=$this->session->admin['id'];
        $data['profile'] = $this->dashboardModel->profile($adminId);
        $data['page']='profile';
        return view('Admin/admin_index',$data);
    }
    public function change_password()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        if (! $this->request->is('post')) {
            $data=[];
            $data['page']='change_password';
            return view('Admin/admin_index',$data);
        }
        
        $rules = [
                     "old_password" => [
                        "label" => "Old Password", 
                        "rules" => "required|max_length[20]|min_length[6]"
                    ],
                     "new_password" => [
                    "label" => "New Password", 
                    "rules" => "required|max_length[20]|min_length[6]"
                    ],
                    "confirm_password" => [
                    "label" => "Confirm Password", 
                    "rules" => "required|max_length[20]|min_length[6]|matches[new_password]"
                    ]
                ];
                
        if (!$this->validate($rules)) {
            $data=[];
            $data['validation'] = $this->validator;
            $data['page']='change_password';
            return view('Admin/admin_index',$data);
        }
        $adminId=$this->session->admin['id'];
        $old_password = password_hash($this->request->getVar('old_password'), PASSWORD_BCRYPT);
        $checkOld_password=$this->dashboardModel->checkOld_password($old_password,$adminId); 
        if($checkOld_password)
        {
            $new_password = password_hash($this->request->getVar('new_password'), PASSWORD_BCRYPT);
            $data=array(
                'password'=>$new_password,
                );
            $this->dashboardModel->update_password($data,$adminId); 
            return redirect()->to('/admin');
        }
        else
        {
            // $session->setFlashdata('msg', 'Old Password Not Match');
            return redirect()->to('/admin/change_password');
        }
    }
    
    public function update_password()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
    }
    
    public function profile_update()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('profile')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/profile/', $newName);

                         // File path to display preview
                         $filepath = "/public/uploads/profile/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
        else
        {
            $filepath='';
        }

        $first_name = $this->request->getVar('first_name');
        $last_name = $this->request->getVar('last_name');
        $email = $this->request->getVar('email');
        $phone = $this->request->getVar('phone');
        $address1 = $this->request->getVar('address1');
        $address2 = $this->request->getVar('address2');
        $zipcode = $this->request->getVar('zipcode');
        $country = $this->request->getVar('country');
        $state = $this->request->getVar('state');
        $city = $this->request->getVar('city');
        $data=array(
            'first_name'=>$first_name,
            'last_name'=>$last_name,
            'email'=>$email,
            'phone'=>$phone,
            'address1'=>$address1,
            'address2'=>$address2,
            'zipcode'=>$zipcode,
            'country'=>$country,
            'provision_state'=>$state,
            'city'=>$city,
            'username'=>$email,
            );
        if($filepath!='')
        {
            $data['profile']=$filepath;
        }
        $adminId=$this->session->admin['id'];
        $this->dashboardModel->profile_update($data,$adminId); 
        return redirect()->to('/admin/profile');
    }
    
    public function logout()
    {
        $this->session->remove('admin');
        return redirect()->to('/admin/login');
    }
    
    public function send_email($emailtemplate,$token,$to)
    {
        $pattern = '[%s]';
        foreach ($token as $key => $val)
        {
            $varMap[sprintf($pattern, $key) ] = $val;
        }       
        $emailContent = strtr($emailtemplate['body'], $varMap);
        $subject = $emailtemplate['subject'];
        default_smtp_mail($emailContent,$subject,$to);
    }
    
    public function clear_cache()
    {
        helper('filesystem');
        delete_files(WRITEPATH.'/cache', true);
        return redirect()->to($_SERVER['HTTP_REFERER']);
    }
    
    
}
