<?php
namespace App\Controllers\Admin;
use App\Models\ImportModel;
use App\Models\OrderModel;
use App\Controllers\BaseController;
use App\Controllers\RenderImage;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Import extends BaseController
{
    public function __construct(){
      
      // Creates New Spreadsheet 
        $this->db = \Config\Database::connect(); //Load database connection 
        $this->ImportModel = new ImportModel();  
        $this->OrderModel = new OrderModel();  
    }
   
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    
    public function lang_slug($unserializeName)
    {
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
            
        }
    }
    
    public function importjewelry()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
            $data=[];
            $data['page']='importjewelry';
            return view('Admin/admin_index',$data);
    }
    // $sheetData = $spreadsheet->getActiveSheet()->toArray();

    public function jewelryimportSubmit()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        if($this->request->getFile('file'))
        { // Valid
            $masterrecord=array();
            
             if($file = $this->request->getFile('file')) 
             {
                if ($file->isValid() && ! $file->hasMoved()) 
                {
                   // Get random file name
                   $newName = $file->getRandomName();
                   $name = $file->getName();
                   $extension = $file->getClientExtension();
    
                   // Store file in public/csvfile/ folder
                   $file->move('./public/uploads/csvfile/', $newName);
                   $filepath = "public/uploads/csvfile/".$newName;
                   // Reading file
  
                    if('csv' == $extension){
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                    } else {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                    }
                    
                    $spreadsheet = $reader->load($filepath);
                    
                    
                    
                    $ImportJewelrysheetData=$spreadsheet->getSheetByName('Import Jewelry')->toArray(null, true, true, true);
                    $ImportJewelryRecord=$this->jewelrysheet($ImportJewelrysheetData);
                    
                    $data=$this->db->transStart();
                    $ProductMetalsheetData=$spreadsheet->getSheetByName('Product Metal')->toArray(null, true, true, true);
                    $ProductMetalRecord=$this->ProductMetalImport($ProductMetalsheetData);
                    
                    $ProductStonesheetData=$spreadsheet->getSheetByName('Product_stone')->toArray(null, true, true, true);
                    $ProductStoneRecord=$this->ProductStoneImport($ProductStonesheetData);
                   
                    $ProductVariationsheetData=$spreadsheet->getSheetByName('Product Variation')->toArray(null, true, true, true);
                    $ProductVariationRecord=$this->ProductVariationImport($ProductVariationsheetData);
                    
                    $ProductImagesheetData=$spreadsheet->getSheetByName('Product_Image')->toArray(null, true, true, true);
                    $ProductImagesRecord=$this->ProductImagesImport($ProductImagesheetData);
                       if($ImportJewelryRecord['notvalidrecord']!=0)
                       {
                           $message="Some Jewelry Records Not Valid! Please Check Import Jewelry Sheet.";
                           $this->db->transRollback();
                           $this->ImportModel->DeleteTempJewelryProducts();
                       }
                       elseif($ProductMetalRecord['notvalidrecord']!=0)
                       {
                           $message="Some Metal Records Not Valid! Please Check Product Metal Sheet.";
                           $this->db->transRollback();
                           $this->ImportModel->DeleteTempJewelryProducts();
                       }
                        elseif($ProductStoneRecord['notvalidrecord']!=0)
                       {
                           $message="Some Stone Records Not Valid! Please Check Product_stone Sheet.";
                           $this->db->transRollback();
                           $this->ImportModel->DeleteTempJewelryProducts();
                       }
                        elseif($ProductVariationRecord['notvalidrecord']!=0)
                       {
                           $message="Some Variation Records Not Valid! Please Check Product Variation Sheet.";
                           $this->db->transRollback();
                           $this->ImportModel->DeleteTempJewelryProducts();
                       }
                        elseif($ProductImagesRecord['notvalidrecord']!=0)
                       {
                           $message="Some Images Records Not Valid! Please Check Product_Image Sheet.";
                           $this->db->transRollback();
                           $this->ImportModel->DeleteTempJewelryProducts();
                       }
                       else
                       {
                           $this->db->transComplete();
                           $this->db->transCommit();
                           $this->ImportModel->updateJewelryProducts();
                           $message="Records inserted successfully!";
                       }
                    
                    $response=array(
                      'status'=>true,
                      'ImportJewelry'=>$ImportJewelryRecord,
                      'ProductMetal'=>$ProductMetalRecord,
                      'ProductStone'=>$ProductStoneRecord,
                      'ProductVariation'=>$ProductVariationRecord,
                      'ProductImages'=>$ProductImagesRecord,
                      'message'=>$message
                    );
                    echo json_encode($response);  
                    return;
                
                }else{
                            $response=array(
                              'status'=>false,
                              'message'=>'File not imported.'
                            );
                            echo json_encode($response);  
                            return;
                  
                }
             }else{
                        $response=array(
                              'status'=>false,
                              'message'=>'File not imported.'
                        );
                        echo json_encode($response);  
                        return;
             }
    
      
        }
    }
    
    public function jewelrysheet($JewelrysheetData)
    {
        $totalrecord=0;
        $validrecord=0;
        $notvalidrecord=0;
        $updaterecord=0;
        $insertrecord=0;
        if(isset($JewelrysheetData[2]))
        {
                $arrayCount = count($JewelrysheetData);
                $flag = 0;
                $JewelryIndexArray=array();
                $JewelryIndex= array('Design','Product_Title','Short_Description','Long_Description','Metal','Purity','Color','Size','Measurement','Category','Category_type','Collection','Style','Occasion','Age','Gender','Quantity','Gross_wt','Net_wt','Unit','Cost_Price','Tag_Price','Sale_Price','Product_Type','Status','Search_Keyword','Meta_Keyword','Metal_Description','Premium','Closeout','Featured','Banner');
                foreach($JewelryIndex as $JewelryIndexrow)
                {
                    $JewelryIndexArray[$JewelryIndexrow]=$JewelryIndexrow;
                }
                $JewelrySheetDataKey = array();
                foreach ($JewelrysheetData as $dataInSheet) 
                {
                    foreach ($dataInSheet as $key => $value) 
                    {
                        if (in_array(trim($value), $JewelryIndex)) 
                        {
                            $value = preg_replace('/\s+/', '', $value);
                            $JewelrySheetDataKey[trim($value)] = $key;
                        } 
                    }
                }
                $dataDiff = array_diff_key($JewelryIndexArray, $JewelrySheetDataKey);
               
                if (empty($dataDiff)) 
                {
                     $flag = 1;
                }
               
                // match excel sheet column
                if ($flag == 1) 
                {
                    for ($i = 2; $i <= $arrayCount; $i++) 
                    {
                        $Design = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Design']]), FILTER_SANITIZE_STRING);
                        if($Design=='') 
                        { 
                            continue;
                        } 
                        else
                        {
                            $totalrecord++;
                        }
                        
                        $title = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Product_Title']]), FILTER_SANITIZE_STRING);
                        $Short_Description = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Short_Description']]), FILTER_SANITIZE_STRING);
                        $Long_Description = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Long_Description']]), FILTER_SANITIZE_STRING);
                        
                        $metal = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Metal']]), FILTER_SANITIZE_STRING);
                        $metalid=$this->ImportModel->getMasterId($metal,$table="metal",$filed="metalid");
                        $purity = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Purity']]), FILTER_SANITIZE_STRING);
                        
                        $color = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Color']]), FILTER_SANITIZE_STRING);
                        $colorid=$this->ImportModel->getMasterId($color,$table="color",$filed="colorid");
                        
                        $size = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Size']]), FILTER_SANITIZE_STRING);
                        $sizeid=$this->ImportModel->getMasterId($size,$table="size",$filed="sizeid");
                        $Measurement = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Measurement']]), FILTER_SANITIZE_STRING);

                        $category = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Category']]), FILTER_SANITIZE_STRING);
                        $categoryid=$this->ImportModel->getMasterId($category,$table="category",$filed="categoryid");
        
                        $category_type = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Category_type']]), FILTER_SANITIZE_STRING);
                        $category_typeid=$this->ImportModel->getMasterId($category_type,$table="type",$filed="typeid");
                        
                        $collection = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Collection']]), FILTER_SANITIZE_STRING);
                        $collectionid=$this->ImportModel->getMasterId($collection,$table="collection",$filed="collectionid");
                       
                        $style = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Style']]), FILTER_SANITIZE_STRING);
                        $styleid=$this->ImportModel->getMasterId($style,$table="style",$filed="styleid");
                        
                        $occasion = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Occasion']]), FILTER_SANITIZE_STRING);
                        $occasionid=$this->ImportModel->getMasterId($occasion,$table="occasion",$filed="occasionid");
                        
                        $age = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Age']]), FILTER_SANITIZE_STRING);
                        $ageid=$this->ImportModel->getMasterId($age,$table="age",$filed="ageid");
                        
                        $gender = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Gender']]), FILTER_SANITIZE_STRING);
                        $genderid=$this->ImportModel->getMasterId($gender,$table="gender",$filed="genderid");
                        
                        $quantity = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Quantity']]), FILTER_SANITIZE_STRING);
                        $gross_weight = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Gross_wt']]), FILTER_SANITIZE_STRING);
                        $net_weight = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Net_wt']]), FILTER_SANITIZE_STRING);
                        $weightunit = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Unit']]), FILTER_SANITIZE_STRING);
                        $cost_price = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Cost_Price']]), FILTER_SANITIZE_STRING);
                        $tag_price = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Tag_Price']]), FILTER_SANITIZE_STRING);
                        $sale_price = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Sale_Price']]), FILTER_SANITIZE_STRING);
                        $protype = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Product_Type']]), FILTER_SANITIZE_STRING);
                        $status = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Status']]), FILTER_SANITIZE_STRING);
                        $search_keyword = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Search_Keyword']]), FILTER_SANITIZE_STRING);
                        $meta_keyword = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Meta_Keyword']]), FILTER_SANITIZE_STRING);
                        $meta_description = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Metal_Description']]), FILTER_SANITIZE_STRING);
                        $Premium = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Premium']]), FILTER_SANITIZE_STRING);
                        $Closeout = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Closeout']]), FILTER_SANITIZE_STRING);
                        $Featured = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Featured']]), FILTER_SANITIZE_STRING);
                        $Banner = filter_var(trim($JewelrysheetData[$i][$JewelrySheetDataKey['Banner']]), FILTER_SANITIZE_STRING);
                        $length = 4;    

                        $protype=strtolower($protype);
                        if($Design=='' || $title=='' || $sale_price=='' || $protype=='')
                        {
                            $notvalidrecord++;
                            $this->ImportModel->DeleteTempJewelryProducts();
                            $record=array(
                                  'status'=>false,
                                  'message'=>'Product Jewelry Row No. '.$i.' Not Valid. Design, Title, Sale price,Product_Type Required.'
                                  );
                            echo json_encode($record);
                            die;
                            continue;
                        }
                        
                        
                        if($protype!='jewelry' &&  $protype!='gemstone' && $protype!='diamond')
                        {
                            $notvalidrecord++;
                            $this->ImportModel->DeleteTempJewelryProducts();
                            $record=array(
                                  'status'=>false,
                                  'message'=>'Product Jewelry Row No. '.$i.' Not Valid. Product Type Not Valid.'
                                  );
                            echo json_encode($record);
                            die;
                            continue;
                        }
                        if($status=='yes')
                        {
                            $status='1';
                        }
                        elseif($status=='no')
                        {
                            $status='0';
                        }
                        else
                        {
                            $status='1';
                        }
                       
                        $jewelryData= array(
                                'design'           =>$Design,
                                'title'            =>$title,
                                'short_description'=>$Short_Description,
                                'long_description' =>$Long_Description,
                                'metalid'          =>$metalid,
                                'metal'            =>$metal,
                                'purity'           =>$purity,
                                'colorid'          =>$colorid,
                                'color'            =>$color,
                                'sizeid'          =>$sizeid,
                                'size'            =>$size,
                                'length'           =>$Measurement,
                                'categoryid'       =>$categoryid,
                                'category'         =>$category,
                                'category_type'    =>$category_type,
                                'category_typeid'  =>$category_typeid,
                                'collectionid'     =>$collectionid,
                                'collection'       =>$collection,
                                'styleid'          =>$styleid,
                                'style'            =>$style,
                                'occasionid'       =>$occasionid,
                                'occasion'         =>$occasion,
                                'ageid'            =>$ageid,
                                'age'              =>$age,
                                'genderid'         =>$genderid,
                                'gender'           =>$gender,
                                'quantity'         =>$quantity,
                                'gross_weight'     =>$gross_weight,
                                'net_weight'       =>$net_weight,
                                'weightunit'       =>$weightunit,
                                'cost_price'       =>$cost_price,
                                'tag_price'        =>$tag_price,
                                'sale_price'       =>$sale_price,
                                'premium'          =>$Premium,
                                'closeout'         =>$Closeout,
                                'featured'         =>$Featured,
                                'featured_banner'  =>$Banner,
                                'producttype'      =>$protype,
                                'status'           =>$status,
                                'search_keyword'   =>$search_keyword,
                                'meta_keyword'     =>$meta_keyword,
                                'meta_description' =>$meta_description,
                                'updateDate'       =>date('Y-m-d h:i:s a', time()),
                                'temp_import'      =>1
                            );
                            
                        $exist_ProductMaster=$this->ImportModel->exist_ProductMaster($Design);
                        if($exist_ProductMaster>=1)
                        {
                            // update exist product
                            $update_Product=$this->ImportModel->update_Product($jewelryData,$Design);
                            if($update_Product)
                            {
                                $updaterecord++;
                                $validrecord++;
                            }
                            else
                            {
                                
                                $notvalidrecord++;
                                $this->ImportModel->DeleteTempJewelryProducts();
                                $record=array(
                                  'status'=>false,
                                  'message'=>'Product Jewelry Row No. '.$i.' Not Valid for Update.'
                                  );
                            echo json_encode($record);
                            die;
                            }
                        }
                        else
                        {
                             // insert new product
                            $productCode1=substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                            $productCode2=substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                            $productCode=settings('product_code_prefix').$productCode1.$productCode2;
                            $slug=strtolower(url_title($title.'-'.$productCode));
                            $jewelryData['slug']=$slug;
                            $jewelryData['product_code']=$productCode;
                            $insert_Product=$this->ImportModel->insert_Product($jewelryData);
                            if($insert_Product)
                            {
                                $insertrecord++;
                                $validrecord++;
                            }
                        }
                    }   
                }

                    $record=array(
                        'status'=>true,
                        'totalrecord'=>$totalrecord,
                        'validrecord'=>$validrecord,
                        'notvalidrecord'=>$notvalidrecord,
                        'updaterecord'=>$updaterecord,
                        'insertrecord'=>$insertrecord,
                        'message'=>'Product Master Successfuly Insert'
                        );
                    return  $record;       
                
                   
           
        }
        else 
        {
                $record=array(
                        'status'=>true,
                        'totalrecord'=>$totalrecord,
                        'validrecord'=>$validrecord,
                        'notvalidrecord'=>$notvalidrecord,
                        'updaterecord'=>$updaterecord,
                        'insertrecord'=>$insertrecord,
                      'message'=>'Record not found in Import Jewelry file.'
                      );
                      
                 return  $record; 
        }
    }
    
    public function ProductMetalImport($sheetData)
    {
                   $totalrecord=0;
                    $validrecord=0;
                    $notvalidrecord=0;
                    $updaterecord=0;
                    $insertrecord=0;
                    if(isset($sheetData[2]))
                    {
                        $designArray=array();
                        $Index= array('Design','Metal','Purity','Weight','Unit');
                            $arrayCount = count($sheetData);
                            $flag = 0;
                            $IndexArray=array();
                            foreach($Index as $Indexrow)
                            {
                                $IndexArray[$Indexrow]=$Indexrow;
                            }
                            $DataKey = array();
                            foreach ($sheetData as $dataInSheet) {
                                foreach ($dataInSheet as $key => $value) {
                                    if (in_array(trim($value), $Index)) {
                                        $value = preg_replace('/\s+/', '', $value);
                                        $DataKey[trim($value)] = $key;
                                    } 
                                }
                            }
                            $dataDiff = array_diff_key($IndexArray, $DataKey);
                            if (empty($dataDiff)) {
                                 $flag = 1;
                            }
                            // match excel sheet column
                            if ($flag == 1) 
                            {
                                for ($i = 2; $i <= $arrayCount; $i++) 
                                {
                                    $Design = filter_var(trim($sheetData[$i][$DataKey['Design']]), FILTER_SANITIZE_STRING);
                                    if($Design=='') 
                                    { 
                                        continue;
                                    } 
                                    else
                                    {
                                        $totalrecord++;
                                    }
                                    
                                    $metal = filter_var(trim($sheetData[$i][$DataKey['Metal']]), FILTER_SANITIZE_STRING);
                                    $metalid=$this->ImportModel->getMasterId($metal,$table="metal",$filed="metalid");
                                    $purity = filter_var(trim($sheetData[$i][$DataKey['Purity']]), FILTER_SANITIZE_STRING);
                                    $weight = filter_var(trim($sheetData[$i][$DataKey['Weight']]), FILTER_SANITIZE_STRING);
                                    $unit = filter_var(trim($sheetData[$i][$DataKey['Unit']]), FILTER_SANITIZE_STRING);
                                    if($Design=='' || $metal=='' || $metalid==0 || $metalid=='' || $purity=='' || $weight=='' || $unit=='')
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Metal Row No. '.$i.' Not Valid.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    
                                    $product=$this->ImportModel->getProduct($Design);
                                    if(!$product)
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Metal Row No. '.$i.' Product Not Found.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    else
                                    {
                                        $product_code=$product['product_code'];
                                        $productid=$product['id'];
                                        $metalData= array(
                                            'productcode'=>$product_code,
                                            'productid'=>$productid,
                                            'othermetalid'=>$metalid,
                                            'othermetal'=>$metal,
                                            'otherweight'=>$weight,
                                            'otherweightunit'=>$unit,
                                            'otherpurity'=>$purity,
                                        );
                                        if (!in_array($Design, $designArray))
                                        {
                                            $this->ImportModel->delete_metal($product_code,$productid);
                                        }
                                        $designArray[]=$Design;
                                        $insert_metal=$this->ImportModel->insert_metal($metalData);
                                        if($insert_metal)
                                        {
                                            $insertrecord++;
                                            $validrecord++;
                                        }
                                    }
                                    
                                    
                                }   
                        }

                                $record=array(
                                    'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                    'message'=>'Product Metal Successfuly Insert'
                                    );
                                return  $record;       
                            
                               
                        
                    }
                    else 
                    {
                            $record=array(
                                'status'=>true,
                                'totalrecord'=>$totalrecord,
                                'validrecord'=>$validrecord,
                                'notvalidrecord'=>$notvalidrecord,
                                'updaterecord'=>$updaterecord,
                                'insertrecord'=>$insertrecord,
                                'message'=>'Record not found in Product Metal file.'
                            );
                             return  $record; 
                    }
    }
    
    public function ProductStoneImport($sheetData)
    {
        $totalrecord=0;
        $validrecord=0;
        $notvalidrecord=0;
        $updaterecord=0;
        $insertrecord=0;
                    if(isset($sheetData[2]))
                    {
                        $Index= array('Design','Stone_Type','Stone','Shape','Cut','Clarity','Color','Color2','Size','Intensity','Lab','Certificate_no','Certificate_file','Treated','Overtone','Origin','Quantity','Weight','Unit','Cost_Price','Tag_Price','Sale_Price');
                      
                            $designArray=array();
                            $arrayCount = count($sheetData);
                            $flag = 0;
                            $IndexArray=array();
                            foreach($Index as $Indexrow)
                            {
                                $IndexArray[$Indexrow]=$Indexrow;
                            }
                            $DataKey = array();
                            foreach ($sheetData as $dataInSheet) {
                                foreach ($dataInSheet as $key => $value) {
                                    if (in_array(trim($value), $Index)) {
                                        $value = preg_replace('/\s+/', '', $value);
                                        $DataKey[trim($value)] = $key;
                                    } 
                                }
                            }
                            $dataDiff = array_diff_key($IndexArray, $DataKey);
                            if (empty($dataDiff)) {
                                 $flag = 1;
                            }
                            // match excel sheet column
                            if($flag == 1) 
                            {
                                for ($i = 2; $i <= $arrayCount; $i++) 
                                {
                                   
                                    $Design = filter_var(trim($sheetData[$i][$DataKey['Design']]), FILTER_SANITIZE_STRING);
                                    if($Design=='') 
                                    { 
                                        continue;
                                    } 
                                    else
                                    {
                                        $totalrecord++;
                                    }
                                    $StoneType = filter_var(trim($sheetData[$i][$DataKey['Stone_Type']]), FILTER_SANITIZE_STRING);
                                    $StoneType=strtolower($StoneType);
                                    if($Design=='' || $StoneType=='')
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Stone Row No. '.$i.' Not Valid. Design And Stone type Required.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    if($StoneType!='white' &&  $StoneType!='fancy' && $StoneType!='gemstone')
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                         $record=array(
                                              'status'=>false,
                                              'message'=>'Product Stone Row No. '.$i.' Stone Type Not Valid.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    
                                    $product=$this->ImportModel->getProduct($Design);
                                    if(!$product)
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Stone Row No. '.$i.' Product Not Found.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    else
                                    {
                                        $product_code=$product['product_code'];
                                        $productid=$product['id'];
                                    }
                                   
                                    $stone = filter_var(trim($sheetData[$i][$DataKey['Stone']]), FILTER_SANITIZE_STRING);
                                    
                                    $stoneid=$this->ImportModel->getMasterId($stone,$table="stone",$filed="stoneid");
                                    if($stoneid<1)
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Stone Row No. '.$i.' Stone Not Valid.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    $shape = filter_var(trim($sheetData[$i][$DataKey['Shape']]), FILTER_SANITIZE_STRING);
                                    $shapeid=$this->ImportModel->getMasterId($shape,$table="shape",$filed="shapeid");
                                    
                                    
                                    $stonecut = filter_var(trim($sheetData[$i][$DataKey['Cut']]), FILTER_SANITIZE_STRING);
                                    $stonecutid=$this->ImportModel->getMasterId($stonecut,$table="stonecut",$filed="stonecutid");
                                    
                                    $clarity = filter_var(trim($sheetData[$i][$DataKey['Clarity']]), FILTER_SANITIZE_STRING);
                                    $clarityid=$this->ImportModel->getMasterId($clarity,$table="clarity",$filed="clarityid");
                                    
                                    if($StoneType=='white')
                                    {
                                        $colorid1=0;
                                        $color1='';
                                        $colorid2=0;
                                        $color2='';
                                        $color=filter_var(trim($sheetData[$i][$DataKey['Color']]), FILTER_SANITIZE_STRING);
                                    }
                                    else
                                    {
                                       $color=''; 
                                       $color1 = filter_var(trim($sheetData[$i][$DataKey['Color']]), FILTER_SANITIZE_STRING);
                                       $colorid1=$this->ImportModel->getMasterId($color1,$table="color",$filed="colorid");
                                       $color2 = filter_var(trim($sheetData[$i][$DataKey['Color2']]), FILTER_SANITIZE_STRING);
                                       $colorid2=$this->ImportModel->getMasterId($color2,$table="color",$filed="colorid");
                                    }
                                    
                                    $stonesize = filter_var(trim($sheetData[$i][$DataKey['Size']]), FILTER_SANITIZE_STRING);
                                    $stonesizeid=$this->ImportModel->getMasterId($stonesize,$table="stonesize",$filed="stonesizeid");
                                    
                                    $intensity = filter_var(trim($sheetData[$i][$DataKey['Intensity']]), FILTER_SANITIZE_STRING);
                                    $intensityid=$this->ImportModel->getMasterId($intensity,$table="intensity",$filed="intensityid");
                                    
                                    $lab = filter_var(trim($sheetData[$i][$DataKey['Lab']]), FILTER_SANITIZE_STRING);
                                    $labid=$this->ImportModel->getMasterId($lab,$table="lab",$filed="labid");
                                    $certificateno = filter_var(trim($sheetData[$i][$DataKey['Certificate_no']]), FILTER_SANITIZE_STRING);
                                    $certificate = filter_var(trim($sheetData[$i][$DataKey['Certificate_file']]), FILTER_SANITIZE_STRING);
                                    
                                    $treatment = filter_var(trim($sheetData[$i][$DataKey['Treated']]), FILTER_SANITIZE_STRING);
                                    $treatmentid=$this->ImportModel->getMasterId($treatment,$table="treatment",$filed="treatmentid");
                                    $overtone = filter_var(trim($sheetData[$i][$DataKey['Overtone']]), FILTER_SANITIZE_STRING);
                                    $origin = filter_var(trim($sheetData[$i][$DataKey['Origin']]), FILTER_SANITIZE_STRING);
                                    $quantity = filter_var(trim($sheetData[$i][$DataKey['Quantity']]), FILTER_SANITIZE_STRING);
                                    $weight = filter_var(trim($sheetData[$i][$DataKey['Weight']]), FILTER_SANITIZE_STRING);
                                    $unit = filter_var(trim($sheetData[$i][$DataKey['Unit']]), FILTER_SANITIZE_STRING);
                                     $tag_price = filter_var(trim($sheetData[$i][$DataKey['Cost_Price']]), FILTER_SANITIZE_STRING);
                                    $tag_price = filter_var(trim($sheetData[$i][$DataKey['Tag_Price']]), FILTER_SANITIZE_STRING);
                                    $sale_price = filter_var(trim($sheetData[$i][$DataKey['Sale_Price']]), FILTER_SANITIZE_STRING);
                                    
                                    
                                    $stoneData= array(
                                                    'productcode'=>$product_code,
                                                    'productid'=>$productid,
                                                    'stonetype'=>$StoneType,
                                                    'stoneid'=>$stoneid,
                                                    'stone'=>$stone,
                                                    'shapeid'=>$shapeid,
                                                    'shape'=>$shape,
                                                    'stonecutid'=>$stonecutid,
                                                    'stonecut'=>$stonecut,
                                                    'clarityid'=>$clarityid,
                                                    'clarity'=>$clarity,
                                                    'color'=>$color,
                                                    'colorid1'=>$colorid1,
                                                    'color1'=>$color1,
                                                    'colorid2'=>$colorid2,
                                                    'color2'=>$color2,
                                                    'stonesize'=>$stonesize,
                                                    'stonesizeid'=>$stonesizeid,
                                                    'intensityid'=>$intensityid,
                                                    'intensity'=>$intensity,
                                                    'lab'=>$lab,
                                                    'labid'=>$labid,
                                                    'certificateno'=>$certificateno,
                                                    'certificate'=>$certificate,
                                                    'treatmentid'=>$treatmentid,
                                                    'treatment'=>$treatment,
                                                    'origin'=>$origin,
                                                    'quantity'=>$quantity,
                                                    'weight'=>$weight,
                                                    'unit'=>$unit,
                                                    'cost_price'=>$tag_price,
                                                    'tag_price'=>$tag_price,
                                                    'sale_price'=>$sale_price,
                                                    'overtone'=>$overtone,
                                                );
                                        
                                       if (!in_array($Design, $designArray))
                                        {
                                            $this->ImportModel->delete_stone($product_code,$productid);
                                        }
                                            
                                        $designArray[]=$Design;
                                        
                                        $insert_stone=$this->ImportModel->insert_stone($stoneData);
                                        if($insert_stone)
                                        {
                                            $insertrecord++;
                                            $validrecord++;
                                            $masterProductPrice=array(
                                                'cost_price'=>$tag_price,
                                                'tag_price'=>$tag_price,
                                                'sale_price'=>$sale_price,
                                                );
                                            $this->ImportModel->UpdatemasterProductPrice($masterProductPrice,$product_code,$productid);
                                        }
                                    
                                        
                                    
                                }   
                        }
                            
                                $record=array(
                                    'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                    'message'=>'Product Stone Successfuly Insert'
                                    );
                                return  $record;       
                            
                               
                        
                    }
                    else 
                    {
                            $record=array(
                                  'status'=>true,
                                  'totalrecord'=>$totalrecord,
                                   'validrecord'=>$validrecord,
                                   'notvalidrecord'=>$notvalidrecord,
                                   'updaterecord'=>$updaterecord,
                                   'insertrecord'=>$insertrecord,
                                  'message'=>'Record not found in Product Stone file.'
                                  );
                                  
                             return  $record; 
                    }
    
    }
    
    public function ProductVariationImport($sheetData)
    {
                    $totalrecord=0;
                    $validrecord=0;
                    $notvalidrecord=0;
                    $updaterecord=0;
                    $insertrecord=0;
                    if(isset($sheetData[2]))
                    {
                        $Index= array('Design','Metal','Size','Quantity','Weight','Unit','Cost_Price','Tag_Price','Sale_Price');
                            $designArray=array();
                            $arrayCount = count($sheetData);
                            $flag = 0;
                            $IndexArray=array();
                            foreach($Index as $Indexrow)
                            {
                                $IndexArray[$Indexrow]=$Indexrow;
                            }
                            $DataKey = array();
                            foreach ($sheetData as $dataInSheet) {
                                foreach ($dataInSheet as $key => $value) {
                                    if (in_array(trim($value), $Index)) {
                                        $value = preg_replace('/\s+/', '', $value);
                                        $DataKey[trim($value)] = $key;
                                    } 
                                }
                            }
                            $dataDiff = array_diff_key($IndexArray, $DataKey);
                            if (empty($dataDiff)) {
                                 $flag = 1;
                            }
                            // match excel sheet column
                            if($flag == 1) 
                            {
                                for ($i = 2; $i <= $arrayCount; $i++) 
                                {
                                   
                                    $Design = filter_var(trim($sheetData[$i][$DataKey['Design']]), FILTER_SANITIZE_STRING);
                                    if($Design=='') 
                                    { 
                                        continue;
                                    } 
                                    else
                                    {
                                        $totalrecord++;
                                    } 
                                    $product=$this->ImportModel->getProduct($Design);
                                    if(!$product)
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                         $record=array(
                                              'status'=>false,
                                              'message'=>'Product Variation Row No. '.$i.' Product Not Found.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    else
                                    {
                                        $product_code=$product['product_code'];
                                        $productid=$product['id'];
                                    }
                                    
                                    $metal = filter_var(trim($sheetData[$i][$DataKey['Metal']]), FILTER_SANITIZE_STRING);
                                    $metalid=$this->ImportModel->getMasterId($metal,$table="metal",$filed="metalid");
                                    $size = filter_var(trim($sheetData[$i][$DataKey['Size']]), FILTER_SANITIZE_STRING);
                                    $sizeid=$this->ImportModel->getMasterId($size,$table="size",$filed="sizeid");
                                    $quantity = filter_var(trim($sheetData[$i][$DataKey['Quantity']]), FILTER_SANITIZE_STRING);
                                    $weight = filter_var(trim($sheetData[$i][$DataKey['Weight']]), FILTER_SANITIZE_STRING);
                                    $unit = filter_var(trim($sheetData[$i][$DataKey['Unit']]), FILTER_SANITIZE_STRING);
                                    $cost_price = filter_var(trim($sheetData[$i][$DataKey['Cost_Price']]), FILTER_SANITIZE_STRING);
                                    $tag_price = filter_var(trim($sheetData[$i][$DataKey['Tag_Price']]), FILTER_SANITIZE_STRING);
                                    $sale_price = filter_var(trim($sheetData[$i][$DataKey['Sale_Price']]), FILTER_SANITIZE_STRING);
                                    if($Design=='' || $metal=='' || $metalid==0 || $metalid=='' || $quantity=='' ||  $sale_price=='')
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Variation Row No. '.$i.' Not Valid.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    
                                    $VariationData= array(
                                                    'productcode'=>$product_code,
                                                    'productid'=>$productid,
                                                    'metal'=>$metal,
                                                    'metalid'=>$metalid,
                                                    'size'=>$size,
                                                    'sizeid'=>$sizeid,
                                                    'weight'=>$weight,
                                                    'weightunit'=>$unit,
                                                    'quantity'=>$quantity,
                                                    'cost_price'=>$cost_price,
                                                    'tag_price'=>$tag_price,
                                                    'sale_price'=>$sale_price,
                                                );
                                        
                                        if (!in_array($Design, $designArray))
                                        {
                                               $this->ImportModel->delete_Variation($product_code,$productid);
                                        }
                                            
                                        $designArray[]=$Design;
                                       
                                        $insert_Variation=$this->ImportModel->insert_Variation($VariationData);
                                        if($insert_Variation)
                                        {
                                            $insertrecord++;
                                            $validrecord++;
                                        }
                                    
                                }   
                        }
                            
                                $record=array(
                                    'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                    'message'=>'Product Variation Successfuly Insert'
                                    );
                                return  $record;       
                            
                              
                        
                    }
                    else 
                    {
                            $record=array(
                                  'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                  'message'=>'Record not found in Product Variation file.'
                                  );
                                  
                             return  $record; 
                    }
    
    
    }
    
    public function ProductImagesImport($sheetData)
    {
                    $totalrecord=0;
                    $validrecord=0;
                    $notvalidrecord=0;
                    $updaterecord=0;
                    $insertrecord=0;
                    if(isset($sheetData[2]))
                    {
                        $Index= array('Design','Image','Thumbnail');
                            $designArray=array();
                            
                            $arrayCount = count($sheetData);
                            $flag = 0;
                            $IndexArray=array();
                            
                            foreach($Index as $Indexrow)
                            {
                                $IndexArray[$Indexrow]=$Indexrow;
                            }
                            $DataKey = array();
                            foreach ($sheetData as $dataInSheet) {
                                foreach ($dataInSheet as $key => $value) {
                                    if (in_array(trim($value), $Index)) {
                                        $value = preg_replace('/\s+/', '', $value);
                                        $DataKey[trim($value)] = $key;
                                    } 
                                }
                            }
                            $dataDiff = array_diff_key($IndexArray, $DataKey);
                            if (empty($dataDiff)) {
                                 $flag = 1;
                            }
                            // match excel sheet column
                            if ($flag == 1) 
                            {
                                $thumbproductids=array();
                                for ($i = 2; $i <= $arrayCount; $i++) 
                                {
                                    $Design = filter_var(trim($sheetData[$i][$DataKey['Design']]), FILTER_SANITIZE_STRING);
                                    if($Design=='') 
                                    { 
                                        continue;
                                    } 
                                    else
                                    {
                                        $totalrecord++;
                                    }
                                    
                                    $Image = filter_var(trim($sheetData[$i][$DataKey['Image']]), FILTER_SANITIZE_STRING);
                                    $Thumbnail = filter_var(trim($sheetData[$i][$DataKey['Thumbnail']]), FILTER_SANITIZE_STRING);
                                    if($Image=='')
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                        $record=array(
                                              'status'=>false,
                                              'message'=>'Product Image Row No. '.$i.' is Blank.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    
                                    $product=$this->ImportModel->getProduct($Design);
                                    if(!$product)
                                    {
                                        $notvalidrecord++;
                                        $this->db->transRollback();
                                        $this->ImportModel->DeleteTempJewelryProducts();
                                         $record=array(
                                              'status'=>false,
                                              'message'=>'Product Image Row No. '.$i.' Product Not Found.'
                                              );
                                        echo json_encode($record);
                                        die;
                                        continue;
                                    }
                                    else
                                    {
                                        $product_code=$product['product_code'];
                                        $productid=$product['id'];
                                    }
                                    
                                    if($Thumbnail=='yes' || $Thumbnail=='Yes')
                                    {
                                            $imageData= array(
                                                'thumbnail'=>$Image,
                                            );
                                        $thumbproductids[]=$productid; 
                                        $this->ImportModel->update_productThumbnail($imageData,$productid,$product_code);    
                                        // $updaterecord++;
                                        // $validrecord++; 
                                        // continue;
                                    }    
                                    
                                         
                                        if (!in_array($productid, $thumbproductids))
                                        {
                                            $imageData= array(
                                                'thumbnail'=>$Image,
                                            );
                                            $this->ImportModel->update_productThumbnail($imageData,$productid,$product_code);
                                        } 
                                        
                                        
                                       
                                            if (!in_array($Design, $designArray))
                                            {
                                              $this->ImportModel->delete_image($product_code,$productid);
                                            }
                                            
                                            $designArray[]=$Design;
                                             $imageData= array(
                                                'productid'=>$productid,
                                                'productcode'=>$product_code,
                                                'image'=>$Image,
                                            );
                                            $insert_image=$this->ImportModel->insert_image($imageData);
                                            if($insert_image)
                                            {
                                                $insertrecord++;
                                                $validrecord++;
                                            }
                                        
                                    
                                    
                                }   
                        }

                                $record=array(
                                    'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                    'message'=>'Product Image Successfuly Insert'
                                    );
                                return  $record;       
                            
                                
                        
                    }
                    else 
                    {
                            $record=array(
                                  'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                  'message'=>'Record not found in Product Image file.'
                                  );
                                  
                             return  $record; 
                    }
    
    }
    
    
    public function importtracking()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
            $data=[];
            $data['page']='importtracking';
            return view('Admin/admin_index',$data);
        
        
    }
    // $sheetData = $spreadsheet->getActiveSheet()->toArray();

    public function importtrackingSubmit()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($this->request->getFile('file'))
        { // Valid
            $masterrecord=array();
            
             if($file = $this->request->getFile('file')) 
             {
                if ($file->isValid() && ! $file->hasMoved()) 
                {
                   // Get random file name
                   $newName = $file->getRandomName();
                   $name = $file->getName();
                   $extension = $file->getClientExtension();
    
                   // Store file in public/csvfile/ folder
                   $file->move('./public/uploads/csvfile/', $newName);
                   $filepath = "public/uploads/csvfile/".$newName;
                   // Reading file
  
                    if('csv' == $extension){
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                    } else {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                    }
                    
                    $spreadsheet = $reader->load($filepath);
                    
                    $OrdertrackingsheetData=$spreadsheet->getSheetByName('Order Tracking')->toArray(null, true, true, true);
                   
                    $ImportImportOrdertrackingRecord=$this->ordertrackingsheet($OrdertrackingsheetData);
                    
                            $response=array(
                              'status'=>true,
                              'Ordertracking'=>$ImportImportOrdertrackingRecord,
                              'message'=>'Records inserted successfully!'
                            );
                            echo json_encode($response);  
                            return;
                
                }else{
                                $response=array(
                                    'status'=>false,
                                    'message'=>'File not imported.'
                                );
                                echo json_encode($response);  
                                return;
                  
                }
             }else{
                 $response=array(
                              'status'=>false,
                              'message'=>'File not imported.'
                              );
                            echo json_encode($response);  
                            return;
             }
    
      
        }
    }
    
    public function ordertrackingsheet($OrdertrackingsheetData)
    {
       
                    if(isset($OrdertrackingsheetData[2]))
                    {
                        
                        if(count($OrdertrackingsheetData[1])==5)
                        {   
                            
                            $totalrecord=0;
                            $validrecord=0;
                            $notvalidrecord=0;
                            $updaterecord=0;
                            $insertrecord=0;
                            $arrayCount = count($OrdertrackingsheetData);
                            $flag = 0;
                            $OrdertrackingIndexArray=array();
                            $OrdertrackingIndex= array('Order_Id','Shipping_Company','Tracking_Link','Tracking_ID','Note');
                            foreach($OrdertrackingIndex as $OrdertrackingIndexrow)
                            {
                                $OrdertrackingIndexArray[$OrdertrackingIndexrow]=$OrdertrackingIndexrow;
                            }
                            $OrdertrackingSheetDataKey = array();
                            foreach ($OrdertrackingsheetData as $dataInSheet) {
                                foreach ($dataInSheet as $key => $value) {
                                    if (in_array(trim($value), $OrdertrackingIndex)) {
                                        $value = preg_replace('/\s+/', '', $value);
                                        $OrdertrackingSheetDataKey[trim($value)] = $key;
                                    } 
                                }
                            }
                            
                            $dataDiff = array_diff_key($OrdertrackingIndexArray, $OrdertrackingSheetDataKey);
                           
                            if (empty($dataDiff)) 
                            {
                                 $flag = 1;
                            }
                           
                            // match excel sheet column
                            if ($flag == 1) 
                            {
                               
                                for ($i = 2; $i <= $arrayCount; $i++) 
                                {
                                    $Order_Id = filter_var(trim($OrdertrackingsheetData[$i][$OrdertrackingSheetDataKey['Order_Id']]), FILTER_SANITIZE_STRING);
                                    if($Order_Id=='') 
                                    { 
                                        $notvalidrecord++;
                                         
                                        continue;
                                    } 
                                    else
                                    {
                                        $totalrecord++;
                                    }
                                    
                                    $Shipping_Company = filter_var(trim($OrdertrackingsheetData[$i][$OrdertrackingSheetDataKey['Shipping_Company']]), FILTER_SANITIZE_STRING);
                                    $Shipping_Company_Row=$this->ImportModel->getShipping_Company($Shipping_Company);
                                    
                                    $Tracking_Link = filter_var(trim($OrdertrackingsheetData[$i][$OrdertrackingSheetDataKey['Tracking_Link']]), FILTER_SANITIZE_STRING);
                                    $Tracking_ID = filter_var(trim($OrdertrackingsheetData[$i][$OrdertrackingSheetDataKey['Tracking_ID']]), FILTER_SANITIZE_STRING);
                                    $Note = filter_var(trim($OrdertrackingsheetData[$i][$OrdertrackingSheetDataKey['Note']]), FILTER_SANITIZE_STRING);
                                    if($Order_Id=='' || $Shipping_Company=='' || $Tracking_ID=='')
                                    {
                                        $notvalidrecord++;
                                         
                                        continue;
                                    }
                                    
                                    if($Shipping_Company_Row)
                                    {
                                        if($Tracking_Link!='')
                                        {
                                            $Tracking_Link=$Tracking_Link;
                                        }
                                        else
                                        {
                                            $Tracking_Link=$Shipping_Company_Row['tracking_link'];
                                        }
                                        $slug=$Shipping_Company_Row['slug'];
                                        $shippingcompanyid=$Shipping_Company_Row['id'];
                                    }
                                    else
                                    {
                                        if($Tracking_Link=='')
                                        {
                                            $notvalidrecord++;
                                             
                                            continue;
                                        }
                                        else
                                        {
                                            $slug=slugify($Shipping_Company);
                                            $sort_order_max=$this->ImportModel->getShipping_CompanysortOrder();
                                            if($sort_order_max)
                                            {
                                                $sequence=$sort_order_max['sequence']+1;
                                            }
                                            else
                                            {
                                                $sequence=1;
                                            }
                                            $data=array(
                                                'company_title'=>$Shipping_Company,
                                    			'slug'=>$slug,
                                                'tracking_link'=>$Tracking_Link,
                                    			'company_logo'=>'',
                                                'sequence'=>$sequence,
                                            );
                                            $orderno=$Order_Id;
                                            $orderDetail=$this->OrderModel->orderDetail($orderno);
                                			if(isset($orderDetail))
                                			{
                                                $shippingcompanyid=$this->ImportModel->insert_shippingcompany($data); 
                                            }
                                            else
                                            {
                                                $notvalidrecord++;
                                                 
                                                continue;
                                            }
                                        }
                                    }         
                                    $orderno=  $Order_Id;       
                                    $orderDetail=$this->OrderModel->orderDetail($orderno);
                        			if(isset($orderDetail))
                        			{
                        				$trackingDetails=array(
                        					'orderid'=>$orderno,
                        					'userid'=>$orderDetail['userid'],
                        					'shipping_company_id'=>$shippingcompanyid,
                        					'shipping_company_slug'=>$slug,
                        					'shipping_company'=>$Shipping_Company,
                        					'order_tracking_link'=>$Tracking_Link,
                        					'tracking_id'=>$Tracking_ID,
                        					'note'=>$Note,
                        				);
                        				
                        				$ChecktrackingDetails=$this->OrderModel->ChecktrackingDetails($orderno);
                        				if(isset($ChecktrackingDetails))
                        				{
                        					$this->OrderModel->updatetrackingDetails($orderno,$trackingDetails);
                        					$updaterecord++;
                        					$validrecord++;
                        				}
                        				else
                        				{
                        					$this->OrderModel->inserttrackingDetails($orderno,$trackingDetails);
                        					$insertrecord++;
                        					$validrecord++;
                        				}
                        				$tracking_id_update=array(
                        					'tracking_id'=>$Tracking_ID,
                        				);
                        				$this->OrderModel->updateOrderinvoice($orderno,$tracking_id_update);
                        			}
                        			else
                        			{
                        				$notvalidrecord++;
                        				 
                                        continue;
                        			}                                                
                                }   
                            }
                            
                            
                                $record=array(
                                    'status'=>true,
                                    'totalrecord'=>$totalrecord,
                                    'validrecord'=>$validrecord,
                                    'notvalidrecord'=>$notvalidrecord,
                                    'updaterecord'=>$updaterecord,
                                    'insertrecord'=>$insertrecord,
                                    'message'=>'Order Tracking Successfuly Insert'
                                    );
                                return  $record;       
                            
                        }        
                        else 
                        {
                            
                            $record=array(
                                  'status'=>false,
                                  'message'=>'Please import correct Import Order Tracking file, did not match excel sheet column'
                                  );
                                  
                            return  $record;    
                        }
                    }
                    else 
                    {
                            
                            $record=array(
                                  'status'=>false,
                                  'message'=>'Record not found in Import Order Tracking file.'
                                  );
                                  
                             return  $record; 
                    }
    }
    
}
