<?php
namespace App\Controllers\Admin;
use App\Models\MasterModel;
use App\Controllers\BaseController;
use App\Controllers\RenderImage;
class Master extends BaseController
{
    public function __construct()
    {
        $this->MasterModel = new MasterModel();  
    }
    
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    public function lang_slug($unserializeName)
    {
       
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
        }
    }
    
    //category
    public function addcategory()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Category";
        $data['categories'] = $this->MasterModel->getcategory();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addcategory';
        return view('Admin/admin_index',$data);
    }
    public function insert_category()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('category_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/category/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/category/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
		 
		 if($design_jewelryfile = $this->request->getFile('design_jewelry')) 
        {
                    if ($design_jewelryfile->isValid() && ! $design_jewelryfile->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $design_jewelryfile->getName();
                         $ext = $design_jewelryfile->getClientExtension();

                         // Get random file name
                         $newName = $design_jewelryfile->getRandomName(); 
                          
                         // Store file in public/uploads/folder
                         $design_jewelryfile->move('./public/design-your-own-jewelry/start/', $newName);

                         // File path to display preview
                         $design_jewelry = "public/design-your-own-jewelry/start/".$newName;
                    }
                    else
                    {
                        $design_jewelry='';
                    }
        }  
        else
        {
            $design_jewelry='';
        }
		
		if($design_stonefile = $this->request->getFile('design_stone')) 
        {
                    if ($design_stonefile->isValid() && ! $design_stonefile->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $design_stonefile->getName();
                         $ext = $design_stonefile->getClientExtension();

                         // Get random file name
                         $newName = $design_stonefile->getRandomName(); 
                          
                         // Store file in public/uploads/folder
                         $design_stonefile->move('./public/design-your-own-jewelry/start/', $newName);

                         // File path to display preview
                         $design_stone = "public/design-your-own-jewelry/start/".$newName;
                    }
                    else
                    {
                        $design_stone='';
                    }
        }  
        else
        {
            $design_stone='';
        }
        
        $language_arr = $this->request->getVar('category_language');
        $name_arr = $this->request->getVar('category_name');
        $category_parent = $this->request->getVar('category_parent');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $CategorySlug=$this->lang_slug($unserializeName);
        $field='categoryid'; 
        $table='category'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['categoryid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'categoryid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$CategorySlug,
            'image'=>$filepath,
			'design_jewelry'=>$design_jewelry,
			'design_stone'=>$design_stone,
            'parent'=>$category_parent,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_category($data); 
        return redirect()->to('/admin/category');
    }
    
    public function editcategory($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $category= $this->MasterModel->getcategoryID($i);

        if(isset($category))
        {
            $data['title']="Edit Category";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['categories'] = $this->MasterModel->getcategory();
            $data['category']  = $category;
            $data['page'] ='editcategory';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/category');  
        }
        
    }
    
    public function update_category($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('category_image')) 
        {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                          
                         // Store file in public/uploads/folder
                         $file->move('./public/uploads/category/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/category/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
        }  
        else
        {
            $filepath='';
        }
		
		if($design_jewelryfile = $this->request->getFile('design_jewelry')) 
        {
                    if ($design_jewelryfile->isValid() && ! $design_jewelryfile->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $design_jewelryfile->getName();
                         $ext = $design_jewelryfile->getClientExtension();

                         // Get random file name
                         $newName = $design_jewelryfile->getRandomName(); 
                          
                         // Store file in public/uploads/folder
                         $design_jewelryfile->move('./public/design-your-own-jewelry/start/', $newName);

                         // File path to display preview
                         $design_jewelry = "public/design-your-own-jewelry/start/".$newName;
                    }
                    else
                    {
                        $design_jewelry='';
                    }
        }  
        else
        {
            $design_jewelry='';
        }
		
		if($design_stonefile = $this->request->getFile('design_stone')) 
        {
                    if ($design_stonefile->isValid() && ! $design_stonefile->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $design_stonefile->getName();
                         $ext = $design_stonefile->getClientExtension();

                         // Get random file name
                         $newName = $design_stonefile->getRandomName(); 
                          
                         // Store file in public/uploads/folder
                         $design_stonefile->move('./public/design-your-own-jewelry/start/', $newName);

                         // File path to display preview
                         $design_stone = "public/design-your-own-jewelry/start/".$newName;
                    }
                    else
                    {
                        $design_stone='';
                    }
        }  
        else
        {
            $design_stone='';
        }
        
        $language_arr = $this->request->getVar('category_language');
        $name_arr = $this->request->getVar('category_name');
        $category_parent = $this->request->getVar('category_parent');
		$design = $this->request->getVar('design');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'parent'=>$category_parent,
			'design'=>$design,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['image']=$filepath;
        }
		if($design_jewelry!='')
        {
            $data['design_jewelry']=$design_jewelry;
        }
		if($design_stone!='')
        {
            $data['design_stone']=$design_stone;
        }
        $this->MasterModel->update_category($data,$id); 
        return redirect()->to('/admin/category');
    }
    
    public function category()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['category'] = $this->MasterModel->getcategory();
        $data['page']='category';
        return view('Admin/admin_index',$data);
    }
     public function getcategory()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('category')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('category')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('category')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

        $data = array();
        $i=1;
       foreach($records as $record )
       {
           $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           $category_name=unserialize($record['name']);
           $category=$category_name['en'];
           $parentcategory= $this->MasterModel->getcategoryID($record['parent']);
           if(isset($parentcategory))
           {
           $parent_category_name=unserialize($parentcategory['name']);
           $parent=$parent_category_name['en'];
           }
           else
           {
             $parent='NONE';  
           }
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editcategory/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "categoryid"=>$record['categoryid'],
             "Image"=>$image,
             "Category"=>$category,
             "Parent"=>$parent,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function categorystatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_category_status($status,$id); 
             
    }
    
    
    
    public function categorydelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MasterModel->category_delete($id);  
    }
    
        //color
    
    public function addcolor()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Category";
        $data['colors'] = $this->MasterModel->getcolor();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addcolor';
        return view('Admin/admin_index',$data);
    }
    public function insert_color()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('color_language');
        $name_arr = $this->request->getVar('color_name');
        $color = $this->request->getVar('color');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $ColorSlug=$this->lang_slug($unserializeName);
        $field='colorid'; 
        $table='color'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['colorid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'colorid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$ColorSlug,
            'color'=>$color,
            'sequence'=>$sort_order,
            );
        if($file = $this->request->getFile('diamond_color')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/diamond_color/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/diamond_color/".$newName;
                         $data['diamond_color']=$filepath;
                    }
                   
         }    
        
        $this->MasterModel->insert_color($data); 
        return redirect()->to('/admin/color');
    }
    
    public function editcolor($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $color= $this->MasterModel->getcolorID($i);

        if(isset($color))
        {
            $data['title']="Add Color";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['colors'] = $this->MasterModel->getcolor();
            $data['color']  = $color;
            $data['page'] ='editcolor';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/color');  
        }
    }
    
    public function update_color($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('color_language');
        $name_arr = $this->request->getVar('color_name');
        $color = $this->request->getVar('color');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'color'=>$color,
            'sequence'=>$sort_order,
            );
        if($file = $this->request->getFile('diamond_color')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/diamond_color/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/diamond_color/".$newName;
                         $data['diamond_color']=$filepath;
                    }
         }     
        
        $this->MasterModel->update_color($data,$id); 
        return redirect()->to('/admin/color');
    }
    
    public function color()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['color'] = $this->MasterModel->getcolor();
        $data['page']='color';
        return view('Admin/admin_index',$data);
    }
    public function getcolor()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('color')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('color')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('color')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $color_name=unserialize($record['name']);
           $color=$color_name['en'];
           
           if($record['diamond_color']!='')
           {
           $image='<img src="'.base_url().$record['diamond_color'].'" class="table-img">';
           }
           else
           {
               $image='None';
           }
           
           $color_code="<span class='color-code-show' style='background:".$record['color']."'></span>";
           
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editcolor/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "colorid"=>$record['colorid'],
             'image'=>$image,
             "Color_Code"=>$color_code,
             "Color"=>$color,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function colorstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_color_status($status,$id); 
             
    }
    
    public function colordelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->color_delete($id);  
    }
    
    //design
    
    public function adddesign()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Design";
        $data['designs'] = $this->MasterModel->getdesign();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='adddesign';
        return view('Admin/admin_index',$data);
    }
    public function insert_design()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('design_language');
        $name_arr = $this->request->getVar('design_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $DesignSlug=$this->lang_slug($unserializeName);
        $field='designid'; 
        $table='design'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['designid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'designid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$DesignSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_design($data); 
        return redirect()->to('/admin/design');
    }
    
    public function editdesign($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $design= $this->MasterModel->getdesignID($i);

        if(isset($design))
        {
            $data['title']="Edit Design";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['designs'] = $this->MasterModel->getdesign();
            $data['design']  = $design;
            $data['page'] ='editdesign';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/design');  
        }
    }
    
    public function update_design($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('design_language');
        $name_arr = $this->request->getVar('design_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_design($data,$id); 
        return redirect()->to('/admin/design');
    }
    
    public function design()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['design'] = $this->MasterModel->getdesign();
        $data['page']='design';
        return view('Admin/admin_index',$data);
    }
    public function getdesign()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('design')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('design')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('design')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $design_name=unserialize($record['name']);
           $design=$design_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editdesign/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "designid"=>$record['designid'],
             "Design"=>$design,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function designstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_design_status($status,$id); 
             
    }
    
    public function designdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->design_delete($id);  
    }
    
    //size
    
    public function addsize()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Size";
        $data['sizes'] = $this->MasterModel->getsize();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addsize';
        return view('Admin/admin_index',$data);
    }
    public function insert_size()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('size_language');
        $name_arr = $this->request->getVar('size_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $SizeSlug=$this->lang_slug($unserializeName);
        $field='sizeid'; 
        $table='size'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['sizeid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'sizeid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$SizeSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_size($data); 
        return redirect()->to('/admin/size');
    }
    
    public function editsize($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $size= $this->MasterModel->getsizeID($i);

        if(isset($size))
        {
            $data['title']="Edit Size";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['sizes'] = $this->MasterModel->getsize();
            $data['size']  = $size;
            $data['page'] ='editsize';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/size');  
        }
    }
    
    public function update_size($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('size_language');
        $name_arr = $this->request->getVar('size_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_size($data,$id); 
        return redirect()->to('/admin/size');
    }
    
    public function size()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['size'] = $this->MasterModel->getsize();
        $data['page']='size';
        return view('Admin/admin_index',$data);
    }
    public function getsize()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('size')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('size')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('size')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $size_name=unserialize($record['name']);
           $size=$size_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editsize/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "sizeid"=>$record['sizeid'],
             "Size"=>$size,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function sizestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_size_status($status,$id); 
             
    }
    
    public function sizedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->size_delete($id);  
    }
    
    //stonecut
    
    public function addstonecut()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Stone Cut";
        $data['stonecuts'] = $this->MasterModel->getstonecut();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addstonecut';
        return view('Admin/admin_index',$data);
    }
    public function insert_stonecut()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('stonecut_language');
        $name_arr = $this->request->getVar('stonecut_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $StoneCutSlug=$this->lang_slug($unserializeName);
        $field='stonecutid'; 
        $table='stonecut'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['stonecutid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'stonecutid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$StoneCutSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_stonecut($data); 
        return redirect()->to('/admin/stone-cut');
    }
    
    public function editstonecut($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $stonecut= $this->MasterModel->getstonecutID($i);

        if(isset($stonecut))
        {
            $data['title']="Edit Stone Cut";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['stonecuts'] = $this->MasterModel->getstonecut();
            $data['stonecut']  = $stonecut;
            $data['page'] ='editstonecut';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/stone-cut');  
        }
    }
    
    public function update_stonecut($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('stonecut_language');
        $name_arr = $this->request->getVar('stonecut_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_stonecut($data,$id); 
        return redirect()->to('/admin/stone-cut');
    }
    
    public function stonecut()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['page']='stonecut';
        return view('Admin/admin_index',$data);
    }
    public function getstonecut()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('stonecut')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('stonecut')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('stonecut')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $stonecut_name=unserialize($record['name']);
           $stonecut=$stonecut_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editstonecut/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "stonecutid"=>$record['stonecutid'],
             "StoneCut"=>$stonecut,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function stonecutstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_stonecut_status($status,$id); 
             
    }
    
    public function stonecutdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->stonecut_delete($id);  
    }
    
  
  //stonesize
    
    public function addstonesize()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Stone Size";
        $data['stonesizes'] = $this->MasterModel->getstonesize();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addstonesize';
        return view('Admin/admin_index',$data);
    }
    public function insert_stonesize()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('stonesize_language');
        $name_arr = $this->request->getVar('stonesize_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $StoneSizeSlug=$this->lang_slug($unserializeName);
        $field='stonesizeid'; 
        $table='stonesize'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['stonesizeid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'stonesizeid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$StoneSizeSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_stonesize($data); 
        return redirect()->to('/admin/stone-size');
    }
    
    public function editstonesize($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $stonesize= $this->MasterModel->getstonesizeID($i);

        if(isset($stonesize))
        {
            $data['title']="Edit Stone Size";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['stonesizes'] = $this->MasterModel->getstonesize();
            $data['stonesize']  = $stonesize;
            $data['page'] ='editstonesize';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/stone-size');  
        }
    }
    
    public function update_stonesize($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('stonesize_language');
        $name_arr = $this->request->getVar('stonesize_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_stonesize($data,$id); 
        return redirect()->to('/admin/stone-size');
    }
    
    public function stonesize()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['stonesize'] = $this->MasterModel->getstonesize();
        $data['page']='stonesize';
        return view('Admin/admin_index',$data);
    }
    public function getstonesize()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('stonesize')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('stonesize')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('stonesize')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $stonesize_name=unserialize($record['name']);
           $stonesize=$stonesize_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editstonesize/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "stonesizeid"=>$record['stonesizeid'],
             "StoneCut"=>$stonesize,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function stonesizestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_stonesize_status($status,$id); 
             
    }
    
    public function stonesizedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->stonesize_delete($id);  
    }
    
    
    
    //age
    
    public function addage()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Age";
        $data['ages'] = $this->MasterModel->getage();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addage';
        return view('Admin/admin_index',$data);
    }
    public function insert_age()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('age_language');
        $name_arr = $this->request->getVar('age_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $AgeSlug=$this->lang_slug($unserializeName);
        $field='ageid'; 
        $table='age'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['ageid']+1;
       }
       else
       {
           $GetMaxId=1;
       }

        $data=array(
            'ageid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$AgeSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_age($data); 
        return redirect()->to('/admin/age');
    }
    
    public function editage($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $age= $this->MasterModel->getageID($i);

        if(isset($age))
        {
            $data['title']="Edit Age";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['ages'] = $this->MasterModel->getage();
            $data['age']  = $age;
            $data['page'] ='editage';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/age');  
        }
    }
    
    public function update_age($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('age_language');
        $name_arr = $this->request->getVar('age_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_age($data,$id); 
        return redirect()->to('/admin/age');
    }
    
    public function age()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['age'] = $this->MasterModel->getage();
        $data['page']='age';
        return view('Admin/admin_index',$data);
    }
    public function getage()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('age')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('age')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('age')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $age_name=unserialize($record['name']);
           $age=$age_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editage/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "ageid"=>$record['ageid'],
             "Age"=>$age,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function agestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_age_status($status,$id); 
             
    }
    
    public function agedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->age_delete($id);  
    }
    
    //metal
    
    public function addmetal()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Metal";
        $data['metals'] = $this->MasterModel->getmetal();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addmetal';
        return view('Admin/admin_index',$data);
    }
    public function insert_metal()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('metal_language');
        $name_arr = $this->request->getVar('metal_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $MetalSlug=$this->lang_slug($unserializeName);
        $field='metalid'; 
        $table='metal'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['metalid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'metalid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$MetalSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_metal($data); 
        return redirect()->to('/admin/metal');
    }
    
    public function editmetal($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $metal= $this->MasterModel->getmetalID($i);

        if(isset($metal))
        {
            $data['title']="Edit Metal";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['metals'] = $this->MasterModel->getmetal();
            $data['metal']  = $metal;
            $data['page'] ='editmetal';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/metal');  
        }
    }
    
    public function update_metal($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('metal_language');
        $name_arr = $this->request->getVar('metal_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_metal($data,$id); 
        return redirect()->to('/admin/metal');
    }
    
    public function metal()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['metal'] = $this->MasterModel->getmetal();
        $data['page']='metal';
        return view('Admin/admin_index',$data);
    }
    public function getmetal()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('metal')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('metal')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('metal')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $metal_name=unserialize($record['name']);
           $metal=$metal_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editmetal/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "metalid"=>$record['metalid'],
             "Metal"=>$metal,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function metalstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_metal_status($status,$id); 
             
    }
    
    public function metaldelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->metal_delete($id);  
    }
    
    //collection
    public function addcollection()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Collection";
        $data['categories'] = $this->MasterModel->getcollection();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addcollection';
        return view('Admin/admin_index',$data);
    }
    public function insert_collection()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('collection_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/collection/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/collection/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('collection_language');
        $name_arr = $this->request->getVar('collection_name');
        $sort_order = $this->request->getVar('sort_order');
    
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $CollectionSlug=$this->lang_slug($unserializeName);
        $field='collectionid'; 
        $table='collection'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['collectionid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'collectionid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$CollectionSlug,
            'image'=>$filepath,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_collection($data); 
        return redirect()->to('/admin/collection');
    }
    
    public function editcollection($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $collection= $this->MasterModel->getcollectionID($i);

        if(isset($collection))
        {
            $data['title']="Edit Collection";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['categories'] = $this->MasterModel->getcollection();
            $data['collection']  = $collection;
            $data['page'] ='editcollection';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/collection');  
        }
        
    }
    
    public function update_collection($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('collection_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/collection/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/collection/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('collection_language');
        $name_arr = $this->request->getVar('collection_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['image']=$filepath;
        }
        $this->MasterModel->update_collection($data,$id); 
        return redirect()->to('/admin/collection');
    }
    
    public function collection()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['collection'] = $this->MasterModel->getcollection();
        $data['page']='collection';
        return view('Admin/admin_index',$data);
    }
     public function getcollection()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('collection')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('collection')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('collection')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record )
       {
           $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           $collection_name=unserialize($record['name']);
           $collection=$collection_name['en'];
           
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editcollection/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "collectionid"=>$record['collectionid'],
             "Image"=>$image,
             "Collection"=>$collection,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function collectionstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_collection_status($status,$id); 
             
    }
    
    public function collectiondelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MasterModel->collection_delete($id);  
    }
    
    //style
    public function addstyle()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Style";
        $data['categories'] = $this->MasterModel->getstyle();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addstyle';
        return view('Admin/admin_index',$data);
    }
    public function insert_style()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('style_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/style/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/style/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('style_language');
        $name_arr = $this->request->getVar('style_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $StyleSlug=$this->lang_slug($unserializeName);
        $field='styleid'; 
        $table='style'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['styleid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'styleid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$StyleSlug,
            'image'=>$filepath,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_style($data); 
        return redirect()->to('/admin/style');
    }
    
    public function editstyle($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $style= $this->MasterModel->getstyleID($i);

        if(isset($style))
        {
            $data['title']="Edit Style";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['categories'] = $this->MasterModel->getstyle();
            $data['style']  = $style;
            $data['page'] ='editstyle';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/style');  
        }
        
    }
    
    public function update_style($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('style_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/style/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/style/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('style_language');
        $name_arr = $this->request->getVar('style_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['image']=$filepath;
        }
        $this->MasterModel->update_style($data,$id); 
        return redirect()->to('/admin/style');
    }
    
    public function style()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['style'] = $this->MasterModel->getstyle();
        $data['page']='style';
        return view('Admin/admin_index',$data);
    }
     public function getstyle()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('style')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('style')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('style')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record )
       {
           $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           $style_name=unserialize($record['name']);
           $style=$style_name['en'];
           
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editstyle/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "styleid"=>$record['styleid'],
             "Image"=>$image,
             "Style"=>$style,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function stylestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_style_status($status,$id); 
             
    }
    
    public function styledelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MasterModel->style_delete($id);  
    }
	//stone
    public function addstone()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Stone";
        $data['categories'] = $this->MasterModel->getstone();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addstone';
        return view('Admin/admin_index',$data);
    }
    public function insert_stone()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('stone_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/stone/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/stone/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('stone_language');
        $name_arr = $this->request->getVar('stone_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $StoneSlug=$this->lang_slug($unserializeName);
        $field='stoneid'; 
        $table='stone'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['stoneid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'stoneid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$StoneSlug,
            'image'=>$filepath,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_stone($data); 
        return redirect()->to('/admin/stone');
    }
    
    public function editstone($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $stone= $this->MasterModel->getstoneID($i);

        if(isset($stone))
        {
            $data['title']="Edit Stone";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['categories'] = $this->MasterModel->getstone();
            $data['stone']  = $stone;
            $data['page'] ='editstone';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/stone');  
        }
        
    }
    
    public function update_stone($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('stone_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/stone/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/stone/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('stone_language');
        $name_arr = $this->request->getVar('stone_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['image']=$filepath;
        }
        $this->MasterModel->update_stone($data,$id); 
        return redirect()->to('/admin/stone');
    }
    
    public function stone()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['stone'] = $this->MasterModel->getstone();
        $data['page']='stone';
        return view('Admin/admin_index',$data);
    }
     public function getstone()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('stone')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('stone')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('stone')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record )
       {
           $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           $stone_name=unserialize($record['name']);
           $stone=$stone_name['en'];
           
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editstone/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "stoneid"=>$record['stoneid'],
             "Image"=>$image,
             "Stone"=>$stone,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function stonestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_stone_status($status,$id); 
             
    }
    
    public function stonedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MasterModel->stone_delete($id);  
    }
    
    //occasion
    public function addoccasion()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Occasion";
        $data['categories'] = $this->MasterModel->getoccasion();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addoccasion';
        return view('Admin/admin_index',$data);
    }
    public function insert_occasion()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('occasion_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/occasion/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/occasion/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('occasion_language');
        $name_arr = $this->request->getVar('occasion_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $OccasionSlug=$this->lang_slug($unserializeName);
        $field='occasionid'; 
        $table='occasion'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['occasionid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'occasionid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$OccasionSlug,
            'image'=>$filepath,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_occasion($data); 
        return redirect()->to('/admin/occasion');
    }
    
    public function editoccasion($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $occasion= $this->MasterModel->getoccasionID($i);

        if(isset($occasion))
        {
            $data['title']="Edit Occasion";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['categories'] = $this->MasterModel->getoccasion();
            $data['occasion']  = $occasion;
            $data['page'] ='editoccasion';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/occasion');  
        }
        
    }
    
    public function update_occasion($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('occasion_image')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/occasion/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/occasion/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('occasion_language');
        $name_arr = $this->request->getVar('occasion_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['image']=$filepath;
        }
        $this->MasterModel->update_occasion($data,$id); 
        return redirect()->to('/admin/occasion');
    }
    
    public function occasion()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['page']='occasion';
        return view('Admin/admin_index',$data);
    }
     public function getoccasion()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('occasion')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('occasion')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('occasion')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1;
       foreach($records as $record )
       {
           $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           $occasion_name=unserialize($record['name']);
           $occasion=$occasion_name['en'];
           
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editoccasion/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "occasionid"=>$record['occasionid'],
             "Image"=>$image,
             "Occasion"=>$occasion,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function occasionstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_occasion_status($status,$id); 
             
    }
    
    public function occasiondelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MasterModel->occasion_delete($id);  
    }
    
    
    //store
    
    public function addstore()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Gender";
        $data['stores'] = $this->MasterModel->getstore();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addstore';
        return view('Admin/admin_index',$data);
    }
    public function insert_store()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('store_language');
        $name_arr = $this->request->getVar('store_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $NameSlug=$this->lang_slug($unserializeName);
       
        $data=array(
            'name'=>$serialized_name,
            'slug'=>$NameSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_store($data); 
        return redirect()->to('/admin/store');
    }
    
    public function editstore($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $store= $this->MasterModel->getstoreID($i);

        if(isset($store))
        {
            $data['title']="Edit Gender";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['stores'] = $this->MasterModel->getstore();
            $data['store']  = $store;
            $data['page'] ='editstore';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/store');  
        }
    }
    
    public function update_store($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('store_language');
        $name_arr = $this->request->getVar('store_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_store($data,$id); 
        return redirect()->to('/admin/store');
    }
    
    public function store()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['store'] = $this->MasterModel->getstore();
        $data['page']='store';
        return view('Admin/admin_index',$data);
    }
    public function getstore()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('store')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('store')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('store')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $store_name=unserialize($record['name']);
           $store=$store_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editstore/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "Store"=>$store,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function storestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_store_status($status,$id); 
             
    }
    
    public function storedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->store_delete($id);  
    }
    
    
    //gender
    
    public function addgender()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Gender";
        $data['genders'] = $this->MasterModel->getgender();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addgender';
        return view('Admin/admin_index',$data);
    }
    public function insert_gender()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('gender_language');
        $name_arr = $this->request->getVar('gender_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $GenderSlug=$this->lang_slug($unserializeName);
        $field='genderid'; 
        $table='gender'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
        
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['genderid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
       
        $data=array(
            'genderid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$GenderSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_gender($data); 
        return redirect()->to('/admin/gender');
    }
    
    public function editgender($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $gender= $this->MasterModel->getgenderID($i);

        if(isset($gender))
        {
            $data['title']="Edit Gender";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['genders'] = $this->MasterModel->getgender();
            $data['gender']  = $gender;
            $data['page'] ='editgender';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/gender');  
        }
    }
    
    public function update_gender($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('gender_language');
        $name_arr = $this->request->getVar('gender_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_gender($data,$id); 
        return redirect()->to('/admin/gender');
    }
    
    public function gender()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['gender'] = $this->MasterModel->getgender();
        $data['page']='gender';
        return view('Admin/admin_index',$data);
    }
    public function getgender()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('gender')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('gender')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('gender')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $gender_name=unserialize($record['name']);
           $gender=$gender_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editgender/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "genderid"=>$record['genderid'],
             "Gender"=>$gender,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function genderstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_gender_status($status,$id); 
             
    }
    
    public function genderdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->gender_delete($id);  
    }
    //add diamond view 
    public function adddiamond()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->MasterModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['metal'] = $this->MasterModel->getmetal();
        $data['shape'] = $this->MasterModel->getshape();
        $data['design'] = $this->MasterModel->getdesign();
        $data['color'] = $this->MasterModel->getcolor();
        $data['size'] = $this->MasterModel->getsize();
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['style'] = $this->MasterModel->getstyle();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['origin'] = $this->MasterModel->getorigin();
        $data['treatment'] = $this->MasterModel->gettreatment();
        
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['stonesize'] = $this->MasterModel->getstonesize();
        
        $data['labs'] = $this->MasterModel->getlab();
        
        $data['units'] = $this->MasterModel->getunit();
        $data['polish'] = $this->MasterModel->getpolish();
        $data['symmetry'] = $this->MasterModel->getsymmetry();
        $data['girdle'] = $this->MasterModel->getgirdle();
        $data['girdlecondition'] = $this->MasterModel->getgirdlecondition();
        $data['culetsize'] = $this->MasterModel->getculetsize();
        $data['culetcondition'] = $this->MasterModel->getculetcondition();
        $data['fluoresenceintensity'] = $this->MasterModel->getfluoresenceintensity();
        $data['inclusion'] = $this->MasterModel->getinclusion();
        $data['milky'] = $this->MasterModel->getmilky();
        
        $data['page']='adddiamond';
        return view('Admin/admin_index',$data);
    }
    
    
    public function editdiamond($id)
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        if(!isset($this->session->admin))
        {
            unset($_SESSION['productid']);
        }
        $productid=base64_decode($id);
        $data['productmaster']=$this->MasterModel->GetProductMaster($productid);
        $this->session->set('productid',$data['productmaster']['id']);
        $data['productimages']=$this->MasterModel->Getproductimages($productid);
        $productstones=$this->MasterModel->Getproductstones($productid);
        if($productstones)
        {
        $data['productstone']=$productstones[0];
        }
        else
        {
            $data['productstone']=$productstones;
        }
        $data['productvariations']=$this->MasterModel->Getproductvariations($productid);
        $data['productmorecertificate']=$this->MasterModel->Getproductmorecertificate($productid);
        
        
        $data['language'] = $this->MasterModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['metal'] = $this->MasterModel->getmetal();
        $data['shape'] = $this->MasterModel->getshape();
        $data['design'] = $this->MasterModel->getdesign();
        $data['color'] = $this->MasterModel->getcolor();
        $data['size'] = $this->MasterModel->getsize();
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['style'] = $this->MasterModel->getstyle();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['origin'] = $this->MasterModel->getorigin();
        $data['treatment'] = $this->MasterModel->gettreatment();
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['stonesize'] = $this->MasterModel->getstonesize();
        
        $data['labs'] = $this->MasterModel->getlab();
        
        $data['units'] = $this->MasterModel->getunit();
        $data['polish'] = $this->MasterModel->getpolish();
        $data['symmetry'] = $this->MasterModel->getsymmetry();
        $data['girdle'] = $this->MasterModel->getgirdle();
        $data['girdlecondition'] = $this->MasterModel->getgirdlecondition();
        $data['culetsize'] = $this->MasterModel->getculetsize();
        $data['culetcondition'] = $this->MasterModel->getculetcondition();
        $data['fluoresenceintensity'] = $this->MasterModel->getfluoresenceintensity();
        $data['inclusion'] = $this->MasterModel->getinclusion();
        $data['milky'] = $this->MasterModel->getmilky();
        
        $data['page']='editdiamond';
        return view('Admin/admin_index',$data);
    }
    
    //add gemstone view 
    public function addgemstone()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->MasterModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['metal'] = $this->MasterModel->getmetal();
        $data['shape'] = $this->MasterModel->getshape();
        $data['design'] = $this->MasterModel->getdesign();
        $data['color'] = $this->MasterModel->getcolor();
        $data['size'] = $this->MasterModel->getsize();
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['style'] = $this->MasterModel->getstyle();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['origin'] = $this->MasterModel->getorigin();
        $data['treatment'] = $this->MasterModel->gettreatment();
        
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['stonesize'] = $this->MasterModel->getstonesize();
        
        $data['labs'] = $this->MasterModel->getlab();
        
        $data['units'] = $this->MasterModel->getunit();
        $data['polish'] = $this->MasterModel->getpolish();
        $data['symmetry'] = $this->MasterModel->getsymmetry();
        $data['girdle'] = $this->MasterModel->getgirdle();
        $data['girdlecondition'] = $this->MasterModel->getgirdlecondition();
        $data['culetsize'] = $this->MasterModel->getculetsize();
        $data['culetcondition'] = $this->MasterModel->getculetcondition();
        $data['fluoresenceintensity'] = $this->MasterModel->getfluoresenceintensity();
        $data['inclusion'] = $this->MasterModel->getinclusion();
        $data['milky'] = $this->MasterModel->getmilky();
        
        $data['page']='addgemstone';
        return view('Admin/admin_index',$data);
    }
    
    
    public function editgemstone($id)
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        if(!isset($this->session->admin))
        {
            unset($_SESSION['productid']);
        }
        $productid=base64_decode($id);
        $data['productmaster']=$this->MasterModel->GetProductMaster($productid);
        $this->session->set('productid',$data['productmaster']['id']);
        $data['productimages']=$this->MasterModel->Getproductimages($productid);
        $data['productstone']=$this->MasterModel->Getproductstones($productid)[0];
        $data['productvariations']=$this->MasterModel->Getproductvariations($productid);
        $data['productmorecertificate']=$this->MasterModel->Getproductmorecertificate($productid);
        
        $data['language'] = $this->MasterModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['metal'] = $this->MasterModel->getmetal();
        $data['shape'] = $this->MasterModel->getshape();
        $data['design'] = $this->MasterModel->getdesign();
        $data['color'] = $this->MasterModel->getcolor();
        $data['size'] = $this->MasterModel->getsize();
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['style'] = $this->MasterModel->getstyle();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['origin'] = $this->MasterModel->getorigin();
        $data['treatment'] = $this->MasterModel->gettreatment();
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['stonesize'] = $this->MasterModel->getstonesize();
        
        $data['labs'] = $this->MasterModel->getlab();
        
        $data['units'] = $this->MasterModel->getunit();
        $data['polish'] = $this->MasterModel->getpolish();
        $data['symmetry'] = $this->MasterModel->getsymmetry();
        $data['girdle'] = $this->MasterModel->getgirdle();
        $data['girdlecondition'] = $this->MasterModel->getgirdlecondition();
        $data['culetsize'] = $this->MasterModel->getculetsize();
        $data['culetcondition'] = $this->MasterModel->getculetcondition();
        $data['fluoresenceintensity'] = $this->MasterModel->getfluoresenceintensity();
        $data['inclusion'] = $this->MasterModel->getinclusion();
        $data['milky'] = $this->MasterModel->getmilky();
        
        $data['page']='editgemstone';
        return view('Admin/admin_index',$data);
    }
    
    //add product view 
    public function addproduct()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['language'] = $this->MasterModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['metal'] = $this->MasterModel->getmetal();
        $data['shape'] = $this->MasterModel->getshape();
        $data['age'] = $this->MasterModel->getage();
        $data['gender'] = $this->MasterModel->getgender();
        $data['design'] = $this->MasterModel->getdesign();
        $data['color'] = $this->MasterModel->getcolor();
        $data['size'] = $this->MasterModel->getsize();
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['style'] = $this->MasterModel->getstyle();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['origin'] = $this->MasterModel->getorigin();
        $data['treatment'] = $this->MasterModel->gettreatment();
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['stonesize'] = $this->MasterModel->getstonesize();
        $data['labs'] = $this->MasterModel->getlab();
        
        $data['units'] = $this->MasterModel->getunit();
        $data['page']='addproduct';
        return view('Admin/admin_index',$data);
    }
    
    public function editproduct($id)
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        if(!isset($this->session->admin))
        {
            unset($_SESSION['productid']);
        }
        $productid=base64_decode($id);
        $data['productmaster']=$this->MasterModel->GetProductMaster($productid);
        $this->session->set('productid',$data['productmaster']['id']);
        $data['productimages']=$this->MasterModel->Getproductimages($productid);
        $data['productothermetals']=$this->MasterModel->Getproductothermetals($productid);
        $data['productstones']=$this->MasterModel->Getproductstones($productid);
        $data['productvariations']=$this->MasterModel->Getproductvariations($productid);
        
        $data['language'] = $this->MasterModel->getlanguage();
        $data['category'] = $this->MasterModel->getcategory();
        $data['collection'] = $this->MasterModel->getcollection();
        $data['metal'] = $this->MasterModel->getmetal();
        $data['shape'] = $this->MasterModel->getshape();
        $data['age'] = $this->MasterModel->getage();
        $data['gender'] = $this->MasterModel->getgender();
        $data['design'] = $this->MasterModel->getdesign();
        $data['color'] = $this->MasterModel->getcolor();
        $data['size'] = $this->MasterModel->getsize();
        $data['occasion'] = $this->MasterModel->getoccasion();
        $data['style'] = $this->MasterModel->getstyle();
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['origin'] = $this->MasterModel->getorigin();
        $data['treatment'] = $this->MasterModel->gettreatment();
        $data['stone'] = $this->MasterModel->getstone();
        $data['stonecut'] = $this->MasterModel->getstonecut();
        $data['stonesize'] = $this->MasterModel->getstonesize();
        $data['labs'] = $this->MasterModel->getlab();
        
        $data['units'] = $this->MasterModel->getunit();
        $data['page']='editproduct';
        return view('Admin/admin_index',$data);
    }
    
    public function products()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='products';
        $data['category'] = $this->MasterModel->getcategory();
        return view('Admin/admin_index',$data);
    }
    
    public function getproduct()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       //$columnIndex = $dtpostData['order'][0]['column']; // Column index
       //$columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       //$columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       // Custom filter
        $producttype = $dtpostData['producttype'];
        $productcategory = $dtpostData['productcategory'];
        $productstatus = $dtpostData['productstatus'];
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('products')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('products');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->where('deleted_at', NULL);
                                        if($producttype)
                                        {
                                            $totalRecordwithFilter->where('producttype', $producttype);   
                                        }
                                        if($productcategory)
                                        {
                                            $totalRecordwithFilter->where('categoryid', $productcategory);   
                                        }
                                        if($productstatus)
                                        {
                                            $totalRecordwithFilter->where('status', "$productstatus");   
                                        }
                                        if($productstatus==0 || $productstatus=="0")
                                        {
                                            $totalRecordwithFilter->where('status', "$productstatus");   
                                        }
                                        if($stratDate)
                                        {
                                            $totalRecordwithFilter->where('updateDate >=', $stratDate);
                                        }
                                        if($endDate)
                                        {
                                            $totalRecordwithFilter->where('updateDate <=', $endDate);
                                        }
                                      

                              $totalRecordwithFilter->groupStart();  // Start group for OR conditions

$totalRecordwithFilter->like('title', $searchValue);
$totalRecordwithFilter->orLike('product_code', $searchValue);

$totalRecordwithFilter->groupEnd();  // End group for OR conditions
        $totalRecordwithFilter = $totalRecordwithFilter->countAllResults();

       ## Fetch records
       $records =   $this->db->table('products');
                    $records->select('*');
                    $records->select('products.*,count(productcode) as total_visit');
                    $records->join('product_visitors', 'product_visitors.productcode = products.product_code', 'LEFT');
                    
                     $records->groupStart();  // Start group for OR conditions

$records->like('title', $searchValue);
$records->orLike('product_code', $searchValue);

$records->groupEnd();  // End group for OR conditions
                  
                    $records->where('deleted_at', NULL);
                               if(!empty($producttype))
                                {
                                    $records->where('producttype', $producttype);   
                                }
                                if($productcategory)
                                {
                                    $records->where('categoryid', $productcategory);   
                                }
                                if($productstatus)
                                {
                                    $records->where('status', "$productstatus");   
                                }
                                if($productstatus==0 || $productstatus=="0")
                                {
                                    $records->where('status', "$productstatus");   
                                }
                                if($stratDate)
                                {
                                    $records->where('updateDate >=', $stratDate);
                                }
                                if($endDate)
                                {
                                    $records->where('updateDate <=', $endDate);
                                }
                    $records->orderBy('updateDate','DESC');
                    $records->groupBy('products.id');

                    $records->limit($rowperpage, $start);
        $records =  $records->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $productid=$record['id'];
            
            $image='<img src="'.settings('product_thumbnail_url').$record['thumbnail'].'" class="table-img">';
            $collectionid=$record['collectionid'];
            $collectionname='-';
            if($collectionid)
            {
                $collection=$this->MasterModel->getcollectionID($collectionid);
                if($collection)
                {
                    if(isset(unserialize($collection['name'])['en']))
                    {
                         $collectionname=unserialize($collection['name'])['en'];
                    }
                }
            }
            
           $categoryid=$record['categoryid'];
           $categoryname='-';
            if($categoryid)
            {
                $category=$this->MasterModel->getcategoryID($categoryid)['name'];
                if(isset(unserialize($category)['en']))
                {
                     $categoryname=unserialize($category)['en'];
                }
            }
            
           $status='';
           if($record['status']=='1')
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               if($record['producttype']=="jewelry")
               {
               $action.='<a href="'.base_url().'admin/editproduct/'.base64_encode($record['id']).'" data-id="'.base64_encode($record['id']).' class="edit-record">';
               }
               if($record['producttype']=="diamond")
               {
               $action.='<a href="'.base_url().'admin/editdiamond/'.base64_encode($record['id']).'" data-id="'.base64_encode($record['id']).' class="edit-record">';
               }
               if($record['producttype']=="gemstone")
               {
               $action.='<a href="'.base_url().'admin/editgemstone/'.base64_encode($record['id']).'" data-id="'.base64_encode($record['id']).' class="edit-record">';
               }
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['createDate']));
            $check='<input type="checkbox" class="checkSingle form-check-input" name="productcheck" value="'.$record['id'].'">';   
          $data[] = array( 
             "id"=>$check, 
             "Image"=>$image,
             "Code"=>'<a target="_blank" href="'.base_url().$record['producttype'].'/'.$record['slug'].'">'.$record['product_code'].'</a>',
             "title"=>'<a target="_blank"  href="'.base_url().$record['producttype'].'/'.$record['slug'].'">'.$record['title'].'</a>',
             "Category"=>$categoryname,
             "Type"=>ucfirst($record['producttype']),
             "Price"=>number_format($record['sale_price'],2),
             "quantity"=>$record['quantity'],
             "Status"=>$status,
             "total_visit"=>$record['total_visit'],
             "LastModied"=>$date,
             "action"=>$action,
          ); 

          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function ProductMasterSubmit($protype)
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        
        $product_code      = $this->request->getVar('product_code');
        $title             = $this->request->getVar('title');
        $short_description = $this->request->getVar('short_description');
        $quantity = $this->request->getVar('quantity');
        $cost_price = $this->request->getVar('cost_price');
        $tag_price = $this->request->getVar('tag_price');
        $sale_price = $this->request->getVar('sale_price');
        $long_description  = $this->request->getVar('long_description');
        $slug=strtolower(url_title($title.'-'.$product_code));
                                        
        if($protype=="diamond")
        {
            $ProductMasterData=array(
                'product_code'     =>$product_code,
                'title'            =>$title,
                'slug'             =>$slug,
                'updateDate'        =>date('Y-m-d h:i:s a', time()),
                'short_description' =>$short_description,
                'long_description' =>$long_description,
                'quantity'         =>$quantity,
                'cost_price'       =>$cost_price,
                'tag_price'       =>$tag_price,
                'sale_price'       =>$sale_price,
                'producttype'      =>$protype
                );
        }
        if($protype=="gemstone")
        {
                 $ProductMasterData=array(
                'product_code'     =>$product_code,
                'title'            =>$title,
                'slug'             =>$slug,
                'updateDate'        =>date('Y-m-d h:i:s a', time()),
                'short_description' =>$short_description,
                'long_description' =>$long_description,
                'quantity'         =>$quantity,
                'cost_price'       =>$cost_price,
                'tag_price'       =>$tag_price,
                'sale_price'       =>$sale_price,
                'producttype'      =>$protype
                );
        }
        
        if($protype=="jewelry")
        {
                    
        $design         = $this->request->getVar('design');
    
        
        $metalid           = $this->request->getVar('metal');
        $metal='';
        if(!empty($metalid))
        {
            $metal=$this->MasterModel->getmetalID($metalid)['name'];
        }
        
        $purity = $this->request->getVar('purity');
        
        $colorid           = $this->request->getVar('color');
        $color='';
        if(!empty($colorid))
        {
            $color=$this->MasterModel->getcolorID($colorid)['name'];
        }
        
        $sizeid            = $this->request->getVar('size');
        $size='';
        if(!empty($sizeid))
        {
            $size=$this->MasterModel->getsizeID($sizeid)['name'];
        }
        
        $length = $this->request->getVar('length');
        
        $categoryid        = $this->request->getVar('category');
        $category='';
        if(!empty($categoryid))
        {
            $category=$this->MasterModel->getcategoryID($categoryid)['name'];
        }
        
        if($this->request->getVar('category_type'))
        {
            $typeid        = $this->request->getVar('category_type');
            $type='';
            if(!empty($typeid))
            {
                $type=$this->MasterModel->gettypeID($typeid)['name'];
            }
        }
        else
        {
            $typeid=0;
            $type='';
        }
        
        $collectionid      = $this->request->getVar('collection');
        $collection='';
        if(!empty($collectionid))
        {
            $collection=$this->MasterModel->getcollectionID($collectionid)['name'];
        }
        
        $styleid           = $this->request->getVar('style');
        $style='';
        if(!empty($styleid))
        {
            $style=$this->MasterModel->getstyleID($styleid)['name'];
        }
        
        $occasionid        = $this->request->getVar('occasion');
        $occasion='';
        if(!empty($occasionid))
        {
            $occasion=$this->MasterModel->getoccasionID($occasionid)['name'];
        }
        
        $ageid           = $this->request->getVar('age');
        $age='';
        if(!empty($ageid))
        {
            $age=$this->MasterModel->getageID($ageid)['name'];
        }
        
        $genderid           = $this->request->getVar('gender');
        $gender='';
        if(!empty($genderid))
        {
            $gender=$this->MasterModel->getgenderID($genderid)['name'];
        }
        
        $gross_weight = $this->request->getVar('gross_weight');
        $net_weight = $this->request->getVar('net_weight');
        $weightunit = $this->request->getVar('weightunit');
        

            $ProductMasterData=array(
            'product_code'     =>$product_code,
            'title'            =>$title,
            'slug'             =>$slug,
            'design'           =>$design,
            'short_description'=>$short_description,
            'metalid'          =>$metalid,
            'metal'            =>$metal,
            'purity'           =>$purity,
            'colorid'          =>$colorid,
            'color'            =>$color,
            'sizeid'          =>$sizeid,
            'size'            =>$size,
            'length'           =>$length,
            'categoryid'       =>$categoryid,
            'category'         =>$category,
            'category_type'    =>$type,
            'category_typeid'  =>$typeid,
            'collectionid'     =>$collectionid,
            'collection'       =>$collection,
            'styleid'          =>$styleid,
            'style'            =>$style,
            'occasionid'       =>$occasionid,
            'occasion'         =>$occasion,
            'ageid'            =>$ageid,
            'age'           =>$age,
            'genderid'       =>$genderid,
            'gender'         =>$gender,
            'quantity'         =>$quantity,
            'gross_weight'     =>$gross_weight,
            'net_weight'       =>$net_weight,
            'weightunit'       =>$weightunit,
            'cost_price'       =>$cost_price,
            'tag_price'       =>$tag_price,
            'sale_price'       =>$sale_price,
            'updateDate'        =>date('Y-m-d h:i:s a', time()),
            'long_description' =>$long_description,
            'producttype'      =>$protype
            );
        }
        
        $exist_ProductMaster=$this->MasterModel->exist_ProductMaster($product_code);
        if($exist_ProductMaster)
        {
            $update_ProductMaster=$this->MasterModel->update_ProductMaster($ProductMasterData,$product_code);
            if($update_ProductMaster)
            {
                $productId=$exist_ProductMaster['id'];
                $this->session->set('productid',$productId);
                if($protype=="diamond")
                {
                 $this->ProductStoneadd();
                }
                if($protype=="gemstone")
                {
                 $this->ProductStoneadd();
                }
                if($protype=="jewelry")
                {
                    $this->ProductOtherMetaladd();
                }
                $return=array(
                    'status'=>true,
                    'productid'=>$productId,
                    'message'=>"Product Master Data Successfully Update.",
                    );
                echo json_encode($return);    
            }
            else
            {
                $return=array(
                    'status'=>false,
                    'message'=>"Product Master Not Insert.",
                    );
                echo json_encode($return); 
            }
        }
        else
        {
            $insert_ProductMaster=$this->MasterModel->insert_ProductMaster($ProductMasterData);
            if($insert_ProductMaster)
            {
                $productId=$insert_ProductMaster;
                $this->session->set('productid',$productId);
                if($protype=="diamond")
                {
                 $this->ProductStoneadd();
                }
                if($protype=="gemstone")
                {
                 $this->ProductStoneadd();
                }
                if($protype=="jewelry")
                {
                    $this->ProductOtherMetaladd();
                }
                $return=array(
                    'status'=>true,
                    'productid'=>$productId,
                    'message'=>"Product Master Data Successfully Insert.",
                    );
                echo json_encode($return); 
                return;
            }
            else
            {
                $return=array(
                    'status'=>false,
                    'message'=>"Product Master Not Insert.",
                    );
                echo json_encode($return); 
                return;
            }
        }
        
    }
    public function ProductthumbfileUpload()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        
        if($thumbnailfile = $this->request->getFile('file')) 
        {
            $productid=$_SESSION['productid'];
            $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
            if(isset($GetProductMaster))
            {
                    $product_code=$GetProductMaster['product_code'];
                    if ($thumbnailfile->isValid() && ! $thumbnailfile->hasMoved()) 
                    {
                         $imagename=$product_code.'_'.$thumbnailfile->getRandomName();
                         $image = \Config\Services::image()
                                ->withFile($thumbnailfile)
                                ->resize(328, 328, true, 'height')
                                ->save('./public/products/thumbnail/'. $imagename);
                
                            $thumbnailfile->move('./public/products/thumbnail/');
            
                    }  
                    
                    $thumbnailfile="public/products/thumbnail/".$imagename;
                    $thumbnailname=$imagename;
                    
                    
                        $product_code=$GetProductMaster['product_code'];
                        $productthumbData=array(
                            'thumbnail'=>$thumbnailname,
                            'thumbnailfile'=>$thumbnailfile,
                            'updateDate'        =>date('Y-m-d h:i:s a', time()),
                        );
                        $UpdateProductFinal=$this->MasterModel->UpdateProductFinal($productthumbData,$productid,$product_code);
                        if($UpdateProductFinal)
                        {
                                $return=array(
                                    'status'=>true,
                                    'message'=>"Product Thumbnail Successfully Add.",
                                    'thumbnailfile'=>base_url().$thumbnailfile
                                    );
                                echo json_encode($return);  
                                return;
                        }
                        else
                        {
                            $return=array(
                                    'status'=>false,
                                    'message'=>"Product Thumbnail Not Add.",
                                    );
                                echo json_encode($return);  
                                return;
                        }
                    }
            else
            {
                        $return=array(
                            'status'=>false,
                            'message'=>"Product Not Found.",
                            );
                        echo json_encode($return);  
                        return;
                    }
                    
        } 
        else
        {
            $return=array(
                'status'=>false,
                'message'=>"Thumbnail Image Not Set.",
                );
            echo json_encode($return);  
            return;
        }
        
                
    }
    public function ProductfileUpload()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        $newName='';
        if($this->request->getFile('file')) 
        {
            $productid=$_SESSION['productid'];
            $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        if(!isset($GetProductMaster))
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Product Image Not Insert.",
                                );
                            echo json_encode($return); 
                            return;
                        }
            $product_code=$GetProductMaster['product_code'];
            $imagefile1=$this->request->getFile('file');

            
            $imagename=$product_code.'_'.$imagefile1->getRandomName();
            $image3 = \Config\Services::image()
                    ->withFile($imagefile1)
                    ->save(FCPATH .'/public/products/large/'. $imagename);

            $image1 = \Config\Services::image()
                    ->withFile(FCPATH .'/public/products/large/'. $imagename)
                    ->resize(80, 80, true, 'height')
                    ->save(FCPATH .'/public/products/small/'. $imagename);

            $image2 = \Config\Services::image()
                    ->withFile(FCPATH .'/public/products/large/'. $imagename)
                    ->resize(328, 328, true, 'height')
                    ->save(FCPATH .'/public/products/thumbnail/'. $imagename);

        
                        $productImageData=array(
                            'productid'=>$productid,
                            'image'=>$imagename,
                            'productcode'=>$GetProductMaster['product_code']
                            );
                        $InserProductImage=$this->MasterModel->InserProductImage($productImageData); 
                        if($InserProductImage)
                        {
                             $productimageid=$InserProductImage;
                             $productImageData['status']=true;
                             $productImageData['message']="Product File Successfully Add.";
                             $productImageData['productimageid']=base64_encode($productimageid);
                             $productImageData['productid']=base64_encode($productid);
                        echo json_encode($productImageData);
                        }
                        else
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Product File Not Add.",
                                );
                            echo json_encode($return); 
                        }
        }             
    }
    
    public function SoftDeleteProductImage()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productimageid=base64_decode($this->request->getVar('productimageid'));
        $DeleteProductImage=$this->MasterModel->SoftDeleteProductImage($productimageid); 
        if($DeleteProductImage)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Image Successfully Delete.",
                                );
                            echo json_encode($return); 
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Image Not Delete.",
                                );
                            echo json_encode($return); 
        }
    }
    
    
    public function SoftDeleteProductStone()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productstoneid=$this->request->getVar('productstoneid');
        $productid=$_SESSION['productid'];
        $DeleteProductStone=$this->MasterModel->SoftDeleteProductStone($productstoneid,$productid); 
        if($DeleteProductStone)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Stone Successfully Delete.",
                                );
                            echo json_encode($return); 
                            return;
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Stone Not Delete.",
                                );
                            echo json_encode($return); 
                            return;
        }
    }
    
    public function DeleteProductCertificate()
    {
        
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productcertificateid=$this->request->getVar('productcertificateid');
        $productid=$_SESSION['productid'];
        $DeleteProductCertificate=$this->MasterModel->DeleteProductCertificate($productcertificateid,$productid); 
        if($DeleteProductCertificate)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Lab Certificate Successfully Delete.",
                                );
                            echo json_encode($return); 
                            return;
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Lab Certificate Not Delete.",
                                );
                            echo json_encode($return); 
                            return;
        }
    
    }
    
    public function RestoreProductStone()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productstoneid=$this->request->getVar('productstoneid');
        $productid=$_SESSION['productid'];
        $DeleteProductStone=$this->MasterModel->RestoreProductStone($productstoneid,$productid); 
        if($DeleteProductStone)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Stone Successfully Restore.",
                                );
                            echo json_encode($return); 
                            return;
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Stone Not Restore.",
                                );
                            echo json_encode($return); 
                            return;
        }
    }
    
    public function SoftDeleteProductVariation()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return); 
            return;
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productvariationid=$this->request->getVar('productvariationid');
        $productid=$_SESSION['productid'];

        $DeleteProductVariation=$this->MasterModel->SoftDeleteProductVariation($productvariationid,$productid); 
        if($DeleteProductVariation)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Variation Successfully Delete.",
                                );
                            echo json_encode($return); 
                            return;
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Variation Not Delete.",
                                );
                            echo json_encode($return); 
                            return;
        }
    }
    
    public function RestoreProductVariation()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productvariationid=$this->request->getVar('productvariationid');
        $productid=$_SESSION['productid'];
        $DeleteProducVariation=$this->MasterModel->RestoreProductVariation($productvariationid,$productid); 
        if($DeleteProducVariation)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Variation Successfully Restore.",
                                );
                            echo json_encode($return); 
                            return;
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Variation Not Restore.",
                                );
                            echo json_encode($return); 
                            return;
        }
    }
    
    public function fullDeleteProductImage()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $productid=$_SESSION['productid'];
        $DeleteProductImage=$this->MasterModel->fullDeleteProductImage($productid); 
        if($DeleteProductImage)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Image Successfully Update.",
                                );
                            echo json_encode($return); 
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Image Not Update.",
                                );
                            echo json_encode($return); 
        }
    }
    
    public function RestoreProductImage()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
        }
        
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $productimageid=base64_decode($this->request->getVar('productimageid'));
        $DeleteProductImage=$this->MasterModel->RestoreProductImage($productimageid); 
        if($DeleteProductImage)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Image Successfully Restore.",
                                );
                            echo json_encode($return); 
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Image Not Restore.",
                                );
                            echo json_encode($return); 
        }
    
    }
    public function DeleteProductImage()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
        }
        $productimageid=base64_decode($this->request->getVar('productimageid'));
        $productid=base64_decode($this->request->getVar('productid'));
        $DeleteProductImage=$this->MasterModel->DeleteProductImage($productimageid,$productid); 
        if($DeleteProductImage)
        {
            $return=array(
                                'status'=>true,
                                'message'=>"Product Image Successfully Delete.",
                                );
                            echo json_encode($return); 
        }
        else
        {
            $return=array(
                                'status'=>false,
                                'message'=>"Product Image Not Delete.",
                                );
                            echo json_encode($return); 
        }
    }
    public function ProductStoneUpdate()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
          $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }

        $stoneArr        = $this->request->getVar('stone[]');
        $productid=$_SESSION['productid'];;
        $deleteProductStone=$this->MasterModel->deleteProductStone($productid);
        if($stoneArr)
        {
            $totalStone=count($stoneArr);
            for ($x = 0; $x < $totalStone; $x++) 
            {
                
                $stonetype  = $this->request->getVar('stonetype')[$x];
                
                $stoneid        = $this->request->getVar('stone')[$x];
                $stone='';
                if(!empty($stoneid))
                {
                    $stone=$this->MasterModel->getstoneID($stoneid)['name'];
                }
                
                $shapeid        = $this->request->getVar('shape')[$x];
                $shape='';
                if(!empty($shapeid))
                {
                    $shape=$this->MasterModel->getshapeID($shapeid)['name'];
                    
                }
                
                $stonecutid        = $this->request->getVar('stonecut')[$x];
                $stonecut='';
                if(!empty($stonecutid))
                {
                    $stonecut=$this->MasterModel->getstonecutID($stonecutid)['name'];
                }
                
                $clarityid        = $this->request->getVar('clarity')[$x];
                $clarity='';
                if(!empty($clarityid))
                {
                    $clarity=$this->MasterModel->getclarityID($clarityid)['name'];
                    
                }
                
                $colorid1        = $this->request->getVar('color')[$x];
                $color1='';
                if(!empty($colorid1))
                {
                    $color1=$this->MasterModel->getcolorID($colorid1)['name'];
                    
                }
                
                $color        = $this->request->getVar('whitecolor')[$x];
                
                $stonesizeid        = $this->request->getVar('stonesize')[$x];
                $stonesize='';
                if(!empty($stonesizeid))
                {
                    $stonesize=$this->MasterModel->getstonesizeID($stonesizeid)['name'];
                }
                
                $intensityid        = $this->request->getVar('intensity')[$x];
                $intensity='';
                if(!empty($intensityid))
                {
                    $intensity=$this->MasterModel->getintensityID($intensityid)['name'];
                }
                
                $treatmentid        = $this->request->getVar('treatment')[$x];
                $treatment='';
                if(!empty($treatmentid))
                {
                    $treatment=$this->MasterModel->gettreatmentID($treatmentid)['name'];
                    
                }
                
                $originid        = $this->request->getVar('origin')[$x];
                $origin='';
                if(!empty($originid))
                {
                    $origin=$this->MasterModel->getoriginID($originid)['name'];
                    
                }
                
                $quantity      = $this->request->getVar('quantity')[$x];
                $weight        = $this->request->getVar('weight')[$x];
                $weightunit        = $this->request->getVar('weightunit')[$x];
                $tag_price        = $this->request->getVar('tag_price')[$x];
                $sale_price        = $this->request->getVar('sale_price')[$x];
                $labid        = $this->request->getVar('lab')[$x];
                $lab='';
                if(!empty($labid))
                {
                    $lab=$this->MasterModel->getlabID($labid)['name'];
                }
                $certificateno        = $this->request->getVar('certificateno')[$x];
               
                $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        if(!isset($GetProductMaster))
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Something Wrong.",
                                );
                            echo json_encode($return);
                            return;  
                        }
                        
                        $product_code=$GetProductMaster['product_code'];
                        $productStoneData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'stonetype'=>$stonetype,
                            'stoneid'=>$stoneid,
                            'stone'=>$stone,
                            'shapeid'=>$shapeid,
                            'shape'=>$shape,
                            'stonecutid'=>$stonecutid,
                            'stonecut'=>$stonecut,
                            'clarityid'=>$clarityid,
                            'clarity'=>$clarity,
                            'color'=>$color,
                            'colorid1'=>$colorid1,
                            'color1'=>$color1,
                            'stonesizeid'=>$stonesizeid,
                            'stonesize'=>$stonesize,
                            'intensityid'=>$intensityid,
                            'intensity'=>$intensity,
                            'treatmentid'=>$treatmentid,
                            'treatment'=>$treatment,
                            'originid'=>$originid,
                            'origin'=>$origin,
                            'quantity'=>$quantity,
                            'lab'=>$lab,
                            'labid'=>$labid,
                            'certificateno'=>$certificateno,
                            'weight'=>$weight,
                            'weightunit'=>$weightunit,
                            'tag_price'=>$tag_price,
                            'sale_price'=>$sale_price,
                            );
                        if($this->request->getFile('certificate'.$x))
                        {
                        if($file = $this->request->getFile('certificate'.$x)) 
                        {
                            if ($file->isValid() && ! $file->hasMoved()) 
                            {
                                 // Get file name and extension
                                 $name = $file->getName();
                                 $ext = $file->getClientExtension();
                                    if($certificateno!=='')
                                    {
                                        // Get random file name
                                         $newName = 'certificate'.$certificateno.'.'.$ext; 
                                         
                                    }
                                    else
                                    {
                                         // Get random file name
                                         $newName = $file->getRandomName(); 
                                    }
                                   
                                 // Store file in public/uploads/ folder
                                 $file->move('./public/uploads/certificate/', $newName);
        
                                 // File path to display preview
                                 $certificate = $newName;
                                 $productStoneData['certificate']=$certificate;
                            }
                        } 
                        }
                        if(isset($this->request->getVar('stoneid')[$x]))
                        {
                            $stoneid=$this->request->getVar('stoneid')[$x];
                            $InserProductStone=$this->MasterModel->UpdateProductStone($productStoneData,$stoneid); 
                        }
                        else
                        {
                            $InserProductStone=$this->MasterModel->InserProductStone($productStoneData); 
                        }
                        
            }
                    if($InserProductStone)
                        {
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Stone Successfully Update.",
                                    );
                                echo json_encode($return);  
                                
                        }
                        else
                        {
                            $return=array(
                                        'status'=>true,
                                        'message'=>"Product Stone Skip.",
                                        );
                                echo json_encode($return); 
                                return;
                        }
                        
                        
        }
        else
        {
            $return=array(
                'status'=>true,
                'message'=>"Product Stone Skip.",
            );
            echo json_encode($return);  
            return;
        }
    }
    public function ProductStoneSubmit()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
          $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $stoneArr        = $this->request->getVar('stone[]');
        $productid=$_SESSION['productid'];;
        $deleteProductStone=$this->MasterModel->deleteProductStone($productid);
        if($stoneArr)
        {
            $totalStone=count($stoneArr);
            for ($x = 0; $x < $totalStone; $x++) {
                
                $stoneid        = $this->request->getVar('stone')[$x];
                $stone='';
                if(!empty($stoneid))
                {
                    $stone=$this->MasterModel->getstoneID($stoneid)['name'];
                }
                
                $shapeid        = $this->request->getVar('shape')[$x];
                $shape='';
                if(!empty($shapeid))
                {
                    $shape=$this->MasterModel->getshapeID($shapeid)['name'];
                    
                }
                
                $stonecutid        = $this->request->getVar('stonecut')[$x];
                $stonecut='';
                if(!empty($stonecutid))
                {
                    $stonecut=$this->MasterModel->getstonecutID($stonecutid)['name'];
                }
                
                $clarityid        = $this->request->getVar('clarity')[$x];
                $clarity='';
                if(!empty($clarityid))
                {
                    $clarity=$this->MasterModel->getclarityID($clarityid)['name'];
                    
                }
                
                $colorid1        = $this->request->getVar('color')[$x];
                $color1='';
                if(!empty($colorid1))
                {
                    $color1=$this->MasterModel->getcolorID($colorid1)['name'];
                    
                }
                
                $color        = $this->request->getVar('whitecolor')[$x];
                
                $stonesizeid        = $this->request->getVar('stonesize')[$x];
                $stonesize='';
                if(!empty($stonesizeid))
                {
                    $stonesize=$this->MasterModel->getstonesizeID($stonesizeid)['name'];
                }
                
                $intensityid        = $this->request->getVar('intensity')[$x];
                $intensity='';
                if(!empty($intensityid))
                {
                    $intensity=$this->MasterModel->getintensityID($intensityid)['name'];
                }
                
                $treatmentid        = $this->request->getVar('treatment')[$x];
                $treatment='';
                if(!empty($treatmentid))
                {
                    $treatment=$this->MasterModel->gettreatmentID($treatmentid)['name'];
                    
                }
                
                $originid        = $this->request->getVar('origin')[$x];
                $origin='';
                if(!empty($originid))
                {
                    $origin=$this->MasterModel->getoriginID($originid)['name'];
                    
                }
                
                $quantity      = $this->request->getVar('quantity')[$x];
                $weight        = $this->request->getVar('weight')[$x];
                $weightunit        = $this->request->getVar('weightunit')[$x];
                $tag_price        = $this->request->getVar('tag_price')[$x];
                $sale_price        = $this->request->getVar('sale_price')[$x];
                $labid        = $this->request->getVar('lab')[$x];
                $lab='';
                if(!empty($labid))
                {
                    $lab=$this->MasterModel->getlabID($labid)['name'];
                }
                $certificateno        = $this->request->getVar('certificateno')[$x];
                    $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        if(!isset($GetProductMaster))
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Something Wrong.",
                                );
                            echo json_encode($return);
                            return;  
                        }
                        
                        $product_code=$GetProductMaster['product_code'];
                        $productStoneData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'stoneid'=>$stoneid,
                            'stone'=>$stone,
                            'shapeid'=>$shapeid,
                            'shape'=>$shape,
                            'stonecutid'=>$stonecutid,
                            'stonecut'=>$stonecut,
                            'clarityid'=>$clarityid,
                            'clarity'=>$clarity,
                            'color'=>$color,
                            'colorid1'=>$colorid1,
                            'color1'=>$color1,
                            'stonesizeid'=>$stonesizeid,
                            'stonesize'=>$stonesize,
                            'intensityid'=>$intensityid,
                            'intensity'=>$intensity,
                            'treatmentid'=>$treatmentid,
                            'treatment'=>$treatment,
                            'originid'=>$originid,
                            'origin'=>$origin,
                            'quantity'=>$quantity,
                            'weight'=>$weight,
                            'lab'=>$lab,
                            'labid'=>$labid,
                            'certificateno'=>$certificateno,
                            'weightunit'=>$weightunit,
                            'tag_price'=>$tag_price,
                            'sale_price'=>$sale_price,
                            );
                            if($this->request->getFile('certificate'.$x))
                        {
                        if($file = $this->request->getFile('certificate'.$x)) 
                        {
                            if ($file->isValid() && ! $file->hasMoved()) 
                            {
                                 // Get file name and extension
                                 $name = $file->getName();
                                 $ext = $file->getClientExtension();
                                    if($certificateno!=='')
                                    {
                                        // Get random file name
                                         $newName = 'certificate'.$certificateno.'.'.$ext; 
                                         
                                    }
                                    else
                                    {
                                         // Get random file name
                                         $newName = $file->getRandomName(); 
                                    }
                                   
                                 // Store file in public/uploads/ folder
                                 $file->move('./public/uploads/certificate/', $newName);
        
                                 // File path to display preview
                                 $certificate = $newName;
                                 $productStoneData['certificate']=$certificate;
                            }
                        } 
                        }
                        $InserProductStone=$this->MasterModel->InserProductStone($productStoneData); 
                        
            }
            if($InserProductStone)
                        {
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Stone Successfully Insert.",
                                    );
                                echo json_encode($return);  
                                
                        }
                        else
                        {
                            $return=array(
                                        'status'=>true,
                                        'message'=>"Product Stone Skip.",
                                        );
                                echo json_encode($return); 
                                return;
                        }
                        
                        
        }
        else
        {
            $return=array(
                'status'=>true,
                'message'=>"Product Stone Skip.",
            );
            echo json_encode($return);  
            return;
        }
    }
    
    public function ProductOtherMetaladd()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
          $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $productid=$_SESSION['productid'];
        $deleteProductOtherMetal=$this->MasterModel->deleteProductOtherMetal($productid);
        $othermetalArr        = $this->request->getVar('othermetal[]');
        if($othermetalArr)
        {   
            $totalothermetal=count($othermetalArr);
            for ($x = 0; $x < $totalothermetal; $x++) 
            {
                $metalid        = $this->request->getVar('othermetal')[$x];
                $metal='';
                if(!empty($metalid))
                {
                    $metal=$this->MasterModel->getmetalID($metalid)['name'];
                }
                
                $purity        = $this->request->getVar('otherpurity')[$x];
                $weight        = $this->request->getVar('otherweight')[$x];
                $weightunit        = $this->request->getVar('otherweightunit')[$x];

                        $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        if(!isset($GetProductMaster))
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Something Wrong.",
                                );
                            return $return;
                        }
                        
                        $product_code=$GetProductMaster['product_code'];
                        $ProductOtherMetalData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'othermetalid'=>$metalid,
                            'othermetal'=>$metal,
                            'otherweight'=>$weight,
                            'otherweightunit'=>$weightunit,
                            'otherpurity'=>$purity,
                            );
                        $InserProductOtherMetal=$this->MasterModel->InserProductOtherMetal($ProductOtherMetalData); 
                }
            }
            
        }
    
    public function ProductStoneadd()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
          $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $productid=$_SESSION['productid'];;
        $deleteProductStone=$this->MasterModel->deleteProductStone($productid);

                $stonetype        = $this->request->getVar('stonetype');
               
                $stoneid        = $this->request->getVar('stone');
                $stone='';
                if(!empty($stoneid))
                {
                    $stone=$this->MasterModel->getstoneID($stoneid)['name'];
                    
                }
                
                $color        = $this->request->getVar('color');
                
                
                $colorid1        = $this->request->getVar('color1');
                $color1='';
                if(!empty($colorid1))
                {
                    $color1=$this->MasterModel->getcolorID($colorid1)['name'];
                    
                }
                
                $colorid2        = $this->request->getVar('color2');
                $color2='';
                if(!empty($colorid2))
                {
                    $color2=$this->MasterModel->getcolorID($colorid2)['name'];
                }
                
                $intensityid        = $this->request->getVar('intensity');
                $intensity='';
                if(!empty($intensityid))
                {
                    $intensity=$this->MasterModel->getintensityID($intensityid)['name'];
                    
                }
                
                $shapeid        = $this->request->getVar('shape');
                $shape='';
                if(!empty($shapeid))
                {
                    $shape=$this->MasterModel->getshapeID($shapeid)['name'];
                    
                }
                
                $stonecutid        = $this->request->getVar('stonecut');
                $stonecut='';
                if(!empty($stonecutid))
                {
                    $stonecut=$this->MasterModel->getstonecutID($stonecutid)['name'];
                }
                
                $clarityid        = $this->request->getVar('clarity');
                $clarity='';
                if(!empty($clarityid))
                {
                    $clarity=$this->MasterModel->getclarityID($clarityid)['name'];
                    
                }
                
                
                $overtone        = $this->request->getVar('overtone');
                
                $treatmentid        = $this->request->getVar('treatment');
                $treatment='';
                if(!empty($treatmentid))
                {
                    $treatment=$this->MasterModel->gettreatmentID($treatmentid)['name'];
                    
                }

                $originid        = $this->request->getVar('origin');
                $origin='';
                if(!empty($originid))
                {
                    $origin=$this->MasterModel->getoriginID($originid)['name'];
                    
                }
                
                $depth        = $this->request->getVar('depth');
                $polish        = $this->request->getVar('polish');
                $symmetry        = $this->request->getVar('symmetry');
                $girdlemin        = $this->request->getVar('girdlemin');
                $girdlemax        = $this->request->getVar('girdlemax');
                $girdlecondition        = $this->request->getVar('girdlecondition');
                $girdle        = $this->request->getVar('girdle');
                $culetsize        = $this->request->getVar('culetsize');
                $culetcondition        = $this->request->getVar('culetcondition');
                $fluoresenceintensity        = $this->request->getVar('fluoresenceintensity');
                
                $fluoresencecolorid        = $this->request->getVar('fluoresencecolor');
                $fluoresencecolor='';
                if(!empty($fluoresencecolorid))
                {
                    $fluoresencecolor=$this->MasterModel->getcolorID($fluoresencecolorid)['name'];
                }
                
                $corowhight        = $this->request->getVar('corowhight');
                
                $corowangle        = $this->request->getVar('corowangle');
                $pavilliondepth        = $this->request->getVar('pavilliondepth');
                $pavillionangle        = $this->request->getVar('pavillionangle');
                $blackinclusion        = $this->request->getVar('blackinclusion');
                
                $centerinclusion        = $this->request->getVar('centerinclusion');
                
                $shadeid        = $this->request->getVar('shade');
                $shade='';
                if(!empty($shadeid))
                {
                    $shade=$this->MasterModel->getcolorID($shadeid)['name'];
                }
                
                $milky        = $this->request->getVar('milky');
                $keystosymobls        = $this->request->getVar('keystosymobls');
                
                $labid        = $this->request->getVar('lab');
                $lab='';
                if(!empty($labid))
                {
                    $lab=$this->MasterModel->getlabID($labid)['name'];
                }

                $certificateno        = $this->request->getVar('certificateno');
                $weight        = $this->request->getVar('weight');
                $unit        = $this->request->getVar('unit');
                $quantity      = $this->request->getVar('quantity');
                $cost_price = $this->request->getVar('cost_price');
                $tag_price = $this->request->getVar('tag_price');
                $sale_price = $this->request->getVar('sale_price');
                
                        $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        if(!isset($GetProductMaster))
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Something Wrong.",
                                );
                            return $return;
                        }
                        $product_code=$GetProductMaster['product_code'];
                        $productStoneData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'quantity'=>$quantity,
                            'weight'=>$weight,
                            'stonetype'=>$stonetype,
                            'stoneid'=>$stoneid,
                            'stone'=>$stone,
                            'color'=>$color,
                            'colorid1'=>$colorid1,
                            'color1'=>$color1,
                            'colorid2'=>$colorid2,
                            'color2'=>$color2,
                            'intensityid'=>$intensityid,
                            'intensity'=>$intensity,
                            'shapeid'=>$shapeid,
                            'shape'=>$shape,
                            'stonecutid'=>$stonecutid,
                            'stonecut'=>$stonecut,
                            'clarityid'=>$clarityid,
                            'clarity'=>$clarity,
                            'overtone'=>$overtone,
                            'treatmentid'=>$treatmentid,
                            'treatment'=>$treatment,
                            'originid'=>$originid,
                            'origin'=>$origin,
                            'depth'=>$depth,
                            'polish'=>$polish,
                            'symmetry'=>$symmetry,
                            'girdlemin'=>$girdlemin,
                            'girdlemax'=>$girdlemax,
                            'girdlecondition'=>$girdlecondition,
                            'girdle'=>$girdle,
                           'culetsize'=>$culetsize,
                           'culetcondition'=>$culetcondition,
                           'fluoresenceintensity'=>$fluoresenceintensity,
                           'fluoresencecolorid'=>$fluoresencecolorid,
                           'fluoresencecolor'=>$fluoresencecolor,
                           'corowhight'=>$corowhight,
                           'corowangle'=>$corowangle,
                           'pavilliondepth'=>$pavilliondepth,
                           'pavillionangle'=>$pavillionangle,
                           'blackinclusion'=>$blackinclusion,
                           'centerinclusion'=>$centerinclusion,
                           'shade'=>$shade,
                           'shadeid'=>$shadeid,
                           'milky'=>$milky,
                           'keystosymobls'=>$keystosymobls,
                           'lab'=>$lab,
                           'labid'=>$labid,
                           'certificateno'=>$certificateno,
                            'unit'=>$unit,
                            'cost_price'=>$cost_price,
                            'tag_price'=>$tag_price,
                            'sale_price'=>$sale_price,
                            );
                        if($this->request->getFile('certificate'))
                        {
                        if($file = $this->request->getFile('certificate')) 
                        {
                            if ($file->isValid() && ! $file->hasMoved()) 
                            {
                                 // Get file name and extension
                                 $name = $file->getName();
                                 $ext = $file->getClientExtension();
                                    if($certificateno!=='')
                                    {
                                        // Get random file name
                                         $newName = 'certificate'.$certificateno.'.'.$ext; 
                                         
                                    }
                                    else
                                    {
                                         // Get random file name
                                         $newName = $file->getRandomName(); 
                                    }
                                   
                                 // Store file in public/uploads/ folder
                                 $file->move('./public/uploads/certificate/', $newName);
        
                                 // File path to display preview
                                 $certificate = $newName;
                                 $productStoneData['certificate']=$certificate;
                            }
                        } 
                        }  
                    
                        $InserProductStone=$this->MasterModel->InserProductStone($productStoneData); 

                        if($InserProductStone)
                        {
                            $this->MoreCertificateadd();
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Stone Successfully Insert.",
                                    );
                                return $return;
                                
                        }
                        else
                        {
                            $return=array(
                                        'status'=>false,
                                        'message'=>"Product Stone Skip.",
                                        );
                                return $return;
                        }
                        
                        
        
        
    }
    
    public function MoreCertificateadd()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
          $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $productid=$_SESSION['productid'];
        $deleteMoreCertificate=$this->MasterModel->deleteMoreCertificate($productid);
        $morelabArr        = $this->request->getVar('morelab[]');
        if($morelabArr)
        {   
            $totalmorelab=count($morelabArr);
            for ($x = 0; $x < $totalmorelab; $x++) 
            {
                $labid        = $this->request->getVar('morelab')[$x];
                $lab='';
                if(!empty($labid))
                {
                    $lab=$this->MasterModel->getlabID($labid)['name'];
                }
                
                $certificateno        = $this->request->getVar('morecertificateno')[$x];

                        $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        if(!isset($GetProductMaster))
                        {
                            $return=array(
                                'status'=>false,
                                'message'=>"Something Wrong.",
                                );
                            return $return;
                        }
                        
                        $product_code=$GetProductMaster['product_code'];
                        $ProductMoreCertificateData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'labid'=>$labid,
                            'lab'=>$lab,
                            'certificateno'=>$certificateno,
                            );
                        if($this->request->getFile('certificate'.$x))
                        {
                        if($file = $this->request->getFile('certificate'.$x)) 
                        {
                            if ($file->isValid() && ! $file->hasMoved()) 
                            {
                                 // Get file name and extension
                                 $name = $file->getName();
                                 $ext = $file->getClientExtension();
                                    if($certificateno!=='')
                                    {
                                        // Get random file name
                                         $newName = 'certificate'.$certificateno.'.'.$ext; 
                                         
                                    }
                                    else
                                    {
                                         // Get random file name
                                         $newName = $file->getRandomName(); 
                                    }
                                   
                                 // Store file in public/uploads/ folder
                                 $file->move('./public/uploads/certificate/', $newName);
        
                                 // File path to display preview
                                 $certificate = $newName;
                                 $ProductMoreCertificateData['certificate']=$certificate;
                            }
                        } 
                        }
                    
                        if(isset($this->request->getVar('certificateid')[$x]))
                        {
                            $certificateid=$this->request->getVar('certificateid')[$x];
                            $InserMoreCertificate=$this->MasterModel->UpdateMoreCertificate($ProductMoreCertificateData,$certificateid); 
                        }
                        else
                        {
                            $InserMoreCertificate=$this->MasterModel->InserMoreCertificate($ProductMoreCertificateData); 
                        }
                        
                        
                }
            }
            
        }
    
    public function ProductVariationSubmit()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $sizeArr        = $this->request->getVar('size[]');
        $productid=$_SESSION['productid'];
        $deleteProductVariation=$this->MasterModel->deleteProductVariation($productid);    
        if($sizeArr)
        {   
            $totalSize=count($sizeArr);
            for ($x = 0; $x < $totalSize; $x++) {
                $metalid            = $this->request->getVar('metal')[$x];
                $metal='';
                if(!empty($metalid))
                {
                    $metal=$this->MasterModel->getmetalID($metalid)['name'];
                }
                $sizeid            = $this->request->getVar('size')[$x];
                $size='';
                if(!empty($sizeid))
                {
                    $size=$this->MasterModel->getsizeID($sizeid)['name'];
                }
                $quantity        = $this->request->getVar('quantity')[$x];
                $weight        = $this->request->getVar('weight')[$x];
                $weightunit        = $this->request->getVar('weightunit')[$x];
                $cost_price        = $this->request->getVar('cost_price')[$x];
                $tag_price        = $this->request->getVar('tag_price')[$x];
                $sale_price        = $this->request->getVar('sale_price')[$x];
                
                        $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        $product_code=$GetProductMaster['product_code'];
                        $productVariationData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'metal'=>$metal,
                            'metalid'=>$metalid,
                            'size'=>$size,
                            'sizeid'=>$sizeid,
                            'weight'=>$weight,
                            'weightunit'=>$weightunit,
                            'quantity'=>$quantity,
                            'cost_price'=>$cost_price,
                            'tag_price'=>$tag_price,
                            'sale_price'=>$sale_price,
                            );
                        $InserProductVariation=$this->MasterModel->InserProductVariation($productVariationData); 
                        
            }
            if($InserProductVariation)
                        {
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Variation Successfully Insert.",
                                    );
                                echo json_encode($return);  
                                return;
                                
                        }
                        else
                        {
                            $return=array(
                                        'status'=>true,
                                        'message'=>"Product Variation Skip.",
                                        );
                                echo json_encode($return); 
                                return;
                        }
                        
                        
        }
        else
        {
            $return=array(
                'status'=>true,
                'message'=>"Product Variation Skip.",
            );
            echo json_encode($return);  
            return;
        }
    }
    
    public function ProductVariationUpdate()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
        $sizeArr        = $this->request->getVar('size[]');
        $productid=$_SESSION['productid'];
        $deleteProductVariation=$this->MasterModel->deleteProductVariation($productid); 
        if($sizeArr)
        {
            $totalSize=count($sizeArr);
            for ($x = 0; $x < $totalSize; $x++) {
                $metalid            = $this->request->getVar('metal')[$x];
                $metal='';
                if(!empty($metalid))
                {
                    $metal=$this->MasterModel->getmetalID($metalid)['name'];
                }
                
                $sizeid            = $this->request->getVar('size')[$x];
                $size='';
                if(!empty($sizeid))
                {
                    $size=$this->MasterModel->getsizeID($sizeid)['name'];
                }
                
                $quantity        = $this->request->getVar('quantity')[$x];
                $weight        = $this->request->getVar('weight')[$x];
                $weightunit        = $this->request->getVar('weightunit')[$x];
                $cost_price        = $this->request->getVar('cost_price')[$x];
                $tag_price        = $this->request->getVar('tag_price')[$x];
                $sale_price        = $this->request->getVar('sale_price')[$x];
                $productid=$_SESSION['productid'];
                        $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                        
                        $product_code=$GetProductMaster['product_code'];
                        $productVariationData=array(
                            'productcode'=>$product_code,
                            'productid'=>$productid,
                            'metal'=>$metal,
                            'metalid'=>$metalid,
                            'size'=>$size,
                            'sizeid'=>$sizeid,
                            'weight'=>$weight,
                            'weightunit'=>$weightunit,
                            'quantity'=>$quantity,
                            'cost_price'=>$cost_price,
                            'tag_price'=>$tag_price,
                            'sale_price'=>$sale_price,
                            );
                        $InserProductVariation=$this->MasterModel->InserProductVariation($productVariationData); 
                        
            }
            if($InserProductVariation)
                        {
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Variation Successfully Update.",
                                    );
                                echo json_encode($return);  
                                return;
                                
                        }
                        else
                        {
                            $return=array(
                                        'status'=>true,
                                        'message'=>"Product Variation Successfully Update.",
                                        );
                                echo json_encode($return); 
                                return;
                        }
                        
                        
        }
        else
        {
            $return=array(
                'status'=>true,
                'message'=>"Product Variation Not Update.",
            );
            echo json_encode($return);  
            return;
        }
    
    }
    
     public function ProductFinalSubmit()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
        
                
               
                
                $status        = $this->request->getVar('status');
                $search_keyword       = $this->request->getVar('search_keyword');
                $meta_keyword        = $this->request->getVar('meta_keyword');
                $meta_description        = $this->request->getVar('meta_description');
                $productid=$_SESSION['productid'];
                $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                $product_code=$GetProductMaster['product_code'];
                $productfinalData=array(
                            'status'=>$status,
                            'search_keyword'=>$search_keyword,
                            'meta_keyword'=>$meta_keyword,
                            'meta_description'=>$meta_description,
                );
                
                if($this->request->getVar('premium'))
                {
                    $productfinalData['premium']=$this->request->getVar('premium');
                }
                if($this->request->getVar('closeout'))
                {
                    $productfinalData['closeout']=$this->request->getVar('closeout');
                }
                if($this->request->getVar('featured'))
                {
                    $productfinalData['featured']=$this->request->getVar('featured');
                    if($featured_bannerfile = $this->request->getFile('featured_banner')) 
                    {
                        if ($featured_bannerfile->isValid() && ! $featured_bannerfile->hasMoved()) 
                        {
                             // Get file name and extension
                             $name = $featured_bannerfile->getName();
                             $ext = $featured_bannerfile->getClientExtension();
    
                             // Get random file name
                             $newName = $featured_bannerfile->getRandomName(); 
                               
                             // Store file in public/uploads/ folder
                             $featured_bannerfile->move('./public/products/featured_banner/', $newName);
                             $featured_bannerfile="public/products/featured_banner/".$newName;
                             $productfinalData['featured_banner']=$featured_bannerfile;
                        }  
                    } 
                }
                
                
                
                $InserProductFinal=$this->MasterModel->InserProductFinal($productfinalData,$productid,$product_code); 
                if($InserProductFinal)
                {
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Successfully Insert.",
                                    );
                                echo json_encode($return);  
                                return;
                                
                }
                else
                {
                            $return=array(
                                        'status'=>false,
                                        'message'=>"Product Not Insert.",
                                        );
                                echo json_encode($return); 
                                return;
                }
                        
                        
        
    }
    
    public function ProductFinalUpdate()
    {
        
        if(!isset($this->session->admin))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);  
            return;
        }
        if(!isset($this->session->productid))
        {
            //session check for admin login
           $return=array(
                'status'=>false,
                'message'=>"Something Wrong.",
                );
            echo json_encode($return);
            return;  
        }
                $status        = $this->request->getVar('status');
                $search_keyword       = $this->request->getVar('search_keyword');
                $meta_keyword        = $this->request->getVar('meta_keyword');
                $meta_description        = $this->request->getVar('meta_description');
                $productid=$_SESSION['productid'];
                $GetProductMaster=$this->MasterModel->GetProductMaster($productid);
                $product_code=$GetProductMaster['product_code'];
                $productfinalData=array(
                            'status'=>$status,
                            'search_keyword'=>$search_keyword,
                            'meta_keyword'=>$meta_keyword,
                            'meta_description'=>$meta_description,
                            'updateDate'        =>date('Y-m-d h:i:s a', time()),
                );
                
                if($this->request->getVar('premium'))
                {
                    $productfinalData['premium']=$this->request->getVar('premium');
                }
                if($this->request->getVar('closeout'))
                {
                    $productfinalData['closeout']=$this->request->getVar('closeout');
                }
                if($this->request->getVar('featured'))
                {
                    $productfinalData['featured']=$this->request->getVar('featured');
                    if($featured_bannerfile = $this->request->getFile('featured_banner')) 
                    {
                        if ($featured_bannerfile->isValid() && ! $featured_bannerfile->hasMoved()) 
                        {
                             // Get file name and extension
                             $name = $featured_bannerfile->getName();
                             $ext = $featured_bannerfile->getClientExtension();
    
                             // Get random file name
                             $newName = $featured_bannerfile->getRandomName(); 
                               
                             // Store file in public/uploads/ folder
                             $featured_bannerfile->move('./public/products/featured_banner/', $newName);
                             $featured_bannerfile="public/products/featured_banner/".$newName;
                             $productfinalData['featured_banner']=$featured_bannerfile;
                        }  
                    } 
                }
                
                $UpdateProductFinal=$this->MasterModel->UpdateProductFinal($productfinalData,$productid,$product_code); 
                if($UpdateProductFinal)
                {
                            $return=array(
                                    'status'=>true,
                                    'message'=>"Product Successfully Update.",
                                    );
                                echo json_encode($return);  
                                return;
                                
                }
                else
                {
                            $return=array(
                                        'status'=>false,
                                        'message'=>"Product Not Update.",
                                        );
                                echo json_encode($return); 
                                return;
                }
    
    }
    
    public function productstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_product_status($status,$id); 
    }
    
    public function productdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MasterModel->product_delete($id);  
    }
    
    
    
    
    //shape
    
    public function addshape()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Shape";
        $data['shapes'] = $this->MasterModel->getshape();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addshape';
        return view('Admin/admin_index',$data);
    }
    public function insert_shape()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('shape_language');
        $name_arr = $this->request->getVar('shape_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $ShapeSlug=$this->lang_slug($unserializeName);
        $field='shapeid'; 
        $table='shape'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['shapeid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'shapeid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$ShapeSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_shape($data); 
        return redirect()->to('/admin/shape');
    }
    
    public function editshape($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $shape= $this->MasterModel->getshapeID($i);

        if(isset($shape))
        {
            $data['title']="Edit Shape";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['shapes'] = $this->MasterModel->getshape();
            $data['shape']  = $shape;
            $data['page'] ='editshape';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/shape');  
        }
    }
    
    public function update_shape($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('shape_language');
        $name_arr = $this->request->getVar('shape_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_shape($data,$id); 
        return redirect()->to('/admin/shape');
    }
    
    public function shape()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['shape'] = $this->MasterModel->getshape();
        $data['page']='shape';
        return view('Admin/admin_index',$data);
    }
    public function getshape()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('shape')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('shape')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('shape')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $shape_name=unserialize($record['name']);
           $shape=$shape_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editshape/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "shapeid"=>$record['shapeid'],
             "Shape"=>$shape,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function shapestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_shape_status($status,$id); 
             
    }
    
    public function shapedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->shape_delete($id);  
    }
    
    
    //stonetype
    
    public function addstonetype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Stone Type";
        $data['stonetypes'] = $this->MasterModel->getstonetype();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addstonetype';
        return view('Admin/admin_index',$data);
    }
    public function insert_stonetype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('stonetype_language');
        $name_arr = $this->request->getVar('stonetype_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $StoneTypeSlug=$this->lang_slug($unserializeName);
        $field='stonetypeid'; 
        $table='stonetype'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['stonetypeid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'stonetypeid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$StoneTypeSlug,
            'sequence'=>$sort_order,
            );
       
        $this->MasterModel->insert_stonetype($data); 
        return redirect()->to('/admin/stonetype');
    }
    
    public function editstonetype($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $stonetype= $this->MasterModel->getstonetypeID($i);

        if(isset($stonetype))
        {
            $data['title']="Edit Stone Type";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['stonetypes'] = $this->MasterModel->getstonetype();
            $data['stonetype']  = $stonetype;
            $data['page'] ='editstonetype';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/stonetype');  
        }
    }
    
    public function update_stonetype($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('stonetype_language');
        $name_arr = $this->request->getVar('stonetype_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_stonetype($data,$id); 
        return redirect()->to('/admin/stonetype');
    }
    
    public function stonetype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['stonetype'] = $this->MasterModel->getstonetype();
        $data['page']='stonetype';
        return view('Admin/admin_index',$data);
    }
    public function getstonetype()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('stonetype')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('stonetype')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('stonetype')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $stonetype_name=unserialize($record['name']);
           $stonetype=$stonetype_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editstonetype/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "stonetypeid"=>$record['stonetypeid'],
             "StoneType"=>$stonetype,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function stonetypestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_stonetype_status($status,$id); 
             
    }
    
    public function stonetypedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->stonetype_delete($id);  
    }
    
    
    //type
    
    public function addtype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Type";
        $data['types'] = $this->MasterModel->gettype();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['Categories'] = $this->MasterModel->GetCategories();
        $data['page']='addtype';
        return view('Admin/admin_index',$data);
    }
    public function insert_type()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('type_language');
        $name_arr = $this->request->getVar('type_name');
        $sort_order = $this->request->getVar('sort_order');
        $category = $this->request->getVar('category');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $TypeSlug=$this->lang_slug($unserializeName);
        $field='typeid'; 
        $table='type'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);

       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['typeid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'typeid'=>$GetMaxId,
            'name'=>$serialized_name,
            'categoryid'=>$category,
            'slug'=>$TypeSlug,
            'sequence'=>$sort_order,
            );
       
        $this->MasterModel->insert_type($data); 
        return redirect()->to('/admin/type');
    }
    
    public function edittype($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $type= $this->MasterModel->gettypeID($i);

        if(isset($type))
        {
            $data['title']="Edit Type";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['Categories'] = $this->MasterModel->GetCategories();
            $data['types'] = $this->MasterModel->gettype();
            $data['type']  = $type;
            $data['page'] ='edittype';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/type');  
        }
    }
    
    public function update_type($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('type_language');
        $name_arr = $this->request->getVar('type_name');
        $sort_order = $this->request->getVar('sort_order');
        $category = $this->request->getVar('category');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'categoryid'=>$category,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_type($data,$id); 
        return redirect()->to('/admin/type');
    }
    
    public function type()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['type'] = $this->MasterModel->gettype();
        $data['page']='type';
        return view('Admin/admin_index',$data);
    }
    public function gettype()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('type')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('type')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('type')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $type_name=unserialize($record['name']);
           $type=$type_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edittype/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               $Category=$this->MasterModel->GetCategoriesId($record['categoryid']);
               if(isset($Category))
               {
               $ViewCategory_Name=unserialize($Category['name'])['en'];
               }
               else
               {
                  $ViewCategory_Name='None'; 
               }
               
          $data[] = array( 
             "id"=>$i,
             "typeid"=>$record['typeid'],
             "Type"=>$type,
             "Category"=>$ViewCategory_Name,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function typestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_type_status($status,$id); 
             
    }
    
    public function typedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->type_delete($id);  
    }
    
    
    //intensity
    
    public function addintensity()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Intensity";
        $data['intensitys'] = $this->MasterModel->getintensity();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addintensity';
        return view('Admin/admin_index',$data);
    }
    public function insert_intensity()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('intensity_language');
        $name_arr = $this->request->getVar('intensity_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $IntensitySlug=$this->lang_slug($unserializeName);
        $field='intensityid'; 
        $table='intensity'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['intensityid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'intensityid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$IntensitySlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_intensity($data); 
        return redirect()->to('/admin/intensity');
    }
    
    public function editintensity($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $intensity= $this->MasterModel->getintensityID($i);

        if(isset($intensity))
        {
            $data['title']="Edit Intensity";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['intensitys'] = $this->MasterModel->getintensity();
            $data['intensity']  = $intensity;
            $data['page'] ='editintensity';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/intensity');  
        }
    }
    
    public function update_intensity($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('intensity_language');
        $name_arr = $this->request->getVar('intensity_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_intensity($data,$id); 
        return redirect()->to('/admin/intensity');
    }
    
    public function intensity()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['intensity'] = $this->MasterModel->getintensity();
        $data['page']='intensity';
        return view('Admin/admin_index',$data);
    }
    public function getintensity()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('intensity')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('intensity')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('intensity')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $intensity_name=unserialize($record['name']);
           $intensity=$intensity_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editintensity/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "intensityid"=>$record['intensityid'],
             "Intensity"=>$intensity,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function intensitystatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_intensity_status($status,$id); 
             
    }
    
    public function intensitydelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->intensity_delete($id);  
    }
    
    
    //overtone
    
    public function addovertone()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Overtone";
        $data['overtones'] = $this->MasterModel->getovertone();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addovertone';
        return view('Admin/admin_index',$data);
    }
    public function insert_overtone()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('overtone_language');
        $name_arr = $this->request->getVar('overtone_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $OvertoneSlug=$this->lang_slug($unserializeName);
        $field='overtoneid'; 
        $table='overtone'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['overtoneid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'overtoneid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$OvertoneSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_overtone($data); 
        return redirect()->to('/admin/overtone');
    }
    
    public function editovertone($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $overtone= $this->MasterModel->getovertoneID($i);

        if(isset($overtone))
        {
            $data['title']="Edit Overtone";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['overtones'] = $this->MasterModel->getovertone();
            $data['overtone']  = $overtone;
            $data['page'] ='editovertone';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/overtone');  
        }
    }
    
    public function update_overtone($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('overtone_language');
        $name_arr = $this->request->getVar('overtone_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_overtone($data,$id); 
        return redirect()->to('/admin/overtone');
    }
    
    public function overtone()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['overtone'] = $this->MasterModel->getovertone();
        $data['page']='overtone';
        return view('Admin/admin_index',$data);
    }
    public function getovertone()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('overtone')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('overtone')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('overtone')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $overtone_name=unserialize($record['name']);
           $overtone=$overtone_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editovertone/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "overtoneid"=>$record['overtoneid'],
             "Overtone"=>$overtone,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function overtonestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_overtone_status($status,$id); 
             
    }
    
    public function overtonedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->overtone_delete($id);  
    }
    
    
    //clarity
    
    public function addclarity()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Clarity";
        $data['claritys'] = $this->MasterModel->getclarity();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addclarity';
        return view('Admin/admin_index',$data);
    }
    
    public function insert_clarity()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('clarity_language');
        $name_arr = $this->request->getVar('clarity_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $ClaritySlug=$this->lang_slug($unserializeName);
        $field='clarityid'; 
        $table='clarity'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['clarityid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'clarityid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$ClaritySlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_clarity($data); 
        return redirect()->to('/admin/clarity');
    }
    
    public function editclarity($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $clarity= $this->MasterModel->getclarityID($i);

        if(isset($clarity))
        {
            $data['title']="Edit Clarity";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['claritys'] = $this->MasterModel->getclarity();
            $data['clarity']  = $clarity;
            $data['page'] ='editclarity';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/clarity');  
        }
    }
    
    public function update_clarity($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('clarity_language');
        $name_arr = $this->request->getVar('clarity_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_clarity($data,$id); 
        return redirect()->to('/admin/clarity');
    }
    
    public function clarity()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['clarity'] = $this->MasterModel->getclarity();
        $data['page']='clarity';
        return view('Admin/admin_index',$data);
    }
    public function getclarity()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('clarity')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('clarity')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('clarity')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $clarity_name=unserialize($record['name']);
           $clarity=$clarity_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editclarity/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "clarityid"=>$record['clarityid'],
             "Clarity"=>$clarity,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function claritystatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_clarity_status($status,$id); 
             
    }
    
    public function claritydelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->clarity_delete($id);  
    }
    
     //gemtype
    
    public function addgemtype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Gem Type";
        $data['gemtypes'] = $this->MasterModel->getgemtype();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addgemtype';
        return view('Admin/admin_index',$data);
    }
    public function insert_gemtype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('gemtype_language');
        $name_arr = $this->request->getVar('gemtype_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $GemTypeSlug=$this->lang_slug($unserializeName);
        $field='gemtypeid'; 
        $table='gemtype'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['gemtypeid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'gemtypeid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$GemTypeSlug,
            'sequence'=>$sort_order,
            );
       
        $this->MasterModel->insert_gemtype($data); 
        return redirect()->to('/admin/gemtype');
    }
    
    public function editgemtype($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $gemtype= $this->MasterModel->getgemtypeID($i);

        if(isset($gemtype))
        {
            $data['title']="Edit Gem Type";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['gemtypes'] = $this->MasterModel->getgemtype();
            $data['gemtype']  = $gemtype;
            $data['page'] ='editgemtype';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/gemtype');  
        }
    }
    
    public function update_gemtype($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('gemtype_language');
        $name_arr = $this->request->getVar('gemtype_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_gemtype($data,$id); 
        return redirect()->to('/admin/gemtype');
    }
    
    public function gemtype()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['gemtype'] = $this->MasterModel->getgemtype();
        $data['page']='gemtype';
        return view('Admin/admin_index',$data);
    }
    public function getgemtype()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('gemtype')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('gemtype')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('gemtype')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $gemtype_name=unserialize($record['name']);
           $gemtype=$gemtype_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editgemtype/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "gemtypeid"=>$record['gemtypeid'],
             "GemType"=>$gemtype,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function gemtypestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_gemtype_status($status,$id); 
             
    }
    
    public function gemtypedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->gemtype_delete($id);  
    }
    
    
    //origin
    
    public function addorigin()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Origin";
        $data['origins'] = $this->MasterModel->getorigin();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addorigin';
        return view('Admin/admin_index',$data);
    }
    public function insert_origin()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('origin_language');
        $name_arr = $this->request->getVar('origin_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $OriginSlug=$this->lang_slug($unserializeName);
        $field='originid'; 
        $table='origin'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['originid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'originid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$OriginSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_origin($data); 
        return redirect()->to('/admin/origin');
    }
    
    public function editorigin($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $origin= $this->MasterModel->getoriginID($i);

        if(isset($origin))
        {
            $data['title']="Edit Origin";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['origins'] = $this->MasterModel->getorigin();
            $data['origin']  = $origin;
            $data['page'] ='editorigin';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/origin');  
        }
    }
    
    public function update_origin($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('origin_language');
        $name_arr = $this->request->getVar('origin_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_origin($data,$id); 
        return redirect()->to('/admin/origin');
    }
    
    public function origin()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['origin'] = $this->MasterModel->getorigin();
        $data['page']='origin';
        return view('Admin/admin_index',$data);
    }
    public function getorigin()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('origin')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('origin')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('origin')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $origin_name=unserialize($record['name']);
           $origin=$origin_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editorigin/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "originid"=>$record['originid'],
             "Origin"=>$origin,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function originstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_origin_status($status,$id); 
             
    }
    
    public function origindelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->origin_delete($id);  
    }
    
    
     //treatment
    
    public function addtreatment()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Treatment";
        $data['treatments'] = $this->MasterModel->gettreatment();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addtreatment';
        return view('Admin/admin_index',$data);
    }
    public function insert_treatment()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('treatment_language');
        $name_arr = $this->request->getVar('treatment_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $TreatmentSlug=$this->lang_slug($unserializeName);
        $field='treatmentid'; 
        $table='treatment'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['treatmentid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'treatmentid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$TreatmentSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_treatment($data); 
        return redirect()->to('/admin/treatment');
    }
    
    public function edittreatment($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $treatment= $this->MasterModel->gettreatmentID($i);

        if(isset($treatment))
        {
            $data['title']="Edit Treatment";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['treatments'] = $this->MasterModel->gettreatment();
            $data['treatment']  = $treatment;
            $data['page'] ='edittreatment';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/treatment');  
        }
    }
    
    public function update_treatment($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('treatment_language');
        $name_arr = $this->request->getVar('treatment_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_treatment($data,$id); 
        return redirect()->to('/admin/treatment');
    }
    
    public function treatment()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['treatment'] = $this->MasterModel->gettreatment();
        $data['page']='treatment';
        return view('Admin/admin_index',$data);
    }
    public function gettreatment()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('treatment')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('treatment')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('treatment')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $treatment_name=unserialize($record['name']);
           $treatment=$treatment_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edittreatment/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "treatmentid"=>$record['treatmentid'],
             "Treatment"=>$treatment,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function treatmentstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_treatment_status($status,$id); 
             
    }
    
    public function treatmentdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->treatment_delete($id);  
    }
    
    
    public function GetTypeCategory()
    {
        $catid = $this->request->getVar('catid');
        $GetCategory=$this->MasterModel->GetCategoriesId($catid); 
        if($GetCategory)
        {
            $GetTypeCategory=$this->MasterModel->GetTypeCategory($catid); 
            if($GetTypeCategory)
            {
                $category_name=unserialize($GetCategory['name']);
                $category=$category_name['en'];
                foreach($GetTypeCategory as &$row)
                {
                    $name=unserialize($row->name);
                    $row->name=$name['en'];
                }
                
                $response=array(
                    'status'=>true,
                    'title'=>ucwords(strtolower($category." Style")),
                    'data'=>$GetTypeCategory
                    );
            }
            else
            {
                $response=array(
                'status'=>false,
                );
            }
        }
        else
        {
            $response=array(
            'status'=>false,
            );
        }
        echo json_encode($response);
        
    }
    
    public function GetTypeCategorySlug()
    {
        $catslug= $this->request->getVar('catslug');
        $GetCategory=$this->MasterModel->GetCategoriesSlug($catslug); 
        if($GetCategory)
        {
            $catid=$GetCategory['categoryid'];
            $GetTypeCategory=$this->MasterModel->GetTypeCategory($catid); 
            if($GetTypeCategory)
            {
                $category_name=unserialize($GetCategory['name']);
                $category=$category_name['en'];
                foreach($GetTypeCategory as &$row)
                {
                    $name=unserialize($row->name);
                    $row->name=$name['en'];
                }
                
                $response=array(
                    'status'=>true,
                    'title'=>ucwords(strtolower($category." Style")),
                    'data'=>$GetTypeCategory
                    );
            }
            else
            {
                $response=array(
                'status'=>false,
                );
            }
        }
        else
        {
            $response=array(
            'status'=>false,
            );
        }
        echo json_encode($response);
        
    }
    
    
    //lab
    
    public function addlab()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Lab";
        $data['labs'] = $this->MasterModel->getlab();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addlab';
        return view('Admin/admin_index',$data);
    }
    public function insert_lab()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('lab_language');
        $name_arr = $this->request->getVar('lab_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $LabSlug=$this->lang_slug($unserializeName);
        $field='labid'; 
        $table='lab'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['labid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'labid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$LabSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_lab($data); 
        return redirect()->to('/admin/lab');
    }
    
    public function editlab($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $lab= $this->MasterModel->getlabID($i);

        if(isset($lab))
        {
            $data['title']="Edit Lab";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['labs'] = $this->MasterModel->getlab();
            $data['lab']  = $lab;
            $data['page'] ='editlab';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/lab');  
        }
    }
    
    public function update_lab($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('lab_language');
        $name_arr = $this->request->getVar('lab_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_lab($data,$id); 
        return redirect()->to('/admin/lab');
    }
    
    public function lab()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['lab'] = $this->MasterModel->getlab();
        $data['page']='lab';
        return view('Admin/admin_index',$data);
    }
    public function getlab()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('lab')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('lab')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('lab')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $lab_name=unserialize($record['name']);
           $lab=$lab_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editlab/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "labid"=>$record['labid'],
             "Lab"=>$lab,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function labstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_lab_status($status,$id); 
             
    }
    
    public function labdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->lab_delete($id);  
    }
    
    public function bulkproductimages()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $data=[];
            $data['page'] ='bulkproductimages';
            return view('Admin/admin_index',$data);
    }
    public function bulkproductimagesUpload()
    {
        if($this->request->getFile('file')) 
        {
            $imagefile1=$this->request->getFile('file');
         
            $imagename= $imagefile1->getName();
            $ext = strtolower($imagefile1->getClientExtension());
            if($ext=='mp4')
            {
                 $imagefile1->move('./public/products/large/', $imagename);
                echo "Scmflkvm";
            }
            else
            {
            $image3 = \Config\Services::image()
                    ->withFile($imagefile1)
                    ->save(FCPATH .'/public/products/large/'. $imagename);
            // $imagefile1->move(FCPATH .'/public/products/large/');
            
            $image2 = \Config\Services::image()
                    ->withFile(FCPATH .'/public/products/large/'. $imagename)
                    ->resize(328, 328, 'width', 'height')
                    ->save(FCPATH .'/public/products/thumbnail/'. $imagename);
                    
            $image1 = \Config\Services::image()
                    ->withFile(FCPATH .'/public/products/thumbnail/'. $imagename)
                    ->resize(80, 80, 'width', 'height')
                    ->save(FCPATH .'/public/products/small/'. $imagename);
            }
        }
        else
        {
            
        }
    }
    

}
