<?php
namespace App\Controllers\Admin;
use App\Models\MoreModel;
use App\Controllers\BaseController;
use App\Controllers\Api;
use App\Controllers\RenderImage;
class More extends BaseController
{
    public function __construct(){
        $this->Api = new Api();
        $this->MoreModel = new MoreModel();  
    }
    
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    public function lang_slug($unserializeName)
    {
       
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
            
        }
        
    }
    public function subscribers()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='subscribers';
        return view('Admin/admin_index',$data);
    }
    public function getsubscribers()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('Newsletter')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('Newsletter')
                                ->select('id')
                                ->Like('email', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('Newsletter')
            ->select('*')
            ->Like('email', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
          $data[] = array( 
             "id"=>$i,
             "email"=>$record['email'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function subscriberstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_subscriber_status($status,$id); 
             
    }
    
    public function subscriberdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->subscriber_delete($id);  
    }
    
    
    
    // Appointments
    
        public function appointments()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='appointment';
        return view('Admin/admin_index',$data);
    }
    public function getappointments()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
    
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('appointment')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('appointment')
                                ->select('id')
                                ->Like('appointment_date', $searchValue)
                                ->Like('name', $searchValue)
                                ->Like('email', $searchValue)
                                ->Like('phone', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('appointment')
            ->select('*')
            ->Like('appointment_date', $searchValue)
            ->Like('name', $searchValue)
            ->Like('email', $searchValue)
            ->Like('phone', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){

            
           $status='';
           
                $status.='<select id="appointmentStatus" data-appointmentid="'.$record['id'].'">';
                if($record['status']=='pending')
                {
                $status.='<option value="pending" selected >Pending</option>';
                $status.='<option value="approved">Approved</option>';
                $status.='<option value="canceled">Canceled</option>';
                }
                if($record['status']=='approved')
                {
                    $status.='<option value="approved" selected>Approved</option>';
                }
                if($record['status']=='canceled')
                {
                    $status.='<option value="canceled" selected>Canceled</option>';
                }
                $status.='</select>';
               
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['create_date']));
               $AppointmentDate=date("d-m-Y H:i:s",strtotime($record['appointment_date']));
            $officeid= $record['officeid'];  
            $office=$this->MoreModel->GetOfficeAddressdetail($officeid); 
            $officeaddress='';
		      if(!empty($office['add1'])){ $officeaddress.=$office['add1']; } 
		      if(!empty($office['add2'])){ $officeaddress.= ', '.$office['add2']; } 
		      if(!empty($office['city'])){ $officeaddress.= ', '.$office['city']; } 
		      if(!empty($office['region'])){ $officeaddress.= ', '.$office['region']; }
		      if(!empty($office['country'])){ $officeaddress.=', '.$office['country']; }
		      if(!empty($office['zipcode'])){ $officeaddress.= ', '.$office['zipcode']; }
								     
          $data[] = array( 
             "id"=>$i,
             "first_name"=>trim($record['name']),
             "email"=>$record['email'],
             "phone"=>"+".trim($record['phone']),
             "appointment_date"=>$AppointmentDate,
             "office"=>$officeaddress,
             "comment"=>$record['comment'],
             "status"=>$status,
             "action"=>$action,
          ); 
          
          
          $i++;
       }  
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function appointmentstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $appointmentid = $this->request->getVar('appointmentid');
             
             $this->MoreModel->update_appointment_status($status,$appointmentid); 
             
             $appointmentDetail=$this->MoreModel->GetAppointment($appointmentid);

        if($appointmentDetail) 
        {

                $emailtemplate=emailtemplates('appointment-booking-user');

                 $websettings=websettings();
                 $token = array('SITE_URL' => base_url(''),
                                'SITE_TITLE' => $websettings['company_title'],
                                'APPOINTMENT_DATE' => date("d-m-Y H:i:s",strtotime($appointmentDetail['appointment_date'])),
                                'USER_NAME' => trim($appointmentDetail['name']),
                                'USER_EMAIL' => $appointmentDetail['email'],
                                'USER_PHONE' => "+".trim($appointmentDetail['phone']),
                                'STATUS' => $status,
                                'COMMENT'=> $appointmentDetail['comment'],
                            );
                 $to=$appointmentDetail['email']; 
                 $this->send_email($emailtemplate,$token,$to);
        }     
    }
    
    public function send_email($emailtemplate,$token,$to)
    {
        $pattern = '[%s]';
        foreach ($token as $key => $val)
        {
            $varMap[sprintf($pattern, $key) ] = $val;
        }       
        $emailContent = strtr($emailtemplate['body'], $varMap);
        $subject = $emailtemplate['subject'];
        default_smtp_mail($emailContent,$subject,$to);
    }
    
    public function appointmentdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->appointment_delete($id);  
    }
    
    
    
    //follow Us
    
    public function addfollowus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add FollowUs";
        $data['followus'] = $this->MoreModel->getfollowus();
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addfollowus';
        return view('Admin/admin_index',$data);
    }
    public function insert_followus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('followus_icon')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/followus/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/followus/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('followus_language');
        $followus_title_arr = $this->request->getVar('followus_title');
        $followus_link = $this->request->getVar('followus_link');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_title=$this->lang_serialize($language_arr,$followus_title_arr);
        
        $data=array(
            'title'=>$serialized_title,
            'icon'=>$filepath,
            'link'=>$followus_link,
            'sequence'=>$sort_order,
            );
        
        $this->MoreModel->insert_followus($data); 
        return redirect()->to('/admin/followus');
    }
    
    public function editfollowus($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $followus= $this->MoreModel->getfollowusID($i);

        if(isset($followus))
        {
            $data['title']="Add FollowUs";
            $data['language'] = $this->MoreModel->getlanguage();
            $data['followus']  = $followus;
            $data['page'] ='editfollowus';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/followus');  
        }
    }
    
    public function update_followus($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('followus_icon')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/followus/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/followus/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('followus_language');
        $followus_title_arr = $this->request->getVar('followus_title');
        $followus_link = $this->request->getVar('followus_link');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_title=$this->lang_serialize($language_arr,$followus_title_arr);
        
        $data=array(
            'title'=>$serialized_title,
            'link'=>$followus_link,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['icon']=$filepath;
        }
        $this->MoreModel->update_followus($data,$id); 
        return redirect()->to('/admin/followus');
    }
    
    public function followus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='followus';
        return view('Admin/admin_index',$data);
    }
    public function getfollowus()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('followus')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('followus')
                                ->select('id')
                                ->Like('title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('followus')
            ->select('*')
            ->Like('title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $image='<img src="'.base_url().$record['icon'].'" class="table-img">';
           $follow_title=unserialize($record['title']);
           $followtitle=$follow_title['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editfollowus/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
          $data[] = array( 
             "id"=>$i,
             "Title"=>$followtitle,
             "Icon"=>$image,
             "FollowUsLink"=>$record['link'],
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function followusstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_followus_status($status,$id); 
             
    }
    
    public function followusdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->followus_delete($id);  
    }
    
    
    //Our Services
    
    public function addservices()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Service";
        $data['services'] = $this->MoreModel->getservices();
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addservices';
        return view('Admin/admin_index',$data);
    }
    public function insert_services()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_title_arr = $this->request->getVar('services_title_language');
        $services_title_arr = $this->request->getVar('services_title');
        $language_detail_arr = $this->request->getVar('services_detail_language');
        $services_detail_arr = $this->request->getVar('services_detail');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_title=$this->lang_serialize($language_title_arr,$services_title_arr);
        $serialized_detail=$this->lang_serialize($language_detail_arr,$services_detail_arr);
        
        $data=array(
            'title'=>$serialized_title,
            'details'=>$serialized_detail,
            'sequence'=>$sort_order,
            );
        
        $this->MoreModel->insert_services($data); 
        return redirect()->to('/admin/services');
    }
    
    public function editservice($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $services= $this->MoreModel->getservicesID($i);

        if(isset($services))
        {
            $data['title']="Edit Service";
            $data['language'] = $this->MoreModel->getlanguage();
            $data['services']  = $services;
            $data['page'] ='editservices';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/services');  
        }
    }
    
    public function update_service($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $language_title_arr = $this->request->getVar('services_title_language');
        $services_title_arr = $this->request->getVar('services_title');
        
        $language_detail_arr = $this->request->getVar('services_detail_language');
        $services_detail_arr = $this->request->getVar('services_detail');
        
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_title=$this->lang_serialize($language_title_arr,$services_title_arr);
        $serialized_detail=$this->lang_serialize($language_detail_arr,$services_detail_arr);
        
        $data=array(
            'title'=>$serialized_title,
            'details'=>$serialized_detail,
            'sequence'=>$sort_order,
        );
        $this->MoreModel->update_services($data,$id); 
        return redirect()->to('/admin/services');
    }
    
    public function services()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='services';
        return view('Admin/admin_index',$data);
    }
    public function getservices()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('services')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('services')
                                ->select('id')
                                ->Like('title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('services')
            ->select('*')
            ->Like('title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $ServiceTitle=unserialize($record['title']);
           $ServiceTitle=$ServiceTitle['en'];
           $ServiceDetail=unserialize($record['details']);
           $ServiceDetail=$ServiceDetail['en'];
            if(!$ServiceDetail)
            {
                $ServiceDetail="NONE";
            }
            
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editservice/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
          $data[] = array( 
             "id"=>$i,
             "ServiceTitle"=>$ServiceTitle,
             "ServiceDetail"=>$ServiceDetail,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function servicesstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_services_status($status,$id); 
             
    }
    
    public function servicesdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->services_delete($id);  
    }
    
    // email parameters
    public function add_email_parameter()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Email Parameters";
        $data['parameters'] = $this->MoreModel->get_email_parameters();
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addemailparameter';
        return view('Admin/admin_index',$data);
    }
    public function insert_email_parameter()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $email_template = $this->request->getVar('email_template_name');
        $parameters = $this->request->getVar('parameters');
        
        $data=array(
            'email_template'=>$email_template,
            'parameters'=>$parameters,
            'slug'=>slugify($email_template),
            );
        
        $this->MoreModel->insert_email_parameter($data); 
        return redirect()->to('/admin/email-parameters');
    }
    
    public function edit_email_parameter($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $email_parameters= $this->MoreModel->get_email_parameterID($i);

        if(isset($email_parameters))
        {
            $data['title']="Edit Email Parameters";
            $data['language'] = $this->MoreModel->getlanguage();
            $data['parameters'] = $this->MoreModel->get_email_parameters();
            $data['parameters']  = $email_parameters;
            $data['page'] ='editemailparameter';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/email-parameters');  
        }
    }
    
    public function update_email_parameter($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $email_template = $this->request->getVar('email_template_name');
        $parameters = $this->request->getVar('parameters');
        
        $data=array(
            'email_template'=>$email_template,
            'parameters'=>$parameters,
            'slug'=>slugify($email_template),
            );
        
        $this->MoreModel->update_email_parameters($data,$id); 
        return redirect()->to('/admin/email-parameters');
    }
    
    public function email_parameters()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='emailparameter';
        return view('Admin/admin_index',$data);
    }
    public function get_email_parameters()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('emailparameters')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('emailparameters')
                                ->select('id')
                                ->Like('email_template', $searchValue)
                                ->Like('parameters', $searchValue)
                                ->Like('slug', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('emailparameters')
            ->select('*')
            ->Like('email_template', $searchValue)
            ->Like('parameters', $searchValue)
            ->Like('slug', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-email-parameter/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
          $data[] = array( 
             "id"=>$i,
             "TemplateName"=>$record['email_template'],
             "TemplateSlug"=>$record['slug'],
             "Parameters"=>$record['parameters'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function email_parameter_status()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_email_parameters_status($status,$id); 
    }
    
    public function email_parameter_delete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->email_parameters_delete($id);  
    }
    
    // email templates
    public function add_email_template()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Email Templates";
        $data['parameters'] = $this->MoreModel->get_email_parameters();
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addemailtemplate';
        return view('Admin/admin_index',$data);
    }
    public function insert_email_template()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $email_template_slug = $this->request->getVar('email_template_name');
        $subject = $this->request->getVar('subject');
        $email_body = $this->request->getVar('email_body');
        $signature = $this->request->getVar('signature');
        
        $data=array(
            'email_template_slug'=>$email_template_slug,
            'subject'=>$subject,
            'body'=>$email_body,
            'signature'=>$signature,
            );
        
        $this->MoreModel->insert_email_template($data); 
        return redirect()->to('/admin/email-templates');
    }
    
    public function edit_email_template($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $email_templates= $this->MoreModel->get_email_templateID($i);

        if(isset($email_templates))
        {
            $data['title']="Edit Email templates";
            $data['language'] = $this->MoreModel->getlanguage();
            $data['parameters'] = $this->MoreModel->get_email_parameters();
            $data['templates']  = $email_templates;
            $data['page'] ='editemailtemplate';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/email-templates');  
        }
    }
    
    public function update_email_template($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $email_template_slug = $this->request->getVar('email_template_name');
        $subject = $this->request->getVar('subject');
        $email_body = $this->request->getVar('email_body');
        $signature = $this->request->getVar('signature');
        
        $data=array(
            'email_template_slug'=>$email_template_slug,
            'subject'=>$subject,
            'body'=>$email_body,
            'signature'=>$signature,
            );
        
        $this->MoreModel->update_email_templates($data,$id); 
        return redirect()->to('/admin/email-templates');
    }
    
    public function email_templates()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='emailtemplate';
        return view('Admin/admin_index',$data);
    }
    public function get_email_templates()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('emailtemplates')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('emailtemplates')
                                ->select('id')
                                ->Like('email_template_slug', $searchValue)
                                ->Like('subject', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('emailtemplates')
            ->select('*')
            ->Like('email_template_slug', $searchValue)
            ->Like('subject', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $email_template_slug=$record['email_template_slug'];
           $email_template_name= $this->MoreModel->get_email_parameterSLUG($email_template_slug);
           $TemplateName=$email_template_name['email_template'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edit-email-template/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
          $data[] = array( 
             "id"=>$i,
             "TemplateName"=>$TemplateName,
             "TemplateSlug"=>$email_template_slug,
             "Subject"=>$record['subject'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function email_template_status()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_email_templates_status($status,$id); 
    }
    
    public function email_template_delete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->email_templates_delete($id);  
    }
    
    public function GetRegion()
    {
        $countryid=$this->request->getVar('countryId');
        $GetRegion=$this->Api->GetRegion($countryid); 
        echo json_encode($GetRegion);
    }
    
    //tax
    public function tax()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $country=country();
        
        $data['GetCountry']=$country;
        $data['pagedata'] = $this->MoreModel->gettax();
        $data['page']='tax';
        return view('Admin/admin_index',$data);
    }
    public function addtax()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $country=country();
        $data['GetCountry']=$country;
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addtax';
        return view('Admin/admin_index',$data);
    }
    public function insert_tax()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $language_tax_arr = $this->request->getVar('tax_language');
        $tax_name_arr = $this->request->getVar('tax_name');
        $serialized_name=$this->lang_serialize($language_tax_arr,$tax_name_arr);
        
        $tax = $this->request->getVar('tax');
        $countryid = $this->request->getVar('country');
        $regionid = $this->request->getVar('region');

        $countryname=countryname($countryid);
		if($regionid=='' || $regionid=='all')
		{
			$regionname='All';
		}
		else
		{
			$regionname=regionname($regionid);
		}
		
        $data=array(
            'tax_name'=>$serialized_name,
            'countryid'=>$countryid,
            'regionid'=>$regionid,
            'country'=>$countryname,
            'region'=>$regionname,
            'tax'=>trim($tax,"%"),
            );

        
        $this->MoreModel->insert_tax($data); 
        return redirect()->to('/admin/tax'); 
     
    }
    
    public function edittax($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $tax= $this->MoreModel->gettaxID($i);

        if(isset($tax))
        {
            $data['tax']  = $tax;
            $country=country();
            $data['GetCountry']=$country;
            $data['language'] = $this->MoreModel->getlanguage();
            $data['page'] ='edittax';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/tax');  
        }
        
    }
    
    public function update_tax($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_tax_arr = $this->request->getVar('tax_language');
        $tax_name_arr = $this->request->getVar('tax_name');
        $serialized_name=$this->lang_serialize($language_tax_arr,$tax_name_arr);
        
        $tax = $this->request->getVar('tax');
        $countryid = $this->request->getVar('country');
        $regionid = $this->request->getVar('region');
		
		$countryname=countryname($countryid);
		if($regionid=='' || $regionid=='all')
		{
			$regionname='All';
		}
		else
		{
			$regionname=regionname($regionid);
		}
           
        $data=array(
            'tax_name'=>$serialized_name,
            'countryid'=>$countryid,
            'regionid'=>$regionid,
            'country'=>$countryname,
            'region'=>$regionname,
            'tax'=>trim($tax,"%"),
            );
        $this->MoreModel->update_tax($data,$id); 
        return redirect()->to('/admin/tax');
    }
    
    public function gettax()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('tax')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('tax')
                                ->select('id')
                                ->orLike('country', $searchValue)
                                ->orLike('region', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('tax')
            ->select('*')
            ->orLike('tax', $searchValue)
            ->orLike('country', $searchValue)
            ->orLike('region', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();
 
       $data = array();
        $i=1;
       $GetCountry=country();
       
       foreach($records as $record ){
           $countryname=$record['country'];
           $regionname=$record['region'];

           $tax_name=unserialize($record['tax_name']);
           $taxname=$tax_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/edittax/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['create_date']));

               
			$data[] = array( 
				 "id"=>$i,
				 "Country"=>$countryname,
				 "Region"=>$regionname,
				 "Tax"=>$record['tax']."%",
				 "Tax_Name"=>$taxname,
				 "Status"=>$status,
				 "date"=>$date,
				 "action"=>$action,
			);           
			$i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function taxstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_tax_status($status,$id); 
    }
    
    public function taxdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MoreModel->tax_delete($id);  
    }
    
    
    
    //shipping
    public function shipping()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $country=country();
        $data['GetCountry']=$country;
        $data['pagedata'] = $this->MoreModel->getshipping();
        $data['page']='shipping';
        return view('Admin/admin_index',$data);
    }
    
    public function addshipping()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $country=country();
        $data['GetCountry']=$country;
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addshipping';
        return view('Admin/admin_index',$data);
    }
    public function insert_shipping()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $language_shipping_arr = $this->request->getVar('shipping_language');
        $shipping_name_arr = $this->request->getVar('shipping_name');
        $serialized_name=$this->lang_serialize($language_shipping_arr,$shipping_name_arr);
        
        $shipping = $this->request->getVar('shipping');
        $country = $this->request->getVar('country');
    $countryid = $this->request->getVar('country');
        $regionid = $this->request->getVar('region');

          $GetCountry=country();
           $countryname='';
           $regionname='';
           if(isset($GetCountry))
           {
                if($GetCountry->success==true)
                {
                    foreach($GetCountry->data as  $country)
                    {
                        if($countryid==$country->id)
                        {
                          $countryname  =$country->name;
                          $countryid=$country->id;
                          $GetRegion=$this->Api->GetRegion($countryid); 
                          if(isset($GetRegion))
                           {
                                if($GetRegion->success==true)
                                {
                                    foreach($GetRegion->data as  $region)
                                    {
                                        if($regionid==$region->id)
                                        {
                                            $regionname=$region->name;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

        $data=array(
            'shipping_name'=>$serialized_name,
            'countryid'=>$countryid,
            'regionid'=>$regionid,
            'country'=>$countryname,
            'region'=>$regionname,
            'shipping'=>$shipping,
            );
        
        $this->MoreModel->insert_shipping($data); 
        return redirect()->to('/admin/shipping'); 
     
    }
    
    public function editshipping($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $shipping= $this->MoreModel->getshippingID($i);

        if(isset($shipping))
        {
            $data['shipping']  = $shipping;
            $country=country();
            $data['GetCountry']=$country;
            $data['language'] = $this->MoreModel->getlanguage();
            $data['page'] ='editshipping';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/shipping');  
        }
        
    }
    
    public function update_shipping($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_shipping_arr = $this->request->getVar('shipping_language');
        $shipping_name_arr = $this->request->getVar('shipping_name');
        $serialized_name=$this->lang_serialize($language_shipping_arr,$shipping_name_arr);
        
        $shipping = $this->request->getVar('shipping');
        $countryid = $this->request->getVar('country');
        $regionid = $this->request->getVar('region');

          $GetCountry=country();
           $countryname='';
           $regionname='';
           if(isset($GetCountry))
           {
                if($GetCountry->success==true)
                {
                    foreach($GetCountry->data as  $country)
                    {
                        if($countryid==$country->id)
                        {
                          $countryname  =$country->name;
                          $countryid=$country->id;
                          $GetRegion=$this->Api->GetRegion($countryid); 
                          if(isset($GetRegion))
                           {
                                if($GetRegion->success==true)
                                {
                                    foreach($GetRegion->data as  $region)
                                    {
                                        if($regionid==$region->id)
                                        {
                                            $regionname=$region->name;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

        $data=array(
            'shipping_name'=>$serialized_name,
            'countryid'=>$countryid,
            'regionid'=>$regionid,
            'country'=>$countryname,
            'region'=>$regionname,
            'shipping'=>$shipping,
            );
        
        $this->MoreModel->update_shipping($data,$id); 
        return redirect()->to('/admin/shipping');
    }
    
    public function getshipping()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('shipping')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('shipping')
                                ->select('id')
                                ->orLike('shipping', $searchValue)
                                ->orLike('country', $searchValue)
                                ->orLike('region', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('shipping')
            ->select('*')
            ->orLike('shipping', $searchValue)
            ->orLike('country', $searchValue)
            ->orLike('region', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();
 
       $data = array();
       $i=1;
       $GetCountry=country();
       
       foreach($records as $record ){
           $countryname=$record['country'];
           $regionname=$record['region'];
           
            
           $shipping_name=unserialize($record['shipping_name']);
           $shippingname=$shipping_name['en'];
           $status='';
           if($record['Status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editshipping/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               $action.='</span">';
               $date=date("d-m-Y H:i:s",strtotime($record['create_date']));

               
          $data[] = array( 
             "id"=>$i,
             "Country"=>$countryname,
             "Region"=>$regionname,
             "Shipping"=>$record['shipping'],
             "Shipping_Name"=>$shippingname,
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          
          $i++;
       }

       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);
   
    }
    public function shippingstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_shipping_status($status,$id); 
    }
    
    public function shippingdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $id = $this->request->getVar('id');
            $this->MoreModel->shipping_delete($id);  
    }
    
    
    // newsletter setting
    
    public function newslettersetting()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $newslettersetting= $this->MoreModel->getnewslettersetting();

            $data['newslettersetting']  = $newslettersetting;
            $data['language'] = $this->MoreModel->getlanguage();
            $data['page'] ='newslettersetting';
            return view('Admin/admin_index',$data);
        
    }


    public function update_newslettersetting()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        
        $newsletter_titlelanguage_arr = $this->request->getVar('newsletter_title_language');
        $newsletter_title_arr = $this->request->getVar('newsletter_title');
        $serialized_newsletter_title=$this->lang_serialize($newsletter_titlelanguage_arr,$newsletter_title_arr);
        
        $newsletter_desclanguage_arr = $this->request->getVar('newsletter_desc_language');
        $newsletter_desc_arr = $this->request->getVar('newsletter_desc');
        $serialized_newsletter_desc=$this->lang_serialize($newsletter_desclanguage_arr,$newsletter_desc_arr);

        $data=array(
            'newsletter_title'=>$serialized_newsletter_title,
            'newsletter_desc'=>$serialized_newsletter_desc,
            );

        $this->MoreModel->update_newslettersetting($data); 
        return redirect()->to('/admin/newsletter-setting');
    }
    
    
    //Website Partners
    
    public function addwebpartner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add FollowUs";
        $data['webpartner'] = $this->MoreModel->getwebpartner();
        $data['language'] = $this->MoreModel->getlanguage();
        $data['page']='addwebpartner';
        return view('Admin/admin_index',$data);
    }
    public function insert_webpartner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('partner_logo')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/partner_logo/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/partner_logo/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('webpartner_language');
        $webpartner_title_arr = $this->request->getVar('webpartner_title');
        $serialized_title=$this->lang_serialize($language_arr,$webpartner_title_arr);
        
        $partner_website = $this->request->getVar('partner_website');
        $sort_order = $this->request->getVar('sort_order');
        
        
        
        $data=array(
            'title'=>$serialized_title,
            'image'=>$filepath,
            'website'=>$partner_website,
            'sequence'=>$sort_order,
            );
        
        $this->MoreModel->insert_webpartner($data); 
        return redirect()->to('/admin/webpartner');
    }
    
    public function editwebpartner($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $webpartner= $this->MoreModel->getwebpartnerID($i);

        if(isset($webpartner))
        {
            $data['title']="Add FollowUs";
            $data['language'] = $this->MoreModel->getlanguage();
            $data['webpartner']  = $webpartner;
            $data['page'] ='editwebpartner';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/webpartner');  
        }
    }
    
    public function update_webpartner($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        if($file = $this->request->getFile('partner_logo')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $file->getRandomName(); 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/partner_logo/', $newName);

                         // File path to display preview
                         $filepath = "public/uploads/partner_logo/".$newName;
                    }
                    else
                    {
                        $filepath='';
                    }
         }  
         else
         {
            $filepath='';
         }
        
        $language_arr = $this->request->getVar('webpartner_language');
        $webpartner_title_arr = $this->request->getVar('webpartner_title');
        $serialized_title=$this->lang_serialize($language_arr,$webpartner_title_arr);
        
        $partner_website = $this->request->getVar('partner_website');
        $sort_order = $this->request->getVar('sort_order');
        
        
        
        $data=array(
            'title'=>$serialized_title,
            'website'=>$partner_website,
            'sequence'=>$sort_order,
            );
        if($filepath!='')
        {
            $data['image']=$filepath;
        }
        $this->MoreModel->update_webpartner($data,$id); 
        return redirect()->to('/admin/webpartner');
    }
    
    public function webpartner()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['page']='webpartner';
        return view('Admin/admin_index',$data);
    }
    public function getwebpartner()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('webpartner')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('webpartner')
                                ->select('id')
                                ->Like('title', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('webpartner')
            ->select('*')
            ->Like('title', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $image='<img src="'.base_url().$record['image'].'" class="table-img">';
           $title=unserialize($record['title']);
           $title=$title['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editwebpartner/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['date']));
               
          $data[] = array( 
             "id"=>$i,
             "Title"=>$title,
             "Logo"=>$image,
             "Website"=>$record['website'],
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function webpartnerstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MoreModel->update_webpartner_status($status,$id); 
             
    }
    
    public function webpartnerdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MoreModel->webpartner_delete($id);  
    }
    

}
