<?php
namespace App\Controllers\Admin;
use App\Models\OrderModel;
use App\Models\HomeModel;
use App\Controllers\BaseController;
use App\Controllers\RenderImage;
use Dompdf\Dompdf;
class Order extends BaseController
{
    public function __construct(){
      
        $this->OrderModel = new OrderModel(); 
		$this->HomeModel = new HomeModel(); 		
    }
    
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    
    public function lang_slug($unserializeName)
    {
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
        }
    }
    
    public function productsreviews()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Products Reviews";
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='product_reviews';
        return view('Admin/admin_index',$data);
    }
    
    
    public function GetProductsReviews()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
		if(isset($dtpostData['userid']))
		{
			$userid=intval($dtpostData['userid']);
		}
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('productreview');
                     $totalRecords->select('id');
					if(isset($dtpostData['userid']))
					{
						$totalRecords->where('userid', $userid);
					}
					
        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('productreview');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('updatedate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('updatedate <=', $endDate);
                                }
								if(isset($dtpostData['userid']))
								{
									$totalRecordwithFilter->where('userid', $userid);
								}
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('productreview');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            
            if(!empty($stratDate))
            {
                $records->where('updatedate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('updatedate <=', $endDate);
            }
			if(isset($dtpostData['userid']))
			{
				$records->where('userid', $userid);
			}
            $records->orderBy('updatedate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

        $data = array();
        $i=1+$start;

        foreach($records as $record )
        {
           $productid=$record['productid'];
           $userid=$record['userid'];
           $orderid=$record['orderid'];
           $orderItemDetail=$this->HomeModel->orderItemDetail($orderid,$userid,$productid);
           if($orderItemDetail)
           {
               $image='<img src="'.settings('product_thumbnail_url').$orderItemDetail['image'].'" class="table-img">';
               $productname=$orderItemDetail['productname'];
           }
           else
           {
               continue;
           }
           
           $userprofile=$this->HomeModel->GetUserProfile($userid);
           if($userprofile)
           {
               $name=trim($userprofile['first_name'].' '.$userprofile['last_name']);
               $email=$userprofile['email'];
               $phone=$userprofile['phone'];
           }
           else
           {
               $name='';
               $email='';
               $phone='';
           }
           
           $rate=$record['rate'];
           $rateview='';
            $rateview.='<div class="rate">';
			if($rate>=1){ $checkclass="checkedstar"; } else { $checkclass="";}
             $rateview.='<label class="'.$checkclass.'" for="star1'.$orderid.$productid.'" title="1 star">1 star</label>';
             if($rate>=2){ $checkclass="checkedstar"; } else { $checkclass="";}
             $rateview.='<label class="'.$checkclass.'" for="star2'.$orderid.$productid.'" title="2 star">2 star</label>';
             if($rate>=3){ $checkclass="checkedstar"; } else { $checkclass="";}
             $rateview.='<label class="'.$checkclass.'" for="star3'.$orderid.$productid.'" title="3 star">3 star</label>';
              if($rate>=4){ $checkclass="checkedstar"; } else { $checkclass="";}
             $rateview.='<label class="'.$checkclass.'" for="star4'.$orderid.$productid.'" title="4 star">4 star</label>';
             if($rate>=5){ $checkclass="checkedstar"; } else { $checkclass="";}
             $rateview.='<label class="'.$checkclass.'" for="star5'.$orderid.$productid.'" title="5 star">5 star</label>';
             $rateview.='</div>';
		    $comment=$record['comment'];
		    $action='';
		    $status='';
           if($record['status']==1)
           {
               
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
            $status.='<div class="square-switch">';
            $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
            $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
            $status.='</div>';
                
		    $date=date("d-m-Y H:i:s",strtotime($record['updatedate']));
          $data[] = array( 
             "sr"=>$i.'.',
             "Image"=>$image,
             "Product"=>$productname,
             "user_name"=>$name,
			 "email"=>$email,
			 "phone"=>$phone,
             "Reviews"=>$rateview,
			 "Comment"=>$comment,
             "Date"=>$date,
             "action"=>$status,
            ); 
            
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    
    public function productsreviewstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->OrderModel->update_productsreview_status($status,$id); 
             
    }
    
    
    public function ordersreviews()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Orders Reviews";
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='orders_reviews';
        return view('Admin/admin_index',$data);
    }
    
    
    public function GetOrdersReviews()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
		if(isset($dtpostData['userid']))
		{
			$userid=intval($dtpostData['userid']);
		}
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
        ## Total number of records without filtering
        $totalRecords = $this->db->table('orderreview');
        $totalRecords->select('id');
		if(isset($dtpostData['userid']))
		{
			$totalRecords->where('userid', $userid);
		}
					
        $totalRecords= $totalRecords->countAllResults();

        ## Total number of records with filtering
        $totalRecordwithFilter = $this->db->table('orderreview');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('updatedate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('updatedate <=', $endDate);
                                }
								if(isset($dtpostData['userid']))
								{
									$totalRecordwithFilter->where('userid', $userid);
								}
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('orderreview');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            
            if(!empty($stratDate))
            {
                $records->where('updatedate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('updatedate <=', $endDate);
            }
			if(isset($dtpostData['userid']))
			{
				$records->where('userid', $userid);
			}
            $records->orderBy('updatedate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

        $data = array();
        $i=1+$start;

        foreach($records as $record )
        {
           $userid=$record['userid'];
           $orderid=$record['orderid'];
          
           $userprofile=$this->HomeModel->GetUserProfile($userid);
           if($userprofile)
           {
               $name=trim($userprofile['first_name'].' '.$userprofile['last_name']);
               $email=$userprofile['email'];
               $phone=$userprofile['phone'];
           }
           else
           {
               $name='';
               $email='';
               $phone='';
           }
           
            $rate=$record['rate'];
                $rateview='';
                $rateview.='<div class="rate">';
			if($rate>=1){ $checkclass="checkedstar"; } else { $checkclass="";}
                $rateview.='<label class="'.$checkclass.'" for="star1'.$orderid.'" title="1 star">1 star</label>';
            if($rate>=2){ $checkclass="checkedstar"; } else { $checkclass="";}
                $rateview.='<label class="'.$checkclass.'" for="star2'.$orderid.'" title="2 star">2 star</label>';
            if($rate>=3){ $checkclass="checkedstar"; } else { $checkclass="";}
                $rateview.='<label class="'.$checkclass.'" for="star3'.$orderid.'" title="3 star">3 star</label>';
            if($rate>=4){ $checkclass="checkedstar"; } else { $checkclass="";}
                $rateview.='<label class="'.$checkclass.'" for="star4'.$orderid.'" title="4 star">4 star</label>';
            if($rate>=5){ $checkclass="checkedstar"; } else { $checkclass="";}
                $rateview.='<label class="'.$checkclass.'" for="star5'.$orderid.'" title="5 star">5 star</label>';
                $rateview.='</div>';
		    $comment=$record['comment'];
		    $action='';
		    $status='';
            if($record['status']==1)
            {
               
              $checked='checked=""'; 
            }
            else
            {
               $checked=''; 
            }
            
            $status.='<div class="square-switch">';
            $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
            $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
            $status.='</div>';
                
		    $date=date("d-m-Y H:i:s",strtotime($record['updatedate']));
            $data[] = array( 
                 "sr"=>$i.'.',
                 "orderid"=>$orderid,
                 "user_name"=>$name,
    			 "email"=>$email,
    			 "phone"=>$phone,
                 "Reviews"=>$rateview,
    			 "Comment"=>$comment,
                 "Date"=>$date,
                 "action"=>$status,
            ); 
            $i++;
       }
       ## Response
       $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordwithFilter,
            "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    
    public function ordersreviewstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->OrderModel->update_ordersreview_status($status,$id); 
             
    }
    
    public function payments()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $data=[];
        $data['title']="Order Payments";
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='order_payments';
        return view('Admin/admin_index',$data);
    }
    
    public function Getpayments()
    {
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('payments');
                     $totalRecords->select('id');
					 
        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('payments');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->groupStart();
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                $totalRecordwithFilter->orLike('txn_id', $searchValue);
                                $totalRecordwithFilter->orLike('payment_gross', $searchValue);
                                $totalRecordwithFilter->orLike('payer_name', $searchValue);
                                $totalRecordwithFilter->orLike('payer_email', $searchValue);
                                $totalRecordwithFilter->orLike('paymenttype', $searchValue);
                                $totalRecordwithFilter->orLike('paymentStatus', $searchValue);
                                $totalRecordwithFilter->groupEnd();
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('createDate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('createDate <=', $endDate);
                                }
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('payments');
            $records->select('*');
            $records->groupStart();
            $records->Like('orderid', $searchValue);
            $records->orLike('txn_id', $searchValue);
            $records->orLike('payment_gross', $searchValue);
            $records->orLike('payer_name', $searchValue);
            $records->orLike('payer_email', $searchValue);
            $records->orLike('paymenttype', $searchValue);
            $records->orLike('paymentStatus', $searchValue);
            $records->groupEnd();
            if(!empty($stratDate))
            {
                $records->where('createDate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('createDate <=', $endDate);
            }
		
            $records->orderBy('createDate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
            $date=date("d-m-Y H:i:s",strtotime($record['createDate']));
			$orderid=$record['orderid'];
			$userid=$record['userid'];
			
			if($record['paymentStatus']=='Paid')
			{
				$paymentstatus='<span class="badge bg-success" >Paid</span>';
			}
			else
			{
			   $paymentstatus='<span class="badge bg-danger" >'.$record['paymentStatus'].'</span>';
			}
			   $action='';
			   $action.='<span class="action-buttons ">';
               $action.='<span title="View Payments Detail" class="view-button">';
               $action.='<a href="'.base_url().'admin/payment-view/'.$record['txn_id'].'"  class="btn btn-success waves-effect waves-light view-record">';
               $action.='<i class="mdi mdi-eye-outline"></i>';
               $action.='</a></span>';
               $action.='</span">';
			  
            //   $action.='<span class="action-buttons ">';
            //   $action.='<span title="Delete Payment Detail" class="view-button">';
            //   $action.='<a href="javascript:void(0)" data-txn_id="'.$record['txn_id'].'" class="btn btn-danger waves-effect waves-light view-record">';
            //   $action.='<i class="mdi mdi-delete-forever"></i>';
            //   $action.='</a></span>';
            //   $action.='</span">';	
		    
		    
		        $orderDetails=$this->OrderModel->orderDetail($orderid);
		    
				$amount='';
				$amount.='<span style="text-wrap: wrap;font-weight: bold;    color: #b52a57;">'.$orderDetails['currency']." ".number_format($record['payment_gross'],2).'</span>';
	            $orderid='<a title="View Order Detail" href="'.base_url().'admin/order/edit/'.$record['orderid'].'"  >'.$record['orderid'].'</a>';
	            
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$orderid,
             "txn_id"=>$record['txn_id'],
             "payment_gross"=>$amount,
			 "payer_name"=>$record['payer_name'],
			 "payer_email"=>$record['payer_email'],
             "paymenttype"=>$record['paymenttype'],
			 "paymentStatus"=>$paymentstatus,
             "createDate"=>$date,
             "action"=>$action,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function payments_view($txnid)
    {
           if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		$paymentDetail=$this->OrderModel->paymentDetail($txnid);
        if(isset($paymentDetail))
        {  
            $userid =$paymentDetail['userid'];
            $orderid =$paymentDetail['orderid'];
            $orderDetail=$this->OrderModel->orderDetail($orderid);
            $txn_id=$paymentDetail['txn_id'];
			$data['txn_id']=$txn_id;
			$data['record']=$paymentDetail;
			$data['orderid']=$orderid;
			$data['order']=$orderDetail;
            $data['page']='view_payment';
            return view('Admin/admin_index',$data);
        }
		else
		{
			return redirect()->to('/admin/payments');
		}   
    }
    
    
    public function index()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Order history";
        $orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='order';
        return view('Admin/admin_index',$data);
    }
    
    
    public function Getorders()
    {
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $orderstatus = $dtpostData['orderstatus'];
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
		if(isset($dtpostData['userid']))
		{
			$userid=intval($dtpostData['userid']);
		}
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('masterorders');
                     $totalRecords->select('id');
					 if(isset($dtpostData['userid']))
					{
						$totalRecords->where('userid', $userid);
					}
        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                if(!empty($orderstatus))
                                {
                                    $totalRecordwithFilter->Like('status', $orderstatus);   
                                }
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('orderdate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('orderdate <=', $endDate);
                                }
								if(isset($dtpostData['userid']))
								{
									$totalRecordwithFilter->where('userid', $userid);
								}
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('masterorders');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            if(!empty($orderstatus))
            {
                $records->Like('status', $orderstatus);   
            }
            if(!empty($stratDate))
            {
                $records->where('orderdate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('orderdate <=', $endDate);
            }
			if(isset($dtpostData['userid']))
			{
				$records->where('userid', $userid);
			}
            $records->orderBy('orderdate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
		   $orderStatus=$this->OrderModel->getorderStatus();
		   $orderStatushtml='';
            $apiflaghtml='';
		   $orderStatushtml.='<select class="orderStatusChange" data-orderid="'.$record['orderid'].'">';
		   if($record['status']=='pending')
		   {
			$orderStatushtml.='<option value="pending" >Pending</option>';
		   }


		   foreach($orderStatus as $orderStatusRow)
		   {
			   if($record['status']==$orderStatusRow["slug"])
			   {
			      $orderStatushtml.='<option selected value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>';
			   }
			   else
			   {
				  $orderStatushtml.='<option value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>'; 
			   }
		   }
		   
		   $orderStatushtml.='</select>';
            
           
             if($record['api_flag']==0)
		   {
            
			$apiflaghtml.='<a href="javascript:void(0)" data-orderid="'.$record['orderid'].'" data-userid="'.$record['userid'].'" class="btn btn-warning waves-effect waves-light apiflagChange">Sync order</a>';
             

		   }else{
            $apiflaghtml='<span class="badge bg-success" >Synced</span>';
           }

		   if($record['status']=='failed' || $record['orderStatus']==0)
		   {
		       $orderStatushtml="NONE";
		   }
           $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="badge bg-success" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="badge bg-warning" >Pending</span>';
 //              $status.='<br><span title="Refund Amount" class="refund-button" >';
 //              $status.='<a href="javascript:void(0)" data-id="'.$record['orderid'].'" class="refundAmount">';
 //              $status.='<i class=" bx bx-undo"></i> Refund';
 //              $status.='</a></span>';
              
           }
          
           elseif($record['status']=='cancelled')
           {
               $status='<span class="badge bg-danger" >Cancelled</span>';
               
           }
           elseif($record['status']=='refunded')
           {
               $status='<span class="badge bg-info" >Refunded</span>';
               
           }
           elseif($record['status']=='failed')
           {
               $status='<span class="badge bg-danger" >Failed</span>';
              
           }
    		else
    		{
    			$status=$record['status'];
    			$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
    			if($GetStatusDetail)
    			{
    				$orderStatus=$GetStatusDetail['status_title'];
    			}	
    			else
    			{
    				$orderStatus=$record['status'];
    			}
    		    $status='<span class="badge bg-success" >'.$orderStatus.'</span>';
    	    }
    	    
            $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
			$orderid=$record['orderid'];
			$userid=$record['userid'];
			
            $orderpaymentDetail=$this->OrderModel->GetpaymentDetail($orderid,$userid);  
			if($orderpaymentDetail['paymentStatus']=='Paid')
			{
				
				$paymentstatus='<span class="badge bg-success" >Paid</span>';
               
			}
			else
			{
				
			   $paymentstatus='<span class="badge bg-danger" >'.$orderpaymentDetail['paymentStatus'].'</span>';
               
			}
			
			 $action.='<span class="action-buttons ">';
               $action.='<span title="Edit Order" class="view-button">';
               $action.='<a href="'.base_url().'admin/order/edit/'.$record['orderid'].'"  class="btn btn-danger waves-effect waves-light view-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               $action.='</span">';
			  
               $action.='<span class="action-buttons ">';
               $action.='<span title="View Order Detail" class="view-button">';
               $action.='<a href="javascript:void(0)" data-orderid="'.$record['orderid'].'" class="btn btn-success waves-effect waves-light view-record orderview">';
               $action.='<i class="mdi mdi-eye-outline"></i>';
               $action.='</a></span>';
               $action.='</span">';	
			
				$orderamount='';
				$orderamount.='<span style="text-wrap: wrap;font-weight: bold;    color: #b52a57;">'.$record['currency']." ".number_format($record['total_amount'],2).'</span>';
			   
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$record['orderid'],
             "ShippingDate"=>$record['shipping_date'],
             "amount"=>$orderamount,
			 "paymentMethod"=>$orderpaymentDetail['paymenttype'],
			 "paymentStatus"=>$paymentstatus,
             "orderstatus"=>$status,
			 "updateStatus"=>$orderStatushtml,
             "orderdate"=>$date,
             "api_flag"=>$apiflaghtml,
             "action"=>$action,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function Getrecentorders()
    {
        
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('masterorders');
                    $totalRecords->select('id');
                    $totalRecords->groupStart();
                    $totalRecords->where('status!=', 'failed');
                    $totalRecords->Where('orderStatus!=', 0);
                    $totalRecords->groupEnd();

        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                $totalRecordwithFilter->groupStart();
                                $totalRecordwithFilter->where('status!=', 'failed');
                                $totalRecordwithFilter->Where('orderStatus!=', 0);
                                $totalRecordwithFilter->groupEnd();
			
                                
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('masterorders');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            $records->groupStart();
            $records->where('status!=', 'failed');
            $records->Where('orderStatus!=', 0);
            $records->groupEnd();
			
            $records->orderBy('orderdate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
		   
           $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="badge bg-success" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="badge bg-warning" >Pending</span>';
 //              $status.='<br><span title="Refund Amount" class="refund-button" >';
 //              $status.='<a href="javascript:void(0)" data-id="'.$record['orderid'].'" class="refundAmount">';
 //              $status.='<i class=" bx bx-undo"></i> Refund';
 //              $status.='</a></span>';
              
           }
          
           elseif($record['status']=='cancelled')
           {
               $status='<span class="badge bg-danger" >Cancelled</span>';
               
           }
           elseif($record['status']=='refunded')
           {
               $status='<span class="badge bg-info" >Refunded</span>';
               
           }
           elseif($record['status']=='failed')
           {
               $status='<span class="badge bg-danger" >Failed</span>';
              
           }
    		else
    		{
    			$status=$record['status'];
    			$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
    			if($GetStatusDetail)
    			{
    				$orderStatus=$GetStatusDetail['status_title'];
    			}	
    			else
    			{
    				$orderStatus=$record['status'];
    			}
    		    $status='<span class="badge bg-success" >'.$orderStatus.'</span>';
    	    }
    	    
            $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
			$orderid=$record['orderid'];
			$userid=$record['userid'];
			
            $orderpaymentDetail=$this->OrderModel->GetpaymentDetail($orderid,$userid);  
			if($orderpaymentDetail['paymentStatus']=='Paid')
			{
				
				$paymentstatus='<span class="badge bg-success" >Paid</span>';
               
			}
			else
			{
				
			   $paymentstatus='<span class="badge bg-danger" >'.$orderpaymentDetail['paymentStatus'].'</span>';
               
			}
			
			$orderCustomeDetail=$this->OrderModel->GeCustomeDetail($userid);  
			
				$orderamount='';
				$orderamount.='<span style="text-wrap: wrap;font-weight: bold;    color: #b52a57;">'.$record['currency']." ".number_format($record['total_amount'],2).'</span>';
			
			$orderid='<a href="'.base_url().'admin/order/edit/'.$record['orderid'].'"  >'.$record['orderid'].'</a>';
			
			 
          $data[] = array( 
             "orderid"=>$orderid,
             "customer"=>trim($orderCustomeDetail['first_name']." ".$orderCustomeDetail['last_name']),
             "amount"=>$orderamount,
			 "paymentMethod"=>$orderpaymentDetail['paymenttype'],
			 "paymentStatus"=>$paymentstatus,
             "orderstatus"=>$status,
             "orderdate"=>$date,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    
    }
    
    public function pending_order(){
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Pending Order History";
        $orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='pending_order';
        return view('Admin/admin_index',$data);
    }
    
    
    public function Getpendingorders()
    {
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
		
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('masterorders');
                    $totalRecords->select('id');
					$totalRecords->where('status', 'pending');
                    $totalRecords->where('orderStatus', 1);
        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                $totalRecordwithFilter->where('status', 'pending');
                                $totalRecordwithFilter->where('orderStatus', 1);
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('orderdate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('orderdate <=', $endDate);
                                }
								
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('masterorders');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            $records->where('status', 'pending');
            $records->where('orderStatus', 1);
            if(!empty($stratDate))
            {
                $records->where('orderdate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('orderdate <=', $endDate);
            }
			
            $records->orderBy('orderdate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
		   $orderStatus=$this->OrderModel->getorderStatus();
		   $orderStatushtml='';
		   $orderStatushtml.='<select class="orderStatusChange" data-orderid="'.$record['orderid'].'">';
		   if($record['status']=='pending')
		   {
			$orderStatushtml.='<option value="pending" >Pending</option>';
		   }
		   foreach($orderStatus as $orderStatusRow)
		   {
			   if($record['status']==$orderStatusRow["slug"])
			   {
			      $orderStatushtml.='<option selected value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>';
			   }
			   else
			   {
				  $orderStatushtml.='<option value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>'; 
			   }
		   }
		   
		   $orderStatushtml.='</select>';
		   if($record['status']=='failed' || $record['orderStatus']==0)
		   {
		       $orderStatushtml="NONE";
		   }
           $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="badge bg-success" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="badge bg-warning" >Pending</span>';
 //              $status.='<br><span title="Refund Amount" class="refund-button" >';
 //              $status.='<a href="javascript:void(0)" data-id="'.$record['orderid'].'" class="refundAmount">';
 //              $status.='<i class=" bx bx-undo"></i> Refund';
 //              $status.='</a></span>';
              
           }
          
           elseif($record['status']=='cancelled')
           {
               $status='<span class="badge bg-danger" >Cancelled</span>';
               
           }
           elseif($record['status']=='refunded')
           {
               $status='<span class="badge bg-info" >Refunded</span>';
               
           }
           elseif($record['status']=='failed')
           {
               $status='<span class="badge bg-danger" >Failed</span>';
              
           }
    		else
    		{
    			$status=$record['status'];
    			$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
    			if($GetStatusDetail)
    			{
    				$orderStatus=$GetStatusDetail['status_title'];
    			}	
    			else
    			{
    				$orderStatus=$record['status'];
    			}
    		    $status='<span class="badge bg-success" >'.$orderStatus.'</span>';
    	    }
    	    
            $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
			$orderid=$record['orderid'];
			$userid=$record['userid'];
			
            $orderpaymentDetail=$this->OrderModel->GetpaymentDetail($orderid,$userid);  
			if($orderpaymentDetail['paymentStatus']=='Paid')
			{
				
				$paymentstatus='<span class="badge bg-success" >Paid</span>';
               
			}
			else
			{
				
			   $paymentstatus='<span class="badge bg-danger" >'.$orderpaymentDetail['paymentStatus'].'</span>';
               
			}
			
			 $action.='<span class="action-buttons ">';
               $action.='<span title="Edit Order" class="view-button">';
               $action.='<a href="'.base_url().'admin/order/edit/'.$record['orderid'].'"  class="btn btn-danger waves-effect waves-light view-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               $action.='</span">';
			  
               $action.='<span class="action-buttons ">';
               $action.='<span title="View Order Detail" class="view-button">';
               $action.='<a href="javascript:void(0)" data-orderid="'.$record['orderid'].'" class="btn btn-success waves-effect waves-light view-record orderview">';
               $action.='<i class="mdi mdi-eye-outline"></i>';
               $action.='</a></span>';
               $action.='</span">';	
			
				$orderamount='';
				$orderamount.='<span style="text-wrap: wrap;font-weight: bold;    color: #b52a57;">'.$record['currency']." ".number_format($record['total_amount'],2).'</span>';
			   
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$record['orderid'],
             "ShippingDate"=>$record['shipping_date'],
             "amount"=>$orderamount,
			 "paymentMethod"=>$orderpaymentDetail['paymenttype'],
			 "paymentStatus"=>$paymentstatus,
             "orderstatus"=>$status,
			 "updateStatus"=>$orderStatushtml,
             "orderdate"=>$date,
             "action"=>$action,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    
    
    public function completed_order(){
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Completed Order History";
        $orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='completed-order';
        return view('Admin/admin_index',$data);
    }
    
    
    public function Getcompletedorders()
    {
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
		
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('masterorders');
                    $totalRecords->select('id');
					$totalRecords->where('status', 'delivered');
                    $totalRecords->where('orderStatus', 1);
        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                $totalRecordwithFilter->where('status', 'delivered');
                                $totalRecordwithFilter->where('orderStatus', 1);
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('orderdate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('orderdate <=', $endDate);
                                }
								
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('masterorders');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            $records->where('status', 'delivered');
            $records->where('orderStatus', 1);
            if(!empty($stratDate))
            {
                $records->where('orderdate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('orderdate <=', $endDate);
            }
			
            $records->orderBy('orderdate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
		   $orderStatus=$this->OrderModel->getorderStatus();
		   $orderStatushtml='';
		   $orderStatushtml.='<select class="orderStatusChange" data-orderid="'.$record['orderid'].'">';
		   if($record['status']=='pending')
		   {
			$orderStatushtml.='<option value="pending" >Pending</option>';
		   }
		   foreach($orderStatus as $orderStatusRow)
		   {
			   if($record['status']==$orderStatusRow["slug"])
			   {
			      $orderStatushtml.='<option selected value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>';
			   }
			   else
			   {
				  $orderStatushtml.='<option value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>'; 
			   }
		   }
		   
		   $orderStatushtml.='</select>';
		   if($record['status']=='failed' || $record['orderStatus']==0)
		   {
		       $orderStatushtml="NONE";
		   }
           $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="badge bg-success" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="badge bg-warning" >Pending</span>';
 //              $status.='<br><span title="Refund Amount" class="refund-button" >';
 //              $status.='<a href="javascript:void(0)" data-id="'.$record['orderid'].'" class="refundAmount">';
 //              $status.='<i class=" bx bx-undo"></i> Refund';
 //              $status.='</a></span>';
              
           }
          
           elseif($record['status']=='cancelled')
           {
               $status='<span class="badge bg-danger" >Cancelled</span>';
               
           }
           elseif($record['status']=='refunded')
           {
               $status='<span class="badge bg-info" >Refunded</span>';
               
           }
           elseif($record['status']=='failed')
           {
               $status='<span class="badge bg-danger" >Failed</span>';
              
           }
    		else
    		{
    			$status=$record['status'];
    			$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
    			if($GetStatusDetail)
    			{
    				$orderStatus=$GetStatusDetail['status_title'];
    			}	
    			else
    			{
    				$orderStatus=$record['status'];
    			}
    		    $status='<span class="badge bg-success" >'.$orderStatus.'</span>';
    	    }
    	    
            $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
			$orderid=$record['orderid'];
			$userid=$record['userid'];
			
            $orderpaymentDetail=$this->OrderModel->GetpaymentDetail($orderid,$userid);  
			if($orderpaymentDetail['paymentStatus']=='Paid')
			{
				
				$paymentstatus='<span class="badge bg-success" >Paid</span>';
               
			}
			else
			{
				
			   $paymentstatus='<span class="badge bg-danger" >'.$orderpaymentDetail['paymentStatus'].'</span>';
               
			}
			
			 $action.='<span class="action-buttons ">';
               $action.='<span title="Edit Order" class="view-button">';
               $action.='<a href="'.base_url().'admin/order/edit/'.$record['orderid'].'"  class="btn btn-danger waves-effect waves-light view-record ">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               $action.='</span">';
			  
               $action.='<span class="action-buttons ">';
               $action.='<span title="View Order Detail" class="view-button">';
               $action.='<a href="javascript:void(0)" data-orderid="'.$record['orderid'].'" class="btn btn-success waves-effect waves-light view-record orderview">';
               $action.='<i class="mdi mdi-eye-outline"></i>';
               $action.='</a></span>';
               $action.='</span">';	
			
				$orderamount='';
				$orderamount.='<span style="text-wrap: wrap;font-weight: bold;    color: #b52a57;">'.$record['currency']." ".number_format($record['total_amount'],2).'</span>';
			   
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$record['orderid'],
             "ShippingDate"=>$record['shipping_date'],
             "amount"=>$orderamount,
			 "paymentMethod"=>$orderpaymentDetail['paymenttype'],
			 "paymentStatus"=>$paymentstatus,
             "orderstatus"=>$status,
			 "updateStatus"=>$orderStatushtml,
             "orderdate"=>$date,
             "action"=>$action,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    
    public function abadonded_order(){
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Abadonded Order History";
        $orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='abadonded-order';
        return view('Admin/admin_index',$data);
    }
    
    
    public function Getabadondedorders()
    {
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       // Custom filter
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
		
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
      
       ## Total number of records without filtering
        $totalRecords = $this->db->table('masterorders');
                    $totalRecords->select('id');
					$totalRecords->groupStart();
                    $totalRecords->where('orderStatus', 1);
                    $totalRecords->where('status', 'failed');
                    $totalRecords->groupEnd();
        			$totalRecords->orWhere('orderStatus', 0);
        $totalRecords= $totalRecords->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders');
                                $totalRecordwithFilter->select('id');
                                $totalRecordwithFilter->Like('orderid', $searchValue);
                                $totalRecordwithFilter->groupStart();
                                $totalRecordwithFilter->where('orderStatus', 1);
                                $totalRecordwithFilter->where('status', 'failed');
                                $totalRecordwithFilter->groupEnd();
                    			$totalRecordwithFilter->orWhere('orderStatus', 0);
                                if(!empty($stratDate))
                                {
                                    $totalRecordwithFilter->where('orderdate >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $totalRecordwithFilter->where('orderdate <=', $endDate);
                                }
								
        $totalRecordwithFilter= $totalRecordwithFilter->countAllResults();

       ## Fetch records
            $records = $this->db->table('masterorders');
            $records->select('*');
            $records->Like('orderid', $searchValue);
            $records->groupStart();
            $records->where('orderStatus', 1);
            $records->where('status', 'failed');
            $records->groupEnd();
			$records->orWhere('orderStatus', 0);
            if(!empty($stratDate))
            {
                $records->where('orderdate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('orderdate <=', $endDate);
            }
			
            $records->orderBy('orderdate','DESC');
            $records->limit($rowperpage, $start);
            $records=$records->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
		   $orderStatus=$this->OrderModel->getorderStatus();
		   $orderStatushtml='';
		   $orderStatushtml.='<select class="orderStatusChange" data-orderid="'.$record['orderid'].'">';
		   if($record['status']=='pending')
		   {
			$orderStatushtml.='<option value="pending" >Pending</option>';
		   }
		   foreach($orderStatus as $orderStatusRow)
		   {
			   if($record['status']==$orderStatusRow["slug"])
			   {
			      $orderStatushtml.='<option selected value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>';
			   }
			   else
			   {
				  $orderStatushtml.='<option value="'.$orderStatusRow["slug"].'">'.$orderStatusRow["status_title"].'</option>'; 
			   }
		   }
		   
		   $orderStatushtml.='</select>';
		   if($record['status']=='failed' || $record['orderStatus']==0)
		   {
		       $orderStatushtml="NONE";
		   }
           $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="badge bg-success" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="badge bg-warning" >Pending</span>';
 //              $status.='<br><span title="Refund Amount" class="refund-button" >';
 //              $status.='<a href="javascript:void(0)" data-id="'.$record['orderid'].'" class="refundAmount">';
 //              $status.='<i class=" bx bx-undo"></i> Refund';
 //              $status.='</a></span>';
              
           }
          
           elseif($record['status']=='cancelled')
           {
               $status='<span class="badge bg-danger" >Cancelled</span>';
               
           }
           elseif($record['status']=='refunded')
           {
               $status='<span class="badge bg-info" >Refunded</span>';
               
           }
           elseif($record['status']=='failed')
           {
               $status='<span class="badge bg-danger" >Failed</span>';
              
           }
    		else
    		{
    			$status=$record['status'];
    			$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
    			if($GetStatusDetail)
    			{
    				$orderStatus=$GetStatusDetail['status_title'];
    			}	
    			else
    			{
    				$orderStatus=$record['status'];
    			}
    		    $status='<span class="badge bg-success" >'.$orderStatus.'</span>';
    	    }
    	    
            $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
			$orderid=$record['orderid'];
			$userid=$record['userid'];
			
            $orderpaymentDetail=$this->OrderModel->GetpaymentDetail($orderid,$userid);  
			if($orderpaymentDetail['paymentStatus']=='Paid')
			{
				
				$paymentstatus='<span class="badge bg-success" >Paid</span>';
               
			}
			else
			{
				
			   $paymentstatus='<span class="badge bg-danger" >'.$orderpaymentDetail['paymentStatus'].'</span>';
               
			}
			
			 $action.='<span class="action-buttons ">';
               $action.='<span title="Edit Order" class="view-button">';
               $action.='<a href="'.base_url().'admin/order/edit/'.$record['orderid'].'"  class="btn btn-danger waves-effect waves-light view-record ">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               $action.='</span">';
			  
               $action.='<span class="action-buttons ">';
               $action.='<span title="View Order Detail" class="view-button">';
               $action.='<a href="javascript:void(0)" data-orderid="'.$record['orderid'].'" class="btn btn-success waves-effect waves-light view-record orderview">';
               $action.='<i class="mdi mdi-eye-outline"></i>';
               $action.='</a></span>';
               $action.='</span">';	
			
				$orderamount='';
				$orderamount.='<span style="text-wrap: wrap;font-weight: bold;    color: #b52a57;">'.$record['currency']." ".number_format($record['total_amount'],2).'</span>';
			   
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$record['orderid'],
             "ShippingDate"=>$record['shipping_date'],
             "amount"=>$orderamount,
			 "paymentMethod"=>$orderpaymentDetail['paymenttype'],
			 "paymentStatus"=>$paymentstatus,
             "orderstatus"=>$status,
			 "updateStatus"=>$orderStatushtml,
             "orderdate"=>$date,
             "action"=>$action,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    
	 public function edit($orderno)
	 {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		$orderDetail=$this->OrderModel->orderDetail($orderno);
        if(isset($orderDetail))
        {  
            $userid =$orderDetail['userid'];
            $orderid=$orderDetail['id'];
			$status=$orderDetail['status'];
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
            $page=1;
            $count=5;
            
            $data['Invoicessummary']=$this->OrderModel->Invoicessummary($orderno,$userid);
            $shippingAddress=$this->OrderModel->GetshippingAddress($orderno,$userid);
            $billingAddress=$this->OrderModel->GetbillingAddress($orderno,$userid);
            $paymentDetail=$this->OrderModel->GetpaymentDetail($orderno,$userid);
			$TrackingDetail=$this->OrderModel->GetTrackingDetail($orderno,$userid);
			if(isset($TrackingDetail))
			{
				$data['TrackingDetail']=$TrackingDetail;
				$shipping_company_slug=$TrackingDetail['shipping_company_slug'];
				$shippingcompanyDetail=$this->OrderModel->shippingcompanyDetail($shipping_company_slug);
				if(isset($shippingcompanyDetail))
				{
					$data['TrackingCompanyDetail']=$shippingcompanyDetail;
				}
			}
			
            $data['paymentDetail']=$paymentDetail;
            $data['shippingAddress']=$shippingAddress;
            $data['billingAddress']=$billingAddress;
			$data['title']="Edit Order";
			$orderStatus=$this->OrderModel->getorderStatus();
		    $data['orderStatus'] = $orderStatus;
			
			$TrackingCompanies=$this->OrderModel->getTrackingCompanies();
		    $data['TrackingCompanies'] = $TrackingCompanies;
			
			$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
			$data['GetStatusDetail']=$GetStatusDetail;
		    $data['orderid'] = $orderno;
            $data['language'] = $this->OrderModel->getlanguage();
            $data['page']='edit_order';
            return view('Admin/admin_index',$data);
        }
		else
		{
			return redirect()->to('/admin/order');
		}

    }
    
    
    public function ShowOrderDetail()
    {
       if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $orderno = $this->request->getVar('orderno');
        
        $orderDetail=$this->OrderModel->orderDetail($orderno);
        if(isset($orderDetail))
        {  
            $userid =$orderDetail['userid'];
            $orderid=$orderDetail['id'];
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
            $page=1;
            $count=5;
            
            $data['Invoicessummary']=$this->OrderModel->Invoicessummary($orderno,$userid);
             $orderdeliveredstatus=$this->OrderModel->orderdeliveredstatus($orderid,$userid);
            if($orderdeliveredstatus)
            {
                $data['orderdeliveredstatus']=$orderdeliveredstatus;
            }
            $shippingAddress=$this->OrderModel->GetshippingAddress($orderno,$userid);
            $billingAddress=$this->OrderModel->GetbillingAddress($orderno,$userid);
            $paymentDetail=$this->OrderModel->GetpaymentDetail($orderno,$userid);
            $data['paymentDetail']=$paymentDetail;
            $data['shippingAddress']=$shippingAddress;
            $data['billingAddress']=$billingAddress;
            return view('ordertemplate/template',$data);
        }
        else
        {
            echo "failed";
            return ;
        }
    }
    
    public function MoreOrderItems()
    {
         if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
       
        $orderno = $this->request->getVar('orderno');
        $page = $this->request->getVar('page');
        $orderDetail=$this->OrderModel->orderDetail($orderno);
        if(isset($orderDetail))
        {
            $userid =$orderDetail['userid'];
            $orderid=$orderDetail['id'];
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
            $count=5;
            $InvoicessummaryData=array();
            if($orderDetail['status']=='confirm')
            {
                $Invoicessummary=$this->Api->Invoicessummary($masterId,$page,$count);
                if($Invoicessummary)
                {
                    if($Invoicessummary->success==true && $Invoicessummary->message=="Success")
                    {
                        $InvoicessummaryData=$Invoicessummary->data;
                        if(isset($InvoicessummaryData))
                        {
                            foreach($InvoicessummaryData as $row)
                            {
                                ?>
                                
                                <tr>
                                 <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: left;" align="left">
                                  <img style="width:50px;"src="<?=settings('product_thumbnail_url')?><?=$row->image?>"
                                  </td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #ff0000;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: left;" class="article" align="left">
                                    <?php
                                    if(!empty($row->name))
                                    {
                                       echo  $row->name;
                                    }
                                    else
                                    {
                                       echo  $row->description;
                                    }
                                    ?>
                                  </td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->metal?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->gwt?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->nwt?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->pcs?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: right;" align="right"><?=$orderDetail['currency']?> <?=$row->price?></td>
                                </tr>
                                <tr>
                                  <td height="1" colspan="7" style="border-bottom:1px solid #e4e4e4"></td>
                                </tr>
                                <?php
                            }
                            
                        }
                        else
                        {
                            echo "notdfound";
                            return ;
                        }
                    }
                    else
                    {
                        echo "notdfound";
                        return ;
                    }
                }
                else
                {
                    echo "notdfound";
                    return ;
                }
            }
            else
            {
                $InvoicessummaryData=$this->OrderModel->GetInvoicessummaryData($orderno,$userid,$page,$count);
                        if(isset($InvoicessummaryData))
                        {
                            foreach($InvoicessummaryData as $row)
                            {
                                ?>
                                
                                <tr>
                                 <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: left;" align="left">
                                  <img style="width:50px;"src="<?=settings('product_thumbnail_url')?><?=$row->image?>"
                                  </td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #ff0000;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: left;" class="article" align="left">
                                    <?php
                                    if(!empty($row->name))
                                    {
                                       echo  $row->name;
                                    }
                                    else
                                    {
                                       echo  $row->description;
                                    }
                                    ?>
                                  </td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->metal?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->gwt?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->nwt?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->pcs?></small></td>
                                  <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: right;" align="right"><?=$orderDetail['currency']?> <?=$row->price?></td>
                                </tr>
                                <tr>
                                  <td height="1" colspan="7" style="border-bottom:1px solid #e4e4e4"></td>
                                </tr>
                                <?php
                            }
                            
                        }
                        else
                        {
                            echo "notdfound";
                            return ;
                        }
            }

        }
        else
        {
            echo "failed";
            return ;
        }
    }
    
    
    public function refundamount()
    {
      
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $orderid = $this->request->getVar('orderid');
             $this->OrderModel->orderRefund($orderid); 

    }
	
	public function orderStatusChange()
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		$orderid = $this->request->getVar('orderid');
		$status = $this->request->getVar('status');
		$GetStatusDetail=$this->OrderModel->GetStatusDetail($status);
		if($GetStatusDetail)
		{
			$orderDetail=$this->OrderModel->orderDetail($orderid);
			if($GetStatusDetail['invoice']==1 && $orderDetail['invoiceno']=='')
			{
				$this->GenerateInvoice($orderid);
			}
			$this->OrderModel->updateOrderStatus($orderid,$status); 
			
			$orderStatusHistory=array(
				'orderid'=>$orderid,
				'userid'=>$orderDetail['userid'],
				'status'=>$status,
				'update_date'=>date('Y-m-d H:i:s'),
			);
			
			$this->OrderModel->insertOrderStatusHistory($orderStatusHistory); 
			
			$data=array(
				'status'=>true,
				'message'=>'Order Status Successfully Changed.'
			);
			echo json_encode($data);
			return;
		}
		else
		{
			$data=array(
				'status'=>false,
				'message'=>'Something Wrong.Please try again.'
			);
			echo json_encode($data);
			return;
		}
	}
	
	public function GenerateInvoice($orderid)
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		$orderDetail=$this->OrderModel->orderDetail($orderid);
        if(isset($orderDetail))
        {
            $orderid=$orderDetail['orderid'];
			$userid=$orderDetail['userid'];
			if($orderDetail['invoiceno']=='')
			{
			$invoiceNo=settings('invoice_prefix').date('y').date('m').$userid.str_replace(settings('order_prefix'),"",$orderid);
			$invoiceupdate=array(
				'invoiceno'=>$invoiceNo,
				'invoice'=> $invoiceNo.'.pdf'
			);
			
			$this->OrderModel->updateOrderinvoice($orderid,$invoiceupdate); 
			}
			else
			{
			$invoiceNo = $orderDetail['invoiceno'];
			}
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
			$data['Invoicessummary']=$this->HomeModel->Invoicessummary($orderid,$userid);
			$paymentDetail=$this->HomeModel->GetpaymentDetail($orderid,$userid);
            $shippingAddress=$this->HomeModel->GetshippingAddress($orderid,$userid);
            $billingAddress=$this->HomeModel->GetbillingAddress($orderid,$userid);
            $data['paymentDetail']=$paymentDetail;
			$data['invoiceNo']=$invoiceNo;
            $data['shippingAddress']=$shippingAddress;
            $data['billingAddress']=$billingAddress; 
			//print_r($data['billingAddress']);
			//die;
			$datainvoice=view('ordertemplate/order_invoice',$data);
			// reference the Dompdf namespace
			// instantiate and use the dompdf class
			$dompdf = new DOMPDF();
			$dompdf->loadHtml($datainvoice);
			$dompdf->render();	
			$dompdf->stream($invoiceNo . ".pdf");			
			/*	while(file_exists("public/orders/pdf/" . $invoiceNo . ".pdf")) 
				{
					
				}
				file_put_contents("public/orders/pdf/" . $invoiceNo . ".pdf", $dompdf->output());
			
			$dompdf->stream("public/orders/pdf/" . $invoiceNo . ".pdf");
			*/
			
		}
	
	}
	
	public function PrintInvoice($orderid)
	{
		if(!isset($this->session->admin))
        {
           $data=array(
				'status'=>false,
				'htmldata'=>''
			);
			echo  json_encode($data);
			return;
        }
		$orderDetail=$this->OrderModel->orderDetail($orderid);
        if(isset($orderDetail))
        {
            $orderid=$orderDetail['orderid'];
			$userid=$orderDetail['userid'];
			if($orderDetail['invoiceno']=='')
			{
			$invoiceNo=settings('invoice_prefix').date('y').date('m').$userid.str_replace(settings('order_prefix'),"",$orderid);
			$invoiceupdate=array(
				'invoiceno'=>$invoiceNo,
				'invoice'=> $invoiceNo.'.pdf'
			);
			
			$this->OrderModel->updateOrderinvoice($orderid,$invoiceupdate); 
			}
			else
			{
			$invoiceNo = $orderDetail['invoiceno'];
			}
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
			$data['Invoicessummary']=$this->HomeModel->Invoicessummary($orderid,$userid);
			$paymentDetail=$this->HomeModel->GetpaymentDetail($orderid,$userid);
            $shippingAddress=$this->HomeModel->GetshippingAddress($orderid,$userid);
            $billingAddress=$this->HomeModel->GetbillingAddress($orderid,$userid);
            $data['paymentDetail']=$paymentDetail;
			$data['invoiceNo']=$invoiceNo;
            $data['shippingAddress']=$shippingAddress;
            $data['billingAddress']=$billingAddress; 
			
			$datainvoice=view('ordertemplate/order_invoice',$data);
			$data=array(
				'status'=>true,
				'htmldata'=>$datainvoice
			);
			echo  json_encode($data);
			return;
		}
		else
		{
		    $data=array(
				'status'=>false,
				'htmldata'=>''
			);
			echo  json_encode($data);
			return;
		}
	}
	
	public function shippingcompanyDetail()
	{
		$shipping_company_slug = $this->request->getVar('shipping_company_slug');
        $shippingcompanyDetail=$this->OrderModel->shippingcompanyDetail($shipping_company_slug);
        if(isset($shippingcompanyDetail))
        {
			
			$data=array(
				'status'=>true,
				'data'=>$shippingcompanyDetail,
				'message'=>''
			);
			echo json_encode($data);
			return;
		}
		else
		{
			$data=array(
				'status'=>false,
				'message'=>'Something Wrong.Please try again.'
			);
			echo json_encode($data);
			return;
		}
	}
	
	public function update_ordertracking()
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		
		$shipping_company_slug = $this->request->getVar('shipping_company');
        $shippingcompanyDetail=$this->OrderModel->shippingcompanyDetail($shipping_company_slug);
        if(isset($shippingcompanyDetail))
        {
			$tracking_link = $this->request->getVar('tracking_link');
			$tracking_id = $this->request->getVar('tracking_id');
			$note = $this->request->getVar('note');
			$orderno = $this->request->getVar('orderno');
		    $orderDetail=$this->OrderModel->orderDetail($orderno);
			if(isset($orderDetail))
			{
				$trackingDetails=array(
					'orderid'=>$orderno,
					'userid'=>$orderDetail['userid'],
					'shipping_company_id'=>$shippingcompanyDetail['id'],
					'shipping_company_slug'=>$shippingcompanyDetail['slug'],
					'shipping_company'=>$shippingcompanyDetail['company_title'],
					'order_tracking_link'=>$tracking_link,
					'tracking_id'=>$tracking_id,
					'note'=>$note,
				);
				
				$ChecktrackingDetails=$this->OrderModel->ChecktrackingDetails($orderno);
				if(isset($ChecktrackingDetails))
				{
					$this->OrderModel->updatetrackingDetails($orderno,$trackingDetails);
				}
				else
				{
					$this->OrderModel->inserttrackingDetails($orderno,$trackingDetails);
				}
				$tracking_id_update=array(
					'tracking_id'=>$tracking_id,
				);
				$this->OrderModel->updateOrderinvoice($orderno,$tracking_id_update);
				
				$data=array(
					'status'=>true,
					'message'=>'Order Tracking Details Successfully Update.'
				);
				echo json_encode($data);
				return;
			}
			else
			{
				$data=array(
					'status'=>false,
					'message'=>'Order Not Found.'
				);
				echo json_encode($data);
				return;
			}
			
		}
		else
		{
			$data=array(
				'status'=>false,
				'message'=>'Shipping Company Not Found.'
			);
			echo json_encode($data);
			return;
		}
	}
   
     public function return_order(){
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Return Order History";
        $orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='return-order';
        return view('Admin/admin_index',$data);
    }

        public function Getreturndorders()
{
    if (!isset($this->session->admin)) {
        return redirect()->to('/admin/login');
    }

    $request = service('request');
    $postData = $request->getPost();
    $dtpostData = $postData['data'];

    $draw = $dtpostData['draw'];
    $start = $dtpostData['start'];
    $rowperpage = $dtpostData['length'];
    $searchValue = $dtpostData['search']['value'];
    $daterange = $dtpostData['daterange'];

    $stratDate = '';
    $endDate = '';

    if (!empty($daterange)) {
        $dateArr = explode("-", $daterange);
        $stratDate = date("Y-m-d", strtotime($dateArr[0])) . " 00:00:00";
        $endDate = date("Y-m-d", strtotime($dateArr[1])) . " 23:59:59";
    }

    // Total count
    $baseCountQuery = $this->db->table('orderitems');
    $baseCountQuery->join('returns', 'returns.orderid = orderitems.orderid AND returns.product_id = orderitems.productid', 'INNER');
    $baseCountQuery->join('masterorders', 'masterorders.orderid = orderitems.orderid');
   $baseCountQuery->whereIn('masterorders.status', ['delivered', 'returned', 'partially-returned']);

    $baseCountQuery->where('masterorders.orderStatus', 1);

    if (!empty($stratDate)) {
        $baseCountQuery->where('returns.created_at >=', $stratDate);
    }
    if (!empty($endDate)) {
        $baseCountQuery->where('returns.created_at <=', $endDate);
    }

    if (!empty($searchValue)) {
        $baseCountQuery->like('masterorders.orderid', $searchValue);
    }

    $totalRecords = $baseCountQuery->countAllResults(false);
    $totalRecordwithFilter = $totalRecords; // Same because of applied filters above

    // Fetch data
    $recordsQuery = $baseCountQuery->select('
        orderitems.*,
        returns.id AS returnid,
        returns.return_quantity,
        returns.reason,
        returns.return_status,
        returns.created_at as return_date,
        masterorders.currency,
        masterorders.total_amount,
        masterorders.orderdate,
        masterorders.orderid,
        masterorders.userid,
        masterorders.status as order_status
    ')->orderBy('masterorders.orderdate', 'DESC')->limit($rowperpage, $start);
//echo $recordsQuery->getCompiledSelect(); die;
    $records = $recordsQuery->get()->getResultArray();
 
    $data = [];
    $i = 1 + $start;

    foreach ($records as $record) {
        // Payment info
        $orderpaymentDetail = $this->OrderModel->GetpaymentDetail($record['orderid'], $record['userid']);

        $paymentstatus = ($orderpaymentDetail['paymentStatus'] == 'Paid')
            ? '<span class="badge bg-success">Paid</span>'
            : '<span class="badge bg-danger">' . $orderpaymentDetail['paymentStatus'] . '</span>';

        // Order status badge
        $statusMap = [
            'pending'   => 'warning',
            'confirm'   => 'success',
            'cancelled' => 'danger',
            'refunded'  => 'info',
            'failed'    => 'danger',
            'delivered' => 'success',
        ];
     
      $rstatusMap = [
            'requested'   => 'warning',
            'approved'   => 'success',
            'rejected' => 'danger',
            'processed'  => 'info'
        ];
        $statusClass = $statusMap[$record['order_status']] ?? 'secondary';
        $statusTitle = ucfirst($record['order_status']);
        
        $retstatusClass = $rstatusMap[$record['return_status']] ?? 'secondary';
        $retstatusTitle = ucfirst($record['return_status']);
        $status = '<span class="badge bg-' . $retstatusClass . '">' . $retstatusClass . '</span>';
      $retstatus = '<span class="badge bg-' . $retstatusClass . '">' . $retstatusTitle . '</span>';
      
      $checkboxitems = '
<input type="checkbox" class="return-checkbox" 
       data-id="' . $record['returnid'] . '"
       data-userid="' . $record['userid'] . '"
       data-status="' . $record['return_status'] . '"
       data-name="' . $record['productname'] . '" 
       data-productid="' . $record['productid'] . '" 
       data-orderid="' . $record['orderid'] . '">';
      
        // Action buttons
        /*
        $action = '<span class="action-buttons">
            <a href="' . base_url() . 'admin/order/edit/' . $record['orderid'] . '" class="btn btn-danger waves-effect waves-light" title="Edit Order"><i class="bx bx-pencil"></i></a>
        </span>'; */
       $action='';
        $orderamount = '<span style="font-weight: bold; color: #b52a57;">' . $record['currency'] . " " . number_format($record['total_amount'], 2) . '</span>';
        $date = date("d-m-Y H:i:s", strtotime($record['return_date']));
$productRate = number_format($record['net_price'], 2);
     $data[] = [
          "checkbox" => $checkboxitems,
    "sr" => $i . '.',
    "orderid" => $record['orderid'],
    "product_name" => $record['productname'],
    "product_rate" => $record['currency'] . ' ' . $productRate,
    "return_quantity" => $record['return_quantity'],
    "reason" => $record['reason'],
    "return_status" => ucfirst($retstatus),
    "orderdate" => $date,
    "action" => $action,
];

        $i++;
    }

    // Final response
    $response = [
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
    ];

    return $this->response->setJSON($response);
}

  public function returnProduct()
{
    if (!isset($this->session->admin)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Not Authorized'
        ]);
    }
  

   

    $items = $this->request->getVar('items');
    if (!$items || !is_array($items)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'No items submitted'
        ]);
    }

    $errors = [];
    foreach ($items as $key => $item) {
      
        $product_id = $item['productid'] ?? null;
        $orderid = $item['orderid'] ?? null;
        $return_quantity = $item['return_quantity'] ?? null;
        $reason = $this->request->getVar('reason') ?? null;
         $userid =  $item['userid'];
        // Inline validation
        if (!$product_id || !$orderid || !$return_quantity || !$reason || strlen($reason) < 3) {
            $errors[$product_id] = "Invalid input for product ID {$product_id}.";
            continue;
        }

        // Check order item existence
        $orderItem = $this->OrderModel->orderItemDetail($orderid, $userid, $product_id);
        if (!$orderItem || $return_quantity > $orderItem['pcs']) {
            $errors[$product_id] = "Invalid product or return quantity for product ID {$product_id}.";
            continue;
        }

        // Save return request
        $returndata = [
            'orderid'         => $orderid,
            'product_id'      => $product_id,
            'return_quantity' => $return_quantity,
            'reason'          => $reason,
            'return_status'   => 'requested'
        ];
        $this->OrderModel->orderitemreturnSubmit($returndata);

        // Update item return status
        $this->OrderModel->markItemReturned($orderid, $userid, $product_id);
    }

    if (!empty($errors)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Some items could not be processed.',
            'errors' => $errors
        ]);
    }

    return $this->response->setJSON([
        'status' => true,
        'message' => 'Return request submitted successfully.'
    ]);
}
  

  public function returnProductapprove()
{
      if (!isset($this->session->admin)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Not Authorized'
        ]);
    }

 

    $items = $this->request->getVar('items');
    //print_r($items);
    if (!$items || !is_array($items)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'No items submitted'
        ]);
    }

    $errors = [];
    foreach ($items as $key => $item) {
         $id = $item['id'] ?? null;
        $product_id = $item['productid'] ?? null;
        $orderid = $item['orderid'] ?? null;
        $returnstatus = $item['return_status'] ?? null;
        $reason = $this->request->getVar('reason') ?? null;
         $userid =  $item['userid'];

        // Inline validation
        if (!$product_id || !$orderid || !$reason || strlen($reason) < 3) {
            $errors[$product_id] = "Invalid input for product ID {$product_id}.";
            continue;
        }
       $itemsdetails=$this->OrderModel->orderItemDetail($orderid, $userid, $product_id);
     if($returnstatus == 'approved') {
    if(!empty($itemsdetails['price'])) {
        $refundamount = number_format($itemsdetails['price'], 2);  
    }
} else {
    $refundamount = '0.00'; 
}
        // Save return request
        $returndata = [
    'note'  => $reason,
    'return_status' => $returnstatus,
    'return_amount' => $refundamount,
    'updated_at' => date('Y-m-d H:i:s') // Optional: track update time
];
      $this->db->table('returns')
    ->where('id', $id)
    ->where('orderid', $orderid)
    ->where('product_id', $product_id)
    ->update($returndata); 
    
    // Call to update master order status
$this->updateOrderReturnStatus($orderid);
    }

    if (!empty($errors)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Some items could not be processed.',
            'errors' => $errors
        ]);
    }

    return $this->response->setJSON([
        'status' => true,
        'message' => 'Return request submitted successfully.'
    ]);
}
 public function updateOrderReturnStatus($orderId)
{
    $totalItems = $this->db->table('orderitems')->where('orderid', $orderId)->countAllResults();

    $returnedItems = $this->db->table('returns')
        ->where('orderid', $orderId)
        ->whereIn('return_status', ['approved', 'processed'])
        ->countAllResults();

    if ($returnedItems == 0) {
        $status = 'delivered';
    } elseif ($returnedItems < $totalItems) {
        $status = 'partially-returned';
    } else {
        $status = 'returned';
    }

    $this->db->table('masterorders')->where('orderid', $orderId)->update(['status' => $status]);
}

	public function send_email($emailtemplate,$token,$to,$cc=NULL, $from=NULL, $email_type=NULL, $redirect_url=NULL)
    {
        $pattern = '[%s]';
        foreach ($token as $key => $val)
        {
            $varMap[sprintf($pattern, $key) ] = $val;
        }       
        
        $emailContent = strtr($emailtemplate['body'], $varMap);
        $subject = $emailtemplate['subject'];
        default_smtp_mail($emailContent,$subject,$to,$cc);
    }

    public function Apisync(){
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		$orderid = $this->request->getVar('orderid');
		$userid = $this->request->getVar('userid');
         $apiresponse=$this->HomeModel->Apiorderdata($orderid,$userid);
          if (isset($apiresponse['success']) && $apiresponse['success'] === true) {
             
             $data=array(
				'status'=>true,
				'message'=>'Order synced Successfully.'
			);
			echo json_encode($data);
			return;
          }else{
              
            $data=array(
				'status'=>false,
				'message'=>'Order synced problem.'
			);
			echo json_encode($data);
			return;
          }
         
    }
}
