<?php
namespace App\Controllers\Admin;
use App\Models\OrderModel;
use App\Models\HomeModel;
use App\Models\ReportModel;
use App\Controllers\BaseController;
use App\Controllers\RenderImage;
use Dompdf\Dompdf;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class Reports extends BaseController
{
    public function __construct()
    {
        $this->OrderModel = new OrderModel(); 
		$this->HomeModel = new HomeModel(); 
		$this->ReportModel = new ReportModel(); 
    }
    
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    public function lang_slug($unserializeName)
    {
       
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
            
        }
        
    }
    
    public function cardreports()
    {
           $totalOrders=$this->ReportModel->gettotalOrders();
           $pendingOrders=$this->ReportModel->getpendingOrders();
           $completedorders=$this->ReportModel->getcompletedOrders();
           $abadondedorders=$this->ReportModel->getabadondedOrders();
           $totalproducts=$this->ReportModel->gettotalproducts();
           $totalcustomers=$this->ReportModel->gettotalcustomers();
           $totalreviews=$this->ReportModel->gettotalreviews();
           $totalsale=$this->ReportModel->gettotalsale();
            $data=array(
               'status'=>true,
               'totalorders'=>$totalOrders,
               'pendingorders'=>$pendingOrders,
               'completedorders'=>$completedorders,
               'abadondedorders'=>$abadondedorders,
               'totalproducts'=>$totalproducts,
               'totalcustomers'=>$totalcustomers,
               'totalreviews'=>$totalreviews,
               'totalsale'=>$totalsale,
            );
               
         echo json_encode($data);
    }
    
    public function allOrderchart()
    {
        $selectby = $this->request->getVar('selectby');
           $totalOrders=$this->ReportModel->gettotalChartOrders($selectby);
           $pendingOrders=$this->ReportModel->getpendingChartOrders($selectby);
           $completedorders=$this->ReportModel->getcompletedChartOrders($selectby);
           $abadondedorders=$this->ReportModel->getabadondedChartOrders($selectby);
           $cancelorders=$this->ReportModel->getcancelChartOrders($selectby);
            $data=array(
               'status'=>true,
               'totalorders'=>$totalOrders,
               'pendingorders'=>$pendingOrders,
               'completedorders'=>$completedorders,
               'abadondedorders'=>$abadondedorders,
               'cancelorders'=>$cancelorders
            );
               
         echo json_encode($data);
    }
    
    public function totalOrderchart()
    {
        $selectby = $this->request->getVar('selectby');
           $totalChartOrdersReport=$this->ReportModel->gettotalChartOrdersReport($selectby);
           $totalorderlabels = array_column($totalChartOrdersReport,'label');
           $totalorderrecords = array_column($totalChartOrdersReport,'total_orders');
           
           $totalChartOrdersReport=$this->ReportModel->getpendingChartOrdersReport($selectby);
           $pendingorderlabels = array_column($totalChartOrdersReport,'label');
           $pendingorderrecords = array_column($totalChartOrdersReport,'total_orders');
           
           $totalChartOrdersReport=$this->ReportModel->getcomplitedChartOrdersReport($selectby);
           $complitedorderlabels = array_column($totalChartOrdersReport,'label');
           $complitedorderrecords = array_column($totalChartOrdersReport,'total_orders');
           
           $totalChartOrdersReport=$this->ReportModel->getabadondedChartOrdersReport($selectby);
           $abadondedorderlabels = array_column($totalChartOrdersReport,'label');
           $abadondedorderrecords = array_column($totalChartOrdersReport,'total_orders');
           
           $records=array(
               'totalorders'=>$totalorderrecords,
               'pendingorders'=>$pendingorderrecords,
               'complitedorders'=>$complitedorderrecords,
               'abadondedorders'=>$abadondedorderrecords
             );
             $labels=array(
                 'totalorders'=>$totalorderlabels
                 );  
            $data=array(
               'status'=>true,
               'records'=>$records,
               'labels'=>$labels,
            );
               
         echo json_encode($data);
    }
    
    public function totalSalechart()
    {
        $selectby = $this->request->getVar('selectby');
           $totalChartSalesReport=$this->ReportModel->gettotalChartSalesReport($selectby);
           $totalSalelabels = array_column($totalChartSalesReport,'label');
           $totalSalerecords = array_column($totalChartSalesReport,'total_sale');
           
           
           $records=array(
               'totalSales'=>$totalSalerecords,
               );
             $labels=array(
                 'totalSales'=>$totalSalelabels
                 );  
            $data=array(
               'status'=>true,
               'records'=>$records,
               'labels'=>$labels,
            );
               
         echo json_encode($data);
    }
    
    public function totalProductchart()
    {
        $selectby = $this->request->getVar('selectby');
           $totalChartProductsReport=$this->ReportModel->gettotalChartProductsReport($selectby);
           $totalChartjewelryProductsReport=$this->ReportModel->getjewelryChartProductsReport($selectby);
           $totalChartdiamondProductsReport=$this->ReportModel->getdiamondChartProductsReport($selectby);
           $totalChartgemstoneProductsReport=$this->ReportModel->getgemstoneChartProductsReport($selectby);
           $totalChartInactiveProductsReport=$this->ReportModel->gettotalinactiveChartProductsReport($selectby);
            $data=array(
               'status'=>true,
               'totalproducts'=>$totalChartProductsReport,
               'totaljewelry'=>$totalChartjewelryProductsReport,
               'totaldiamond'=>$totalChartdiamondProductsReport,
               'totalgemstone'=>$totalChartgemstoneProductsReport,
               'inactiveproducts'=>$totalChartInactiveProductsReport
            );
               
         echo json_encode($data);
    }
    public function totalCustomerchart()
    {
       $selectby = $this->request->getVar('selectby');
           $totalChartCustomersReport=$this->ReportModel->gettotalChartCustomersReport($selectby);
           $totalCustomerlabels = array_column($totalChartCustomersReport,'label');
           $totalCustomerrecords = array_column($totalChartCustomersReport,'total_user');
           
           
           $records=array(
               'totalCustomers'=>$totalCustomerrecords,
               );
             $labels=array(
                 'totalCustomers'=>$totalCustomerlabels
                 );  
            $data=array(
               'status'=>true,
               'records'=>$records,
               'labels'=>$labels,
            );
               
         echo json_encode($data);
    }
    
    public function totalReviewschart()
    {
        $selectby = $this->request->getVar('selectby');
           $totalChartReviewsReport=$this->ReportModel->gettotalChartReviewsReport($selectby);
           $totalreviewlabels = array_column($totalChartReviewsReport,'label');
           $totalreviewrecords = array_column($totalChartReviewsReport,'total_reviews');
           
           $totalChartReviewsReport=$this->ReportModel->getfiveChartReviewsReport($selectby);
           $fivereviewlabels = array_column($totalChartReviewsReport,'label');
           $fiveReviewsrecords = array_column($totalChartReviewsReport,'total_reviews');
           
           $totalChartReviewsReport=$this->ReportModel->getfourChartReviewsReport($selectby);
           $fourreviewlabels = array_column($totalChartReviewsReport,'label');
           $fourReviewsrecords = array_column($totalChartReviewsReport,'total_reviews');
           
           $totalChartReviewsReport=$this->ReportModel->getthreeChartReviewsReport($selectby);
           $threereviewlabels = array_column($totalChartReviewsReport,'label');
           $threeReviewsrecords = array_column($totalChartReviewsReport,'total_reviews');
           
           $totalChartReviewsReport=$this->ReportModel->gettwoChartReviewsReport($selectby);
           $tworeviewlabels = array_column($totalChartReviewsReport,'label');
           $twoReviewsrecords = array_column($totalChartReviewsReport,'total_reviews');
           
           $totalChartReviewsReport=$this->ReportModel->getoneChartReviewsReport($selectby);
           $onereviewlabels = array_column($totalChartReviewsReport,'label');
           $oneReviewsrecords = array_column($totalChartReviewsReport,'total_reviews');
           $fiveReviewsrecordsNew=array();
           $fourReviewsrecordsNew=array();
           $threeReviewsrecordsNew=array();
           $twoReviewsrecordsNew=array();
           $oneReviewsrecordsNew=array();
           foreach($totalreviewlabels as $key =>$row)
           {
                if(in_array($row, $fivereviewlabels))
                {
                    $fivekey = array_search($row, $fivereviewlabels);
                    $fiveReviewsrecordsNew[$key]=$fiveReviewsrecords[$fivekey];
                }
                else
                {
                    $fiveReviewsrecordsNew[$key]=0;
                }
                if(in_array($row, $fourreviewlabels))
                {
                    $fourkey = array_search($row, $fourreviewlabels);
                    $fourReviewsrecordsNew[$key]=$fourReviewsrecords[$fourkey];
                }
                else
                {
                    $fourReviewsrecordsNew[$key]=0;
                }
                if(in_array($row, $threereviewlabels))
                {
                    $threekey = array_search($row, $threereviewlabels);
                    $threeReviewsrecordsNew[$key]=$threeReviewsrecords[$threekey];
                }
                else
                {
                    $threeReviewsrecordsNew[$key]=0;
                }
                if(in_array($row, $tworeviewlabels))
                {
                    $twokey = array_search($row, $tworeviewlabels);
                    $twoReviewsrecordsNew[$key]=$twoReviewsrecords[$twokey];
                }
                else
                {
                    $twoReviewsrecordsNew[$key]=0;
                }
               
               if(in_array($row, $onereviewlabels))
                {
                    $onekey = array_search($row, $onereviewlabels);
                    $oneReviewsrecordsNew[$key]=$oneReviewsrecords[$onekey];
                  
                }
                else
                {
                    $oneReviewsrecordsNew[$key]=0;
                }
           }
           
           $records=array(
               'totalReviews'=>$totalreviewrecords,
               'fiveReviews'=>$fiveReviewsrecordsNew,
               'fourReviews'=>$fourReviewsrecordsNew,
               'threeReviews'=>$threeReviewsrecordsNew,
               'twoReviews'=>$twoReviewsrecordsNew,
               'oneReviews'=>$oneReviewsrecordsNew,
               );
             $labels=array(
                 'totalreviews'=>$totalreviewlabels
                 );  
            $data=array(
               'status'=>true,
               'records'=>$records,
               'labels'=>$labels,
            );
               
         echo json_encode($data);
    }
    
    public function orderReports()
    {
        $daterange = $this->request->getVar('daterange');
		$orderstatus = $this->request->getVar('orderstatus');
		if(!$orderstatus)
		{
            $file_name = 'All Orders Reports.xlsx';
        }
        elseif($orderstatus=='abadonded')
        {
            $file_name = 'Abadonded Orders Reports.xlsx';
        }
        else
        {
            $file_name = ucfirst($orderstatus).' Orders Reports.xlsx';
        }
		$spreadsheet = new Spreadsheet();

		$sheet = $spreadsheet->getActiveSheet();
        $from = "A1"; // or any value
        $to = "H1"; // or any value
        $sheet->getStyle("$from:$to")->getFont()->setBold( true );
		$sheet->setCellValue('A1', 'Sr.no');

		$sheet->setCellValue('B1', 'Order No.');

		$sheet->setCellValue('C1', 'Shipping Date');

		$sheet->setCellValue('D1', 'Payment Method');
		
		$sheet->setCellValue('E1', 'Payment Status');
		
		$sheet->setCellValue('F1', 'Order Status');
		
		$sheet->setCellValue('G1', 'Order Date');
		
		$sheet->setCellValue('H1', 'Amount');
		
		
		$searchValue ='';
		

		$stratDate='';
        $endDate='';
		
			
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
        
        	$records = $this->db->table('masterorders');
            $records->select('*');
            $records->Like('orderid', $searchValue);
           
            if(!empty($stratDate))
            {
                $records->where('orderdate >=', $stratDate);
            }
            if(!empty($endDate))
            {
                $records->where('orderdate <=', $endDate);
            }
            if($orderstatus)
    		{
                if($orderstatus=='abadonded')
                {
                    $records->groupStart();
                    $records->where('orderStatus', 1);
                    $records->where('status', 'failed');
                    $records->groupEnd();
					$records->orWhere('orderStatus', 0);
                }
                else
                {
                    $records->Like('status', $orderstatus);
                }
            }
			
            $records->orderBy('orderdate','DESC');
            $records=$records->get()->getResultArray();

		$count = 2;

        $i=1;
        $totalAmount=0;
        if($records)
        {
    		foreach($records as $record )
            {
                $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
    			$orderid=$record['orderid'];
    			$userid=$record['userid'];
                $orderpaymentDetail=$this->OrderModel->GetpaymentDetail($orderid,$userid);
                
    			$sheet->setCellValue('A' . $count, $i);
    
    			$sheet->setCellValue('B' . $count, $record['orderid']);
    
    			$sheet->setCellValue('C' . $count, $record['shipping_date']);
    			
    			$sheet->setCellValue('D' . $count, $orderpaymentDetail['paymenttype']);
    			
    			$sheet->setCellValue('E' . $count, $orderpaymentDetail['paymentStatus']);
    			
    			$sheet->setCellValue('F' . $count, $record['status']);
    			
    			$sheet->setCellValue('G' . $count, $date);
    			
    			$sheet->setCellValue('H' . $count, $record['currency']." ".number_format($record['total_amount'],2));
                $totalAmount+=$record['total_amount'];
    
    			$count++;
    			$i++;
            }
            $sheet->mergeCells('A'.$count.':G'.$count);
            $sheet->getStyle('A' . $count)->getFont()->setBold( true );
            $sheet->setCellValue('A' . $count, "Total");
            
            $sheet->getStyle('H' . $count)->getFont()->setBold( true );
            
            $sheet->setCellValue('H' . $count, $record['currency']." ".number_format($totalAmount,2));
        }
        
        
		$writer = new Xlsx($spreadsheet);

		$writer->save($file_name);

		header("Content-Type: application/vnd.ms-excel");

		header('Content-Disposition: attachment; filename="' . basename($file_name) . '"');

		header('Expires: 0');

		header('Cache-Control: must-revalidate');

		header('Pragma: public');

		header('Content-Length:' . filesize($file_name));

		flush();

		readfile($file_name);

		exit;
    }
    
    public function customerReports()
    {
        $file_name = 'Customers Reports.xlsx';

		$spreadsheet = new Spreadsheet();

		$sheet = $spreadsheet->getActiveSheet();
        $from = "A1"; // or any value
        $to = "S1"; // or any value
        $sheet->getStyle("$from:$to")->getFont()->setBold( true );
		$sheet->setCellValue('A1', 'Sr.no');

		$sheet->setCellValue('B1', 'Name');

		$sheet->setCellValue('C1', 'Mobile');

		$sheet->setCellValue('D1', 'Email');
		
		$sheet->setCellValue('E1', 'Second Email');
		
		$sheet->setCellValue('F1', 'Date Of Birth');
		
		$sheet->setCellValue('G1', 'Anniversary');
		
		$sheet->setCellValue('H1', 'Gender');
		$sheet->setCellValue('I1', 'Address 1');
		$sheet->setCellValue('J1', 'Address 2');
		$sheet->setCellValue('K1', 'City');
		$sheet->setCellValue('L1', 'Region');
		$sheet->setCellValue('M1', 'Country');
		$sheet->setCellValue('N1', 'zipcode');
		$sheet->setCellValue('O1', 'Referral Code');
		$sheet->setCellValue('P1', 'Use Referral Code');
	    $sheet->setCellValue('Q1', 'Register Date');
        $sheet->setCellValue('R1', 'Status');

		$sheet->setCellValue('S1', 'Source');
        
        	$records = $this->db->table('users');
            $records->select('*');
            $records->orderBy('register_date','DESC');
            $records=$records->get()->getResultArray();

		$count = 2;

        $i=1;
        $totalAmount=0;
		foreach($records as $record )
        {
            if($record['status']==1)
            {
                $status="Active";
            }
            else
            {
                $status="Inactive";
            }
            
            if($record['source']=="register")
            {
                $source="Email Register";
            }
            else
            {
                $source=$record['source'];
            }
            
             
            $register_date=date("d-m-Y H:i:s",strtotime($record['register_date']));

			$sheet->setCellValue('A' . $count, $i);

			$sheet->setCellValue('B' . $count, trim($record['first_name']." ".$record['last_name']));

			$sheet->setCellValue('C' . $count, $record['phone']);
			
			$sheet->setCellValue('D' . $count, $record['email']);
			
			$sheet->setCellValue('E' . $count, $record['additional_email']);
			
			$sheet->setCellValue('F' . $count, date("d-m-Y H:i:s",strtotime($record['dob'])));
			
			$sheet->setCellValue('G' . $count, date("d-m-Y H:i:s",strtotime($record['anniversary'])));
			
			$sheet->setCellValue('H' . $count, $record['gender']);
			
			$sheet->setCellValue('I' . $count, $record['address1']);
			
			$sheet->setCellValue('J' . $count, $record['address2']);
			
			$sheet->setCellValue('K' . $count, $record['city']);
			
			$sheet->setCellValue('L' . $count, $record['region']);
			
			$sheet->setCellValue('M' . $count, $record['country']);
			
			$sheet->setCellValue('N' . $count, $record['zipcode']);
			
			$sheet->setCellValue('O' . $count, $record['referralcode']);
			
			$sheet->setCellValue('P' . $count, $record['referralcodeby']);
			
			$sheet->setCellValue('Q' . $count, $register_date);
			
            $sheet->setCellValue('R' . $count, $status);
            
            $sheet->setCellValue('S' . $count, $source);
            
			$count++;
			$i++;
        }
        
        
        
		$writer = new Xlsx($spreadsheet);

		$writer->save($file_name);

		header("Content-Type: application/vnd.ms-excel");

		header('Content-Disposition: attachment; filename="' . basename($file_name) . '"');

		header('Expires: 0');

		header('Cache-Control: must-revalidate');

		header('Pragma: public');

		header('Content-Length:' . filesize($file_name));

		flush();

		readfile($file_name);

		exit;
    }
    
    public function paymentReports()
    {
        $file_name = 'Payments Report.xlsx';

		$spreadsheet = new Spreadsheet();

		$sheet = $spreadsheet->getActiveSheet();
        $from = "A1"; // or any value
        $to = "I1"; // or any value
        $sheet->getStyle("$from:$to")->getFont()->setBold( true );
		$sheet->setCellValue('A1', 'Sr.no');

		$sheet->setCellValue('B1', 'Order No.');

		$sheet->setCellValue('C1', 'Transaction Id');

		$sheet->setCellValue('D1', 'Amount');
		
		$sheet->setCellValue('E1', 'Payer Name');
		
		$sheet->setCellValue('F1', 'Payer Email');
		
		$sheet->setCellValue('G1', 'Payment Type');
		
		$sheet->setCellValue('H1', 'Payment Status');
		$sheet->setCellValue('I1', 'Payment Date');
        
        $records = $this->db->table('payments');
        $records->select('*');
        $records->orderBy('createDate','DESC');
        $records=$records->get()->getResultArray();

		$count = 2;

        $i=1;
        $totalAmount=0;
		foreach($records as $record )
        {
           
            $orderid=$record['orderid'];
			$userid=$record['userid'];
            $orderDetails=$this->OrderModel->orderDetail($orderid);
            
            $date=date("d-m-Y H:i:s",strtotime($record['createDate']));

			$sheet->setCellValue('A' . $count, $i);

			$sheet->setCellValue('B' . $count, $record['orderid']);

			$sheet->setCellValue('C' . $count, $record['txn_id']);
			
			$sheet->setCellValue('D' . $count, $orderDetails['currency']." ".number_format($record['payment_gross'],2));
			
			$sheet->setCellValue('E' . $count, $record['payer_name']);
			
			$sheet->setCellValue('F' . $count, $record['payer_email']);
			
			$sheet->setCellValue('G' . $count, $record['paymenttype']);
			
			$sheet->setCellValue('H' . $count, $record['paymentStatus']);
			
			$sheet->setCellValue('I' . $count, $date);
			
		
			$count++;
			$i++;
        }
        
        
        
		$writer = new Xlsx($spreadsheet);

		$writer->save($file_name);

		header("Content-Type: application/vnd.ms-excel");

		header('Content-Disposition: attachment; filename="' . basename($file_name) . '"');

		header('Expires: 0');

		header('Cache-Control: must-revalidate');

		header('Pragma: public');

		header('Content-Length:' . filesize($file_name));

		flush();

		readfile($file_name);

		exit;
    }
    
}
