<?php

namespace App\Controllers\Admin;

use App\Models\UpsModel;
use App\Models\OrderModel;
use App\Models\ContentModel;
use App\Models\ShipperModel;
use App\Models\UserModel;
use App\Models\OrderShipmentModel;

use App\Controllers\BaseController;
use DateTime;

class UpsController extends BaseController
{
	
	public function __construct(){
      
        $this->ContentModel = new ContentModel(); 
        $this->OrderModel = new OrderModel(); 
		$this->ShipperModel = new ShipperModel(); 
		$this->OrderShipmentModel = new OrderShipmentModel(); 
		$this->UpsModel = new UpsModel(); 
		$this->UserModel = new UserModel();
		
    }
	
	public function index()
	{
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Shipments";
        $orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['language'] = $this->OrderModel->getlanguage();
        $data['page']='shipment';
        return view('Admin/admin_index',$data);
    }
	
	public function GetShipments()
{
    $request = service('request');
    $postData = $request->getPost('data');

    $start = $postData['start'];
    $length = $postData['length'];
    $searchValue = $postData['search']['value'];
    $shipmentstatus = $postData['shipmentstatus'] ?? '';
    $daterange = $postData['daterange'] ?? '';

    $builder = $this->db->table('ordershipment');

    // Filtering
    if ($shipmentstatus != '') {
        $builder->where('status', $shipmentstatus);
    }

    if (!empty($daterange)) {
    $dates = explode(' - ', $daterange);
    if (count($dates) == 2) {
        $from = DateTime::createFromFormat('d/m/Y', trim($dates[0]))->format('Y-m-d');
        $to = DateTime::createFromFormat('d/m/Y', trim($dates[1]))->format('Y-m-d');

        $builder->where('created_at >=', $from)
                ->where('created_at <=', $to . ' 23:59:59');
    }
}

    if (!empty($searchValue)) {
        $builder->groupStart()
            ->like('order_id', $searchValue)
            ->orLike('tracking_number', $searchValue)
            ->orLike('ShipmentIdentificationNumber', $searchValue)
            ->groupEnd();
    }

    $totalRecords = $builder->countAllResults(false);

    $data = $builder->limit($length, $start)->get()->getResult();

    $resultData = [];
    $sr = $start + 1;
    foreach ($data as $row) {
		$base64 = $row->shipping_label;
		$safeBase64 = htmlspecialchars($base64); // Escape for HTML
		$labelType=$row->label_type;
		$labelType = strtoupper($row->label_type); // Make sure you're storing label type

		if ($labelType === 'ZPL') {
			$decodedZpl = base64_decode($row->shipping_label);
			$safeZpl = htmlspecialchars($decodedZpl, ENT_QUOTES); // safe for HTML attribute
			$labelDisplay = '<button class="btn btn-sm btn-primary viewZPL" data-zpl="'.$safeZpl.'">Print ZPL</button>';
		} elseif ($labelType === 'GIF') {
			$imageUrl = base_url($row->label_file);
			$labelDisplay = '<img src="' . $imageUrl . '" class="label-preview" data-full="' . $imageUrl . '" style="max-height:30px; cursor:pointer;" />';
		} else {
			$labelDisplay = 'Label format not supported';
		}
        $resultData[] = [
            'sr' => $sr++,
            'orderid' => $row->order_id,
            'trackingNumber' => $row->tracking_number,
            'billingWeight' => $row->billing_weight,
            'transportationCharges' => $row->transportation_charges,
            'serviceCharges' => $row->service_options_charges,
            'shipmentIdentificationNumber' => $row->ShipmentIdentificationNumber,
            'totalCharges' => $row->total_charges,
			'pickup_prn' => is_null($row->pickup_prn) ? 'N/A' : $row->pickup_prn,
			'shippingLabel' => $labelDisplay,
            'shipmentstatus' => ucwords($row->status),
            'shipdate' => date('Y-m-d', strtotime($row->created_at)),
			'action' => ($row->status == 'pickup scheduled') ? 
				'<button class="btn btn-sm btn-warning cancelPickup" data-id="'.$row->id.'" style="margin-right: 5px;">Cancel Pickup</button>' :
				(($row->status == 'shipped' || $row->status == 'pickup canceled') ?
					'<button class="btn btn-sm btn-success createPickup" data-id="'.$row->id.'" style="margin-right: 5px;">Create Pickup</button>
					 <button class="btn btn-sm btn-danger cancelShipment" data-id="'.$row->id.'" >Cancel Shipment</button>' :
					'N/A')
        ];
    }

    return $this->response->setJSON([
        'draw' => $postData['draw'],
        'recordsTotal' => $totalRecords,
        'recordsFiltered' => $totalRecords,
        'aaData' => $resultData,
    ]);
}

	public function getShippers($shipperId)
	{
		// Load the ShipperModel

		// Retrieve the shipper data
		$shipper = $this->ShipperModel->find($shipperId);

		// Check if shipper exists
		if ($shipper) {
			return $this->response->setJSON([
				'success' => true,
				'shipper' => $shipper
			]);
		} else {
			return $this->response->setJSON([
				'success' => false,
				'message' => 'Shipper not found'
			]);
		}
	}
	
	public function createPickup($id)
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
		
		$data=[];
		// Fetch the shipment details based on the shipment ID
		$shipment = $this->OrderShipmentModel->find($id); // Assuming the table is 'order' and you use the model to find records by id

		// Check if shipment exists
		if (!$shipment) {
			return redirect()->to('/admin/shipments')->with('error', 'Shipment not found.');
		}
		$data['shipment'] = $shipment;
		$data['orders'] = $this->OrderModel->shipmentorders();
		$data['shippers'] = $this->ShipperModel->findAll();
		$data['warehouses'] = $this->UpsModel->warehouses();
		
        $data['page']='createpickup';
        return view('Admin/admin_index',$data);
	}

	
	
	public function CreateShipment($orderid='')
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
		$data['orderid']=$orderid;
		$data['orders'] = $this->OrderModel->shipmentorders();
		$data['shippers'] = $this->ShipperModel->findAll();
		$data['warehouses'] = $this->UpsModel->warehouses();
		
		
        $data['page']='createshipment';
        return view('Admin/admin_index',$data);
	}
	
	
	public function checkOrderExists()
{
    $orderId = $this->request->getPost('order_id');

    $order = $this->db->table('masterorders')
                      ->where('orderid', $orderId)
                      ->get()
                      ->getRow();

    if ($order) {
        return $this->response->setJSON([
            'status' => 'success',
            'message' => 'Order found.'
        ]);
    } else {
        return $this->response->setJSON([
            'status' => 'error',
            'message' => 'Invalid Order No. Please check and try again.'
        ]);
    }
}

public function submitCreateShipment()
{
    $request = \Config\Services::request();

    // Retrieve form data
    $orderId = $request->getPost('order_id');
    $shipperId = $request->getPost('shipper_id');
    $warehouseid = $request->getPost('warehouse_id');
    $weight = $request->getPost('weight');
    $length = $request->getPost('length');
    $height = $request->getPost('height');
	$width = $request->getPost('width');
    $serviceCode = $request->getPost('service_code');
    $DimensionsCode = $request->getPost('dimension_unit');
    $WeightCode = $request->getPost('weight_unit');
	$serviceDesc = $request->getPost('servicedesc') ?: '';
    $package_type = $request->getPost('package_type');
    $packagedesc = $request->getPost('packagedesc') ?: '';
	$label_type = $request->getPost('label_type') ?: '';
   
    // Check if a shipment already exists for this order
    $existingShipment = $this->OrderShipmentModel->where('order_id', $orderId)->first();
    if ($existingShipment) {
        return $this->response->setJSON([
            'error' => 'A shipment has already been created for this order.'
        ]);
    }

   
    // Fetch order details
    $order = $this->OrderModel->shipmentorder($orderId);
    if (!$order) {
        return $this->response->setJSON(['error' => 'Order not found']);
    } else {
		
        $orderno = $order['orderid'];
		$result = $this->UpsModel->totalOrderPcs($orderId);
		$totalPcs = $result['pcs'] ?? 0;
		$orderQuantity=$totalPcs;
        $ShipTo = $this->UpsModel->ShipTo($orderno);
        $ShipFrom = $this->UpsModel->ShipFrom($warehouseid);
    }

    $shipper = $this->UpsModel->shipper($shipperId);
    if (!$shipper) {
        return $this->response->setJSON(['error' => 'Shipper not found']);
    }
	
$label_type = strtoupper($label_type ?? 'GIF'); // Default to GIF if not set

// Build LabelSpecification based on label type
$labelSpec = [
    "LabelImageFormat" => [
        "Code" => $label_type,
    ]
];

// For ZPL, validate and add label size
if ($label_type === 'ZPL') {
    $zpl_height = trim($request->getPost('zpl_height') ?? '');
    $zpl_width  = trim($request->getPost('zpl_width') ?? '');

    if (is_numeric($zpl_height) && is_numeric($zpl_width)) {
        $labelSpec["LabelStockSize"] = [
            "Height" => $zpl_height,
            "Width"  => $zpl_width
        ];
    } else {
        log_message('error', 'Invalid ZPL label height or width');
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Invalid label height or width for ZPL format.'
        ]);
    }
}

// Prepare shipment data
$shipmentData = [
    "ShipmentRequest" => [
        "Request" => [
            "RequestOption" => "nonvalidate",
        ],
        "Shipment" => [
			"Description" => "Shipment",
            "Shipper" => [
                "Name" => $shipper['title'],
				"AttentionName" => !empty($shipper['title']) ? $shipper['title'] : 'Shipping Manager',
				"Phone" => [
					"Number" => preg_replace('/\D/', '', $shipper['phone'] ?? '0000000000') // ensures digits only
				],
                "ShipperNumber" => $shipper['account_number'],
                "Address" => [
                    "AddressLine" => trim($shipper['add1'] . ' ' . $shipper['add2']),
                    "City" => $shipper['city'],
                    "StateProvinceCode" => $shipper['state_iso2'],
                    "PostalCode" => $shipper['zipcode'],
                    "CountryCode" => $shipper['country_iso2'],
                ],
            ],
            "ShipTo" => [
				"Name" => trim($ShipTo['first_name'] . ' ' . $ShipTo['last_name']),
				"AttentionName" => !empty($ShipTo['first_name']) ? trim($ShipTo['first_name'] . ' ' . $ShipTo['last_name']) : 'Receiver',
				"Phone" => [
					"Number" => preg_replace('/\D/', '', $ShipTo['phone'] ?? '0000000000') // default if blank
				],
				"Address" => [
					"AddressLine" => array_filter([
						!empty($ShipTo['address1']) ? trim($ShipTo['address1']) : null,
						!empty($ShipTo['address2']) ? trim($ShipTo['address2']) : null,
					]),
					"City" => $ShipTo['city'],
					"StateProvinceCode" => $ShipTo['state_iso2'],
					"PostalCode" => $ShipTo['zipcode'],
					"CountryCode" => $ShipTo['country_iso2'],
				],
			],
            "ShipFrom" => [
                "Name" => $ShipFrom['title'],
                "Address" => [
                    "AddressLine" => trim($ShipFrom['add1'] . ' ' . $ShipFrom['add2']),
                    "City" => $ShipFrom['city'],
                    "StateProvinceCode" => $ShipFrom['state_iso2'],
                    "PostalCode" => $ShipFrom['zipcode'],
                    "CountryCode" => $ShipFrom['country_iso2'],
                ],
            ],
            "PaymentInformation" => [
                "ShipmentCharge" => [
                    "Type" => "01",
                    "BillShipper" => [
                        "AccountNumber" => $shipper['account_number'],
                    ],
                ],
            ],
            "Service" => [
                "Code" => $serviceCode,
                "Description" => $serviceDesc
            ],
            "Package" => [
                "Packaging" => [
                    "Code" => $package_type,
                    "Description" => $packagedesc
                ],
                "Dimensions" => [
                    "UnitOfMeasurement" => [
                        "Code" => $DimensionsCode,
                    ],
                    "Length" => $length,
                    "Width" => $width,
                    "Height" => $height,
                ],
                "PackageWeight" => [
                    "UnitOfMeasurement" => [
                        "Code" => $WeightCode,
                    ],
                    "Weight" => $weight,
                ],
            ],
        ],
        "LabelSpecification" => $labelSpec 
    ],
];



    // Get UPS Access Token
    $token = $this->UpsModel->getAccessToken();
    if (!$token) {
        return $this->response->setJSON(['error' => 'Failed to get access token']);
    }

    // Create Shipment with UPS
    $response = $this->UpsModel->createShipment($token, $shipmentData);
    //print_r($response); die;
    // Handle UPS Response
    if ($response['status'] === 'error') {
        $errorDetails = $response['data']['response']['errors'][0] ?? [];
        $errorMessage = $errorDetails['message'] ?? 'Unknown error occurred';
        return $this->response->setJSON(['error' => 'UPS API error: ' . $errorMessage]);
    }

    $shipmentResult = $response['data']['ShipmentResponse'] ?? null;
    if ($shipmentResult && isset($shipmentResult['ShipmentResults']['ShipmentIdentificationNumber'])) {
        $shipmentCharges = $shipmentResult['ShipmentResults']['ShipmentCharges'] ?? [];
        $packageResults = $shipmentResult['ShipmentResults']['PackageResults'] ?? [];

        $trackingNumber = $shipmentResult['ShipmentResults']['ShipmentIdentificationNumber'] ?? '';
        $transportationCharges = $shipmentCharges['TransportationCharges']['MonetaryValue'] ?? '0.00';
        $serviceOptionsCharges = $shipmentCharges['ServiceOptionsCharges']['MonetaryValue'] ?? '0.00';
        $totalCharges = $shipmentCharges['TotalCharges']['MonetaryValue'] ?? '0.00';
        $billingWeight = $shipmentResult['ShipmentResults']['BillingWeight']['Weight'] ?? '0.0';

        $labelContent = $packageResults['ShippingLabel']['GraphicImage'] ?? '';

		if ($label_type === 'ZPL') {
			// ZPL labels are in 'LabelImage' field as plain text
			$labelContent = $packageResults['ShippingLabel']['ImageFormat']['Code'] === 'ZPL'
				? $packageResults['ShippingLabel']['GraphicImage']
				: '';
			$labelData = $labelContent; // Plain ZPL text
			$labelExtension = 'zpl';
		} else {
			// GIF labels are base64 encoded in GraphicImage
			$labelData = base64_decode($labelContent);
			$labelExtension = 'gif';
		}

		// File path and name
		$labelFileName = 'label_' . $trackingNumber . '_' . time() . '.' . $labelExtension;
		$labelFilePath = FCPATH . 'uploads/labels/' . $labelFileName;

		// Ensure directory exists
		if (!file_exists(dirname($labelFilePath))) {
			mkdir(dirname($labelFilePath), 0755, true);
		}

		// Save label file
		file_put_contents($labelFilePath, $labelData);

		// Save shipment info in database
		$shipmentData = [
		'order_id' => $orderno,
		'tracking_number' => $trackingNumber,
		'billing_weight' => $billingWeight,
		'transportation_charges' => $transportationCharges,
		'service_options_charges' => $serviceOptionsCharges,
		'ShipmentIdentificationNumber' => $trackingNumber,
		'total_charges' => $totalCharges,
		'shipping_label' => $labelContent, // base64 or plain text
		'label_file' => 'uploads/labels/' . $labelFileName,
		'label_type' => $label_type,       // Save type for reference
		'shipper_id' => $shipperId,
		'warehouse_id' => $warehouseid,
		'weight' => $weight,
		'length' => $length,
		'height' => $height,
		'service_code' => $serviceCode,
		'dimension_unit' => $DimensionsCode,
		'weight_unit' => $WeightCode,
		'servicedesc' => $serviceDesc,
		'package_type' => $package_type,
		'packagedesc' => $packagedesc,
		'quantity' => $orderQuantity,
		'created_at' => date('Y-m-d H:i:s'),
		];
		
		

        $this->OrderShipmentModel->save($shipmentData);
        $this->UpsModel->updateTrackingNumber($orderno, $trackingNumber);
			
			// Send email to customer
			$emailtemplate = emailtemplates('order-status-change');
			$websettings = websettings();
			$userid=$order['userid'];
			
			$userDetail = $this->UserModel->getUserById($userid);
			
			$link = base_url('customer/orders'); // Link to order history page

			$token = array(
				'SITE_URL' => base_url(),
				'SITE_TITLE' => $websettings['company_title'],
				'NAME' => trim($userDetail['first_name'] . ' ' . $userDetail['last_name']),
				'ORDER_ID' => $order['orderid'],
				'ORDER_STATUS' => ucfirst('shipped'),
			);

			$to = $userDetail['email'];
			$this->send_email($emailtemplate, $token, $to);
         
         	$orderStatusHistory=array(
				'orderid'=>$orderno,
				'userid'=>$order['userid'],
				'status'=>'shipped',
				'update_date'=>date('Y-m-d H:i:s'),
			);
			
			$this->OrderModel->insertOrderStatusHistory($orderStatusHistory); 
			
         
        return $this->response->setJSON([
            'status' => 'success',
            'tracking_number' => $trackingNumber,
            'billing_weight' => $billingWeight . ' lbs',
            'transportation_charges' => '$' . $transportationCharges,
            'service_options_charges' => '$' . $serviceOptionsCharges,
            'ShipmentIdentificationNumber' => $shipmentResult['ShipmentResults']['ShipmentIdentificationNumber'],
            'total_charges' => '$' . $totalCharges,
			'label_type' => $label_type,
            'label_url' => base_url('uploads/labels/' . $labelFileName)
        ]);
    } else {
        log_message('error', 'Failed to create shipment. Response: ' . print_r($response, true));
        return $this->response->setJSON(['error' => 'Failed to create shipment. Please try again later.']);
    }
}


	public function cancelUpsShipment()
    {
	$request = \Config\Services::request();
	$shipmentId=$request->getPost('id');
    // Get shipment details from your database
      $shipment = $this->OrderShipmentModel->where('id', $shipmentId)->first();  // Use 'first()' to get a single row


    // Check if shipment exists
    if ($shipment) {
		
        // Extract required information for the UPS API request
        $trackingNumber = $shipment['tracking_number'];
		$orderId = $shipment['order_id'];
        $shipmentIdentificationNumber = $shipment['ShipmentIdentificationNumber'];

        // Call the cancelShipment method from the UpsModel
		$token = $this->UpsModel->getAccessToken();
		if (!$token) {
			return $this->response->setJSON(['error' => 'Failed to get access token']);
		}
	
      $response = $this->UpsModel->cancelShipment($token, $shipmentIdentificationNumber, $trackingNumber);

// Debug only during development
// print_r($response); die;

// Check if the response was successful
if ($response['status'] === 'success') {
    return $this->response->setJSON([
        'status' => 'success',
        'message' => 'Shipment has been successfully canceled.',
        'data' => $response['data']
    ]);
} else {
    // Extract UPS error message if available
    $errorMsg = 'Failed to cancel shipment.';

    if (
        isset($response['data']['response']['errors'][0]['message']) &&
        !empty($response['data']['response']['errors'][0]['message'])
    ) {
        $errorMsg = $response['data']['response']['errors'][0]['message'];
    }

    return $this->response->setJSON([
        'status' => 'error',
        'message' => $errorMsg,
        'data' => $response['data'],
        'httpCode' => $response['httpCode']
    ]);
}
    } else {
        // If no shipment is found
        return $this->response->setJSON([
            'status' => 'error',
            'message' => 'Shipment not found.',
        ]);
    }
}

public function cancelUpsPickup()
{
	$request = \Config\Services::request();
	$shipmentId=$request->getPost('id');
    // Get shipment details from your database
      $shipment = $this->OrderShipmentModel->where('id', $shipmentId)->first();  // Use 'first()' to get a single row


    // Check if shipment exists
    if ($shipment) {
		
        // Extract required information for the UPS API request
        $pickup_prn = $shipment['pickup_prn'];
		$orderId = $shipment['order_id'];
        $TransactionIdentifier = $shipment['TransactionIdentifier'];

        // Call the cancelShipment method from the UpsModel
		$token = $this->UpsModel->getAccessToken();
		if (!$token) {
			return $this->response->setJSON(['error' => 'Failed to get access token']);
		}
	
       $response = $this->UpsModel->cancelPickup($token, $TransactionIdentifier, $pickup_prn);

		// Debug only during development
		// print_r($response); die;

		// Check if the response was successful
		if ($response['status'] === 'success') {
			
			$this->db->table('masterorders')
						->where('orderid', $orderId)
						->update([
                           'tracking_status' => 'pickup canceled',
                       ]);
					   
			$this->db->table('ordershipment')
						->where('id', $shipmentId)
						->update([
                           'status' => 'pickup canceled',
                       ]);
					   
			return $this->response->setJSON([
				'status' => 'success',
				'message' => 'Shipment has been successfully canceled.',
				'data' => $response['data']
			]);
		} else {
			// Extract UPS error message if available
			$errorMsg = 'Failed to cancel shipment.';

			if (
				isset($response['data']['response']['errors'][0]['message']) &&
				!empty($response['data']['response']['errors'][0]['message'])
			) {
				$errorMsg = $response['data']['response']['errors'][0]['message'];
			}

			return $this->response->setJSON([
				'status' => 'error',
				'message' => $errorMsg,
				'data' => $response['data'],
				'httpCode' => $response['httpCode']
			]);
		}
    } else {
        // If no shipment is found
        return $this->response->setJSON([
            'status' => 'error',
            'message' => 'Shipment not found.',
        ]);
    }
}


public function createUpsPickup()
{
    // Get shipment details from the database
	$request = \Config\Services::request();

    // Retrieve form data
	$shipmentid=$request->getPost('id');
	$shipment = $this->OrderShipmentModel->find($shipmentid);
    $orderId = $request->getPost('order_id');
    $orderno = $shipment['order_id'];

    $shipperId = $shipment['shipper_id'];
    $warehouseid = $shipment['warehouse_id'];

    // Fetch additional data for shipper, shipto, and shipfrom
    $ShipTo = $this->UpsModel->ShipTo($orderno);
    $ShipFrom = $this->UpsModel->ShipFrom($warehouseid);
    $shipper = $this->UpsModel->shipper($shipperId);
    
    if (!$shipper) {
        return ['error' => 'Shipper not found'];
    }

    // Input values for the pickup (can be dynamic or predefined)
    $getpickupDate = $request->getPost('pickup_date');  // Today's date or pass dynamic date
    $getreadyTime = $request->getPost('ready_time');  // e.g., 5:00 AM
    $getcloseTime = $request->getPost('close_time');  // e.g., 2:00 PM
	$pickupDate = date('Ymd', strtotime(str_replace('-', '/', $getpickupDate)));
	$readyTime = str_replace(':', '', $getreadyTime); // e.g., "05:00" → "0500"
	$closeTime = str_replace(':', '', $getcloseTime); // e.g., "14:00" → "1400"
    $specialInstructions = $request->getPost('specialInstructions');  // Optional field, dynamic or fixed

    // Pickup Pieces (can be dynamic based on shipment)
    $shipments = $this->OrderShipmentModel->getShipmentByOrder($orderno);  // Get shipment details for this order
	$pickupPieces = [];

	foreach ($shipments as $item) {
		$pickupPieces[] = [
			"ServiceCode" => str_pad($item['service_code'], 3, '0', STR_PAD_LEFT),  // Correct: get value from array
			'Quantity' =>  $item["quantity"],   // Ensure it's an integer
			'DestinationCountryCode' => $ShipTo['country_iso2'],  // Ensure this variable is defined
			'ContainerCode' => $item['package_type'],
		];
	}

    // Prepare the payload for the UPS API
    $payload = [
        "PickupCreationRequest" => [
            "RatePickupIndicator" => "N",  // Not required for rate pickup
            "Shipper" => [
                "Account" => [
                    "AccountNumber" => $shipper['account_number'],  // From Shipper database
                    "AccountCountryCode" => $shipper['country_iso2'],  // From Shipper database
                ]
            ],
            "PickupDateInfo" => [
                "CloseTime" => $closeTime,  // Fixed or dynamic
                "ReadyTime" => $readyTime,  // Fixed or dynamic
                "PickupDate" => $pickupDate,  // Date of pickup (format: YYYYMMDD)
            ],
            "PickupAddress" => [
                "CompanyName" => $ShipFrom['title'],  // From ShipFrom database
                "ContactName" => $ShipFrom['title'],  // From ShipFrom database
                "AddressLine" => $ShipFrom['add1'] . ' ' . $ShipFrom['add2'],  // From ShipFrom database
                "Room" => $ShipFrom['room'] ?? "",  // Optional, if available
                "Floor" => $ShipFrom['floor'] ?? "",  // Optional, if available
                "City" => $ShipFrom['city'],  // From ShipFrom database
                "StateProvince" => $ShipFrom['state_iso2'],  // From ShipFrom database
                "PostalCode" => $ShipFrom['zipcode'],  // From ShipFrom database
                "CountryCode" => $ShipFrom['country_iso2'],  // From ShipFrom database
                "ResidentialIndicator" => "N",  // Set based on ShipFrom or input ("Y" for residential, "N" for commercial)
                "PickupPoint" => "Lobby",  // Fixed or dynamic based on the pickup location
                "Phone" => [
                    "Number" => $ShipFrom['phone'],  // From ShipFrom database
                    "Extension" => $ShipFrom['phone_extension'] ?? "911",  // Optional, from ShipFrom database
                ]
            ],
            "AlternateAddressIndicator" => "Y",  // Default value, can be set dynamically
            "PickupPiece" => $pickupPieces,  // Array of items to be picked up (from shipment data)
            "TotalWeight" => [
                "Weight" => $shipment['weight'],  // Total weight from shipment data
                "UnitOfMeasurement" => $shipment['weight_unit'],  // LBS or KG
            ],
            "OverweightIndicator" => ($shipment['weight'] > 150) ? "Y" : "N",  // Example logic for overweight
            "PaymentMethod" => "01",  // Default is Bill Shipper (01)
            "SpecialInstruction" => $specialInstructions,  // Optional special instructions
            "ReferenceNumber" => $shipment['ShipmentIdentificationNumber'],  // Optional, you can use order number or custom reference
        ]
    ];
     
      // Get UPS Access Token
		$token = $this->UpsModel->getAccessToken();
    
		$responseData = $this->UpsModel->createPickup($token, $payload);
		if ($responseData['status'] === 'success' && isset($responseData['data']['PickupCreationResponse'])) 
		{
			
			$pickupData = $responseData['data']['PickupCreationResponse'];

			// Prepare insert/update array
			$insertData = [
				'pickup_prn'       => $pickupData['PRN'] ?? null,
				'rate_code'        => $pickupData['RateStatus']['Code'] ?? null,
				'rate_description' => $pickupData['RateStatus']['Description'] ?? null,
				'sat_wst'          => $pickupData['WeekendServiceTerritory']['SatWST'] ?? null,
				'sun_wst'          => $pickupData['WeekendServiceTerritory']['SunWST'] ?? null,
				'TransactionIdentifier'   => $pickupData['Response']['TransactionReference']['TransactionIdentifier'] ?? null,
				'CustomerContext' => $pickupData['Response']['TransactionReference']['CustomerContext'] ?? null,
				'status'    => 'pickup scheduled',
				'pickup_requested_at' => date('Y-m-d H:i:s'),
			];
			
			$this->UpsModel->updatePickupdata($shipmentid, $insertData);
			
			$this->db->table('masterorders')
						->where('orderid', $orderId)
						->update([
                           'tracking_status' => 'pickup scheduled',
                       ]);
	
			return $this->response->setJSON([
				'status'  => 'success',
				'message' => $responseData['message'],
				'data'    => $responseData['data']
			]);
		} else {
			$errorMsg = $responseData['data']['response']['errors'][0]['message'] ?? $responseData['message'];
			return $this->response->setJSON([
				'status'  => 'error',
				'error'   => $errorMsg,
				'data'    => $responseData['data'],
				'httpCode'=> $responseData['httpCode'] ?? 500
			]);
		}    
	}
	
	public function send_email($emailtemplate,$token,$to,$cc=NULL, $from=NULL, $email_type=NULL, $redirect_url=NULL)
    {
        $pattern = '[%s]';
        foreach ($token as $key => $val)
        {
            $varMap[sprintf($pattern, $key) ] = $val;
        }       
        
        $emailContent = strtr($emailtemplate['body'], $varMap);
        $subject = $emailtemplate['subject'];
        default_smtp_mail($emailContent,$subject,$to,$cc);
    }

}