<?php
namespace App\Controllers\Admin;
use App\Models\UserModel;
use App\Models\HomeModel;
use App\Models\OrderModel;
use App\Controllers\BaseController;
use App\Controllers\Api;
class User extends BaseController
{
    public function __construct(){
        $this->Api = new Api();
        $this->UserModel = new UserModel(); 
        $this->HomeModel = new HomeModel(); 
        $this->OrderModel = new OrderModel(); 		
    }
    public function lang_serialize($language_arr,$name_arr)
    {
        $serializeArr=array();
        foreach($language_arr as $index=>$language_row)
        {
            $serializeArr[$language_row]=$name_arr[$index];
        }
        return $serialized_array=serialize($serializeArr);
    }
    public function lang_unserialize($serialized_name)
    {
        return unserialize($serialized_name);
    }
    public function lang_slug($unserializeName)
    {
       
        foreach($unserializeName as $index=>$row)
        {
            if($index=='eng' || $index=='en')
            {
                return strtolower(url_title($row));
            }
            
        }
    }
    
    public function fetch_states()
    {
        $countryid        = $this->request->getVar('countryid');
        $states=region($countryid);
        if(isset($states) && count($states)>=1)
        {
        $data=array(
            'status'=>true,
            'states'=>$states,
            'message'=>''
            );
        echo json_encode($data);  
        }
        else
        {
            $data=array(
            'status'=>false,
            'states'=>'',
            'message'=>'State Not found.'
            );
        echo json_encode($data); 
        }
    }
    
     public function role()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']='Role';
        $data['page']='User/role';
        return view('Admin/admin_index',$data);
    }
    
    
    
    public function rolecreate()
    {
        if(!isset($this->session->admin))
        {
           $response=array(
               'status'=>false,
               'message'=>'Not Authorised.'
               );
           return json_encode($response);
        }
         $role        = $this->request->getVar('role');
         $detail      = $this->request->getVar('detail');
         $data=array(
             'role'=>$role,
             'detail'=>$detail
             );
        $checkExistRole=$this->UserModel->checkExistRole($role);
        if(isset($checkExistRole) && count($checkExistRole)>=1)
        {
            $response=array(
               'status'=>false,
               'message'=>'Role already exists.'
               );
           return json_encode($response);
            
        }
        else
        {
            $InsertRole=$this->UserModel->InsertRole($data); 
            if($InsertRole)
            {
                $response=array(
                   'status'=>true,
                   'message'=>'Role Successfully add.'
                   );
               return json_encode($response);
            }
            else
            {
                 $response=array(
                   'status'=>false,
                   'message'=>'Something Wrong.'
                   );
               return json_encode($response);
            }
        }
        
    }
    
    public function getrole()
    {
        $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
              
       ## Total number of records without filtering
       $totalRecords = $this->db->table('role')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('role')
                                ->select('id')
                                ->Like('role', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('role')
            ->select('*')
            ->Like('role', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record )
       {
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status='';  
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
         
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
                $action.='<span title="Permission" class="permission-button">';
               $action.='<a href="'.base_url().'admin/user/permission/'.$record['id'].'" data-id="'.$record['id'].'" class="permission-record">';
               $action.='<i class="bx bx-lock"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
            
          $data[] = array( 
                 "id"=>$i,
                 "role"=>'<a href="'.base_url().'admin/user/permission/'.$record['id'].'" data-id="'.$record['id'].'" class="permission-record">'.$record['role'].'</a>',
                 "detail"=>$record['detail'],
                 "Status"=>$status,
                 "action"=>$action,
              ); 
    
          $i++;
       }
    
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);

    }
    
    public function geteditrole()
    {
        if(!isset($this->session->admin))
        {
           $response=array(
               'status'=>false,
               'message'=>'Not Authorised.'
               );
           return json_encode($response);
        }
        $id = $this->request->getVar('editId');
        $editRole=$this->UserModel->geteditrole($id);
        if(isset($editRole) && count($editRole)>=1)
        {
             $response=array(
               'status'=>true,
               'message'=>'Record  found.',
               'data'=>$editRole
               );
           return json_encode($response);
        }
        else
        {
            $response=array(
               'status'=>false,
               'message'=>'Record not found.'
               );
           return json_encode($response);
        }
    }
    
    public function roleupdate()
    {
        if(!isset($this->session->admin))
        {
           $response=array(
               'status'=>false,
               'message'=>'Not Authorised.'
               );
           return json_encode($response);
        }
         $role        = $this->request->getVar('role');
         $detail      = $this->request->getVar('detail');
         $id        = $this->request->getVar('id');
         $data=array(
             'role'=>$role,
             'detail'=>$detail
             );
        $checkUpdateRole=$this->UserModel->checkUpdateRole($id);
        if(isset($checkUpdateRole) && count($checkUpdateRole)>=1)
        {
            
            $UpdateRole=$this->UserModel->UpdateRole($id,$data);
            $response=array(
               'status'=>true,
               'message'=>'Role successfully update.'
               );
           return json_encode($response);
            
        }
        else
        {
                $response=array(
                   'status'=>true,
                   'message'=>'Record Not found.'
                   );
               return json_encode($response);
        }
        
    }
    
    public function rolestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->UserModel->update_role_status($status,$id); 
             
    }
    
    public function roledelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->UserModel->role_delete($id);  
    }
    
    public function addemployee()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['roles']=$this->UserModel->getAllRoles();
        $data['title']='Employee';
        $data['page']='User/addemployee';
        return view('Admin/admin_index',$data);
    }
    
    public function employeecreate()
    {
        if(!isset($this->session->admin))
        {
           $response=array(
               'status'=>false,
               'message'=>'Not Authorised.'
               );
           return json_encode($response);
        }
        
        $firstname        = $this->request->getVar('firstname');
        $lastname        = $this->request->getVar('lastname');
        $password        = $this->request->getVar('password');
        $email        = $this->request->getVar('email');
        $mobile      = $this->request->getVar('mobile');
        $position      = $this->request->getVar('position');
        $address1      = $this->request->getVar('address1');
        $address2      = $this->request->getVar('address2');
        $countryid     = $this->request->getVar('country');
        $country     = countryname($countryid);
        $stateid      = $this->request->getVar('state');
        $state      = regionname($stateid);
        $city      = $this->request->getVar('city');
        $zipcode      = $this->request->getVar('zipcode');
        $role      = $this->request->getVar('role');
        
        // check email no exist or not
        $checkexistemail=$this->UserModel->checkexistemail($email);
        if(isset($checkexistemail) && count($checkexistemail)>=1)
        {
            $response=array(
               'status'=>false,
               'message'=>'Email already exist.'
               );
           return json_encode($response);
        }
        
        // check mobile no exist or not
        $checkexistmobile=$this->UserModel->checkexistmobile($mobile);
        if(isset($checkexistmobile) && count($checkexistmobile)>=1)
        {
            $response=array(
               'status'=>false,
               'message'=>'Mobile already exist.'
               );
           return json_encode($response);
        }
        
            
        $profile='assets/images/dummy-profile.jpg';
        
        if($file = $this->request->getFile('profile')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $mobile.'employee'.$ext; 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/employee/', $newName);

                         // File path to display preview
                         $profile = "public/uploads/employee/".$newName;
                    }
         }  
         
         $employeedata=array(
            'profile'=>$profile,
            'firstname'=>$firstname,
            'lastname'=>$lastname,
            'lastname'=>$lastname,
            'email'=>$email,
            'mobile'=>$mobile,
            'position'=>$position,
            'password'=>$password,
            'address1'=>$address1,
            'address2'=>$address2,
            'countryid'=>$countryid,
            'country'=>$country,
            'stateid'=>$stateid,
            'state'=>$state,
            'city'=>$city,
            'zipcode'=>$zipcode,
            'role'=>$role,
            );

         $InsertEmployee=$this->UserModel->InsertEmployee($employeedata); 
            if($InsertEmployee)
            {
                $response=array(
                   'status'=>true,
                   'message'=>'Employee Successfully add.'
                   );
               return json_encode($response);
            }
            else
            {
                 $response=array(
                   'status'=>false,
                   'message'=>'Something Wrong.'
                   );
               return json_encode($response);
            }   
        
        
    }
    
    public function employee()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']='Employee';
        $data['page']='User/employee';
        return view('Admin/admin_index',$data);
    }
    public function getemployee()
    {
         $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
              
       ## Total number of records without filtering
       $totalRecords = $this->db->table('employee')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('employee')
                                ->select('id')
                                ->Like('firstname', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('employee')
            ->select('*')
            ->Like('firstname', $searchValue)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record )
       {
           $image='<img src="'.base_url().$record['profile'].'" class="table-img">';
           
           $roleid=$record['role'];
           $roleDetail=$this->UserModel->geteditrole($roleid);
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status='';  
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
         
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/user/editemployee/'.$record['id'].'" data-id="'.$record['id'].'" class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
            
          $data[] = array( 
                 "id"=>$i,
                 "image"=>$image,
                 "firstname"=>trim($record['firstname'].' '.$record['lastname']),
                 "email"=>$record['email'],
                 "mobile"=>$record['mobile'],
                 "position"=>$record['position'],
                 "role"=>$roleDetail['role'],
                 "password"=>$record['password'],
                 "Status"=>$status,
                 "action"=>$action,
              ); 
              
    
          $i++;
       }
    
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);   
    }
    
    public function editemployee($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['roles']=$this->UserModel->getAllRoles();
        $data['employee']=$this->UserModel->geteditemployee($id);
        $data['title']='Employee';
        $data['page']='User/editemployee';
        return view('Admin/admin_index',$data);
    }
    
    public function employeeupdate($id)
    {
        
        if(!isset($this->session->admin))
        {
           $response=array(
               'status'=>false,
               'message'=>'Not Authorised.'
               );
           return json_encode($response);
        }
        
        $firstname        = $this->request->getVar('firstname');
        $lastname        = $this->request->getVar('lastname');
        $password        = $this->request->getVar('password');
        $email        = $this->request->getVar('email');
        $mobile      = $this->request->getVar('mobile');
        $position      = $this->request->getVar('position');
        $address1      = $this->request->getVar('address1');
        $address2      = $this->request->getVar('address2');
        $countryid     = $this->request->getVar('country');
        $country     = countryname($countryid);
        $stateid      = $this->request->getVar('state');
        $state      = regionname($stateid);
        $city      = $this->request->getVar('city');
        $zipcode      = $this->request->getVar('zipcode');
        $role      = $this->request->getVar('role');
        
        // check email no exist or not
        $checkexistemail=$this->UserModel->checkexistupdateemail($email,$id);
        if(isset($checkexistemail) && count($checkexistemail)>=1)
        {
            $response=array(
               'status'=>false,
               'message'=>'Email already exist.'
               );
           return json_encode($response);
        }
        
        // check mobile no exist or not
        $checkexistmobile=$this->UserModel->checkexistupdatemobile($mobile,$id);
        if(isset($checkexistmobile) && count($checkexistmobile)>=1)
        {
            $response=array(
               'status'=>false,
               'message'=>'Mobile already exist.'
               );
           return json_encode($response);
        }
        
         $employeedata=array(
            'firstname'=>$firstname,
            'lastname'=>$lastname,
            'lastname'=>$lastname,
            'email'=>$email,
            'mobile'=>$mobile,
            'position'=>$position,
            'password'=>$password,
            'address1'=>$address1,
            'address2'=>$address2,
            'countryid'=>$countryid,
            'country'=>$country,
            'stateid'=>$stateid,
            'state'=>$state,
            'city'=>$city,
            'zipcode'=>$zipcode,
            'role'=>$role,
            );
            
        if($file = $this->request->getFile('profile')) 
         {
                    if ($file->isValid() && ! $file->hasMoved()) 
                    {
                         // Get file name and extension
                         $name = $file->getName();
                         $ext = $file->getClientExtension();

                         // Get random file name
                         $newName = $mobile.'employee'.$ext; 
                           
                         // Store file in public/uploads/ folder
                         $file->move('./public/uploads/employee/', $newName);

                         // File path to display preview
                         $profile = "public/uploads/employee/".$newName;
                         $employeedata['profile']=$profile;
                    }
         }  
             

         $UpdateEmployee=$this->UserModel->UpdateEmployee($employeedata,$id); 
            if($UpdateEmployee)
            {
                $response=array(
                   'status'=>true,
                   'message'=>'Employee Successfully update.'
                   );
               return json_encode($response);
            }
            else
            {
                 $response=array(
                   'status'=>false,
                   'message'=>'Something Wrong.'
                   );
               return json_encode($response);
            }   
        
        
    
    }
    
    public function employeestatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->UserModel->update_employee_status($status,$id); 
             
    }
    
    public function employeedelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->UserModel->employee_delete($id);  
    }
    
    public function permission($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $getRole=$this->UserModel->geteditrole($id);
        if(isset($getRole) && count($getRole)>=1)
        {
            $data['role']=$getRole;
            $data['title']='Permission';
            $data['page']='User/permission';
            return view('Admin/admin_index',$data);
        }
        else
        {
            return redirect()->to('admin/user/role'); 
        }
        
    }
    
    public function role_permission($id)
    {
        $getRole=$this->UserModel->geteditrole($id);
        if(isset($getRole) && count($getRole)>=1)
        {
            
            $permissionserialize=serialize($_POST);
            
            $this->UserModel->update_role_permission($permissionserialize,$id);
            $data=array(
                'status'=>true,
                'message'=>'Role permission successfully update'   
                );
             echo json_encode($data);  
             return;
        }
        else
        {
            $data=array(
                'status'=>false,
                'message'=>'Role not found'   
                );
             echo json_encode($data);  
             return;
        }
    }
    
    
    public function customers()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']='Customers';
        $data['page']='customers';
        return view('Admin/admin_index',$data);
    }
    public function getcustomer()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       $filter=$searchValue;
       ## Total number of records without filtering
       $totalRecords = $this->db->table('users')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('users');
                                $totalRecordwithFilter->select('id');
                                
        $totalRecordwithFilter = $totalRecordwithFilter->countAllResults();

       ## Fetch records
       $records =   $this->db->table('users');
                    $records->select('*');
                    $records->orderBy('create_date','DESC');
                    $records->limit($rowperpage, $start);
        $records =  $records->get()->getResultArray();


       $data = array();
       $i=$start+1;
       $start=$start-1;
       $rowperpage=$rowperpage+$start;
       foreach($records as $key => $record )
       {
           if($start<$key && $rowperpage>=$key)
           {
			  $status='';
           if($record['phone']!='')
           {
               $mobile=$record['phone'];
           }
           else
           {
               $mobile='xxxxxxxxxx';
           }
           if($record['email']!='')
           {
               $email=$record['email'];
           }
           else
           {
               $email='-';
           }
           
               if($record['status']==1)
			   {
				  $checked='checked=""'; 
			   }
			   else
			   {
				   $checked=''; 
			   }
               $status.='<div class="square-switch">';
               $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
               $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
               $status.='</div>';
               
               $action='';
               $action.='<span class="action-buttons">';
               $action.='<span title="Edit" class="edit-button" >';
               $action.='<a href="'.base_url().'admin/customers/edit/'.$record['id'].'" data-id="'.$record['id'].'" class="edit-record">';
               $action.='<i class=" bx bx-pencil"></i>';
               $action.='</a></span>';
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
			   $address=trim($record['address1'] . ', ' . $record['address2'] . ', ' . $record['city'] . '<br>' . $record['region'] . ', ' . $record['country']);
			   if($record['address1']=='')
			   {
				   $address="None";
			   }
            
			  $data[] = array( 
				 "id"=>$i.'.',
				 "image"=>'',
				 "Name"=>trim($record['first_name'].' '.$record['last_name']),
				 "mobile"=>$mobile,
				 "email"=>$email,
				 "register"=>date("d-m-Y",strtotime($record['register_date'])),
				 "Status"=>$status,
				 "action"=>$action,
			  ); 
		
			  $i++;
       }
    }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );

       return $this->response->setJSON($response);

    }
	
	public function customerstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->UserModel->update_customer_status($status,$id); 
             
    }
	
	public function customers_edit($id)
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
		$userid=$id;
		$profile=$this->UserModel->getuserprofile($id);
		
        $data['profile']=$profile;
		$email=$profile['email'];
        $Newsletter= $this->UserModel->GetNewsletter($email);
		$data['newsletter']=false;
        if(isset($Newsletter))
        {
            $data['newsletter']=true; 
        }
		
		$LoyaltyPoints=$this->HomeModel->GetUserLoyaltyPoints($userid);
		$TotalLoyaltyPoints=$this->TotalLoyaltyPoints($userid);
		$data['TotalLoyaltyPoints']=$TotalLoyaltyPoints;
		$data['LoyaltyPoints']=$LoyaltyPoints;
		$allAddress= $this->HomeModel->address($userid);
        $data['useraddress']=$allAddress;
		$payments=$this->UserModel->getuserpayments($userid);
        $data['payments']=$payments;
		$orderStatus=$this->OrderModel->getorderStatus();
		$data['orderStatus'] = $orderStatus;
        $data['title']='Edit Customer';
        $data['page']='editcustomer';
        return view('Admin/admin_index',$data);
	}
	
	public function wishlistdetails()
    {
        if($this->request->getVar('userid'))
        {
           $userid=$this->request->getVar('userid');
           $wishlistdetails=$this->HomeModel->wishlistdetails($userid);
        
            $totalwishlistItem=0;
            if(isset($wishlistdetails) && count($wishlistdetails)>=1)
            {
                
                $totalwishlistItem=count($wishlistdetails);
              
                $data=array(
                        "success"=>true,
                        "totalwishlistItem"=>$totalwishlistItem,
                        "wishlistItems"=>$wishlistdetails,
                );
                    
                echo json_encode($data);
                return;
            }
            else
            {
                $data=array(
                    "success"=>false,
                    "totalwishlistItem"=>0,
                    "wishlistItems"=>0,
                );
                echo json_encode($data);
                return;
            }
        }   
        else
        {
            $data=array(
                    "success"=>false,
                    "totalwishlistItem"=>0,
                    "wishlistItems"=>'',
                );
            echo json_encode($data);
            return;
        }
    }
    
	
	public function TotalLoyaltyPoints($userid)
	{
			$totaladdpoints = $this->HomeModel->totaladdpoints($userid);
			
			$totalremovepoints = $this->HomeModel->totalremovepoints($userid);
			$TotalLoyaltyPoints=array(
				'totaladdpoints'=>$totaladdpoints['points'],
				'totalremovepoints'=>$totalremovepoints['points'],
				'totalpoints'=>$totaladdpoints['points']-$totalremovepoints['points']
			);
			return $TotalLoyaltyPoints;
        
	}
	
	public function customers_update($id)
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
            $userid=$id;
            
            $first_name = $this->request->getVar('first_name');
            $last_name = $this->request->getVar('last_name');
            $email = $this->request->getVar('email');
            $userEmail=$this->UserModel->CheckProfileEmail($email,$userid);
            if(isset($userEmail))
            {
                $data=[];
                $data['message'] = 'Email already registered.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
            $birth_month = $this->request->getVar('birth_month');
            $birth_day = $this->request->getVar('birth_day');
            $birth_year = $this->request->getVar('birth_year');
            if($birth_month!='' && $birth_day!='' && $birth_year!='')
            {
                $dob = $birth_day."-".$birth_month."-".$birth_year;
                $dob=date("Y-m-d",strtotime($dob));
            }
            else
            {
                $dob='';
            }  
            
            $anniversary_month = $this->request->getVar('anniversary_month');
            $anniversary_day = $this->request->getVar('anniversary_day');
            $anniversary_year = $this->request->getVar('anniversary_year');
            if($anniversary_month!='' && $anniversary_day!='' && $anniversary_year!='')
            {
                $anniversary = $anniversary_day."-".$anniversary_month."-".$anniversary_year;
                $anniversary=date("Y-m-d",strtotime($anniversary));
            }
            else
            {
                $anniversary='';
            }  
            $countryid = $this->request->getVar('country');
            $country = countryname($countryid);
            $regionid = $this->request->getVar('region');
            $region = regionname($regionid);
            $address1 = $this->request->getVar('address1');
            $additional_email = $this->request->getVar('additional_email');
            $address2 = $this->request->getVar('address2');
            $gender = $this->request->getVar('gender');
            $city = $this->request->getVar('city');
            $zip = $this->request->getVar('zip');
            $phone = $this->request->getVar('phone');
            $company_name = $this->request->getVar('company_name');
            if($this->request->getVar('newsletter'))
            {
                $NewsletterEmail=$email;
                $Newsletter= $this->UserModel->GetNewsletter($NewsletterEmail);
                if(!isset($Newsletter))
                {
                    $data=array(
                        'email'=>$NewsletterEmail
                    );
                    $this->UserModel->InsertNewsletter($data);  
                }
            }
            $account_detail=array(
                'first_name'=>$first_name,
                'last_name'=>$last_name,
                'email'=>$email,
                'phone'=>$phone,
                'dob'=>$dob,
                'anniversary'=>$anniversary,
                'gender'=>$gender,
                'countryid'=>$countryid,
                'country'=>$country,
                'regionid'=>$regionid,
                'region'=>$region,
                'address1'=>$address1,
                'additional_email'=>$additional_email,
                'address2'=>$address2,
                'city'=>$city,
                'zipcode'=>$zip,
                'company'=>$company_name
                );    
			
            $UserAccountUpdate=$this->UserModel->UserAccountUpdate($account_detail,$userid);
            if($UserAccountUpdate)
            {
				$userprofile=$this->UserModel->GetUserProfile($userid);
				 //loyalty points on  birthday
				 if($userprofile['dob']!='')
				 {
                    $type='birthday_loyalty_points';
                    $points=settings("birthday_loyalty_points");
					if($points>=1)
				    {
                      $this->Addloyaltypoints($type,$userid,$points);
					}
				 }
				 
				 //loyalty points on anniversary
				 if($userprofile['anniversary']!='')
				 {
                    $type='anniversary_loyalty_points';
                    $points=settings("anniversary_loyalty_points");
					if($points>=1)
				    {
                      $this->Addloyaltypoints($type,$userid,$points);
					}
				 }
				 
                $data=[];
                $data['message'] = 'Customer Detail successfully update.';
                $data['status'] = "success";
                echo json_encode($data);
                return;
            }   
            else
            {
                $data=[];
                $data['message'] = 'Something Wrong! Please Try again.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
	}
	
	public function Addloyaltypoints($type,$userid,$points)
    {
        $data=array(
            'userid'=>$userid,
            'points'=>$points,
            'type'=>$type,
            'created_at'=>date('Y-m-d H:i:s')
            );
		$chekloyaltypoints = $this->UserModel->chekloyaltypoints($userid,$type);
		if($chekloyaltypoints<1)
		{
			$this->UserModel->Insertloyaltypoints($data);    
		}
    }
    
	public function LoyaltyPoints()
    {
        if(!isset($this->session->admin))
        {
            //session check for admin login
           return redirect()->to('/admin/login'); 
        }
        $data=[];
		$data['customers']=$this->UserModel->customersDetail();
        $data['page']='loyalty_points';
        return view('Admin/admin_index',$data);
    }
	
	public function getLoyaltyPoints()
	{
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       //$columnIndex = $dtpostData['order'][0]['column']; // Column index
       //$columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       //$columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       // Custom filter
        $customer = $dtpostData['customer'];
        $daterange = $dtpostData['daterange'];
        $stratDate='';
        $endDate='';
        if(!empty($daterange))
        {
            $dateArr=explode("-",$daterange);
            $stratDate=date("Y-m-d",strtotime($dateArr[0]))." 00:00:00";
            $endDate=date("Y-m-d",strtotime($dateArr[1]))." 23:59:59";
        }
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('loyaltypoints')
                     ->select('id')
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('loyaltypoints');
                                $totalRecordwithFilter->select('id');
                                        if(!empty($customer))
                                        {
                                            $totalRecordwithFilter->where('userid', $customer);   
                                        }
                                        
                                         if(!empty($stratDate))
										{
											$totalRecordwithFilter->where('created_at >=', $stratDate);
										}
										if(!empty($endDate))
										{
											$totalRecordwithFilter->where('created_at <=', $endDate);
										}
                                $totalRecordwithFilter->Like('type', $searchValue);
        $totalRecordwithFilter = $totalRecordwithFilter->countAllResults();

       ## Fetch records
       $records =   $this->db->table('loyaltypoints');
                    $records->select('*');
                    $records->Like('type', $searchValue);
                                if(!empty($customer))
                                {
                                    $records->where('userid', $customer);   
                                }
                                if(!empty($stratDate))
                                {
                                    $records->where('created_at >=', $stratDate);
                                }
                                if(!empty($endDate))
                                {
                                    $records->where('created_at <=', $endDate);
                                }
                    $records->orderBy('created_at','DESC');
                    $records->limit($rowperpage, $start);
        $records =  $records->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $cusomerid=$record['userid'];
		   $customer=$this->UserModel->customerDetail($cusomerid);
               $action='';
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
            if($record['add_remove']=='add')
			{
				$DateAdded= date("d-m-Y",strtotime($record['created_at']));
			}
			else
			{
				$DateAdded= "-";
			}
			
			if($record['add_remove']=='remove')
			{
				$DateRemoved= date("d-m-Y",strtotime($record['created_at']));
			}
			else
			{
				$DateRemoved= "-";
			}
			$customername='';
			if($customer['first_name']!='')
			{
				$customername.=$customer['first_name'];
			}
			if($customer['last_name']!='')
			{
				$customername.=" ".$customer['last_name'];
			}
			
          $data[] = array( 
             "id"=>$i.'.', 
             "Customer"=>$customername,
             "Description"=>ucwords(str_replace("_"," ",$record['type'])),
             "DateAdded"=>$DateAdded,
             "DateRemoved"=>$DateRemoved,
             "AddRemove"=>ucwords($record['add_remove']),
             "Points"=>$record['points'],
             "action"=>$action,
          ); 
		  
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
	public function loyaltypointdelete()
	{
		if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->UserModel->loyaltypointdelete($id); 
	}
    
}
