//lab
    
    public function addlab()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['title']="Add Lab";
        $data['labs'] = $this->MasterModel->getlab();
        $data['language'] = $this->MasterModel->getlanguage();
        $data['page']='addlab';
        return view('Admin/admin_index',$data);
    }
    public function insert_lab()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('lab_language');
        $name_arr = $this->request->getVar('lab_name');
        $sort_order = $this->request->getVar('sort_order');
        
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $unserializeName = $this->lang_unserialize($serialized_name);
        $LabSlug=$this->lang_slug($unserializeName);
        $field='labid'; 
        $table='lab'; 
        $GetMaxIdData=$this->MasterModel->GetMaxId($table,$field);
       if($GetMaxIdData[$field]>=1)
       {
           $GetMaxId=$GetMaxIdData['labid']+1;
       }
       else
       {
           $GetMaxId=1;
       }
        $data=array(
            'labid'=>$GetMaxId,
            'name'=>$serialized_name,
            'slug'=>$LabSlug,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->insert_lab($data); 
        return redirect()->to('/admin/lab');
    }
    
    public function editlab($i)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $lab= $this->MasterModel->getlabID($i);

        if(isset($lab))
        {
            $data['title']="Edit Lab";
            $data['language'] = $this->MasterModel->getlanguage();
            $data['labs'] = $this->MasterModel->getlab();
            $data['lab']  = $lab;
            $data['page'] ='editlab';
            return view('Admin/admin_index',$data);
        }
        else
        {
             return redirect()->to('/admin/lab');  
        }
    }
    
    public function update_lab($id)
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        
        $language_arr = $this->request->getVar('lab_language');
        $name_arr = $this->request->getVar('lab_name');
        $sort_order = $this->request->getVar('sort_order');
        $serialized_name=$this->lang_serialize($language_arr,$name_arr);
        $data=array(
            'name'=>$serialized_name,
            'sequence'=>$sort_order,
            );
        
        $this->MasterModel->update_lab($data,$id); 
        return redirect()->to('/admin/lab');
    }
    
    public function lab()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
        $data=[];
        $data['lab'] = $this->MasterModel->getlab();
        $data['page']='lab';
        return view('Admin/admin_index',$data);
    }
    public function getlab()
    {
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
       $columnIndex = $dtpostData['order'][0]['column']; // Column index
       $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
       $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('lab')
                     ->select('id')
                     ->where('deleted_at', NULL)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('lab')
                                ->select('id')
                                ->where('deleted_at', NULL)
                                ->Like('name', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('lab')
            ->select('*')
            ->Like('name', $searchValue)
            ->where('deleted_at', NULL)
            ->orderBy($columnName,$columnSortOrder)
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
       $i=1;
       foreach($records as $record ){
           $lab_name=unserialize($record['name']);
           $lab=$lab_name['en'];
           $status='';
           if($record['Status']==1)
           {
              $checked='checked=""'; 
           }
           else
           {
               $checked=''; 
           }
                $status.='<div class="square-switch">';
                $status.='<input type="checkbox" class="status-checkbox" value="'.$record['id'].'" id="square-switch'.$record['id'].'" switch="bool" '.$checked.' >';
                $status.='<label for="square-switch'.$record['id'].'"  data-on-label="Yes" data-off-label="No"></label>';
                $status.='</div>';
                
               $action='';
               $action.='<span class="action-buttons">';
               
               $action.='<span title="Edit" class="edit-button">';
               $action.='<a href="'.base_url().'admin/editlab/'.$record['id'].'" data-id="'.$record['id'].' class="edit-record">';
               $action.='<i class="bx bx-pencil"></i>';
               $action.='</a></span>';
               
               $action.='<span title="Delete" class="delete-button" >';
               $action.='<a href="javascript:void(0)" data-id="'.$record['id'].'" class="delete-record">';
               $action.='<i class=" bx bx-trash"></i>';
               $action.='</a></span>';
               
               $action.='</span">';
               
               $date=date("d-m-Y H:i:s",strtotime($record['Date']));
               
          $data[] = array( 
             "id"=>$i,
             "labid"=>$record['labid'],
             "Lab"=>$lab,
             "sequence"=>$record['sequence'],
             "Status"=>$status,
             "date"=>$date,
             "action"=>$action,
          ); 
          
          $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    public function labstatus()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $status = $this->request->getVar('status');
             $id = $this->request->getVar('id');
             $this->MasterModel->update_lab_status($status,$id); 
             
    }
    
    public function labdelete()
    {
        if(!isset($this->session->admin))
        {
           return redirect()->to('/admin/login'); 
        }
             $id = $this->request->getVar('id');
            $this->MasterModel->lab_delete($id);  
    }
    