<?php
namespace App\Controllers;
use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
use App\Models\ApiModel;
use App\Models\HomeModel;
use App\Controllers\BaseController;
use App\Libraries\ExternalApiService; // Make sure this is at the top

class Api extends ResourceController
{
    use ResponseTrait;
    protected $apiService;
    public function __construct(){
       
          $this->HomeModel = new HomeModel(); 
         $this->apiService = new ExternalApiService();
    }
   

public function Token_generate()
{
  
    $token = $this->apiService->generateToken(); // Call the library function

    if ($token) {
        return $this->respond([
            'status' => 'success',
            'token'  => $token
        ]);
    } else {
        return $this->respond([
            'status' => 'failed',
            'message' => 'Unable to generate token'
        ], 400);
    }
}


    public function Productdetails($stockId){
    // Instance
        $token=$this->Token_generate();
        $apilink = $this->apiURL.'Productdetails?stockid='.$stockId;
        $client = \Config\Services::curlrequest();
            
            // Header data
            $headerData = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'Authorization' => 'Bearer '.$token
            );

            $response = $client->post($apilink,[
                'debug' => true,
                'headers'=> $headerData,
            ]);
         
       // Read response
        $code = $response->getStatusCode();
        $reason = $response->getReason();
        if($code == 200){ // Success

            // Read data 
            $body = $response->getBody();
            if(isset($body))
            {
                $datas=json_decode($body);
                if($datas->message=='Success')
                {
                     return $datas->data;
                     die;
                }
                else
                {
                    $response=array(
                    "success"=>false
                    );
                    $response=json_encode($response);    
                    return  $body = json_decode($response);
                    die;
                }

            }
            else
            {
                $response=array(
                "success"=>false
                );
                $response=json_encode($response);    
                return  $body = json_decode($response);
                die;
            }
          
        }else{
            $response=array(
                "success"=>false
                );
            $response=json_encode($response);    
            return  $body = json_decode($response);
            die;
        }
}


   public function Customerlist()
    {  
    
        $usersdata = $this->ApiModel->getusers();
        $responses = [];

        if (!empty($usersdata)) {
            foreach ($usersdata as $user) {
                $responses[] = [
                    "id"            => $this->clean($user, 'id'),
                    "Firstname"     => $this->clean($user, 'first_name'),
                    "Lastname"      => $this->clean($user, 'last_name'),
                    "Email"         => $this->clean($user, 'email'),
                    "Emailverify"   => $this->clean($user, 'email_verify'),
                    "Phonecode"     => $this->clean($user, 'phoneCode'),
                    "Phone"         => $this->clean($user, 'phone'),
                    "Dob"           => $this->clean($user, 'dob'),
                    "Gender"        => $this->clean($user, 'gender'),
                    "Address1"      => $this->clean($user, 'address1'),
                    "Address2"      => $this->clean($user, 'address2'),
                    "Zipcode"       => $this->clean($user, 'zipcode'),
                    "City"          => $this->clean($user, 'city'),
                    "Country"       => $this->clean($user, 'country'),
                    "Region"        => $this->clean($user, 'region'),
                    "Company"       => $this->clean($user, 'company'),
                    "Source"        => $this->clean($user, 'source'),
                    "Registerdate"  => $this->clean($user, 'register_date'),
                    "Apiflag"       => $this->clean($user, 'api_flag'),
                ];
            }

            return $this->respond([
                "success" => true,
                "message" => "Customer list retrieved successfully.",
                "data"    => $responses
            ], 200);
        } else {
            return $this->respond([
                "success" => false,
                "message" => "No customer data found.",
                "data"    => []
            ], 404);
        }
    }

 private function clean(array $array, string $key): string
    {
        return (isset($array[$key]) && $array[$key] !== null && strtolower((string)$array[$key]) !== 'null')
            ? (string) $array[$key]
            : '';
    }
    
 
    
   public function Customerdetails()
{
   
    $apiKeyHeader = $this->request->getHeaderLine('X-API-KEY');

   
    $validApiKey = getenv('STATIC_API_KEY') ?: 'your_static_api_key_here';

    
    if ($apiKeyHeader !== $validApiKey) {
        return $this->failUnauthorized('Invalid or missing API Key.');
    }

  
    $mobileNo = $this->request->getGet('mobile_no');
    if (!$mobileNo) {
        return $this->failValidationError('Mobile number is required.');
    }

    $customer = $this->HomeModel->GetUserByMobile($mobileNo);

    if (!$customer) {
        return $this->failNotFound('Customer not found.');
    }

    // Success response
    return $this->respond([
        'status' => true,
        'message' => 'Customer found.',
        'data' => $customer
    ]);
}

    

    
    public function SendOrderDetail($userid,$orderid,$txn_id)
    {
        
        $token=$this->Token_generate();
       
        $apilink = $this->apiURL.'Order';
        $client = \Config\Services::curlrequest();
        $shippingAddress=$this->ApiModel->getshippingAddress($userid,$orderid,$txn_id);
        $orderDetail=$this->ApiModel->getorderDetail($userid,$orderid,$txn_id);
        $shippingDetail=array(
            "add1"=> $shippingAddress['add1'],
            "add2"=> $shippingAddress['add1'],
            "city"=> $shippingAddress['city'],
            "zip"=> $shippingAddress['zip'],
            "countryid"=> $shippingAddress['countryid'],
            "countryname"=> $shippingAddress['countryname'],
            "regionid"=> $shippingAddress['regionid'],
            "regionname"=> $shippingAddress['regionname'],
            "mobile"=> $shippingAddress['mobile'],
            "phone"=> $shippingAddress['phone_code'],
            "contact"=> "",
            "emailid"=> $shippingAddress['emailid']
            );
        $postData = array(
                "customerid" => $userid,
                "transactionid" => $orderDetail['txn_id'],
                "amount" => $orderDetail['total_amount'],
                "shippingDetail" => $shippingDetail,
            );
            

        
         // Header data
    $headerData = array(
        'Content-Type' => 'application/json',
        'Accept' => 'application/json',
        'Authorization' => 'Bearer '.$token
    );
       
    $response = $client->post($apilink,[
        'debug' => true,
        'headers'=>$headerData,
        'json' => $postData
    ]);
    
    
         // Read response
        $code = $response->getStatusCode();
        $reason = $response->getReason();
           
        if($code == 200){ // Success

            // Read data 
            $body = json_decode($response->getBody());
            if(isset($body))
            {
                $datas=$body;
                if($datas->message=='Success')
                {
                     $data=$body->data;
                     $pdfstring=$data->pdfstring;
                     $masterID=$data->masterID;
                     $message=$body->message;
                     $updateOrderData=array(
                         'masterID'=>$masterID,
                         'pdfstring'=>$pdfstring,
                         'message'=>$message,
                         'status'=>"confirm"
                         );
                    $txn_Id=$orderDetail['txn_id'];     
                    $updateOrder=$this->ApiModel->updateOrder($updateOrderData,$txn_Id);
                }
                else
                {
                    $response=array(
                    "success"=>false
                    );
                    $response=json_encode($response);    
                    return  $body = json_decode($response);
                    die;
                }
            }
            else
            {
                    $response=array(
                    "success"=>false
                    );
                    $response=json_encode($response);    
                    return  $body = json_decode($response);
                    die;
            }
        }
        else
        {
            $response=array(
                "success"=>false
                );
            $response=json_encode($response);    
            return  $body = json_decode($response);
            die;
        }
    }
    
    
public function Invoicessummary($masterId='',$page=0,$count=0)
{
    // Instance
        $token=$this->Token_generate();
        $apilink = $this->apiURL.'Invoicessummary?masterid='.$masterId.'&page='.$page.'&count='.$count;
        $client = \Config\Services::curlrequest();
        
        $headerData = array(
                'Accept' => 'text/plain',
                'Authorization' => 'Bearer '.$token
            );
            // Send request
            $response = $client->get($apilink,[
                'debug' => true,
                'headers'=> $headerData,
            ]);

       // Read response
        $code = $response->getStatusCode();
        $reason = $response->getReason();
		
        if($code == 200){ // Success
            // Read data 
            $body = json_decode($response->getBody());
           if(isset($body))
            {
            return $body;
            }
            else
            {
                $response=array(
                "success"=>false
                );
                $response=json_encode($response);    
                return  $body = json_decode($response);
                die;
            }
          
        }else{
            $response=array(
                "success"=>false
                );
            $response=json_encode($response);    
            return  $body = json_decode($response);
            die;
        }
    }
    
    
      public function Updatecustomerimage($customerid,$data)
      {
        $token=$this->Token_generate();
        $apilink = $this->apiURL.'Uploadimage';
        $client = \Config\Services::curlrequest();
    
        $postData = array(
              "customerid" =>$customerid,
              "image" => $data,
            );
        
         // Header data
    $headerData = array(
        'Content-Type' => 'application/json',
        'Accept' => 'application/json',
        'Authorization' => 'Bearer '.$token
    );
       
          $response = $client->post($apilink,[
        'debug' => true,
        'headers'=>$headerData,
        'json' => $postData
    ]);
    
    
         // Read response
    $code = $response->getStatusCode();
    $reason = $response->getReason();
            
         if($code == 200){ // Success

            // Read data 
            $body = json_decode($response->getBody());
            if(isset($body))
            {
                return $body;
            }
            else
            {
               
                $response=array(
                "success"=>false
                );
                $response=json_encode($response);    
                return  $body = json_decode($response);
                die;
            }
          
        }else{
           
                $response=array(
                "success"=>false
                );
                $response=json_encode($response);    
                return  $body = json_decode($response);
                die;
        }
      }
      
    public function Search($Customerid,$q,$page,$count)
    {
        $token=$this->Token_generate();
        $apilink = $this->apiURL.'Search?q='.$q.'&customerid='.$Customerid.'&page='.$page.'&count='.$count;
        $client = \Config\Services::curlrequest();

        
         // Header data
    $headerData = array(
        'Content-Type' => 'text/plain',
        'Authorization' => 'Bearer '.$token
    );
       
          $response = $client->post($apilink,[
            'debug' => true,
            'headers'=>$headerData,
        ]);
    
    
         // Read response
    $code = $response->getStatusCode();
    $reason = $response->getReason();
            
         if($code == 200){ // Success

            // Read data 
            $body = json_decode($response->getBody());
            if(isset($body))
            {
                return $body;
            }
            else
            {
               
                $response=array(
                "success"=>false
                );
                $response=json_encode($response);    
                return  $body = json_decode($response);
                die;
            }
          
        }else{
           
                $response=array(
                "success"=>false
                );
                $response=json_encode($response);    
                return  $body = json_decode($response);
                die;
        }
    }
}