<?php
namespace App\Controllers;
use App\Models\HomeModel;
use App\Models\OrderModel;

use App\Controllers\BaseController;
use App\Libraries\ExternalApiService;
use Dompdf\Dompdf;
class Home extends BaseController
{    
    protected $apiService;
     public function __construct()
     {
          helper('site_helper');
        $this->session = \Config\Services::session(); 
        $this->HomeModel = new HomeModel(); 
        $this->OrderModel = new OrderModel(); 
        $this->checklogout();
        /* Load google oauth library */ 

        $this->apiService = new ExternalApiService();
          
    }
    public function SetLanguage()
    {
        $languge=$this->request->getVar('lang');
        $this->session->set('language',$languge);
        return true;
    }
    public function not_found()
    {
        $data=[];
        $data['title']='404 - Not Found';
        $data['page']='not_found';
        return view('index',$data);
    }
    
    public function checkLogin()
    {
        if(!isset($this->session->user))
        {
           $response=array(
             'status'=>false,
             'message'=>'Please login before checkout.'
          );
        }   
        else
        {
             $response=array(
             'status'=>true,
          );
        }
        echo json_encode($response);
    }
    public function GetRegion()
    {
            $countryid=$this->request->getVar('countryId');
            $GetRegion=region($countryid); 
            echo json_encode($GetRegion);
    }
    public function index(): string
    {
        if(isset($_GET['referral']))
        {
            $referralcode=$_GET['referral'];
            $checkreferralcode=$this->HomeModel->checkreferralcode($referralcode);
            if($checkreferralcode)
            {
                if(isset($this->session->user))
                {
                    $user=$user= $_SESSION['user'];
                    $userid=$user['id'];
                    if($userid!=$checkreferralcode['id'])
                    {
                        $this->session->set('referralcode',$_GET['referral']);
                    }
                }
                else
                {
                    $this->session->set('referralcode',$_GET['referral']);
                }
            }
        }
        
            $data=[];
            $data['page']='home';
            return view('index',$data);
    }
    public function faq()
    {
        $data=[];
        $data['faqs']=$this->HomeModel->Getfaqs();
        $data['meta_title']='';
        $data['meta_keyword']='';
        $data['meta_description']='';
        $data['title']='FAQs';
        $data['page']='faq';
        return view('index',$data);
    }
    
    
    public function book_an_appointment()
    {
        $data=[];
        $officeaddress= $this->HomeModel->Getofficeaddress();
        $data['officeaddress']=json_encode($officeaddress);
        $bookanappointment= $this->HomeModel->Getbookanappointment();
        $data['bookanappointment']=json_encode($bookanappointment);
        $data['meta_title']=$bookanappointment['meta_title'];
        $data['meta_keyword']=$bookanappointment['meta_keyword'];
        $data['meta_description']=$bookanappointment['meta_description'];
        $data['page']='book_an_appointment';
        return view('index',$data);
    }
    
    public function emailAssistance()
    {
        $name=$this->request->getVar('name');
        $email=$this->request->getVar('email');
        $phone=$this->request->getVar('phone');
        $comment=$this->request->getVar('comment');
        $data=array(
            'name'=>$name,
            'email'=>$email,
            'phone'=>$phone,
            'comment'=>$comment,
            );
         $this->HomeModel->InsertemailAssistance($data);
        $emailtemplate=emailtemplates('email-assistance-admin');
        $websettings=websettings();

         $token = array('SITE_URL' => base_url(''),
                        'SITE_TITLE' => $websettings['company_title'],
                        'USER_NAME' => trim($name),
                        'USER_EMAIL' => $email,
                        'USER_PHONE' => trim($phone),
                        'COMMENT'=> $comment,
                    );
         $to=settings('assistance_email');   
         //$to="carmotorofficial@gmail.com";
         $cc=$email;
         $this->send_email($emailtemplate,$token,$to,$cc);

         $response=array(
             'status'=>'success',
             'message'=>'Email Successfully sent to Assistance.'
         );
        echo json_encode($response); 
         
    }
    
    public function bookAppointment()
    {
        $name=$this->request->getVar('name');
        $email=$this->request->getVar('email');
        $phone=$this->request->getVar('phone');
        $product_codes=$this->request->getVar('product_codes');
        $office=$this->request->getVar('office');
        $appointment_date=$this->request->getVar('appointment_date');
        $comment=$this->request->getVar('comment');

        $data=array(
            'name'=>$name,
            'email'=>$email,
            'phone'=>$phone,
            'product'=>$product_codes,
            'officeid'=>$office,
            'appointment_date'=>$appointment_date,
            'comment'=>$comment,
            );
         $this->HomeModel->InsertbookAppointment($data);  
         
         //send email to admin end
         $office=$this->HomeModel->GetOfficeAddressdetail($office); 
         $emailtemplate=emailtemplates('appointment-booking-admin');
         $websettings=websettings();

         $token = array('SITE_URL' => base_url(''),
                        'SITE_TITLE' => $websettings['company_title'],
                        'APPOINTMENT_DATE' => $appointment_date,
                        'USER_NAME' => trim($name),
                        'USER_EMAIL' => $email,
                        'USER_PHONE' => "+".trim($phone),
                        'COMMENT'=> $comment,
                        'OFFICE'=>$office['title']
                    );
         $to=$websettings['comapny_email'];   
        
         $this->send_email($emailtemplate,$token,$to);

         //send email to admin end
         if($this->request->getVar('newsletter'))
        {
            $NewsletterEmail=$email;
            $Newsletter= $this->HomeModel->GetNewsletter($NewsletterEmail);
            if(!isset($Newsletter))
            {
                $data=array(
                    'email'=>$NewsletterEmail
                );
                $this->HomeModel->InsertNewsletter($data);  
            }
        }
         $response=array(
             'status'=>'success',
             'message'=>'Appointment Successfully Booked.'
         );
        echo json_encode($response);
         
    }
    public function GetHomeSliders()
    {
        if (($result = cache("HomeSliders")) == null ) // Check HomeSliders in Cache
        {
            $HomeSliders= $this->HomeModel->GetHomeSliders();
            if(isset($HomeSliders))
            {
                foreach($HomeSliders as $key=> &$HomeSlider)
                {
                    if(isset(unserialize($HomeSlider['slider_title'])[$_SESSION['language']]))
                    {
                        $HomeSlider['slider_title']=unserialize($HomeSlider['slider_title'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeSlider['slider_title']='';
                    }
                    
                    if(isset(unserialize($HomeSlider['button1_text'])[$_SESSION['language']]))
                    {
                        $HomeSlider['button1_text']=unserialize($HomeSlider['button2_text'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeSlider['button1_text']='';
                    }
                    
                    if(isset(unserialize($HomeSlider['button2_text'])[$_SESSION['language']]))
                    {
                        $HomeSlider['button2_text']=unserialize($HomeSlider['button2_text'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeSlider['button2_text']='';
                    }
                    
                    if(isset(unserialize($HomeSlider['slider_desc'])[$_SESSION['language']]))
                    {
                        $HomeSlider['slider_desc']=unserialize($HomeSlider['slider_desc'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeSlider['slider_desc']='';
                    }
                    
                }
                $data=array(
                        'status'=>'success',
                        'data'=>$HomeSliders
                        );
                echo $data=json_encode($data);
                cache()->save("HomeSliders", $data, 86400);
                return;        
        }
            else
            {
                 $data=array(
                    'status'=>false,
                    );
                echo json_encode($data);  
                return;
            }
        }
        else
        {
            echo $result;
            return;
        }
    }
    
    
    public function GetHomePartnerSlider()
    {
        if (($result = cache("HomePartnerSlider")) == null ) // Check HomePartnerSlider in Cache
        {
            $HomePartnerSlider= $this->HomeModel->GetHomePartnerSlider();
            if(isset($HomePartnerSlider))
            {
                foreach($HomePartnerSlider as $key=> &$PartnerSlider)
                {
                    if(isset(unserialize($PartnerSlider['title'])[$_SESSION['language']]))
                    {
                        $PartnerSlider['title']=unserialize($PartnerSlider['title'])[$_SESSION['language']];
                    }
                    else
                    {
                        $PartnerSlider['title']='';
                    }
            }
                $data=array(
                        'status'=>'success',
                        'data'=>$HomePartnerSlider
                        );
                
                echo $data=json_encode($data);
                cache()->save("HomePartnerSlider", $data, 86400);
                return;
            }
            else
            {
                 $data=array(
                    'status'=>false,
                    );
                echo json_encode($data);        
            }
        }
        else
        {
            echo $result;
            return;
        }
    
    }
    
    public function GetCustomerReviews()
    {
        if (($result = cache("HomeCustomerReviews")) == null ) // Check HomePartnerSlider in Cache
        {
            $HomeCustomerReviews= $this->HomeModel->GetHomeCustomerReviews();
            if(isset($HomeCustomerReviews))
            {
                $data=array(
                        'status'=>'success',
                        'data'=>$HomeCustomerReviews
                        );
                
                echo $data=json_encode($data);
                cache()->save("HomeCustomerReviews", $data, 86400);
                return;
            }
            else
            {
                 $data=array(
                    'status'=>false,
                    );
                echo json_encode($data);        
            }
        }
        else
        {
            echo $result;
            return;
        }
    }
    
    
    public function GetHomeCategories()
    {
        if (($result = cache("HomeCategories")) == null ) // Check HomeCategories in Cache
        {
        $category= $this->HomeModel->GetHomeCategories();
        
            if(isset($category))
            {
                $categorydata=array(
                    'status'=>'success'
                    );
                foreach($category as $row)
                {
                    $categoryName=unserialize($row['name']);
                    $data=array(
                        'categoryid'=>$row['categoryid'],
                        'categoryname'=>$categoryName[$_SESSION['language']],
                        'categoryslug'=>$row['slug'],
                        'categoryimage'=>$row['image'],
                        );
                    $categorydata['data'][]= $data;
                }
                echo $categorydata=json_encode($categorydata);
                cache()->save("HomeCategories", $categorydata, 86400);
                return;
            }
            else
            {
                 $data=array(
                    'status'=>'error'
                    );
                echo json_encode($data);
                return;
            }
        } 
        else
        {
            echo $result;
            return;
        }
    }
    
    public function GetHomeLooseDiamonds()
    {
        if (($result = cache("HomeLooseDiamonds")) == null ) // Check HomeLooseDiamonds in Cache
        {
            $LooseDiamonds= $this->HomeModel->GetHomeLooseDiamonds();
            if(isset($LooseDiamonds))
            {
                $LooseDiamonddata=array(
                    'status'=>'success'
                    );
                foreach($LooseDiamonds as $row)
                {
                    $LooseDiamondName=unserialize($row['name']);
                    $data=array(
                        'id'=>$row['colorid'],
                        'name'=>$LooseDiamondName[$_SESSION['language']],
                        'slug'=>$row['slug'],
                        'image'=>$row['diamond_color'],
                        );
                    $LooseDiamonddata['data'][]= $data;
                }
                $LooseDiamonddata=json_encode($LooseDiamonddata);
                cache()->save("HomeLooseDiamonds", $LooseDiamonddata, 86400);
                echo $LooseDiamonddata;
                return;

            }
            else
            {
                 $data=array(
                    'status'=>'error'
                    );
                echo json_encode($data);
                return;
            }
        } 
        else
        {
            echo $result;
            return;
        }
    
    }
    
    public function GetHomeLooseGemstones()
    {
        if (($result = cache("HomeLooseGemstones")) == null ) // Check HomeLooseGemstones in Cache
        {
            $LooseGemstones= $this->HomeModel->GetHomeLooseGemstones();
            if(isset($LooseGemstones))
            {
                $LooseGemstonedata=array(
                    'status'=>'success'
                    );
                foreach($LooseGemstones as $row)
                {
                    $LooseGemstoneName=unserialize($row['name']);
                    $data=array(
                        'id'=>$row['stoneid'],
                        'name'=>$LooseGemstoneName[$_SESSION['language']],
                        'slug'=>$row['slug'],
                        'image'=>$row['image'],
                        );
                    $LooseGemstonedata['data'][]= $data;
                }
                $LooseGemstonedata=json_encode($LooseGemstonedata);
                cache()->save("HomeLooseGemstones", $LooseGemstonedata, 86400);
                echo $LooseGemstonedata;
                return;
            
            }
            else
            {
                 $data=array(
                    'status'=>'error'
                    );
                echo json_encode($data);

            }
    
        }
        else
        {
            echo $result;
            return;
        }
    }
    public function GetHomeSection($id)
    {
        if (($result = cache("HomeBanners".$id)) == null ) // Check HomeLooseGemstones in Cache
        {
            $HomeBanners= $this->HomeModel->GetHomeBanners($id);
            if(isset($HomeBanners))
            {
                foreach($HomeBanners as $key=> &$HomeBanner)
                {
                    if(isset(unserialize($HomeBanner['banner_title'])[$_SESSION['language']]))
                    {
                        $HomeBanner['banner_title']=unserialize($HomeBanner['banner_title'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeBanner['banner_title']='';
                    }
                    
                    if(isset(unserialize($HomeBanner['button_text'])[$_SESSION['language']]))
                    {
                        $HomeBanner['button_text']=unserialize($HomeBanner['button_text'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeBanner['button_text']='';
                    }
                    
                    if(isset(unserialize($HomeBanner['banner_desc'])[$_SESSION['language']]))
                    {
                        $HomeBanner['banner_desc']=unserialize($HomeBanner['banner_desc'])[$_SESSION['language']];
                    }
                    else
                    {
                        $HomeBanner['banner_desc']='';
                    }
                }
                $data=array(
                        'status'=>'success',
                        'data'=>$HomeBanners
                        );
                $data=json_encode($data);
                cache()->save("HomeBanners".$id, $data, 86400);
                echo $data;
                return;       
                 
        }
            else
            {
                 $data=array(
                    'status'=>false,
                    );
                echo json_encode($data);        
            }
        }
        else
        {
            echo $result;
            return;
        }
    
    }
    
    public function search()
    {
        if($this->request->getVar('q'))
        {
            $q=trim($this->request->getVar('q'));
        }
        else
        {
            $q='';
        }
        if($this->request->getVar('view'))
        {
            $view=$this->request->getVar('view');
        }
        else
        {
            $view='';
        }
        $data=array(); 
        //$start=($page-1)*$rowperpage;
        $SearchProducts=json_decode($this->HomeModel->searchProducts($view,$q),true);
        
        $data['products']=$SearchProducts['products'];
        $data['totalProducts']=$SearchProducts['totalproducts'];
        $data['page']='search';
        return view('index',$data);
    }
    public function getSearchProducts()
    {
        if($this->request->getVar('q'))
        {
            $q=trim($this->request->getVar('q'));
        }
        else
        {
            $q='';
        }
        if($this->request->getVar('view'))
        {
            $view=$this->request->getVar('view');
        }
        else
        {
            $view='';
        }
        $rowperpage=20;
        $page=$this->request->getVar('page');
        $data=array(); 
        $start=($page-1)*$rowperpage;
        $SearchProducts=$this->HomeModel->searchProducts($view,$q,$start,$rowperpage);
        echo $SearchProducts;
    }
    
    public function GetProductSizeVariation()
    {
        if($this->request->getVar('productSlug') && $this->request->getVar('metalslug'))
        {
                 $productSlug=$this->request->getVar('productSlug');
                $metalSlug=$this->request->getVar('metalslug');
                $productvariations=$this->HomeModel->productvariationsSize($productSlug,$metalSlug);
                if(isset($productvariations) && count($productvariations)>=1)
                {
                $data=array(
                    'status'=>true,
                    'data'=>$productvariations,
                    );
                echo json_encode($data);   
                return;
                }
                else
                {
                    $data=array(
                        'status'=>false,
                        );
                    echo json_encode($data);   
                    return;
                }
                
        }
        else
        {
            $data=array(
                    'status'=>false,
                    );
                echo json_encode($data);   
                return;
        }
       
        
    }
    
    public function GetProductvariationdetail()
    {
        if($this->request->getVar('metalslug'))
        {
                
                $metalSlug=$this->request->getVar('metalslug');
                $Productvariationdetail=$this->HomeModel->GetProductvariationdetail($metalSlug);
                print_r($Productvariationdetail);die;
                if(isset($Productvariationdetail) && count($Productvariationdetail)>=1)
                {
                    $data=array(
                        'status'=>true,
                        'data'=>$Productvariationdetail,
                        );
                    echo json_encode($data);   
                    return;
                }
                else
                {
                    $data=array(
                        'status'=>false,
                        );
                    echo json_encode($data);   
                    return;
                }
                
        }
        else
        {
            $data=array(
                    'status'=>false,
                    );
                echo json_encode($data);   
                return;
        }
    }
	public function design_jewelry($slug,$category,$productSlug='')
	{
		$checkcategory=$this->HomeModel->checkcategoryDesign($category);
        if(isset($checkcategory) && count($checkcategory)>=1)
        {
			    $categoryName=unserialize($checkcategory['name']);
				$categoryId=$checkcategory['categoryid'];
				if(isset($categoryName[$_SESSION['language']]))
				{
					$categoryName=$categoryName[$_SESSION['language']];
				}
				else
				{
					$categoryName=$categoryName['en'];
				}
				
			if($slug=='start')
			{       $this->session->remove('setting_design'); 
					$this->session->remove('stone_design'); 		
					$data=[];
					$designproduct=$this->HomeModel->GetDesignProducts($categoryId);
					$data['designproducts']=$designproduct;
					$data['title']='Design Your Own '.$categoryName;
					$data['category']=$categoryName;
					$data['categoryData']=$checkcategory;
					$data['category_slug']=$category;
					$data['slug']=$slug;
					$data['page']='design_jewelry_start';
					return view('index',$data);
			}
			if($slug=='style')
			{                
					$data=[];
					
					$this->session->set('filterProductType','jewelry');
					$this->session->set('DesignfilterProductType','jewelry');
					$data['title']='Select Your Own '.$categoryName;
					$data['category']=$categoryName;
					$data['categoryData']=$checkcategory;
					$data['category_slug']=$category;
					$data['productSlug']=$productSlug;
					$data['slug']=$slug;
					$data['page']='design_jewelry';
					return view('index',$data);
			}
			if($slug=='stone')
			{                
					$data=[];
					$this->session->set('filterProductType','stone');
					$this->session->set('DesignfilterProductType','stone');
					$data['title']='Select Your Own Stone';
					$data['category']=$categoryName;
					$data['categoryData']=$checkcategory;
					$data['category_slug']=$category;
					$data['slug']=$slug;
					$data['page']='design_stone';
					return view('index',$data);
			}
		}
		else
		{
			return redirect()->to('not-found');
		}
	}
	
	public function final_design()
	{
		if(!isset($this->session->setting_design) && !isset($this->session->stone_design))
		{
			$redirect='design-your-own-jewelry/final-design';
			return redirect()->to($redirect);
		}
		elseif(isset($this->session->setting_design) && !isset($this->session->stone_design))
		{
			$redirect='design-your-own-jewelry/stone/'.$_SESSION['setting_design']['category'];
			return redirect()->to($redirect);
		}
		elseif(!isset($this->session->setting_design) && isset($this->session->stone_design))
		{
			$redirect='design-your-own-jewelry/style/'.$_SESSION['stone_design']['category'];
			return redirect()->to($redirect);
		}
		else
		{
			$data=array();
			$productslug=$_SESSION['setting_design']['productslug'];
			$size_slug=$_SESSION['setting_design']['ringsize'];
			if($size_slug!='')
			{
				$sizeData=$this->HomeModel->GetSizeIds($size_slug);
				if(isset(unserialize($sizeData['name'])[$_SESSION['language']]))
				{
					$sizename=unserialize($sizeData['name'])[$_SESSION['language']];
				}
				else
				{
					$sizename=unserialize($sizeData['name'])['en'];
				}
				$data['ring_size']=$sizename;
			}
			else
			{
				$data['ring_size']='';
			}
			$metal_slug=$_SESSION['setting_design']['metal'];
			if($metal_slug!='')
			{
				$metalData=$this->HomeModel->GetMetalIds($metal_slug);
				if(isset(unserialize($metalData['name'])[$_SESSION['language']]))
				{
					$metalname=unserialize($metalData['name'])[$_SESSION['language']];
				}
				else
				{
					$metalname=unserialize($metalData['name'])['en'];
				}
				$data['product_metal']=$metalname;
			}
			else
			{
				$data['product_metal']='';
			}
			$stoneslug=$_SESSION['stone_design']['productslug'];
			$product=$this->HomeModel->ProductDetail($productslug);
			$stone=$this->HomeModel->ProductDetail($stoneslug);
			$data['product']=$product;
			$data['stone']=$stone;
			$data['category']=$_SESSION['setting_design']['category'];;
			$data['page']='final_design';
			return view('index',$data);
		}
	}
    
	public function getDesignProductDetails()
	{
		$productslug=$this->request->getVar('productslug');
		$category_slug=$this->request->getVar('category_slug');
		$slug=$this->request->getVar('slug');
		
		$data=array();
        $product=$this->HomeModel->ProductDetail($productslug);
        $productid=$product['id'];
        $product_code=$product['product_code'];
        $producttitle=$product['title'];
        $productImages=$this->HomeModel->productImages($productid,$product_code);
        $productothermetals=$this->HomeModel->productothermetals($productid,$product_code);
        $productstones=$this->HomeModel->productstones($productid,$product_code);
        $MoreCetificates=$this->HomeModel->MoreCetificates($productid,$product_code);
        $productvariations=$this->HomeModel->productvariations($productid,$product_code);
		$ringSizes=$this->HomeModel->GetSize();
		$metals=$this->HomeModel->GetMetal();
		$data['metals']=$metals;
		$data['ringSizes']=$ringSizes;
		$data['product']=$product;
		$data['productstones']=$productstones;
		$data['MoreCetificates']=$MoreCetificates;
		$data['productvariations']=$productvariations;
		$data['images']=$productImages;
		$data['page']='product';
		$data['productslug']=$productslug;
		$data['category_slug']=$category_slug;
		$data['slug']=$slug;
		$viewpage=view('design_product_details',$data);
		$data=array(
			'status'=>true,
			'page'=>$viewpage,
			);
		echo json_encode($data);   
		return;
	}
	
	public function CustomeDesign_AddtoCart()
	{
		if(!isset($this->session->setting_design) && !isset($this->session->stone_design))
		{
			$data=array(
					'status'=>false,
					'message'=>'Please Select Stone.',
			);
			echo json_encode($data);   
			return;
		}
		elseif(isset($this->session->setting_design) && !isset($this->session->stone_design))
		{
			$data=array(
					'status'=>false,
					'message'=>'Please select jewelry setting.',
			);
			echo json_encode($data);   
			return;
		}
		elseif(!isset($this->session->setting_design) && isset($this->session->stone_design))
		{
			$data=array(
					'status'=>false,
					'message'=>'Not Authorizedy',
			);
			echo json_encode($data);   
			return;
		}
		else
		{
			if(isset($this->session->user))
			{
			   $user=$_SESSION['user'];
			   $userid=$user['id'];
			   $cartguestid=$userid;
			}   
			else
			{
				$userid=0;
				$cartguestid=$this->cartguestid();
			}
			
			if(isset($this->session->setting_design))
			{	
			   $productslug=$_SESSION['setting_design']['productslug'];
			   $product=$this->HomeModel->ProductDetail($productslug);
			   if($product)
			   {
					$productid=$product['id'];
					$size_slug=$_SESSION['setting_design']['ringsize'];
					if($size_slug!='')
					{
						$sizeData=$this->HomeModel->GetSizeIds($size_slug);
						if(isset(unserialize($sizeData['name'])[$_SESSION['language']]))
						{
							$sizename=unserialize($sizeData['name'])[$_SESSION['language']];
						}
						else
						{
							$sizename=unserialize($sizeData['name'])['en'];
						}
						
					}
					else
					{
						$sizename='';
					}
					$metal_slug=$_SESSION['setting_design']['metal'];
					if($metal_slug!='')
					{
						$metalData=$this->HomeModel->GetMetalIds($metal_slug);
						if(isset(unserialize($metalData['name'])[$_SESSION['language']]))
						{
							$metalname=unserialize($metalData['name'])[$_SESSION['language']];
						}
						else
						{
							$metalname=unserialize($metalData['name'])['en'];
						}
					}
					else
					{
						$metalname='';
					}
					
					$variationid=0;
					  $cartdatainsert=array(
						'productid'=>$productid,
						'userid'=>$userid,
						'cartguestid'=>$cartguestid,
						'variationid'=>$variationid,
						'metalname'=>$metalname,
						'sizename'=>$sizename,
						'designtype'=>'setting',
						'designid'=>$_SESSION['setting_design']['designid']
					   );
					   
						   $cartdatainsert['create_date']=date('Y-m-d H:i:s');
						   $cartdatainsert['cartqty']=1;
						   $Addtocart=$this->HomeModel->Addtocart($cartdatainsert);
					                 
			   }
			   else
			   {
					$data=array(
						"success"=>false,
						"msg"=>'Product not found add to cart.'
						);
					echo json_encode($data);
					return;
			   }
			}
			if(isset($this->session->stone_design))
			{	
			   $productslug=$_SESSION['stone_design']['productslug'];
			   $product=$this->HomeModel->ProductDetail($productslug);
			   if($product)
			   {
					$productid=$product['id'];
					$sizename='';
				    $metalname='';
					
					$variationid=0;
					  $cartdatainsert=array(
						'productid'=>$productid,
						'userid'=>$userid,
						'cartguestid'=>$cartguestid,
						'variationid'=>$variationid,
						'metalname'=>$metalname,
						'sizename'=>$sizename,
						'designtype'=>'stone',
						'designid'=>$_SESSION['stone_design']['designid']
					   );
					   
						   $cartdatainsert['create_date']=date('Y-m-d H:i:s');
						   $cartdatainsert['cartqty']=1;
						   $Addtocart=$this->HomeModel->Addtocart($cartdatainsert);
					                   
			   }
			   else
			   {
					$data=array(
						"success"=>false,
						"msg"=>'Product not found add to cart.'
						);
					echo json_encode($data);
					return;
			   }
			}			
			$this->session->remove('setting_design');
			$this->session->remove('stone_design');
			$data=array(
				"success"=>true,
				"msg"=>'Your Design Successfully add to cart.'
				);
			echo json_encode($data);
			return;
		}
	}
	
	public function SetDesignSetting()
	{
		$productslug=$this->request->getVar('productslug');
		$category_slug=$this->request->getVar('category_slug');
		$slug=$this->request->getVar('slug');
		if($slug=='style')
		{
			$checkcategory=$this->HomeModel->checkcategoryDesign($category_slug);
			if(isset($checkcategory) && count($checkcategory)>=1)
			{
				$product=$this->HomeModel->ProductDetail($productslug);
				if(isset($product) && count($product)>=1)
				{
					$setting_ring_size=$this->request->getVar('setting_ring_size');
					$setting_metal=$this->request->getVar('setting_metal');
					if($category_slug=='rings' && $setting_ring_size=='')
					{
						$data=array(
							'status'=>false,
							'message'=>'This Select Ring Size for design Setting.',
						);
						echo json_encode($data);   
						return;
					}
					if($setting_metal=='')
					{
						$data=array(
							'status'=>false,
							'message'=>'This Select Metal for design Setting.',
						);
						echo json_encode($data);   
						return;
					}					
					
						if(isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$Sessionno='';
							$designid=$_SESSION['stone_design']['designid'];
						}
						elseif(isset($this->session->setting_design) && !isset($this->session->stone_design))
						{
							$Sessionno='first';
							$designid=strtoupper(RandomString($length=12));
						}
						elseif(!isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$Sessionno='secound';
							$designid=$_SESSION['stone_design']['designid'];
						}
						else
						{
							$Sessionno='first';
							$designid=strtoupper(RandomString($length=12));
						}
						$SettingdesignData=array(
							'productslug'=>$productslug,
							'category'=>$category_slug,
							'type'=>'style',
							'ringsize'=>$setting_ring_size,
							'metal'=>$setting_metal,
						);
						if($Sessionno!='')
						{
							$SettingdesignData['sessionno']=$Sessionno;
						}
						$SettingdesignData['designid']=$designid;
						$this->session->remove('setting_design');
					    $this->session->set('setting_design',$SettingdesignData);
						
						if(isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$redirect=base_url().'design-your-own-jewelry/final-design';
						}
						elseif(isset($this->session->setting_design) && !isset($this->session->stone_design))
						{
							$redirect=base_url().'design-your-own-jewelry/stone/'.$category_slug;
						}
						elseif(!isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$redirect=base_url().'design-your-own-jewelry/style/'.$category_slug;
						}
						
						$data=array(
							'status'=>true,
							'message'=>'Design Setting Successfully select.',
							'redirect'=>$redirect,
							'setting_design'=>$_SESSION['setting_design']
						);
						echo json_encode($data);   
						return;
				}
				else
				{
					$data=array(
						'status'=>false,
						'message'=>'This Product Not Valid for design.',
					);
					echo json_encode($data);   
					return;
					
				}
			}
			else
			{
				$data=array(
					'status'=>false,
					'message'=>'This Category Not Valid for design.',
				);
				echo json_encode($data);   
				return;
			}
			
		}
		if($slug=='stone')
		{
			
				$product=$this->HomeModel->ProductDetail($productslug);
				if(isset($product) && count($product)>=1)
				{
						if(isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$Sessionno='';
							$designid=$_SESSION['setting_design']['designid'];
						}
						elseif(isset($this->session->setting_design) && !isset($this->session->stone_design))
						{
							$Sessionno='secound';
							$designid=$_SESSION['setting_design']['designid'];
							
						}
						elseif(!isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$Sessionno='first';
							$designid=strtoupper(RandomString($length=12).'design');
						}
						else
						{
							$Sessionno='first';
							$designid=strtoupper(RandomString($length=12).'design');
						}
						$SettingdesignData=array(
							'productslug'=>$productslug,
							'category'=>$category_slug,
							'type'=>'stone',
							'ringsize'=>'',
							'metal'=>'',
						);
						if($Sessionno!='')
						{
							$SettingdesignData['sessionno']=$Sessionno;
						}
						$SettingdesignData['designid']=$designid;
						$this->session->remove('stone_design');
					    $this->session->set('stone_design',$SettingdesignData);
						
						if(isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$redirect=base_url().'design-your-own-jewelry/final-design';
						}
						elseif(isset($this->session->setting_design) && !isset($this->session->stone_design))
						{
							$redirect=base_url().'design-your-own-jewelry/stone/'.$category_slug;
						}
						elseif(!isset($this->session->setting_design) && isset($this->session->stone_design))
						{
							$redirect=base_url().'design-your-own-jewelry/style/'.$category_slug;
						}
						
						$data=array(
							'status'=>true,
							'message'=>'Design Stone Successfully select.',
							'redirect'=>$redirect,
							'setting_design'=>$_SESSION['stone_design']
						);
						echo json_encode($data);   
						return;
				}
				else
				{
					$data=array(
						'status'=>false,
						'message'=>'This Product Not Valid for design.',
					);
					echo json_encode($data);   
					return;
					
				}			
		}
		else
		{
			$data=array(
				'status'=>false,
				'message'=>'Something Wrong.Please try again.',
			);
			echo json_encode($data);   
			return;
		
		}

	}
   
	public function productVisit($productid, $product_code, $slug, $short_description, $title, $thumbnail, $cost_price, $tag_price, $sale_price, $producttype)
	{
	     if(!empty($_SERVER['HTTP_CLIENT_IP']))
	     {
        //ip from share internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
        }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            //ip pass from proxy
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }else{
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        $currentdate=date('Y-m-d H:i:s');
        if(isset($this->session->user))
        {
           $user=$user= $_SESSION['user'];
           $userid=$user['id'];
        }
        else
        {
            $userid=0;
        }
        $visitdata=array(
            'productid'=>$productid,
            'productcode'=>$product_code,
            'slug'=>$slug,
            'short_description'=>$short_description,
            'title'=>$title,
            'thumbnail'=>$thumbnail,
            'cost_price'=>$cost_price,
            'tag_price'=>$tag_price,
            'sale_price'=>$sale_price,
            'producttype'=>$producttype,
            'userid'=>$userid,
            'ip'=>$ip,
            'visit_date'=>$currentdate,
            );
       
        $visit=$this->HomeModel->ProductVisitInsert($visitdata);
        if($visit)
        {
        $totalvisit=$this->HomeModel->ProductVisitDetail($productid,$product_code);
        $this->HomeModel->ProductVisitUpdate($productid,$product_code,$totalvisit);
        }
            
	}
	
    public function shop($menuslug,$productslug='')
     {
       if (!empty($menuslug) && !empty($productslug)) {
    
    // Try to get data from cache
        $data = cache($productslug);

    if ($data === null) {
        $product = $this->HomeModel->ProductDetailCode($productslug);

        if (!$product) {
            // Product not found
            return view('index', [
                'title' => '404 - Not Found',
                'page'  => 'not_found',
            ]);
        }

        // Product found
        $productid    = $product['id'];
        $product_code = $product['product_code'];
        $slug = $product['slug'];
        $short_description = $product['short_description'];
         $title = $product['title'];
          $thumbnail = $product['thumbnail'];
           $cost_price = $product['cost_price'];
            $tag_price = $product['tag_price'];
             $sale_price = $product['sale_price'];
             $producttype = $product['producttype'];
        $this->productVisit($productid, $product_code, $slug, $short_description, $title,  $thumbnail, $cost_price, $tag_price, $sale_price, $producttype);

        // Wishlist logic
        $wishlist = '';
        if (isset($this->session->user)) {
            $user   = $_SESSION['user'];
            $userid = $user['id'];

            if ($this->HomeModel->GetWishlistexist($productid, $userid) >= 1) {
                $wishlist = 'yes';
            }
        }

        $producttitle = $product['title'];

        $data = [
            'ogimage'           => settings('product_thumbnail_url') . $product['thumbnail'],
            'ogtitle'           => $producttitle,
            'wishlist'          => $wishlist,
            'product'           => $product,
            'productstones'     => $product['stone_details'],
            'MoreCetificates'   => [], // You can load actual certificate data here
            'productvariations' => $product['productVariation'],
            'images'            => $product['images'],
            'page'              => 'product',
            'menuslug'          => $menuslug,
            'productslug'       => $productslug,
            'meta_title'        => $producttitle,
            'meta_keyword'      => $producttitle,
            'meta_description'  => $product['short_description'],
            'breadcrumbs'       => $this->productbreadcrumbs($menuslug, $productslug, $producttitle),
            'stones'          =>$this->HomeModel->GetHomeLooseGemstones(),
            'metals'          =>$this->HomeModel->GetMetal(),
            'colors'          =>$this->HomeModel->GetfancycolorValue(),
            'claritys'          =>$this->HomeModel->GetclarityValue(),
             
        ];

        // Save to cache
        //cache()->save($productslug, $data, 3600); // cache for 1 hour
    }

    // Show product page
    return view('index', $data);
}
        elseif(!empty($menuslug) && empty($productslug))
        {
            $uri=$menuslug;
            $pageresult =  $this->db->table('pages_management')
                                    ->where('page_slug', $uri)
                            	    ->get()->getRowArray();
            
            if(isset($pageresult))
            {
                $page_data['page_detail'] = $pageresult;
                $page_data['page'] = "page_view";
                $page_data['title'] = $pageresult['page_name']; 
                $page_data['ogimage']=base_url().$pageresult['page_banner'];
                $page_data['ogtitle']=$pageresult['page_name'];
                $page_data['meta_title'] = $pageresult['meta_title'];
                $page_data['meta_keyword'] = $pageresult['meta_keyword'];   
                $page_data['meta_description'] = $pageresult['meta_description'];   
                return view('index',$page_data);
            }
         
            $data=array();
            
            $ShopProducts=json_decode($this->GetShopProducts($menuslug),'true');
          
            if(isset($ShopProducts['redirect']))
            {
               
                $pageuri=$ShopProducts['redirect'];
                if($pageuri=='not-found')
                {
                    $data=[];
                    $data['title']='404 - Not Found';
                    $data['page']='not_found';
                    return view('index',$data);
                }
               // else
               // {
                    $pageresult =  $this->db->table('pages_management')
                               ->where('page_slug', $pageuri)
                        	   ->get()->getRowArray();
                    if(isset($pageresult))
                    {
                        $page_data['page_detail'] = $pageresult;
                        $page_data['page'] = "page_view";
                        $page_data['ogimage']=base_url().$pageresult['page_banner'];
                        $page_data['ogtitle']=$pageresult['page_name'];
                        $page_data['title'] = $pageresult['page_name']; 
                        $page_data['meta_title'] = $pageresult['meta_title'];
                        $page_data['meta_keyword'] = $pageresult['meta_keyword'];   
                        $page_data['meta_description'] = $pageresult['meta_description'];   
                        return view('index',$page_data);
                     }
                //} 
            }
            
           
          
            $data['products']=$ShopProducts['products'];
            $data['totalProducts']=$ShopProducts['totalproducts'];
            if (($breadcrumbs = cache($menuslug.'_breadcrumbs')) == null ) // Check  Cache exist or not
            {
                $breadcrumbs=$this->breadcrumbs($menuslug);
                if($ShopProducts['totalproducts']>=1)
                {
                cache()->save($menuslug.'_breadcrumbs', $breadcrumbs, 3600);
                }
            }
            
            $data['breadcrumbs']=$breadcrumbs;
            $breadcrumbsArr=json_decode($breadcrumbs, true);
            if(isset($breadcrumbsArr[count($breadcrumbsArr)]['image']))
            {
            $data['ogimage']=$breadcrumbsArr[count($breadcrumbsArr)]['image'];
            }
            else
            {
                $data['ogimage']='';
            }
            
            $websettings=websettings();
            if(isset($breadcrumbsArr[count($breadcrumbsArr)]['name']))
            {
                $data['ogtitle']=$breadcrumbsArr[count($breadcrumbsArr)]['name'].' | '.$websettings['tagline'];
                $data['meta_title'] = $breadcrumbsArr[count($breadcrumbsArr)]['name'].' | '.$websettings['tagline'];
                
                $data['shopPageTitle']=$breadcrumbsArr[count($breadcrumbsArr)]['name'];
                if($breadcrumbsArr[count($breadcrumbsArr)]['detail']!='')
                {
                    $data['shopPageDetails']=$breadcrumbsArr[count($breadcrumbsArr)]['detail'];
                    $data['meta_description'] = $breadcrumbsArr[count($breadcrumbsArr)]['detail'];

                }
                else
                {
                    $data['shopPageDetails']=$websettings['default_page_description'];
                    $data['meta_description'] = $websettings['meta_description'];
                }
             
            }
            else
            {
                $data['meta_title'] = $websettings['meta_title'];
            }
            
            $data['meta_keyword'] = $websettings['meta_keyword'];  
            
           
            $data['menuslug']=$menuslug;
            
            $data['page']='shop';
            return view('index',$data);
        }
        else
        {
            $data=[];
            $data['title']='404 - Not Found';
            $data['page']='not_found';
            return view('index',$data);
        }
    }
    
    
    public function GetShopProducts($menuslug='',$page=1)
    {
        if(isset($_GET) && count($_GET)>=1)
        {
            $filters=$_GET;
        }
        else
        {
            $filters=array();
        }
        
        
        $start=0; 
        $rowperpage=16;
        if(empty($menuslug))
        {
            if($this->request->getVar('slug'))
            {
                $menuslug=trim($this->request->getVar('slug'),'/');
                $page=$this->request->getVar('page');
            }
            else
            {
                return false;
            }
        }
        
        if($this->request->getVar('page'))
        {
            $page=$this->request->getVar('page');
        }
        //print_r($filters);
                
            if (($filterData = cache($menuslug.'_menufilter')) == null ) // Check  Cache exist or not
            {
                $filterData=$this->menufilter($menuslug);
              
            }
            
            
            if(isset($filterData['redirect']))
            {
                    $data=array(
                        'status'=>false,
                        'redirect'=>$filterData['redirect'],
                    );              
                    return json_encode($data,true);  
            }
            elseif(isset($filterData['filterProductType']))
            {
                $this->session->set('filterProductType',$filterData['filterProductType']);
            }
            else
            {
                    $data=array(
                        'status'=>false,
                        'redirect'=>'not-found',
                    );              
                    return json_encode($data,true);  
            }
			
            
           
            
        if($page<=1)
        {
            
               $rowperpage=18;
          
        }
        else
        {
            $start=($page-1)*$rowperpage;
        }

        if(isset($_GET) && count($_GET)>=1)
        {
                $productShop=$this->HomeModel->productShop($filterData,$menuslug,$start,$rowperpage,$filters);
                
               
                return json_encode($productShop,true);
        }
        else
        {
            
             //echo $menuslug; die;
                /* API Tiara */ 
               
                $productShop=$this->HomeModel->productShop($filterData,$menuslug,$start,$rowperpage,$filters);
                 //print_r($productShop);die;
               
                return json_encode($productShop,true);
           die;
        }
    }
    
    public function menufilter($menuslug,$data=array())
    {
         if (($filterData = cache($menuslug.'_menufilter')) == null ) // Check  Cache exist or not
            {
                $shoppage=true;
                $menuslugArray=explode("-",$menuslug);
                $menuslug1='';
                $menuslug2='';
                foreach($menuslugArray as $menuslugRow)
                {
                 if($menuslugRow=='diamonds' || $menuslugRow=='diamond' || $menuslugRow=='gemstones' || $menuslugRow=='gemstone' || $menuslugRow=='jewelry')
                 {
                     $menuslug2=trim($menuslugRow,'s');
                 }
                 else
                 {
                     $menuslug1.=$menuslugRow.'-';
                 }
                }
                $menuslug1=trim($menuslug1,'-');
                $checkcategoryShop=$this->HomeModel->checkcategoryShop($menuslug);
                
                $checkstoneShop=$this->HomeModel->checkstoneShop($menuslug1);
                $checkcolorShop=$this->HomeModel->checkcolorShop($menuslug1);
               
                if(isset($checkcategoryShop) && count($checkcategoryShop)>=1)
                {
                    $categoryid=$checkcategoryShop['categoryid'];
                    $filterData['categoryid']=$categoryid;
                    $categoryName=unserialize($checkcategoryShop['name']);
                    $data['shopPageTitle']=$categoryName[$_SESSION['language']];
                    $filterData['filterProductType']='jewelry';
                }
                elseif(isset($checkstoneShop) && count($checkstoneShop)>=1)
                {
                    $stoneid=$checkstoneShop['stoneid'];
                    $filterData['stoneid']=$stoneid;
                    $stoneName=unserialize($checkstoneShop['name']);
                    $data['shopPageTitle']=$stoneName[$_SESSION['language']];
                    if(isset($menuslugArray[1]))
                    {
                    $filterData['filterProductType']=trim($menuslug2,'s');
                     $filterData['all-product']=trim($menuslug2,'s');
                    }
                    else
                    {
                    $filterData["all-product"]='gemstone';
                    $filterData['filterProductType']='gemstone';
                    }
                }
                elseif(isset($checkcolorShop) && count($checkcolorShop)>=1)
                {
                    $colorid=$checkcolorShop['colorid'];
                    $filterData['colorid']=$colorid;
                    $colorName=unserialize($checkcolorShop['name']);
                    $data['shopPageTitle']=$colorName[$_SESSION['language']];
                    if(isset($menuslugArray[1]))
                    {
                    $filterData['filterProductType']=trim($menuslug2,'s');
                     $filterData["all-product"]=trim($menuslug2,'s');
                    }
                    else
                    {
                    $filterData['filterProductType']='diamond';
                    $filterData["all-product"]='diamond';
                    }
                }
                else
                {
                    $checkMenuShop=$this->HomeModel->checkMenuShop($menuslug);
                    if(isset($checkMenuShop) && count($checkMenuShop)>=1)
                    {
                        if($checkMenuShop['menu-type']=='products')
                        {
                            $filterData['menufilter']=$checkMenuShop;
                            $shopPageTitle=unserialize($checkMenuShop['menu_title']);
                            $data['shopPageTitle']=$shopPageTitle[$_SESSION['language']];
                            if($filterData['menufilter']['category'])
                            {
                                $filterData['filterProductType']='jewelry';
                            }
                            elseif($filterData['menufilter']['all-product'])
                            {
                                $filterData['filterProductType']=$filterData['menufilter']['all-product'];
                            }
                            else
                            {
                               $filterData['filterProductType']='jewelry';
                            }
                            
                        }
                        elseif($checkMenuShop['menu-type']=='custom')
                        {
                            if($checkMenuShop['page']!='')
                            {
                                $filterData['redirect']=$checkMenuShop['page'];
                            }
                            else
                            {
                                 $filterData['redirect']='not-found';
                            }
                        }
                        else
                        {
                            $filterData['redirect']='not-found';
                        }
                    }
                    else
                    {
                            $menuslugArray=explode("-",$menuslug);
                            $shoppage=false;
                            $filterData["all-product"]='';
                            $filterData['filterProductType']='';
                            $filterData['menufilter']['stonetype']='';
                            $filterData['menufilter']["all-product"]='';
                            $filterData['menufilter']['collection']='';
                            $filterData['menufilter']['category']='';
                            $filterData['menufilter']['category-type']='';
                            $filterData['menufilter']['color']='';
                            $filterData['menufilter']['stonetype']='';
                            $filterData['menufilter']['stone']='';
                            $filterData['menufilter']['occasion']='';
                        if(count($menuslugArray)>=1)
                        {
                            if (false !== $key=array_search('white', $menuslugArray)) 
                            {
                                $filterData['menufilter']['stonetype']=$menuslugArray[$key];
                                // $filterData["all-product"]="diamond";
                                // $filterData['menufilter']["all-product"]="diamond";
                                // $filterData['filterProductType']="diamond";
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('fancy', $menuslugArray)) 
                            {
                                 $filterData['menufilter']['stonetype']=$menuslugArray[$key];
                                // $filterData["all-product"]="diamond";
                                // $filterData['menufilter']["all-product"]="diamond";
                                // $filterData['filterProductType']="diamond";
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('gemstone', $menuslugArray)) 
                            {
                                $filterData['menufilter']['stonetype']=$menuslugArray[$key];
                                $filterData["all-product"]="diamond";
                                $filterData['menufilter']["all-product"]="diamond";
                                $filterData['filterProductType']="diamond";
                                $shoppage=true;
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('color', $menuslugArray)) 
                            {
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('collection', $menuslugArray)) 
                            {
                                $shoppage=true;
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('collections', $menuslugArray)) 
                            {
                                $shoppage=true;
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('occasion', $menuslugArray)) 
                            {
                                $shoppage=true;
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('occasions', $menuslugArray)) 
                            {
                                $shoppage=true;
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('diamonds', $menuslugArray)) 
                            {
                                $shoppage=true;
                                $filterData["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['menufilter']["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['filterProductType']=trim($menuslugArray[$key],'s');
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('diamond', $menuslugArray)) 
                            {
                                $shoppage=true;
                                $filterData["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['menufilter']["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['filterProductType']=trim($menuslugArray[$key],'s');
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('gemstones', $menuslugArray)) 
                            {
                                $shoppage=true;
                                $filterData["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['menufilter']["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['filterProductType']=trim($menuslugArray[$key],'s');
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('gemstone', $menuslugArray)) 
                            {
                                $shoppage=true;
                                $filterData["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['menufilter']["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['filterProductType']=trim($menuslugArray[$key],'s');
                                unset($menuslugArray[$key]);
                            }
                            if (false !== $key=array_search('jewelry', $menuslugArray)) 
                            {
                                $shoppage=true;
                                $filterData["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['menufilter']["all-product"]=trim($menuslugArray[$key],'s');
                                $filterData['filterProductType']=trim($menuslugArray[$key],'s');
                                unset($menuslugArray[$key]);
                            }
							if (false !== $key=array_search('stone', $menuslugArray)) 
                            {
                                $shoppage=true;
                                $filterData["all-product"]=trim($menuslugArray[$key]);
                                $filterData['menufilter']["all-product"]=trim($menuslugArray[$key]);
                                $filterData['filterProductType']=trim($menuslugArray[$key]);
                                unset($menuslugArray[$key]);
                            }
							
                              if($shoppage==false)
                              {
                                  $filterData['redirect']='not-found';
                              }
                               $masterslug=implode("-",$menuslugArray);
                               if(!empty($masterslug))
                               {
                                   
                                   $filterData['menufilter']['color']=$masterslug;
                                    $filterData['menufilter']['collection']=$masterslug;
                                    $filterData['menufilter']['category']=$masterslug;
                                    $filterData['menufilter']['category-type']=$masterslug;
                                    $filterData['menufilter']['color']=$masterslug;
                                    $filterData['menufilter']['stone']=$masterslug;
                                    $filterData['menufilter']['occasion']=$masterslug;
                               }
                                // print_r($filterData);
                                // die;
                            }
                            
                    }
                   
                }
                if($shoppage=true)
                {
                cache()->save($menuslug.'_menufilter', $filterData, 600);
                }
            }
        return $filterData;    
    }
    
    public function breadcrumbs($menuslug)
    {
                $breadcrumbData=array();
                 
                if($menuslug=='diamonds' || $menuslug=='diamond' || $menuslug=='gemstones' || $menuslug=='gemstone' || $menuslug=='jewelry')
                {
                    $breadcrumbData[1]['name']=$menuslug;
                    $breadcrumbData[1]['image']='';
                    $breadcrumbData[1]['link']=base_url().$menuslug;
                    $checkMenuShop=$this->HomeModel->checkMenuShop($menuslug);
                    if(isset($checkMenuShop))
                    {
                        if(count($checkMenuShop)>=1)
                        {
                                $breadcrumbData[1]['detail']=$checkMenuShop['description'];
                        }
                    }
                    else
                    {
                        $checkcategoryShop=$this->HomeModel->checkcategoryShop($menuslug);
                        if(isset($checkcategoryShop) && count($checkcategoryShop)>=1)
                        {
                            $categoryName=unserialize($checkcategoryShop['name']);
                            $breadcrumbData[1]['detail']=$categoryName[$_SESSION['language']];
                        }
                        else
                        {
                            $websettings=websettings();
                            $breadcrumbData[1]['detail']=$websettings['default_page_description'];
                        }
                    }
                    return json_encode($breadcrumbData);
                }
                else
                {
                    $breadcrumbData[1]['image']='';
                    $breadcrumbData[1]['name']=$_SESSION['filterProductType'];
                    $breadcrumbData[1]['link']=base_url().$_SESSION['filterProductType'];
                    $checkMenuShop=$this->HomeModel->checkMenuShop($menuslug);
                    if(isset($checkMenuShop))
                    {
                        if(count($checkMenuShop)>=1)
                        {
                            
                                $breadcrumbData[1]['detail']=$checkMenuShop['description'];
                            
                        }
                    }
                    else
                    {
                        $menuslugArray=explode("-",$menuslug);
                        $menuslug1='';
                        $menuslug2='';
                        foreach($menuslugArray as $menuslugRow)
                        {
                         if($menuslugRow=='diamonds' || $menuslugRow=='diamond' || $menuslugRow=='gemstones' || $menuslugRow=='gemstone' || $menuslugRow=='jewelry')
                         {
                             $menuslug2=trim($menuslugRow,'s');
                         }
                         else
                         {
                             $menuslug1.=$menuslugRow.'-';
                         }
                        }
                        $menuslug1=trim($menuslug1,'-');
                        
                        $checkstoneShop=$this->HomeModel->checkstoneShop($menuslug1);
                        $checkcategoryShop=$this->HomeModel->checkcategoryShop($menuslug);
                        if(isset($checkcategoryShop) && count($checkcategoryShop)>=1)
                        {
                            $categoryName=unserialize($checkcategoryShop['name']);
                            $breadcrumbData[1]['detail']=$categoryName[$_SESSION['language']];
                        }
                        elseif(isset($checkstoneShop) && count($checkstoneShop)>=1)
                        {
                            $stoneName=unserialize($checkstoneShop['name']);
                            $breadcrumbData[1]['detail']=$stoneName[$_SESSION['language']];
                        }
                        else
                        {
                            $websettings=websettings();
                            $breadcrumbData[1]['detail']=$websettings['default_page_description'];
                        }
                    }
                }
                $menuslugArray=explode("-",$menuslug);
                $menuslug1='';
                $menuslug2='';
                foreach($menuslugArray as $menuslugRow)
                {
                 if($menuslugRow=='diamonds' || $menuslugRow=='diamond' || $menuslugRow=='gemstones' || $menuslugRow=='gemstone' || $menuslugRow=='jewelry')
                 {
                     $menuslug2=trim($menuslugRow,'s');
                 }
                 else
                 {
                     $menuslug1.=$menuslugRow.'-';
                 }
                }
                $menuslug1=trim($menuslug1,'-');
                $checkcolorShop=$this->HomeModel->checkcolorShop($menuslug1);
                $checkstoneShop=$this->HomeModel->checkstoneShop($menuslug1);
                $checkcategoryShop=$this->HomeModel->checkcategoryShop($menuslug);
                if(isset($checkcategoryShop) && count($checkcategoryShop)>=1)
                {
                    if($checkcategoryShop['image']!='')
                    {
                        $breadcrumbData[2]['image']=base_url().$checkcategoryShop['image'];
                    }
                    else
                    {
                        $breadcrumbData[2]['image']=''; 
                    }
                    
                    $categoryName=unserialize($checkcategoryShop['name']);
                    $breadcrumbData[2]['name']=$categoryName[$_SESSION['language']];
                    $breadcrumbData[2]['link']=base_url().$checkcategoryShop['slug'];
                }
                elseif(isset($checkstoneShop) && count($checkstoneShop)>=1)
                {
                   if($checkstoneShop['image']!='')
                    {
                        $breadcrumbData[2]['image']=base_url().$checkstoneShop['image'];
                    }
                    else
                    {
                        $breadcrumbData[2]['image']=''; 
                    }
                    
                    $stoneName=unserialize($checkstoneShop['name']);
                    $breadcrumbData[2]['name']=$stoneName[$_SESSION['language']];
                    $breadcrumbData[2]['link']=base_url().$checkstoneShop['slug'];
                }
                elseif(isset($checkcolorShop) && count($checkcolorShop)>=1)
                {
                    if($checkcolorShop['diamond_color']!='')
                    {
                        $breadcrumbData[2]['image']=base_url().$checkcolorShop['diamond_color'];
                    }
                    else
                    {
                        $breadcrumbData[2]['image']=''; 
                    } 
                    
                    $colorName=unserialize($checkcolorShop['name']);
                    $breadcrumbData[2]['name']=$colorName[$_SESSION['language']];
                    $breadcrumbData[2]['link']=base_url().$checkcolorShop['slug'];
                }
                else
                {
                    $checkMenuShop=$this->HomeModel->checkMenuShop($menuslug);
                    
                    if(isset($checkMenuShop) && count($checkMenuShop)>=1)
                    {
                        if($checkMenuShop['menu-type']=='products')
                        {
                            $filterData['menufilter']=$checkMenuShop;
                            $shopPageTitle=unserialize($checkMenuShop['menu_title']);
                            if($checkMenuShop['image']!='')
                            {
                            $breadcrumbData[2]['image']=base_url().$checkMenuShop['image'];
                            }
                            else
                            {
                              $breadcrumbData[2]['image']='';  
                            }
                            $breadcrumbData[2]['name']=$shopPageTitle[$_SESSION['language']];
                            $breadcrumbData[2]['link']=base_url().$menuslug;
                        }
                        
                    }
                   
                }
                $checkMenuShop=$this->HomeModel->checkMenuShop($menuslug);
                    if(isset($checkMenuShop))
                    {
                        if(count($checkMenuShop)>=1)
                        {
                           
                                $breadcrumbData[2]['detail']=$checkMenuShop['description'];
                            
                        }
                    }
                    else
                    {
                        $checkcategoryShop=$this->HomeModel->checkcategoryShop($menuslug);
                        if(isset($checkcategoryShop) && count($checkcategoryShop)>=1)
                        {
                            $categoryName=unserialize($checkcategoryShop['name']);
                            $breadcrumbData[2]['detail']=$categoryName[$_SESSION['language']];
                        }
                        else
                        {
                            $websettings=websettings();
                            $breadcrumbData[2]['detail']=$websettings['default_page_description'];
                        }
                    }
                return json_encode($breadcrumbData);
    }
    
    public function productbreadcrumbs($menuslug,$productslug,$producttitle)
    {
                $breadcrumbData=array();
                $i=0;
                if($menuslug=='diamonds' || $menuslug=='diamond' || $menuslug=='gemstones' || $menuslug=='gemstone' || $menuslug=='jewelry')
                {
                    $i++;
                    $breadcrumbData[$i]['name']=$menuslug;
                    $breadcrumbData[$i]['detail']=$menuslug;
                    $breadcrumbData[$i]['link']=base_url().$menuslug;
                }
                else
                {
                    if(isset($_SESSION['filterProductType']))
                    {
                        $i++;
                    $breadcrumbData[$i]['name']=$_SESSION['filterProductType'];
                    $breadcrumbData[$i]['detail']=$_SESSION['filterProductType'];
                    $breadcrumbData[$i]['link']=base_url().$_SESSION['filterProductType'];
                    }
                }
                
                    $checkcategoryShop=$this->HomeModel->checkcategoryShop($menuslug);
                
                
                    $checkMenuShop=$this->HomeModel->checkMenuShop($menuslug);
                    if(isset($checkMenuShop))
                    {
                        if(count($checkMenuShop)>=1)
                        {
                            if($checkMenuShop['menu-type']=='products')
                            {
                                $i++;
                                $filterData['menufilter']=$checkMenuShop;
                                $shopPageTitle=unserialize($checkMenuShop['menu_title']);
                                $breadcrumbData[$i]['name']=$shopPageTitle[$_SESSION['language']];
                                $breadcrumbData[$i]['detail']=$checkMenuShop['description'];
                                $breadcrumbData[$i]['link']=base_url().$menuslug;
                            }
                        }
                    }
                    else
                    {
                        if(isset($checkcategoryShop) && count($checkcategoryShop)>=1)
                        {
                            $i++;
                            $categoryName=unserialize($checkcategoryShop['name']);
                            $breadcrumbData[$i]['name']=$categoryName[$_SESSION['language']];
                            $breadcrumbData[$i]['detail']=$categoryName[$_SESSION['language']];
                            $breadcrumbData[$i]['link']=base_url().$checkcategoryShop['slug'];
                        }
                    }
                 
                // $breadcrumbData[3]['name']=$producttitle;
                // $breadcrumbData[3]['link']=base_url().$menuslug.'/'.$productslug;
                return $breadcrumbData;
                
    }
    /*
    public function GetProductData()
    {
        $productjson = $this->request->getPost('productjson');

if (is_string($productjson)) {
    $products = json_decode($productjson, true);
} else {
    $products = $productjson;
}

if (!is_array($products)) {
    return $this->response->setJSON([
        'status' => false,
        'message' => 'Invalid product data'
    ])->setStatusCode(400);
}

        foreach($products as $productkey=> &$product)
        {
            
            $productId=$product['id'];
            $productCode=$product['product_code'];
            $table='products';
            $ProductPrices=$this->HomeModel->GetProductPrices($table,$productId,$productCode); 
            $product['prices']=$ProductPrices;
            
            $cartguestid=$this->cartguestid();
            $GetCartexist=$this->HomeModel->GetCartexist($productId,$productCode,$cartguestid); 
            if($GetCartexist>=1)
            {
                $product['cart']='yes';
            }
            else
            {
                $product['cart']='';
            }
            
            if(isset($this->session->user))
            {
                $user=$user= $_SESSION['user'];
                $userid=$user['id'];
                $GetWishlistexist=$this->HomeModel->GetWishlistexist($productId,$userid);
                if($GetWishlistexist>=1)
                {
                    $product['wishlist']='yes';
                }
                else
                {
                    $product['wishlist']='';
                }
            }
            else
            {
                $product['wishlist']='';
            }
            
            $table='productimage';
            $ProductThumbImages=$this->HomeModel->GetProductThumbImages($table,$productId,$productCode);
            if(isset($ProductThumbImages) && count($ProductThumbImages)>=1)
            {
                $product['images']=$ProductThumbImages;
                $product['imageStatus']=true;
            }
            else
            {
                $product['imageStatus']=false;
                $product['images']='';
            }
            
        }
        echo json_encode($products);
    }*/
    
    public function Getfiltershopproducts()
    {
        if($this->request->getVar('slug'))
        {
            $menuslug=trim($this->request->getVar('slug'),'/');
            if (($filterData = cache($menuslug.'_menufilter')) == null ) // Check  Cache exist or not
            {
                $filterData=$this->menufilter($menuslug);
            }
                $result=$this->HomeModel->shopProductSettings($filterData,$menuslug);
                
                $response=array(
                    'status'=>true,
                    'data'=>$result,
                    );  
                echo json_encode($response); 
           
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }
    
    public function GetRelatedProducts()
    {
        if($this->request->getVar('menuslug'))
        {
            $menuslug=trim($this->request->getVar('menuslug'),'/');
            $productslug=trim($this->request->getVar('productslug'),'/');
            if (($filterData = cache($menuslug.'_menufilter')) == null ) // Check  Cache exist or not
            {
                $filterData=$this->menufilter($menuslug);
            }
                $result=$this->HomeModel->getReletedProducts($filterData,$menuslug,$productslug);
                if(isset($result) && count($result)>=1)
                {
                    $response=array(
                        'status'=>true,
                        'data'=>$result,
                        );  
                    echo json_encode($response); 
                }
                else
                {
                    $response=array(
                        'status'=>false
                        );  
                    echo json_encode($response); 
                }
           
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }
    
    public function GetLastProducts()
    {
        if(!empty($_SERVER['HTTP_CLIENT_IP']))
	     {
        //ip from share internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
        }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            //ip pass from proxy
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }else{
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        $currentdate=date('Y-m-d H:i:s');
        if(isset($this->session->user))
        {
           $user=$user= $_SESSION['user'];
           $userid=$user['id'];
        }
        else
        {
            $userid=0;
        }
        $menuslug=trim($this->request->getVar('menuslug'),'/');
        $productslug=trim($this->request->getVar('productslug'),'/');
        $result=$this->HomeModel->getLastProducts($userid,$ip,$productslug);
        if(isset($result) && count($result)>=1)
        {
            $response=array(
                'status'=>true,
                'data'=>$result,
                );  
            echo json_encode($response); 
        }
        else
        {
            $response=array(
                'status'=>false
                );  
            echo json_encode($response); 
        }
    }
    
    public function GetProductReviews()
    {
        if($this->request->getVar('productslug'))
        {
            $productslug=trim($this->request->getVar('productslug'),'/');
            $product=$this->HomeModel->ProductDetail($productslug);
			if($product)
		    {
               $productid=$product['id'];
               $Reviewsproduct=$this->HomeModel->ProductReviewsDetail($productid);
               if($Reviewsproduct)
               {
                   $response=array(
                        'status'=>true,
                        'data'=>$Reviewsproduct
                        );  
                    echo json_encode($response); 
               }
               else
               {
                    $response=array(
                        'status'=>false
                    );  
                    echo json_encode($response); 
               }
		    }
		    else
		    {
		        $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
		    }
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }

    public function shopProductSettings()
    {
        if($this->request->getVar('slug'))
        {
            $menuslug=trim($this->request->getVar('slug'),'/');
            if (($filterData = cache($menuslug.'_menufilter')) == null ) // Check  Cache exist or not
            {
                $filterData=$this->menufilter($menuslug);
            }    
            if (($result = cache($menuslug.'_all_products')) == null ) // Check  Cache exist or not
            {
               
               // $result=$this->HomeModel->shopProductSettings($filterData,$menuslug);
  
                $filter=$this->GetProductFilters($filterData,$menuslug);
                /*if(count($result)>=1)
                {
                cache()->save($menuslug.'_all_products', $result, 600);
                }
                */
                $response=array(
                    'status'=>true,
                    
                    'filters'=>$filter,
                    );  
                echo json_encode($response); 
            } 
            else
            {
                $filter=$this->GetProductFilters($filterData,$menuslug);
                $response=array(
                    'status'=>true,
                   
                    'filters'=>$filter
                    );  
                echo json_encode($response); 
            }
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }
    
    public function shopProductFilters()
    {
        if($this->request->getVar('slug'))
        {
            $menuslug=trim($this->request->getVar('slug'),'/');
            if (($filterData = cache($menuslug.'_menufilter')) == null ) // Check  Cache exist or not
            {
                $filterData=$this->menufilter($menuslug);
            }    
            if($this->request->getVar('category'))
            {
                $category=$this->request->getVar('category');
                $filter=$this->GetProductFilters($filterData,$menuslug,$category);
            }
            else
            {
                $filter=$this->GetProductFilters($filterData,$menuslug);
            }
                
                $response=array(
                    'status'=>true,
                    'filters'=>$filter,
                    );  
                echo json_encode($response);
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }
    
    public function GetProductFilters($filterData,$menuslug,$category='')
    {
        // print_r($filterData);
        $filter=array();
        $filter['jewelrytype']= $this->GetjewelrytypeFilter($filterData,$menuslug);
        $filter['filtertype']= $this->GetCategorytypeFilter($filterData,$menuslug,$category);
        $filter['filterstonetype']= $this->Getfilterstonetype($filterData,$menuslug);
        $filter['filterstone']= $this->Getfilterstone($filterData,$menuslug);
        $filter['filtershape']= $this->Getfiltershape($filterData,$menuslug);
        $filter['filtermetal']= $this->Getfiltermetal($filterData,$menuslug);
        $filter['filterfancycolor']= $this->Getfilterfancycolor($filterData,$menuslug);
        $filter['filterintensity']= $this->Getfilterintensity($filterData,$menuslug);
        $filter['filterovertone']= $this->Getfilterovertone($filterData,$menuslug);
        $filter['filterclarity']= $this->Getfilterclarity($filterData,$menuslug);
        cache()->save("shopfilter".$_SESSION['filterProductType'], json_encode($filter), 86400);
        return $filter;
    }
    
    public function Getfilterclarity($filterData,$menuslug)
    {
        $filterView['filtername']='clarity';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='clarity';
        $filterView['values']='';
        if($_SESSION['filterProductType']!='jewelry')
        {
            $clarity=$this->HomeModel->GetclarityValue();
            if(isset($clarity) && count($clarity)>=1)
            {
                    $filterView['visible']=true;
                    foreach($clarity as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
    
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['checked']=false;
                        $filterView['data'][]=$dataValue;
                    }
        }
        }
        return $filterView;
    }
    public function Getfilterovertone($filterData,$menuslug)
    {
        $filterView['filtername']='overtone';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='overtone';
        $filterView['values']='';
        if($_SESSION['filterProductType']!='jewelry')
        {
            $overtone=$this->HomeModel->GetovertoneValue();
            if(isset($overtone) && count($overtone)>=1)
            {
                    $filterView['visible']=true;
                    foreach($overtone as $row)
                    {
                        if($row['overtone']!='' && $row['overtone']!='None')
                        {
                            $dataValue['value']=$row['overtone'];
                            $dataValue['slug']=str_replace(' ', '-', $row['overtone']);
                            $dataValue['checked']=false;
                            $filterView['data'][]=$dataValue;
                        }
                    }
            }
        }
        return $filterView;
    }
    public function Getfilterintensity($filterData,$menuslug)
    {
        $filterView['filtername']='intensity';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='intensity';
        $filterView['values']='';
        if($_SESSION['filterProductType']!='jewelry')
        {
            $intensity=$this->HomeModel->GetintensityValue();
            if(isset($intensity) && count($intensity)>=1)
            {
                    $filterView['visible']=true;
                    foreach($intensity as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
    
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['checked']=false;
                        $filterView['data'][]=$dataValue;
                    }
        }
        }
        return $filterView;
    }
    public function Getfilterfancycolor($filterData,$menuslug)
    {
        $filterView['filtername']='fancycolor';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='fancy color';
        $filterView['values']='';
        if($_SESSION['filterProductType']=='diamond')
        {
            $fancycolor=$this->HomeModel->GetfancycolordiamondValue();
            if(isset($fancycolor) && count($fancycolor)>=1)
            {
                    $filterView['visible']=true;
                    foreach($fancycolor as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['diamond_color']=$row['diamond_color'];
                        $dataValue['color']=$row['color'];
                        $dataValue['checked']=false;
                        if(isset($filterData['colorid']))
                        {
                            if($row['colorid']==$filterData['colorid'])
                            {
                                $dataValue['checked']=true;
                            }
                        }
                        if(isset($filterData['menufilter']['color']))
                        {
                            if($row['slug']==$filterData['menufilter']['color'])
                            {
                                $dataValue['checked']=true;
                            }
                        }
                        
                        
                        $filterView['data'][]=$dataValue;
                    }
            }
        }
        else
        {
            $fancycolor=$this->HomeModel->GetfancycolorValue();
            if(isset($fancycolor) && count($fancycolor)>=1)
            {
                    $filterView['visible']=true;
                    foreach($fancycolor as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['diamond_color']=$row['diamond_color'];
                        $dataValue['color']=$row['color'];
                        $dataValue['checked']=false;
                        if(isset($filterData['colorid']))
                        {
                            if($row['colorid']==$filterData['colorid'])
                            {
                                $dataValue['checked']=true;
                            }
                        }
                        if(isset($filterData['menufilter']['color']))
                        {
                            if($row['slug']==$filterData['menufilter']['color'])
                            {
                                $dataValue['checked']=true;
                            }
                        }
                        $filterView['data'][]=$dataValue;
                    }
            }
        
        }
        return $filterView;
    }
    public function GetjewelrytypeFilter($filterData,$menuslug)
    {

        $filterView['filtername']='jewelrytype';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='jewelry type';
        $filterView['values']='';
        if($_SESSION['filterProductType']=='jewelry' && (!isset($filterData['menufilter']['category'])  || (isset($filterData['menufilter']['category']) && empty($filterData['menufilter']['category']))))
        {
            if(!isset($filterData['categoryid']))
            {
            $jewelrytype=$this->HomeModel->GetjewelrytypeValue();
            if(isset($jewelrytype) && count($jewelrytype)>=1)
            {
                    $filterView['visible']=true;
                    foreach($jewelrytype as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
    
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['checked']=false;
                        if(isset($filterData['menufilter']['category']))
                        {
                            if($row['slug']==$filterData['menufilter']['category'])
                            {
                                $dataValue['checked']=true;
                            }
                            
                        }
                        
                        $filterView['data'][]=$dataValue;
                    }
            }
            }
        }
        return $filterView;
    }
    
    public function Getfiltermetal($filterData,$menuslug)
    {
        $filterView['filtername']='metal';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='Metal';
        $filterView['values']='';
        if($_SESSION['filterProductType']=='jewelry')
        {
            $metal=$this->HomeModel->GetmetalValue();
            if(isset($metal) && count($metal)>=1)
            {
                    $filterView['visible']=true;
                    foreach($metal as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
    
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['checked']=false;
                        $filterView['data'][]=$dataValue;
                    }
        }
        }
        return $filterView;
    }
    
    public function Getfiltershape($filterData,$menuslug)
    {
        $filterView['filtername']='shape';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='Shape';
        $filterView['values']='';
        
        $shape=$this->HomeModel->GetshapeValue();
        if(isset($shape) && count($shape)>=1)
        {
                $filterView['visible']=true;
                foreach($shape as $row)
                {
                    $Nameserialize=unserialize($row['name']);

                    $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                    $dataValue['slug']=$row['slug'];
                    $dataValue['checked']=false;
                    $filterView['data'][]=$dataValue;
                }
        }
        return $filterView;
    }
    
    public function Getfilterstone($filterData,$menuslug)
    {
        $filterView['filtername']='stone';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='Stone';
        $filterView['values']='';
        
        $stone=$this->HomeModel->GetstoneValue();
        if(isset($stone) && count($stone)>=1)
        {
                $filterView['visible']=true;
                foreach($stone as $row)
                {
                    $Nameserialize=unserialize($row['name']);

                    $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                    $dataValue['slug']=$row['slug'];
                    $dataValue['checked']=false;
                    if(isset($filterData['menufilter']['stone']))
                    {
                        if($row['slug']==$filterData['menufilter']['stone'])
                        {
                            $dataValue['checked']=true;
                        }
                    }
                    $filterView['data'][]=$dataValue;
                }
        }
        return $filterView;
    }
    
    public function Getfilterstonetype($filterData,$menuslug)
    {
        $filterView['filtername']='stonetype';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='Stone Type';
        $filterView['values']='';
        
        $stonetype=$this->HomeModel->GetstonetypeValue();
        if(isset($stonetype) && count($stonetype)>=1)
        {
                $filterView['visible']=true;
                foreach($stonetype as $row)
                {
                    $Nameserialize=unserialize($row['name']);

                    $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                    $dataValue['slug']=$row['slug'];
                    $dataValue['checked']=false;
                    if(isset($filterData['menufilter']['stonetype']))
                    {
                        if($row['slug']==$filterData['menufilter']['stonetype'])
                        {
                            $dataValue['checked']=true;
                        }
                        
                    }
                    $filterView['data'][]=$dataValue;
                }
        }
        return $filterView;
    }
    
    public function GetCategorytypeFilter($filterData,$menuslug,$category)
    {
        $filterView['filtername']='type';
        $filterView['link']=false;
        $filterView['multiselect']=true;
        $filterView['range']=false;
        $filterView['visible']=false;
        $filterView['name']='';
        $filterView['values']='';
        if($_SESSION['filterProductType']=='jewelry')
        {
            if(isset($filterData['categoryid']) && !empty($filterData['categoryid']))
            {
                $categoryid=$filterData['categoryid'];
                $category=$this->HomeModel->GetCategoryValue($categoryid);
                $categoryNameserialize=unserialize($category['name']);
                $categoryname=$categoryNameserialize[$_SESSION['language']];
                $filterView['name']=$categoryname.' Type';
                $categorytype=$this->HomeModel->GetCategorytypeValue($categoryid);
               
                if(isset($categorytype) && count($categorytype)>=1)
                {
                    $filterView['visible']=true;
                    foreach($categorytype as $row)
                    {
                        $Nameserialize=unserialize($row['name']);
                        $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                        $dataValue['slug']=$row['slug'];
                        $dataValue['checked']=false;
                        if(isset($filterData['menufilter']['category-type']))
                        {
                            if($row['slug']==$filterData['menufilter']['category-type'])
                            {
                                $dataValue['checked']=true;
                            }
                        }
                        $filterView['data'][]=$dataValue;
                    }
                }    
                
        }
            else
            {
                if($category)
                {
                    $categoryArrslug=explode(",",$category);
                    if(count($categoryArrslug)==1)
                    {
                        $categorySlug=$categoryArrslug[0];
                        $categoryShop=$this->HomeModel->checkcategoryShop($categorySlug);
                        if($categoryShop)
                        {
                            $categoryid=$categoryShop['categoryid'];
                            $category=$this->HomeModel->GetCategoryValue($categoryid);
                            $categoryNameserialize=unserialize($category['name']);
                            $categoryname=$categoryNameserialize[$_SESSION['language']];
                            $filterView['name']=$categoryname.' Type';
                            $categorytype=$this->HomeModel->GetCategorytypeValue($categoryid);
                            if(isset($categorytype) && count($categorytype)>=1)
                            {
                                $filterView['visible']=true;
                                foreach($categorytype as $row)
                                {
                                     
                                    $Nameserialize=unserialize($row['name']);
                
                                    $dataValue['value']=$Nameserialize[$_SESSION['language']];;
                                    $dataValue['slug']=$row['slug'];
                                    $dataValue['checked']=false;
                                    if(isset($filterData['menufilter']['category-type']))
                                    {
                                        if($row['slug']==$filterData['menufilter']['category-type'])
                                        {
                                            $dataValue['checked']=true;
                                        }
                                    }
                                    $filterView['data'][]=$dataValue;
                                }
                } 
                        }
                    }
                }
            }
        }
        return $filterView;
    }
    
    //set newsletter email

    public function SetNewsletterEmail()
    {
        $NewsletterEmail=$this->request->getVar('NewsletterEmail');
        $Newsletter= $this->HomeModel->GetNewsletter($NewsletterEmail);
        if(isset($Newsletter))
        {
            $dataReturn=array(
                'status'=>"exist"
            );
            echo json_encode($dataReturn);   
        }
        else
        {
            $data=array(
                'email'=>$NewsletterEmail
            );
            $this->HomeModel->InsertNewsletter($data);  
            $dataReturn=array(
                'status'=>"success"
                );
            echo json_encode($dataReturn);
        }
        
    }
    
    public function WishlistCommetSave()
    {
        if(isset($this->session->user))
        {
           $user=$user= $_SESSION['user'];
           $userid=$user['id'];
           $productcode=$this->request->getVar('productcode');
           $comment=$this->request->getVar('comment');
           $product=$this->HomeModel->ProductDetailCode($productcode);
           if($product)
           {
               $productid=$product['id'];
               $AddWishlistComment=$this->HomeModel->WishlistCommetSave($productid,$userid,$comment);
               if($AddWishlistComment)
               {
                   $data=array(
                        "success"=>true,
                        "msg"=>'Successfully add Comment in Wishlist.'
                        );
                    echo json_encode($data);
                    return;
               }
               else
               {
                   $data=array(
                        "success"=>false,
                        "msg"=>'Something Wrong.Please Try Again!'
                        );
                    echo json_encode($data);
                    return;
               }
           }
           else
           {
               $data=array(
                "success"=>false,
                "msg"=>'Product Not found for Wishlist.'
                );
            echo json_encode($data);
            return;
           }
           
        }
        else
        {
            $data=array(
                "success"=>false,
                "msg"=>"Please Login Before Add Comment To Wishlist."
            );
            echo json_encode($data);
            return;
        }
    }
    
    public function AddWishlist()
    {
        if(isset($this->session->user))
        {
           $user=$user= $_SESSION['user'];
           $userid=$user['id'];
           $productcode=$this->request->getVar('productcode');
           $product=$this->HomeModel->ProductDetailCode($productcode);
           if($product)
           {
               $productid=$product['id'];
                

                //  Check if wishlist already exists for this user and product
            $existing = $this->db->table('wishlist')
                ->where('userid', $userid)
                ->where('productid', $productid)
                ->get()
                ->getRow();

            if ($existing) {
                // Item already in wishlist
                echo json_encode([
                    "success" => false,
                    "msg" => "This wishlist item already exists."
                ]);
                return;
            }
                 $dataitem=array( 
            'productid'=>$productid,
            'userid'=>$userid,
            'product_slug'=>$product['slug'],
            'product_code'=>$product['product_code'],
            'product_title'=>$product['title'],
            'product_thumbnail'=>$product['thumbnail'],
            'producttype'=>'jewelry',
            'products_cost_price'=>$product['cost_price'],
            'products_tag_price'=>$product['tag_price'],
            'products_sale_price'=>$product['sale_price'],
            'create_date'=> date('Y-m-d H:i:s'),
            );
               $AddWishlist=$this->HomeModel->AddWishlist($dataitem);
               if($AddWishlist)
               {
                   $data=array(
                        "success"=>true,
                        "msg"=>'Successfully add in Wishlist.'
                        );
                    echo json_encode($data);
                    return;
               }
               else
               {
                   $data=array(
                        "success"=>false,
                        "msg"=>'Something Wrong.Please Try Again!'
                        );
                    echo json_encode($data);
                    return;
               }
           }
           else
           {
               $data=array(
                "success"=>false,
                "msg"=>'Product Not found for Wishlist.'
                );
            echo json_encode($data);
            return;
           }
           
        }
        else
        {
            $data=array(
                "success"=>false,
                "msg"=>"Please Login Before Add To Wishlist."
            );
            echo json_encode($data);
            return;
        }
    }
    
    public function RemoveWishlist()
    {
        if(isset($this->session->user))
        {
           $user=$user= $_SESSION['user'];
           $userid=$user['id'];
           $productcode=$this->request->getVar('productcode');
           $product=$this->HomeModel->ProductDetailCode($productcode);
           if($product)
           {
               $productid=$product['id'];
               $RemoveWishlist=$this->HomeModel->RemoveWishlist($productid,$userid);
               if($RemoveWishlist)
               {
                   $data=array(
                        "success"=>true,
                        "msg"=>'Successfully remove from Wishlist.'
                        );
                    echo json_encode($data);
                    return;
               }
               else
               {
                   $data=array(
                        "success"=>false,
                        "msg"=>'Something Wrong.Please Try Again!'
                        );
                    echo json_encode($data);
                    return;
               }
           }
           else
           {
               $data=array(
                    "success"=>false,
                    "msg"=>'Product Not found for Wishlist.'
                );
                echo json_encode($data);
                return;
           }
           
        }
        else
        {
            $data=array(
                "success"=>false,
                "msg"=>"Please Login Before Add To Wishlist."
            );
            echo json_encode($data);
        }
    }

    /**
 * Helper function to return JSON response
 */
private function jsonResponse($success, $msg)
{
    echo json_encode([
        'success' => $success,
        'msg' => $msg
    ]);
    return;
}
   public function AddtoCart()
{
    // Determine user or guest
    if (isset($this->session->user)) {
        $user = $_SESSION['user'];
        $userid = $user['id'];
        $cartguestid = $userid;
    } else {
        $userid = 0;
        $cartguestid = $this->cartguestid();
    }
      
    $request = json_decode(file_get_contents('php://input'), true);
    // Sanitize input
    $productcode = htmlspecialchars(trim($request['productcode']));
   
  
    // Get product details
    $product = $this->HomeModel->ProductDetailCode($productcode);
    //print_r($product); die;
    $stones = [];

    if (!$product) {
        return $this->jsonResponse(false, 'Product not found.');
    }
       if (isset($request['metalid']) && !empty($request['metalid'])) {
            $metalid = $request['metalid'];
            $metalname = $request['metalname'];
       }else{
             $metalname = $product['metalname'];
       }
    if (isset($request['stones']) && !empty($request['stones'])) {
    
        $metalamount = isset($request['metalamount']) ? floatval($request['metalamount']) : 0;
$findingamount = isset($request['findingamount']) ? floatval($request['findingamount']) : 0;
$settingamount = isset($request['settingamount']) ? floatval($request['settingamount']) : 0;
$labouramount = isset($request['labouramount']) ? floatval($request['labouramount']) : 0;
$extrametalamount = isset($request['extrametalamount']) ? floatval($request['extrametalamount']) : 0;
$overheadAmount = isset($request['overheadAmount']) ? floatval($request['overheadAmount']) : 0;
    
        $stones = $request['stones'];
    $totalStonePrice = 0;
   foreach ($stones as $stone) {
    $stonePrice = isset($stone['price']) ? floatval($stone['price']) : 0;

    if ($stone['weightunit'] == 'Cts') {
        $stonePrice = $stonePrice * floatval($stone['weight']);
    } elseif ($stone['weightunit'] == 'Pcs') {
        $stonePrice = $stonePrice * floatval($stone['pcs']);
    }

    $totalStonePrice += $stonePrice;
}

    // Final cost price calculation

   
  $totalSalePrice = $metalamount + $findingamount + $settingamount + $labouramount + $extrametalamount + $overheadAmount + $totalStonePrice;

}elseif (isset($product['stone_details']) && is_array($product['stone_details']) && !empty($product['stone_details'])) {
    
        foreach ($product['stone_details'] as $stone) {
            $stones[] = [
                  'sskuid'   => $stone['sskuid'],
                  'stoneid'   => $stone['stoneid'],
                  'stonename'   => $stone['stonename'],
                  'stonecutid'  => $stone['stonecutid'],
                  'stonesizeid' => $stone['stonesizeid'],
                  'shapeid'     => $stone['shapeid'],
                  'qualityid'   => $stone['qualityid'],
                  'weight'      => $stone['weight'],
                  'weightunit'      => $stone['weightunit'],
                  'pcs'    =>     $stone['pcs'],
                  'price'    =>     $stone['price'],
                  'colorid'      => $stone['colorid']
                ];
        }
    $totalSalePrice=$product['sale_price'];
    }
     
   
     
    $productid = $product['id'];
     $product_slug = $product['slug'];
     $product_code = $product['product_code'];
     $product_title = $product['title'];
     $product_thumbnail = $product['thumbnail'];
     $products_cost_price = $product['cost_price'];
     $products_tag_price = $product['tag_price'];
     $products_sale_price = $totalSalePrice;
     $producttype = 'jewelry';
     $products_metalid = $metalid;
     $products_sizeid = $product['sizeid'];
     $products_gross_weight = $product['gross_weight'];
     $products_net_weight = $product['net_weight'];
     $products_weightunit = $product['weightunit'];
     $metalname = $metalname;
     $sizename = $product['sizename'];
     $product_slug = $product['slug'];
    $variationid = 0;
   
        
        if ($product['quantity'] < 1) {
         
        return $this->jsonResponse(false, 'This product is currently out of stock.');
        }
   
    // Prepare cart data
    $cartdatainsert = [
        'productid'    => $productid,
        'userid'       => $userid,
        'cartguestid'  => $cartguestid,
        'variationid'  => $variationid,
        'product_slug' => $product_slug,
        'product_code' => $product_code,
        'product_title' => $product_title,
        'product_thumbnail' => $product_thumbnail,
        'products_cost_price' => $products_cost_price,
        'products_tag_price' =>$products_tag_price,
        'products_sale_price' =>$products_sale_price,
        'producttype' =>$producttype,
        'products_metalid' =>$products_metalid,
        'products_sizeid' =>$products_sizeid,
        'products_gross_weight'=>$products_gross_weight,
        'products_net_weight' => $products_net_weight,
        'products_weightunit' =>$products_weightunit,
         'metalname'    => $metalname,
        'sizename'     => $sizename,
        'designid'     => '',
        'stonedetails'  => json_encode($stones)
    ];


    $datarecord = [
        'productid'    => $productid,
        'userid'       => $userid,
        'cartguestid'  => $cartguestid,
        'product_code' => $product_code,
        
    ];
    //print_r($cartdatainsert); die;
    
    // Check if item already exists in cart
    $existcart = $this->HomeModel->exist_record($datarecord, 'cart');

    if ($existcart >= 1) {
        
        return $this->jsonResponse(false, 'Item already exists in cart.');
    }

    // Add to cart
    $cartdatainsert['create_date'] = date('Y-m-d H:i:s');
    $cartdatainsert['cartqty'] = 1;

    $Addtocart = $this->HomeModel->Addtocart($cartdatainsert);
    
    if ($Addtocart) {
        return $this->jsonResponse(true, 'Item successfully added to cart.');
    } else {
        return $this->jsonResponse(false, 'Something went wrong. Please try again!');
    }
}
    
    public function cartupdate($cartguestid='')
    {
         if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
        }
        if($cartguestid=='')
        {
             $data=array(
                    "success"=>false,
                    "msg"=>'Something Wrong.Please Try Again!'
                    );
                echo json_encode($data);
                return;
        }

           $productcode=$this->request->getVar('code');
           $qty=$this->request->getVar('qty');
           $product=$this->HomeModel->ProductDetailCode($productcode);
           if($product)
           {
                  $productid=$product['id'];
                  $cartdataUpdate=array(
                    'cartqty'=>$qty,
                   );
            
                       $Updatetocart=$this->HomeModel->Updatetocart($cartdataUpdate,$productid,$cartguestid);
                       if($Updatetocart)
                       {
                           $data=array(
                                "success"=>true,
                                "msg"=>'Item quantity successfully update.',
                                );
                            echo json_encode($data);
                            return;
                        }
                       else
                       {
                           $data=array(
                                "success"=>false,
                                "msg"=>'Something Wrong.Please Try Again!'
                                );
                            echo json_encode($data);
                            return;
                        }   
               
           }
           else
           {
                $data=array(
                    "success"=>false,
                    "msg"=>'Item not found.'
                    );
                echo json_encode($data);
                return;
           }
    
    }
    
    public function productQty($cartguestid='')
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
        }
        if($cartguestid=='')
        {
            $data=array(
                    "success"=>false,
                );
            // echo json_encode($data);
            return;
        }
        $productcode=$this->request->getVar('code');
        $qty=$this->request->getVar('qty');
        $productQty=0;
        $product=$this->HomeModel->ProductDetailCode($productcode);
        if($product)
        {
               $productid=$product['id'];
               $productQtyData=$this->HomeModel->productQtyData($productid,$cartguestid);
               //print_r($productQtyData);
               if($productQtyData)
               {
                   if($productQtyData['variationid']>=1)
                   {
                       $productQty=$productQtyData['variation_quantity'];
                   }
                   else
                   {
                       $productQty=$productQtyData['products_quantity'];
                   }
                   if($productQty>=$qty)
                   {
                       $data=array(
                            "success"=>true,
                            );
                        echo json_encode($data);
                        return;
                   }
                   else
                   {
                       $data=array(
                            "success"=>false,
                            );
                        echo json_encode($data);
                        return;
                   }
               }
               else
               {
                    $data=array(
                        "success"=>false,
                        );
                    echo json_encode($data);
                    return;
               }
        }
        else
        {
                $data=array(
                        "success"=>false,
                        );
                echo json_encode($data);
                return;
        }
    }
    
    public function removetoCart($cartguestid='')
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
        }
        if($cartguestid=='')
        {
            $data=array(
                    "success"=>true,
                    "totalcartItem"=>0,
                );
            echo json_encode($data);
            return;
        }

           $productcode=$this->request->getVar('productcode');
           $product=$this->HomeModel->ProductDetailCode($productcode);
           if($product)
           {
               $productid=$product['id'];
			   $ProductCartCheck=$this->HomeModel->ProductCartCheck($productid,$cartguestid);
               if($ProductCartCheck)
			   {   
					if($ProductCartCheck['designid']!='')
					{
						$designid=$ProductCartCheck['designid'];
						$Removetocart=$this->HomeModel->RemovetocartDesign($designid,$cartguestid);
					}
					else
					{
						$Removetocart=$this->HomeModel->Removetocart($productid,$cartguestid);
					}
				   if($Removetocart)
				   {
					   $data=array(
							"success"=>true,
							"msg"=>'Item Successfully remove form cart.'
							);
						echo json_encode($data);
						return;
					}
					else
					{
					   $data=array(
							"success"=>false,
							"msg"=>'Something Wrong.Please Try Again!'
							);
						echo json_encode($data);
						return;
					}   
			 }
			 else
			 {
				 $data=array(
                    "success"=>false,
                    "msg"=>'Product not found in cart.'
                    );
                echo json_encode($data);
                return;
			 }
		   }
           else
           {
                $data=array(
                    "success"=>false,
                    "msg"=>'Product not found.'
                    );
                echo json_encode($data);
                return;
           }
        
    }
    
    public function totalcart($cartguestid='')
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
        }
        if($cartguestid=='')
        {
            $data=array(
                    "success"=>true,
                    "totalcartItem"=>0,
                );
            echo json_encode($data);
            return;
        }
        
                $this->cartnotexitremove($cartguestid);
                $totalcartItem=$this->HomeModel->totalcart($cartguestid);

                $data=array(
                        "success"=>true,
                        "totalcartItem"=>$totalcartItem,
                );
                    
                echo json_encode($data);
                return;
           
    }
    
    public function cartnotexitremove($cartguestid='')
    {
          if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
        }
        if($cartguestid=='')
        {
            return;
        }
        
            $cartdetails=$this->HomeModel->cartdetails($cartguestid);
        
            $totalcartItem=0;
            if(isset($cartdetails) && count($cartdetails)>=1)
            {
                foreach($cartdetails as $cartproduct)
                {
                    $productcode=$cartproduct['product_code'];
                    $productid=$cartproduct['productid'];
                   
                           $product=$this->HomeModel->ProductcartRemoveQty($productcode,$productid);
                           if($product)
                           {
                                if($product['quantity']<1)
                                {
                                    $this->HomeModel->RemoveCartProductOutofStock($productid);
                                    return;
                                }
                           }
                           else
                           {
                               $this->HomeModel->RemoveCartProductOutofStock($productid);
                                    return;
                           }
                      
                    
                }
               
            }
           
    }
    
    public function cartdetails($cartguestid='')
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
        }
        if($cartguestid=='')
        {
            $data=array(
                    "success"=>true,
                    "totalcartItem"=>0,
                    "cartItems"=>'',
                );
            echo json_encode($data);
            return;
        }
        
            $this->cartnotexitremove($cartguestid);
            $cartdetails=$this->HomeModel->cartdetails($cartguestid);
        
            $totalcartItem=0;
            if(isset($cartdetails) && count($cartdetails)>=1)
            {
                foreach($cartdetails as $cartproduct)
                {
                    $productcode=$cartproduct['product_code'];
                    $productid=$cartproduct['productid'];
                    $variationid=$cartproduct['variationid'];
                        if($variationid>=1)
                        {
                            $GetvariationCart=$this->HomeModel->ProductVariationDetail($productid,$variationid);
                            if(isset($GetvariationCart) && count($GetvariationCart)>=1)
                            {
                                if($GetvariationCart['variationquantity']<1)
                                {
                                   $this->HomeModel->RemoveCartProductVariationOutofStock($productid,$variationid);
                                    return;
                                }

                            }
                            else
                            {
                                $this->HomeModel->RemoveCartProductVariationOutofStock($productid,$variationid);
                                return;
                            }
                        }
                        else
                        {
                           $product=$this->HomeModel->ProductcartRemoveQty($productcode,$productid);
                           if($product)
                           {
                                if($product['quantity']<1)
                                {
                                    $this->HomeModel->RemoveCartProductOutofStock($productid);
                                    return;
                                }
                           }
                           else
                           {
                               $this->HomeModel->RemoveCartProductOutofStock($productid);
                                    return;
                           }
                        }
                    
                }
                $totalcartItem=count($cartdetails);
              
                $data=array(
                        "success"=>true,
                        "totalcartItem"=>$totalcartItem,
                        "cartItems"=>$cartdetails,
                );
                    
                echo json_encode($data);
                return;
            }
            else
            {
                $data=array(
                    "success"=>true,
                    "totalcartItem"=>0,
                    "cartItems"=>'',
                );
                echo json_encode($data);
                return;
            }
    }
    
    public function cart()
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $cartguestid=$userid;
        }   
        else
        {
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
            else
            {
                return redirect()->to('/');
            }
        }
        
            $data=[];
            $customerid=$cartguestid;
            $this->cartnotexitremove($cartguestid);
            $data['Customercartlist']=$this->HomeModel->cartdetails($customerid);
            $data['onlinebenefits']=$this->HomeModel->onlinebenefit();
            $data['title']='Cart';
            $data['page']='cart';
            return view('index',$data);
        
    }
    
    public function wishlist()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }   
        
            $data=[];
			$TotalLoyaltyPoints=$this->TotalLoyaltyPoints();
			$data['TotalLoyaltyPoints']=$TotalLoyaltyPoints;
            $data['title']='Wishlist';
            $data['page']='wishlist';
            return view('index',$data);
        
    }
    
    public function wishlistdetails($cartguestid='')
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $wishlistdetails=$this->HomeModel->wishlistdetails($userid);
        
            $totalwishlistItem=0;
            if(isset($wishlistdetails) && count($wishlistdetails)>=1)
            {
                
                $totalwishlistItem=count($wishlistdetails);
              
                $data=array(
                        "success"=>true,
                        "totalwishlistItem"=>$totalwishlistItem,
                        "wishlistItems"=>$wishlistdetails,
                );
                    
                echo json_encode($data);
                return;
            }
            else
            {
                $data=array(
                    "success"=>false,
                    "totalwishlistItem"=>0,
                    "wishlistItems"=>0,
                );
                echo json_encode($data);
                return;
            }
        }   
        else
        {
            $data=array(
                    "success"=>false,
                    "totalwishlistItem"=>0,
                    "wishlistItems"=>'',
                );
            echo json_encode($data);
            return;
        }
    }
    
    public function totalwishlist($cartguestid='')
    {
        if(isset($this->session->user))
        {
           $user=$_SESSION['user'];
           $userid=$user['id'];
           $totalwishlist=$this->HomeModel->totalwishlist($userid);
                $data=array(
                        "success"=>true,
                        "totalwishlistItem"=>$totalwishlist,
                );
                    
                echo json_encode($data);
                return;
        }   
        else
        {
            $data=array(
                    "success"=>true,
                    "totalwishlistItem"=>0,
                );
            echo json_encode($data);
            return;
        }
           
    }
    
    public function register()
    {
        if(isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
             $google_client = new \Google_Client();
              $GoogleClientId=settings("GoogleClientId");
              $GoogleClientSecret=settings("GoogleClientSecret");
              $redirectUrl=base_url().'google-auth';
              $google_client->setClientId($GoogleClientId); //Define your ClientID
    
              $google_client->setClientSecret($GoogleClientSecret); //Define your Client Secret Key
            
              $google_client->setRedirectUri($redirectUrl); //Define your Redirect Uri
            
              $google_client->addScope('email');
            
              $google_client->addScope('profile');

            $data=[];
              
            $data['googleLoginUrl']=$google_client->createAuthUrl();

            $data['banner']= $this->HomeModel->GetRegisterBanners();
            $data['title']='Register';
            $data['page']='register';
            return view('index',$data);
    }
    
   public function register_submit()
{
    if (isset($this->session->user)) {
        return redirect()->to('/');
    }

    // Load validation service
    $validation = \Config\Services::validation();

    // Define validation rules
    $validationRules = [
        'first_name' => 'required',
        'last_name'  => 'required',
        'email'      => 'required|valid_email|is_unique[users.email]',
        'mobile'     => 'required|numeric|is_unique[users.phone]', // Adjust table/column name if needed
        'password'   => 'required|min_length[6]'
    ];

    if (!$this->validate($validationRules)) {
        echo json_encode([
            'status'  => 'failed',
            'message' => $this->validator->getErrors()
        ]);
        return;
    }

    // Collect input values
    $first_name = $this->request->getVar('first_name');
    $last_name  = $this->request->getVar('last_name');
    $email      = $this->request->getVar('email');
    $mobile     = $this->request->getVar('mobile');
    $password   = $this->request->getVar('password');
    $month      = $this->request->getVar('month');
    $day        = $this->request->getVar('day');
    $year       = $this->request->getVar('year');

    // Format DOB
    if ($month !== '' && $day !== '' && $year !== '') {
        $dob = date("Y-m-d", strtotime("$day-$month-$year"));
    } else {
        $dob = '';
    }

    // Prepare other data
    $code = RandomString($length = 32);
    $plainpass = $password;
    $password = password_hash($password, PASSWORD_BCRYPT);

    $referralcode = substr($first_name, 0, 3) . RandomString(10) . date('dm');
    $userreferralcode = isset($this->session->referralcode) ? $_SESSION['referralcode'] : '';

    // Save user
    $data = [
        'first_name'       => $first_name,
        'last_name'        => $last_name,
        'email'            => $email,
        'phone'            => $mobile,
        'password'         => $password,
        'dob'              => $dob,
        'email_verify_code'=> $code,
        'referralcode'     => $referralcode,
        'referralcodeby'   => $userreferralcode,
        'register_date'    => date('Y-m-d H:i:s')
    ];

    $SaveUser = $this->HomeModel->SaveUser($data);

    if ($SaveUser) {
        // Send to external API
        $postData = [
            'firstname' => $first_name,
            'lastname'  => $last_name,
            'emailid'   => $email,
            'phone'     => $mobile,
            'registermobile'=>$mobile,
            'dob'       => $dob
        ];

        $apiresponse = $this->apiService->registerUser($postData);

        if (isset($apiresponse['success']) && $apiresponse['success'] === true) {
            $this->HomeModel->updateApiFlag($email);
        }

        // Handle newsletter subscription
        if ($this->request->getVar('newsletter')) {
            $NewsletterEmail = $email;
            $Newsletter = $this->HomeModel->GetNewsletter($NewsletterEmail);
            if (!isset($Newsletter)) {
                $this->HomeModel->InsertNewsletter(['email' => $NewsletterEmail]);
            }
        }

        // Send email verification
        $link = base_url() . "register-verify/" . $code;
        $emailtemplate = emailtemplates('verify-email-user');
        $websettings = websettings();
        $token = [
            'NAME'        => $first_name.' '.$last_name,
            'SITE_URL'    => base_url(''),
            'SITE_TITLE'  => $websettings['company_title'],
            'EMAIL'       => $email,
            'LINK'        => $link
        ];

        $this->send_email($emailtemplate, $token, $email);
          
       // --- Send registration notification to admin ---
$adminTemplate = emailtemplates('new-user-registered'); // template slug for admin email
$adminEmail = $websettings['comapny_email']; // make sure this exists in your settings

$adminToken = [
    'NAME'       => $first_name . ' ' . $last_name,
    'EMAIL'      => $email,
    'PHONE'      => $mobile,
    'SITE_TITLE' => $websettings['company_title'],
    'SITE_URL' =>base_url(''),
    'DATE'       => date('d-M-Y H:i:s')
];

$this->send_email($adminTemplate, $adminToken, $adminEmail); // to admin

        echo json_encode([
            'message' => "Please Verify Your Register Email For Login.",
            'status'  => "success"
        ]);
        return;

    } else {
        echo json_encode([
            'message' => 'Something went wrong. Please try again.',
            'status'  => "failed"
        ]);
        return;
    }
}

    
    public function register_verify($udid='')
    {
        if(isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        //echo $udid; die;
        if(!isset($udid) )
        {
          return redirect()->to('/not-found');   
        }
        else
        {
            $verify_email= $this->HomeModel->Verifycustomer($udid);
            if($verify_email)
            {
                //loyalty points on register
                $type='register_loyalty_points';
                $userid=$verify_email['id'];
                $points=settings("register_loyalty_points");
				if($points>=1)
				{
                $this->Addloyaltypoints($type,$userid,$points);
				}
                
                if($verify_email['referralcodeby']!='')
                {
                    //loyalty points on register referral
                    $referralcodeby=$verify_email['referralcodeby'];
                    $checkreferralcode=$this->HomeModel->checkreferralcode($referralcodeby);
                    if($checkreferralcode)
                    {
                        $type='register_loyalty_points';
                        $userid=$checkreferralcode['id'];
                        $points=settings("referral_loyalty_points");
						if($points>=1)
						{
                        $this->Addloyaltypoints($type,$userid,$points);
						}
                    }    
                }
				
				if($verify_email['dob']!='')
                {
                    //loyalty points on register birth day
                        $type='birthday_loyalty_points';
                        $userid=$verify_email['id'];
                        $points=settings("birthday_loyalty_points");
						if($points>=1)
						{
                        $this->Addloyaltypoints($type,$userid,$points);
						}
                       
                }
                
                $this->HomeModel->VerifycustomerUpdate($udid);
               
                // 5. Send confirmation email
            $emailtemplate = emailtemplates('email-verified-success'); // Create this template in DB
            $websettings = websettings();

            $token = [
                'NAME'        => $verify_email['first_name'] . ' ' . $verify_email['last_name'],
                'EMAIL'       => $verify_email['email'],
                'SITE_TITLE'  => $websettings['company_title'],
                'SITE_EMAIL'  => $websettings['comapny_email'],
                'SITE_URL'    => base_url(),
                'DATE'        => date('d-M-Y H:i:s')
            ];

            $this->send_email($emailtemplate, $token, $verify_email['email']);


                $data=[];
                $data['success_msg'] = "Email Successfully Verified ! Please Login.";
                $data['title']='Email Verify';
                $data['page']='email_verify';
                return view('index',$data);
            }
            else
            {
                return redirect()->to('/not-found'); 
            }
        }
    }
    
    public function send_email($emailtemplate,$token,$to,$cc=NULL, $from=NULL, $email_type=NULL, $redirect_url=NULL)
    {
        $pattern = '[%s]';
        foreach ($token as $key => $val)
        {
            $varMap[sprintf($pattern, $key) ] = $val;
        }       
        $emailContent = strtr($emailtemplate['body'], $varMap);
        $subject = $emailtemplate['subject'];
        default_smtp_mail($emailContent,$subject,$to,$cc);
    }
    
    public function my_account()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $data=[];
			$TotalLoyaltyPoints=$this->TotalLoyaltyPoints();
			$data['TotalLoyaltyPoints']=$TotalLoyaltyPoints;
            $data['title']='My Account';
            $data['page']='my_account';
            return view('index',$data);
    }
    
    public function address()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $user=$_SESSION['user'];
            $userid=$user['id']; 
            $data=[];
            $allAddress= $this->HomeModel->address($userid);
            $data['useraddress']=$allAddress;
            $data['title']='Address';
            $data['page']='address';
            return view('index',$data);
    }
    
    public function edit_address($addressid)
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $user=$_SESSION['user'];
            $userid=$user['id']; 
            $addressid=base64_decode($addressid);
            $data=[];
            $editAddress= $this->HomeModel->editaddress($addressid,$userid);
            if(!$editAddress)
            {
                return redirect()->to('/my-account/address'); 
            }
            $data['editAddress']=$editAddress;
            $data['title']='Edit Address';
            $data['page']='edit_address';
            return view('index',$data);
    }
    
    public function address_remove()
    {
        if(!isset($this->session->user))
        {
                $data=[];
                $data['message'] = 'Please Login';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
        }
        else
        {
            $user=$_SESSION['user'];
            $userid=$user['id']; 
            $addressid=$this->request->getVar('id');
            $addressid=base64_decode($addressid);
            $data=[];
            $deletAddress= $this->HomeModel->editaddress($addressid,$userid);
            if(!$deletAddress)
            {
                $data=[];
                $data['message'] = 'Address Not found for delete.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
            else
            {
                $address_detailData=$this->HomeModel->UserAddressRemove($userid,$addressid);
                if($address_detailData)
                {
                    $data=[];
                    $data['message'] = 'Address successfully remove.';
                    $data['status'] = "success";
                    echo json_encode($data);
                    return;
                }   
                else
                {
                    $data=[];
                    $data['message'] = 'Something Wrong! Please Try again.';
                    $data['status'] = "failed";
                    echo json_encode($data);
                    return;
                }
            }
        }    
    }
    
    public function edit_address_submit($addressid)
    {
        if(!isset($this->session->user))
        {
                $data=[];
                $data['message'] = 'Please Login';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
        }
        else
        {
            $user=$_SESSION['user'];
            $userid=$user['id']; 
            $addressid=base64_decode($addressid);
            $data=[];
            $editAddress= $this->HomeModel->editaddress($addressid,$userid);
            if(!$editAddress)
            {
                $data=[];
                $data['message'] = 'Address Not found for update.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
            
            $address = $this->request->getVar('address');
            $first_name = $this->request->getVar('first_name');
            $last_name = $this->request->getVar('last_name');
            $countryid = $this->request->getVar('country');
            $country = countryname($countryid);
            $regionid = $this->request->getVar('region');
            $region = regionname($regionid);
            $address1 = $this->request->getVar('address1');
            $address2 = $this->request->getVar('address2');
            $city = $this->request->getVar('city');
            $zip = $this->request->getVar('zip');
            $phone = $this->request->getVar('phone');
            $company_name = $this->request->getVar('company_name');
            $default = $this->request->getVar('default');
            $note = $this->request->getVar('note');
            $address_detail=array(
                'first_name'=>$first_name,
                'last_name'=>$last_name,
                'address1'=>$address1,
                'address2'=>$address2,
                'phone'=>$phone,
                'countryid'=>$countryid,
                'countryname'=>$country,
                'regionid'=>$regionid,
                'regionname'=>$region,
                'city'=>$city,
                'zipcode'=>$zip,
                'addresstype'=>$address,
                'company'=>$company_name,
                'note'=>$note,
                );  
            if($this->request->getVar('default'))
            {
                $address_detail['defaultaddress']='yes';
            }
            else
            {
                $address_detail['defaultaddress']='no';
            }
            $address_detailData=$this->HomeModel->UserAddressUpdate($address_detail,$userid,$addressid);
            if($address_detailData)
            {
              $profile=$this->HomeModel->GetUserProfile($userid);
                    $postData = [
            'shippingcode' => (string) $editAddress['shippingcode'],
            'registermobile'=>$profile['phone'],
            'firstname' => $first_name,
            'lastname'  => $last_name,
            'address1'   =>$address1,
            'address2'=>$address2,
            'mobileno'=>$phone,
            'email'=>$profile['email'],
            'country'=>$country,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zip,
            'company'=>$company_name,
        ];

        $apiresponse = $this->apiService->Add_address($postData);

        if (isset($apiresponse['success']) && $apiresponse['success'] === true) {
            $this->HomeModel->updateaddressApiFlag($addressid);
        }


                $data=[];
                $data['message'] = 'Address successfully update.';
                $data['status'] = "success";
                echo json_encode($data);
                return;
            }   
            else
            {
                $data=[];
                $data['message'] = 'Something Wrong! Please Try again.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
        } 
    }
    
    public function update_password()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
     
            $data=[];
            $data['title']='Update Password';
            $data['page']='update_password';
            return view('index',$data);
    }
    
    public function update_password_submit()
    {
        if(!isset($this->session->user))
        {
                $data=[];
                $data['message'] = 'Please Login';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
        }
        else
        {
            $user=$_SESSION['user'];
            $userid=$user['id']; 
            $this->session->set('logout_send',$userid);
            $password = $this->request->getVar('password');
            $password=password_hash($password, PASSWORD_BCRYPT);
            $current_datetime = date('Y-m-d H:i:s');
            $userPassworddetail=array(
                'password'=>$password,
                'password_update_date'=>$current_datetime,
                'password_update_logout'=>'yes'
            );  
            $userPassworddetailData=$this->HomeModel->UserPasswordUpdate($userPassworddetail,$userid);
            if($userPassworddetailData)
            {
                $_SESSION['user']['password']=$password;
                $data=[];
                $data['message'] = 'Password successfully update.';
                $data['status'] = "success";
                echo json_encode($data);
                return;
            }   
            else
            {
                $data=[];
                $data['message'] = 'Something Wrong! Please Try again.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
        } 
    }
    
    
    public function add_address()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $data=[];
            $data['title']='Add Address';
            $data['page']='add_address';
            return view('index',$data);
    }
    
    public function add_address_submit()
    {
        if(!isset($this->session->user))
        {
                $data=[];
                $data['message'] = 'Please Login';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
        }
        else
        {
            $user=$_SESSION['user'];
            $userid=$user['id']; 
            $address = $this->request->getVar('address');
            $first_name = $this->request->getVar('first_name');
            $last_name = $this->request->getVar('last_name');
            $countryid = $this->request->getVar('country');
            $country = countryname($countryid);
            $regionid = $this->request->getVar('region');
            $region = regionname($regionid);
            $address1 = $this->request->getVar('address1');
            $address2 = $this->request->getVar('address2');
            $city = $this->request->getVar('city');
            $zip = $this->request->getVar('zip');
            $phone = $this->request->getVar('phone');
            $company_name = $this->request->getVar('company_name');
            $default = $this->request->getVar('default');
            $note = $this->request->getVar('note');
              
    $shippingcode = $this->HomeModel->generateNewShippingCode();
            $address_detail=array(
                'userid'=>$userid,
                'shippingcode'=>$shippingcode,
                'first_name'=>$first_name,
                'last_name'=>$last_name,
                'address1'=>$address1,
                'address2'=>$address2,
                'phone'=>$phone,
                'countryid'=>$countryid,
                'countryname'=>$country,
                'regionid'=>$regionid,
                'regionname'=>$region,
                'city'=>$city,
                'zipcode'=>$zip,
                'addresstype'=>$address,
                'company'=>$company_name,
                'note'=>$note,
                );  
            if($this->request->getVar('default'))
            {
                $address_detail['defaultaddress']='yes';
            }
            else
            {
                $address_detail['defaultaddress']='no';
            }
            $address_detailData=$this->HomeModel->UserAddressInsert($address_detail);
            if($address_detailData)
            {
              $profile=$this->HomeModel->GetUserProfile($userid);
                // Send to external API
        $postData = [
            'shippingcode' => (string) $shippingcode,
            'registermobile'=>$profile['phone'],
            'firstname' => $first_name,
            'lastname'  => $last_name,
            'address1'   =>$address1,
            'address2'=>$address2,
            'mobileno'=>$phone,
            'email'=>$profile['email'],
            'country'=>$country,
            'region'=>$region,
            'city'=>$city,
            'zipcode'=>$zip,
            'company'=>$company_name,
        ];

        $apiresponse = $this->apiService->Add_address($postData);

        if (isset($apiresponse['success']) && $apiresponse['success'] === true) {
            $this->HomeModel->updateaddressApiFlag($address_detailData);
        }


                $data=[];
                $data['message'] = 'Address successfully add.';
                $data['status'] = "success";
                echo json_encode($data);
                return;
            }   
            else
            {
                $data=[];
                $data['message'] = 'Something Wrong! Please Try again.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
        } 
    }
    
    public function account_detail_submit()
    {
        if(!isset($this->session->user))
        {
                $data=[];
                $data['message'] = 'Please Login';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
        }
        else
        {
            $user=$_SESSION['user'];
            $userid=$user['id'];
            
            $first_name = $this->request->getVar('first_name');
            $last_name = $this->request->getVar('last_name');
            $email = $this->request->getVar('email');
            $userEmail=$this->HomeModel->CheckProfileEmail($email,$userid);
            if(isset($userEmail))
            {
                $data=[];
                $data['message'] = 'Email already registered.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
            $birth_month = $this->request->getVar('birth_month');
            $birth_day = $this->request->getVar('birth_day');
            $birth_year = $this->request->getVar('birth_year');
            if($birth_month!='' && $birth_day!='' && $birth_year!='')
            {
                $dob = $birth_day."-".$birth_month."-".$birth_year;
                $dob=date("Y-m-d",strtotime($dob));
            }
            else
            {
                $dob='';
            }  
            
            $anniversary_month = $this->request->getVar('anniversary_month');
            $anniversary_day = $this->request->getVar('anniversary_day');
            $anniversary_year = $this->request->getVar('anniversary_year');
            if($anniversary_month!='' && $anniversary_day!='' && $anniversary_year!='')
            {
                $anniversary = $anniversary_day."-".$anniversary_month."-".$anniversary_year;
                $anniversary=date("Y-m-d",strtotime($anniversary));
            }
            else
            {
                $anniversary='';
            }  
            $countryid = $this->request->getVar('country');
            $country = countryname($countryid);
            $regionid = $this->request->getVar('region');
            $region = regionname($regionid);
            $address1 = $this->request->getVar('address1');
            $additional_email = $this->request->getVar('additional_email');
            $address2 = $this->request->getVar('address2');
            $gender = $this->request->getVar('gender');
            $city = $this->request->getVar('city');
            $zip = $this->request->getVar('zip');
            $phone = $this->request->getVar('phone');
            $company_name = $this->request->getVar('company_name');
            if($this->request->getVar('newsletter'))
            {
                $NewsletterEmail=$email;
                $Newsletter= $this->HomeModel->GetNewsletter($NewsletterEmail);
                if(!isset($Newsletter))
                {
                    $data=array(
                        'email'=>$NewsletterEmail
                    );
                    $this->HomeModel->InsertNewsletter($data);  
                }
            }
            $account_detail=array(
                'first_name'=>$first_name,
                'last_name'=>$last_name,
                'email'=>$email,
                'phone'=>$phone,
                'dob'=>$dob,
                'anniversary'=>$anniversary,
                'gender'=>$gender,
                'countryid'=>$countryid,
                'country'=>$country,
                'regionid'=>$regionid,
                'region'=>$region,
                'address1'=>$address1,
                'additional_email'=>$additional_email,
                'address2'=>$address2,
                'city'=>$city,
                'zipcode'=>$zip,
                'company'=>$company_name
            );            
            $UserAccountUpdate=$this->HomeModel->UserAccountUpdate($account_detail,$userid);
            if($UserAccountUpdate)
            {
				$userprofile=$this->HomeModel->GetUserProfile($userid);
				 //loyalty points on  birthday
				 if($userprofile['dob']!='')
				 {
                    $type='birthday_loyalty_points';
                    $points=settings("birthday_loyalty_points");
					if($points>=1)
				    {
                      $this->Addloyaltypoints($type,$userid,$points);
					}
				 }
				 
				 //loyalty points on anniversary
				 if($userprofile['anniversary']!='')
				 {
                    $type='anniversary_loyalty_points';
                    $points=settings("anniversary_loyalty_points");
					if($points>=1)
				    {
                      $this->Addloyaltypoints($type,$userid,$points);
					}
				 }
				 
               $postData = [
             'firstname' => $first_name,
            'lastname'  => $last_name,
            'emailid'   => $email,
            'phone'     => $phone,
            'registermobile'=>$userprofile['phone'],
            'dob'       => $dob
        ];

        $apiresponse = $this->apiService->registerUser($postData);

        if (isset($apiresponse['success']) && $apiresponse['success'] === true) {
            $this->HomeModel->updateApiFlag($email);
        }

                $data=[];
                $data['message'] = 'Account Detail successfully update.';
                $data['status'] = "success";
                echo json_encode($data);
                return;
            }   
            else
            {
                $data=[];
                $data['message'] = 'Something Wrong! Please Try again.';
                $data['status'] = "failed";
                echo json_encode($data);
                return;
            }
        }    
    }
    
    public function account_detail()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $user=$_SESSION['user'];
            $userid=$user['id'];
            $data=[];
            $profile=$this->HomeModel->GetUserProfile($userid);
            if(!$profile)
            {
                return redirect()->to('/'); 
            }
            $email=$profile['email'];
            $Newsletter= $this->HomeModel->GetNewsletter($email);
			$data['newsletter']=false;
            if(isset($Newsletter))
            {
               $data['newsletter']=true; 
            }
			$TotalLoyaltyPoints=$this->TotalLoyaltyPoints();
			$data['TotalLoyaltyPoints']=$TotalLoyaltyPoints;
            $data['profile']=$profile;
            $data['title']='Account Detail';
            $data['page']='account_detail';
            return view('index',$data);
    }
	
	public function loyalty_points()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $user=$_SESSION['user'];
            $userid=$user['id'];
            $data=[];
            $profile=$this->HomeModel->GetUserProfile($userid);
            if(!$profile)
            {
                return redirect()->to('/'); 
            }
			$LoyaltyPoints=$this->HomeModel->GetUserLoyaltyPoints($userid);
			if(!$LoyaltyPoints)
			{
				return redirect()->to('my-account');
			}
			$TotalLoyaltyPoints=$this->TotalLoyaltyPoints();
			$data['TotalLoyaltyPoints']=$TotalLoyaltyPoints;
            $data['LoyaltyPoints']=$LoyaltyPoints;
			$data['profile']=$profile;
            $data['title']='Loyalty Points';
            $data['page']='loyalty_points';
            return view('index',$data);
    }
    
    public function login()
    {
        if(isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
              $google_client = new \Google_Client();
              $GoogleClientId=settings("GoogleClientId");
              $GoogleClientSecret=settings("GoogleClientSecret");
              $redirectUrl=base_url().'google-auth';
              $google_client->setClientId($GoogleClientId); //Define your ClientID
    
              $google_client->setClientSecret($GoogleClientSecret); //Define your Client Secret Key
            
              $google_client->setRedirectUri($redirectUrl); //Define your Redirect Uri
            
              $google_client->addScope('email');
            
              $google_client->addScope('profile');
              
        if(! $this->request->is('post')) 
        {
            $data=[];
              
            $data['googleLoginUrl']=$google_client->createAuthUrl();
            $data['onlinebenefits']=$this->HomeModel->onlinebenefit();
            $data['title']='Login';
            $data['page']='login';
            return view('index',$data);
        }
        else
        {
                
                
                        $rules = [
                         "email" => ["label" => "Email",  "rules" => "required|valid_email"],
                         "password" => ["label" => "Password",  "rules" => "required"],
                        ];

                        if(!$this->validate($rules)) 
                        {
                                $data=[];
                                $data['message'] = 'Email or Password not valid.';
                                $data['status'] = "failed";
                                echo json_encode($data);
                                return;
                }
                        else
                        {
                            $email=$this->request->getVar('email');
                            $password=$this->request->getVar('password');
                            $user=$this->HomeModel->CheckLogin($email);
                            if(isset($user))
                            {
                                $userpassword=$user['password'];
                                if($user['email_verify']==1)
                                {
                                    if($user['status']==1)
                                    {
                                        if(password_verify($password, $userpassword))
                                        {
                                                $this->session->set('user',$user);
                                                $this->cartexicute($type='login');
                                                $data=[];
                                                $data['message'] = 'Successfully login.';
                                                $data['status'] = "success";
                                                echo json_encode($data);
                                                return;
                                                
                                        }else {
                                                $data=[];
                                                $data['message'] = 'Password not valid.';
                                                $data['status'] = "failed";
                                                echo json_encode($data);
                                                return;
                                        }
                                    }
                                    else
                                    {
                                        $data=[];
                                        $data['message'] = 'Not Authorized for login.';
                                        $data['status'] = "failed";
                                        echo json_encode($data);
                                        return;
                                    }
                                }
                                else
                                {
                                    $code=RandomString($length=32);
                                    $userid=$user['id'];
                                    $update_data=array(
                                        'email_verify_code'=>$code,
                                    );
                                    
                                    $UserUpdatedata=$this->HomeModel->UserUpdatedata($update_data,$email,$userid);
                                    if($UserUpdatedata)
                                    {
                                        $link=base_url()."register-verify/".$code;
                                        $emailtemplate=emailtemplates('verify-email-user');
                                        $websettings=websettings();
                                        $token = array('SITE_URL' => base_url(''),
                                                        'SITE_TITLE' => $websettings['company_title'],
                                                        'EMAIL' => $email,
                                                        'LINK' => $link,
                                                        );
                                                        
                                        $to=$email; 
                                        $this->send_email($emailtemplate,$token,$to);
                                
                                        $data=[];
                                        $data['message'] = "Please Verify Your Register Email.";
                                        $data['status'] = "failed";
                                        echo json_encode($data);
                                        return;
                                    }
                                    else
                                    {
                                        $data=[];
                                        $data['message'] = "Something Wrong! Please Try again.";
                                        $data['status'] = "failed";
                                        echo json_encode($data);
                                        return;
                                    }
                                }
                            }
                            else
                            {
                                $data=[];
                                $data['message'] = 'Email not registered.';
                                $data['status'] = "failed";
                                echo json_encode($data);
                                return;
                            }
                          
                }
                
        }
    }
    
    public function google_auth()
    {
        if(isset($this->session->user))
        {
           return redirect()->to('login'); 
        }
        
              $google_client = new \Google_Client();
              $GoogleClientId=settings("GoogleClientId");
              $GoogleClientSecret=settings("GoogleClientSecret");
              $redirectUrl=base_url().'google-auth';
              $google_client->setClientId($GoogleClientId); //Define your ClientID
    
              $google_client->setClientSecret($GoogleClientSecret); //Define your Client Secret Key
            
              $google_client->setRedirectUri($redirectUrl); //Define your Redirect Uri
            
              $google_client->addScope('email');
            
              $google_client->addScope('profile');
              
        
        if(isset($_GET["code"]))
        {
                   $token = $google_client->fetchAccessTokenWithAuthCode($_GET["code"]);
                
                   if(!isset($token["error"]))
                   {
                    $google_client->setAccessToken($token['access_token']);
                    
                    $this->session->set('access_token', $token['access_token']);
                
                    $google_service = new \Google_Service_Oauth2($google_client);
                
                    $data = $google_service->userinfo->get();
                    $email=$data['email'];
                    $current_datetime = date('Y-m-d H:i:s');
                    $user=$this->HomeModel->CheckLogin($email);
                    if(isset($user))
                    {
                        if($user['status']==1)
                        {
                            //update data
                             $user_data = array(
                              'google_oauth_id' => $data['id'],
                              'update_date' => $current_datetime
                             );
                
                            $this->HomeModel->Update_google_user_data($user_data, $user['id']);
                            $this->session->set('user',$user);
                            $this->cartexicute($type='login');
                            return redirect()->to('my-account');
            
                        }
                        else
                        {
                            return redirect()->to('login');
                        }
                    }
                    else
                    {
                        $first_name=$data['given_name'];
                        $referralcode=RandomString($length=10);
                        $namesub=substr($first_name, 0, 3);
                        $dm=date('dm');
                        $referralcode=$namesub.$referralcode.$dm;
                        $userreferralcode='';
                        if(isset($this->session->referralcode))
                        {
                            $userreferralcode=$_SESSION['referralcode'];
                        }
                        
                       
                         //insert data
                         $dob='';
                         $user_data = array(
                          'google_oauth_id' => $data['id'],
                          'email_verify' =>1,
                          'first_name'  => $data['given_name'],
                          'last_name'   => $data['family_name'],
                          'email'  => $data['email'],
                          'profile' => $data['picture'],
                          'referralcode'=>$referralcode,
                          'referralcodeby'=>$userreferralcode,
                          'register_date'  => $current_datetime,
                          'update_date' => $current_datetime,
                          'source' => 'google'
                         );
                         if($data['gender']!='')
                         {
                             $user_data['gender']=$data['gender'];
                         }
                
                        $SaveUser=$this->HomeModel->SaveUser($user_data);
                        if($SaveUser)
                        {
                                //loyalty points on register
                                $type='register_loyalty_points';
                                $userid=$SaveUser;
                                $points=settings("register_loyalty_points");
                				if($points>=1)
                				{
                                $this->Addloyaltypoints($type,$userid,$points);
                				}
                            
                                if($userreferralcode!='')
                                {
                                    //loyalty points on register referral
                                    $referralcodeby=$userreferralcode;
                                    $checkreferralcode=$this->HomeModel->checkreferralcode($referralcodeby);
                                    if($checkreferralcode)
                                    {
                                        $type='register_loyalty_points';
                                        $userid=$checkreferralcode['id'];
                                        $points=settings("referral_loyalty_points");
                						if($points>=1)
                						{
                                        $this->Addloyaltypoints($type,$userid,$points);
                						}
                                    }    
                                }
            				
                				if($dob!='')
                                {
                                    //loyalty points on register birth day
                                        $type='birthday_loyalty_points';
                                        $userid=$SaveUser;
                                        $points=settings("birthday_loyalty_points");
                						if($points>=1)
                						{
                                        $this->Addloyaltypoints($type,$userid,$points);
                						}
                                       
                                }
                           
                            $user_data['id']=  $SaveUser; 
                            $this->session->set('user',$user_data);
                            $this->cartexicute($type='login');
                            return redirect()->to('my-account');
                        }
                    }
                   }
                   else
                   {
                        return redirect()->to('login'); 
                   }
                }
        else
        {
            return redirect()->to('login'); 
        }
    }
    
    public function forgot_password()
    {
        
        if(isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        
        if(! $this->request->is('post')) 
        {
            $data=[];
            $data['title']='Forgot Password';
            $data['page']='forgot_password';
            $data['onlinebenefits']=$this->HomeModel->onlinebenefit();

            return view('index',$data);
        }
        else
        {
               $rules = [
                         "email" => ["label" => "Email",  "rules" => "required|valid_email"],
                        ];

                if(!$this->validate($rules)) 
                {
                        $data=[];
                        $data['message'] = 'Enter valid email.';
                        $data['status'] = "failed";
                        echo json_encode($data);
                        return;
                }
                else
                {
                    $email=$this->request->getVar('email');
                    $user=$this->HomeModel->CheckLogin($email);
                    if(isset($user))
                    {
                        if($user['email_verify']==1)
                        {
                            if($user['status']==1)
                            {
                                $code=RandomString($length=32);
                                $link=base_url()."reset-password/".$code;
                                $emailtemplate=emailtemplates('forgot-password-admin');
                                $websettings=websettings();
                                $token = array('SITE_URL' => base_url(''),
                                                'SITE_TITLE' => $websettings['company_title'],
                                                'EMAIL' => $email,
                                                'LINK' => $link,
                                                );
                                                
                                $to=$email; 
                                $this->send_email($emailtemplate,$token,$to);
                                $currentTime = strtotime(date('Y-m-d H:i:s', strtotime('1 hour')));
                                $userid=$user['id'];
                                $reset_password_data=array(
                                    'reset_password_time'=>$currentTime,
                                    'reset_password_code'=>$code
                                    );
                                $reset_passwordUpdate=$this->HomeModel->reset_passwordUpdate($reset_password_data,$email,$userid);
                                if($reset_passwordUpdate)
                                {
                                    $data=[];
                                    $data['message'] = 'Password reset link successfully send.';
                                    $data['status'] = "success";
                                    echo json_encode($data);
                                    return;
                                }
                                else
                                {
                                    $data=[];
                                    $data['message'] = 'Something Wrong! Please Try again';
                                    $data['status'] = "failed";
                                    echo json_encode($data);
                                    return;
                                }
                            }
                            else
                            {
                                $data=[];
                                $data['message'] = 'Not Authorized for login.';
                                $data['status'] = "failed";
                                echo json_encode($data);
                                return;
                            }
                        }
                        else
                        {
                            $code=RandomString($length=32);
                            $userid=$user['id'];
                            $update_data=array(
                                'email_verify_code'=>$code,
                            );
                            
                            $UserUpdatedata=$this->HomeModel->UserUpdatedata($update_data,$email,$userid);
                            if($UserUpdatedata)
                            {
                                $link=base_url()."register-verify/".$code;
                                $emailtemplate=emailtemplates('verify-email-user');
                                $websettings=websettings();
                                $token = array('SITE_URL' => base_url(''),
                                                'SITE_TITLE' => $websettings['company_title'],
                                                'EMAIL' => $email,
                                                'LINK' => $link,
                                                );
                                                
                                $to=$email; 
                                $this->send_email($emailtemplate,$token,$to);
                        
                                $data=[];
                                $data['message'] = "Please Verify Your Register Email.";
                                $data['status'] = "failed";
                                echo json_encode($data);
                                return;
                            }
                            else
                            {
                                $data=[];
                                $data['message'] = "Something Wrong! Please Try again.";
                                $data['status'] = "failed";
                                echo json_encode($data);
                                return;
                            }
                        }
                    }
                    else
                    {
                        $data=[];
                        $data['message'] = 'Email not registered.';
                        $data['status'] = "failed";
                        echo json_encode($data);
                        return;
                    }
                  
                }
        }
    
    }
    
    public function reset_password($udid='')
    {
        if(isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        //echo $udid; die;
        if(!isset($udid) )
        {
          return redirect()->to('/not-found');   
        }
        else
        {
            $verify_email= $this->HomeModel->Verifyreset_password($udid);
            if(isset($verify_email) && count($verify_email)>=1)
            {
                $currentTime = strtotime(date('Y-m-d H:i:s'));
                if($currentTime<=$verify_email['reset_password_time'])
                {
                    if(! $this->request->is('post')) 
                    {
                          $data=[];
                          $data['title']='Reset Password';
                          $data['code']=$udid;
                          $data['page']='reset_password';
                          $data['onlinebenefits']=$this->HomeModel->onlinebenefit();

                          return view('index',$data);
                    }
                    else
                    {
                        $password = $this->request->getVar('password');
                        $userid=$verify_email['id'];
                        $email=$verify_email['email'];
                        $password=password_hash($password, PASSWORD_BCRYPT);
                        $reset_password_data=array(
                            'reset_password_time'=>'',
                            'reset_password_code'=>'',
                            'password'=>$password
                        );
                        $reset_passwordUpdate=$this->HomeModel->reset_passwordUpdate($reset_password_data,$email,$userid);
                        if($reset_passwordUpdate)
                        {
                            $data=[];
                            $data['message'] = 'Password successfully reset.';
                            $data['status'] = "success";
                            echo json_encode($data);
                            return;
                        }
                        else
                        {
                            $data=[];
                            $data['message'] = 'Something Wrong! Please Try again';
                            $data['status'] = "failed";
                            echo json_encode($data);
                            return;
                        }
                    }
                }
                else
                {
                    return redirect()->to('/forgot-password'); 
                }
            }
            else
            {
                return redirect()->to('/forgot-password'); 
            }
        }
    }
    
    public function logout()
    {

        if(isset($this->session->user))
        {
            $cartguestid='';
            if(isset($this->session->cartguestid))
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
            $this->cartexicute($type='logout');
            $this->session->remove('user');
            $this->session->remove('referralcode');
            

            if($cartguestid=='')
            {
                $cartguestid=$this->cartguestid();
            }
            else
            {
                $cartguestid=$this->cartguestid($cartguestid);
            }
            
                return redirect()->to('/');
            
        }
        else
        {
            return redirect()->to('/');
        }
    }
    
    public function cartexicute($type='logout')
    {
            if(!isset($this->session->cartguestid))
            {
                $cartguestid=$this->cartguestid();
            }
            else
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
       
        if(isset($this->session->user))
        {
            $user=$_SESSION['user'];
            $userid=$user['id'];
           
            $this->HomeModel->cartexicuteUpdate($userid,$cartguestid,$type);
          
        }     
    }
    
    public function cartguestid($cartguestid='')
    {
            if(!isset($this->session->cartguestid))
            {
                if($cartguestid=='')
                {
                    $cartguestid=RandomString($length=6).'GUEST'.strtotime(date("Y-m-d H:i:s"));
                }
                $this->session->set('cartguestid',$cartguestid);
            }
            else
            {
                $cartguestid=$_SESSION['cartguestid'];
            }
            
            return $cartguestid;
    }
    
    public function Addloyaltypoints($type,$userid,$points)
    {
        $data=array(
            'userid'=>$userid,
            'points'=>$points,
            'type'=>$type,
            'created_at'=>date('Y-m-d H:i:s')
            );
		$chekloyaltypoints = $this->HomeModel->chekloyaltypoints($userid,$type);
		if($chekloyaltypoints<1)
		{
			$this->HomeModel->Insertloyaltypoints($data);    
		}
    }
	
	public function TotalLoyaltyPoints()
	{
		if(isset($this->session->user))
        {
            $user=$user= $_SESSION['user'];
            $userid=$user['id'];
			$totaladdpoints = $this->HomeModel->totaladdpoints($userid);
			
			$totalremovepoints = $this->HomeModel->totalremovepoints($userid);
			$TotalLoyaltyPoints=array(
				'totaladdpoints'=>$totaladdpoints['points'],
				'totalremovepoints'=>$totalremovepoints['points'],
				'totalpoints'=>$totaladdpoints['points']-$totalremovepoints['points']
			);
			return $TotalLoyaltyPoints;
        }
		else
		{
			$TotalLoyaltyPoints=array(
				'totaladdpoints'=>0,
				'totalpoints'=>0,
				'totalremovepoints'=>0,
			);
			return $TotalLoyaltyPoints;
		}
		
	}
	public function checkout()
    {
       if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
	
            $user=$user= $_SESSION['user'];
            $data=[];
            $customerid=$user['id'];
            $carttype=1;
            $page=0;
            $count=0;
            $this->cartnotexitremove($customerid);
            $cartdetails=$this->HomeModel->cartdetails($customerid);
            if(!isset($cartdetails) || count($cartdetails)<1)
            {
               return redirect()->to('/cart'); 
                
            }  
            
            
            $address=$this->HomeModel->address($customerid);
            $data['cartlist']  =$cartdetails;     
            $data['address']  =$address;     
            $country=country();
            $data['GetCountry']=$country;
            $data['title']='Checkout';
            $data['page']='checkout';
            return view('include/top_meta')
                . view('include/include_top')
                . view('include/body_start')
                . view('include/checkout_header')
                . view('checkout', $data)
                . view('include/checkout_footer')
                . view('include/include_bottom')
                . view('include/body_end');
    }
	
	  
    public function GetShippingMethod()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        $session_ShippingMethod="";
        $checkedStatus="";
        if(isset($_SESSION['shippingdetail']))
        {
            $session_ShippingMethod=$_SESSION['shippingdetail']['ShippingMethod'];
        }
        $shippingaddress=$this->request->getVar('shippingaddress'); 
        if($shippingaddress=='newaddress')
        {
            $regionid=$this->request->getVar('regionid');  
            $countryId=$this->request->getVar('countryid'); 
            $ShippingMethods=$this->HomeModel->GetShippingMethod($regionid,$countryId);
        }
        else
        {
                $user= $_SESSION['user'];
                $Customerid=$user['id'];
                $addressId=base64_decode($shippingaddress);
                $address=$this->HomeModel->editaddress($Customerid,$addressId);
                if(isset($address))
                {        
                    $regionid=$address['regionid'];  
                    $countryId=$address['countryid']; 
                    $ShippingMethods=$this->HomeModel->GetShippingMethod($regionid,$countryId);
                }
        }
        
        if(isset($ShippingMethods))
        {
            if(count($ShippingMethods)>0)
            {
                foreach($ShippingMethods as $ShippingMethod)
                {
                    $currentdate=date("d-m-Y");
                    $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.$ShippingMethod['days'].' days'));
                    if(isset(unserialize($ShippingMethod['shipping_name'])[$_SESSION['language']]))
                    {
                        $ShippingMethodname=unserialize($ShippingMethod['shipping_name'])[$_SESSION['language']];
                    }
                    else
                    {
                        $ShippingMethodname=unserialize($ShippingMethod['shipping_name'])['en'];
                    }
                    if($session_ShippingMethod==base64_encode($ShippingMethod['id']))
                    {
                        $checkedStatus='checked="checked"';
                    }
            ?>
            <div class="form-check">
                <input class="form-check-input" type="radio" <?=$checkedStatus?> value="<?=base64_encode($ShippingMethod['id'])?>" name="ShippingMethod" id="r10">
                <label class="form-check-label" for="r10">
                <h5 class="sa-check-title"><?=$ShippingMethodname?></h5>
                    <p class="sa-check-text">Delivery by <?=date("l d/m",strtotime($ShippingDate))?></p>
                </label>
                <div class="sa-check-arrow"><?=settings('currency')?> <?=$ShippingMethod['shipping']?></div>
            </div>
            <?php 
                }
            }
            else
            {
                $currentdate=date("d-m-Y");
                $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.settings('standard_delivery_days').' days'));
                if($session_ShippingMethod=="standered")
                {
                    $checkedStatus='checked="checked"';
                }
                ?>
                <div class="form-check">
                    <input class="form-check-input" type="radio"  <?=$checkedStatus?>  value="standered" name="ShippingMethod" id="r10">
                    <label class="form-check-label" for="r10">
                    <h5 class="sa-check-title">Standered Delivery</h5>
                        <p class="sa-check-text">Delivery by <?=date("l d/m",strtotime($ShippingDate))?></p>
                    </label>
                    <div class="sa-check-arrow"><?=settings('currency')?> <?=settings('standard_delivery_amount')?></div>
                </div>
                <?php   
            }
        }
        else
        {
            $currentdate=date("d-m-Y");
            $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.settings('standard_delivery_days').' days'));
               if($session_ShippingMethod=="standered")
                {
                    $checkedStatus='checked="checked"';
                } 
                ?>
                <div class="form-check">
                    <input class="form-check-input" type="radio" <?=$checkedStatus?>   value="standered" name="ShippingMethod" id="r10">
                    <label class="form-check-label" for="r10">
                    <h5 class="sa-check-title">Standered Delivery</h5>
                        <p class="sa-check-text">Delivery by <?=date("l d/m",strtotime($ShippingDate))?></p>
                    </label>
                    <div class="sa-check-arrow"><?=settings('currency')?> <?=settings('standard_delivery_amount')?></div>
                </div>
            <?php                                
        }
    }
	public function GetamountMaping()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        $user= $_SESSION['user'];
        $Customerid=$user['id'];
        $cartAmount=0;
        $taxAmount=settings('default_estimated_taxes');
        $tax_name="";
        
        $shipping_date="";
        $shipping_name="";
        $shippingAmount=0;

        $shippingaddress=$this->request->getVar('shippingaddress'); 
        $shippingmethod=$this->request->getVar('shippingmethod'); 
        if($shippingaddress=='newaddress')
        {
            $regionid=$this->request->getVar('regionid');  
            $countryId=$this->request->getVar('countryId'); 
        }
        else
        {
                $addressId=base64_decode($shippingaddress);
                $address=$this->HomeModel->editaddress($addressId,$Customerid);
                if(isset($address))
                {        
                    $regionid=$address['regionid'];  
                    $countryId=$address['countryid']; 
                }
        }
		
        if(isset($shippingmethod))
        {
            if($shippingmethod=='standered')
            {
                $shipping_name="Standered Delivery";
                $shippingAmount=settings('standard_delivery_amount');
                
                $currentdate=date("d-m-Y");
                $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.settings('standard_delivery_days').' days'));

                $shipping_date="Delivery by ".date("l d/m",strtotime($ShippingDate));
            }
            else
            {
                $shippingmethod=base64_decode($shippingmethod);
                $ShippingMethods=$this->HomeModel->GetShippingMethodId($shippingmethod);
                if(isset($ShippingMethods))
                {
                    if(count($ShippingMethods)>0)
                    {
                        if(isset(unserialize($ShippingMethods['shipping_name'])[$_SESSION['language']]))
                        {
                            $shipping_name=unserialize($ShippingMethods['shipping_name'])[$_SESSION['language']];
                        }
                        else
                        {
                            $shipping_name=unserialize($ShippingMethods['shipping_name'])['en'];
                        }
                        
                        $currentdate=date("d-m-Y");
                        $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.$ShippingMethods['days'].' days'));
                    
                        $shipping_date="Delivery by ".date("l d/m",strtotime($ShippingDate));
                        $shippingAmount=$ShippingMethods['shipping'];
                    }
            }
            }
        }
        
        $taxamountData=$this->HomeModel->Gettaxamount($regionid,$countryId);                
        if(isset($taxamountData))
        {
            if(count($taxamountData)>0)
            {
				if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
				{
					$tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
				}
				else
				{
					$tax_name=unserialize($taxamountData['tax_name'])['en'];
				}
				$taxAmount=$taxamountData['tax'];
            }
        }
		else
		{
			$taxamountData=$this->HomeModel->GetCountrytaxamount($countryId);                
			if(isset($taxamountData))
			{
				if(count($taxamountData)>0)
				{
					if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
					{
						$tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
					}
					else
					{
						$tax_name=unserialize($taxamountData['tax_name'])['en'];
					}
					$taxAmount=$taxamountData['tax'];
				}
			}
		}
        
            $carttype=1;
            $page=0;
            $count=0;
            $totalTaxAmount=0;
            $this->cartnotexitremove($Customerid);
            $cartdetails=$this->HomeModel->cartdetails($Customerid);
            if($cartdetails)
            {
				foreach($cartdetails as $product)
				{
					if($product['variationid']!=0)
					{
						$productAmount=$product['variation_sale_price'];
						$productPrice=floatval(preg_replace('/[^\d.]/', '', $product['variation_sale_price']))*floatval($product['cartqty']);
					}
					else
					{
						$productAmount=$product['products_sale_price'];
						$productPrice=floatval(preg_replace('/[^\d.]/', '', $product['products_sale_price']))*floatval($product['cartqty']);
					}
					$cartAmount+=$productPrice;
					
					
					$product_tax=($productPrice/100)*$taxAmount;
					$totalTaxAmount+=$product_tax;
				}
				
			}
                        
        
		
		$couponAmount=0;
		$couponId=0;
		if(isset($_SESSION['coupon']))
		{	
			$couponCode=$_SESSION['coupon']['coupon'];	
			$couponDataResponce=$this->couponCheck($couponCode);
			$couponDataResponce=json_decode($couponDataResponce,true);
			if($couponDataResponce['status']==true)
			{
				$couponId=$_SESSION['coupon']['id'];
				if($_SESSION['coupon']['coupon_type']=='Percent')
				{
					$couponAmount=$cartAmount*$_SESSION['coupon']['discount']/100;
				}
				else
				{
					$couponAmount=$_SESSION['coupon']['discount'];
				}
			}
		}
		
        
        $data=array(
            'subtotal'=>$cartAmount,
			'couponAmount'=>$couponAmount,
			'couponId'=>$couponId,
            'tax_name'=>$tax_name,
            'tax'=>$taxAmount,
            'taxAmount'=>round($totalTaxAmount,2),
            'shipping_name'=>$shipping_name,
            'shipping_date'=>$shipping_date,
            'shippingAmount'=>$shippingAmount,
            );
            
        echo json_encode($data);    

    }
	
	public function SetBillingAddress()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        if(isset($this->session->billingaddress))
        {
                unset($_SESSION['billingaddress']);
        }
        
        if(!$this->request->getVar('Sameshippingaddress'))
        {
            $first_name = $this->request->getVar('first_name');
            $last_name = $this->request->getVar('last_name');
            $email = $this->request->getVar('email');
            $phoneCode = $this->request->getVar('country_code');
            $phone = $this->request->getVar('phone');
            $address1 = $this->request->getVar('address1');
            $address2 = $this->request->getVar('address2');
            $zipcode = $this->request->getVar('zipcode');
            $city = $this->request->getVar('city');
            $countryid = $this->request->getVar('country');
            $regionid = $this->request->getVar('region');
            
            $user= $_SESSION['user'];
            $Customerid=$user['id'];
            $profile=$this->HomeModel->GetUserProfile($Customerid);
            if(isset($profile))
            {
                $profileData=$profile;
            }
            if(!isset($profileData))
            {
                return redirect()->to('/checkout'); 
            }
           $GetCountry=$this->Api->GetCountry();
           $countryname=countryname($countryid);
           $regionname=regionname($regionid);
		   
                    $data=array(
                        'useid'=>$profileData['id'],
                        'accounttype'=>'customer',
                        'first_name'=>$first_name,
                        'last_name'=>$last_name,
                        'address1'=>$address1,
                        'address2'=>$address2,
                        'city'=>$city,
                        'zipcode'=>$zipcode,
                        'countryid'=>$countryid,
                        'countryname'=>$countryname,
                        'regionid'=>$regionid,
                        'regionname'=>$regionname,
                        'phone'=>$phone,
                        'phone_code'=>$phoneCode,
                        'emailid'=>$email,
                        'addresstype'=>"custom",
                        'defaultaddress'=>"no",
                        'billingaddresstype'=>"custom"
                        );       
            $this->session->set('billingaddress',$data);
        }
        else
        {
            if(isset($_SESSION['shippingdetail']))
            {
                if($_SESSION['shippingdetail']['shippingaddress']=="newaddress")
                { 
                    if(isset($_SESSION['shippingaddress']))
                    {
                        $address=$_SESSION['shippingaddress'];
                    }
                }
                else
                {
                    $shippingaddressId=base64_decode($_SESSION['shippingdetail']['shippingaddress']);
                    $user= $_SESSION['user'];
                    $Customerid=$user['id'];
                    $address=$this->HomeModel->editaddress($shippingaddressId,$Customerid);
                }
            }
            $address["billingaddresstype"]="shippingaddress";
            $this->session->set('billingaddress',$address);
        }
        
        $data=array(
            "status"=>"success",
            );
        echo json_encode($data);
    }
    public function Shippingcheckout()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        if(isset($this->session->shippingaddress))
        {
                unset($_SESSION['shippingaddress']);
        }
        if(isset($this->session->shippingdetail))
        {
                unset($_SESSION['shippingdetail']);
        }
        $shippingaddress=$this->request->getVar('shippingaddress'); 
        if($shippingaddress=='newaddress')
        {
            $first_name = $this->request->getVar('first_name');
            $last_name = $this->request->getVar('last_name');
            $email = $this->request->getVar('email');
            $phoneCode = $this->request->getVar('country_code');
            $phone = $this->request->getVar('phone');
            $address1 = $this->request->getVar('address1');
            $address2 = $this->request->getVar('address2');
            $zipcode = $this->request->getVar('zipcode');
            $city = $this->request->getVar('city');
            $countryid = $this->request->getVar('country');
            $regionid = $this->request->getVar('region');
            
           $user= $_SESSION['user'];
            $Customerid=$user['id'];
            $profile=$this->HomeModel->GetUserProfile($Customerid);
            if(isset($profile))
            {
                $profileData=$profile;
            }
            if(!isset($profileData))
            {
                return redirect()->to('/checkout'); 
            }
           $GetCountry=country();
           $countryname=countryname($countryid);
           $regionname=regionname($regionid);
		   
                   $data=array(
                        'userid'=>$profileData['id'],
                        'accounttype'=>'customer',
                        'first_name'=>$first_name,
                        'last_name'=>$last_name,
                        'address1'=>$address1,
                        'address2'=>$address2,
                        'city'=>$city,
                        'zipcode'=>$zipcode,
                        'countryid'=>$countryid,
                        'countryname'=>$countryname,
                        'regionid'=>$regionid,
                        'regionname'=>$regionname,
                        'phone'=>$phone,
                        'phone_code'=>$phoneCode,
                        'emailid'=>$email,
                        'addresstype'=>"custom",
                        );  
						
            if($this->request->getVar('setshippingaddress') && $this->request->getVar('setshippingaddress')=="yes")
            {
                $data["defaultaddress"]="yes";
            }
            $this->session->set('shippingaddress',$data);
        }elseif($shippingaddress=='undefined' || $shippingaddress==''){
              // If shippingaddress is undefined, return an error status
        $data = array(
            "status"  => "error",
            "message" => "Shipping address is undefined. Please select a valid address."
        );
          
        echo json_encode($data);
        return;

        }


        
        $ShippingMethod=$this->request->getVar('ShippingMethod'); 
        $data=array(
            "status"=>"success",
            "shippingaddress"=>$shippingaddress,
            "ShippingMethod"=>$ShippingMethod,
            );
        $this->session->set('shippingdetail',$data);
        echo json_encode($data);
    }
    
    public function viewshippingAddress()
    {
        if(isset($_SESSION['shippingdetail']))
        {
            if($_SESSION['shippingdetail']['shippingaddress']=="newaddress")
            { 
                if(isset($_SESSION['shippingaddress']))
                {
                    $address=$_SESSION['shippingaddress'];
                    if(isset($address))
                    {
                        $addressView="";
                        $addressView.=$address['address1'];
                        if($address['address2']!='')
                        {
                            $addressView.=", ".$address['address2'];
                        }
                        $addressView.=", ".$address['city'];
                        $addressView.=", ".$address['regionname'];
                        $addressView.=", ".$address['countryname'];
                        $addressView.=", ".$address['zipcode'];
                        $addressView.="<br>Phone : +".$address['phone_code']." ".$address['phone'];
                        echo $addressView;
                    }
                }
            }
            else
            {
                $shippingaddressId=base64_decode($_SESSION['shippingdetail']['shippingaddress']);
                $user= $_SESSION['user'];
                $Customerid=$user['id'];
                $address=$this->HomeModel->editaddress($shippingaddressId,$Customerid);
                if(isset($address))
                {
                    $addressView="";
                    $addressView.=$address['address1'];
                    if($address['address2']!='')
                    {
                        $addressView.=", ".$address['address2'];
                    }
                    $addressView.=", ".$address['city'];
                    $addressView.=", ".$address['regionname'];
                    $addressView.=", ".$address['countryname'];
                    $addressView.=", ".$address['zipcode'];
                    $addressView.="<br>Phone : ".$address['phone'];
                    echo $addressView;
                }
            }
        }
    }
    
    public function viewshippingmethod()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        $session_ShippingMethod="";
        
        if(isset($_SESSION['shippingdetail']))
        {
            $session_ShippingMethod=$_SESSION['shippingdetail']['ShippingMethod'];
            if($session_ShippingMethod=="standered")
            {
                $currentdate=date("d-m-Y");
                $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.settings('standard_delivery_days').' days'));
                ?>
                <li>Standered Delivery</li>
                <li>Delivery by <?=date("l d/m",strtotime($ShippingDate))?></li>
                <?php 
            }
            else
            {
                $ShippingMethodId=base64_decode($session_ShippingMethod);
                $ShippingMethod=$this->HomeModel->GetShippingMethodId($ShippingMethodId);
                if(isset(unserialize($ShippingMethod['shipping_name'])[$_SESSION['language']]))
                {
                    $shipping_name=unserialize($ShippingMethod['shipping_name'])[$_SESSION['language']];
                }
                else
                {
                    $shipping_name=unserialize($ShippingMethod['shipping_name'])['en'];
                }
                    $currentdate=date("d-m-Y");
                    $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.$ShippingMethod['days'].' days'));
                 ?>
                <li><?=$shipping_name?></li>
                <li>Delivery by <?=date("l d/m",strtotime($ShippingDate))?></li>
                <?php    
            }
        }
    }
	public function CouponApply()
	{
		$couponCode = $this->request->getVar('couponCode');
		$couponDataResponce=$this->couponCheck($couponCode);
		$couponDataResponce=json_decode($couponDataResponce,true);
		if($couponDataResponce['status']==true)
		{
		$couponData=$couponDataResponce['data'];
		$this->session->set('coupon',$couponData);
		}
		echo json_encode($couponDataResponce);
	}
	
	public function CouponRemove()
	{
		if(isset($_SESSION['coupon']))
		{
			$this->session->remove('coupon');
			$responsedata=array(
				"status"=>true,
				'message'=>'Coupon successfully removed.',
				);
			return json_encode($responsedata);
			return;
		}
		
	}
	public function couponCheck($couponCode)
	{
		$couponData=$this->HomeModel->getCoupon($couponCode);
		if($couponData)
		{
			$user= $_SESSION['user'];
			$Customerid=$user['id'];
			$couponid=$couponData['id'];
			$current_date=strtotime(date("m/d/Y"));
			$coupon_date=explode("-",$couponData['coupon_date']);
			$startDate=strtotime($coupon_date[0]);
			$endDate=strtotime($coupon_date[1]);
			if($current_date>=$startDate && $current_date<=$endDate)
			{
					$customerids=explode(",",$couponData['customers']);
					if (in_array($Customerid, $customerids) || $couponData['customers']=='')
					{
						$totalCouponUse=$this->HomeModel->totalCouponUse($couponid);
						$totalCouponUseCustomer=$this->HomeModel->totalCouponUseCustomer($couponid,$Customerid);
						if($couponData['uses_per_coupon']==0 || $couponData['uses_per_coupon']>$totalCouponUse)
						{
							if($couponData['uses_per_customer']==0 || $couponData['uses_per_customer']>$totalCouponUseCustomer)
							{
								$responsedata=array(
									"status"=>true,
									'message'=>'Coupon successfully applied.',
									'data'=>$couponData
									);
								return json_encode($responsedata);
								return;
							}
							else
							{
								$responsedata=array(
									"status"=>false,
									'message'=>'Coupon not valid.'
									);
								return json_encode($responsedata);
								return;
							}
							
						}
						else
						{
							$responsedata=array(
								"status"=>false,
								'message'=>'Coupon not valid.'
								);
							return json_encode($responsedata);
							return;
						}
					}
					else
					{
					   $responsedata=array(
							"status"=>false,
							'message'=>'Coupon not valid for you.'
							);
						return json_encode($responsedata);
						return;
					}
			}
			else
			{
				$responsedata=array(
					"status"=>false,
					'message'=>'Coupon Code Expired.'
					);
				return json_encode($responsedata);
				return;
				
			}
			
		}
		else
		{
			$responsedata=array(
				"status"=>false,
				'message'=>'Coupon Code Not valid.'
				);
			return json_encode($responsedata);
			return;
		}
	}
	   public function failed()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
                $data=[];
                $data['title']='Failed';
                $data['page']='failed';
                return view('index',$data);
    }

 public function success()
{
    $hasPost = $this->request->getPost();
    $stripeData = $_SESSION['StripPaymentdata'] ?? null;

    if (($hasPost || $stripeData)) {
        if ($stripeData) {
            unset($_SESSION['StripPaymentdata']);

            $userid = $stripeData['userid'];
            $orderid = $stripeData['orderid'];
            $txn_id = $stripeData["txn_id"];

            $data = [
                'orderid' => $orderid,
                'txn_id' => $txn_id,
                'userid' => $userid,
            ];
          $apiData=$this->HomeModel->Apiorderdata($orderid,$userid);
            $this->session->set('paymentProcess', $data);
      
            $data['title'] = 'Order Success';
            $data['GetCountry'] = country(); // Assuming country() is a helper function
            $data['page'] = 'ordersuccess';
             
            return view('include/top_meta')
                . view('include/include_top')
                . view('include/body_start')
                . view('include/checkout_header')
                . view('ordersuccess', $data)
                . view('include/checkout_footer')
                . view('include/include_bottom')
                . view('include/body_end');
        }
    }

    return redirect()->to('/');
}

    
    public function paymentProcess()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        if(isset($_SESSION['paymentProcess']))
        {
            $paymentProcess=$_SESSION['paymentProcess'];
            $orderid = $paymentProcess['orderid']; 
            $txn_id = $paymentProcess["txn_id"];
            $userid = $paymentProcess["userid"];
            $paymentStatus=$this->HomeModel->paymentStatus($orderid,$txn_id,$userid);
            
            if(isset($paymentStatus))
            {
                if($paymentStatus['orderid']==$orderid && $paymentStatus['txn_id']==$txn_id && $paymentStatus['userid']==$userid)
                {
                    if($paymentStatus['paymentStatus']=="Paid")
                    {
                        $orderStatus=$this->HomeModel->orderStatus($orderid,$txn_id,$userid);
                        if(isset($orderStatus))
                        {
                            if($orderStatus['status']=="pending")
                            {
                            $data=array(
                                'status'=>"success",
                                "paymenttype"=>"paid",
                                "ordertype"=>"pending"
                                );
                            }
                            elseif($orderStatus['status']=="confirm")
                            {
                            $data=array(
                                    'status'=>"success",
                                    "paymenttype"=>"paid",
                                    "ordertype"=>"confirm"
                                );
                            }
                            else
                            {
                                $data=array(
                                    'status'=>"success",
                                    "paymenttype"=>"paid",
                                    "ordertype"=>"pending"
                                );
                            }
                        }
                        else
                        {
                            $data=array(
                                    'status'=>"success",
                                    "paymenttype"=>"paid",
                                    "ordertype"=>"pending"
                                );
                        }
                    }
                    else
                    {
                        $data=array(
                            'status'=>"success",
                            "paymenttype"=>"failed",
                            "ordertype"=>"pending"
                            );
                    }
                    
                }
                else
                {
                    $data=array(
                        'status'=>"failed",
                        "paymenttype"=>"notfound",
                        "ordertype"=>"pending"
                        );
                }
            }
            else
            {
                $data=array(
                    'status'=>"failed",
                    "paymenttype"=>"notfound",
                    "ordertype"=>"pending"
                );
            }
            echo json_encode($data);
        }
    }
	
	public function orders()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $data=[];
            $data['title']='Orders';
            $data['page']='orders';
            return view('index',$data);
    }
    
    public function Getorders()
    {
        if(!isset($this->session->user))
        {
           return false; 
        }
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('masterorders')
                     ->select('id')
                     ->where('userid', $userid)
                     ->where('orderStatus', 1)
                      ->groupStart()
                        ->where('status!=', 'failed')
                        ->groupEnd()
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders')
                                ->select('id')
                                ->where('userid', $userid)
                                ->Like('orderid', $searchValue)
                                ->groupStart()
                                ->where('status!=', 'failed')
                                ->groupEnd()
                                ->where('orderStatus', 1)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('masterorders')
            ->select('*')
            ->where('userid', $userid)
            ->where('orderStatus', 1)
            ->Like('orderid', $searchValue)
            ->groupStart()
            ->where('status!=', 'failed')
            ->groupEnd()
            ->orderBy('orderdate','DESC')
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1+$start;

       foreach($records as $record )
       {
            $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="status confirm" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="status pending" >Pending</span>';
               
           }
		   else
		  {
			$status=$record['status'];
			$GetStatusDetail=$this->HomeModel->GetStatusDetail($status);
			if($GetStatusDetail)
			{
				$orderStatus=$GetStatusDetail['status_title'];
			}	
			else
			{
				$orderStatus=$record['status'];
			}
			  $status='<span class="status confirm" >'.$orderStatus.'</span>';
              
		  }
				$action.='<span class="action-buttons" style="display: flex;  gap: 3px; justify-content: flex-start; flex-wrap: nowrap;    flex-direction: row;">';
				$action.='<a href="javascript:void(0)" style="color:white;" data-orderid="'.$record['orderid'].'" class="view-record orderview">';
				$action.='<span title="View Order" class="view-button btn btn-info">';
				$action.='<i class="fa fa-eye"></i>';
				$action.='</span></a>';
				
			if($record['invoice']!='')
			{					
			    $action.='<a href="'.base_url().'invoice/'.$record['orderid'].'" style="color:white;" data-orderid="'.$record['orderid'].'" class="view-record">';
				$action.='<span title="View Invoice" class="view-button btn btn-success">';
				$action.='<i class="fa fa-file-pdf-o"></i>';
				$action.='</span></a>';
			}
             $action.='</span">';
          
          
             $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
             $orderid=$record['orderid'];
			 
			 $billingAddress=$this->HomeModel->GetbillingAddress($orderid,$userid);  
			 $trackingStatus='';
			 if($record['tracking_id']!='')
			 {
				 $trackingDetails=$this->HomeModel->GettrackingDetails($orderid,$userid);  
				 if(isset($trackingDetails))
				 {
					 
					 $trackingStatus='<p style="display: flex;flex-direction: column;"><span style="background: #91c991;
						color: white;
						text-align: center;
						font-size: 13px;
						border-radius: 14px;
					">'.$trackingDetails['tracking_id'].'
					
					</span><span style="text-align: center;"><a style="text-align: center;
						font-size: 11px;
					"href="'.$trackingDetails['order_tracking_link'].'" target="_blank"><i class="fa fa-truck"></i> Track Order</a></span></p>';
				}
				 else
				 {
					$trackingStatus='-';  
				 }
			 }
			 else
			 {
				$trackingStatus='-'; 
			 }
			 $orderid=$record['orderid'];
			 $OrderReview=$this->HomeModel->orderReview($orderid,$userid); 
			 if($OrderReview)
			 {
			     $rate=$OrderReview['rate'];
			 }
			 else
			 {
			     $rate=0;
			 }
			 $orderidview='';
			 $orderidview.='<span>'.$record['orderid'].'</span>';
			 
			 $orderdeliveredstatus=$this->HomeModel->orderdeliveredstatus($orderid,$userid);
			 if($orderdeliveredstatus)
			 {
			 $orderidview.='<div class="rate orderreview orderreview_'.$orderid.'"  data-orderid="'.$orderid.'">';
			 if($rate>=1){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star1'.$orderid.'" title="1 star">1 star</label>';
             if($rate>=2){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star2'.$orderid.'" title="2 star">2 star</label>';
             if($rate>=3){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star3'.$orderid.'" title="3 star">3 star</label>';
              if($rate>=4){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star4'.$orderid.'" title="4 star">4 star</label>';
             if($rate>=5){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star5'.$orderid.'" title="5 star">5 star</label>';
             $orderidview.='</div>';
			 }
			 
			 if($billingAddress)
			 {
			     $billname=trim($billingAddress['first_name'].' '.$billingAddress['last_name']);
			 }
			 else
			 {
			     $billname='';
			 }
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$orderidview,
			 "billname"=>$billname,
             "ShippingDate"=>$record['shipping_date'],
             "amount"=>$record['currency']." ".number_format($record['total_amount'],2),
             "status"=>$status,
			 "tracking_id"=>$trackingStatus,
             "orderdate"=>$date,
             "action"=>$action,
            ); 
            $i++;
       }
	   
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
	public function payments()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
            $data=[];
            $data['title']='Payments';
            $data['page']='payments';
            return view('index',$data);
    }
    
    public function Getpayments()
    {
        
        if(!isset($this->session->user))
        {
           return false; 
        }
        
       $user=$user= $_SESSION['user'];
       $userid=$user['id'];
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('payments')
                     ->select('id')
                     ->where('userid', $userid)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('payments')
                                ->select('id')
                                ->where('userid', $userid)
                                ->Like('orderid', $searchValue)
                                ->orLike('txn_id', $searchValue)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('payments')
            ->select('*')
            ->Like('orderid', $searchValue)
            ->orLike('txn_id', $searchValue)
            ->where('userid', $userid)
            ->orderBy('createDate','DESC')
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1+$start;
       foreach($records as $record )
       {
           if($record['paymentStatus']=='Paid')
           {
              $status='<span class="status confirm" >Paid</span>';
           }
           if($record['paymentStatus']=='unpaid')
           {
               $status='<span class="status failed" >Unpaid</span>';
           }

               $date=date("d-m-Y H:i:s",strtotime($record['createDate']));
               
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$record['orderid'],
             "txn_id"=>$record['txn_id'],
             "paymentStatus"=>$status,
             "payment_gross"=>number_format($record['payment_gross'],2),
             "createDate"=>$date,
            ); 
            $i++;
       }
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    
    }
    
    public function Getfailedorders()
    {
        if(!isset($this->session->user))
        {
           return false; 
        }
        
       $user=$user= $_SESSION['user'];
       $userid=$user['id'];
       $request = service('request');
       $postData = $request->getPost();
       $dtpostData = $postData['data'];
       $response = array();
       ## Read value
       $draw = $dtpostData['draw'];
       $start = $dtpostData['start'];
       $rowperpage = $dtpostData['length']; // Rows display per page
    //   $columnIndex = $dtpostData['order'][0]['column']; // Column index
    //   $columnName = $dtpostData['columns'][$columnIndex]['data']; // Column name
    //   $columnSortOrder = $dtpostData['order'][0]['dir']; // asc or desc
       $searchValue = $dtpostData['search']['value']; // Search value
       
       ## Total number of records without filtering
       $totalRecords = $this->db->table('masterorders')
                     ->select('id')
                     ->where('userid', $userid)
                     ->where('status', 'failed')
                     ->where('orderStatus', 1)
                     ->countAllResults();

       ## Total number of records with filtering
       $totalRecordwithFilter = $this->db->table('masterorders')
                                ->select('id')
                                ->where('userid', $userid)
                                ->where('status', 'failed')
                                ->Like('orderid', $searchValue)
                                ->where('orderStatus', 1)
                                ->countAllResults();

       ## Fetch records
       $records = $this->db->table('masterorders')
            ->select('*')
            ->Like('orderid', $searchValue)
            ->where('userid', $userid)
            ->where('status', 'failed')
            ->where('orderStatus', 1)
            ->orderBy('orderdate','DESC')
            ->limit($rowperpage, $start)
            ->get()->getResultArray();

       $data = array();
        $i=1+$start;
       foreach($records as $record )
       {
            $action='';
           if($record['status']=='confirm')
           {
               $status='<span class="status confirm" >Confirm</span>';
               
           }
           elseif($record['status']=='pending')
           {
               $status='<span class="status pending" >Pending</span>';
               
           }
		   else
		  {
			$status=$record['status'];
			$GetStatusDetail=$this->HomeModel->GetStatusDetail($status);
			if($GetStatusDetail)
			{
				$orderStatus=$GetStatusDetail['status_title'];
			}	
			else
			{
				$orderStatus=$record['status'];
			}
			  $status='<span class="status confirm" >'.$orderStatus.'</span>';
              
		  }
				$action.='<span class="action-buttons" style="display: flex;  gap: 3px; justify-content: flex-start; flex-wrap: nowrap;    flex-direction: row;">';
				$action.='<a href="javascript:void(0)" style="color:white;" data-orderid="'.$record['orderid'].'" class="view-record orderview">';
				$action.='<span title="View Order" class="view-button btn btn-info">';
				$action.='<i class="fa fa-eye"></i>';
				$action.='</span></a>';
				
			if($record['invoice']!='')
			{					
			    $action.='<a href="'.base_url().'invoice/'.$record['orderid'].'" style="color:white;" data-orderid="'.$record['orderid'].'" class="view-record">';
				$action.='<span title="View Invoice" class="view-button btn btn-success">';
				$action.='<i class="fa fa-file-pdf-o"></i>';
				$action.='</span></a>';
			}
             $action.='</span">';
          
          
             $date=date("d-m-Y H:i:s",strtotime($record['orderdate']));
             $orderid=$record['orderid'];
			 
			 $billingAddress=$this->HomeModel->GetbillingAddress($orderid,$userid);  
			 $trackingStatus='';
			 if($record['tracking_id']!='')
			 {
				 $trackingDetails=$this->HomeModel->GettrackingDetails($orderid,$userid);  
				 if(isset($trackingDetails))
				 {
					 
					 $trackingStatus='<p style="display: flex;flex-direction: column;"><span style="background: #91c991;
						color: white;
						text-align: center;
						font-size: 13px;
						border-radius: 14px;
					">'.$trackingDetails['tracking_id'].'
					
					</span><span style="text-align: center;"><a style="text-align: center;
						font-size: 11px;
					"href="'.$trackingDetails['order_tracking_link'].'" target="_blank"><i class="fa fa-truck"></i> Track Order</a></span></p>';
				}
				 else
				 {
					$trackingStatus='-';  
				 }
			 }
			 else
			 {
				$trackingStatus='-'; 
			 }
			 $orderid=$record['orderid'];
			 $OrderReview=$this->HomeModel->orderReview($orderid,$userid); 
			 if($OrderReview)
			 {
			     $rate=$OrderReview['rate'];
			 }
			 else
			 {
			     $rate=0;
			 }
			 $orderidview='';
			 $orderidview.='<span>'.$record['orderid'].'</span>';
			 
			 $orderdeliveredstatus=$this->HomeModel->orderdeliveredstatus($orderid,$userid);
			 if($orderdeliveredstatus)
			 {
			 $orderidview.='<div class="rate orderreview orderreview_'.$orderid.'"  data-orderid="'.$orderid.'">';
			 if($rate>=1){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star1'.$orderid.'" title="1 star">1 star</label>';
             if($rate>=2){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star2'.$orderid.'" title="2 star">2 star</label>';
             if($rate>=3){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star3'.$orderid.'" title="3 star">3 star</label>';
              if($rate>=4){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star4'.$orderid.'" title="4 star">4 star</label>';
             if($rate>=5){ $checkclass="checkedstar"; } else { $checkclass="";}
             $orderidview.='<label class="'.$checkclass.'" for="star5'.$orderid.'" title="5 star">5 star</label>';
             $orderidview.='</div>';
			 }
			 
			 if($billingAddress)
			 {
			     $billname=trim($billingAddress['first_name'].' '.$billingAddress['last_name']);
			 }
			 else
			 {
			     $billname='';
			 }
          $data[] = array( 
             "sr"=>$i.'.',
             "orderid"=>$orderidview,
			 "billname"=>$billname,
             "ShippingDate"=>$record['shipping_date'],
             "amount"=>$record['currency']." ".number_format($record['total_amount'],2),
             "status"=>$status,
			 "tracking_id"=>$trackingStatus,
             "orderdate"=>$date,
             "action"=>$action,
            ); 
            $i++;
       }
	   
       ## Response
       $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data,
       );
       return $this->response->setJSON($response);
    }
    
    public function ShowOrderDetail()
    {
        if(!isset($this->session->user))
        {
           return false; 
        }
        
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $orderno = $this->request->getVar('orderno');
        
        $orderDetail=$this->HomeModel->orderDetail($orderno,$userid);
        if(isset($orderDetail))
        {
            $orderid=$orderDetail['orderid'];
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
            $page=1;
            $count=5;
            
            $data['Invoicessummary']=$this->HomeModel->Invoicessummary($orderid,$userid);
             $orderdeliveredstatus=$this->HomeModel->orderdeliveredstatus($orderid,$userid);
            $data['orderdeliveredstatus']=$orderdeliveredstatus;
			$paymentDetail=$this->HomeModel->GetpaymentDetail($orderid,$userid);
            $shippingAddress=$this->HomeModel->GetshippingAddress($orderid,$userid);
            $billingAddress=$this->HomeModel->GetbillingAddress($orderid,$userid);
            $data['paymentDetail']=$paymentDetail;
            $data['shippingAddress']=$shippingAddress;
            $data['billingAddress']=$billingAddress; 
          return view('ordertemplate/template',$data);
        }
        else
        {
            echo "failed";
            return ;
        }
    }
    
    public function MoreOrderItems()
    {
        if(!isset($this->session->user))
        {
           return false; 
        }
        
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $orderno = $this->request->getVar('orderno');
        $page = $this->request->getVar('page');
        $orderDetail=$this->HomeModel->orderDetail($orderno,$userid);
        if(isset($orderDetail))
        {
            $orderid=$orderDetail['id'];
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
            $count=5;
            $Invoicessummary=$this->Api->Invoicessummary($masterId,$page,$count);
            $InvoicessummaryData=array();
            if($Invoicessummary)
            {
                if($Invoicessummary->success==true && $Invoicessummary->message=="Success")
                {
                    $InvoicessummaryData=$Invoicessummary->data;
                    if(isset($InvoicessummaryData))
                    {
                        foreach($InvoicessummaryData as $row)
                        {
                            ?>
                            
                            <tr>
                             <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: left;" align="left">
                              <img style="width:50px;"src="<?=settings('product_thumbnail_url')?><?=$row->image?>"
                              </td>
                              <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #ff0000;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: left;" class="article" align="left">
                                <?php
                                if(!empty($row->name))
                                {
                                   echo  $row->name;
                                }
                                else
                                {
                                   echo  $row->description;
                                }
                                ?>
                              </td>
                              <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->metal?></small></td>
                              <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #646a6e;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->gwt?></small></td>
                              <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->nwt?></small></td>
                              <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: center;" align="left"><small><?=$row->pcs?></small></td>
                              <td style="font-size: 12px; font-family: 'Open Sans', sans-serif; color: #1e2b33;  line-height: 18px;  vertical-align: top; padding:10px 0; text-align: right;" align="right"><?=$orderDetail['currency']?> <?=$row->price?></td>
                            </tr>
                            <tr>
                              <td height="1" colspan="7" style="border-bottom:1px solid #e4e4e4"></td>
                            </tr>
                            <?php
                        }
                        
                    }
                    else
                    {
                        echo "notdfound";
                        return ;
                    }
                }
                else
                {
                    echo "notdfound";
                    return ;
                }
            }
            else
            {
                echo "failed";
                return ;
            }

        }
        else
        {
            echo "failed";
            return ;
        }
    }
    
    public function ShowOrderItemReview()
    {
        if(!isset($this->session->user))
        {
           return false; 
        }
        
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $productid = $this->request->getVar('productid');
        $orderid = $this->request->getVar('orderid');
        $orderItemDetail=$this->HomeModel->orderItemDetail($orderid,$userid,$productid);
        if($orderItemDetail)
        {
            ?>
            <div class="wrapper">
                  <div class="master">
                    <h1>Product Review And Rating</h1>
                    <h2>How was your experience about our product?</h2>
                <form action="javascript:void(0);" style="width: -webkit-fill-available;text-align:center;"  class="bookAppointment-form" name="productreview_form" id="productreview_form" method="post" accept-charset="utf-8">

                    <div class="rating-component">
                      <div class="status-msg">
                        <label>
                            <input  class="rating_msg" type="hidden" name="rating_msg" value=""/>
                        </label>
                      </div>
                      <div class="stars-box">
                        <i class="star fa fa-star" title="1 star" data-message="Poor" data-value="1"></i>
                        <i class="star fa fa-star" title="2 stars" data-message="Too bad" data-value="2"></i>
                        <i class="star fa fa-star" title="3 stars" data-message="Average quality" data-value="3"></i>
                        <i class="star fa fa-star" title="4 stars" data-message="Nice" data-value="4"></i>
                        <i class="star fa fa-star" title="5 stars" data-message="very good qality" data-value="5"></i>
                      </div>
                      <div class="starrate">
                        <label>
                            <input  class="ratevalue" type="hidden" name="rate_value" value=""/>
                        </label>
                      </div>
                    </div>
                
                    <div class="feedback-tags">
                      <div class="tags-container" data-tag-set="1">
                        <div class="question-tag">
                          Why was your experience so bad?
                        </div>
                      </div>
                      <div class="tags-container" data-tag-set="2">
                        <div class="question-tag">
                          Why was your experience so bad?
                        </div>
                
                      </div>
                
                      <div class="tags-container" data-tag-set="3">
                        <div class="question-tag">
                          Why was your average rating experience ?
                        </div>
                      </div>
                      <div class="tags-container" data-tag-set="4">
                        <div class="question-tag">
                          Why was your experience good?
                        </div>
                      </div>
                
                      <div class="tags-container" data-tag-set="5">
                        <div class="make-compliment">
                          <div class="compliment-container">
                            Give a compliment
                            <i class="far fa-smile-wink"></i>
                          </div>
                        </div>
                      </div>
                      
                      <div class="tags-box">
                        <textarea  class="tag form-control" name="comment" id="inlineFormInputName" placeholder="please enter your review"></textarea>
                        <input type="hidden" name="productid" value="<?=$productid?>" />
                        <input type="hidden" name="orderid" value="<?=$orderid?>" />
                      </div>
                      
                    </div>
                
                    <div class="button-box">
                      <input type="button" class=" done btn btn-warning" disabled="disabled" value="Submit Review" />
                    </div>
                
                    <div class="submited-box" style="display: flex;    justify-content: center;">
                      <div class="loader"></div>
                      <div class="success-message">
                        Thank you!
                      </div>
                    </div>
                  </div>
                
                </div>
            <?php
        }
        else
        {
            return false; 
        }
    }
    
    public function ShowOrderReview()
    {
        if(!isset($this->session->user))
        {
           return false; 
        }
        
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $orderid = $this->request->getVar('orderid');
        $orderDetail=$this->HomeModel->orderDetail($orderid,$userid);
        if($orderDetail)
        {
            ?>
            <div class="wrapper">
                  <div class="master">
                    <h1>Order Review And Rating</h1>
                    <h2>How was your experience about this order?</h2>
                <form action="javascript:void(0);" style="width: -webkit-fill-available;text-align:center;"  class="bookAppointment-form" name="orderreview_form" id="orderreview_form" method="post" accept-charset="utf-8">

                    <div class="rating-component">
                      <div class="status-msg">
                        <label>
                            <input  class="rating_msg" type="hidden" name="rating_msg" value=""/>
                        </label>
                      </div>
                      <div class="stars-box">
                        <i class="star fa fa-star" title="1 star" data-message="Poor" data-value="1"></i>
                        <i class="star fa fa-star" title="2 stars" data-message="Too bad" data-value="2"></i>
                        <i class="star fa fa-star" title="3 stars" data-message="Average quality" data-value="3"></i>
                        <i class="star fa fa-star" title="4 stars" data-message="Nice" data-value="4"></i>
                        <i class="star fa fa-star" title="5 stars" data-message="very good qality" data-value="5"></i>
                      </div>
                      <div class="starrate">
                        <label>
                            <input  class="ratevalue" type="hidden" name="rate_value" value=""/>
                        </label>
                      </div>
                    </div>
                
                    <div class="feedback-tags">
                      <div class="tags-container" data-tag-set="1">
                        <div class="question-tag">
                          Why was your experience so bad?
                        </div>
                      </div>
                      <div class="tags-container" data-tag-set="2">
                        <div class="question-tag">
                          Why was your experience so bad?
                        </div>
                
                      </div>
                
                      <div class="tags-container" data-tag-set="3">
                        <div class="question-tag">
                          Why was your average rating experience ?
                        </div>
                      </div>
                      <div class="tags-container" data-tag-set="4">
                        <div class="question-tag">
                          Why was your experience good?
                        </div>
                      </div>
                
                      <div class="tags-container" data-tag-set="5">
                        <div class="make-compliment">
                          <div class="compliment-container">
                            Give a compliment
                            <i class="far fa-smile-wink"></i>
                          </div>
                        </div>
                      </div>
                      
                      <div class="tags-box">
                        <textarea  class="tag form-control" name="comment" id="inlineFormInputName" placeholder="please enter your review"></textarea>
                        <input type="hidden" name="orderid" value="<?=$orderid?>" />
                      </div>
                      
                    </div>
                
                    <div class="button-box">
                      <input type="button" class=" done btn btn-warning" disabled="disabled" value="Submit Review" />
                    </div>
                
                    <div class="submited-box" style="display: flex;    justify-content: center;">
                      <div class="loader"></div>
                      <div class="success-message">
                        Thank you!
                      </div>
                    </div>
                  </div>
                
                </div>
            <?php
        }
        else
        {
            return false; 
        }
    }
    
    public function productReviewsubmit()
    {
        if(!isset($this->session->user))
        {
           $return=array(
               'status'=>false,
               'message'=>'Not Authorizedy'
               );
           echo json_encode($return); 
           return;
        }
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $productid = $this->request->getVar('productid');
        $orderid = $this->request->getVar('orderid');
        $rate_value = $this->request->getVar('rate_value');
        $comment = $this->request->getVar('comment');
        $orderItemDetail=$this->HomeModel->orderItemDetail($orderid,$userid,$productid);
        
        if($orderItemDetail)
        {
            $reviewdata=array(
                'orderid'=>$orderid,
                'userid'=>$userid,
                'productid'=>$productid,
                'rate'=>$rate_value,
                'comment'=>$comment,
                );
                
            $orderItemReview=$this->HomeModel->orderItemReview($orderid,$userid,$productid);
            if($orderItemReview)
            {
                $reviewdata['updatedate']=date("Y-m-d H:i:s");
                $this->HomeModel->orderitemreviewupdate($reviewdata,$orderid,$userid,$productid); 
            }
            else
            {
                $reviewdata['createdate']=date("Y-m-d H:i:s");
                $reviewdata['status']=1;
                $this->HomeModel->orderitemreviewSubmit($reviewdata); 
            }
            
            $return=array(
               'status'=>true,
               'reviewdata'=>$reviewdata,
               'message'=>'Thank you! Review successfully submit.'
               );
           echo json_encode($return); 
           return;
        }
        else
        {
           $return=array(
               'status'=>false,
               'message'=>'Not Authorizedy for this product.'
               );
           echo json_encode($return); 
           return;
        }
        
    }
    
    public function orderReviewsubmit()
    {
        if(!isset($this->session->user))
        {
           $return=array(
               'status'=>false,
               'message'=>'Not Authorizedy'
               );
           echo json_encode($return); 
           return;
        }
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $orderid = $this->request->getVar('orderid');
        $rate_value = $this->request->getVar('rate_value');
        $comment = $this->request->getVar('comment');
        $orderDetail=$this->HomeModel->orderDetail($orderid,$userid);
        
        if($orderDetail)
        {
            $reviewdata=array(
                'orderid'=>$orderid,
                'userid'=>$userid,
                'rate'=>$rate_value,
                'comment'=>$comment,
                );
                
            $orderReview=$this->HomeModel->orderReview($orderid,$userid);
            if($orderReview)
            {
                $reviewdata['updatedate']=date("Y-m-d H:i:s");
                $this->HomeModel->orderreviewupdate($reviewdata,$orderid,$userid); 
            }
            else
            {
                $reviewdata['createdate']=date("Y-m-d H:i:s");
                $reviewdata['status']=1;
                $this->HomeModel->orderreviewSubmit($reviewdata); 
            }
            
            $return=array(
               'status'=>true,
               'reviewdata'=>$reviewdata,
               'message'=>'Thank you! Review successfully submit.'
               );
           echo json_encode($return); 
           return;
        }
        else
        {
           $return=array(
               'status'=>false,
               'message'=>'Not Authorizedy for this product.'
               );
           echo json_encode($return); 
           return;
        }
        
    }
	
	public function orderInvoicePDF()
	{
        $user=$user= $_SESSION['user'];
        $userid=$user['id'];
        $orderno = 'ORDER000001';
        
        $orderDetail=$this->HomeModel->orderDetail($orderno,$userid);
	    //print_r($orderDetail);
        //die;
        if(isset($orderDetail))
        {
            $orderid=$orderDetail['orderid'];
            $data=array();
            $data['order']=$orderDetail;
            $masterId=$orderDetail['masterID'];
			$data['Invoicessummary']=$this->HomeModel->Invoicessummary($orderid,$userid);
			$paymentDetail=$this->HomeModel->GetpaymentDetail($orderid,$userid);
            $shippingAddress=$this->HomeModel->GetshippingAddress($orderid,$userid);
            $data['paymentDetail']=$paymentDetail;
            $data['shippingAddress']=$shippingAddress;
            $data['billingAddress']=$billingAddress; 
			//print_r($data['billingAddress']);
			//die;
			$datainvoice=view('ordertemplate/order_invoice',$data);
			// reference the Dompdf namespace
			// instantiate and use the dompdf class
			
			$dompdf = new DOMPDF();

			$i = 0;
			$dompdf->loadHtml($datainvoice);
			$dompdf->render();
			while(file_exists("public/orders/pdf/" . $orderid . ".pdf")) {
			}
			file_put_contents("public/orders/pdf/" . $orderid . ".pdf", $dompdf->output());
		}
	
	}
	
	public function GenerateInvoice($orderid)
	{
		if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
		
		$orderDetail=$this->OrderModel->orderDetail($orderid);
        if(isset($orderDetail))
        {
			$user=$_SESSION['user'];
            $userid=$user['id'];
			if($orderDetail['invoiceno']!='' && $orderDetail['userid']==$userid)
			{
				$orderid=$orderDetail['orderid'];
				$userid=$orderDetail['userid'];	
				$invoiceNo=$orderDetail['invoiceno'];
				$data=array();
				$data['order']=$orderDetail;
				$masterId=$orderDetail['masterID'];
				$data['Invoicessummary']=$this->HomeModel->Invoicessummary($orderid,$userid);
				$paymentDetail=$this->HomeModel->GetpaymentDetail($orderid,$userid);
				$shippingAddress=$this->HomeModel->GetshippingAddress($orderid,$userid);
				$billingAddress=$this->HomeModel->GetbillingAddress($orderid,$userid);
				$data['paymentDetail']=$paymentDetail;
				$data['invoiceNo']=$invoiceNo;
				$data['shippingAddress']=$shippingAddress;
				$data['billingAddress']=$billingAddress; 
				//print_r($data['billingAddress']);
				//die;
				$datainvoice=view('ordertemplate/order_invoice',$data);
				// reference the Dompdf namespace
				// instantiate and use the dompdf class
				$dompdf = new DOMPDF();
				$dompdf->loadHtml($datainvoice);
				$dompdf->render();	
				$dompdf->stream($invoiceNo . ".pdf");	
			}
			else
			{
				return redirect()->to('my-account/orders'); 
			}	
		}
		else
		{
			return redirect()->to('my-account/orders'); 
		}
	
	}

	
	public function checklogout()
	{
	    if(isset($this->session->user))
	    {
	        $user=$_SESSION['user'];
            $userid=$user['id'];
            $userdetail=$this->HomeModel->GetLogoutUserDetail($userid);
	        $session_password=$user['password'];
	        $userpassword=$userdetail['password'];
	        if($session_password!=$userpassword)
	        {
	                    $cartguestid='';
                        if(isset($this->session->cartguestid))
                        {
                            $cartguestid=$_SESSION['cartguestid'];
                        }
                        $this->cartexicute($type='logout');
                        $this->session->remove('user');
                        $this->session->remove('referralcode');
                        if($cartguestid=='')
                        {
                            $cartguestid=$this->cartguestid();
                        }
                        else
                        {
                            $cartguestid=$this->cartguestid($cartguestid);
                        }
                        return redirect()->to('login');
	        }
	    }
	}

      public function GetMainorders()
{
    if (!isset($this->session->user)) {
        return false;
    }
    
    $user = $_SESSION['user'];
    $userid = $user['id'];
    $request = service('request');
    $postData = $request->getPost();
    
    // Check if 'data' exists in the post request
    if (!isset($postData['data'])) {
        return $this->response->setJSON(['error' => 'Missing data parameter']);
    }
    
    $dtpostData = $postData['data'];
    $response = array();

    // Read values
    $draw = isset($dtpostData['draw']) ? $dtpostData['draw'] : 0;
    $start = isset($dtpostData['start']) ? $dtpostData['start'] : 0;
    $rowperpage = isset($dtpostData['length']) ? $dtpostData['length'] : 10; // Default to 10 if length is not provided
    $searchValue = isset($dtpostData['search']['value']) ? $dtpostData['search']['value'] : ''; // Default to empty if no search value

    // Fetch orders based on search
    $records = $this->db->table('masterorders')
        ->select('*')
        ->like('orderid', $searchValue)
        ->where('userid', $userid)
        ->where('orderStatus', 1)
        ->groupStart()
        ->where('status !=', 'cancelled')
        ->orWhere('status !=', 'pending')
        ->groupEnd()
        ->orderBy('orderdate', 'DESC')
        ->limit($rowperpage, $start)
        ->get()
        ->getResultArray();
     
    $html = '';
    //print_r($records); die;
    foreach ($records as $record) {
        	$status=$record['status'];
       	$GetStatusDetail=$this->HomeModel->GetStatusDetail($status);
       	$showTrackButton = (
    ($record['status'] === 'delivered' || $record['status'] === 'pending' || $record['status'] === 'shipped' || $record['status'] === 'confirmed' || $record['status'] === 'cancelled')
);
       
       		if($GetStatusDetail)
			{
	    	$orderStatus=$GetStatusDetail['status_title'];
	        }	
			else
	     	{
	    	$orderStatus=$record['status'];
	    	}
        $orderid = $record['orderid'];
        $trackerprogress=$this->tracker($orderid);
        $trackingStatus = '-';
        $billingAddress = $this->HomeModel->GetbillingAddress($orderid, $userid);  
        //print_r($billingAddress); die;
        $date = date("d-m-Y H:i:s", strtotime($record['orderdate']));

        $shippingAddress = $this->HomeModel->GetshippingAddress($orderid, $userid);
        //print_r($shippingAddress);die;
          $showInvoiceButton = ($record['status'] == 'delivered' && !empty($record['invoiceno']));
        $html .= '
        <div class="order-card">
           <div class="order-header d-flex justify-content-between align-items-start" style="display: flex; justify-content: space-between; align-items: start;">
    <div>
        <div><strong>Order ID:</strong> #' . esc($orderid) . '</div>
        <div><strong>Order Date:</strong> ' . date('M d, Y', strtotime($record['orderdate'])) . '</div>
        <div><strong>Status:</strong> <span class="status">' . esc(ucfirst($orderStatus)) . '</span></div>
    </div>';
     if ($showTrackButton) {
    $html .= '
      <div class="progressmodelcontent" id="progressModalContent_' . esc($orderid) . '">
                <!-- Progress content will be populated dynamically here -->
            </div>';
     }
     $html .= '
    <div class="order-actions text-end order-action-buttons" style="text-align: right;">
        <a href="javascript:void(0)"  data-orderid="'.$record['orderid'].'" class="view-record orderview">View Details</a><br>';
        
         if ($showTrackButton) {
   
    $html .= '
        <a href="javascript:void(0)" class="track-order-button" 
            data-orderid="' . esc($orderid) . '">
           
        </a><br>';
}
          if ($showInvoiceButton) {
        $html .= '
                <a href="' . base_url("invoice/{$orderid}") . '" class=" mb-1" target="_blank">
            <i class="fa fa-file-pdf-o"></i> Invoice
        </a><br>';
                
    }
       
         // print_r($record);die;
        if (!empty($record['tracking_id'])) {
         
    $trackingDetails = $this->HomeModel->GettrackingDetails($orderid, $userid);
   

    if (!empty($trackingDetails) && !empty($trackingDetails['order_tracking_link'])) {
       
             $html .= ' 
        <a href="' . esc($trackingDetails['order_tracking_link']) . '" class="">' . esc($trackingDetails['tracking_id']) . '</a>';
    }
}
     
        
        
    $html .='
    </div>
</div>
            
            <div class="address-box">
                <strong>Shipping To:</strong><br>
                ' . esc($shippingAddress['first_name'].' '.$shippingAddress['last_name']) . '<br>
                ' . esc($shippingAddress['address1']) . ',<br>
                ' . esc($shippingAddress['city']) . ', ' . esc($shippingAddress['zipcode']) . '<br>
                ' . esc($shippingAddress['countryname']) . '
            </div>
            
            <!-- Product List -->
            <div class="product-list">
        ';
        
        // Get order items
        $items = $this->HomeModel->Invoicessummary($orderid, $userid);  // assuming you have a method for order items
        
       
         
        if (!empty($items)) {
           foreach ($items as $item) {
               	//$getproductdetails=$this->HomeModel->getProductWithCategory($item['productid']);

             //print_r($getproductdetails);die;   
    // Check if return button should be shown
    $showReturnButton = ($record['status'] === 'delivered' && empty($item['return_status']));


    $html .= '
        <div class="product">
            <img src="' . settings('product_thumbnail_url') . $item['image'] . '" alt="Product Image">
            <div class="product-details">
                <h4><a href="#">' . esc($item['productname']) . '</a></h4>
                <p>Qty: ' . esc($item['pcs']) . ' | ' . esc($item['sizename']) . '</p>
                <p>Price: ₹' . number_format($item['price'], 2) . '</p>
            </div>
            <div class="product-actions">';
              $secret = env('SECRET_KEY');
$secure_token = hash_hmac('sha256', $orderid . esc($item['productid']) . $userid, $secret);

    if ($showReturnButton) {
        $html .= '
                <button class="return-button btn" 
                    data-productid="' . esc($item['productid']) . '"
                    data-orderid="' . esc($orderid) . '"
                    data-quantity="' . esc($item['pcs']) . '"
                    data-token="'.$secure_token.'">
                    Return
                </button>';
    }else{
         $html .= '
                 <div class="mb-1"><strong>Return status:</strong> <span class="status">' . esc(ucfirst($item['return_status'])) . '</span></div>
            ';
    }

    $html .= '
                <button type="button" class="btn orderreview orderreview_' . esc($orderid) . '" data-orderid="' . esc($orderid) . '">Write a product review</button>
         
    ';
   

     $html .= '
                
            </div>
        </div>
    ';
    
  
}

        } else {
            $html .= '<p>No items found in this order.</p>';
        }
        
        $html .= '</div></div>';
    }

    // Return HTML response
    return $this->response->setJSON(['html' => $html]);
}
  
 public function tracker($orderId)
{
    // Get the order status history for the given orderid
    $orderProgress = $this->OrderModel->getOrderStatusHistory($orderId);
    
    // Get all possible statuses (you can fetch them from the orderstatus table)
    $totalStatuses = $this->OrderModel->getorderStatus();

    // Initialize the $relevantStatuses array (default is for confirmed orders)
    $relevantStatuses = ['pending', 'confirmed', 'shipped', 'delivered'];

    // Calculate how many steps are completed
    $completedSteps = [];

    foreach ($orderProgress as $status) {
        $completedSteps[] = $status['status'];
    }

    // Modify the relevantStatuses array based on completed steps
    if (in_array('cancelled', $completedSteps)) {
        // If 'cancelled' is found, show "Pending", "Cancelled", "Refunded"
        $relevantStatuses = ['pending', 'cancelled', 'refunded'];
    } elseif (in_array('confirmed', $completedSteps) && in_array('cancelled', $completedSteps)) {
        // If both 'confirmed' and 'cancelled' are found, show "Pending", "Confirmed", "Cancelled", "Refunded"
        $relevantStatuses = ['pending', 'confirmed', 'cancelled', 'refunded'];
    } elseif (in_array('confirmed', $completedSteps)) {
        // If only 'confirmed' is found, show "Pending", "Confirmed", "Shipped", "Delivered"
        $relevantStatuses = ['pending', 'confirmed', 'shipped', 'delivered'];
    }

    // Filter to include only relevant statuses (pending, confirmed, shipped, delivered, cancelled, refunded)
    $filteredStatuses = array_filter($totalStatuses, function($status) use ($relevantStatuses) {
        return in_array($status['slug'], $relevantStatuses);
    });

    // Re-index the filtered statuses array (as array_filter preserves keys)
    $filteredStatuses = array_values($filteredStatuses);

    // Return the response with the relevant statuses and completed steps
    return $this->response->setJSON([
        'progress' => $orderProgress,
        'totalStatuses' => $filteredStatuses,
        'completedSteps' => $completedSteps,
    ]);
}
  
/* Get product metal price  */
   
  public function Getproduct_metalprice()
    {
        if($this->request->getPost('productcode') && $this->request->getPost('metalid'))
        {
          $productcode= $this->request->getPost('productcode');
         $metalid = $this->request->getPost('metalid');
                $result=$this->HomeModel->getProductmetalprice($productcode, $metalid);
                if(isset($result) && count($result)>=1)
                {
                    $response=array(
                        'status'=>true,
                        'data'=>$result,
                        );  
                    echo json_encode($response); 
                }
                else
                {
                    $response=array(
                        'status'=>false
                        );  
                    echo json_encode($response); 
                }
           
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }
/* Ended get products metal price */

/* Get product stone price  */
   
  public function Getproduct_stoneprice()
    {
        if($this->request->getPost('stoneid'))
        {
          $stoneid= $this->request->getPost('stoneid');
          $shapeid= $this->request->getPost('shapeid');
           $qualityid= $this->request->getPost('qualityid');
            $colorid= $this->request->getPost('colorid');
            $sizeid= $this->request->getPost('sizeid');
        
                $result=$this->HomeModel->getproductstoneprice($stoneid, $shapeid, $qualityid, $colorid, $sizeid);
                if(isset($result) && count($result)>=1)
                {
                    $response=array(
                        'status'=>true,
                        'data'=>$result,
                        );  
                    echo json_encode($response); 
                }
                else
                {
                    $response=array(
                        'status'=>false
                        );  
                    echo json_encode($response); 
                }
           
        }
        else
        {
            $response=array(
                    'status'=>false
                    );  
                echo json_encode($response); 
        }
    }
/* Ended get products stone price */

public function returnProduct()
{
    if (!isset($this->session->user)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Not Authorized'
        ]);
    }

    $user = $this->session->get('user');
    $userid = $user['id'];

    $items = $this->request->getVar('items');
    if (!$items || !is_array($items)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'No items submitted'
        ]);
    }

    $errors = [];
    foreach ($items as $key => $item) {
      
        $product_id = $item['productid'] ?? null;
        $orderid = $item['orderid'] ?? null;
        $return_quantity = $item['return_quantity'] ?? null;
        $reason = $this->request->getVar('reason') ?? null;
        $token = $item['token'] ?? null;
        $secret = env('SECRET_KEY');
        $expected_token = hash_hmac('sha256', $orderid . $product_id . $userid, $secret);
if ($token !== $expected_token) {
    return $this->response->setJSON([
        'status' => false,
        'message' => 'Invalid or tampered request.'
    ]);
}
        // Inline validation
        if (!$product_id || !$orderid || !$return_quantity || !$reason || strlen($reason) < 3) {
            $errors[$product_id] = "Invalid input for product ID {$product_id}.";
            continue;
        }

        // Check order item existence
        $orderItem = $this->HomeModel->orderItemDetail_With_Return($orderid, $userid, $product_id);
        if (!$orderItem || $return_quantity > $orderItem['pcs']) {
            $errors[$product_id] = "Invalid product or return quantity for product ID {$product_id}.";
            continue;
        }
        
        // Check if return already requested
        if (!empty($orderItem['return_status']) && $orderItem['return_status'] !== 'none') {
            $errors[$pid] = "Return already requested for product ID {$product_id}.";
            continue;
        }
     $actual_qty = (int)$orderItem['pcs'];
     
     if ($return_quantity > $actual_qty) {
        $errors[$pid] = "Invalid return quantity.";
        continue;
    }
        // Save return request
        $returndata = [
            'orderid'         => $orderid,
            'product_id'      => $product_id,
            'return_quantity' => $return_quantity,
            'reason'          => $reason,
            'return_status'   => 'requested'
        ];
        $this->HomeModel->orderitemreturnSubmit($returndata);

        // Update item return status
        $this->HomeModel->markItemReturned($orderid, $userid, $product_id);
    }

    if (!empty($errors)) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Some items could not be processed.',
            'errors' => $errors
        ]);
    }

    return $this->response->setJSON([
        'status' => true,
        'message' => 'Return request submitted successfully.'
    ]);
}

}
