<?php
namespace App\Controllers;
use App\Models\HomeModel;
use App\Models\PaypalModel;
use App\Libraries\Paypal_lib;
use App\Controllers\BaseController;
class Paypal extends BaseController
{
     public function __construct()
     {
        $this->session = \Config\Services::session(); 
        $this->Api = new Api(); 
        $this->paypal_lib = new Paypal_lib();
        $this->PaypalModel = new PaypalModel(); 
        $this->HomeModel = new HomeModel(); 
        $this->apiURL = 'https://jeweal.tiarasoftwares.com/';
        if(!isset($this->session->language))
        {
           $language='en';
           $this->session->set('language',$language); 
        }
        
    }
    
    public function payment()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        $user= $_SESSION['user'];
        $Customerid=$user->id;
        
        $order_id = time() . mt_rand() . $Customerid;
        $saveOrderdata=$this->saveOrderdata($order_id);
        if($saveOrderdata==true)
        {
            $websettings=websettings();
            $returnURL = base_url().'success'; 
            $failURL = base_url().'failed'; 
            $notifyURL = base_url().'paypal/ipn';
            $userID = $Customerid; 
            $logo = base_url().$websettings['logo'];
            $OrderDetails=$this->PaypalModel->GetOrderDetails($order_id);
            $OrderAmount=0;
                if($OrderDetails)
                {
                    $OrderAmount=$OrderDetails['total_amount'];
                }
                else
                {
                    $this->session->set('failedmsg',"Order Not Created. Please Try Again."); 
                    return redirect()->to("/failed");
                }
             
            $this->paypal_lib->add_field('return', $returnURL);
            $this->paypal_lib->add_field('fail_return', $failURL);
            $this->paypal_lib->add_field('notify_url', $notifyURL);
            $this->paypal_lib->add_field('item_name', "New order");
            $this->paypal_lib->add_field('custom', $userID);
            $this->paypal_lib->add_field('item_number',  $order_id);
            $this->paypal_lib->add_field('amount',  $OrderAmount);    
            $this->paypal_lib->add_field('currency_code', settings('currency_code')); 
            $this->paypal_lib->add_field('quantity', 1); 
            $this->paypal_lib->image($logo);
            $this->paypal_lib->paypal_auto_form();
        }    
        else
        {
            $this->session->set('failedmsg',"Order Not Create! Please Try Again");
            return redirect()->to("/failed");
        }
    }
    
    public function saveOrderdata($order_id)
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        $user= $_SESSION['user'];
        $Customerid=$user->id;
        $saveshippingaddress=$this->saveshippingaddress($order_id);
        if($saveshippingaddress==true)
        {
            $savebillingaddress=$this->savebillingaddress($order_id);
            if($savebillingaddress==true)
            {
                $saveorderItems=$this->saveorderItems($order_id);
                if($saveorderItems==true)
                {
                    $savemasterorder=$this->savemasterorder($order_id);
                    if($savemasterorder==true)
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    
    public function saveshippingaddress($order_id)
    {
        $user= $_SESSION['user'];
        $Customerid=$user->id;
        if(isset($_SESSION['shippingdetail']))
        {
            if($_SESSION['shippingdetail']['shippingaddress']=="newaddress")
            { 
                if(isset($_SESSION['shippingaddress']))
                {
                    $address=$_SESSION['shippingaddress'];
                    if(isset($address))
                    {
                        $dataShippingaddress=array(
                        'orderid'=>$order_id,
                        'userid'=>$Customerid,
                        'first_name'=>$address['first_name'],
                        'last_name'=>$address['last_name'],
                        'add1'=>$address['add1'],
                        'add2'=>$address['add2'],
                        'city'=>$address['city'],
                        'zip'=>$address['zip'],
                        'countryid'=>$address['countryid'],
                        'countryname'=>$address['countryname'],
                        'regionid'=>$address['regionid'],
                        'regionname'=>$address['regionname'],
                        'mobile'=>$address['mobile'],
                        'phone_code'=>$address['phone_code'],
                        'emailid'=>$address['emailid'],
                        'addresstype'=>"shipping",
                        );
                    }
                }
            }
            else
            {
                $shippingaddressId=base64_decode($_SESSION['shippingdetail']['shippingaddress']);
                $user= $_SESSION['user'];
                $Customerid=$user->id;
                $address=$this->HomeModel->editaddress($Customerid,$shippingaddressId);
                if(isset($address))
                {
                    $dataShippingaddress=array(
                        'orderid'=>$order_id,
                        'userid'=>$Customerid,
                        'first_name'=>$address['first_name'],
                        'last_name'=>$address['last_name'],
                        'add1'=>$address['add1'],
                        'add2'=>$address['add2'],
                        'city'=>$address['city'],
                        'zip'=>$address['zip'],
                        'countryid'=>$address['countryid'],
                        'countryname'=>$address['countryname'],
                        'regionid'=>$address['regionid'],
                        'regionname'=>$address['regionname'],
                        'mobile'=>$address['mobile'],
                        'phone_code'=>$address['phone_code'],
                        'emailid'=>$address['emailid'],
                        'addresstype'=>"shipping",
                        );
                        
                }
            }
                            //  $this->PaypalModel->deleteorderaddress($Customerid);
            return $responce=$this->PaypalModel->saveorderaddress($dataShippingaddress);
        }
    }
    
    public function savebillingaddress($order_id)
    {
        $user= $_SESSION['user'];
        $Customerid=$user->id;
        if(isset($_SESSION['billingaddress']))
        {
            $address=$_SESSION['billingaddress'];
            $dataShippingaddress=array(
                        'orderid'=>$order_id,
                        'userid'=>$Customerid,
                        'first_name'=>$address['first_name'],
                        'last_name'=>$address['last_name'],
                        'add1'=>$address['add1'],
                        'add2'=>$address['add2'],
                        'city'=>$address['city'],
                        'zip'=>$address['zip'],
                        'countryid'=>$address['countryid'],
                        'countryname'=>$address['countryname'],
                        'regionid'=>$address['regionid'],
                        'regionname'=>$address['regionname'],
                        'mobile'=>$address['mobile'],
                        'phone_code'=>$address['phone_code'],
                        'emailid'=>$address['emailid'],
                        'addresstype'=>"billing",
                        );
            return $responce= $this->PaypalModel->saveorderaddress($dataShippingaddress);            
        }
        
        
    }
    
    public function saveorderItems($order_id)
    {
            $user=$user= $_SESSION['user'];
            $customerid=$user->id;
            $carttype=1;
            $page=0;
            $count=0;
            // $this->PaypalModel->deleteorderitems($customerid);
           $cartdetail=$this->Api->Customerwishlist($customerid,$carttype,$page,$count);
           if($cartdetail->success==true)
           {
               if(isset($cartdetail->data))
               {
                    if(count($cartdetail->data)>0)
                    {
                        foreach($cartdetail->data as $cartproduct)
                        {
                            $dataorderitem=array(
                                        'orderid'=>$order_id,
                                        'userid'=>$customerid,
                                        'productid'=>$cartproduct->productid,
                                        'stockid'=>$cartproduct->stockid,
                                        'name'=>$cartproduct->name,
                                        'description'=>$cartproduct->description,
                                        'metal'=>($cartproduct->metal ?: ''),
                                        'size'=>(isset($cartproduct->size) ?: ''),
                                        'stone'=>(isset($cartproduct->stone) ?: ''),
                                        'engravtext'=>(isset($cartproduct->engravtext) ?: ''),
                                        'pcs'=>$cartproduct->pcs,
                                        'gwt'=>$cartproduct->gwt,
                                        'nwt'=>$cartproduct->nwt,
                                        'price'=>floatval(preg_replace('/[^\d.]/', '', $cartproduct->price))*floatval($cartproduct->pcs),
                                        'image'=>$cartproduct->image,
                                        );
                                        
                            $responce= $this->PaypalModel->saveorderitem($dataorderitem);   
                    }
                        return true;
                    }
                    else
                    {
                        return false;
                    }
               }    
               else
               {
                        return false;
                }
           }
           else
           {
                return false;
            }
    }
    
    public function savemasterorder($order_id)
    {
            $user=$user= $_SESSION['user'];
            $customerid=$user->id;
            $amountMaping=$this->GetamountMaping();
            if($amountMaping['subtotal']>0)
            {
                if(isset($amountMaping['coupon_amount']))
                {
                    $coupon_amount=$amountMaping['coupon_amount'];
                    $coupon_id=$amountMaping['coupon_id'];
                }
                else
                {
                    $coupon_amount=0;
                    $coupon_id='';
                }

                $dataorder=array(
                                    'orderid'=>$order_id,
                                    'userid'=>$customerid,
                                    'gross_amount'=>$amountMaping['subtotal'],
                                    'tax_amount'=>$amountMaping['totaltax'],
                                    'shipping_amount'=>$amountMaping['shippingAmount'],
                                    'coupon_amount'=>$coupon_amount,
                                    'coupon_id'=>$coupon_id,
                                    'total_amount'=>$amountMaping['totalpayamount'],
                                    'txn_id'=>'',
                                    'currency_code'=>settings('currency_code'),
                                    'currency'=>settings('currency'),
                                    'shippingmethod'=>$_SESSION['shippingdetail']['ShippingMethod'],
                                    'shippingname'=>$amountMaping['shipping_name'],
                                    'shipping_date'=>$amountMaping['shipping_date'],
                                    'tax_percent'=>$amountMaping['taxAmount'],
                                    );
                                    //   $this->PaypalModel->deletemasterorder($customerid);
                        return $responce= $this->PaypalModel->savemasterorder($dataorder);   
            }
            else
            {
                return false;
            }

    }
    
    public function GetamountMaping()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        
        $user= $_SESSION['user'];
        $Customerid=$user->id;
        $cartAmount=0;
        $taxAmount=settings('default_estimated_taxes');
        $tax_name="";
        
        $shipping_date="";
        $shipping_name="";
        $shippingAmount=0;
        $shippingdetail=$_SESSION["shippingdetail"];

        $shippingaddress=$shippingdetail['shippingaddress']; 
        $shippingmethod=$shippingdetail['ShippingMethod']; 
        if($shippingaddress=='newaddress')
        {
            $sess_shippingaddress=$_SESSION["shippingaddress"];
            $regionid=$sess_shippingaddress['regionid'];  
            $countryId=$sess_shippingaddress['countryidd']; 
        }
        else
        {
                $addressId=base64_decode($shippingaddress);
                $address=$this->HomeModel->editaddress($Customerid,$addressId);
                if(isset($address))
                {        
                    $regionid=$address['regionid'];  
                    $countryId=$address['countryid']; 
                }
        }
        if(isset($shippingmethod))
        {
            if($shippingmethod=='standered')
            {
                $shipping_name="Standered Delivery";
                $shippingAmount=settings('standard_delivery_amount');
                
                $currentdate=date("d-m-Y");
                $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.settings('standard_delivery_days').' days'));

                $shipping_date="Delivery by ".date("l d/m",strtotime($ShippingDate));
            }
            else
            {
                $shippingmethod=base64_decode($shippingmethod);
                $ShippingMethods=$this->HomeModel->GetShippingMethodId($shippingmethod);
                if(isset($ShippingMethods))
                {
                    if(count($ShippingMethods)>0)
                    {
                        if(isset(unserialize($ShippingMethods['shipping_name'])[$_SESSION['language']]))
                        {
                            $shipping_name=unserialize($ShippingMethods['shipping_name'])[$_SESSION['language']];
                        }
                        else
                        {
                            $shipping_name=unserialize($ShippingMethods['shipping_name'])['en'];
                        }
                        
                        $currentdate=date("d-m-Y");
                        $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.$ShippingMethods['days'].' days'));
                    
                        $shipping_date="Delivery by ".date("l d/m",strtotime($ShippingDate));
                        $shippingAmount=$ShippingMethods['shipping'];
                    }
            }
            }
        }
        
            $carttype=1;
            $page=0;
            $count=0;
            $cartTotalItem=0;
            $Customercartlist=$this->Api->Customerwishlist($Customerid,$carttype,$page,$count);
            if($Customercartlist->success==true)
            {
                if(isset($Customercartlist->data))
                {
                            if(count($Customercartlist->data)>0)
                            {
                                $cartTotalItem=count($Customercartlist->data);
                                foreach($Customercartlist->data as $product)
                                {
                                    $productPrice=floatval(preg_replace('/[^\d.]/', '', $product->price))*floatval($product->pcs);
                                    $cartAmount+=$productPrice;
                                }
                            }
                }            
            }
                        
        $taxamountData=$this->HomeModel->Gettaxamount($regionid,$countryId);                
        if(isset($taxamountData))
        {
            if(count($taxamountData)>0)
            {
                    if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
                    {
                        $tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
                    }
                    else
                    {
                        $tax_name=unserialize($taxamountData['tax_name'])['en'];
                    }
                    $taxAmount=$taxamountData['tax'];
            }
        }
        $totaltax=0;
        $totaltax=round(($taxAmount / 100) * $cartAmount,2);
        $totalpayamount=$cartAmount+$totaltax+$shippingAmount;
        
        $data=array(
            'subtotal'=>$cartAmount,
            'totalItem'=>$cartTotalItem,
            'tax_name'=>$tax_name,
            'taxAmount'=>$taxAmount,
            'totaltax'=>$totaltax,
            'shipping_name'=>$shipping_name,
            'shipping_date'=>$shipping_date,
            'shippingAmount'=>$shippingAmount,
            'totalpayamount'=>round($totalpayamount,2)
            );
            
        return $data;

    }
    
    public function ipn()
    {
        $paypalInfo = $this->request->getPost();
        if(isset($paypalInfo))
        {
            $userid=$paypalInfo['custom'];
            $orderid=$paypalInfo["item_number"];
            $txn_id=$paypalInfo["txn_id"];
            $data['userid'] = $paypalInfo['custom'];
            $data['orderid']    = $paypalInfo["item_number"];
            $data['txn_id']    = $paypalInfo["txn_id"];
            $data['payment_gross'] = $paypalInfo["mc_gross"];
            $data['currency_code'] = $paypalInfo["mc_currency"];
            $data['payer_email'] = $paypalInfo["payer_email"];
            $data['paymentgetwaystatus']    = $paypalInfo["payment_status"];
            $data['paymenttype']    = 'paypal';
     
            $paypalURL = $this->paypal_lib->paypal_url;        
            $result    = $this->paypal_lib->curlPost($paypalURL,$paypalInfo);
            // $result = "VERIFIED";
            if(preg_match("/VERIFIED/i",$result))
            {   
                if($paypalInfo["payment_status"]=="Completed" && $paypalInfo["txn_id"]!='')
                {
                    $data['paymentStatus']="Paid";
                    $storeTransaction=$this->PaypalModel->storeTransaction($data);
                    if($storeTransaction==true)
                    {
                        $data=array(
                            "orderStatus"=>1,
                            "txn_id"=>$txn_id,
                            "status"=>"pending"
                        );
                        
                        $this->PaypalModel->successorderaddress($userid,$orderid);
                        $this->PaypalModel->successorderitems($userid,$orderid);
                        $this->PaypalModel->successmasterorder($userid,$orderid,$txn_id,$data);
                        $this->Api->SendOrderDetail($userid,$orderid,$txn_id);
                    }
                }
            }
            else
            {
                $data['paymentStatus']="unpaid";
                $storeTransaction=$this->PaypalModel->storeTransaction($data);
                if($storeTransaction==true)
                {
                $data=array(
                            "orderStatus"=>1,
                            "txn_id"=>$txn_id,
                            "status"=>"failed"
                        );
                $this->PaypalModel->successorderaddress($userid,$orderid);
                $this->PaypalModel->successorderitems($userid,$orderid);
                $this->PaypalModel->successmasterorder($userid,$orderid,$txn_id,$data);
                }
            }
        }
    }
}