<?php
namespace App\Controllers;
use App\Models\HomeModel;
use App\Models\StripeModel;

use App\Controllers\BaseController;
class Stripe extends BaseController
{
     protected $session;
    protected $stripe_lib;
    protected $StripeModel;
    protected $HomeModel;
     public function __construct()
     {
        $this->session = \Config\Services::session(); 
       
        $this->stripe_lib = service('stripeLib');
        $this->StripeModel = new StripeModel();
        $this->HomeModel = new HomeModel(); 
        if(!isset($this->session->language))
        {
           $language='en';
           $this->session->set('language',$language); 
        }
    }
    
    
    function payment()
    { 
        if(!isset($this->session->user))
        {
           //return redirect()->to('/'); 
        }
        $user= $_SESSION['user'];
        $Customerid=$user['id'];
		$order_prefix=settings('order_prefix');
		$lastorder=$this->StripeModel->GetlastMasterOrder();
		if($lastorder)
		{
        $orderlastid = trim($lastorder['orderid'],"$order_prefix")+1;
		}
		else
		{
		$orderlastid=1;	
		}
		$orderno_num = str_pad($orderlastid, 6, "0", STR_PAD_LEFT);
		
		$order_id=$order_prefix.$orderno_num;
        // If payment form is submitted with token 
        if($this->request->getVar('stripeToken'))
        { 
            // Retrieve stripe token and user info from the posted form data 
            $postData = $this->request->getVar(); 
            // Make payment 
            
            // If post data is not empty 
            if(!empty($postData))     
            { 
                $saveOrderdata=$this->saveOrderdata($order_id);
                if($saveOrderdata==true)
                {
            //  Retrieve stripe token and user info from the submitted form data 
            
                $OrderDetails=$this->StripeModel->GetOrderDetails($order_id);
                $OrderAmount=0;
                if($OrderDetails)
                {
                    $OrderAmount=$OrderDetails['total_amount'];
                }
                else
                {
                    $this->session->set('failedmsg',"Order Not Created. Please Try Again."); 
                    return redirect()->to("/failed");
                }
				
                $token  = $postData['stripeToken']; 
                $name = $postData['name']; 
                $email = $postData['email']; 
                $productName="Product Name";
                $price=$OrderAmount;
                $currency=settings('currency_code');
                $user= $_SESSION['user'];
                $userid=$user['id'];
				
                // Add customer to stripe 
                $BilingAddress=$this->StripeModel->GetOrderBilingAddress($order_id);
                if($BilingAddress)
                {
                    $customer = $this->stripe_lib->addCustomer($email, $token,$BilingAddress); 
                }
                else
                {
                    $this->session->set('failedmsg',"Billing Address Not Set. Please Try Again."); 
                    return redirect()->to("/failed");
                }
                if($customer)
                { 
                    // Charge a credit or a debit card 
                    $shippingAddress=$this->StripeModel->GetOrderShippingAddress($order_id);
                    if($shippingAddress)
                    {
                      $charge = $this->stripe_lib->createCharge($customer->id,$userid, $productName, $price, $token, $currency, $order_id,$shippingAddress,$email,$name); 
                        
                    }
                    else
                    {
                        $this->session->set('failedmsg',"Shipping Address Not Set. Please Try Again."); 
                        return redirect()->to("/failed");
                    }
                    if($charge)
                    { 
                        $responce=json_decode(json_encode($charge));
                        if(isset($responce->id))
                        {
                            $payment_intent=$responce->id;
                            $payment_intentupdate=$this->StripeModel->saveorderpayment_intent($payment_intent,$order_id,$userid);
                            if($payment_intentupdate==true)
                            {
                                if(isset($charge['next_action']['redirect_to_url']['url']))
                                {
                                    $redirecturl=$charge['next_action']['redirect_to_url']['url'];
                                    if($redirecturl)
                                    {
                                           return redirect()->to($redirecturl);
                                    }
                                    else
                                    {
                                            if(isset($charge['last_payment_error']['message']))
                                            {
                                                $this->session->set('failedmsg',$charge['last_payment_error']['message']);
                                                return redirect()->to("/failed");
                                            }
                                            else
                                            {
                                                $this->session->set('failedmsg',"Something Wrong!");
                                                return redirect()->to("/failed");
                                            }
                                    }
                                }
                                else
                                {
                                    if(isset($charge['last_payment_error']['message']))
                                    {
                                        $this->session->set('failedmsg',$charge['last_payment_error']['message']);
                                        return redirect()->to("/failed");
                                    }
                                    else
                                    {
                                        $this->session->set('failedmsg',"Something Wrong!");
                                        return redirect()->to("/failed");
                                    }
                                }
                            }
                            else
                            {
                                $this->session->set('failedmsg',"Payment Not Created!");
                                return redirect()->to("/failed");
                            }
                        }
                        else
                        {
                            $apiError = !empty($this->stripe_lib->api_error)?' ('.$this->stripe_lib->api_error.')':'';
                            return redirect()->to("/failed");
                        }
                    } 
                    else
                    {
                        $apiError = !empty($this->stripe_lib->api_error)?' ('.$this->stripe_lib->api_error.')':''; 
                       $this->session->set('failedmsg',$apiError);
                    }
                } 
                else
                {
                    $apiError = !empty($this->stripe_lib->api_error)?' ('.$this->stripe_lib->api_error.')':''; 
                    $this->session->set('failedmsg',$apiError);
                    return redirect()->to("/failed");
                }
            }
                else
                {
                    $this->session->set('failedmsg',"Order Not Create! Please Try Again");
                    return redirect()->to("/failed");
                }
                    // If payment successful 
                    // if($paymentID)
                    // { 
                    //     redirect('products/payment_status/'.$paymentID); 
                    // }else{ 
                    //     $apiError = !empty($this->stripe_lib->api_error)?' ('.$this->stripe_lib->api_error.')':''; 
                    //     $data['error_msg'] = 'Transaction has been failed!'.$apiError; 
                    // } 
            }
            else
            {
                return redirect()->to("/");
            }
        }
        else
        {
             return redirect()->to("/");
        }
        
    } 
    
    public function payment_verify()
    {
        if($this->request->getVar('payment_intent'))
        {
                $payment_intent=$this->request->getVar('payment_intent');
                
                $retrieve = $this->stripe_lib->retrieve($payment_intent);
                if($retrieve)
                {
                    if(isset($retrieve['last_payment_error']['message']))
                    {
                         $userid=$retrieve['metadata']['userid'];
                         $orderid=$retrieve['metadata']['order_id'];
                         $txn_id=$retrieve["id"];
                         $data['userid'] = $retrieve['metadata']['userid'];
                         $data['orderid']    = $retrieve['metadata']['order_id'];
                         $data['txn_id']    = $retrieve["id"];
                         $data['payment_gross'] = $retrieve["amount"]/100;
                         $data['currency_code'] = $retrieve["currency"];
						 $data['payer_name'] = $retrieve['metadata']["payer_name"];
                         $data['payer_email'] = $retrieve['metadata']["payer_email"];
                         $data['paymentgetwaystatus']    = $retrieve['status'];
                         $data['paymenttype']    = 'stripe';
                         $data['paymentStatus']="unpaid";
                         $storeTransaction=$this->StripeModel->storeTransaction($data);
                                   if($storeTransaction==true)
                                    {
                                        $data=array(
                                                    "orderStatus"=>1,
                                                    "txn_id"=>$retrieve["id"],
                                                    "status"=>"failed"
                                                );
												
                                        $this->StripeModel->successorderaddress($userid,$orderid);
                                        $this->StripeModel->successorderitems($userid,$orderid);
                                        $this->StripeModel->successmasterorder($userid,$orderid,$txn_id,$data);
										$this->StripeModel->removetemporder();
                                    }
                                    
                        $this->session->set('failedmsg',$retrieve['last_payment_error']['message']);
                        return redirect()->to("/failed");
                    }
                    else
                    {
                              if($retrieve['status']=="succeeded")
                              {                      
					  
                                    $data['userid'] = $retrieve['metadata']['userid'];
                                    $data['orderid']    = $retrieve['metadata']['order_id'];
                                    $data['txn_id']    = $retrieve["id"];
                                    $data['payment_gross'] = $retrieve["amount_received"]/100;
                                    $data['currency_code'] = $retrieve["currency"];
									$data['payer_name'] = $retrieve['metadata']["payer_name"];
                                    $data['payer_email'] = $retrieve['metadata']["payer_email"];
                                    $data['paymentgetwaystatus']    = $retrieve['status'];
                                    $data['paymenttype']    = 'stripe';
                                    $data['paymentStatus']="Paid";
                                    $storeTransaction=$this->StripeModel->storeTransaction($data);
                                    if($storeTransaction==true)
                                    {
                                        $userid=$retrieve['metadata']['userid'];
                                        $orderid=$retrieve['metadata']['order_id'];
                                        $txn_id=$retrieve["id"];
                                        $StripPaymentdata=array(
                                            'userid'=>$userid,
                                            'orderid'=>$orderid,
                                            'txn_id'=>$txn_id
                                            );
                                        $this->session->set('StripPaymentdata',$StripPaymentdata);
                                        if($storeTransaction==true)
                                        {
                                            $data=array(
                                                        "orderStatus"=>1,
                                                        "txn_id"=>$txn_id,
                                                        "status"=>"pending"
                                                    );
                                            $this->StripeModel->successorderaddress($userid,$orderid);
                                            $this->StripeModel->successorderitems($userid,$orderid);
                                            $this->StripeModel->successmasterorder($userid,$orderid,$txn_id,$data);
											$this->StripeModel->removetemporder();
											$this->StripeModel->removeCart($userid);
											$this->session->remove('shippingaddress');
											$this->session->remove('billingaddress');
											$this->session->remove('shippingdetail');
											$this->session->remove('coupon');
											$this->productQuantityUpadet($userid,$orderid);
                                        }                                        
                                    }
                                  $returnURL = base_url().'success';
                                  return redirect()->to($returnURL);
                              }
                              else
                              {
                                    $data['userid'] = $retrieve['metadata']['userid'];
                                    $data['orderid']    = $retrieve['metadata']['order_id'];
                                    $data['txn_id']    = $retrieve["id"];
                                    $data['payment_gross'] = $retrieve["amount"]/100;
                                    $data['currency_code'] = $retrieve["currency"];
									$data['payer_name'] = $retrieve['metadata']["payer_name"];
                                    $data['payer_email'] = $retrieve['metadata']["payer_email"];
                                    $data['paymentgetwaystatus']    = $retrieve['status'];
                                    $data['paymenttype']    = 'stripe';
                                    $data['paymentStatus']="unpaid";
                                    $storeTransaction=$this->StripeModel->storeTransaction($data);
                                    if($storeTransaction==true)
                                    {
                                        $userid=$retrieve['metadata']['userid'];
                                        $orderid=$retrieve['metadata']['order_id'];
                                        $txn_id=$retrieve["id"];
                                        
                                        $data=array(
                                                    "orderStatus"=>1,
                                                    "txn_id"=>$retrieve["id"],
                                                    "status"=>"failed"
                                                );
                                        $this->StripeModel->successorderaddress($userid,$orderid);
                                        $this->StripeModel->successorderitems($userid,$orderid);
                                        $this->StripeModel->successmasterorder($userid,$orderid,$txn_id,$data);
										$this->StripeModel->removetemporder();
                                    }
                              }
                    }
            }
            else
            {
                $apiError = !empty($this->stripe_lib->api_error)?' ('.$this->stripe_lib->api_error.')':''; 
                $this->session->set('failedmsg',$apiError);
                return redirect()->to("/failed");
            }
        }
        else
        {
            return redirect()->to('/');  
        }
        
    }
    
    public function productQuantityUpadet($userid,$orderid)
    {
        $orderItems=$this->StripeModel->orderItems($orderid,$userid);
        if($orderItems)
        {
            foreach($orderItems as $item)
            {
                $productid=$item['productid'];
                $variationid=$item['variationid'];
                $orderQuantity=$item['pcs'];
                if($variationid>=1)
                {
                    $productvariation=$this->StripeModel->ProductvariationDetailid($productid);
        			if($productvariation)
        		    {
        		        $variationQuantity=$productvariation['quantity'];
        		        $remainvariationQuantity=$variationQuantity-$orderQuantity;
        		        if($remainvariationQuantity<1)
        		        {
        		            $remainvariationQuantity=0;
        		        }
        		        $VariationQuantityData=array(
        		            'quantity'=>$remainvariationQuantity
        		        );
        		        if($remainvariationQuantity<1)
        		        {
        		            $VariationQuantityData['stock']='no';
        		        }
        		        $this->StripeModel->ProductvariationQuantityUpdate($VariationQuantityData,$variationid);
        		    }
                }
                else
                {
                    $product=$this->StripeModel->ProductDetailid($productid);
        			if($product)
        		    {
        		        $Quantity=$product['quantity'];
        		        $remainQuantity=$Quantity-$orderQuantity;
        		        if($remainQuantity<1)
        		        {
        		            $remainQuantity=0;
        		        }
        		        $QuantityData=array(
        		            'quantity'=>$remainQuantity
        		        );
        		        if($remainQuantity<1)
        		        {
        		            $QuantityData['stock']='no';
        		        }
        		        $this->StripeModel->ProductQuantityUpdate($QuantityData,$productid);
        		    }
                }
            }
        }
    }
    
    public function saveOrderdata($order_id)
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        
        $user= $_SESSION['user'];
        $Customerid=$user['id'];
        $savemasterorder=$this->savemasterorder($order_id);
        if($savemasterorder==true)
        {
            $saveshippingaddress=$this->saveshippingaddress($order_id);
            if($saveshippingaddress==true)
            {
                $savebillingaddress=$this->savebillingaddress($order_id);
                if($savebillingaddress==true)
                {
                    $saveorderItems=$this->saveorderItems($order_id);
                    if($saveorderItems==true)
                    {
                        return true;
                    }
                    else
                    {
                        $this->StripeModel->deletefailedorderaddress($order_id);
                        return false;
                    }
                }
                else
                {
                    $this->StripeModel->deletefailedorderaddress($order_id);
                    return false;
                }
            }
            else
            {
                $this->StripeModel->deletefailedmasterorder($order_id);
                return false;
            }
        }
        else
        {
            return false;
        }
    }
    
    public function saveshippingaddress($order_id)
    {
        $user= $_SESSION['user'];
        $Customerid=$user['id'];
        if(isset($_SESSION['shippingdetail']))
        {
            if($_SESSION['shippingdetail']['shippingaddress']=="newaddress")
            { 
                if(isset($_SESSION['shippingaddress']))
                {
                    $address=$_SESSION['shippingaddress'];
                    if(isset($address))
                    {
                        $dataShippingaddress=array(
                                'orderid'=>$order_id,
                                'userid'=>$Customerid,
                                'first_name'=>$address['first_name'],
                                'last_name'=>$address['last_name'],
                                'address1'=>$address['address1'],
                                'address2'=>$address['address2'],
                                'city'=>$address['city'],
                                'zipcode'=>$address['zipcode'],
                                'countryid'=>$address['countryid'],
                                'countryname'=>$address['countryname'],
                                'regionid'=>$address['regionid'],
                                'regionname'=>$address['regionname'],
                                'phone'=>$address['phone'],
                                'phone_code'=>$address['phone_code'],
                                'emailid'=>$address['emailid'],
                                'addresstype'=>"shipping",
                            );
                    }
                }
            }
            else
            {
                $shippingaddressId=base64_decode($_SESSION['shippingdetail']['shippingaddress']);
                $user= $_SESSION['user'];
                $Customerid=$user['id'];
                $address=$this->HomeModel->editaddress($shippingaddressId,$Customerid);
                if(isset($address))
                {
                    $dataShippingaddress=array(
                        'orderid'=>$order_id,
                        'userid'=>$Customerid,
                        'first_name'=>$address['first_name'],
                        'last_name'=>$address['last_name'],
                        'address1'=>$address['address1'],
                        'address2'=>$address['address2'],
                        'city'=>$address['city'],
                        'zipcode'=>$address['zipcode'],
                        'countryid'=>$address['countryid'],
                        'countryname'=>$address['countryname'],
                        'regionid'=>$address['regionid'],
                        'regionname'=>$address['regionname'],
                        'phone'=>$address['phone'],
                        'phone_code'=>$address['phone_code'],
                        'emailid'=>'',
                        'addresstype'=>"shipping",
                        );
                        
                }
            }
                            //  $this->StripeModel->deleteorderaddress($Customerid);
            return $responce=$this->StripeModel->saveorderaddress($dataShippingaddress);
        }
    }
    
    public function savebillingaddress($order_id)
    {
        $user= $_SESSION['user'];
        $Customerid=$user['id'];
        if(isset($_SESSION['billingaddress']))
        {
            $address=$_SESSION['billingaddress'];
            $dataShippingaddress=array(
                        'orderid'=>$order_id,
                        'userid'=>$Customerid,
                        'first_name'=>$address['first_name'],
                        'last_name'=>$address['last_name'],
                        'address1'=>$address['address1'],
                        'address2'=>$address['address2'],
                        'city'=>$address['city'],
                        'zipcode'=>$address['zipcode'],
                        'countryid'=>$address['countryid'],
                        'countryname'=>$address['countryname'],
                        'regionid'=>$address['regionid'],
                        'regionname'=>$address['regionname'],
                        'phone'=>$address['phone'],
                        'phone_code'=>$address['phone_code'],
                        'emailid'=>'',
                        'addresstype'=>"billing",
                        );
            return $responce= $this->StripeModel->saveorderaddress($dataShippingaddress);            
        }       
    }
    
    public function saveorderItems($order_id)
    {
            $user= $_SESSION['user'];
            $customerid=$user['id'];
            $carttype=1;
            $page=0;
            $count=0;
            // $this->StripeModel->deleteorderitems($customerid);
           $cartdetails=$this->HomeModel->cartdetails($customerid);
           if(isset($cartdetails) && count($cartdetails)>=1)
            {
                        $taxAmount=settings('default_estimated_taxes');
                        $shippingdetail=$_SESSION["shippingdetail"];
                
                        $shippingaddress=$shippingdetail['shippingaddress']; 
                        $shippingmethod=$shippingdetail['ShippingMethod']; 
                        if($shippingaddress=='newaddress')
                        {
                            $sess_shippingaddress=$_SESSION["shippingaddress"];
                            $regionid=$sess_shippingaddress['regionid'];  
                            $countryId=$sess_shippingaddress['countryid']; 
                        }
                        else
                        {
                                $addressId=base64_decode($shippingaddress);
                                $address=$this->HomeModel->editaddress($addressId,$customerid);
                                if(isset($address))
                                {        
                                    $regionid=$address['regionid'];  
                                    $countryId=$address['countryid']; 
                                }
                                else
                                {
                                    return false;
                                }
                        }
                		
                		$taxamountData=$this->HomeModel->Gettaxamount($regionid,$countryId);                
                        if(isset($taxamountData))
                        {
                            if(count($taxamountData)>0)
                            {
                				if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
                				{
                					$tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
                				}
                				else
                				{
                					$tax_name=unserialize($taxamountData['tax_name'])['en'];
                				}
                				$taxAmount=$taxamountData['tax'];
                            }
                        }
                		else
                		{
                			$taxamountData=$this->HomeModel->GetCountrytaxamount($countryId);                
                			if(isset($taxamountData))
                			{
                				if(count($taxamountData)>0)
                				{
                					if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
                					{
                						$tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
                					}
                					else
                					{
                						$tax_name=unserialize($taxamountData['tax_name'])['en'];
                					}
                					$taxAmount=$taxamountData['tax'];
                				}
                			}
                		}
                        foreach($cartdetails as $product)
                        {
							$metalname='';
							$sizename='';
							$grossweight='';
							$netweight='';
							$weightunit='';
							if($product['variationid']!=0)
							{
								$productAmount=$product['variation_sale_price'];
							}
							else
							{
								$productAmount=$product['products_sale_price'];
							}
							if($product['variationid']!=0)
                            {
								if(!empty($product['v_metalname']))
								{
									if(isset(unserialize($product['v_metalname'])[$_SESSION['language']]))
									{
										$metalname=unserialize($product['v_metalname'])[$_SESSION['language']];
									}
									else
									{
										$metalname=unserialize($product['v_metalname'])['en'];
									}
								}
								if(!empty($product['v_sizename']))
								{
									if(isset(unserialize($product['v_sizename'])[$_SESSION['language']]))
									{
										$sizename=unserialize($product['v_sizename'])[$_SESSION['language']];
									}
									else
									{
										$sizename=unserialize($product['v_sizename'])['en'];
									}
								}
								if(!empty($product['variation_weight']))
								{
									$grossweight=$product['variation_weight'];
									$netweight=$product['variation_weight'];
									$weightunit=$product['variation_weightunit'];
								}
							}
							elseif($product['designid']!='' && $product['producttype']=='jewelry')
							{
								$metalname=$product['metalname'];
								$sizename=$product['sizename'];
							}
							else
							{
								$metalname=$product['metalname'];
								$sizename=$product['sizename'];	
                                $stonedetails=$product['stonedetails'];	
									
									if(!empty($product['products_gross_weight']))
									{
										$grossweight=$product['products_gross_weight'];
										$weightunit=$product['products_weightunit'];
									}
									if(!empty($product['products_gross_weight']))
									{
										$netweight=$product['products_net_weight'];
										$weightunit=$product['products_weightunit'];
									}
									if($product['producttype']!='jewelry')
									{
										if(!empty($product['stone_weight']))
										{
											$grossweight=$product['stone_weight'];
											$netweight=$product['stone_weight'];
										    $weightunit=$product['stone_weightunit'];
										}
									}
							}
							
							$productprice=floatval(preg_replace('/[^\d.]/', '', $productAmount))*floatval($product['cartqty']);
        							
							$product_tax=($productprice/100)*$taxAmount;
							
							$productNetPrice=$productprice+$product_tax;
							
                            $dataorderitem=array(
								'orderid'=>$order_id,
								'userid'=>$customerid,
								'productid'=>$product['productid'],
								'productSlug'=>$product['product_slug'],
								'productname'=>$product['product_title'],
								'image'=>$product['product_thumbnail'],
								'producttype'=>$product['producttype'],
								'designtype'=>$product['designtype'],
								'designid'=>$product['designid'],
								'variationid'=>$product['variationid'],
								'metalname'=>$metalname,
								'sizename'=>$sizename,
								'pcs'=>$product['cartqty'],
								'grossweight'=>$grossweight,
								'netweight'=>$netweight,
								'weightunit'=>$weightunit,
								'price'=>$productprice,
								'tax_amount'=>$product_tax,
								'net_price'=>$productNetPrice,
								'tax'=>$taxAmount,
                                'stonedetails'=>$stonedetails
							);
                            $responce= $this->StripeModel->saveorderitem($dataorderitem);   
                    }
                        return true;
			}
			else
			{
				return false;
			}
          
           
    }
    
    public function savemasterorder($order_id)
    {
            $user=$user= $_SESSION['user'];
            $customerid=$user['id'];
            $amountMaping=$this->GetamountMaping();
            if($amountMaping['subtotal']>0)
            {
                if(isset($amountMaping['couponAmount']))
                {
                    $coupon_amount=$amountMaping['couponAmount'];
                    $coupon_id=$amountMaping['couponId'];
                }
                else
                {
                    $coupon_amount=0;
                    $coupon_id='';
                }

                $dataorder=array(
                                    'orderid'=>$order_id,
                                    'userid'=>$customerid,
                                    'gross_amount'=>$amountMaping['subtotal'],
                                    'tax_amount'=>$amountMaping['totaltax'],
                                    'shipping_amount'=>$amountMaping['shippingAmount'],
                                    'coupon_amount'=>$coupon_amount,
                                    'coupon_id'=>$coupon_id,
                                    'total_amount'=>$amountMaping['totalpayamount'],
                                    'txn_id'=>'',
                                    'currency_code'=>settings('currency_code'),
                                    'currency'=>settings('currency'),
                                    'shippingmethod'=>$_SESSION['shippingdetail']['ShippingMethod'],
                                    'shippingname'=>$amountMaping['shipping_name'],
                                    'shipping_date'=>$amountMaping['shipping_date'],
                                    'tax_percent'=>$amountMaping['taxAmount'],
                                    );
                                    //   $this->StripeModel->deletemasterorder($customerid);
                        return $responce= $this->StripeModel->savemasterorder($dataorder);   
            }
            else
            {
                return false;
            }

    }
    
    public function GetamountMaping()
    {
        if(!isset($this->session->user))
        {
           return redirect()->to('/'); 
        }
        $user= $_SESSION['user'];
        $Customerid=$user['id'];
        $cartAmount=0;
        $taxAmount=settings('default_estimated_taxes');
        $tax_name="";
        
        $shipping_date="";
        $shipping_name="";
        $shippingAmount=0;
        $shippingdetail=$_SESSION["shippingdetail"];

        $shippingaddress=$shippingdetail['shippingaddress']; 
        $shippingmethod=$shippingdetail['ShippingMethod']; 
        if($shippingaddress=='newaddress')
        {
            $sess_shippingaddress=$_SESSION["shippingaddress"];
            $regionid=$sess_shippingaddress['regionid'];  
            $countryId=$sess_shippingaddress['countryid']; 
        }
        else
        {
                $addressId=base64_decode($shippingaddress);
                $address=$this->HomeModel->editaddress($addressId,$Customerid);
                if(isset($address))
                {        
                    $regionid=$address['regionid'];  
                    $countryId=$address['countryid']; 
                }
        }
		
		 $taxamountData=$this->HomeModel->Gettaxamount($regionid,$countryId);                
        if(isset($taxamountData))
        {
            if(count($taxamountData)>0)
            {
				if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
				{
					$tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
				}
				else
				{
					$tax_name=unserialize($taxamountData['tax_name'])['en'];
				}
				$taxAmount=$taxamountData['tax'];
            }
        }
		else
		{
			$taxamountData=$this->HomeModel->GetCountrytaxamount($countryId);                
			if(isset($taxamountData))
			{
				if(count($taxamountData)>0)
				{
					if(isset(unserialize($taxamountData['tax_name'])[$_SESSION['language']]))
					{
						$tax_name=unserialize($taxamountData['tax_name'])[$_SESSION['language']];
					}
					else
					{
						$tax_name=unserialize($taxamountData['tax_name'])['en'];
					}
					$taxAmount=$taxamountData['tax'];
				}
			}
		}
		
        if(isset($shippingmethod))
        {
            if($shippingmethod=='standered')
            {
                $shipping_name="Standered Delivery";
                $shippingAmount=settings('standard_delivery_amount');
                
                $currentdate=date("d-m-Y");
                $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.settings('standard_delivery_days').' days'));

                $shipping_date="Delivery by ".date("l d/m",strtotime($ShippingDate));
            }
            else
            {
                $shippingmethod=base64_decode($shippingmethod);
                $ShippingMethods=$this->HomeModel->GetShippingMethodId($shippingmethod);
                if(isset($ShippingMethods))
                {
                    if(count($ShippingMethods)>0)
                    {
                        if(isset(unserialize($ShippingMethods['shipping_name'])[$_SESSION['language']]))
                        {
                            $shipping_name=unserialize($ShippingMethods['shipping_name'])[$_SESSION['language']];
                        }
                        else
                        {
                            $shipping_name=unserialize($ShippingMethods['shipping_name'])['en'];
                        }
                        
                        $currentdate=date("d-m-Y");
                        $ShippingDate=date('Y-m-d', strtotime($currentdate. ' + '.$ShippingMethods['days'].' days'));
                    
                        $shipping_date="Delivery by ".date("l d/m",strtotime($ShippingDate));
                        $shippingAmount=$ShippingMethods['shipping'];
                    }
            }
            }
        }
        
            $totalTaxAmount=0;
            $carttype=1;
            $page=0;
            $count=0;
            $cartdetails=$this->HomeModel->cartdetails($Customerid);
            if($cartdetails)
            {
				foreach($cartdetails as $product)
				{
					if($product['variationid']!=0)
					{
						$productAmount=$product['variation_sale_price'];
						$productPrice=floatval(preg_replace('/[^\d.]/', '', $product['variation_sale_price']))*floatval($product['cartqty']);
					}
					else
					{
						$productAmount=$product['products_sale_price'];
						$productPrice=floatval(preg_replace('/[^\d.]/', '', $product['products_sale_price']))*floatval($product['cartqty']);
					}
					$cartAmount+=$productPrice;
					$product_tax=($productPrice/100)*$taxAmount;
					$totalTaxAmount+=$product_tax;
				}
				
			}

		$couponAmount=0;
		$couponId=0;
		if(isset($_SESSION['coupon']))
		{	
				$couponId=$_SESSION['coupon']['id'];
				if($_SESSION['coupon']['coupon_type']=='Percent')
				{
					$couponAmount=$cartAmount*$_SESSION['coupon']['discount']/100;
				}
				else
				{
					$couponAmount=$_SESSION['coupon']['discount'];
				}
			
		}
		
        $totaltax=0;
        
        $totaltax=round($totalTaxAmount,2);
        
        $totalpayamount=$cartAmount+$totaltax+$shippingAmount-$couponAmount;
		
        $data=array(
            'subtotal'=>$cartAmount,
			'couponAmount'=>$couponAmount,
			'couponId'=>$couponId,
			'totaltax'=>$totaltax,
            'tax_name'=>$tax_name,
            'taxAmount'=>$taxAmount,
            'shipping_name'=>$shipping_name,
            'shipping_date'=>$shipping_date,
            'shippingAmount'=>$shippingAmount,
			'totalpayamount'=>round($totalpayamount,2)
            );
        return $data;
    }
    
     //As per Indian regulations, only registered Indian businesses (i.e. sole proprietorships, limited liability partnerships and companies, but not individuals) can accept international payments. More info here: https://stripe.com/docs/india-exports
}