<?php

if (! function_exists('settings')) {
    function settings($key = '') {
        
        $CI = \Config\Database::connect();
        
        return $result =  $CI->table('settings')
            		       ->where('webkey', $key)
            		       ->get()->getRowArray()['value'];
    }
}

if (! function_exists('websettings')) 
{
    function websettings($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('web_setting')
            		       ->get()->getRowArray();
    }
}


if (! function_exists('parentmenus')) {
    function parentmenus($key = '') {
        
        $CI = \Config\Database::connect();
        
        return $result =  $CI->table('menus')
            		       ->where('parent_menu', $key)
            		       ->where('status', '1')
            		       ->orderBy('menu_sort','ASC')
            		       ->get()->getResultArray();
    }
}

if (! function_exists('userdetail')) 
{
    function userdetail($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('users')
                            ->where('id', $key)
            		       ->get()->getRowArray();
    }
}


if (! function_exists('country')) 
{
    function country($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('country')
                           ->where('status', 1)
            		       ->get()->getResultArray();
    }
}

if (! function_exists('countryname')) {
    function countryname($key = '') {
        
        $CI = \Config\Database::connect();
        
        return $result =  $CI->table('country')
            		       ->where('country_id', $key)
            		       ->where('status', 1)
            		       ->orderBy('country','ASC')
            		       ->get()->getRowArray()['country'];
    }
}


if (! function_exists('region')) {
    function region($key = '') {
        
        $CI = \Config\Database::connect();
        
        return $result =  $CI->table('states')
            		       ->where('country_id', $key)
            		       ->where('status', 1)
            		       ->orderBy('name','ASC')
            		       ->get()->getResultArray();
    }
}
if (! function_exists('regionname')) {
    function regionname($key = '') {
        
        $CI = \Config\Database::connect();
        
        return $result =  $CI->table('states')
            		       ->where('id', $key)
            		       ->where('status', 1)
            		       ->get()->getRowArray()['name'];
    }
}

if (! function_exists('newslettersetting')) 
{
    function newslettersetting($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('newslettersettinig')
            		       ->get()->getRowArray();
    }
}

if (! function_exists('default_smtp_mail')) 
{
    function default_smtp_mail($msg = NULL, $sub = NULL, $to = NULL, $cc = NULL, $from = NULL, $email_type = NULL, $redirect_url = NULL) 
    {
        $email_data = ['message' => $msg];
        $htmlContent = view('email/default_template', $email_data);

        $email = \Config\Services::email();

        $email->initialize([
            'protocol'  => 'smtp',
            'SMTPHost'  => settings('smtp_host'),
            'SMTPPort'  => settings('smtp_port'),
            'SMTPUser'  => settings('smtp_user'),
            'SMTPPass'  => settings('smtp_pass'),
            'mailType'  => 'html',
            'charset'   => 'utf-8',
            'newline'   => "\r\n",
            'CRLF'      => "\r\n"
        ]);

        $email->setFrom(settings('smtp_user'), $sub);
        $email->setTo($to);
        $email->setSubject($sub);
        $email->setMessage($htmlContent);

        if ($cc) {
            $email->setCC($cc);
        }

        if (!$email->send()) {
            log_message('error', 'Email failed to send: ' . print_r($email->printDebugger(['headers', 'subject', 'body']), true));
        }
    }
}





if (! function_exists('languages')) 
{
    function languages($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('language')
                          ->where('Status', 1)
            		      ->get()->getResultArray();
    }
}

if (! function_exists('emailtemplates')) 
{
    function emailtemplates($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('emailtemplates')
                          ->where('Status', 1)
                          ->where('email_template_slug', $key)
            		      ->get()->getRowArray();
    }
}

if (! function_exists('stores')) 
{
    function stores($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('store')
                          ->where('Status', 1)
            		      ->get()->getResultArray();
    }
}

if (! function_exists('services')) 
{
    function services($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('services')
                          ->where('Status', 1)
                          ->orderBy('sequence', 'ASC')
            		      ->get()->getResultArray();
    }
}


if (! function_exists('categories')) 
{
    function categories($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('category')
                          ->where('deleted_at', NULL)
                          ->where('Status', 1)
            		      ->get()->getResultArray();
    }
}

if (! function_exists('topmenu')) 
{
    function topmenu($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('menus')
                          ->where('status', '1')
                          ->where('parent_menu', 0)
            		      ->get()->getResultArray();
    }
}

if (! function_exists('submenu')) 
{
    function submenu($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('menus')
                          ->where('status', '1')
                          ->where('parent_menu', $key)
            		      ->get()->getResultArray();
    }
}

if (! function_exists('followus')) 
{
    function followus($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('followus')
                          ->where('Status', 1)
            		      ->get()->getResultArray();
    }
}
if (! function_exists('footersectionone')) 
{
    function footersectionone($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('footersectionpage')
                          ->where('section', 1)
            		      ->get()->getResultArray();
    }
}
if (! function_exists('footersectiontwo')) 
{
    function footersectiontwo($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('footersectionpage')
                          ->where('section', 2)
            		      ->get()->getResultArray();
    }
}
if (! function_exists('footersectionthree')) 
{
    function footersectionthree($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('footersectionpage')
                          ->where('section', 3)
            		      ->get()->getResultArray();
    }
}


if (! function_exists('collections')) 
{
    function collections($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('collection')
                          ->where('deleted_at', NULL)
                          ->where('Status', 1)
            		      ->get()->getResultArray();
    }
}

if (! function_exists('metals')) 
{
    function metals($key = '') {
        $CI = \Config\Database::connect();
        return $result =  $CI->table('metal')
                          ->where('deleted_at', NULL)
                          ->where('Status', 1)
            		      ->get()->getResultArray();
    }
}
if ( ! function_exists('slugify'))
{
    function slugify($text) {
        $text = preg_replace('~[^\\pL\d]+~u', '-', $text);
        $text = trim($text, '-');
        $text = strtolower($text);
        //$text = preg_replace('~[^-\w]+~', '', $text);
        if (empty($text))
        return 'n-a';
        return $text;
    }
}

if ( ! function_exists('RandomString'))
{
    function RandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

if (!function_exists('curl_get_request')) {
    function curl_get_request(string $url, array $headers = [], $postData = null, bool $insecure = false)
    {
        $ch = curl_init();

        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_HTTPHEADER => $headers,
        ]);

        if ($insecure) {
            // Allow self-signed or mismatched SSL
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        }

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            log_message('error', 'cURL error: ' . curl_error($ch));
            curl_close($ch);
            return false;
        }

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        return ($httpCode === 200) ? $response : false;
    }
}
if (!function_exists('curl_post_request')) {
    function curl_post_request(
        string $url,
        array $headers = [],
        $postData = null,
        bool $insecure = false,
        int $timeout = 30
    ) {
        //echo $postData; die;
        //($headers);die;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); // Avoid hanging indefinitely

        if ($insecure) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        }

        if (!empty($headers)) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }

        // POST data handling
    if ($postData !== null) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, is_array($postData) ? json_encode($postData) : $postData);
    }

     $response = curl_exec($ch);
$error = curl_error($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// Log raw response (debugging)
log_message('debug', 'RAW API RESPONSE: ' . $response);

if ($error) {
    log_message('error', 'CURL ERROR: ' . $error);
    return false;
}

if ($httpCode >= 400) {
    log_message('error', 'API ERROR (HTTP ' . $httpCode . '): ' . $response);
    return false;
}

return $response;
    }
}

if (!function_exists('getDefaultPostData')) {
    function getDefaultPostData(): array
    {
        return [
            'category'     => [],
            'subcategory'  => [],
            'collection'   => [],
            'style'        => [],
            'fancycolor'   => [],
            'stonetype'    => [],
            'stone'        => [],
            'shape'        => [],
            'metal'        => [],
            'min_price'    => 0,
            'max_price'    => 10000000000000,
            'sortby'       => 1,
            'page'         => 0,
            'search_text'  => "",
            'mobile'       => ""
        ];
    }
}

function encrypt_id($id)
{
    $encrypter = \Config\Services::encrypter();
    return base64_encode($encrypter->encrypt($id));
}

function decrypt_id($encryptedId)
{
    $encrypter = \Config\Services::encrypter();
    return $encrypter->decrypt(base64_decode($encryptedId));
}

?>
