<?php
namespace App\Libraries;

use App\Models\ApiModel;

class ExternalApiService
{
    protected $ApiModel;
    protected $apiURL;
    protected $username;
    protected $mailid;
    protected $appid;
    protected $password;

    public function __construct()
    {
        helper('site_helper');
        $this->ApiModel = new ApiModel();

        $this->apiURL = settings('api_url');
        $this->username = settings('username');
        $this->mailid = settings('mailid');
        $this->appid = settings('appid');
        $this->password = settings('password');
    }

    public function generateToken()
    {
        $queryParams = http_build_query([
            'username' => $this->username,
            'mailid'   => $this->mailid,
            'appid'    => $this->appid,
            'password' => $this->password
        ]);

        $url = rtrim($this->apiURL, '/') . '/GenerateToken?' . $queryParams;

        $response = curl_get_request($url, ['Accept: text/plain'], null, true);

        if ($response !== false) {
            $json = json_decode($response);
            if (isset($json->data->access_token)) {
                return $json->data->access_token;
            }
        }

        log_message('error', 'Failed to generate token.');
        return false;
    }

    public function registerUser(array $postData)
    {
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/signup/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
        
       
        // Parse response
    if ($response) {
        $decoded = json_decode($response, true);
        if (json_last_error() === JSON_ERROR_NONE && isset($decoded['success'])) {
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];

    }

    /*  Catalog Api */

    public function Catalogitems(array $postData)
    {
      // print_r(json_encode($postData));die;
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/catalog/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
       // echo $response;die;
       
        // Parse response
    if ($response) {
       
        $decoded = json_decode($response, true);
      /*
        echo '<pre>';
      print_r($decoded);
      echo '</pre>';
      die;
      */
        if (isset($decoded['success'])) {
             
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];
    
    }
   
   
     public function Catalogitemdetails($postdata)
    {
      // print_r(json_encode($postData));die;
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/catalogdetails/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postdata));

        $response = curl_post_request($url, $headers, $postdata, true);
       // echo $response;die;
       
        // Parse response
    if ($response) {
       
        $decoded = json_decode($response, true);
      /*
        echo '<pre>';
      print_r($decoded);
      echo '</pre>';
      die;
      */
     
        if (isset($decoded['success'])) {
             
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];
    
    }
     

     public function RelatedCatalogitems(array $postData)
    {
      // print_r(json_encode($postData));die;
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/relatedcatalogs/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
       // echo $response;die;
       
        // Parse response
    if ($response) {
       
        $decoded = json_decode($response, true);
      /*
        echo '<pre>';
      print_r($decoded);
      echo '</pre>';
      die;
      */
        if (isset($decoded['success'])) {
             
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];
    
    }

    // You can move more methods here as needed...

     public function Postorderdata(array $postData)
    {
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/ordersubmit/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
        
       
        // Parse response
    if ($response) {
        $decoded = json_decode($response, true);
        if (json_last_error() === JSON_ERROR_NONE && isset($decoded['success'])) {
            return $decoded;
        }
        log_message('error', '[API]  JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];

    }


      public function Getmetalprice(array $postData)
    {
      // print_r(json_encode($postData));die;
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/getproductmetalprice/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
       // echo $response;die;
       
        // Parse response
    if ($response) {
       
        $decoded = json_decode($response, true);
      /*
        echo '<pre>';
      print_r($decoded);
      echo '</pre>';
      die;
      */
        if (isset($decoded['success'])) {
             
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];
    
    }

      public function Getstoneprice(array $postData)
    {
       //print_r(json_encode($postData));die;
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/getproductstoneprice/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending registration request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
       // echo $response;die;
       
        // Parse response
    if ($response) {
       
        $decoded = json_decode($response, true);
      /*
        echo '<pre>';
      print_r($decoded);
      echo '</pre>';
      die;
      */
        if (isset($decoded['success'])) {
             
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API registration failed.'
    ];
    
    }

      public function Add_address(array $postData)
    {
        $token = $this->generateToken();
        if (!$token) {
            return ['status' => 'failed', 'message' => 'Token not generated.'];
        }

        $url = rtrim($this->apiURL, '/') . '/shippingaddress/';
        $headers = [
            'Accept: text/plain',
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ];

        log_message('debug', 'Sending add address request: ' . json_encode($postData));

        $response = curl_post_request($url, $headers, $postData, true);
        
       
        // Parse response
    if ($response) {
        $decoded = json_decode($response, true);
        if (json_last_error() === JSON_ERROR_NONE && isset($decoded['success'])) {
            return $decoded;
        }
        log_message('error', '[API] Invalid JSON Response: ' . $response);
    } else {
        log_message('error', '[API] Empty or failed response from ' . $url);
    }

    return [
        'success' => 'false',
        'message' => 'API address failed.'
    ];

    }
}
