<?php 
/** 
 * PayPal Library for CodeIgniter 3.x 
 * 
 * Library for PayPal payment gateway. It helps to integrate PayPal payment gateway 
 * in the CodeIgniter application. 
 * 
 * It requires PayPal configuration file and it should be placed in the config directory. 
 * 
 * @package     CodeIgniter 
 * @category    Libraries 
 * @author      CodexWorld 
 * @license     http://www.codexworld.com/license/ 
 * @link        http://www.codexworld.com 
 * @version     2.0 
 */ 
namespace App\Libraries; 
class Stripe_lib{ 
    var $CI; 
    var $api_error; 

    function __construct(){ 
        $this->api_error = ''; 
         
        // Include the Stripe PHP bindings library 
        // require APPPATH .'Libraries/init.php'; 
         
        // Set API key 
        $sanbox = $this->settings('stripe_sanbox'); 
        $this->publishable_key = ($sanbox == TRUE)? $this->settings('stripe_test_publishable_key'):$this->settings('stripe_live_publishable_key');
        $this->secret_key = ($sanbox == TRUE)? $this->settings('stripe_test_secret_key'):$this->settings('stripe_live_secret_key');
        
        \Stripe\Stripe::setApiKey($this->secret_key); 
    } 
    
    function settings($key = '') {
        
        $CI = \Config\Database::connect();
        
        return $result =  $CI->table('settings')
            		       ->where('webkey', $key)
            		       ->get()->getRowArray()['value'];
    }
    
    function addCustomer($email, $token,$BilingAddress){ 
        try { 
            // Add customer to stripe 
            $customer = \Stripe\Customer::create(array(
                 'name' => trim($BilingAddress['first_name']." ".$BilingAddress['last_name']),
                 'address' => [
                      'line1' => $BilingAddress['address1'],
                      'line2' => $BilingAddress['address2'],
                      'postal_code' => $BilingAddress['zipcode'],
                      'city' => $BilingAddress['city'],
                      'state' => $BilingAddress['regionname'],
                      'country' =>  $BilingAddress['countryname'],
                    ],
                'phone' => $BilingAddress['phone'],
                'email' => $email, 
                'source'  => $token 
            )); 
            return $customer; 
        }  catch(\Stripe\Exception\CardException $e) {
          // Since it's a decline, \Stripe\Exception\CardException will be caught
             $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\RateLimitException $e) {
          // Too many requests made to the API too quickly
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\InvalidRequestException $e) {
          // Invalid parameters were supplied to Stripe's API
          $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\AuthenticationException $e) {
          // Authentication with Stripe's API failed
          // (maybe you changed API keys recently)
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\ApiConnectionException $e) {
          $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\ApiErrorException $e) {
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch(Exception $e) { 
             $this->api_error = $e->getMessage(); 
             return false; 
        } 
    }
    function retrieve($payment_intent){ 
        // Convert price to cents 
       $stripe = new \Stripe\StripeClient($this->secret_key);
           
        try { 
            $charge=$stripe->paymentIntents->retrieve($payment_intent);
            // Retrieve charge details 
           return $chargeJson = $charge->jsonSerialize(); 
        }catch(\Stripe\Exception\CardException $e) {
          // Since it's a decline, \Stripe\Exception\CardException will be caught
             $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\RateLimitException $e) {
          // Too many requests made to the API too quickly
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\InvalidRequestException $e) {
          // Invalid parameters were supplied to Stripe's API
          $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\AuthenticationException $e) {
          // Authentication with Stripe's API failed
          // (maybe you changed API keys recently)
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\ApiConnectionException $e) {
          $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\ApiErrorException $e) {
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch(Exception $e) { 
             $this->api_error = $e->getMessage(); 
             return false; 
        }
    }
    
    function cancel($payment_intent,$return_url){ 
        // Convert price to cents 
       $stripe = new \Stripe\StripeClient($this->secret_key);
           
           $charge=$stripe->paymentIntents->cancel($payment_intent, []);
            // Retrieve charge details 
           return $chargeJson = $charge->jsonSerialize(); 
            
            
        try { 
            
            
        }catch(\Stripe\Exception\CardException $e) {
          // Since it's a decline, \Stripe\Exception\CardException will be caught
         return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\RateLimitException $e) {
          // Too many requests made to the API too quickly
          return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\InvalidRequestException $e) {
          // Invalid parameters were supplied to Stripe's API
         return $this->api_error = $e->getMessage(); 
          return $e->getError();
        } catch (\Stripe\Exception\AuthenticationException $e) {
          // Authentication with Stripe's API failed
          // (maybe you changed API keys recently)
          return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\ApiConnectionException $e) {
         return $this->api_error = $e->getMessage(); 
          
        } catch (\Stripe\Exception\ApiErrorException $e) {
          return $this->api_error = $e->getMessage(); 
        } catch(Exception $e) { 
            return $this->api_error = $e->getMessage(); 

            return false; 
        }
    }

    function capture($payment_intent){ 
        // Convert price to cents 
       $stripe = new \Stripe\StripeClient($this->secret_key);
           
           $charge=$stripe->paymentIntents->capture($payment_intent, []);
            // Retrieve charge details 
           return $chargeJson = $charge->jsonSerialize(); 
            
            
        try { 
            
            
        }catch(\Stripe\Exception\CardException $e) {
          // Since it's a decline, \Stripe\Exception\CardException will be caught
         return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\RateLimitException $e) {
          // Too many requests made to the API too quickly
          return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\InvalidRequestException $e) {
          // Invalid parameters were supplied to Stripe's API
         return $this->api_error = $e->getMessage(); 
          return $e->getError();
        } catch (\Stripe\Exception\AuthenticationException $e) {
          // Authentication with Stripe's API failed
          // (maybe you changed API keys recently)
          return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\ApiConnectionException $e) {
         return $this->api_error = $e->getMessage(); 
          
        } catch (\Stripe\Exception\ApiErrorException $e) {
          return $this->api_error = $e->getMessage(); 
        } catch(Exception $e) { 
            return $this->api_error = $e->getMessage(); 

            return false; 
        }
    }
    
    function confirm($payment_intent,$return_url){ 
        // Convert price to cents 
       $stripe = new \Stripe\StripeClient($this->secret_key);
           
           $charge=$stripe->paymentIntents->confirm(
               $payment_intent, 
               [
                   'payment_method' => 'pm_card_visa',
                   'return_url' => $return_url,
                ] 
               );
            // Retrieve charge details 
           return $chargeJson = $charge->jsonSerialize(); 
            
            
        try { 
            
            
        }catch(\Stripe\Exception\CardException $e) {
          // Since it's a decline, \Stripe\Exception\CardException will be caught
         return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\RateLimitException $e) {
          // Too many requests made to the API too quickly
          return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\InvalidRequestException $e) {
          // Invalid parameters were supplied to Stripe's API
         return $this->api_error = $e->getMessage(); 
          return $e->getError();
        } catch (\Stripe\Exception\AuthenticationException $e) {
          // Authentication with Stripe's API failed
          // (maybe you changed API keys recently)
          return $this->api_error = $e->getMessage(); 
        } catch (\Stripe\Exception\ApiConnectionException $e) {
         return $this->api_error = $e->getMessage(); 
          
        } catch (\Stripe\Exception\ApiErrorException $e) {
          return $this->api_error = $e->getMessage(); 
        } catch(Exception $e) { 
            return $this->api_error = $e->getMessage(); 

            return false; 
        }
    }
     
    function createCharge($customerid,$userid, $productName, $price, $token, $currency, $order_id,$shippingAddress,$email,$name){ 
        // Convert price to cents 
       $itemPriceCents = ($price*100); 
       $stripe = new \Stripe\StripeClient($this->secret_key);

        try { 
            // Charge a credit or a debit card 
            $charge=$stripe->paymentIntents->create([
                'amount' => $itemPriceCents,
                'currency' => $currency,
                'shipping' => [
                    'name' => trim($shippingAddress['first_name']." ".$shippingAddress['last_name']),
                    'address' => [
                      'line1' => $shippingAddress['address1'],
                      'line2' => $shippingAddress['address2'],
                      'postal_code' => $shippingAddress['zipcode'],
                      'city' => $shippingAddress['city'],
                      'state' => $shippingAddress['regionname'],
                      'country' => "US",
                    ],
                ], 
                'automatic_payment_methods' => ['enabled' => true],
                // 'payment_method' => 'pm_card_visa',
                'customer' => $customerid,
                'confirm' => true,
                'return_url'=>base_url().'payment-verify',
                'capture_method' => 'automatic',
                'description' => "$order_id Order Id Payment",
                'metadata' => ['order_id' => $order_id,'userid' => $userid,'payer_email' => $email,'payer_name' => $name],
            ]);
            
             
            // Retrieve charge details 
            $chargeJson = $charge->jsonSerialize(); 
            return $chargeJson; 
        }catch(\Stripe\Exception\CardException $e) {
          // Since it's a decline, \Stripe\Exception\CardException will be caught
             $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\RateLimitException $e) {
          // Too many requests made to the API too quickly
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\InvalidRequestException $e) {
          // Invalid parameters were supplied to Stripe's API
          $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\AuthenticationException $e) {
          // Authentication with Stripe's API failed
          // (maybe you changed API keys recently)
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\ApiConnectionException $e) {
          $this->api_error = $e->getMessage(); 
             return false; 
        } catch (\Stripe\Exception\ApiErrorException $e) {
           $this->api_error = $e->getMessage(); 
             return false; 
        } catch(Exception $e) { 
             $this->api_error = $e->getMessage(); 
             return false; 
        }
    } 
}