<?php 
namespace App\Models;
use CodeIgniter\Model;
use App\Libraries\ExternalApiService;
class HomeModel extends Model
{
     protected $apiService;
    public function __construct()
    {
        parent::__construct();
        // OR $this->db = db_connect();
           helper('site_helper');
         $this->apiService = new ExternalApiService();
    }
    
    public function GetCategories()
    {
         return $category = $this->db->table('category')
                                     ->where('deleted_at', NULL)
                                     ->where('Status', 1)
            		                 ->get()->getResultArray();
    }
    
    public function GetHomeSliders()
    {
        return $HomeSliders = $this->db->table('homeslider')
                                    ->where('Status', 1)
                                    ->orderBy('sequence','ASC')
                		            ->get()->getResultArray();
    }
    
    public function GetRegisterBanners()
    {
        return $HomeSliders = $this->db->table('registerbanner')
                                    ->where('Status', 1)
                		            ->get()->getResultArray();
    }
    
    
    
    
    public function GetHomePartnerSlider()
    {
        return $GetHomePartnerSlider = $this->db->table('webpartner')
                                    ->where('Status', 1)
                                    ->orderBy('sequence','ASC')
                		            ->get()->getResultArray();
    }
    
    public function GetHomeCategories()
    {
        return $category = $this->db->table('category')
                                    ->where('deleted_at', NULL)
                                    ->where('Status', 1)
                                    ->orderBy('sequence','ASC')
                		            ->get()->getResultArray();
    }
    
    public function Getofficeaddress()
    {
        return $officeaddress = $this->db->table('officeaddress')
                                    ->where('Status', '1')
                		            ->get()->getResultArray();
    }
    
   
    
    public function Getbookanappointment()
    {
        return $officeaddress = $this->db->table('book_an_appointment')
                		            ->get()->getRowArray();
    }
    
    
    public function GetHomeLooseDiamonds()
    { 
        return $category = $this->db->table('color')
                                    ->where('deleted_at', NULL)
                                    ->where('Status', 1)
                                    ->where('diamond_color !=', '')
                                    ->orderBy('sequence','ASC')
                		            ->get()->getResultArray();
    }
    
    public function GetHomeLooseGemstones()
    {
        return $category = $this->db->table('stone')
                                    ->where('deleted_at', NULL)
                                    ->where('Status', 1)
                                    ->orderBy('sequence','ASC')
                		            ->get()->getResultArray();
    }
    
    public function GetLogoutUserDetail($userid)
    {
        $userTable=$this->db->table('users');
        $userTable->where('id', $userid);
        $userTable->where('email_verify', 1);
        $userTable->where('status', 1);
        return $userTable->get()->getRowArray();   
    }
    
    public function checkreferralcode($referralcode)
    {
        $userTable=$this->db->table('users');
        $userTable->where('referralcode', $referralcode);
        $userTable->where('email_verify', 1);
        $userTable->where('status', 1);
        return $userTable->get()->getRowArray();   
    }
	
	public function chekloyaltypoints($userid,$type)
	{
		$userTable=$this->db->table('loyaltypoints');
        $userTable->where('userid', $userid);
        $userTable->where('type', $type);
		
        return $userTable->get()->getNumRows();
	}
    
   
    
    public function onlinebenefit()
    {
        return $tomasonlinebenefit = $this->db->table('onlinebenefit')
                                    ->where('Status', 1)
                		            ->get()->getResultArray();
    }
    
    
    public function GetCategoriesSlug($catSlug)
    {
        return $category = $this->db->table('category')
                                    ->where('deleted_at', NULL)
                                    ->where('Status', 1)
                                    ->where('slug', $catSlug)
            		                ->get()->getRowArray();
    }
    public function GetFirstSectionAbout()
    {
        return $homebanner = $this->db->table('homebanner')
                                      ->where('Status', 1)
                                      ->where('banner_section', '1')
            		                  ->get()->getRowArray();
    }
    public function GetOurStorySections()
    {
        return $ourstory = $this->db->table('ourstory')
                                    ->where('Status', 1)
            		                ->get()->getResultArray();
    }
    public function GetOurTeams()
    {
        return $ourteam = $this->db->table('ourteam')
                                   ->where('Status', 1)
            		               ->get()->getResultArray();
    }
    public function GetOurServices()
    {
        return $ourservice = $this->db->table('ourservice')
                                      ->where('Status', 1)
            		                  ->get()->getResultArray();
    }
    
    public function Coupon()
    {
        return $testimonial = $this->db->table('coupon')
                                       ->where('Status', '1')
            		                   ->get()->getResultArray();
    }
    
	public function getCoupon($couponCode)
	{
		 return $getCoupon = $this->db->table('coupon')
                                       ->where('Status', '1')
									   ->Where('coupon',$couponCode)
            		                   ->get()->getRowArray();
	}
	
	public function totalCouponUse($couponid)
	{
		 return $totalCouponUse = $this->db->table('couponuse')
									   ->Where('couponid',$couponid)
            		                   ->get()->getNumRows();
	}
	
	public function totalCouponUseCustomer($couponid,$Customerid)
	{
		return $totalCouponUseCustomer = $this->db->table('couponuse')
									   ->Where('couponid',$couponid)
									   ->Where('customerid',$Customerid)
            		                   ->get()->getNumRows();
		
	}
	
	
	
    public function Gettestimonials()
    {
        return $testimonial = $this->db->table('testimonial')
                                       ->where('Status', 1)
            		                   ->get()->getResultArray();
    }
    
    public function GetCollection()
    {
        return $collection = $this->db->table('collection')
                                      ->where('deleted_at', NULL)
                                      ->where('Status', 1)
            		                  ->get()->getResultArray();
    }

    public function Getfaqs()
    {
        return $collection = $this->db->table('faq')
                                      ->where('language', $_SESSION['language'])
                                      ->where('Status', 1)
                                      ->orderBy('sequence','asc')
            		                  ->get()->getResultArray();
    }
    
    
    public function GetHomeBanners($id)
    {
        return $homebanners = $this->db->table('homebanner')
                                       ->where('Status', 1)
                                       ->where('banner_section', $id)
            		                   ->get()->getResultArray();
    }
    
    public function GetCollectionIds($collectionSlug)
    {
        return $collection = $this->db->table('collection')
                                      ->where('deleted_at', NULL)
                                      ->where('Status', 1)
                                      ->where('slug', $collectionSlug)
                                	  ->get()->getRowArray();
    }
    
    public function GetMetal()
    {
        return $metal = $this->db->table('metal')
                                 ->where('deleted_at', NULL)
                                 ->where('Status', 1)
            		             ->get()->getResultArray();
    }
    public function GetMetalIds($metalSlug)
    {
         return $metal = $this->db->table('metal')
                                  ->where('deleted_at', NULL)
                                  ->where('Status', 1)
                                  ->where('slug', $metalSlug)
            		              ->get()->getRowArray();
    }
    public function GetSize()
    {
        return $size = $this->db->table('size')
                                ->where('deleted_at', NULL)
                                ->where('Status', 1)
            		            ->get()->getResultArray();
    }
    public function GetSizeIds($sizeSlug)
    {
         return $size = $this->db->table('size')
                                 ->where('deleted_at', NULL)
                                 ->where('Status', 1)
                                 ->where('slug', $sizeSlug)
            		             ->get()->getRowArray();
    }
    public function GetStone()
    {
        return $stone = $this->db->table('stone')
                                 ->where('deleted_at', NULL)
                                 ->where('Status', 1)
            		             ->get()->getResultArray();
    }
    
    
    public function GetStoneIds($sizeSlug)
    {
         return $stone = $this->db->table('stone')
                                  ->where('deleted_at', NULL)
                                  ->where('Status', 1)
                                  ->where('slug', $sizeSlug)
            		              ->get()->getRowArray();
    }
    public function GetStyle()
    {
        return $style = $this->db->table('style')
                                 ->where('deleted_at', NULL)
                                 ->where('Status', 1)
                        		 ->get()->getResultArray();
    }
    public function GetStyleIds($sizeSlug)
    {
         return $style = $this->db->table('style')
                                  ->where('deleted_at', NULL)
                                  ->where('Status', 1)
                                  ->where('slug', $sizeSlug)
                        		  ->get()->getRowArray();
    }

    public function GetCategoryBannerId($id,$bannertype)
    {
        return $CategoryBanner = $this->db->table('categorybanner')
                                          ->where('Status', 1)
                                          ->where('view_page', 'category')
                                          ->where('view_category', $id)
                                          ->where('banner_type', $bannertype)
                                          ->orderBy('rand()')
                                    	  ->get()->getRowArray();
    }
    
    public function GetCategoryBanner($bannertype,$page)
    {
        return $CategoryBanner = $this->db->table('categorybanner')
                                          ->where('Status', 1)
                                          ->where('view_category', '')
                                          ->where('view_page', $page)
                                          ->where('banner_type', $bannertype)
                                          ->orderBy('rand()')
                                		  ->get()->getRowArray();
    }
    
    
    public function GetNewArrivalsBanner($bannertype)
    {
        return $CategoryBanner = $this->db->table('categorybanner')
                                          ->where('Status', 1)
                                          ->where('view_page', 'newarrival')
                                          ->where('banner_type', $bannertype)
                                          ->orderBy('rand()')
                                		  ->get()->getRowArray();
    }
    
    
    
    public function GetBestSellerBanner($bannertype)
    {
        return $CategoryBanner = $this->db->table('categorybanner')
                                          ->where('Status', 1)
                                          ->where('view_page', 'bestseller')
                                          ->where('banner_type', $bannertype)
                                          ->orderBy('rand()')
                                		  ->get()->getRowArray();
    }
    
    public function GetNewsletter($NewsletterEmail)
    {
        return $Newsletter = $this->db->table('Newsletter')
                                      ->where('email', $NewsletterEmail)
                            		  ->get()->getRowArray();
    }
    public function InsertNewsletter($data)
    {
        return  $this->db->table('Newsletter')
                         ->insert($data);
    }
    public function InsertbookAppointment($data)
    {
        return  $this->db->table('appointment')
                         ->insert($data);
    }
    public function GetOfficeAddressdetail($office)
    {
        return $office = $this->db->table('officeaddress')
                                 ->where('id', $office)
                		         ->get()->getRowArray();
    }
    
    public function InsertemailAssistance($data)
    {
        return  $this->db->table('emailAssistance')
                         ->insert($data);
    }
    
    public function GetStoreId($store)
    {
        return $store = $this->db->table('store')
                                 ->where('id', $store)
                		         ->get()->getRowArray();
    }
    
    public function GetServiceId($service)
    {
        return $service = $this->db->table('services')
                                   ->where('id', $service)
                		           ->get()->getRowArray();
    }
    
    public function insertRegisterUser($data)
    {
          $this->db->table('users')
                   ->insert($data);
        return $this->db->insertID();    
    }
    
    public function deleteRegisterUser($userId)
    {
        return $user = $this->db->table('users')
                                ->where('id', $userId)
                		        ->delete();
    }
    
   
    
    public function paymentStatus($orderid,$txn_id,$userid)
    {
        return $paymentStatus=$this->db->table('payments')
                                       ->where('userid', $userid)
                                       ->where('orderid', $orderid)
                                       ->where('txn_id', $txn_id)
                    		           ->get()->getRowArray();
    }
    
    public function orderStatus($orderid,$txn_id,$userid)
    {
        return $orderStatus=$this->db->table('masterorders')
                                     ->where('userid', $userid)
                                     ->where('orderid', $orderid)
                                     ->where('txn_id', $txn_id)
                            		 ->get()->getRowArray();
    }
    
    public function CheckLogin($email)
    {
        return $CheckLogin=$this->db->table('users')
                                    ->where('email', $email)
                                    ->where('source!=', 'facebook')
                            		->get()->getRowArray();
    }
     public function CheckProfileEmail($email,$userid)
    {
        return $CheckProfileEmail=$this->db->table('users')
                                    ->where('email', $email)
                            		->where('id!=', $userid)
                            		->get()->getRowArray();
    }
    
    
    
    
    public function UserAddressInsert($address_detail)
    {
          $this->db->table('address')
                   ->insert($address_detail);
         return $this->db->insertID();
    }
    
    public function GetAlluserAddress($userid)
    {
        
    }
    
    public function updatedefaultAddress($Customerid,$lastAddId)
    {
          $data=array('defaultaddress'=>"no");
          $this->db->table('address')
                   ->where('userid', $Customerid)
                   ->where('id !=', $lastAddId)
                   ->update($data); 
                   
          $data=array('defaultaddress'=>"yes");
          return $this->db->table('address')
                          ->where('userid', $Customerid)
                          ->where('id', $lastAddId)
                          ->update($data);                   
    }
    
    public function UserAddressRemove($userid,$addressid)
    {
        return $this->db->table('address')
                        ->where('userid', $userid)
                        ->where('id', $addressid)
                        ->delete();     
    }
    
    public function checkAddress($userid,$accounttype)
    {
        return $checkAddress=$this->db->table('address')
                                      ->where('userid', $userid)
                                      ->where('accounttype', $accounttype)
                    		          ->get()->getRowArray();
    }
    
    
    public function address($userid)
    {
        return $address = $this->db->table('address')
                                   ->where('Status', 1)
                                   ->where('userid', $userid)
                        		   ->get()->getResultArray();
    }
    
    public function editaddress($addressid,$userid)
    {
        return $address = $this->db->table('address')
                                   ->where('Status', 1)
                                   ->where('userid', $userid)
                                   ->where('id', $addressid)
                        		   ->get()->getRowArray();
    }
    
    public function UserAddressUpdate($address_detail,$userid,$addressid)
    {
        return $data = $this->db->table('address')
                                ->where('userid', $userid)
                                ->where('id', $addressid)
                                ->update($address_detail);  
    }
    
    public function GetShippingMethod($regionid,$countryId)
    {
        return $data = $this->db->table('shipping')
                                ->where('countryid', $countryId)
                                ->where('regionid', $regionid)
                                ->where('Status', 1)
                                ->get()->getResultArray();
    }
    
    public function ProductVisitDetail($productid,$product_code)
    {
        $TableSql=$this->db->table('product_visitors');
        $TableSql->where('productid', $productid);
        $TableSql->where('productcode', $product_code);
        $totalrecords = $TableSql->get()->getNumRows();
        return $totalrecords;
    }
    
    public function  ProductVisitInsert($visitdata)
    {
        $insert = $this->db->table('product_visitors')
                           ->insert($visitdata);
        return $insert?true:false;
    }
    
    public function ProductVisitUpdate($productid,$product_code,$totalvisit)
    {
         $data=array(
            "visit"=>$totalvisit,
            );
        return  $this->db->table('products')
                         ->where('id', $productid)
                         ->where('product_code', $product_code)
                         ->update($data);
    }
   
    
    public function Gettaxamount($regionid,$countryId)
    {
        return $data = $this->db->table('tax')
                                ->where('countryid', $countryId)
                                ->where('regionid', $regionid)
                                ->where('Status', 1)
                                ->get()->getRowArray();
    }
    
	public function GetCountrytaxamount($countryId)
    {
        return $data = $this->db->table('tax')
                                ->where('countryid', $countryId)
                                ->where('Status', 1)
                                ->get()->getRowArray();
    }
    
    public function GetShippingMethodId($shippingmethod)
    {
        return $data = $this->db->table('shipping')
                        ->where('id', $shippingmethod)
                        ->where('Status', 1)
                        ->get()->getRowArray();
    }
    
    public function storeTransaction($data = array())
    {
        $insert = $this->db->table('payments')
                           ->insert($data);
        return $insert?true:false;
    }
    
 public function orderDetail($orderno, $userid)
{
    return $this->db->table('masterorders')
                    ->select('masterorders.*, users.phone') // select all from masterorders and only phone from users
                    ->join('users', 'users.id = masterorders.userid')
                    ->where('masterorders.userid', $userid)
                    ->where('masterorders.orderid', $orderno)
                    ->get()
                    ->getRowArray();
}
    
    public function orderItemDetail($orderid,$userid,$productid)
    {
        return $data = $this->db->table('orderitems')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('productid', $productid)
                        ->get()->getRowArray();	   
    }

    
    public function orderItemReview($orderid,$userid,$productid)
    {
        return $data = $this->db->table('productreview')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('productid', $productid)
                        ->get()->getRowArray();	   
    }
    
    public function orderReview($orderid,$userid)
    {
        return $data = $this->db->table('orderreview')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->get()->getRowArray();	   
    }
    
    public function orderdeliveredstatus($orderid,$userid)
    {
        return $data = $this->db->table('orderstatushistory')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('status', 'delivered')
                        ->get()->getRowArray();	   
    }
    
    public function ProductReviewsDetail($productid)
    {
            $ReviewsTable=$this->db->table('productreview');
            $ReviewsTable->select('productreview.*,users.*');
            $ReviewsTable->join('users', 'users.id = productreview.userid');
			$ReviewsTable->where('productreview.productid', $productid);
			$ReviewsTable->where('productreview.status', 1);
			$ReviewsTable->groupBy('productreview.userid');
            $Reviews=$ReviewsTable->get()->getResultArray();
			return $Reviews;            
    }
    
    public function GetHomeCustomerReviews()
    {
            $ReviewsTable=$this->db->table('productreview');
            $ReviewsTable->select('productreview.comment,users.first_name,users.last_name,products.thumbnail,products.title');
            $ReviewsTable->join('users', 'users.id = productreview.userid');
            $ReviewsTable->join('products', 'products.id = productreview.productid');
			$ReviewsTable->where('productreview.status', 1);
			$ReviewsTable->groupBy('productreview.userid');
			$ReviewsTable->orderBy('productreview.updatedate','DESC');
            $Reviews=$ReviewsTable->get()->getResultArray();
			return $Reviews;    
    }
    
    public function orderitemreviewupdate($reviewdata,$orderid,$userid,$productid)
    {
        return  $this->db->table('productreview')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('productid', $productid) 
                        ->update($reviewdata);  
    }
    
    
    public function orderitemreviewSubmit($reviewdata)
    {
        return  $this->db->table('productreview')
                         ->insert($reviewdata);    
    }
    
    public function orderreviewupdate($reviewdata,$orderid,$userid)
    {
        return  $this->db->table('orderreview')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->update($reviewdata);  
    }
    
    
    public function orderreviewSubmit($reviewdata)
    {
        return  $this->db->table('orderreview')
                         ->insert($reviewdata);    
    }
    
    public function GetshippingAddress($orderno,$userid)
    {
        return $data = $this->db->table('orderaddress')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->where('addresstype', 'shipping')
                        ->get()->getRowArray();
    }
    
    public function GetbillingAddress($orderno,$userid)
    {
        return $data = $this->db->table('orderaddress')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->where('addresstype', 'billing')
                        ->get()->getRowArray();
    }
    
    public function GetpaymentDetail($orderno,$userid)
    {
		return $data = $this->db->table('payments')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->get()->getRowArray();				
					
    }	
	
	public function Invoicessummary($orderno, $userid)
{
    $productsTable = $this->db->table('orderitems');

    $productsTable->select('
        orderitems.*,
        productreview.rate,
        productreview.comment,
        returns.return_quantity,
        returns.reason,
        returns.return_status,
         returns.refund_status,
        returns.created_at as return_created_at
    ');

    $productsTable->join('productreview', 'productreview.productid = orderitems.productid', 'LEFT');
    $productsTable->join('returns', 'returns.product_id = orderitems.productid AND returns.orderid = orderitems.orderid', 'LEFT');

    $productsTable->where('orderitems.userid', $userid);
    $productsTable->where('orderitems.orderid', $orderno);

    $products = $productsTable->get()->getResultArray();

    return $products;
}
	
	public function GetStatusDetail($status)
	{
		return $this->db->table('orderstatus')
                        ->where('slug', $status)
                        ->where('Status', 1)
                        ->get()->getRowArray();
	}
	
	public function checkcolorShop($slug)
    {
        return $this->db->table('color')
                        ->where('deleted_at', NULL)
                        ->where('Status', 1)
                        ->where('slug', $slug)
                        ->get()->getRowArray();
    }
	
	public function checkstoneShop($slug)
    {
        return $this->db->table('stone')
                        ->where('deleted_at', NULL)
                        ->where('Status', 1)
                        ->where('slug', $slug)
                        ->get()->getRowArray();
    }
	
    // shop page methed
    public function checkcategoryShop($slug)
    {
        return $this->db->table('category')
                        ->where('deleted_at', NULL)
                        ->where('Status', 1)
                        ->where('slug', $slug)
                        ->get()->getRowArray();
    }
	public function checkcategoryDesign($category)
    {
        return $this->db->table('category')
                        ->where('deleted_at', NULL)
                        ->where('Status', 1)
						->where('design', 'yes')
                        ->where('slug', $category)
                        ->get()->getRowArray();
    }
	
    public function checkMenuShop($slug)
    {
        return $this->db->table('menus')
                        ->where('status', '1')
                        ->where('menu_slug', $slug)
                        ->get()->getRowArray();
    }
    
    public function searchProducts($view,$q,$start=0,$rowperpage=10)
    {
        $postdata = getDefaultPostData();
               
             $postdata['search_text']=$q;
             $postdata['page'] = $start;
              
              
                  $productsResponse=$this->apiService->Catalogitems($postdata);
             //print_r($productsResponse); die;
             
             // Handle API failure
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [
            'status' => false,
            'totalproducts' =>0, // Optional: could use $productsResponse['total'] if available
            'showingproducts' =>0,
            'message' => $productsResponse['message'] ?? 'Catalog API error.',
            'products' => []
        ];
    }
$totalProducts = $productsResponse['totalproducts'] ?? 0;
    $showingProducts = $productsResponse['showingproducts'] ?? 0;
    $products = $productsResponse['products'] ?? [];
    foreach($products as $productkey=> &$product)
        {
            $productId=$product['id'];
            $ProductCetificate=[];
            $product['MoreCetificate']=$ProductCetificate;
            $product['producttype']='jewelry';
        }
      // Extract data correctly
    
      //print_r($totalProducts); die;
             $data = [
        'status' => !empty($products),
        'totalproducts' =>$totalProducts, // Optional: could use $productsResponse['total'] if available
        'showingproducts' =>$showingProducts,
        'products' => $products
    ]; 
        
     
                
            return json_encode($data,true);   
        
    }
    
    public function GetProductCetificate($productId)
    {
     return $this->db->table('productmorecertificate')
                        ->where('productid', $productId)
                        ->where('certificate !=', '')
                        ->get()->getResultArray();   
    }
    public function AlltotalsearchProducts($view,$q)
    {
        $productsTable=$this->db->table('products');
        $productsTable->select('products.id');
        $productsTable->join('productstone', 'productstone.productid = products.id', 'LEFT');
        if(!empty($q))
        {
        $productsTable->like('products.title', $q);
        }
        if(!empty($view))
        {
            $productsTable->groupStart();
            $viewArr=explode(',',$view);
            foreach($viewArr as $key=> $viewrow)
            {
                if($key==0)
                {
                    $productsTable->Where('products.producttype', $viewrow);
                }
                else
                {
                    $productsTable->orWhere('products.producttype', $viewrow);
                }
            }
            $productsTable->groupEnd();
        }
        $productsTable->where('products.deleted_at', NULL);
        $productsTable->where('products.status', '1');
        $productsTable->where('products.quantity>=', 1);
        $productsTable->where('products.stock', 'yes');
        $productsTable->groupBy('products.id');
        return $productsTable->get()->getNumRows();
    }
    public function featuredProduct($filterData,$slug,$filters)
    {
            $start=0;$rowperpage=2;
            $productsTable=$this->db->table('products');
            $productsTable->select('products.id,products.product_code,products.slug,products.title,products.thumbnail,products.cost_price,products.tag_price,products.sale_price,products.producttype,products.featured,products.featured_banner');
            $productsTable->join('productvariation', 'productvariation.productid = products.id','LEFT');

            // join table by menufilter
            
            $this->shopProductwhere($filterData,$productsTable);
            
            if(isset($filters) && count($filters)>=1)
            {
                $this->shopfilterProductwhere($productsTable,$filters);
            }
            
            $productsTable->where('products.featured', 'yes');
            $productsTable->where('products.deleted_at', NULL);
            $productsTable->where('products.status', '1');
            $productsTable->where('products.quantity>=', 1);
            $productsTable->where('products.stock', 'yes');
            $productsTable->groupBy('products.id');
            $productsTable->limit($rowperpage, $start);
            $productsTable->orderBy('rand()');
            return $featuredProducts=$productsTable->get()->getResultArray();
            // echo $this->db->getLastQuery();
            //     die;
            
            
    }
    public function GetDesignProducts($categoryId)
	{
		$productsTable=$this->db->table('products');
            $productsTable->select('products.id,products.product_code,products.slug,products.title,products.thumbnail,products.cost_price,products.tag_price,products.sale_price,products.producttype,category.slug as categoryslug');
			$productsTable->join('category', 'category.categoryid = products.categoryid', 'LEFT');
			$productsTable->where('products.deleted_at', NULL);
            $productsTable->where('products.status', '1');
            $productsTable->where('products.quantity>=', 1);
            $productsTable->where('products.stock', 'yes');
            $productsTable->where('products.categoryid', $categoryId);
            $productsTable->groupBy('products.id');
            $productsTable->limit(3);
            $productsTable->orderBy('rand()');
            $products=$productsTable->get()->getResultArray();
			return $products;
			//echo $this->db->getLastQuery();
            //die;
	}
	
    public function productShop($filterData,$slug,$start=0,$rowperpage=16,$filters=array())
    {
      
             $postdata = getDefaultPostData();

             // Assign a mobile number if provided
    //$postdata['mobile'] = !empty($filterData['mobile']) ? $filterData['mobile'] : '0000000000';

            $this->shopProductwhere($filterData,$postdata);
            
            if(isset($filters) && count($filters)>=1)
            { 
               
                $this->shopfilterProductwhere($postdata,$filters);
            }
             //print_r($postdata); die;

             $productsResponse=$this->apiService->Catalogitems($postdata);
             //print_r($productsResponse); die;
             
             // Handle API failure
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [
            'status' => false,
            'totalproducts' =>0, // Optional: could use $productsResponse['total'] if available
            'showingproducts' =>0,
            'message' => $productsResponse['message'] ?? 'Catalog API error.',
            'products' => []
        ];
    }
      // Extract data correctly
    $totalProducts = $productsResponse['totalproducts'] ?? 0;
    $showingProducts = $productsResponse['showingproducts'] ?? 0;
    $products = $productsResponse['products'] ?? [];
      //print_r($totalProducts); die;
              return [
        'status' => !empty($products),
        'totalproducts' =>$totalProducts, // Optional: could use $productsResponse['total'] if available
        'showingproducts' =>$showingProducts,
        'products' => $products
    ];    
    }

    public function AlltotalProducts($filterData,$slug,$filters)
    {
        $productsTable=$this->db->table('products');
               $productsTable->select('products.id,products.product_code,products.slug,products.title,products.thumbnail,products.cost_price,products.tag_price,products.sale_price,products.producttype');
               $productsTable->join('productvariation', 'productvariation.productid = products.id','LEFT');

               //menu all-product filter
               // join table by menufilter
            
                 $this->shopProductwhere($filterData,$productsTable);
                 if(isset($filters) && count($filters)>=1)
                {
                    $this->shopfilterProductwhere($productsTable,$filters);
                }
            
                 $productsTable->groupBy('products.id');
                return $productsTable->get()->getNumRows();
    }
    
    public function shopProductSettings($filterData,$slug)
    {
               $productsTable=$this->db->table('products');
               $productsTable->select('products.id,products.product_code,products.slug,products.title,products.thumbnail,products.cost_price,products.tag_price,products.sale_price,products.producttype');
               $productsTable->join('productvariation', 'productvariation.productid = products.id','LEFT');

               //menu all-product filter
               // join table by menufilter
                 $this->shopProductwhere($filterData,$productsTable);
                 if(isset($filters) && count($filters)>=1)
                {
                    $this->shopfilterProductwhere($productsTable,$filters);
                }
                 $productsTable->groupBy('products.id');
                return $products=$productsTable->get()->getResultArray();
    
    }
    
    public function getLastProducts($userid,$ip,$productslug)
    {


               $productsTable=$this->db->table('product_visitors');
               $productsTable->select('product_visitors.productid AS id,product_visitors.productcode,product_visitors.slug,product_visitors.short_description,product_visitors.title,product_visitors.thumbnail,product_visitors.cost_price,product_visitors.tag_price,product_visitors.sale_price,product_visitors.producttype');
               
                if(!$userid)
                {
                    $productsTable->where('product_visitors.ip', $ip);   
                }
                else
                {
                    $productsTable->where('product_visitors.userid', $userid);
                }
                $productsTable->where("product_visitors.slug !=",$productslug);
                 $productsTable->groupBy('product_visitors.productid');
                 $productsTable->orderBy('rand()');
                 $productsTable->limit(5);
                return $products=$productsTable->get()->getResultArray();
               
    }
    
    public function getReletedProducts($filterData,$menuslug,$productslug)
    {       
          

             $postdata['product_code']=$productslug;
           
                  $productsResponse=$this->apiService->RelatedCatalogitems($postdata);
           
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [];
    }

    $products = $productsResponse['products'] ?? [];
      //print_r($products); die;
            return $products;   


    }
    
    public function ProductDetail($productslug)
    {
                $productsTable=$this->db->table('products');
                $productsTable->select('products.*,metal.name as metalname,color.name as colorname,
                size.name as sizename,
                gender.name as gendername,
                style.name as stylename,
                age.name as agename,productstone.cost_price as stone_cost_price,productstone.tag_price as stone_tag_price,productstone.sale_price as stone_sale_price');
                $productsTable->join('productstone', 'productstone.productid = products.id', 'LEFT');
                $productsTable->join('metal', 'metal.metalid = products.metalid', 'LEFT');
                $productsTable->join('color', 'color.colorid = products.colorid', 'LEFT');
                $productsTable->join('size', 'size.sizeid = products.sizeid', 'LEFT');
                $productsTable->join('age', 'age.ageid = products.ageid', 'LEFT');
                $productsTable->join('gender', 'gender.genderid = products.genderid', 'LEFT');
                $productsTable->join('style', 'style.styleid = products.styleid', 'LEFT');
                $productsTable->where('products.deleted_at', NULL);
                $productsTable->where('products.status', '1');
                $productsTable->where("products.slug",$productslug);
                $productsTable->groupBy('products.id');
               
         return $products=$productsTable->get()->getRowArray();
         
    }
    public function ProductcartRemoveQty($productcode,$productid)
    {
          $postdata['product_code']=$productcode;


       $productsResponse= $this->apiService->Catalogitemdetails($postdata);

                 // Handle API failure
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [];
    }
      
    $product = $productsResponse['data'] ?? [];

               
         return $product;
    }
    
    public function RemoveCartProductOutofStock($productid)
    {
        return  $this->db->table('cart')
                ->where('productid', $productid)
                ->delete();   
    }
    public function RemoveCartProductVariationOutofStock($productid,$variationid)
    {
        return  $this->db->table('cart')
                ->where('productid', $productid)
                ->where('variationid',$variationid)
				->where('designid', '')
                ->delete();   
    }
    public function productImages($productid,$product_code)
    {
        $productImagesTable=$this->db->table('productimage');
                $productImagesTable->select('*');
                $productImagesTable->where("productid",$productid);
                $productImagesTable->where("productcode",$product_code);
         return $productImages=$productImagesTable->get()->getResultArray();
    }
    public function productothermetals($productid,$product_code)
    {
        $productothermetalTable=$this->db->table('productimage');
                $productothermetalTable->select('*');
                $productothermetalTable->where("productid",$productid);
                $productothermetalTable->where("productcode",$product_code);
         return $productothermetals=$productothermetalTable->get()->getResultArray();
    }
    public function MoreCetificates($productid,$product_code)
    {
                $MoreCetificatesTable=$this->db->table('productmorecertificate');
                $MoreCetificatesTable->select('productmorecertificate.*,lab.name as labname,lab.logo as lablogo');
                $MoreCetificatesTable->join('lab', 'lab.labid = productmorecertificate.labid', 'LEFT');
                $MoreCetificatesTable->where("productmorecertificate.productid",$productid);
                $MoreCetificatesTable->where("productmorecertificate.productcode",$product_code);
                $MoreCetificatesTable->where('productmorecertificate.deleted_at', NULL);
         return $MoreCetificates=$MoreCetificatesTable->get()->getResultArray();
    }
    
    public function productvariations($productid,$product_code)
    {
                $productvariationTable=$this->db->table('productvariation');
                $productvariationTable->select('productvariation.*,metal.name as metalname,metal.slug as metalslug');
                $productvariationTable->join('metal', 'metal.metalid = productvariation.metalid');
                $productvariationTable->join('size', 'size.sizeid = productvariation.sizeid');
                $productvariationTable->where("productvariation.productid",$productid);
                $productvariationTable->where("productvariation.productcode",$product_code);
                $productvariationTable->where('productvariation.deleted_at', NULL);
                $productvariationTable->where('productvariation.status', '1');
                $productvariationTable->where('productvariation.quantity>=', 1);
                $productvariationTable->where('productvariation.stock', 'yes');
                $productvariationTable->where('metal.deleted_at', NULL);
                $productvariationTable->where('metal.Status', 1);
                $productvariationTable->where('size.deleted_at', NULL);
                $productvariationTable->where('size.Status', 1);
                $productvariationTable->groupBy('productvariation.metalid');
         return $productvariation=$productvariationTable->get()->getResultArray();
    }
    
    public function productvariationsSize($productSlug,$metalSlug)
    {
                $productsTable=$this->db->table('products');
                $productsTable->select('productvariation.*,size.name as sizename,size.slug as sizeslug');
                $productsTable->join('productvariation', 'productvariation.productid = products.id');
                $productsTable->join('size', 'size.sizeid = productvariation.sizeid');
                $productsTable->join('metal', 'metal.metalid = productvariation.metalid');
                $productsTable->where('products.deleted_at', NULL);
                $productsTable->where('metal.slug', $metalSlug);
                $productsTable->where('products.status', '1');
                $productsTable->where('productvariation.deleted_at', NULL);
                $productsTable->where('productvariation.status', '1');
                $productsTable->where('productvariation.quantity>=', 1);
                $productsTable->where('productvariation.stock', 'yes');
                $productsTable->where('metal.deleted_at', NULL);
                $productsTable->where('size.deleted_at', NULL);
                $productsTable->where('metal.Status', 1);
                $productsTable->where('size.Status', 1);
                $productsTable->where("products.slug",$productSlug);
                $productsTable->groupBy('productvariation.sizeid');
         return $products=$productsTable->get()->getResultArray();
    }
    
    public function GetProductvariationdetail($metalSlug)
    {
         $products = $this->ProductDetailCode($metalSlug);
             return $products;
    }
    
    public function productstones($productid)
    {
                $productstonesTable=$this->db->table('productstone');
                $productstonesTable->select('productstone.*,
                stone.name as stonename,
                intensity.name as intensityname,
                clarity.name as clarityname,
                treatment.name as treatmentname,
                firstcolor.name as firstcolorname,
                secoundcolor.name as secoundcolorname,
                shape.name as shapename,
                stonecut.name as stonecutname,
                stonesize.name as stonesizename,
                lab.name as labname,
                lab.logo as lablogo,
                stonetype.name as stonetypename');
                $productstonesTable->join('stonetype', 'stonetype.slug = productstone.stonetype', 'LEFT');
                $productstonesTable->join('stone', 'stone.stoneid = productstone.stoneid', 'LEFT');
                $productstonesTable->join('intensity', 'intensity.intensityid = productstone.intensityid', 'LEFT');
                $productstonesTable->join('clarity', 'clarity.clarityid = productstone.clarityid', 'LEFT');
                $productstonesTable->join('treatment', 'treatment.treatmentid = productstone.treatmentid', 'LEFT');
                $productstonesTable->join('color as firstcolor', 'firstcolor.colorid = productstone.colorid1', 'LEFT');
                $productstonesTable->join('color as secoundcolor', 'secoundcolor.colorid = productstone.colorid2', 'LEFT');
                $productstonesTable->join('shape', 'shape.shapeid = productstone.shapeid', 'LEFT');
                $productstonesTable->join('stonecut', 'stonecut.stonecutid = productstone.stonecutid', 'LEFT');
                $productstonesTable->join('stonesize', 'stonesize.stonesizeid = productstone.stonesizeid', 'LEFT');
                $productstonesTable->join('lab', 'lab.labid = productstone.labid', 'LEFT');
                $productstonesTable->where("productstone.productid",$productid);
                $productstonesTable->where('productstone.deleted_at', NULL);
                $productstonesTable->where('productstone.status', '1');
                
                $productstonesTable->groupBy('productstone.id');
         return $productstones=$productstonesTable->get()->getResultArray();
    }
    
    
    public function shopProductwhere($filterData,&$postdata)
    {
   
            if(isset($filterData['menufilter'])) 
            {
                
             
                //menu all-product filter
              
               //print_r($filterData); die;
                //menu collection filter
                if(isset($filterData['menufilter']['collection']) && $filterData['menufilter']['collection']!='')
                {
                    $collectionSlug=$filterData['menufilter']['collection'];
                    $strSubQuery = $this->db->table('collection');
                                    $strSubQuery->select("collectionid");
                                    $strSubQuery->where("slug",$collectionSlug);
                    $collectionid = $strSubQuery->get()->getRowArray();
                    if($collectionid)
                    { 
                        $postdata['collection'][] = ["id" => (int)$collectionid['collectionid']];
                    
                    }
                }
              
            if(isset($filterData['menufilter']['style']) && $filterData['menufilter']['style']!='')
                {
                    $styleSlug=$filterData['menufilter']['style'];
                    $strSubQuery = $this->db->table('style');
                                    $strSubQuery->select("styleid");
                                    $strSubQuery->where("slug",$styleSlug);
                    $styleid = $strSubQuery->get()->getRowArray();
                    if($styleid)
                    { 
                        $postdata['style'][] = ["id" => (int)$styleid['styleid']];
                    
                    }
                }

                //menu category filter
                if(isset($filterData['menufilter']['category']) && $filterData['menufilter']['category']!='')
                {
                    $categorySlug=$filterData['menufilter']['category'];
                    $strSubQuery = $this->db->table('category');
                                    $strSubQuery->select("categoryid");
                                    $strSubQuery->where("slug",$categorySlug);
                    $categoryid = $strSubQuery->get()->getRowArray();
                    if($categoryid)
                    {
                        $postdata['category'][] = ["id" => (int)$categoryid['categoryid']];
                   
                    }
                }
                
                //menu category type filter
                if(isset($filterData['menufilter']['category-type']) && $filterData['menufilter']['category-type']!='')
                {
                    $categorytypeSlug=$filterData['menufilter']['category-type'];
                    $strSubQuery = $this->db->table('type');
                                    $strSubQuery->select("typeid");
                                    $strSubQuery->where("slug",$categorytypeSlug);
                    $categorytypeid = $strSubQuery->get()->getRowArray();
                    if($categorytypeid)
                    {
                         $postdata['subcategory'][] = ["id" => (int)$categorytypeid['typeid']];
                   
                    }
                }
                
                //menu color filter
                if(isset($filterData['menufilter']['color']) && $filterData['menufilter']['color']!='')
                {
                    $colorSlug=$filterData['menufilter']['color'];
                    $strSubQuery = $this->db->table('color');
                                   $strSubQuery->select("colorid");
                                   $strSubQuery->where("slug",$colorSlug);
                    $colorid = $strSubQuery->get()->getRowArray();
                    if($colorid)
                    {
                  $postdata['fancycolor'][] = ["id" => (int)$colorid['colorid']];
                    }
                }

                //menu stone type filter
                if(isset($filterData['menufilter']['stonetype']) && $filterData['menufilter']['stonetype']!='')
                {
                    $stonetypeSlug=$filterData['menufilter']['stonetype'];
                    $strSubQuery = $this->db->table('stonetype');
                                   $strSubQuery->select("stonetypeid");
                                   $strSubQuery->where("slug",$stonetypeSlug);
                    $stonetypeid = $strSubQuery->get()->getRowArray();
                    if($stonetypeid)
                    {
                  $postdata['stonetype'][] = ["id" => (int)$stonetypeid['stonetypeid']];
                    }

                   

                }
                
                //menu stone filter
                if(isset($filterData['menufilter']['stone']) && $filterData['menufilter']['stone']!='')
                {
                    $stoneSlug=$filterData['menufilter']['stone'];
                    $strSubQuery = $this->db->table('stone');
                                   $strSubQuery->select("stoneid");
                                   $strSubQuery->where("slug",$stoneSlug);
                    $stoneid = $strSubQuery->get()->getRowArray();
                    if($stoneid)
                    {
                         $postdata['stone'][] = ["id" => (int)$stoneid['stoneid']];
                 
                    }
                }
                
                
                
                //menu all-product filter
               if(isset($filterData['menufilter']['all-product']) && isset($filterData['menufilter']['category']))
               {
                   
                      
                   
                   if($filterData['menufilter']['all-product']=='diamond' && !$filterData['menufilter']['stonetype'])
                   {
                       $productsTable->groupStart();
                       $productsTable->where('productstone.stonetype', 'white');
                       $productsTable->orWhere('productstone.stonetype', 'fancy');
                       $productsTable->groupEnd();
                         $postdata['stonetype'][] = ["id" => 1];
                         $postdata['stonetype'][] = ["id" => 2];
                       
                   }
                   if($filterData['menufilter']['all-product']=='gemstone' && !$filterData['menufilter']['stonetype'])
                   {
                      $postdata['stonetype'][] = ["id" => 3];
                   }
               }
               elseif(isset($filterData['menufilter']['all-product']) && !isset($filterData['menufilter']['category']))
               {
                
				   if($filterData['menufilter']['all-product']=='stone')
					{
						
                          $postdata['stonetype'][] = ["id" => 1];
                         $postdata['stonetype'][] = ["id" => 2];
					}
				
               }
            
                
            }
           
            if(isset($filterData['categoryid'])) 
            {
                $postdata['category'][] = ["id" => (int)$filterData['categoryid']];
              
            }
            
            if(isset($filterData['stoneid'])) 
            {
                 $postdata['stone'][] = ["id" => (int)$filterData['stoneid']];
              
            }
            if(isset($filterData['colorid']))
            {
                
                $colorid = $filterData['colorid'];
                if($colorid)
                {
                     $postdata['fancycolor'][] = ["id" => (int)$filterData['colorid']];
                
                }
            }

            
            
              
                
    }
    
    public function shopfilterProductwhere( &$postdata, $filters)
    {
       if(isset($filters['min-price']))
       {
         $postdata['min_price'] = $filters['min-price'];
       }
       if(isset($filters['max-price']))
       {
           $postdata['max_price'] = $filters['max-price'];
       }
       if(isset($filters['category']))
       {
           $slugArr=explode(',',$filters['category']);
            $strSubQuery = $this->db->table('category');
            $strSubQuery->select("categoryid");
            $strSubQuery->whereIn("slug",$slugArr);
            $categoryids = array_column($strSubQuery->get()->getResultArray(),'categoryid');
             
        
    foreach ($categoryids as $categoryid) {
        $postdata['category'][] = ["id" => (int)$categoryid];
    }
           
       }
       
       if(isset($filters['type']))
       {
           $slugArr=explode(',',$filters['type']);
            $strSubQuery = $this->db->table('type');
            $strSubQuery->select("typeid");
            $strSubQuery->whereIn("slug",$slugArr);
            $typeids = array_column($strSubQuery->get()->getResultArray(),'typeid');
            
    foreach ($typeids as $typeid) {
        $postdata['subcategory'][] = ["id" => (int)$typeid];
    }

           
       }
       
       if(isset($filters['fancycolor']))
       {
           $slugArr=explode(',',$filters['fancycolor']);

            $strSubQuery = $this->db->table('color');
            $strSubQuery->select("colorid");
            $strSubQuery->whereIn("slug",$slugArr);
            $colorids = array_column($strSubQuery->get()->getResultArray(),'colorid');
           

    foreach ($colorids as $colorid) {
        $postdata['fancycolor'][] = ["id" => (int)$colorid];
    }
       }
       
       if(isset($filters['stonetype']))
       {
           $slugArr=explode(',',$filters['stonetype']);
          
             $strSubQuery = $this->db->table('stonetype');
            $strSubQuery->select("stonetypeid");
            $strSubQuery->whereIn("slug",$slugArr);
            $stonetypeids = array_column($strSubQuery->get()->getResultArray(),'stonetypeid');
         

    foreach ($stonetypeids as $stonetypeid) {
        $postdata['stonetype'][] = ["id" => (int)$stonetypeid];
    }

          
       }
       
       if(isset($filters['stone']))
       {
           $slugArr=explode(',',$filters['stone']);
            $strSubQuery = $this->db->table('stone');
            $strSubQuery->select("stoneid");
            $strSubQuery->whereIn("slug",$slugArr);
            $stoneids = array_column($strSubQuery->get()->getResultArray(),'stoneid');

    foreach ($stoneids as $stoneid) {
        $postdata['stone'][] = ["id" => (int)$stoneid];
    }

          
       }
       if(isset($filters['shape']))
       {
           $slugArr=explode(',',$filters['shape']);
            $strSubQuery = $this->db->table('shape');
            $strSubQuery->select("shapeid");
            $strSubQuery->whereIn("slug",$slugArr);
            $shapeids = array_column($strSubQuery->get()->getResultArray(),'shapeid');

    foreach ($shapeids as $shapeid) {
        $postdata['shape'][] = ["id" => (int)$shapeid];
    }
     
       }
       if(isset($filters['metal']))
       {
           $slugArr=explode(',',$filters['metal']);
            $strSubQuery = $this->db->table('metal');
            $strSubQuery->select("metalid");
            $strSubQuery->whereIn("slug",$slugArr);
            $metalids = array_column($strSubQuery->get()->getResultArray(),'metalid');
    foreach ($metalids as $metalid) {
        $postdata['metal'][] = ["id" => (int)$metalid];
    }

            
       }
       if(isset($filters['intensity']))
       {
           $slugArr=explode(',',$filters['intensity']);
            $strSubQuery = $this->db->table('intensity');
            $strSubQuery->select("intensityid");
            $strSubQuery->whereIn("slug",$slugArr);
            $intensityids = array_column($strSubQuery->get()->getResultArray(),'intensityid');
    foreach ($intensityids as $intensityid) {
        $postdata['intensity'][] = ["id" => (int)$intensityid];
    }
          
       }
       if(isset($filters['overtone']))
       {
            $slugArr=explode(',',$filters['overtone']);
             $strSubQuery = $this->db->table('overtone');
            $strSubQuery->select("overtoneid");
            $strSubQuery->whereIn("slug",$slugArr);
            $overtoneids = array_column($strSubQuery->get()->getResultArray(),'overtoneid');
       
    foreach ($overtoneids as $overtoneid) {
        $postdata['overtone'][] = ["id" => (int)$overtoneid];
    }
         
       }
       if(isset($filters['clarity']))
       {
            $slugArr=explode(',',$filters['clarity']);
            $strSubQuery = $this->db->table('clarity');
            $strSubQuery->select("clarityid");
            $strSubQuery->whereIn("slug",$slugArr);
            $clarityids = array_column($strSubQuery->get()->getResultArray(),'clarityid');
        
    foreach ($clarityids as $clarityid) {
        $postdata['clarity'][] = ["id" => (int)$clarityid];
    }

       }
       
       if(isset($filters['sortby']))
       {
              if($filters['sortby']=='priceasc')
              {
               // $productsTable->orderBy('products.sale_price','ASC');
                 $postdata['sortby'] = 1;
              }
              if($filters['sortby']=='pricedesc')
              {
                
                $postdata['sortby'] = 2;
              }
              if($filters['sortby']=='dateasc')
              {
               $postdata['sortby'] = 3;
              }
              if($filters['sortby']=='datedesc')
              {
               $postdata['sortby'] = 4;
              }
          
       }
    }
    
    public function getproductprice($productCode)
    {
        return $this->db->table('menus')
                        ->where('status', '1')
                        ->where('menu_slug', $slug)
                        ->get()->getRowArray();
    }
    
    
    
    public function GetProductPrices($table,$productId,$productCode)
    {
        $productsTable=$this->db->table($table);
        $productsTable->select('product_code as productcode,cost_price,tag_price,sale_price,');
        $productsTable->where('deleted_at', NULL);
        $productsTable->where('status', '1');
        $productsTable->where('id', $productId);
        $productsTable->where('product_code', $productCode);
        $productPrice=$productsTable->get()->getRowArray();
        return $productPrice;
    }
    public function GetProductStonePrices($table,$productId,$productCode)
    {
        $productsTable=$this->db->table($table);
        $productsTable->select('productid,productcode,cost_price,tag_price,sale_price,');
        $productsTable->where('deleted_at', NULL);
        $productsTable->where('status', '1');
        $productsTable->where('productid', $productId);
        $productsTable->where('productcode', $productCode);
        $productPrice=$productsTable->get()->getRowArray();
        return $productPrice;
    }

    public function GetProductThumbImages($table,$productId,$productCode)
    {
        $productsImages=$this->db->table($table);
        $productsImages->select('productid,productcode,image');
        $productsImages->where('deleted_at', NULL);
        $productsImages->where('status', '1');
        $productsImages->where('productid', $productId);
        $productsImages->where('productcode', $productCode);
        $productsImage=$productsImages->get()->getResultArray();
        return $productsImage;
    }
    
    
    //filter show
    
    public function GetCategoryValue($categoryid)
    {
        return $this->db->table('category')
                        ->where('id', $categoryid)
                        ->where('Status', 1)
                        ->get()->getRowArray();
    }
    
    
    public function GetCategorytypeValue($categoryid)
    {
        return $this->db->table('type')
                        ->where('categoryid', $categoryid)
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    
    public function GetstonetypeValue()
    {
        return $this->db->table('stonetype')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    
    public function GetstoneValue()
    {
        return $this->db->table('stone')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    
    public function GetshapeValue()
    {
        return $this->db->table('shape')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    public function GetmetalValue()
    {
        return $this->db->table('metal')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    
    public function GetjewelrytypeValue()
    {
        return $this->db->table('category')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    
    public function GetfancycolordiamondValue()
    {
        return $this->db->table('color')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->where('diamond_color !=', '')
                        ->get()->getResultArray();
    }
    public function GetfancycolorValue()
    {
        return $this->db->table('color')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    public function GetintensityValue()
    {
        return $this->db->table('intensity')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    public function GetovertoneValue()
    {
        return $this->db->table('productstone')
                        ->where('status', '1')
                        ->where('deleted_at', NULL)
                        ->orderBy('overtone','asc')
                        ->groupBy('overtone')
                        ->get()->getResultArray();
    }
    public function GetclarityValue()
    {
        return $this->db->table('clarity')
                        ->where('Status', 1)
                        ->where('deleted_at', NULL)
                        ->get()->getResultArray();
    }
    
    
    public function ProductDetailCode($productcode)
    {
        $postdata['product_code']=$productcode;


       $productsResponse= $this->apiService->Catalogitemdetails($postdata);

                 // Handle API failure
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [];
    }
      
    $product = $productsResponse['data'] ?? [];
     /*echo '<pre>';  
    print_r($product);
      echo '</pre>';
      die;
      */
              return $product; 
     
    }
    
    public function AddWishlist($data)
    {
       
        return  $this->db->table('wishlist')
                         ->insert($data);    
    }
    
    public function WishlistCommetSave($productid,$userid,$comment)
    {
        $data=array(
            'comment'=>$comment,
            );
        return  $this->db->table('wishlist')
                        ->where('productid', $productid)
                        ->where('userid', $userid)  
                        ->update($data);  
    }
    
    public function RemoveWishlist($productid,$userid)
    {
        return  $this->db->table('wishlist')
                ->where('productid', $productid)
                ->where('userid', $userid)
                ->delete();
    }
    
    public function Addtocart($cartdatainsert)
    { 
     return $this->db->table('cart')
                         ->insert($cartdatainsert);
     //echo $this->db->getLastQuery(); die;

    }
    
    public function Updatetocart($cartdataUpdate,$productid,$cartguestid)
    {
        return  $this->db->table('cart')
                ->where('productid', $productid)
                ->where('cartguestid', $cartguestid)
                ->update($cartdataUpdate);
    }
    
    public function Removetocart($productid,$cartguestid)
    {
        return  $this->db->table('cart')
                ->where('productid', $productid)
                ->where('cartguestid', $cartguestid)
				->where('designid', '')
                ->delete();
    }
	
	public function RemovetocartDesign($designid,$cartguestid)
	{
		return  $this->db->table('cart')
                ->where('designid', $designid)
                ->where('cartguestid', $cartguestid)
                ->delete();
	}
	
	public function ProductCartCheck($productid,$cartguestid)
	{
		return $this->db->table('cart')
                        ->where('productid', $productid)
						->where('cartguestid', $cartguestid)
                        ->get()->getRowArray();
	}
    
    public function exist_record($Data,$table)
    {
        $productsTable=$this->db->table($table);
        foreach($Data as $key=> $value)
        {
            $productsTable->where($key, $value);
        }
        $totalrow=$productsTable->get()->getNumRows();
        return $totalrow;
    }
   
    public function ProductVariationCart($sizeslug,$metalslug,$productid)
    {
                $productsTable=$this->db->table('productvariation');
                $productsTable->select('productvariation.id as variationid,metal.name as metalname,size.name as sizename,productvariation.quantity as variationquantity');
                $productsTable->join('metal', 'metal.metalid = productvariation.metalid');
                $productsTable->join('size', 'size.sizeid = productvariation.sizeid');
                
                $productsTable->where("metal.slug",$metalslug);
                $productsTable->where("size.slug",$sizeslug);
                $productsTable->where("productvariation.productid",$productid);
                
                $productsTable->where('productvariation.deleted_at', NULL);
                $productsTable->where('metal.deleted_at', NULL);
                $productsTable->where('size.deleted_at', NULL);
                
                $productsTable->where('productvariation.status', '1');
                $productsTable->where('productvariation.quantity>=', 1);
                $productsTable->where('productvariation.stock', 'yes');
                $productsTable->where('metal.Status', 1);
                $productsTable->where('size.Status', 1);
                $variation=$productsTable->get()->getRowArray();
                // echo $this->db->getLastQuery();
                // die;
                return $variation;
    }
    public function ProductVariationCartId($sizeid,$metalid,$productid)
    {
        $productsTable=$this->db->table('productvariation');
        $productsTable->select('productvariation.id as variationid,metal.name as metalname,size.name as sizename,productvariation.quantity as variationquantity');
        $productsTable->join('metal', 'metal.metalid = productvariation.metalid');
        $productsTable->join('size', 'size.sizeid = productvariation.sizeid');
        
        $productsTable->where("metal.metalid",$metalid);
        $productsTable->where("size.sizeid",$sizeid);
        $productsTable->where("productvariation.productid",$productid);
        
        $productsTable->where('productvariation.deleted_at', NULL);
        $productsTable->where('metal.deleted_at', NULL);
        $productsTable->where('size.deleted_at', NULL);
        
        $productsTable->where('productvariation.status', '1');
        $productsTable->where('productvariation.quantity>=', 1);
        $productsTable->where('productvariation.stock', 'yes');
        $productsTable->where('metal.Status', 1);
        $productsTable->where('size.Status', 1);
        $variation=$productsTable->get()->getRowArray();
        return $variation;
    }
    
    public function ProductVariationDetail($productid,$variationid)
    {
                $productsTable=$this->db->table('productvariation');
                $productsTable->select('productvariation.id as variationid,productvariation.quantity as variationquantity');
                $productsTable->where("productvariation.productid",$productid);
                $productsTable->where("productvariation.id",$variationid);
                $productsTable->where('productvariation.deleted_at', NULL);
                $productsTable->where('productvariation.status', '1');
                $productsTable->where('productvariation.quantity>=', 1);
                $productsTable->where('productvariation.stock', 'yes');
                $variation=$productsTable->get()->getRowArray();
                return $variation;   
    }
    

    
    public function cartdetails($cartguestid)
    {
                $productsTable=$this->db->table('cart');
                $productsTable->select('*');

                $productsTable->where('cart.cartguestid', $cartguestid);
				$productsTable->orderBy('cart.id','desc');
                $cartproducts=$productsTable->get()->getResultArray();
                // echo $this->db->getLastQuery();
                // die;
                return $cartproducts;
    }
    
    public function productQtyData($productid,$cartguestid)
    {
        $productsTable=$this->db->table('cart');
                $productsTable->select('cart.*,
                productvariation.quantity as variation_quantity,
                products.quantity as products_quantity,
                ');
                $productsTable->join('productvariation', 'productvariation.id = cart.variationid','LEFT');
                $productsTable->join('products', 'products.id = cart.productid');
                
                $productsTable->where('products.deleted_at', NULL);
                $productsTable->where('products.status', '1');
                $productsTable->where('cart.cartguestid', $cartguestid);
                $productsTable->where('cart.productid', $productid);
                $productsTable->groupBy('products.id');
                $cartproducts=$productsTable->get()->getRowArray();
                // echo $this->db->getLastQuery();
                // die;
                return $cartproducts;
    }
    
    public function GetCartexist($productId,$productCode,$cartguestid)
    {
        $productsTable=$this->db->table('cart');
                $productsTable->select('cart.id');
                $productsTable->where('cart.cartguestid', $cartguestid);
                $productsTable->where('cart.productid', $productId);
                $cartproducts=$productsTable->get()->getNumRows();
                // echo $this->db->getLastQuery();
                // die;
                return $cartproducts;
    }
    
    public function GetWishlistexist($productId,$userid)
    {
        $productsTable=$this->db->table('wishlist');
                $productsTable->select('wishlist.id');
                $productsTable->where('wishlist.userid', $userid);
                $productsTable->where('wishlist.productid', $productId);
                $wishlistproducts=$productsTable->get()->getNumRows();
                // echo $this->db->getLastQuery();
                // die;
                return $wishlistproducts;
    }
    
    public function wishlistdetails($userid)
    {
        $productsTable=$this->db->table('wishlist');
                $productsTable->select('wishlist.*,
                cart.id as cartid');
                $productsTable->join('cart', 'cart.productid = wishlist.productid','LEFT');
                $productsTable->where('wishlist.userid', $userid);
                $productsTable->groupBy('wishlist.productid');
                $wishlistproducts=$productsTable->get()->getResultArray();
                // echo $this->db->getLastQuery();
                // die;
                return $wishlistproducts;
    }
    
   public function totalwishlist($userid)
{
    return $this->db->table('wishlist')
        ->where('userid', $userid)
        ->countAllResults();
}

    public function totalcart($cartguestid)
    {
        $productsTable=$this->db->table('cart');
        $productsTable->select('cart.id');
        $productsTable->where('cart.cartguestid', $cartguestid);
        return $productsTable->get()->getNumRows();
    }
    
    public function SaveUser($data)   
    {
        $this->db->table('users')
                         ->insert($data);
                return $this->db->insertID();             
    }

    public function updateApiFlag($email)
{
    return $this->db->table('users') // Replace 'users' with your actual table name
        ->where('email', $email)
        ->update(['api_flag' => 1]);
}
    public function Verifycustomer($udid)
    {
        $productsTable=$this->db->table('users');
        $productsTable->where('email_verify_code', $udid);
        $productsTable->where('email_verify', 0);
        $productsTable->where('status', 1);
        return $productsTable->get()->getRowArray();
    }
    

    public function VerifycustomerUpdate($udid)
    {
        $data=array(
            "email_verify_code"=>"",
            "email_verify"=>1
            );
        return  $this->db->table('users')
                         ->where('email_verify_code', $udid)
                         ->update($data);
    }
    
    public function cartexicuteUpdate($userid,$cartguestid,$type)
    {
        if($type=='login')
        {
            $data=array(
                "userid"=>$userid,
                "cartguestid"=>$userid
            );
        return  $this->db->table('cart')
                         ->where('cartguestid', $cartguestid)
                         ->orWhere('userid', $userid)
                         ->update($data);
        }
        else
        {
            $data=array(
                "userid"=>$userid,
                "cartguestid"=>$cartguestid
            );
            return  $this->db->table('cart')
                         ->where('userid', $userid)
                         ->orWhere('cartguestid', $userid)
                         ->update($data);
        }
    }
    
    public function reset_passwordUpdate($reset_password_data,$email,$userid)
    {
        return  $this->db->table('users')
                         ->where('email', $email)
                         ->orWhere('id', $userid)
                         ->update($reset_password_data);
    }
    
    public function UserPasswordUpdate($userPassworddetail,$userid)
    {
        return  $this->db->table('users')
                         ->Where('id', $userid)
                         ->update($userPassworddetail);
    }
    
    public function UserUpdatedata($update_data,$email,$userid)
    {
        return  $this->db->table('users')
                         ->where('email', $email)
                         ->orWhere('id', $userid)
                         ->update($update_data);
    }
    
    public function UserAccountUpdate($account_detail,$userid)
    {
        return  $this->db->table('users')
                         ->orWhere('id', $userid)
                         ->update($account_detail);
    }
    
    public function Verifyreset_password($udid)
    {
        $productsTable=$this->db->table('users');
        $productsTable->where('reset_password_code', $udid);
        $productsTable->where('email_verify', 1);
        $productsTable->where('status', 1);
        return $productsTable->get()->getRowArray();
    }
    
    public function GetUserProfile($userid)
    {
        $userTable=$this->db->table('users');
        $userTable->where('id', $userid);
        $userTable->where('email_verify', 1);
        $userTable->where('status', 1);
        return $userTable->get()->getRowArray();
    }
    
     public function GetUserByMobile($mobile)
    {
        $userTable=$this->db->table('users');
        $userTable->where('phone', $mobile);
       
        return $userTable->get()->getRowArray();
    }
    
    public function GetLogoutUsers()
    {
        $userTable=$this->db->table('users');
        $userTable->where('password_update_logout', 'yes');
        return $userTable->get()->getResultArray();
    }
    
    public function  LogoutUsersUpdate($LogoutUserId,$LogoutUserData)
    {
        return $data = $this->db->table('users')
                                ->where('id', $LogoutUserId)
                                ->update($LogoutUserData);
    }
    
    
   
    public function Is_already_google_register($googleid)
    {
        $userTable=$this->db->table('users');
        $userTable->where('google_oauth_id', $googleid);
        $userTable->where('email_verify', 1);
        $userTable->where('status', 1);
        return $userTable->get()->getRowArray();
    }
    
    public function Update_google_user_data($user_data,$userid)
    {
        $userTable=$this->db->table('users');
        $userTable->where('id', $userid);
        $userTable->update($user_data); 
        //  echo $this->db->getLastQuery();
        //          die;
    }
    
    public function GetUserLoyaltyPoints($userid)
	{
		$userTable=$this->db->table('loyaltypoints');
        $userTable->where('userid', $userid);
		$userTable->where('status', 1);
        return $userTable->get()->getResultArray();
	}	
	
	public function totaladdpoints($userid)
	{
		$userTable=$this->db->table('loyaltypoints');
		$userTable->selectSum('points');
        $userTable->where('userid', $userid);
		$userTable->where('add_remove', 'add');
		$userTable->where('status', 1);
        return $userTable->get()->getRowArray();
	}
	
	public function totalremovepoints($userid)
	{
		$userTable=$this->db->table('loyaltypoints');
		$userTable->selectSum('points');
        $userTable->where('userid', $userid);
		$userTable->where('add_remove', 'remove');
		$userTable->where('status', 1);
        return $userTable->get()->getRowArray();
	}
    
    public function Insertloyaltypoints($data)
    {
         return  $this->db->table('loyaltypoints')
                         ->insert($data);
    }
	
	public function GettrackingDetails($orderid,$userid)
	{
		$trackingTable=$this->db->table('ordertracking');
        $trackingTable->where('userid', $userid);
        $trackingTable->where('orderid', $orderid);
        return $trackingTable->get()->getRowArray();
		
	}
    	public function getProductWithCategory($productId)
{
    return $this->db->table('products')
                    ->select('products.*, category.slug as category_slug')
                    ->join('category', 'category.categoryid = products.categoryid', 'left')
                    ->where('products.id', $productId)
                    ->get()
                    ->getRowArray();
}

 public function AllItemdetail($orderid,$userid)
    {
        return $data = $this->db->table('orderitems')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                       ->get()->getResultArray();	   
    }

public function Apiorderdata($orderid, $userid)
{
    // Step 1: Get the order
    $order = $this->orderDetail($orderid, $userid);

    if (!$order) {
        // Order not found
        return false;
    }

    // Step 2: Select only needed fields from order
    $filteredOrder = [
        'orderid'        => $order['id'],
        'userid'         => $order['userid'],
        'mobileno'         => $order['phone'],
        'gross_amount'   => $order['gross_amount'],
        'tax_amount'     => $order['tax_amount'],
        'shipping_amount'=> $order['shipping_amount'],
        'coupon_amount'  => $order['coupon_amount'],
        'total_amount'   => $order['total_amount'],
       'message' => !empty($order['message']) ? $order['message'] : '',
        'orderdate'      => $order['orderdate'],
        'api_flag'       => $order['api_flag'],
    ];

    // Step 3: Get and filter order items
    $orderItemsRaw = $this->AllItemdetail($orderid, $userid);
    $orderItems = [];

    foreach ($orderItemsRaw as $item) {
        $orderItems[] = [
            'productid'     => $item['productid'],
            'productSlug'   => $item['productSlug'],
            'productname'   => $item['productname'],
            'image'         => $item['image'],
            'producttype'   => $item['producttype'],
            'metalname'     => $item['metalname'],
            'sizename'      => $item['sizename'],
            'pcs'           => $item['pcs'],
            'grossweight'   => $item['grossweight'],
            'netweight'     => $item['netweight'],
            'weightunit'    => $item['weightunit'],
            'price'         => $item['price'],
            'tax_amount'    => $item['tax_amount'],
            'net_price'     => $item['net_price'],
            'tax'           => $item['tax'],
            'stonedetails' => !empty($item['stonedetails']) ? json_decode($item['stonedetails'], true) : [], // assumed to be JSON
        ];
    }

    // Step 4: Prepare postdata
   
    $postdata = array_merge($filteredOrder, [
    'items' => $orderItems
]);

    // Step 5: Send to API
    $apiresponse = $this->apiService->Postorderdata($postdata);

    // Step 6: If successful, update API flag
    if (isset($apiresponse['success']) && $apiresponse['success'] === true) {
        $this->update_order_flag($orderid);
    }

    return $apiresponse;
}


 public function update_order_flag($orderid)
{
    return $this->db->table('masterorders') // Replace 'users' with your actual table name
        ->where('orderid', $orderid)
        ->update(['api_flag' => 1]);
}

  public function getProductmetalprice($productcode,$metalid)
    {       
           if (empty($productcode) || empty($metalid)) {
     
        return [
            'success' => false,
            'message' => 'Both productcode and metalid are required.',
        ];
    }

             $postdata['productcode']=$productcode;
             $postdata['metalid']=$metalid;
           
                  $productsResponse=$this->apiService->Getmetalprice($postdata);
           
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [];
    }

    return $productsResponse ?? [];
     


    }

    public function getproductstoneprice($stoneid,$shapeid,$qualityid,$colorid,$sizeid)
    {       
           if (empty($stoneid)) {
     
        return [
            'success' => false,
            'message' => ' stoneid is required.',
        ];
    }

            $postdata['stoneid'] = (int) $stoneid;
            $postdata['shapeid'] = (int) $shapeid;
            $postdata['qualityid'] = (int) $qualityid;
            $postdata['colorid'] = (int) $colorid;
            $postdata['sizeid'] = (int) $sizeid;
           
                  $productsResponse=$this->apiService->Getstoneprice($postdata);
           
    if (empty($productsResponse['success']) || $productsResponse['success'] === false) {
        return [];
    }

    return $productsResponse ?? [];
     


    }

     public function updateaddressApiFlag($id)
{
    return $this->db->table('address') // Replace 'users' with your actual table name
        ->where('id', $id)
        ->update(['api_flag' => 1]);
}

public function getLastShippingCode()
{
    $builder = $this->db->table('address'); // Replace with your actual table name

    $builder->select('shippingcode');
    $builder->orderBy('shippingcode', 'DESC'); // Assuming 'id' is the primary key
    $builder->limit(1);

    $query = $builder->get();

    if ($query->getNumRows() > 0) {
        $result = $query->getRow();
        return $result->shippingcode;
    }

    return 1000;
}

public function generateNewShippingCode()
{
    $lastCode = $this->getLastShippingCode();
    $newNumber = $lastCode + 1;

    return $newNumber; // Returns 1001, 1002, etc.
}

   public function orderItemDetail_With_Return($orderid, $userid, $product_id)
{
    return $this->db->table('orderitems oi')
        ->select('oi.*, r.return_quantity, r.reason, r.return_status, r.refund_status, r.return_amount')
        ->where('oi.userid', $userid)
        ->where('oi.orderid', $orderid)
        ->where('oi.productid', $product_id)
        ->join('returns r', 'r.orderid = oi.orderid AND r.product_id = oi.productid', 'left')
        ->get()
        ->getRowArray();
}
  public function orderitemreturnSubmit($returndata)
    {
        return  $this->db->table('returns')
                         ->insert($returndata);    
    }
     public function markItemReturned($orderid, $userid, $product_id)
    {
         return  $this->db->table('orderitems')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('productid', $product_id) 
                        ->update(['status' => 'returned']);  
       
    }

}