<?php 
namespace App\Models;
use CodeIgniter\Model;

class ImportModel extends Model
{
    public function __construct()
    {
        parent::__construct();
     // OR $this->db = db_connect();
    }
    
    public function getlanguage()
    {
        return $language = $this->db->table('language')
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function GetMaxId($table,$field)
    {
        return $maxid = $this->db->table($table)
                    ->selectMax($field)
            		->get()->getRowArray();
    }
    
    public function getMasterId($name,$table,$filed)
    {
        $name=trim($name);
        $pattern=':"'.$name.'";';
        $rowdata=$this->db->table($table)->where('deleted_at', null)
                        ->like('name', $pattern)
                        ->get()->getRowArray();
                //echo $this->db->getLastQuery();
                //die;
                
        if($rowdata)
        {
            return $rowdata[$filed];
        }
        else
        {
            return $id=0;
        }
               
    }
    
    public function updateJewelryProducts()
    {
        $data=array(
            'temp_import'=>0
            );
        return  $this->db->table('products')
                         ->where('temp_import', 1)
                         ->update($data);
    }
    
    public function DeleteTempJewelryProducts()
    {
        $this->db->table('products')
                 ->where('temp_import', 1)
                 ->delete();   
    }

    public function exist_ProductMaster($Design)
    {
        return $exist_ProductMaster = $this->db->table('products')
                    ->where('design', $Design)
            		->get()->getNumRows();
    }
    
    public function check_ProductMasterSlug($slug)
    {
        return $exist_ProductMaster = $this->db->table('products')
                                           ->where('slug', $slug)
            		                       ->get()->getRowArray();
    }
    
    public function update_Product($jewelryData,$Design)
    {
        return  $this->db->table('products')
                        ->where('design', $Design)
                        ->update($jewelryData);
    }
    
    public function insert_Product($jewelryData)
    {
        $this->db->table('products')->insert($jewelryData);
                                  return $this->db->insertID(); 
    }
    public function getProduct($Design)
    {
        return $getProduct = $this->db->table('products')
                                  ->where('design', $Design)
                            	  ->get()->getRowArray();
    }
    public function exist_metal($metalid,$productid)
    {
        return $exist_metal = $this->db->table('productothermetal')
                    ->where('othermetalid', $metalid)
                    ->where('productid', $productid)
            		->get()->getNumRows();
    }
    
    
    
    public function update_metal($metalData,$metalid,$productid)
    {
        return  $this->db->table('productothermetal')
                        ->where('productid', $productid)
                        ->where('othermetalid', $metalid)
                        ->update($metalData);
    }
    
    public function insert_metal($metalData)
    {
        return  $this->db->table('productothermetal')
                         ->insert($metalData);
    }
    
    public function delete_metal($product_code,$productid)
    {
        return  $this->db->table('productothermetal')
                         ->where('productcode', $product_code)
                         ->where('productid', $productid)
                         ->delete();
    }
    
    
    
    public function exist_record($Data,$table)
    {
            $productsTable=$this->db->table($table);
            foreach($Data as $key=> $value)
            {
                $productsTable->like($key, $value);
            }
            $totalrow=$productsTable->get()->getNumRows();
            // echo $this->db->getLastQuery();
            //     die;
            return $totalrow;
    }
    
    public function insert_stone($stoneData)
    {
        return  $this->db->table('productstone')
                         ->insert($stoneData);
    }
    
    public function delete_stone($product_code,$productid)
    {
        return  $this->db->table('productstone')
                         ->where('productcode', $product_code)
                         ->where('productid', $productid)
                         ->delete();
    }
    
    public function insert_Variation($VariationData)
    {
        return  $this->db->table('productvariation')
                         ->insert($VariationData);
    }
    
    public function delete_Variation($product_code,$productid)
    {
        return  $this->db->table('productvariation')
                         ->where('productcode', $product_code)
                         ->where('productid', $productid)
                         ->delete();
    }
    
    
    
    public function update_productThumbnail($imageData,$productid,$product_code)
    {
        return  $this->db->table('products')
                        ->where('id', $productid)
                        ->where('product_code', $product_code)
                        ->update($imageData);
    }
    public function UpdatemasterProductPrice($masterProductPrice,$product_code,$productid)
    {
        return  $this->db->table('products')
                        ->where('id', $productid)
                        ->where('product_code', $product_code)
                        ->update($masterProductPrice);
    }
    
    
    public function insert_image($imageData)
    {
        return  $this->db->table('productimage')
                         ->insert($imageData);
    }
    public function delete_image($product_code,$productid)
    {
        return  $this->db->table('productimage')
                         ->where('productcode', $product_code)
                         ->where('productid', $productid)
                         ->delete();
    }
    
    
    public function getShipping_Company($Shipping_Company)
    {
        return $rowdata=$this->db->table('shippingcompany')
                        ->like('company_title', $Shipping_Company)
                        ->get()->getRowArray();
                //echo $this->db->getLastQuery();
                //die;
                
       
    }
    
    public function insert_shippingcompany($data)
    {
        return  $this->db->table('shippingcompany')
                         ->insert($data);
    }
    
    public function getShipping_CompanysortOrder()
    {
        return $rowdata=$this->db->table('shippingcompany')
                         ->selectMax('shippingcompany.sequence')
                        ->get()->getRowArray();
                //echo $this->db->getLastQuery();
                //die;
                
       
    }
    


}