<?php 
namespace App\Models;
use CodeIgniter\Model;

class MasterModel extends Model
{
    public function __construct()
    {
        parent::__construct();
     // OR $this->db = db_connect();
    }
    
    public function getlanguage()
    {
        return $language = $this->db->table('language')
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function GetMaxId($table,$field)
    {
        return $maxid = $this->db->table($table)
                    ->selectMax($field)
            		->get()->getRowArray();
    }
    public function GetCategoriesId($catId)
    {
        return $category = $this->db->table('category')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
                    ->where('categoryid', $catId)
            		->get()->getRowArray();
    }
    
    public function GetCategoriesSlug($catslug)
    {
        return $category = $this->db->table('category')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
                    ->where('slug', $catslug)
            		->get()->getRowArray();
    }
    public function GetCategories()
    {
         return $category = $this->db->table('category')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function GetTypeCategory($catid)
    {
        return $GetTypeCategory = $this->db->table('type')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
                    ->where('categoryid', $catid)
                    ->orderBy('sequence','ASC')
            		->get()->getResult();
    }
    
    // category
    public function insert_category($data)
    {
        return  $this->db
                ->table('category')
                ->insert($data);
    }
    public function getcategory()
    {
        return $category = $this->db->table('category')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function getcategoryID($i)
    {
        return $category = $this->db->table('category')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_category($data,$id)
    {
        return  $this->db
                ->table('category')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function update_category_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('category')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function category_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('category')
                ->where('id', $id)
                ->update($data);
    }
    
    
    
    
    
    // color
    public function insert_color($data)
    {
        return  $this->db
                ->table('color')
                ->insert($data);
    }
    public function getcolor()
    {
        return $color = $this->db->table('color')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getcolorID($i)
    {
        return $color = $this->db->table('color')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_color($data,$id)
    {
        return  $this->db
                ->table('color')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_color_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('color')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function color_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('color')
                ->where('id', $id)
                ->update($data);
    }
    
    
    // design
    public function insert_design($data)
    {
        return  $this->db
                ->table('design')
                ->insert($data);
    }
    public function getdesign()
    {
        return $design = $this->db->table('design')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getdesignID($i)
    {
        return $design = $this->db->table('design')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_design($data,$id)
    {
        return  $this->db
                ->table('design')
                ->where('id', $id)
                ->where('Status', 1)
                ->update($data);
    }
    
    public function update_design_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('design')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function design_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('design')
                ->where('id', $id)
                ->update($data);
    }
    
    // size
    public function insert_size($data)
    {
        return  $this->db
                ->table('size')
                ->insert($data);
    }
    public function getsize()
    {
        return $size = $this->db->table('size')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getsizeID($i)
    {
        return $size = $this->db->table('size')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_size($data,$id)
    {
        return  $this->db
                ->table('size')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_size_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('size')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function size_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('size')
                ->where('id', $id)
                ->update($data);
    }
    
    // stonecut
    public function insert_stonecut($data)
    {
        return  $this->db
                ->table('stonecut')
                ->insert($data);
    }
    public function getstonecut()
    {
        return $stonecut = $this->db->table('stonecut')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getstonecutID($i)
    {
        return $stonecut = $this->db->table('stonecut')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_stonecut($data,$id)
    {
        return  $this->db
                ->table('stonecut')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_stonecut_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('stonecut')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function stonecut_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('stonecut')
                ->where('id', $id)
                ->update($data);
    }
    
    // stonesize
    public function insert_stonesize($data)
    {
        return  $this->db
                ->table('stonesize')
                ->insert($data);
    }
    public function getstonesize()
    {
        return $stonesize = $this->db->table('stonesize')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getstonesizeID($i)
    {
        return $stonesize = $this->db->table('stonesize')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_stonesize($data,$id)
    {
        return  $this->db
                ->table('stonesize')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_stonesize_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('stonesize')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function stonesize_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('stonesize')
                ->where('id', $id)
                ->update($data);
    }
    
    // store
    public function insert_store($data)
    {
        return  $this->db
                ->table('store')
                ->insert($data);
    }
    public function getstore()
    {
        return $store = $this->db->table('store')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getstoreID($i)
    {
        return $store = $this->db->table('store')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_store($data,$id)
    {
        return  $this->db
                ->table('store')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_store_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('store')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function store_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('store')
                ->where('id', $id)
                ->update($data);
    }
    
    // gender
    public function insert_gender($data)
    {
        return  $this->db
                ->table('gender')
                ->insert($data);
    }
    public function getgender()
    {
        return $gender = $this->db->table('gender')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getgenderID($i)
    {
        return $gender = $this->db->table('gender')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_gender($data,$id)
    {
        return  $this->db
                ->table('gender')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_gender_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('gender')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function gender_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('gender')
                ->where('id', $id)
                ->update($data);
    }
    
    // age
    public function insert_age($data)
    {
        return  $this->db
                ->table('age')
                ->insert($data);
    }
    public function getage()
    {
        return $age = $this->db->table('age')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getageID($i)
    {
        return $age = $this->db->table('age')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_age($data,$id)
    {
        return  $this->db
                ->table('age')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_age_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('age')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function age_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('age')
                ->where('id', $id)
                ->update($data);
    }
    
    // metal
    public function insert_metal($data)
    {
        return  $this->db
                ->table('metal')
                ->insert($data);
    }
    public function getmetal()
    {
        return $metal = $this->db->table('metal')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getmetalID($i)
    {
        return $metal = $this->db->table('metal')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_metal($data,$id)
    {
        return  $this->db
                ->table('metal')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_metal_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('metal')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function metal_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('metal')
                ->where('id', $id)
                ->update($data);
    }
    
    // collection
    public function insert_collection($data)
    {
        return  $this->db
                ->table('collection')
                ->insert($data);
    }
    public function getcollection()
    {
        return $collection = $this->db->table('collection')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getcollectionID($i)
    {
        return $collection = $this->db->table('collection')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_collection($data,$id)
    {
        return  $this->db
                ->table('collection')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function update_collection_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('collection')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function collection_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('collection')
                ->where('id', $id)
                ->update($data);
    }
    // style
    public function insert_style($data)
    {
        return  $this->db
                ->table('style')
                ->insert($data);
    }
    public function getstyle()
    {
        return $style = $this->db->table('style')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getstyleID($i)
    {
        return $style = $this->db->table('style')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_style($data,$id)
    {
        return  $this->db
                ->table('style')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function update_style_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('style')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function style_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('style')
                ->where('id', $id)
                ->update($data);
    }
    // stone
    public function insert_stone($data)
    {
        return  $this->db
                ->table('stone')
                ->insert($data);
    }
    public function getstone()
    {
        return $stone = $this->db->table('stone')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getstoneID($i)
    {
        return $stone = $this->db->table('stone')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_stone($data,$id)
    {
        return  $this->db
                ->table('stone')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function update_stone_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('stone')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function stone_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('stone')
                ->where('id', $id)
                ->update($data);
    }
    
    // occasion
    public function insert_occasion($data)
    {
        return  $this->db
                ->table('occasion')
                ->insert($data);
    }
    public function getoccasion()
    {
        return $occasion = $this->db->table('occasion')
                    ->where('deleted_at', NULL)
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getoccasionID($i)
    {
        return $occasion = $this->db->table('occasion')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_occasion($data,$id)
    {
        return  $this->db
                ->table('occasion')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function update_occasion_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('occasion')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function occasion_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('occasion')
                ->where('id', $id)
                ->update($data);
    }
    public function exist_ProductMaster($product_code)
    {
        return $exist_ProductMaster = $this->db->table('products')
                    ->where('product_code', $product_code)
            		->get()->getRowArray();
    }
    
    public function GetProductMaster($productid)
    {
        return $GetProductMaster = $this->db->table('products')
                    ->where('id', $productid)
            		->get()->getRowArray();
    }
    public function Getproductimages($productid)
    {
        return $Getproductimage = $this->db->table('productimage')
                    ->where('productid', $productid)
                    ->orderBy('deleted_at','DESC')
            		->get()->getResultArray();
    }
    public function Getproductstones($productid)
    {
        return $Getproductstone = $this->db->table('productstone')
                    ->where('productid', $productid)
                    ->orderBy('deleted_at','DESC')
            		->get()->getResultArray();
    }
    
    public function Getproductothermetals($productid)
    {
        return $Getproductstone = $this->db->table('productothermetal')
                    ->where('productid', $productid)
            		->get()->getResultArray();
    }
    
    
    public function Getproductmorecertificate($productid)
    {
        return $Getproductstone = $this->db->table('productmorecertificate')
                    ->where('productid', $productid)
            		->get()->getResultArray();
    }
    
    public function Getproductvariations($productid)
    {
        return $Getproductstone = $this->db->table('productvariation')
                    ->where('productid', $productid)
                    ->orderBy('deleted_at','DESC')
            		->get()->getResultArray();
    }
    
    
    public function insert_ProductMaster($ProductMasterData)
    {
          $this->db->table('products')->insert($ProductMasterData);
          return $this->db->insertID(); 
    }
    
    public function DeleteProductImage($productimageid,$productid)
    {
        return  $this->db->table('productimage')
                ->where('productid', $productid)
                ->where('id', $productimageid)
                ->delete();
    }
    
    public function SoftDeleteProductImage($productimageid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
         return $this->db->table('productimage')
                ->where('id', $productimageid)
                ->update($data);
    }
    public function SoftDeleteProductStone($productstoneid,$productid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
         return $this->db->table('productstone')
                ->where('id', $productstoneid)
                ->where('productid', $productid)
                ->update($data);
    }
    
    public function RestoreProductStone($productstoneid,$productid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=NULL;
         return $this->db->table('productstone')
                ->where('id', $productstoneid)
                ->where('productid', $productid)
                ->update($data);
    }
    
    public function SoftDeleteProductVariation($productvariationid,$productid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
         return $this->db->table('productvariation')
                ->where('id', $productvariationid)
                ->where('productid', $productid)
                ->update($data);
    }
    
    public function RestoreProductVariation($productvariationid,$productid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=NULL;
         return $this->db->table('productvariation')
                ->where('id', $productvariationid)
                ->where('productid', $productid)
                ->update($data);
    }
    
    public function DeleteProductCertificate($productcertificateid,$productid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
         return $this->db->table('productmorecertificate')
                ->where('id', $productcertificateid)
                ->where('productid', $productid)
                ->update($data);
    }
    
    
    
    
    public function fullDeleteProductImage($productid)
    {
        return  $this->db->table('productimage')
                ->where('productid', $productid)
                ->where('deleted_at !=', NULL)
                ->delete();
    }
    public function RestoreProductImage($productimageid)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=NULL;
         return $this->db->table('productimage')
                ->where('id', $productimageid)
                ->update($data);
    }
    
    
    
    public function InserProductImage($productImageData)
    {
        $this->db->table('productimage')->insert($productImageData);
          return $this->db->insertID(); 
    }
    
    public function InserProductStone($productStoneData)
    {
        $this->db->table('productstone')->insert($productStoneData);
          return $this->db->insertID(); 
    }
    public function UpdateProductStone($productStoneData,$stoneid)
    {
         return $this->db->table('productstone')
                ->where('id', $stoneid)
                ->update($productStoneData);
                return $this->db->insertID(); 
    }
    
    
    public function InserProductOtherMetal($ProductOtherMetalData)
    {
        $this->db->table('productothermetal')->insert($ProductOtherMetalData);
          return $this->db->insertID(); 
    }
    
    
    public function deleteProductStone($productid)
    {
        return  $this->db->table('productstone')
                ->where('productid', $productid)
                ->where('deleted_at !=', null)
                ->delete();
    }
    
    public function deleteProductOtherMetal($productid)
    {
        return  $this->db->table('productothermetal')
                ->where('productid', $productid)
                ->delete();
    }
    public function deleteMoreCertificate($productid)
    {
        return  $this->db->table('productmorecertificate')
                ->where('productid', $productid)
                ->where('deleted_at !=', null)
                ->delete();
    }
    
    public function InserMoreCertificate($ProductMoreCertificateData)
    {
        $this->db->table('productmorecertificate')->insert($ProductMoreCertificateData);
          return $this->db->insertID(); 
    }
    public function UpdateMoreCertificate($ProductMoreCertificateData,$certificateid)
    {
        return  $this->db->table('productmorecertificate')
                ->where('id', $certificateid)
                ->update($ProductMoreCertificateData);
    }
    
    
    
    public function InserProductVariation($productVariationData)
    {
        $this->db->table('productvariation')->insert($productVariationData);
          return $this->db->insertID(); 
    }
    
    public function deleteProductVariation($productid)
    {
        return  $this->db->table('productvariation')
                ->where('productid', $productid)
                ->delete();
    }
    
    public function update_ProductMaster($ProductMasterData,$product_code)
    {
        return  $this->db->table('products')
                ->where('product_code', $product_code)
                ->update($ProductMasterData);
    }
    public function InserProductFinal($productfinalData,$productid,$product_code)
    {
        return  $this->db->table('products')
                ->where('product_code', $product_code)
                ->where('id', $productid)
                ->update($productfinalData);
    }
    public function UpdateProductFinal($productfinalData,$productid,$product_code)
    {
        return  $this->db->table('products')
                ->where('product_code', $product_code)
                ->where('id', $productid)
                ->update($productfinalData);
    }
    
    public function GetProductImage($productid)
    {
        return $GetProductImage = $this->db->table('productimage')
                    ->where('productid', $productid)
            		->get()->getRowArray();
    }

    public function update_product_status($status,$id)
    {
        $data=array(
            'status'=>$status
            );
        return  $this->db
                ->table('products')
                ->where('id', $id)
                ->update($data);
    }
    
    public function product_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('products')
                ->where('id', $id)
                ->update($data);
    }
    
   
    
    
    // shape
    public function insert_shape($data)
    {
        return  $this->db
                ->table('shape')
                ->insert($data);
    }
    public function getshape()
    {
        return $shape = $this->db->table('shape')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getshapeID($i)
    {
        return $shape = $this->db->table('shape')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_shape($data,$id)
    {
        return  $this->db
                ->table('shape')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_shape_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('shape')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function shape_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('shape')
                ->where('id', $id)
                ->update($data);
    }
    
    
    // lab
    public function insert_lab($data)
    {
        return  $this->db
                ->table('lab')
                ->insert($data);
    }
    public function getlab()
    {
        return $lab = $this->db->table('lab')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getlabID($i)
    {
        return $lab = $this->db->table('lab')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_lab($data,$id)
    {
        return  $this->db
                ->table('lab')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_lab_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('lab')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function lab_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('lab')
                ->where('id', $id)
                ->update($data);
    }
    
    
    // stonetype
    public function insert_stonetype($data)
    {
        return  $this->db
                ->table('stonetype')
                ->insert($data);
    }
    public function getstonetype()
    {
        return $stonetype = $this->db->table('stonetype')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getstonetypeID($i)
    {
        return $stonetype = $this->db->table('stonetype')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_stonetype($data,$id)
    {
        return  $this->db
                ->table('stonetype')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_stonetype_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('stonetype')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function stonetype_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('stonetype')
                ->where('id', $id)
                ->update($data);
    }
    
    
    
    // type
    public function insert_type($data)
    {
        return  $this->db
                ->table('type')
                ->insert($data);
    }
    public function gettype()
    {
        return $type = $this->db->table('type')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function gettypeID($i)
    {
        return $type = $this->db->table('type')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_type($data,$id)
    {
        return  $this->db
                ->table('type')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_type_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('type')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function type_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('type')
                ->where('id', $id)
                ->update($data);
    }
    
    
    // overtone
    public function insert_overtone($data)
    {
        return  $this->db
                ->table('overtone')
                ->insert($data);
    }
    public function getovertone()
    {
        return $overtone = $this->db->table('overtone')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getovertoneID($i)
    {
        return $overtone = $this->db->table('overtone')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_overtone($data,$id)
    {
        return  $this->db
                ->table('overtone')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_overtone_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('overtone')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function overtone_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('overtone')
                ->where('id', $id)
                ->update($data);
    }
    
    
      // intensity
    public function insert_intensity($data)
    {
        return  $this->db
                ->table('intensity')
                ->insert($data);
    }
    public function getintensity()
    {
        return $intensity = $this->db->table('intensity')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getintensityID($i)
    {
        return $intensity = $this->db->table('intensity')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_intensity($data,$id)
    {
        return  $this->db
                ->table('intensity')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_intensity_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('intensity')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function intensity_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('intensity')
                ->where('id', $id)
                ->update($data);
    }
    
    
    
      // clarity
    public function insert_clarity($data)
    {
        return  $this->db
                ->table('clarity')
                ->insert($data);
    }
    public function getclarity()
    {
        return $clarity = $this->db->table('clarity')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getclarityID($i)
    {
        return $clarity = $this->db->table('clarity')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_clarity($data,$id)
    {
        return  $this->db
                ->table('clarity')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_clarity_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('clarity')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function clarity_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('clarity')
                ->where('id', $id)
                ->update($data);
    }
    
    
    // gemtype
    public function insert_gemtype($data)
    {
        return  $this->db
                ->table('gemtype')
                ->insert($data);
    }
    public function getgemtype()
    {
        return $gemtype = $this->db->table('gemtype')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getgemtypeID($i)
    {
        return $gemtype = $this->db->table('gemtype')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_gemtype($data,$id)
    {
        return  $this->db
                ->table('gemtype')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_gemtype_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('gemtype')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function gemtype_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('gemtype')
                ->where('id', $id)
                ->update($data);
    }
    
    
    
    // origin
    public function insert_origin($data)
    {
        return  $this->db
                ->table('origin')
                ->insert($data);
    }
    public function getorigin()
    {
        return $origin = $this->db->table('origin')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getoriginID($i)
    {
        return $origin = $this->db->table('origin')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_origin($data,$id)
    {
        return  $this->db
                ->table('origin')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_origin_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('origin')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function origin_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('origin')
                ->where('id', $id)
                ->update($data);
    }
    
    
    // treatment
    public function insert_treatment($data)
    {
        return  $this->db
                ->table('treatment')
                ->insert($data);
    }
    public function gettreatment()
    {
        return $treatment = $this->db->table('treatment')
                     ->where('deleted_at', NULL)
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function gettreatmentID($i)
    {
        return $treatment = $this->db->table('treatment')
                    ->where('id', $i)
                    ->where('deleted_at', NULL)
            		->get()->getRowArray();
    }
    public function update_treatment($data,$id)
    {
        return  $this->db
                ->table('treatment')
                ->where('id', $id)
                ->update($data);
    }
    
    public function update_treatment_status($status,$id)
    {
        $data=array(
            'Status'=>$status
            );
        return  $this->db
                ->table('treatment')
                ->where('id', $id)
                ->where('deleted_at', NULL)
                ->update($data);
    }
    
    public function treatment_delete($id)
    {
        $date = date('Y-m-d H:i:s');
        $data['deleted_at']=$date;
        return  $this->db
                ->table('treatment')
                ->where('id', $id)
                ->update($data);
    }


    public function getunit()
    {
        return $getunit = $this->db->table('unit')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function getpolish()
    {
        return $getunit = $this->db->table('polish')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function getsymmetry()
    {
        return $getunit = $this->db->table('symmetry')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getgirdle()
    {
        return $getunit = $this->db->table('girdle')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getgirdlecondition()
    {
        return $getunit = $this->db->table('girdlecondition')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getfluoresenceintensity()
    {
        return $getunit = $this->db->table('fluoresenceintensity')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getinclusion()
    {
        return $getunit = $this->db->table('inclusion')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getmilky()
    {
        return $getunit = $this->db->table('milky')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getculetsize()
    {
        return $getunit = $this->db->table('culetsize')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    public function getculetcondition()
    {
        return $getunit = $this->db->table('culetcondition')
                     ->where('Status', 1)
            		->get()->getResultArray();
    }
    
}