<?php 
namespace App\Models;
use CodeIgniter\Model;

class OrderModel extends Model
{
    public function __construct()
    {
        parent::__construct();
     // OR $this->db = db_connect();
    }
    
    public function getlanguage()
    {
        return $language = $this->db->table('language')
                    ->where('Status', 1)
            		->get()->getResultArray();
    }
    
    public function GetMaxId($table,$field)
    {
        return $maxid = $this->db->table($table)
                    ->selectMax($field)
            		->get()->getRowArray();
    }
       
    public function orderDetail($orderno)
    {
        return $this->db->table('masterorders')
                        ->where('orderid', $orderno)
                        ->get()->getRowArray();
    }
    	public function shipmentorders()
    {
        
		return $this->db->table('masterorders')
            ->select('masterorders.*, users.first_name, users.last_name, users.email') // Add other user fields if needed
            ->join('users', 'users.id = masterorders.userid')
            ->where('masterorders.tracking_id IS NULL OR masterorders.tracking_id = ""') // Check for both NULL and empty string
            ->get()
            ->getResultArray(); // Use getRowArray() if only one row expected
    }
	
	public function shipmentorder($orderId)
    {
        
		return $this->db->table('masterorders')
                ->select('masterorders.*, users.first_name,users.last_name, users.email') // Add other user fields if needed
                ->join('users', 'users.id = masterorders.userid')
                ->where('masterorders.orderid', $orderId)
				->get()
				->getRowArray();
    }
	
	public function paymentDetail($txnid)
    {
        return $this->db->table('payments')
                        ->where('txn_id', $txnid)
                        ->get()->getRowArray();
    }
	
	
	public function ChecktrackingDetails($orderno)
    {
        return $this->db->table('ordertracking')
                        ->where('orderid', $orderno)
                        ->get()->getRowArray();
    }
    
    public function GeCustomeDetail($userid)
    {
        return $this->db->table('users')
                        ->where('id', $userid)
                        ->get()->getRowArray();
    }
	
    public function GetshippingAddress($orderno,$userid)
    {
        return $this->db->table('orderaddress')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->where('addresstype', 'shipping')
                        ->get()->getRowArray();
    }
    
    public function GetbillingAddress($orderno,$userid)
    {
        return $this->db->table('orderaddress')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->where('addresstype', 'billing')
                        ->get()->getRowArray();
    }
    
    public function GetpaymentDetail($orderno,$userid)
    {
        return $this->db->table('payments')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->get()->getRowArray();
    }
	
	public function GetTrackingDetail($orderno,$userid)
	{
		return $this->db->table('ordertracking')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->get()->getRowArray();
	}
	
	public function GetStatusDetail($status)
	{
		return $this->db->table('orderstatus')
                        ->where('slug', $status)
                        ->where('Status', 1)
                        ->get()->getRowArray();
	}
    
    public function GetInvoicessummaryData($orderno,$userid,$page,$count)
    {
        if($page<=1)
        {
            $start=0;
        }
        else
        {
            $start=($page-1)*$count;
        }
        return $this->db->table('orderitems')
                        ->where('userid', $userid)
                        ->where('orderid', $orderno)
                        ->limit($count, $start)
                        ->get()->getResult();
    }
    
    public function Invoicessummary($orderno,$userid)
    {
		return $data = $this->db->table('orderitems')
                                ->where('userid', $userid)
                                ->where('orderid', $orderno)
                                ->get()->getResultArray();				
    }
	
	public function getorderStatus()
	{
		return $data = $this->db->table('orderstatus')
                        ->where('Status', 1)
						->orderBy('sequence', 'ASC')
                        ->get()->getResultArray();	
	}
	
	public function getTrackingCompanies()
	{
		return $data = $this->db->table('shippingcompany')
                        ->where('Status', 1)
						->orderBy('sequence', 'ASC')
                        ->get()->getResultArray();	
	}
	
	
	public function shippingcompanyDetail($shipping_company_slug)
	{
		return $data = $this->db->table('shippingcompany')
                        ->where('Status', 1)
						->where('slug', $shipping_company_slug)
                        ->get()->getRowArray();	
	}
	
	
	
	
    
    public function orderRefund($orderid)
    {
        $data=array(
            'status'=>'refunded'
            );
        return  $this->db
                ->table('masterorders')
                ->where('orderid', $orderid)
                ->update($data);
    }
	
	public function updateOrderStatus($orderid,$status)
	{
		$data=array(
            'status'=>$status
            );
		return  $this->db
                ->table('masterorders')
                ->where('orderid', $orderid)
                ->update($data);
		
	}
	
	public function updatetrackingDetails($orderno,$trackingDetails)
	{
		return  $this->db
                ->table('ordertracking')
                ->where('orderid', $orderno)
                ->update($trackingDetails);
		
	}
	
	public function inserttrackingDetails($orderno,$trackingDetails)
	{
		return  $this->db
                ->table('ordertracking')
                ->insert($trackingDetails);
		
	}
	
	public function insertOrderStatusHistory($orderStatusHistory)
	{
		return  $this->db
                ->table('orderstatushistory')
                ->insert($orderStatusHistory);
		
	}
	
	
	
	public function updateOrderinvoice($orderid,$invoiceupdate)
	{
		return  $this->db->table('masterorders')
                ->where('orderid', $orderid)
                ->update($invoiceupdate);
		
	}
	
	public function update_productsreview_status($status,$id)
    {
        $data=array(
            'status'=>$status
            );
        return  $this->db
                ->table('productreview')
                ->where('id', $id)
                ->update($data);
    }
    public function update_ordersreview_status($status,$id)
    {
        $data=array(
            'status'=>$status
            );
        return  $this->db
                ->table('orderreview')
                ->where('id', $id)
                ->update($data);
    }
    
    
	
	
	
	public function ProductDetailId($productid)
	{
	    
	}
	
    public function orderdeliveredstatus($orderid,$userid)
    {
        return $data = $this->db->table('orderstatushistory')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('status', 'delivered')
                        ->get()->getRowArray();	   
    }
     public function orderItemDetail($orderid, $userid, $product_id)
    {
        return $data = $this->db->table('orderitems')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('productid', $product_id)
                        ->get()->getRowArray();
        
    }	
    
       public function orderitemreturnSubmit($returndata)
    {
        return  $this->db->table('returns')
                         ->insert($returndata);    
    }
    public function markItemReturned($orderid, $userid, $product_id)
    {
         return  $this->db->table('orderitems')
                        ->where('userid', $userid)
                        ->where('orderid', $orderid)
                        ->where('productid', $product_id) 
                        ->update(['status' => 'returned']);  
       
    }
    public function getOrderStatusHistory($orderid)
{
    // Query to join orderstatushistory and orderstatus tables
    return $this->db->table('orderstatushistory osh')
                    ->join('orderstatus os', 'osh.status = os.slug', 'left') // Join on the status (slug) field
                    ->where('osh.orderid', $orderid) // Filter by orderid
                    ->orderBy('osh.id', 'ASC') // Order by sequence
                    ->select('osh.id, osh.orderid, osh.status, osh.update_date, os.status_title') // Select necessary columns
                    ->get()
                    ->getResultArray(); // Return results as an array
}
    
    
}