<?php

namespace App\Models;

use CodeIgniter\Model;

class OrderShipmentModel extends Model
{
    protected $table      = 'ordershipment';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'order_id',
        'tracking_number',
        'billing_weight',
        'transportation_charges',
        'service_options_charges',
        'ShipmentIdentificationNumber',
        'total_charges',
        'shipping_label',
        'label_file',
		'label_type',
		'status',
		'shipper_id',
		'warehouse_id',
		'weight',
		'length',
		'height',
		'service_code',
		'dimension_unit',
		'weight_unit',
		'servicedesc',
		'package_type',
		'packagedesc',
        'pickup_prn',
		'rate_code',
		'rate_description',
		'sat_wst',
		'sun_wst',
		'TransactionIdentifier',
		'CustomerContext',
		'pickup_requested_at',
		'created_at',
    ];
	
    // Enable timestamps if you want to automatically manage created_at and updated_at
    protected $useTimestamps = false; // Since we are manually setting `created_at`

    // Use soft deletes if needed
    protected $useSoftDeletes = false;

    // Automatically populate `created_at` field when inserting
    protected $dateFormat = 'datetime';

    // Add any custom methods if needed, e.g., for saving shipment data.
	
	public function getShipmentByOrder($orderId)
	{
		return $this->where('order_id', $orderId)->findAll();
	}
}
