<?php 
namespace App\Models;
use CodeIgniter\Model;

class UpsModel extends Model
{
		protected $client_id;
		protected $client_secret;
		protected $redirect_uri;
		protected $base_url;
		protected $account_number;
		protected $transactionSrc;

		public function __construct()
		{
			parent::__construct();
			
			helper('site_helper'); // Load the helper
			$upsCompany = $this->db->table('shippingcompany')
				->where('slug', 'ups')
				->get()
				->getRowArray();

			if (!$upsCompany || empty($upsCompany['api_details'])) {
				log_message('error', 'UPS API details not found in shipping company');
				return;
			}
			
			$api_details = json_decode($upsCompany['api_details'], true);
			$sandbox = isset($api_details['sandbox']) && $api_details['sandbox'] === 'true';

			$this->client_id      = $sandbox ? $api_details['sandbox_client_id'] : $api_details['product_client_id'];
			$this->client_secret  = $sandbox ? $api_details['sandbox_client_secret'] : $api_details['product_client_secret'];
			$this->base_url       = $sandbox ? $api_details['sandbox_url'] : $api_details['product_url'];
			$this->account_number = $api_details['account_number'] ?? '';			
			$this->transactionSrc = $sandbox ? 'testing' : 'production';
		}
		 public function Getshippingcompany($slug)
		{
			 return $shippingcompany = $this->db->table('shippingcompany')
										 ->where('slug', $slug)
										 ->where('Status', 1)
										 ->get()->getRowArray();
		}
	
	public function warehouses()
	{
		return $this->db->table('warehouse')
                        ->get()->getResultArray();
	}
	
	public function ShipFrom($warehouseid)
	{
		return $this->db->table('warehouse')
				->select('warehouse.*, states.iso2 AS state_iso2, country.iso2 AS country_iso2')
				->join('states', 'states.id = warehouse.regionId', 'left')
				->join('country', 'country.country_id = warehouse.countryId', 'left')
				->where('warehouse.id', $warehouseid)
				->get()
				->getRowArray();
	}
	
	public function ShipTo($orderno)
    {
        
		return $this->db->table('orderaddress')
				->select('orderaddress.*, states.iso2 AS state_iso2, country.iso2 AS country_iso2')
				->join('states', 'states.id = orderaddress.regionid', 'left')
				->join('country', 'country.country_id = orderaddress.countryid', 'left')
				->where('orderaddress.orderid', $orderno)
				->where('orderaddress.addresstype', 'shipping')
				->get()
				->getRowArray();
    }
	public function shipper($shipperId)
    {
        
		return $this->db->table('shippers')
				->select('shippers.*, states.iso2 AS state_iso2, country.iso2 AS country_iso2')
				->join('states', 'states.id = shippers.regionId', 'left')
				->join('country', 'country.country_id = shippers.countryId', 'left')
				->where('shippers.id', $shipperId)
				->get()
				->getRowArray();
						
    }
	
	public function totalOrderPcs($orderno)
	{
		return $this->db->table('orderitems')
			->selectSum('pcs')
			->where('orderid', $orderno)
			->get()
			->getRowArray();
	}
	
	
	
	public function updateTrackingNumber($orderId, $trackingNumber)
	{
		return $this->db->table('masterorders')
						->where('orderid', $orderId)
						->update([
                           'tracking_id'   => $trackingNumber,
                           'tracking_status' => 'shipped',
                           'status'  => 'shipped'
                       ]);
	}
	
	public function updatePickupdata($shipmentid, $insertData)
	{
		return $this->db->table('ordershipment')
						->where('id', $shipmentid)
						->update($insertData);
	}
	
	
	
	

    public function getAccessToken()
    {
        $client = \Config\Services::curlrequest();
        $auth = base64_encode("{$this->client_id}:{$this->client_secret}");

        $response = $client->post($this->base_url.'/security/v1/oauth/token', [
            'headers' => [
                'Authorization' => 'Basic ' . $auth,
                'Content-Type'  => 'application/x-www-form-urlencoded',
            ],
            'form_params' => [
                'grant_type' => 'client_credentials',
            ],
        ]);

        $body = json_decode($response->getBody(), true);
        return $body['access_token'] ?? null;
    }

   public function createShipment($accessToken, $shipmentData)
{
    try {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->base_url.'/api/shipments/v1/ship',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($shipmentData),
            CURLOPT_HTTPHEADER => array(
                'transId: ' . uniqid(), // Optional, but UPS recommends a unique ID
                'transactionSrc: '.$this->transactionSrc,
                'Content-Type: application/json',
                'Authorization: Bearer ' . $accessToken
            ),
        ));

        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        if (curl_errno($curl)) {
            $error = curl_error($curl);
            curl_close($curl);
            return [
                'status'  => 'error',
                'message' => 'CURL Error',
                'error'   => $error
            ];
        }

        curl_close($curl);

        // Try to decode the JSON response
        $decodedResponse = json_decode($response, true);

        if ($httpCode >= 200 && $httpCode < 300) {
            return [
                'status'   => 'success',
                'message'  => 'Shipment created successfully.',
                'data'     => $decodedResponse
            ];
        } else {
            return [
                'status'  => 'error',
                'message' => 'UPS API Error',
                'data'    => $decodedResponse,
                'httpCode'=> $httpCode
            ];
        }
    } catch (\Exception $e) {
        return [
            'status'  => 'error',
            'message' => 'Exception occurred',
            'error'   => $e->getMessage()
        ];
    }
	
	
	
}

public function createPickup($accessToken, $pickupData)
{
	try {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->base_url.'/api/pickupcreation/v2403/pickup',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($pickupData),
            CURLOPT_HTTPHEADER => array(
                'transId: ' . uniqid(), // Optional, but UPS recommends a unique ID
                'transactionSrc: '.$this->transactionSrc,
                'Content-Type: application/json',
                'Authorization: Bearer ' . $accessToken
            ),
        ));

        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        if (curl_errno($curl)) {
            $error = curl_error($curl);
            curl_close($curl);
            return [
                'status'  => 'error',
                'message' => 'CURL Error',
                'error'   => $error
            ];
        }

        curl_close($curl);

        // Try to decode the JSON response
        $decodedResponse = json_decode($response, true);

        if ($httpCode >= 200 && $httpCode < 300) {
            return [
                'status'   => 'success',
                'message'  => 'Pickup created successfully.',
                'data'     => $decodedResponse
            ];
        } else {
            return [
                'status'  => 'error',
                'message' => 'UPS API Error',
                'data'    => $decodedResponse,
                'httpCode'=> $httpCode
            ];
        }
    } catch (\Exception $e) {
        return [
            'status'  => 'error',
            'message' => 'Exception occurred',
            'error'   => $e->getMessage()
        ];
    }
}

public function cancelShipment($accessToken, $shipmentIdentificationNumber,$trackingNumber)
{
	//echo $accessToken;
	//die;
    // Initialize cURL session
    $curl = curl_init();
    $version = 'v2';
	$url = $this->base_url . "/api/shipments/{$version}/void/cancel/{$shipmentIdentificationNumber}?trackingnumber={$trackingNumber}";
    // Set cURL options
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true, // Ensure the response is returned as a string
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30, // Timeout set to 30 seconds to avoid hanging requests
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'DELETE', // POST request for void operation
        CURLOPT_HTTPHEADER => array(
            'transactionSrc: '.$this->transactionSrc, // If applicable, keep this header or remove it if unnecessary
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken // Use the actual access token
        ),
       
    ));

    // Execute cURL request
    $response = curl_exec($curl);

    // Get the HTTP status code from the response
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    // Check if there was a cURL error
    if (curl_errno($curl)) {
        // Log or handle cURL error more gracefully
        return [
            'status' => 'error',
            'message' => 'cURL Error: ' . curl_error($curl),
        ];
    }

    // Close the cURL session
    curl_close($curl);

    // Decode the JSON response into an array
    $decodedResponse = json_decode($response, true);

    // Handle the response based on the HTTP code
    if ($httpCode >= 200 && $httpCode < 300) {
        // Success response
        return [
            'status' => 'success',
            'message' => 'Shipment cancelled successfully.',
            'data' => $decodedResponse
        ];
    } else {
        // Error response
        return [
            'status' => 'error',
            'message' => 'Failed to cancel shipment. Please check your request.',
            'data' => $decodedResponse,
            'httpCode' => $httpCode
        ];
    }
}


public function cancelPickup($accessToken, $transactionIdentifier, $pickupPrn)
{
	
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $this->base_url.'/api/shipments/v2/pickup/02',
        CURLOPT_RETURNTRANSFER => true, // Ensure the response is returned as a string
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30, // Timeout set to 30 seconds to avoid hanging requests
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'DELETE', // POST request for void operation
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
			 'Prn: ' . $pickupPrn,
			 'transId: ' . $transactionIdentifier,
			 'transactionSrc: '.$this->transactionSrc,
            'Authorization: Bearer ' . $accessToken
        ]
    ]);

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    if (curl_errno($curl)) {
        return [
            'status' => 'error',
            'message' => 'cURL Error: ' . curl_error($curl)
        ];
    }

    curl_close($curl);
    $decoded = json_decode($response, true);
    if ($httpCode >= 200 && $httpCode < 300) {
        return [
            'status' => 'success',
            'message' => 'Pickup cancelled successfully.',
            'data' => $decoded
        ];
    } else {
        return [
            'status' => 'error',
            'message' => 'Failed to cancel pickup.',
            'httpCode' => $httpCode,
            'data' => $decoded
        ];
    }
}


}