<style>
.main-content .page-content .main-body-top-status-bar {
    align-items: center;
    display: flex;
    gap: 15px;
    margin-bottom: 10px;
}
    .main-content .page-content .common-modal .modal-content {
    border: none;
    border-radius: 20px;
    padding: 30px 15px 27px;
    text-align: center;
    width: 480px;
}
.main-content .page-content .common-modal .modal-body {
    flex: none;
    padding: 0;
}
  .main-content .page-content .placeholder-up-input {
    height: 2.08vw;
    position: relative;
    width: 250px;
} 
.main-content .page-content .placeholder-up-input-field {
    -webkit-appearance: none;
    appearance: none;
    background: #fff;
    border: 0.5px solid #5cc7c1;
    border-radius: 5px;
    color: #2a2a2a;
    display: block;
    font-size: clamp(10px,.93vw,16px);
    height: 100%;
    outline: none;
    padding: 0 0.52vw;
    width: 100%;
}

.main-content .page-content .placeholder-up-input.textarea {
    min-height: 5vw;
    width: 100%;
}

.main-content .page-content .placeholder-up-input-label {
    background-color: #0000;
    color: #a4a4a4;
    font-size: clamp(10px,.93vw,16px);
    height: auto;
    left: 0.52vw;
    line-height: normal;
    padding: 0;
    pointer-events: none;
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    transition: .3s;
    white-space: nowrap;
    width: auto;
}



.main-content .page-content .placeholder-up-input>.form-select~label, .main-content .page-content .placeholder-up-input>.placeholder-up-input-field-plaintext~label, .main-content .page-content .placeholder-up-input>.placeholder-up-input-field:focus~label, .main-content .page-content .placeholder-up-input>.placeholder-up-input-field:not(:placeholder-shown)~label {
    background-color: #fff;
    font-size: clamp(11px,.625vw,12px);
    height: auto;
    left: 0.52vw;
    opacity: 1!important;
    padding: 0 0.364vw;
    top: -3px;
    transform: translateY(-50%);
    transition: .3s;
    width: auto;
}

.main-content .page-content .com-btn {
    background: #5cc7c1;
    border: none;
    border-radius: 20px;
    box-shadow: 0 2px 5px #e5e5e5;
    color: #fff;
    font-size: 20px;
    padding: 4px 19px;
    text-decoration: none;
    text-transform: capitalize;
}
</style>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
             <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Employee</h4>
                                        <p class="card-title-desc">All Employee Details</p>
                                    </div>
                                    <div class="card-body">
                                      <div class="main-body-top-status-bar">
                                            <a class="main-body-top-inputs-bar-col-right-submit-btn com-btn ms-auto d-flex align-items-center" href="<?=base_url()?>admin/user/addemployee">
                                            <i class="bx bx-plus label-icon me-2"></i>
                                            </i>Create</a></div>
                                      
                                        <table id="employee_datatable" class="table table-bordered dt-responsive  nowrap w-100">
                                            <thead>
                                            <tr>
                                                <th>Sr.no</th>
                                                <th>Image</th>
                                                <th>Name</th>
                                                <th>Email</th>
                                                <th>Mobile</th>
                                                <th>Position</th>
                                                <th>Role</th>
                                                <th>Password</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
        
                             
        </div>    
    </div>        
</div>             
    <script type="text/javascript">
   $(document).ready(function(){
       
       var datatable=$('#employee_datatable').DataTable({
         'processing': true,
         'serverSide': true,
         'serverMethod': 'post',
         'ajax': {
            'url':"<?=site_url('admin/user/getemployee')?>",
            'data': function(data){
            //   // CSRF Hash
            //   var csrfName = $('.txt_csrfname').attr('name'); // CSRF Token name
            //   var csrfHash = $('.txt_csrfname').val(); // CSRF hash

               return {
                  data: data,
               };
            },
            dataSrc: function(data){
              // Update token hash
            //   $('.txt_csrfname').val(data.token);
              // Datatable data
              return data.aaData;
            }
         },
         'columns': [
            { data: 'id' },
            { data: 'image' },
            { data: 'firstname' },
            { data: 'email' },
            { data: 'mobile' },
            { data: 'position' },
            { data: 'role' },
            { data: 'password' },
            { data: 'Status' },
            { data: 'action' },
         ]
      });

        $(document).on('change', '#employee_datatable :checkbox', function(){
            var id=$(this).val();
            if (this.checked) {
               var status=1;
            } else {
              var status=0;
            }
            $.ajax({
                type: "POST",
                url: "<?=site_url('Admin/User/employeestatus')?>",
                data: {status: status,id:id},
                success: function (result) {
                    notifi("Employee Status Successfully Update.", "success");
                }
            });
        });
        
        $(document).on('click', '.delete-record', function(){
            var id=$(this).data("id");
            Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/User/employeedelete')?>",
                        data: {id:id},
                        success: function (result) {
                            notifi("Employee Successfully Delete.", "success");
                            datatable.draw();
                        }
                    });
                }
                else
                {
                    
                }
            });
        });
   });
   
</script>