<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
             <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Appointments</h4>
                                        <!--<p class="card-title-desc"></p>-->
                                    </div>
                                    <div class="card-body">
                                       
                                        <table id="appointments_datatable" class="table table-bordered dt-responsive  nowrap w-100">
                                            <thead>
                                            <tr>
                                                <th>Sr.no</th>
                                                <th>User Name</th>
                                                <th>Email</th>
                                                <th>Phone</th>
                                                <th>Appointment Date</th>
                                                <th>Office</th>
                                                <th>Comment</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
        
                             
        </div>    
    </div>        
</div>             
    <script type="text/javascript">
   $(document).ready(function(){
       if($('#typeFilter').val()=='service')
       {
           var isVisibleService = true;
           var isVisibleProduct = true;
       }
       else
       {
           var isVisibleService = true;
           var isVisibleProduct = true;
       }
       var datatable=$('#appointments_datatable').DataTable({
         'processing': true,
         'serverSide': true,
         'serverMethod': 'post',
         'ajax': {
            'url':"<?=site_url('Admin/More/getappointments')?>",
            'data': function(data){
                data.typeFilter = $('#typeFilter').val();
            //   // CSRF Hash
            //   var csrfName = $('.txt_csrfname').attr('name'); // CSRF Token name
            //   var csrfHash = $('.txt_csrfname').val(); // CSRF hash

               return {
                  data: data,
               };
            },
            dataSrc: function(data){
              // Update token hash
            //   $('.txt_csrfname').val(data.token);
              // Datatable data
              return data.aaData;
            }
         },
         'columns': [
            { data: 'id' },
            { data: 'first_name' },
            { data: 'email' },
            { data: 'phone' },
            { data: 'appointment_date' },
            { data: 'office' },
            { data: 'comment' },
            { data: 'status' },
            { data: 'action' },
         ]
      });
      
      $('#typeFilter').change(function(event) {
        datatable.ajax.reload();
    });

        $(document).on('change', '#appointmentStatus', function(){
            var status=$(this).val();
            var appointmentid=$(this).data("appointmentid");
            Swal.fire({
            title: "Are you sure?",
            text: "You won't be "+status+" This Appointment.",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, Change it!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                    $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/More/appointmentstatus')?>",
                        data: {status: status,appointmentid:appointmentid},
                        success: function (result) {
                            $.notify("Appointment Status Successfully Update.", "success");
                        }
                    });
                }
                else
                {
                    
                }
            });
        });
    
        $(document).on('click', '.delete-record', function(){
            var id=$(this).data("id");
            Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/More/appointmentdelete')?>",
                        data: {id:id},
                        success: function (result) {
                            $.notify("Appointment Successfully Delete.", "success");
                            datatable.draw();
                        }
                    });
                }
                else
                {
                    
                }
            });
        });
   });
</script>