<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Create Pickup</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?=base_url()?>admin/shipment">Shipments</a></li>
                                <li class="breadcrumb-item active">Create Pickup</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
				  <form action="<?= base_url('admin/submit-pickup') ?>" method="post" id="pickupForm">
				  <input type="hidden" name="id" value="<?=$shipment['id']?>">
				  
					<?= csrf_field() ?>

					<!-- Select Order (Receiver Details Auto-Fill) -->
					<div class="mb-3">
						<label for="tracking_number" class="form-label">Tracking Number</label>
						
							<input type="text" name="tracking_number" id="tracking_number" readonly value="<?=$shipment['tracking_number']?>" class="form-control" required>
							<div id="orderValidationMsg" class="text-danger mt-1" style="display: none;"></div>
					</div>
					<div class="mb-3">
						<label for="order_id" class="form-label">Order No</label>						
					    <input type="text" readonly value="<?=$shipment['order_id']?>" name="order_id" id="order_id" class="form-control" required>
							
					</div>
					
					<?php
					//print_r($shipment);
					?>
					<!-- Shipper Selection Tabs -->
					<div class="mb-3">
						<label for="shipper_id" class="form-label">Select Shipper</label>
						<select name="shipper_id" id="shipper_id" class="form-control" required>
							<option value="">-- Select Shipper --</option>
							<?php foreach ($shippers as $shipper): ?>
								<option value="<?= $shipper['id'] ?>" <?php if($shipper['id']==$shipment['shipper_id']) { echo "selected"; }  ?>><?= $shipper['title'] ?> - <?= $shipper['account_number'] ?></option>
							<?php endforeach; ?>
						</select>
					</div>
					
					<div class="mb-3">
						<label for="warehouse_id" class="form-label">Select Warehouse</label>
						<select name="warehouse_id" id="warehouse_id" class="form-control" required>
							<option value="">-- Select Warehouse --</option>
							<?php foreach ($warehouses as $warehouse): ?>
								<option value="<?= $warehouse['id'] ?>" <?php if($warehouse['id']==$shipment['warehouse_id']) { echo "selected"; }  ?>><?= $warehouse['title'] ?></option>
							<?php endforeach; ?>
						</select>
					</div>
					<div class="mb-3">
						<label for="pickupDate" class="form-label">Pickup Date</label>
						<input type="text" name="pickup_date" id="pickupDate" class="form-control" placeholder="DD-MM-YYY" required>
					</div>
					
					<div class="mb-3">
						<label for="readyTime" class="form-label">Ready Time (HH:MM)</label>
						<input type="text" name="ready_time" id="readyTime" class="form-control" placeholder="e.g., 05:00" required>
					</div>
					
					<div class="mb-3">
						<label for="closeTime" class="form-label">Close Time (HH:MM)</label>
						<input type="text" name="close_time" id="closeTime" class="form-control" placeholder="e.g., 14:00" required>
					</div>
					
					<div class="mb-3">
						<label for="specialInstructions" class="form-label">Special Instructions</label>
						<input type="text" name="specialInstructions" id="specialInstructions" class="form-control" >
					</div>
					
	

					<button type="submit" class="btn btn-primary">Create Pickup</button>
				</form>
				<br>
                </div>
            </div>
        </div>    
    </div>
</div>    
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    // Initialize Flatpickr for Pickup Date (Date Picker)
    flatpickr("#pickupDate", {
        dateFormat: "d-m-Y", // Display format: DD-MM-YYYY
    });

    // Initialize Time Picker for Ready Time
    flatpickr("#readyTime", {
        enableTime: true,
        noCalendar: true,
        dateFormat: "H:i", // HH:MM format
        time_24hr: true, // Use 24-hour time
    });

    // Initialize Time Picker for Close Time
    flatpickr("#closeTime", {
        enableTime: true,
        noCalendar: true,
        dateFormat: "H:i", // HH:MM format
        time_24hr: true, // Use 24-hour time
    });
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
	const labelTypeSelect = document.getElementById('label_type');
	const zplDimensions = document.getElementById('zpl-dimensions');

	labelTypeSelect.addEventListener('change', function () {
		if (this.value === 'ZPL') {
			zplDimensions.style.display = 'block';
		} else {
			zplDimensions.style.display = 'none';
		}
	});
});
</script>
<script>
$(document).ready(function () {
    $('#pickupForm').on('submit', function (e) {
        e.preventDefault(); // prevent default form submit

        // Check for required fields manually
        let valid = true;
        $('#pickupForm').find('select, input').each(function () {
            if ($(this).prop('required') && $(this).val().trim() === '') {
                $(this).addClass('is-invalid');
                valid = false;
            } else {
                $(this).removeClass('is-invalid');
            }
        });

        if (!valid) {
            alert('Please fill all required fields.');
            return false;
        }

        let formData = $(this).serialize();

        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function () {
                // optional loader or button disable
            },
            success: function (response) {
                if (response.status === 'success') {
                  
                      $.notify("Pickup created successfully!", "success");
                    // optionally redirect or reset form
                    $('#pickupForm')[0].reset();
                } else {
                  
                      $.notify('Error: ' + response.error, "error");
                }
            },
            error: function (xhr) {
                console.log(xhr.responseText);
              
                 $.notify('Something went wrong while creating the Pickup.', "error");
            }
        });
    });
    
    $('#order_id').on('blur', function () {
    var orderId = $(this).val();

    if (orderId !== '') {
        $.ajax({
            url: '<?= site_url('admin/checkOrderExists') ?>',
            type: 'POST',
            data: { order_id: orderId },
            dataType: 'json',
            success: function (response) {
                if (response.status === 'error') {
                    $('#orderValidationMsg')
                        .removeClass('text-success')
                        .addClass('text-danger')
                        .text(response.message)
                        .show();
                } else {
                    $('#orderValidationMsg')
                        .removeClass('text-danger')
                        .addClass('text-success')
                        .text('Order number matched successfully.')
                        .show();
                }
            },
            error: function () {
                $('#orderValidationMsg').text('Unable to validate order. Please try again.').show();
            }
        });
    } else {
        $('#orderValidationMsg').hide();
    }
});

});
</script>

<script>

    // Automatically select the dimension unit based on the weight unit
    document.getElementById('weight_unit').addEventListener('change', function() {
        var weightUnit = this.value;
        var dimensionUnit = document.getElementById('dimension_unit');
        
        // If weight unit is LBS, select IN
        if (weightUnit === 'LBS') {
            dimensionUnit.value = 'IN';
        } 
        // If weight unit is KG, select CM
        else if (weightUnit === 'KGS') {
            dimensionUnit.value = 'CM';
        }
    });

    // Automatically select the weight unit based on the dimension unit
    document.getElementById('dimension_unit').addEventListener('change', function() {
        var dimensionUnit = this.value;
        var weightUnit = document.getElementById('weight_unit');
        
        // If dimension unit is IN, select LBS
        if (dimensionUnit === 'IN') {
            weightUnit.value = 'LBS';
        } 
        // If dimension unit is CM, select KG
        else if (dimensionUnit === 'CM') {
            weightUnit.value = 'KGS';
        }
    });


  // Function to update the hidden field with the service description
  document.getElementById('service_code').addEventListener('change', function() {
    // Get the selected option's text content
    var serviceDesc = this.options[this.selectedIndex].text;

    // Set the description in the hidden input field
    document.getElementById('servicedesc').value = serviceDesc;
  });
  
    // Function to update the hidden field with the service description
  document.getElementById('package_type').addEventListener('change', function() {
    // Get the selected option's text content
    var packageDesc = this.options[this.selectedIndex].text;

    // Set the description in the hidden input field
    document.getElementById('packagedesc').value = packageDesc;
  });
  
  document.getElementById('dimension_unit').addEventListener('change', function() {
    // Get the selected option's text content
    var dimension_unitDesc = this.options[this.selectedIndex].text;

    // Set the description in the hidden input field
    document.getElementById('dimensionunitdesc').value = dimension_unitDesc;
  });
</script>
