<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Create Shipment</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?=base_url()?>admin/order">Orders</a></li>
                                <li class="breadcrumb-item active">Create Shipment</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
				  <form action="<?= base_url('admin/submit-shipment') ?>" method="post" id="shipmentForm">
					<?= csrf_field() ?>

					<!-- Select Order (Receiver Details Auto-Fill) -->
					<div class="mb-3">
						<label for="order_id" class="form-label">Order No</label>
					
							<input type="text" name="order_id" id="order_id"  value="<?=$orderid?>" class="form-control" required>
							
							 <div id="orderValidationMsg" class="text-danger mt-1" style="display: none;"></div>
					</div>

					<!-- Shipper Selection Tabs -->
					<div class="mb-3">
						<label for="shipper_id" class="form-label">Select Shipper</label>
						<select name="shipper_id" id="shipper_id" class="form-control" required>
							<option value="">-- Select Shipper --</option>
							<?php foreach ($shippers as $shipper): ?>
								<option value="<?= $shipper['id'] ?>"><?= $shipper['title'] ?> - <?= $shipper['account_number'] ?></option>
							<?php endforeach; ?>
						</select>
					</div>
					
					<div class="mb-3">
						<label for="warehouse_id" class="form-label">Select Warehouse</label>
						<select name="warehouse_id" id="warehouse_id" class="form-control" required>
							<option value="">-- Select Warehouse --</option>
							<?php foreach ($warehouses as $warehouse): ?>
								<option value="<?= $warehouse['id'] ?>"><?= $warehouse['title'] ?></option>
							<?php endforeach; ?>
						</select>
					</div>

					<div class="mb-3">
    <label class="form-label">Package Type</label>
    <select name="package_type" class="form-control" id="package_type" required>
        <option value="01">UPS Letter (01)</option>
        <option value="02" selected>Customer Supplied Package (02)</option>
        <option value="03">Tube (03)</option>
        <option value="04">PAK (04)</option>
        <option value="21">UPS Express Box (21)</option>
        <option value="24">UPS 25KG Box (24)</option>
        <option value="25">UPS 10KG Box (25)</option>
        <option value="30">Pallet (30)</option>
        <option value="2a">Small Express Box (2a)</option>
        <option value="2b">Medium Express Box (2b)</option>
        <option value="2c">Large Express Box (2c)</option>
        <option value="56">Flats (56)</option>
        <option value="57">Parcels (57)</option>
        <option value="58">BPM (58)</option>
        <option value="59">First Class (59)</option>
        <option value="60">Priority (60)</option>
        <option value="61">Machineables (61)</option>
        <option value="62">Irregulars (62)</option>
        <option value="63">Parcel Post (63)</option>
        <option value="64">BPM Parcel (64)</option>
        <option value="65">Media Mail (65)</option>
        <option value="66">BPM Flat (66)</option>
        <option value="67">Standard Flat (67)</option>
    </select>
   <div class="alert alert-info mt-3">
        <strong>Note:</strong> 
        - Only packaging type code <strong>02</strong> is applicable to Ground Freight Pricing. 
        - Package types <strong>24</strong> and <strong>25</strong> are only allowed for shipments without return service. 
        - Packaging type must be valid for all of the following: ShipTo country or territory, ShipFrom country or territory, a shipment going from ShipTo to ShipFrom, all Accessorials at both the shipment and package level, and the shipment service type.
        - UPS will not accept raw wood pallets. Refer to the UPS packaging guidelines for pallets on UPS.com.
    </div>
     <input type="hidden" name="packagedesc" id="packagedesc" value="Customer Supplied Package (02)">
</div>



					<!-- Package Details -->
					<div class="mb-3">
						<label class="form-label">Package Weight</label>
						<div class="d-flex gap-2">
							<input type="text" name="weight" class="form-control" required>
							<select name="weight_unit" class="form-control" required style="width:150px;" id="weight_unit">
							
								<option value="LBS" selected>LBS</option>
									<option value="KGS">Kilograms</option>
							</select>
						</div>
					</div>

					<div class="mb-3">
						<label class="form-label">Dimensions</label>
						<div class="d-flex gap-2">
							<input type="text" name="length" placeholder="Length" class="form-control" required>
							<input type="text" name="width" placeholder="Width" class="form-control" required>
							<input type="text" name="height" placeholder="Height" class="form-control" required>
							<select name="dimension_unit" class="form-control" required style="width:150px;" id="dimension_unit">
							
								<option value="IN" selected>Inches(IN)</option>
								<option value="CM">Centimeters(CM)</option>
							</select>
							 <input type="hidden" name="dimensionunitdesc" id="dimensionunitdesc" value="Inches">
						</div>
						
						<!-- Note Message -->
<div class="alert alert-info mt-3">
  <strong>Note:</strong> 
  <ul>
    <li>Package length. Length must be the longest dimension of the container. Valid values are 0 to 108 IN and 0 to 270 CM.</li>
  
  </ul>
</div>
					</div>
					<!-- Label Type -->
					<div class="mb-3">
						<label class="form-label">Label Type</label>
						<select name="label_type" class="form-control" id="label_type" required>
							<option value="">Select Label Type</option>
							<option value="GIF">GIF</option>
							<option value="ZPL">ZPL</option>
						</select>
					</div>

					<!-- ZPL Label Size (only show when ZPL is selected) -->
					<div id="zpl-dimensions" style="display: none;">
						<div class="mb-3" style="width:100%;">
							<label class="form-label">Label Height (inches)</label>
							<input type="text" name="zpl_height"  class="form-control" placeholder="Label Height (6 inches)">
						</div>
						<div class="mb-3"  style="width:100%;">
							<label class="form-label">Label Width (inches)</label>
							<input type="text" name="zpl_width" class="form-control" placeholder="Label Width (4 inches)">
						</div>
					</div>
					
					

					<!-- Service Code -->
			
 <div class="mb-3">
  <label class="form-label">UPS Service</label>
  <select name="service_code" class="form-control service_code" id="service_code" required>
    <option value="01">Next Day Air (01)</option>
    <option value="02">2nd Day Air (02)</option>
    <option value="03" selected>Ground (03)</option>
    <option value="07">Express (07)</option>
    <option value="08">Expedited (08)</option>
    <option value="11">UPS Standard (11)</option>
    <option value="12">3 Day Select (12)</option>
    <option value="13">Next Day Air Saver (13)</option>
    <option value="14">UPS Next Day Air® Early (14)</option>
    <option value="17">UPS Worldwide Economy DDU (17)</option>
    <option value="54">Express Plus (54)</option>
    <option value="59">2nd Day Air A.M. (59)</option>
    <option value="65">UPS Saver (65)</option>
    <option value="M2">First Class Mail (M2)</option>
    <option value="M3">Priority Mail (M3)</option>
    <option value="M4">Expedited Mail Innovations (M4)</option>
    <option value="M5">Priority Mail Innovations (M5)</option>
    <option value="M6">Economy Mail Innovations (M6)</option>
    <option value="M7">Mail Innovations (MI) Returns (M7)</option>
    <option value="70">UPS Access Point™ Economy (70)</option>
    <option value="71">UPS Worldwide Express Freight Midday (71)</option>
    <option value="72">UPS Worldwide Economy DDP (72)</option>
    <option value="74">UPS Express®12:00 (74)</option>
    <option value="75">UPS Heavy Goods (75)</option>
    <option value="82">UPS Today Standard (82)</option>
    <option value="83">UPS Today Dedicated Courier (83)</option>
    <option value="84">UPS Today Intercity (84)</option>
    <option value="85">UPS Today Express (85)</option>
    <option value="86">UPS Today Express Saver (86)</option>
    <option value="96">UPS Worldwide Express Freight (96)</option>
    <option value="C6">Roadie XD AM (Morning delivery) (C6)</option>
    <option value="C7">Roadie XD PM (Afternoon delivery) (C7)</option>
    <option value="C8">Roadie XD (Anytime delivery) (C8)</option>
    <option value="T0">Master (T0)</option>
    <option value="T1">LTL (T1)</option>
  </select>
  <input type="hidden" name="servicedesc" id="servicedesc">
</div>

<!-- Note Message -->
<div class="alert alert-info mt-3">
  <strong>Note:</strong> 
  <ul>
    <li>Only service code <strong>03</strong> is used for Ground Freight Pricing shipments.</li>
    <li>The following services are not available for return shipments: <strong>13, 59, 82, 83, 84, 85, 86, C6, C7, C8</strong>.</li>
  </ul>
</div>

					<button type="submit" class="btn btn-primary">Create Shipment</button>
				</form>
				<br>
                </div>
            </div>
        </div>    
    </div>
</div>    
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
	const labelTypeSelect = document.getElementById('label_type');
	const zplDimensions = document.getElementById('zpl-dimensions');

	labelTypeSelect.addEventListener('change', function () {
		if (this.value === 'ZPL') {
			zplDimensions.style.display = 'block';
		} else {
			zplDimensions.style.display = 'none';
		}
	});
});
</script>
<script>
$(document).ready(function () {
    $('#shipmentForm').on('submit', function (e) {
        e.preventDefault(); // prevent default form submit

        // Check for required fields manually
        let valid = true;
        $('#shipmentForm').find('select, input').each(function () {
            if ($(this).prop('required') && $(this).val().trim() === '') {
                $(this).addClass('is-invalid');
                valid = false;
            } else {
                $(this).removeClass('is-invalid');
            }
        });

        if (!valid) {
            alert('Please fill all required fields.');
            return false;
        }

        let formData = $(this).serialize();

        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function () {
                // optional loader or button disable
            },
            success: function (response) {
                if (response.status === 'success') {
                  
                      $.notify("Shipment created successfully!", "success");
                    // optionally redirect or reset form
                    $('#shipmentForm')[0].reset();
                } else {
                  
                      $.notify('Error: ' + response.error, "error");
                }
            },
            error: function (xhr) {
                console.log(xhr.responseText);
              
                 $.notify('Something went wrong while creating the shipment.', "error");
            }
        });
    });
    
    $('#order_id').on('blur', function () {
    var orderId = $(this).val();

    if (orderId !== '') {
        $.ajax({
            url: '<?= site_url('admin/checkOrderExists') ?>',
            type: 'POST',
            data: { order_id: orderId },
            dataType: 'json',
            success: function (response) {
                if (response.status === 'error') {
                    $('#orderValidationMsg')
                        .removeClass('text-success')
                        .addClass('text-danger')
                        .text(response.message)
                        .show();
                } else {
                    $('#orderValidationMsg')
                        .removeClass('text-danger')
                        .addClass('text-success')
                        .text('Order number matched successfully.')
                        .show();
                }
            },
            error: function () {
                $('#orderValidationMsg').text('Unable to validate order. Please try again.').show();
            }
        });
    } else {
        $('#orderValidationMsg').hide();
    }
});

});
</script>

<script>

    // Automatically select the dimension unit based on the weight unit
    document.getElementById('weight_unit').addEventListener('change', function() {
        var weightUnit = this.value;
        var dimensionUnit = document.getElementById('dimension_unit');
        
        // If weight unit is LBS, select IN
        if (weightUnit === 'LBS') {
            dimensionUnit.value = 'IN';
        } 
        // If weight unit is KG, select CM
        else if (weightUnit === 'KGS') {
            dimensionUnit.value = 'CM';
        }
    });

    // Automatically select the weight unit based on the dimension unit
    document.getElementById('dimension_unit').addEventListener('change', function() {
        var dimensionUnit = this.value;
        var weightUnit = document.getElementById('weight_unit');
        
        // If dimension unit is IN, select LBS
        if (dimensionUnit === 'IN') {
            weightUnit.value = 'LBS';
        } 
        // If dimension unit is CM, select KG
        else if (dimensionUnit === 'CM') {
            weightUnit.value = 'KGS';
        }
    });


  // Function to update the hidden field with the service description
  document.getElementById('service_code').addEventListener('change', function() {
    // Get the selected option's text content
    var serviceDesc = this.options[this.selectedIndex].text;

    // Set the description in the hidden input field
    document.getElementById('servicedesc').value = serviceDesc;
  });
  
    // Function to update the hidden field with the service description
  document.getElementById('package_type').addEventListener('change', function() {
    // Get the selected option's text content
    var packageDesc = this.options[this.selectedIndex].text;

    // Set the description in the hidden input field
    document.getElementById('packagedesc').value = packageDesc;
  });
  
  document.getElementById('dimension_unit').addEventListener('change', function() {
    // Get the selected option's text content
    var dimension_unitDesc = this.options[this.selectedIndex].text;

    // Set the description in the hidden input field
    document.getElementById('dimensionunitdesc').value = dimension_unitDesc;
  });
</script>
