<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
             <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Email Parameters</h4>
                                        <!--<p class="card-title-desc"></p>-->
                                    </div>
                                    <div class="card-body">
                                        <a href="<?=base_url()?>admin/add-email-parameter">
                                            <button type="button" class="btn btn-light waves-effect btn-label waves-light">
                                            <i class="bx bx-plus label-icon"></i> Add Email Parameters</button>
                                        </a>
                                        <table id="email-parameter_datatable" class="table table-bordered dt-responsive  nowrap w-100">
                                            <thead>
                                            <tr>
                                                <th>Sr.no</th>
                                                <th>Template Name</th>
                                                <th>Template Slug</th>
                                                <th>Parameters</th>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
        
                             
        </div>    
    </div>        
</div>             
    <script type="text/javascript">
   $(document).ready(function(){
       var datatable=$('#email-parameter_datatable').DataTable({
         'processing': true,
         'serverSide': true,
         'serverMethod': 'post',
         'ajax': {
            'url':"<?=site_url('Admin/More/get_email_parameters')?>",
            'data': function(data){
            //   // CSRF Hash
            //   var csrfName = $('.txt_csrfname').attr('name'); // CSRF Token name
            //   var csrfHash = $('.txt_csrfname').val(); // CSRF hash

               return {
                  data: data,
               };
            },
            dataSrc: function(data){
              // Update token hash
            //   $('.txt_csrfname').val(data.token);
              // Datatable data
              return data.aaData;
            }
         },
         'columns': [
            { data: 'id' },
            { data: 'TemplateName' },
            { data: 'TemplateSlug' },
            { data: 'Parameters' },
            { data: 'Status' },
            { data: 'date' },
            { data: 'action' },
         ]
      });

        $(document).on('change', '#email-parameter_datatable :checkbox', function(){
            var id=$(this).val();
            if (this.checked) {
               var status=1;
            } else {
              var status=0;
            }
            $.ajax({
                type: "POST",
                url: "<?=site_url('Admin/More/email_parameter_status')?>",
                data: {status: status,id:id},
                success: function (result) {
                    $.notify("Email Parameters Status Successfully Update.", "success");
                }
            });
        });
        
        $(document).on('click', '.delete-record', function(){
            var id=$(this).data("id");
            Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/More/email_parameter_delete')?>",
                        data: {id:id},
                        success: function (result) {
                            $.notify("Email Parameters Successfully Delete.", "success");
                            datatable.draw();
                        }
                    });
                }
                else
                {
                    
                }
            });
        });
   });
</script>