<style>
.modal-dialog {
    max-width: 584px;
    margin: 1.75rem auto;
}
</style>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
             <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header" style="display: flex;    justify-content: space-between;">
                                        <h4 class="card-title">Pending Orders </h4>
                                        <!--<a href="<?=base_url()?>admin/reports/orderReports">-->
                                            <button class="report_button" title="Order Excel Reports"><i class="fas fa-file-excel"></i></button>
                                        <!--</a>-->
                                    </div>
                                    <div class="card-body">
                                        <!-- Custom Filter -->
                                         <table>
                                              <tr>
                                                  <td style="width: 250px;">
                                                       <div class="mb-4">
                                                            <label for="example-email-input" class="form-label">Order Date Range</label>
                                                            <input class="form-control" style="max-width: 250px;" type="text" placeholder="Order Date Range" name="datefilter" id="datepicker-range">
                                                        </div>
                                                  </td>
                                                  <td style="width: 250px;">
                                                       <div class="mb-4" style="margin-top: 28px;">
                                                            <button type="button" class="filter btn btn-success">Filter</button>
                                                        </div>
                                                  </td>
                                              </tr>
                                         </table>
                                        <table id="order_datatable" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th>Sr.no</th>
                                                <th style="min-width: 130px;">Order No.</th>
                                                <th  style="min-width: 130px;">Shipping Date</th>
                                                <th  style="min-width: 130px;">Amount</th>
												<th  style="min-width: 130px;">Payment Method</th>
												<th  style="min-width: 130px;">Payment Status</th>
                                                <th  style="min-width: 130px;">Order Status</th>
												<th  style="min-width: 130px;">Status Update</th>
                                                <th style="min-width: 130px;">Order Date</th>
                                                <th style="min-width: 130px;">Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
        
                             
        </div>    
    </div>        
</div>

   <!-- Order View modal start -->
        <div class="modal fade bookAppointment" id="orderdetailview" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                    </div>
            </div>
            </div>
        </div>
        <!-- Order View modal end -->

 <script>
        $(document).ready(function () {
            var datatable = $('#order_datatable').DataTable({
                 'processing': true,
                 'serverSide': true,
                 'serverMethod': 'post',
                 "ordering": false,
                 "scrollX":true,
                 'ajax': {
                    'url':"<?=site_url('Admin/Order/Getpendingorders')?>",
                    'data': function(data){
                        // Custom filter values
                        var daterange = $('#datepicker-range').val();

                        data.daterange = daterange;
                        
                       return {
                          data: data,
                       };
                    },
                    dataSrc: function(data){
                      return data.aaData;
                    }
                 },
                 'columns': [
                    { data: 'sr' },
                    { data: 'orderid' },
                    { data: 'ShippingDate' },
                    { data: 'amount' },
					{ data: 'paymentMethod' },
					{ data: 'paymentStatus' },
                    { data: 'orderstatus' },
					{ data: 'updateStatus' },
                    { data: 'orderdate' },
                    { data: 'action' },
                 ]
              });
          // Custom filter
              $('#orderstatus').change(function(){
                   datatable.draw();
              });
    
              $('.filter').click(function(){
                   datatable.draw();
              });
              
            $(document).on('click', '.orderview', function(){
                var orderno=$(this).data("orderid");
                
                 $.ajax({
                    type:'POST',
                    url:'<?php echo base_url('Admin/Order/ShowOrderDetail'); ?>',
                    data:'orderno='+orderno,
                    dataType: "html",
                    beforeSend:function()
                    {
                        
                    },
                    success:function(data){
                        if(data=="failed")
                        {
                            notifi("Order Not Found!","danger");
                        }
                        else
                        {
                            $("#orderdetailview .modal-body").html(data);
                            $('#orderdetailview').modal('show');
                        }
                       
                    }
                });
            }); 
            
             $(document).on('click', '.loadMoreItem', function(){
                var orderno=$(this).data("orderid");
                var page=$(this).data("page");
                 $.ajax({
                    type:'POST',
                    url:'<?php echo base_url('Admin/Order/MoreOrderItems'); ?>',
                    data:'orderno='+orderno+'&page='+page,
                    dataType: "html",
                    beforeSend:function()
                    {
                        
                    },
                    success:function(data){
                        if(data=="notdfound")
                        {
                            notifi("Not more items in this Order!","danger");
                            $(".loadmoreTR").remove();
                        }
                        else if(data=="failed")
                        {
                            notifi("Something Wrong Please Try Again!","danger");
                        }
                        else
                        {
                            $(".orderitemsbody").append(data);
                            page=$('.loadMoreItem').data("page")+1;
                            $(".loadMoreItem").data("page",page)
                        }
                       
                    }
                });
            }); 
            
            $(document).on('click', '.refundAmount', function(){
            var refundButton=$(this);    
            var orderid=$(this).data("id");
            Swal.fire({
            title: "Are you sure?",
            text: "You want Refund Amount Of this Order.",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, Refund!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/Order/refundamount')?>",
                        data: {orderid:orderid},
                        success: function (result) {
                            $.notify("Successfully Refund Amount.", "success");
                            datatable.draw();
                        }
                    });
                }
                else
                {
                    
                }
            });
            
        });
            
			$(document).on('change', '.orderStatusChange', function()
			{
            var refundButton=$(this);    
            var orderid=$(this).data("orderid");
			var status=$(this).val();
            Swal.fire({
            title: "Are you sure?",
            text: "You want to Change Order Status.",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, Change!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/Order/orderStatusChange')?>",
                        data: {orderid:orderid,status:status},
						dataType:'json',
                        success: function (result) 
						{
							if(result.status==true)
							{
								$.notify("Successfully Status Change.", "success");
								datatable.draw();
							}
							if(result.status==false)
							{
								$.notify(result.message, "danger");
								datatable.draw();
							}
                        },
						error: function()
						{
							$.notify("Something Wrong. Please try again.", "danger");
							datatable.draw();
								
						}
                    });
                }
                else
                {
                    datatable.draw();
                }
            });
            
        });
            
        });
        
       	$(document).on('click', '.report_button', function()
		{ 
		     var orderstatus = 'pending';
             var daterange = $('#datepicker-range').val();
             var orderreportUrl="<?=base_url()?>admin/reports/orderReports?orderstatus="+orderstatus+"&daterange="+daterange;
           window.location.href = orderreportUrl; //Will take you to Google.
		});
    </script>