uugu<style>
.modal-dialog {
    max-width: 584px;
    margin: 1.75rem auto;
}
</style>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
             <div class="row">
                             <div class="col-12">
                                <div class="card">
                                    <div class="card-header" style="display: flex;    justify-content: space-between;">
                                        <h4 class="card-title">Shipments </h4>
                                        
                                         <a href="<?=base_url()?>admin/create-shipment">
                                            <button type="button" class="btn btn-primary waves-effect waves-light" >
                                            <i class="bx bx-plus label-icon"></i> Create Shipment</button>
                                        </a>
                                    </div>
                                    <div class="card-body">
                                        <!-- Custom Filter -->
                                         <table>
                                              <tr>
                                                  <td style="width: 250px;">
                                                      <div class="mb-4">
                                                        <label for="example-email-input" class="form-label">Shipment Status</label>
                                                            <select id='shipmentstatus'  style="max-width: 250px;" class="form-control choiceSelect">
                                                            <option value="">All</option>
                                                            <option value="shipped" >Shipped</option>
															<option value="pickup scheduled" >Scheduled</option>
															<option value="pickup canceled" >Pickup Canceled</option>
															<option value="canceled" >Shipment Canceled</option>
															<option value="delivered" >Delivered</option>
                                                       </select>
                                                        </div>
                                                       
                                                  </td>
                                                  <td style="width: 250px;">
                                                       <div class="mb-4">
                                                            <label for="example-email-input" class="form-label">Shipment Date Range</label>
                                                            <input class="form-control" style="max-width: 250px;" type="text" placeholder="Shipment Date Range" name="datefilter" id="datepicker-range">
                                                        </div>
                                                  </td>
                                                  <td style="width: 250px;">
                                                       <div class="mb-4" style="margin-top: 28px;">
                                                            <button type="button" class="filter btn btn-success">Filter</button>
                                                        </div>
                                                  </td>
                                              </tr>
                                         </table>
                                        <table id="shipment_datatable" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th>Sr.no</th>
                                                <th style="min-width: 130px;">Order No.</th>
                                                <th style="min-width: 130px;">Tracking Number</th>
                                                <th style="min-width: 130px;">Billing Weight</th>
												<th style="min-width: 160px;">Transportation Charges</th>
												<th style="min-width: 130px;">Service Charges</th>
                                                <th style="min-width: 130px;">ShipmentIdentificationNumber</th>
												<th style="min-width: 130px;">Total Charges</th>
												<th style="min-width: 130px;">Shipping Label</th>
												<th style="min-width: 130px;">Pickup PRN</th>
                                                <th style="min-width: 130px;">Status</th>
												<th style="min-width: 130px;">Shipping Date</th>
                                                <th style="min-width: 250px;">Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
        
                             
        </div>    
    </div>        
</div>

   <!-- Order View modal start -->
        <div class="modal fade bookAppointment" id="orderdetailview" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                    </div>
            </div>
            </div>
        </div>
        <!-- Order View modal end -->
<div id="returnModal" class="modal" style="display:none;">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="returnForm">
        <div class="modal-header">
          <h4 class="modal-title">Return Reason</h4>
          <button type="button" class="close btn-close closeReturnModal">&times;</button>
        </div>
        <div class="modal-body">
          <div id="returnItems"></div>
          <div class="form-group">
            <label for="reason">Reason for Return</label>
            <textarea name="reason" class="form-control" required></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Submit Return</button>
          <button type="button" class="btn btn-secondary closeReturnModal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- Modal for large image -->
<!-- GIF Label Viewer -->
<div id="labelModal" class="modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background-color: rgba(0,0,0,0.7); z-index:9999;">
    <span style="position:absolute; top:20px; right:30px; font-size:30px; color:white; cursor:pointer;" id="closeLabelModal">&times;</span>
    <img id="modalLabelImage" src="" style="display:block; margin:50px auto; max-width:90%; max-height:90%;" />
</div>

<!-- ZPL Label Viewer -->
<div id="zplModal" class="modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background-color: rgba(0,0,0,0.7); z-index:9999;">
    <span style="position:absolute; top:20px; right:30px; font-size:30px; color:white; cursor:pointer;" id="closeZplModal">&times;</span>
    <pre id="modalZPLData" style="color:white; white-space:pre-wrap; background:#222; padding:20px; margin:60px auto; max-width:90%; max-height:80%; overflow:auto;"></pre>
    <div style="text-align:center; margin-top:10px;">
        <button onclick="printZPL()" class="btn btn-sm btn-light">Print ZPL</button>
    </div>
</div>



 <script>
        $(document).ready(function () {
            var datatable = $('#shipment_datatable').DataTable({
                 'processing': true,
                 'serverSide': true,
                 'serverMethod': 'post',
                 "ordering": false,
                 "scrollX":true,
                 'ajax': {
                    'url':"<?=site_url('admin/shipments')?>",
                    'data': function(data){
                        // Custom filter values
                        var shipmentstatus = $('#shipmentstatus').val();
                        var daterange = $('#datepicker-range').val();

                        data.shipmentstatus = shipmentstatus;
                        data.daterange = daterange;
                        
                       return {
                          data: data,
                       };
                    },
                    dataSrc: function(data){
                      return data.aaData;
                    }
                 },
                 'columns': [
					{ data: 'sr' },
					{ data: 'orderid' },
					{ data: 'trackingNumber' },
					{ data: 'billingWeight' },
					{ data: 'transportationCharges' },
					{ data: 'serviceCharges' },
					{ data: 'shipmentIdentificationNumber' },
					{ data: 'totalCharges' },
					{ data: 'shippingLabel'},
					{ data: 'pickup_prn'},
					{ data: 'shipmentstatus' },
					{ data: 'shipdate' },
					{ data: 'action' },
				]
              });
          // Custom filter
              $('#shipmentstatus').change(function(){
                   datatable.draw();
              });
    
              $('.filter').click(function(){
                   datatable.draw();
              });
			  
		$(document).on('click', '.cancelShipment', function() {
			var shipmentId = $(this).data('id');

			if (confirm('Are you sure you want to cancel this shipment?')) {
				$.ajax({
					url: '<?= site_url('admin/cancelUpsShipment') ?>',
					type: 'POST',
					data: {
						id: shipmentId
					},
					success: function(response) {
						if (response.status === 'success') {
						   $.notify({
			message: response.message || 'Shipment canceled successfully.'
		}, {
			type: "success",
			allow_dismiss: true,
			delay: 5000,
			newest_on_top: true,
			escape: false
		});

                     
                    $('#shipment_datatable').DataTable().ajax.reload(); // Refresh the DataTable
                } else {
                    // Show specific UPS error message if available
                    let errorMessage = response.message || 'Failed to cancel shipment.';
                    
                    // Optional: fallback if deeper error exists
                    if (
                        response.data &&
                        response.data.response &&
                        response.data.response.errors &&
                        response.data.response.errors[0] &&
                        response.data.response.errors[0].message
                    ) {
                        errorMessage = response.data.response.errors[0].message;
                    }

                    $.notify({
						message: 'Error: ' + errorMessage
					}, {
						type: "danger",
						allow_dismiss: true,
						delay: 5000,
						newest_on_top: true,
						escape: false
					});

									}
								},
								error: function() {
								  
									 $.notify({
						message: 'An unexpected error occurred while canceling the shipment.'
					}, {
						type: "danger",
						allow_dismiss: true,
						delay: 5000,
						newest_on_top: true,
						escape: false
					});

            }
        });
    }
});


		$(document).on('click', '.cancelPickup', function () {
			var pickupId = $(this).data('id'); // this should be the pickup record ID or PRN

			if (confirm('Are you sure you want to cancel this pickup?')) {
				$.ajax({
					url: '<?= site_url('admin/cancelUpsPickup') ?>', // Backend route to handle pickup cancellation
					type: 'POST',
					dataType: 'json',
					data: {
						id: pickupId
					},
					success: function (response) {
						if (response.status === 'success') {
							$.notify({
								message: response.message || 'Pickup canceled successfully.'
							}, {
								type: "success",
								allow_dismiss: true,
								delay: 5000,
								newest_on_top: true
							});

							$('#shipment_datatable').DataTable().ajax.reload();
						} else {
							let errorMessage = response.message || 'Failed to cancel pickup.';

							if (
								response.data &&
								response.data.response &&
								response.data.response.errors &&
								response.data.response.errors[0] &&
								response.data.response.errors[0].message
							) {
								errorMessage = response.data.response.errors[0].message;
							}

							$.notify({
								message: 'Error: ' + errorMessage
							}, {
								type: "danger",
								allow_dismiss: true,
								delay: 5000,
								newest_on_top: true
							});
						}
					},
					error: function () {
						$.notify({
							message: 'An unexpected error occurred while canceling the pickup.'
						}, {
							type: "danger",
							allow_dismiss: true,
							delay: 5000,
							newest_on_top: true
						});
					}
				});
			}
		});
	  
		});     
  </script>  
  <script>
document.addEventListener("DOMContentLoaded", function () {
    // === GIF label preview (click to view full image) ===
		   document.addEventListener('click', function (e) {
			if (e.target.classList.contains('label-preview')) {
				const fullImgUrl = e.target.getAttribute('data-full');
				const modal = document.getElementById('labelModal');
				const modalImg = document.getElementById('modalLabelImage');

				modalImg.src = fullImgUrl;
				modal.style.display = 'block';
			}
		});

		document.getElementById('closeLabelModal').addEventListener('click', function () {
			const modal = document.getElementById('labelModal');
			modal.style.display = 'none';
		});

    // === Direct ZPL printing (no modal) ===
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('viewZPL')) {
            const zpl = e.target.getAttribute('data-zpl');
            printZPL(zpl);
        }
    });
});

// Print ZPL in new tab
function printZPL(zpl) {
    const win = window.open('', '_blank');
    win.document.write('<pre>' + zpl + '</pre>');
    win.document.close();
    win.focus();
    win.print();
    win.close();
}

$(document).on('click', '.createPickup', function() {
    var shipmentId = $(this).data('id'); // Get the shipment ID

    if (confirm('Are you sure you want to create a pickup for this shipment?')) {
        // Redirect to the Create Pickup page with the shipment ID as a URL parameter
        window.location.href = '<?= site_url('admin/create-pickup') ?>/' + shipmentId;
    }
});
</script>
