<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
             <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Tax</h4>
                                        <!--<p class="card-title-desc"></p>-->
                                    </div>
                                    <div class="card-body">
                                        <a href="<?=base_url()?>admin/addtax">
                                            <button type="button" class="btn btn-light waves-effect btn-label waves-light">
                                            <i class="bx bx-plus label-icon"></i> Add Tax</button>
                                        </a>
                                        <table id="tax_datatable" class="table table-bordered dt-responsive  nowrap w-100">
                                            <thead>
                                            <tr>
                                                <th>Sr.no</th>
                                                <th>Country</th>
                                                <th>Region</th>
                                                <th>Tax</th>
                                                <th>Tax Name</th>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
        
                             
        </div>    
    </div>        
</div>             
    <script type="text/javascript">
   $(document).ready(function(){
       var datatable=$('#tax_datatable').DataTable({
         'processing': true,
         'serverSide': true,
         'serverMethod': 'post',
         'ajax': {
            'url':"<?=site_url('Admin/More/gettax')?>",
            'data': function(data){
            //   // CSRF Hash
            //   var csrfName = $('.txt_csrfname').attr('name'); // CSRF Token name
            //   var csrfHash = $('.txt_csrfname').val(); // CSRF hash

               return {
                  data: data,
               };
            },
            dataSrc: function(data){
              // Update token hash
            //   $('.txt_csrfname').val(data.token);
              // Datatable data
              return data.aaData;
            }
         },
         'columns': [
            { data: 'id' },
            { data: 'Country' },
            { data: 'Region' },
            { data: 'Tax' },
            { data: 'Tax_Name' },
            { data: 'Status' },
            { data: 'date' },
            { data: 'action' },
         ]
      });

        $(document).on('change', '#tax_datatable :checkbox', function(){
            var id=$(this).val();
            if (this.checked) {
               var status=1;
            } else {
              var status=0;
            }
            $.ajax({
                type: "POST",
                url: "<?=site_url('Admin/More/taxstatus')?>",
                data: {status: status,id:id},
                success: function (result) {
                    $.notify("Tax Status Successfully Update.", "success");
                }
            });
        });
        
        $(document).on('click', '.delete-record', function(){
            var id=$(this).data("id");
            Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            }).then(function (e) {
                if(e.isConfirmed==true)
                {
                $.ajax({
                        type: "POST",
                        url: "<?=site_url('Admin/More/taxdelete')?>",
                        data: {id:id},
                        success: function (result) {
                            $.notify("Tax Successfully Delete.", "success");
                            datatable.draw();
                        }
                    });
                }
                else
                {
                    
                }
            });
        });
   });
</script>