<!DOCTYPE html>
<html>
<head>
  <title>Order Detail</title>
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans">
  <style>
    body {
      font-family: 'Open Sans', sans-serif;
      background: #f3f3f3;
      margin: 20px;
    }
    .order-card {
      background: #fff;
      border: 1px solid #ddd;
      padding: 20px;
      margin-bottom: 30px;
      box-shadow: 0 0 8px rgba(0,0,0,0.05);
    }
    .order-header {
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      margin-bottom: 20px;
    }
    .status {
      color: green;
      font-weight: bold;
    }
    .product {
      display: flex;
      padding: 15px 0;
      border-top: 1px solid #eee;
    }
    .product img {
      width: 80px;
      height: 80px;
      object-fit: cover;
      margin-right: 15px;
    }
    .product-details {
      flex: 1;
    }
    .product-actions {
      text-align: right;
      min-width: 120px;
    }
    .product-actions button {
      background-color: #f0c14b;
      border: 1px solid #a88734;
      border-radius: 3px;
      padding: 5px 10px;
      margin-bottom: 5px;
      cursor: pointer;
    }
    .product-actions button:hover {
      background-color: #e2b33f;
    }
    .address-box {
      margin-top: 20px;
    }
  </style>
</head>
<body>

  <div class="order-card">
    <div class="order-header">
      <div><strong>Order ID:</strong> #<?= esc($order['orderid']) ?></div>
      <div><strong>Order Date:</strong> <?= date('M d, Y', strtotime($order['orderdate'])) ?></div>
      <div><strong>Status:</strong> <span class="status"><?= esc(ucfirst($order['status'])) ?></span></div>
    </div>

    <!-- Address Details -->
    <div class="address-box">
      <strong>Shipping To:</strong><br>
      <?= esc($shippingAddress['name']) ?><br>
      <?= esc($shippingAddress['address']) ?>,<br>
      <?= esc($shippingAddress['city']) ?>, <?= esc($shippingAddress['zip']) ?><br>
      <?= esc($shippingAddress['country']) ?>
    </div>

    <!-- Product List -->
    <?php if (!empty($order['items'])): ?>
      <?php foreach ($order['items'] as $item): ?>
        <div class="product">
          <img src="<?= base_url('uploads/products/' . $item['product_image']) ?>" alt="Product Image">
          <div class="product-details">
            <h4><?= esc($item['product_name']) ?></h4>
            <p>Qty: <?= esc($item['pcs']) ?> | <?= esc($item['variant']) ?></p>
            <p>Price: ?<?= number_format($item['price'], 2) ?></p>
          </div>
          <div class="product-actions">
            <form action="<?= site_url('return-request') ?>" method="post">
              <input type="hidden" name="orderid" value="<?= $order['orderid'] ?>">
              <input type="hidden" name="productid" value="<?= $item['productid'] ?>">
              <button type="submit">Return</button>
            </form>
            <button>Buy Again</button>
          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p>No items found in this order.</p>
    <?php endif; ?>

  </div>

</body>
</html>
